/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import com.google.common.base.Function;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.actions.KeyBindingUtils;
import docking.widgets.EmptyBorderButton;
import docking.widgets.PopupWindow;
import docking.widgets.label.GIconLabel;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Caching;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.graph.VisualGraph;
import ghidra.graph.event.VisualGraphChangeListener;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.GraphSatelliteListener;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.PathHighlightMode;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphLayeredPaneButton;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.VisualEdgeRenderer;
import ghidra.graph.viewer.edge.VisualGraphEdgeSatelliteRenderer;
import ghidra.graph.viewer.edge.VisualGraphEdgeStrokeTransformer;
import ghidra.graph.viewer.edge.VisualGraphPathHighlighter;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.event.mouse.VisualGraphHoverMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphPluggableGraphMouse;
import ghidra.graph.viewer.event.picking.GPickedState;
import ghidra.graph.viewer.event.picking.PickListener;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.options.ViewRestoreOption;
import ghidra.graph.viewer.options.VisualGraphOptions;
import ghidra.graph.viewer.satellite.CachingSatelliteGraphViewer;
import ghidra.graph.viewer.shape.VisualGraphShapePickSupport;
import ghidra.graph.viewer.vertex.VertexClickListener;
import ghidra.graph.viewer.vertex.VertexFocusListener;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.graph.viewer.vertex.VisualVertexRenderer;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import help.HelpService;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import resources.Icons;
import util.CollectionUtils;

public class GraphComponent<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>> {
    private static final double PARENT_TO_SATELLITE_RATIO = 4.0;
    private static final int MINIMUM_SATELLITE_WIDTH = 150;
    private static final int REALLY_BIG_GRAPH_VERTEX_COUNT = 500;
    private static final Integer PRIMARY_VIEWER_LAYER = 100;
    private static final Integer SATELLITE_PROVIDER_BUTTON_LAYER = 199;
    private static final Integer SATELLITE_VIEWER_LAYER = 200;
    private static final Integer STALE_GRAPH_VIEW_LAYER = 300;
    private static final Icon LARGE_SATELLITE_ICON = new GIcon("icon.graph.satellite.large");
    private JPanel staleGraphViewPanel;
    private MessagePaintable messagePaintable = new MessagePaintable();
    protected GPickedState<V> gPickedState;
    private Optional<VertexFocusListener<V>> vertexFocusListener = Optional.empty();
    private Optional<VertexClickListener<V, E>> vertexClickListener = Optional.empty();
    private JPanel mainPanel;
    private JLayeredPane layeredPane;
    protected G graph;
    private GraphChangeListener graphChangeListener = new GraphChangeListener();
    private VertexPickingListener vertexPickingListener;
    protected GraphViewer<V, E> primaryViewer;
    protected SatelliteGraphViewer<V, E> satelliteViewer;
    private Optional<GraphSatelliteListener> satelliteListener = Optional.empty();
    private JPanel undockedSatellitePanel;
    private JButton showUndockedSatelliteButton;
    private LayoutListener<V, E> layoutListener = new PrimaryLayoutListener();
    private boolean isUninitialized = true;
    private GraphPerspectiveInfo<V, E> graphPerspectiveInfo;
    private VisualGraphPluggableGraphMouse<V, E> primaryGraphMouse;
    private VisualGraphPluggableGraphMouse<V, E> satelliteGraphMouse;
    private Dimension lastSize;
    protected VisualGraphOptions vgOptions = new VisualGraphOptions();
    private SatellitePosition dockedSatellitePosition = SatellitePosition.UPPER_RIGHT;

    public GraphComponent(G graph) {
        this.setGraph(graph);
        this.build();
    }

    protected GraphComponent() {
    }

    protected void setGraph(G g) {
        this.graph = (VisualGraph)Objects.requireNonNull(g);
    }

    protected void build() {
        this.graph.addGraphChangeListener(this.graphChangeListener);
        VisualGraphLayout<V, E> layout = this.buildLayout();
        Dimension mainViewerSize = new Dimension(4000, 4000);
        this.primaryViewer = this.buildPrimaryGraphViewer(layout, mainViewerSize);
        this.decoratePrimaryViewer(this.primaryViewer, layout);
        Dimension satelliteSize = new Dimension(300, 300);
        this.satelliteViewer = this.buildSatelliteViewer(this.primaryViewer, layout, satelliteSize);
        this.decorateSatelliteViewer(this.satelliteViewer, layout);
        VisualGraphViewUpdater<V, E> updater = this.primaryViewer.getViewUpdater();
        updater.setSatelliteViewer(this.satelliteViewer);
        this.staleGraphViewPanel = this.buildStaleLayoutPanel();
        this.primaryGraphMouse.prepend((GraphMousePlugin)new VisualGraphHoverMousePlugin<V, E>(this, this.primaryViewer, this.satelliteViewer));
        this.satelliteGraphMouse.prepend((GraphMousePlugin)new VisualGraphHoverMousePlugin<V, E>(this, this.satelliteViewer, this.primaryViewer));
        this.primaryGraphMouse.prepend((GraphMousePlugin)new VertexClickMousePlugin());
        this.createGUIComponents(this.primaryViewer, this.satelliteViewer);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.primaryViewer));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.satelliteViewer));
    }

    protected GraphViewer<V, E> createPrimaryGraphViewer(VisualGraphLayout<V, E> layout, Dimension viewerSize) {
        GraphViewer<V, E> viewer = new GraphViewer<V, E>(layout, viewerSize);
        viewer.setGraphOptions(this.vgOptions);
        return viewer;
    }

    private GraphViewer<V, E> buildPrimaryGraphViewer(VisualGraphLayout<V, E> layout, Dimension viewerSize) {
        GraphViewer viewer = this.createPrimaryGraphViewer(layout, viewerSize);
        viewer.setViewerInitializedListener(v -> this.viewerInitialized((VisualizationViewer<V, E>)v));
        this.primaryGraphMouse = viewer.getGraphMouse();
        viewer.setPickSupport((GraphElementAccessor)new VisualGraphShapePickSupport<V, E>(viewer));
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.addChangeListener(event -> GraphViewerUtils.adjustEdgePickSizeForZoom(viewer));
        this.gPickedState = viewer.getGPickedVertexState();
        this.vertexPickingListener = new VertexPickingListener(this.graph);
        this.gPickedState.addPickingListener(this.vertexPickingListener);
        viewer.addKeyListener(new KeyForwardingKeyAdapter(this, this.graph, viewer));
        this.adjustPickSupport(viewer);
        viewer.addPostRenderPaintable(this.messagePaintable);
        return viewer;
    }

    protected void decoratePrimaryViewer(GraphViewer<V, E> viewer, VisualGraphLayout<V, E> layout) {
        Renderer renderer = viewer.getRenderer();
        BasicEdgeRenderer<V, E> edgeRenderer = layout.getEdgeRenderer();
        renderer.setEdgeRenderer(edgeRenderer);
        RenderContext renderContext = viewer.getRenderContext();
        GColor drawColor = new GColor("color.visualgraph.view.primary.edge.draw");
        GColor focusedColor = new GColor("color.visualgraph.view.primary.edge.focused");
        GColor selectedColor = new GColor("color.visualgraph.view.primary.edge.selected");
        GColor hoveredColor = new GColor("color.visualgraph.view.primary.edge.hovered");
        if (edgeRenderer instanceof VisualEdgeRenderer) {
            VisualEdgeRenderer visualEdgeRenderer = (VisualEdgeRenderer)renderer.getEdgeRenderer();
            visualEdgeRenderer.setDrawColorTransformer(e -> drawColor);
            visualEdgeRenderer.setFocusedColorTransformer(e -> focusedColor);
            visualEdgeRenderer.setSelectedColorTransformer(e -> selectedColor);
            visualEdgeRenderer.setHoveredColorTransformer(e -> hoveredColor);
        } else {
            Function edgeColorTransformer = e -> e.isSelected() ? selectedColor : drawColor;
            renderContext.setEdgeDrawPaintTransformer(edgeColorTransformer);
            renderContext.setArrowDrawPaintTransformer(edgeColorTransformer);
            renderContext.setArrowFillPaintTransformer(edgeColorTransformer);
        }
        VisualVertexRenderer vertexRenderer = new VisualVertexRenderer();
        renderer.setVertexRenderer(vertexRenderer);
        PickedState pickedVertexState = viewer.getPickedVertexState();
        vertexRenderer.setVertexFillPaintTransformer(new PickableVertexPaintTransformer((PickedInfo)pickedVertexState, (Paint)GThemeDefaults.Colors.Palette.WHITE, (Paint)GThemeDefaults.Colors.Palette.YELLOW));
        PickedState pickedEdgeState = viewer.getPickedEdgeState();
        renderContext.setEdgeStrokeTransformer(new VisualGraphEdgeStrokeTransformer(pickedEdgeState, 3));
        pickedEdgeState.addItemListener((ItemListener)new EdgePickingListener(this));
        Function<E, Shape> edgeTransformer = layout.getEdgeShapeTransformer(renderContext);
        renderContext.setEdgeShapeTransformer(edgeTransformer);
        renderContext.setArrowPlacementTolerance(5.0f);
        renderContext.setVertexShapeTransformer(new VisualGraphVertexShapeTransformer());
    }

    protected SatelliteGraphViewer<V, E> createSatelliteGraphViewer(GraphViewer<V, E> masterViewer, Dimension viewerSize) {
        SatelliteGraphViewer viewer = this.isReallyBigData() ? new CachingSatelliteGraphViewer<V, E>(masterViewer, viewerSize) : new SatelliteGraphViewer<V, E>(masterViewer, viewerSize);
        return viewer;
    }

    private SatelliteGraphViewer<V, E> buildSatelliteViewer(GraphViewer<V, E> masterViewer, VisualGraphLayout<V, E> layout, Dimension viewerSize) {
        SatelliteGraphViewer<V, E> viewer = this.createSatelliteGraphViewer(masterViewer, viewerSize);
        viewer.setGraphOptions(this.vgOptions);
        viewer.setMinimumSize(viewerSize);
        viewer.setMaximumSize(viewerSize);
        this.satelliteGraphMouse = viewer.getGraphMouse();
        return viewer;
    }

    protected void decorateSatelliteViewer(SatelliteGraphViewer<V, E> viewer, VisualGraphLayout<V, E> layout) {
        RenderContext renderContext = viewer.getRenderContext();
        Renderer renderer = viewer.getRenderer();
        Renderer.Vertex<V, E> vertexRenderer = viewer.getPreferredVertexRenderer();
        renderContext.setVertexFillPaintTransformer(v -> new GColor("color.bg.visualgraph.satellite.vertex"));
        renderer.setVertexRenderer(vertexRenderer);
        VisualGraphEdgeSatelliteRenderer visualEdgeRenderer = new VisualGraphEdgeSatelliteRenderer((VisualEdgeRenderer)layout.getEdgeRenderer());
        renderer.setEdgeRenderer(visualEdgeRenderer);
        visualEdgeRenderer.setDrawColorTransformer(e -> new GColor("color.visualgraph.view.satellite.edge.draw"));
        visualEdgeRenderer.setFocusedColorTransformer(e -> new GColor("color.visualgraph.view.satellite.edge.focused"));
        visualEdgeRenderer.setSelectedColorTransformer(e -> new GColor("color.visualgraph.view.satellite.edge.selected"));
        visualEdgeRenderer.setHoveredColorTransformer(e -> new GColor("color.visualgraph.view.satellite.edge.hovered"));
        Function<E, Shape> edgeTransformer = layout.getEdgeShapeTransformer(renderContext);
        renderContext.setEdgeShapeTransformer(edgeTransformer);
        renderContext.setVertexShapeTransformer(new VisualGraphVertexShapeTransformer());
        viewer.setVertexToolTipTransformer((Function)new ToStringLabeller());
    }

    private void createGUIComponents(VisualizationViewer<V, E> viewer, SatelliteGraphViewer<V, E> satellite) {
        this.installCommonListeners(viewer, (VisualizationViewer<V, E>)satellite);
        this.mainPanel = new JPanel(new BorderLayout());
        this.layeredPane = new JLayeredPane(){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                Rectangle bounds = GraphComponent.this.primaryViewer.getBounds();
                Dimension parentSize = GraphComponent.this.mainPanel.getSize();
                if (bounds.width == parentSize.width && bounds.height == parentSize.height) {
                    return;
                }
                GraphComponent.this.updateLayeredPaneComponentsForSizeChange();
            }
        };
        this.layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (GraphComponent.this.layeredPane.getSize().equals(GraphComponent.this.lastSize)) {
                    return;
                }
                GraphComponent.this.updateLayeredPaneComponentsForSizeChange();
            }
        });
        this.layeredPane.setPreferredSize(new Dimension(400, 400));
        this.layeredPane.add((Component)viewer, PRIMARY_VIEWER_LAYER);
        this.layeredPane.add((Component)((Object)satellite), SATELLITE_VIEWER_LAYER);
        satellite.setDocked(true);
        this.mainPanel.add((Component)this.layeredPane, "Center");
        satellite.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        this.undockedSatellitePanel = new JPanel(new BorderLayout());
        this.undockedSatellitePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (GraphComponent.this.isSatelliteUnDocked()) {
                    VisualGraphViewUpdater viewUpdater = GraphComponent.this.getViewUpdater();
                    viewUpdater.fitGraphToViewerLater(GraphComponent.this.satelliteViewer);
                }
            }
        });
        this.showUndockedSatelliteButton = this.buildShowUndockedProviderButton();
        this.layeredPane.add((Component)this.showUndockedSatelliteButton, SATELLITE_PROVIDER_BUTTON_LAYER);
    }

    private void installCommonListeners(VisualizationViewer<V, E> viewer, VisualizationViewer<V, E> satellite) {
        MouseAdapter hidePopupMouseListener = new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                PopupWindow.hideAllWindows();
            }
        };
        viewer.addMouseListener((MouseListener)hidePopupMouseListener);
        satellite.addMouseListener((MouseListener)hidePopupMouseListener);
        KeyAdapter hidePopupKeyListener = new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    PopupWindow.hideAllWindows();
                    DockingUtils.hideTipWindow();
                }
            }
        };
        viewer.addKeyListener((KeyListener)hidePopupKeyListener);
        satellite.addKeyListener((KeyListener)hidePopupKeyListener);
    }

    private EmptyBorderButton buildShowUndockedProviderButton() {
        String tooltip = "Bring satellite view to the front";
        Icon icon = LARGE_SATELLITE_ICON;
        GIconLabel iconLabel = new GIconLabel(icon);
        iconLabel.setOpaque(false);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        iconLabel.setToolTipText(tooltip);
        VisualGraphLayeredPaneButton button = new VisualGraphLayeredPaneButton(icon);
        button.setName("show.satellite.button");
        button.addActionListener(e -> this.setSatelliteVisible(true));
        button.setOpaque(false);
        button.setToolTipText(tooltip);
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)button, new HelpLocation("VisualGraph", "Satellite_View_Dock"));
        return button;
    }

    private JPanel buildStaleLayoutPanel() {
        JPanel mainStalePanel = new JPanel(new BorderLayout()){

            @Override
            public boolean isShowing() {
                return true;
            }
        };
        mainStalePanel.setOpaque(false);
        String tooltip = HTMLUtilities.toWrappedHTML((String)"The block model of the function for this graph has changed.  Press the relayout button to refresh the layout.\n\n") + "<b>Note: </b>You can edit the graph options to have the graph update automatically.";
        Icon icon = Icons.REFRESH_ICON;
        GIconLabel iconLabel = new GIconLabel(icon);
        iconLabel.setOpaque(false);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        iconLabel.setToolTipText(tooltip);
        VisualGraphLayeredPaneButton refreshButton = new VisualGraphLayeredPaneButton(icon);
        refreshButton.setName("refresh.button");
        refreshButton.addActionListener(e -> this.refreshCurrentLayout());
        refreshButton.setOpaque(false);
        refreshButton.setToolTipText(tooltip);
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)refreshButton, new HelpLocation("FunctionGraphPlugin", "Stale_Graph"));
        mainStalePanel.add((Component)((Object)refreshButton), "West");
        return mainStalePanel;
    }

    private VisualGraphLayout<V, E> buildLayout() {
        VisualGraphLayout<V, E> layout = this.graph.getLayout();
        if (layout == null) {
            throw new AssertException("Graph should have had a layout applied before rendering.  Make sure the layout has been created and that it is returned from VisualGraph.getLayout()");
        }
        layout.addLayoutListener(this.layoutListener);
        return layout;
    }

    private void adjustPickSupport(VisualizationViewer<V, E> viewer) {
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (!(pickSupport instanceof ShapePickSupport)) {
            return;
        }
        ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
        shapePickSupport.setStyle(ShapePickSupport.Style.HIGHEST);
    }

    protected boolean isReallyBigData() {
        return this.graph.getVertices().size() > 500;
    }

    public void setVertexFocusListener(VertexFocusListener<V> l) {
        this.vertexFocusListener = Optional.ofNullable(l);
    }

    public void setVertexClickListener(VertexClickListener<V, E> l) {
        this.vertexClickListener = Optional.ofNullable(l);
    }

    public void setGraphOptions(VisualGraphOptions options) {
        this.vgOptions = options;
        if (this.primaryViewer != null) {
            this.primaryViewer.setGraphOptions(options);
        }
        if (this.satelliteViewer != null) {
            this.satelliteViewer.setGraphOptions(options);
        }
    }

    public VisualGraphOptions getGraphOptions() {
        return this.vgOptions;
    }

    public boolean isUninitialized() {
        return this.isUninitialized;
    }

    public void setGraphViewStale(boolean isStale) {
        this.layeredPane.remove(this.staleGraphViewPanel);
        String message = null;
        if (isStale) {
            this.layeredPane.add((Component)this.staleGraphViewPanel, STALE_GRAPH_VIEW_LAYER);
            message = "Graph is stale";
        }
        this.setStatusMessage(message);
        this.layeredPane.repaint();
    }

    public boolean isGraphViewStale() {
        Component[] comps = this.layeredPane.getComponentsInLayer(STALE_GRAPH_VIEW_LAYER);
        return comps.length != 0;
    }

    public void setStatusMessage(String message) {
        this.messagePaintable.setMessage(message);
        this.primaryViewer.repaint();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void optionsChanged() {
        this.primaryViewer.optionsChanged();
        this.satelliteViewer.optionsChanged();
    }

    public void repaint() {
        this.mainPanel.repaint();
    }

    public GraphViewer<V, E> getPrimaryViewer() {
        return this.primaryViewer;
    }

    public SatelliteGraphViewer<V, E> getSatelliteViewer() {
        return this.satelliteViewer;
    }

    public VisualGraphViewUpdater<V, E> getViewUpdater() {
        return this.primaryViewer.getViewUpdater();
    }

    public Rectangle getSatelliteBounds() {
        if (!this.isSatelliteShowing()) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.satelliteViewer.getBounds();
    }

    private void viewerInitialized(VisualizationViewer<V, E> viewer) {
        this.isUninitialized = false;
        if (this.graphPerspectiveInfo != null) {
            this.applyGraphPerspective(this.graphPerspectiveInfo);
        } else {
            ViewRestoreOption viewOption = this.vgOptions.getViewRestoreOption();
            if (viewOption == ViewRestoreOption.START_FULLY_ZOOMED_IN) {
                this.zoomInCompletely(this.getInitialVertex());
            } else {
                VisualGraphViewUpdater<V, E> viewUpdater = this.getViewUpdater();
                viewUpdater.fitAllGraphsToViewsNow();
            }
        }
        this.twinkleVertex(this.graph.getFocusedVertex());
        this.graphPerspectiveInfo = null;
    }

    protected V getInitialVertex() {
        return this.graph.getFocusedVertex();
    }

    protected void zoomInCompletely(V v) {
        VisualGraphViewUpdater<V, E> viewUpdater = this.getViewUpdater();
        viewUpdater.zoomInCompletely(v);
    }

    public void setGraphPerspective(GraphPerspectiveInfo<V, E> info) {
        if (this.isUninitialized) {
            this.graphPerspectiveInfo = info;
        } else {
            this.applyGraphPerspective(info);
        }
    }

    private void applyGraphPerspective(GraphPerspectiveInfo<V, E> graphInfo) {
        VisualGraphViewUpdater<V, E> viewUpdater = this.getViewUpdater();
        viewUpdater.setGraphPerspective(graphInfo);
    }

    public void setVertexFocused(V vertex) {
        if (!vertex.isFocused()) {
            this.gPickedState.pickToActivate(vertex);
        } else {
            this.gPickedState.pickToSync(vertex);
        }
    }

    public void setVerticesSelected(Collection<V> vertices) {
        this.gPickedState.clear();
        for (VisualVertex v : vertices) {
            this.gPickedState.pick(v, true);
        }
    }

    public void twinkleVertex(V twinkleVertex) {
        if (twinkleVertex == null) {
            return;
        }
        VisualGraphViewUpdater<V, E> viewUpdater = this.getViewUpdater();
        viewUpdater.twinkeVertex(twinkleVertex);
    }

    public boolean isSatelliteComponent(Component c) {
        return c == this.satelliteViewer;
    }

    protected JComponent getSatelliteContentComponent() {
        return this.undockedSatellitePanel;
    }

    private void updateSatellite(boolean docked, boolean visible) {
        this.layeredPane.remove((Component)((Object)this.satelliteViewer));
        this.undockedSatellitePanel.remove((Component)((Object)this.satelliteViewer));
        if (visible) {
            if (docked) {
                this.layeredPane.add((Component)((Object)this.satelliteViewer), SATELLITE_VIEWER_LAYER);
            } else {
                this.undockedSatellitePanel.add((Component)((Object)this.satelliteViewer));
            }
        }
        this.satelliteViewer.setDocked(docked);
        this.updateLayeredPaneComponentsSizes(true);
        this.layeredPane.repaint();
        this.undockedSatellitePanel.repaint();
        this.satelliteListener.ifPresent(l -> l.satelliteVisibilityChanged(docked, visible));
    }

    void setSatelliteLisetener(GraphSatelliteListener l) {
        this.satelliteListener = Optional.ofNullable(l);
    }

    void setInitialSatelliteState(boolean visible, boolean docked) {
        this.updateSatellite(docked, visible);
    }

    public void setSatelliteDocked(boolean docked) {
        if (this.isSatelliteDocked() == docked) {
            return;
        }
        this.satelliteViewer.setDocked(docked);
        this.updateSatellite(docked, true);
    }

    public SatellitePosition getSatellitePosition() {
        return this.dockedSatellitePosition;
    }

    public void setSatellitePosition(SatellitePosition position) {
        this.dockedSatellitePosition = position;
        this.updateSatellite(this.satelliteViewer.isDocked(), this.isSatelliteShowing());
    }

    public void setSatelliteVisible(boolean visible) {
        if (this.isSatelliteShowing() == visible) {
            if (visible && !this.isSatelliteDocked()) {
                Window w = SwingUtilities.windowForComponent(this.satelliteViewer);
                w.toFront();
            }
            return;
        }
        this.updateSatellite(this.isSatelliteDocked(), visible);
    }

    public boolean isSatelliteShowing() {
        Component[] comps = this.layeredPane.getComponentsInLayer(SATELLITE_VIEWER_LAYER);
        if (comps.length != 0) {
            return true;
        }
        return this.satelliteViewer.isShowing();
    }

    private void updateLayeredPaneComponentsForSizeChange() {
        this.updateLayeredPaneComponentsSizes(false);
    }

    private void updateLayeredPaneComponentsSizes(boolean force) {
        Dimension parentSize = this.mainPanel.getSize();
        this.primaryViewer.setBounds(0, 0, parentSize.width, parentSize.height);
        this.updateSatelliteBounds(parentSize, force);
        Dimension stalePanelSize = this.staleGraphViewPanel.getPreferredSize();
        int x = 0;
        int y = parentSize.height - stalePanelSize.height;
        this.staleGraphViewPanel.setBounds(x, y, stalePanelSize.width, stalePanelSize.height);
        Dimension buttonSize = this.showUndockedSatelliteButton.getPreferredSize();
        Point p = this.getSatellitePosition(parentSize, buttonSize);
        this.showUndockedSatelliteButton.setBounds(p.x, p.y, buttonSize.width, buttonSize.height);
        this.lastSize = new Dimension(parentSize.width, parentSize.height);
    }

    private void updateSatelliteBounds(Dimension parentSize, boolean forceUpdate) {
        if (!this.isSatelliteShowing() && !forceUpdate) {
            return;
        }
        if (!this.isSatelliteUnDocked()) {
            int newWidth;
            Dimension satelliteSize = this.satelliteViewer.getSize();
            satelliteSize.width = newWidth = this.getNewBoundsSize(parentSize, satelliteSize);
            satelliteSize.height = newWidth;
            Point p = this.getSatellitePosition(parentSize, satelliteSize);
            this.satelliteViewer.setBounds(p.x, p.y, satelliteSize.width, satelliteSize.height);
        }
        VisualGraphViewUpdater<V, E> viewUpdater = this.getViewUpdater();
        viewUpdater.fitGraphToViewerNow((VisualizationServer<V, E>)this.satelliteViewer);
    }

    private Point getSatellitePosition(Dimension parentSize, Dimension satelliteSize) {
        int x = parentSize.width - satelliteSize.width;
        int y = parentSize.height - satelliteSize.height;
        switch (this.dockedSatellitePosition.ordinal()) {
            case 2: {
                return new Point(0, y);
            }
            case 0: {
                return new Point(0, 0);
            }
            case 1: {
                return new Point(x, 0);
            }
        }
        return new Point(x, y);
    }

    private int getNewBoundsSize(Dimension parentBounds, Dimension satelliteBounds) {
        double newSatelliteHeight = (double)parentBounds.height / 4.0;
        double newSatelliteWidth = (double)parentBounds.width / 4.0;
        int newValue = (int)Math.round(newSatelliteWidth);
        if (newSatelliteHeight < newSatelliteWidth) {
            newValue = (int)Math.round(newSatelliteHeight);
        }
        return Math.max(150, newValue);
    }

    public boolean isSatelliteDocked() {
        return this.satelliteViewer.isDocked();
    }

    public boolean isSatelliteUnDocked() {
        return !this.satelliteViewer.isDocked();
    }

    public void setPopupsVisible(boolean visible) {
        this.primaryViewer.setPopupsVisible(visible);
    }

    public PathHighlightMode getVertexHoverPathHighlightMode() {
        return this.primaryViewer.getVertexHoverPathHighlightMode();
    }

    public void setVertexHoverPathHighlightMode(PathHighlightMode mode) {
        this.primaryViewer.setVertexHoverPathHighlightMode(mode);
        this.primaryViewer.repaint();
        this.satelliteViewer.repaint();
    }

    public PathHighlightMode getVertexFocusPathHighlightMode() {
        return this.primaryViewer.getVertexFocusPathHighlightMode();
    }

    public void setVertexFocusPathHighlightMode(PathHighlightMode mode) {
        this.primaryViewer.setVertexFocusPathHighlightMode(mode);
        this.primaryViewer.repaint();
        this.satelliteViewer.repaint();
    }

    public RenderContext<V, E> getRenderContext() {
        RenderContext context = this.primaryViewer.getRenderContext();
        return context;
    }

    public G getGraph() {
        return this.graph;
    }

    public VisualGraphPathHighlighter<V, E> getPathHighlighter() {
        return this.primaryViewer.getPathHighlighter();
    }

    protected void refreshCurrentLayout() {
        this.setGraphViewStale(false);
    }

    public void dispose() {
        Layout layout;
        if (this.graph != null) {
            this.graph.removeGraphChangeListener(this.graphChangeListener);
            layout = this.graph.getLayout();
            layout.removeLayoutListener(this.layoutListener);
        }
        if ((layout = this.primaryViewer.getGraphLayout()) instanceof Caching) {
            ((Caching)layout).clear();
        }
        if ((layout = this.satelliteViewer.getGraphLayout()) instanceof Caching) {
            ((Caching)layout).clear();
        }
        this.gPickedState.removePickingListener(this.vertexPickingListener);
        PickedState vertexState = this.primaryViewer.getPickedVertexState();
        vertexState.clear();
        vertexState = this.satelliteViewer.getPickedVertexState();
        vertexState.clear();
        PickedState edgeState = this.primaryViewer.getPickedEdgeState();
        edgeState.clear();
        edgeState = this.primaryViewer.getPickedEdgeState();
        edgeState.clear();
        this.primaryViewer.dispose();
        this.undockedSatellitePanel.removeAll();
        this.undockedSatellitePanel.repaint();
        this.satelliteViewer.removeAll();
        this.primaryGraphMouse.dispose();
        this.satelliteGraphMouse.dispose();
        this.layeredPane.removeAll();
        this.layeredPane = null;
        this.mainPanel.removeAll();
        this.mainPanel = null;
        this.primaryViewer = null;
        this.satelliteViewer = null;
        this.graphPerspectiveInfo = null;
        this.satelliteListener = null;
        this.graph = null;
    }

    private class MessagePaintable
    implements VisualizationServer.Paintable {
        private static final String FONT_ID = "font.graph.component.message";
        private final Color backgroundColor = new GColor("color.bg.visualgraph.message");
        private String message = null;

        private MessagePaintable() {
        }

        public void paint(Graphics g) {
            if (this.message == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), 0.6f));
            Font font = Gui.getFont((String)FONT_ID);
            g.setFont(font);
            Rectangle stringBounds = font.getStringBounds(this.message, g2.getFontRenderContext()).getBounds();
            Rectangle viewerBounds = GraphComponent.this.primaryViewer.getBounds();
            Point viewPosition = viewerBounds.getLocation();
            int bottomY = (int)((double)viewPosition.y + viewerBounds.getHeight());
            int startX = 0;
            int startY = bottomY - 5;
            Color[] colors = new Color[]{this.backgroundColor, GraphComponent.this.primaryViewer.getBackground()};
            int backgroundHeight = stringBounds.height * 3;
            int backgroundWidth = viewerBounds.width;
            int backgroundX = startX;
            int backgroundY = bottomY - backgroundHeight;
            float[] fractions = new float[]{0.0f, 0.95f};
            int upperY = backgroundY;
            LinearGradientPaint bottomToTopGradiant = new LinearGradientPaint(new Point(startX, startY), new Point(startX, upperY), fractions, colors);
            g2.setPaint(bottomToTopGradiant);
            g2.fillRect(backgroundX, upperY, backgroundWidth, backgroundHeight);
            g2.setPaint((Paint)GThemeDefaults.Colors.Palette.BLACK);
            int textX = startX + (GraphComponent.this.isGraphViewStale() ? GraphComponent.this.staleGraphViewPanel.getBounds().width + 5 : 0);
            g2.drawString(this.message, textX, startY);
            g2.setComposite(originalComposite);
        }

        public boolean useTransform() {
            return false;
        }

        void setMessage(String message) {
            this.message = message;
        }
    }

    private class GraphChangeListener
    implements VisualGraphChangeListener<V, E> {
        private GraphChangeListener() {
        }

        @Override
        public void verticesRemoved(Iterable<V> vertices) {
            GraphComponent.this.getPathHighlighter().clearEdgeCache();
            PickedState pickedState = GraphComponent.this.primaryViewer.getPickedVertexState();
            for (VisualVertex v : vertices) {
                pickedState.pick((Object)v, false);
            }
        }

        @Override
        public void verticesAdded(Iterable<V> vertices) {
            GraphComponent.this.getPathHighlighter().clearEdgeCache();
        }

        @Override
        public void edgesAdded(Iterable<E> edges) {
            GraphComponent.this.getPathHighlighter().clearEdgeCache();
        }

        @Override
        public void edgesRemoved(Iterable<E> edges) {
            GraphComponent.this.getPathHighlighter().clearEdgeCache();
        }
    }

    private class PrimaryLayoutListener
    implements LayoutListener<V, E> {
        private PrimaryLayoutListener() {
        }

        @Override
        public void vertexLocationChanged(V v, Point2D newLocation, LayoutListener.ChangeType changeType) {
            if (GraphComponent.this.isUninitialized) {
                return;
            }
            v.setLocation(newLocation);
            if (changeType.isTransitional()) {
                return;
            }
            if (GraphComponent.this.isSatelliteShowing()) {
                VisualGraphViewUpdater viewUpdater = GraphComponent.this.getViewUpdater();
                viewUpdater.fitGraphToViewerLater(GraphComponent.this.satelliteViewer);
            }
            GraphComponent.this.graph.vertexLocationChanged(v, new Point((int)newLocation.getX(), (int)newLocation.getY()), changeType);
        }
    }

    public static enum SatellitePosition {
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }

    private class VertexClickMousePlugin
    extends AbstractGraphMousePlugin
    implements MouseListener,
    VisualGraphMousePlugin<V, E> {
        private V selectedVertex;

        public VertexClickMousePlugin() {
            super(1024);
        }

        public boolean checkModifiers(MouseEvent e) {
            return e.getModifiersEx() == this.modifiers;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.checkModifiers(e)) {
                return;
            }
            if (e.getClickCount() != 2) {
                return;
            }
            if (!this.onVertex(e)) {
                return;
            }
            GraphViewer viewer = this.getGraphViewer(e);
            VertexMouseInfo info = GraphViewerUtils.convertMouseEventToVertexMouseEvent(viewer, e);
            GraphComponent.this.vertexClickListener.ifPresent(l -> {
                if (l.vertexDoubleClicked(this.selectedVertex, info)) {
                    e.consume();
                }
            });
        }

        private boolean onVertex(MouseEvent e) {
            if (!this.checkModifiers(e)) {
                this.selectedVertex = null;
                return false;
            }
            VisualizationViewer vv = this.getViewer(e);
            GraphElementAccessor pickSupport = vv.getPickSupport();
            Layout layout = vv.getGraphLayout();
            if (pickSupport == null) {
                return false;
            }
            Point p = e.getPoint();
            this.selectedVertex = (VisualVertex)pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
            return this.selectedVertex != null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class VertexPickingListener
    implements PickListener<V> {
        private final VisualGraph<V, E> innerClassGraph;

        public VertexPickingListener(VisualGraph<V, E> g) {
            this.innerClassGraph = g;
        }

        @Override
        public void verticesPicked(Set<V> vertices, PickListener.EventSource source) {
            if (vertices.size() == 0) {
                this.innerClassGraph.clearSelectedVertices();
            } else if (vertices.size() == 1) {
                this.focusVertex((VisualVertex)CollectionUtils.any(vertices), source);
            } else {
                this.innerClassGraph.setSelectedVertices(vertices);
            }
            GraphComponent.this.getPathHighlighter().setFocusedVertex(GraphComponent.this.graph.getFocusedVertex());
        }

        private void focusVertex(V vertex, PickListener.EventSource source) {
            this.innerClassGraph.setVertexFocused(vertex, true);
            if (source == PickListener.EventSource.INTERNAL) {
                GraphComponent.this.vertexFocusListener.ifPresent(l -> l.vertexFocused(vertex));
            }
        }
    }

    private class KeyForwardingKeyAdapter
    extends KeyAdapter {
        private final VisualizationViewer<V, E> viewer;
        private final VisualGraph<V, E> innerClassGraph;

        public KeyForwardingKeyAdapter(GraphComponent graphComponent, VisualGraph<V, E> g, VisualizationViewer<V, E> viewer) {
            this.innerClassGraph = g;
            this.viewer = viewer;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object focusedVertex = this.innerClassGraph.getFocusedVertex();
            if (focusedVertex == null) {
                return;
            }
            KeyBindingUtils.retargetEvent((Component)focusedVertex.getComponent(), (KeyEvent)e);
            this.viewer.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Object focusedVertex = this.innerClassGraph.getFocusedVertex();
            if (focusedVertex == null) {
                return;
            }
            KeyBindingUtils.retargetEvent((Component)focusedVertex.getComponent(), (KeyEvent)e);
            this.viewer.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            Object focusedVertex = this.innerClassGraph.getFocusedVertex();
            if (focusedVertex == null) {
                return;
            }
            KeyBindingUtils.retargetEvent((Component)focusedVertex.getComponent(), (KeyEvent)e);
            this.viewer.repaint();
        }
    }

    private class EdgePickingListener
    implements ItemListener {
        private EdgePickingListener(GraphComponent graphComponent) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            VisualEdge edge = (VisualEdge)e.getItem();
            edge.setSelected(e.getStateChange() == 1);
        }
    }
}

