/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PublicSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublic32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractUnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DataSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ReferenceSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.app.util.pdb.pdbapplicator.TypedefSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;
import mdemangler.MDParsableItem;
import mdemangler.object.MDObjectCPP;

public class PdbResearch {
    private static Set<Integer> debugIndexNumbers;
    private static Set<Integer> developerDebugOrderIndexNumbers;

    private static void doNothingSetBreakPointHere() {
    }

    static void initBreakPointRecordNumbers() {
        debugIndexNumbers = new TreeSet<Integer>();
        debugIndexNumbers.add(9715);
    }

    static void checkBreak(int recordNumber) {
        if (debugIndexNumbers.contains(recordNumber)) {
            PdbResearch.doNothingSetBreakPointHere();
        }
    }

    private static void initDeveloperOrderRecordNumbers() {
        developerDebugOrderIndexNumbers = new TreeSet<Integer>();
        developerDebugOrderIndexNumbers.add(9696);
        developerDebugOrderIndexNumbers.add(9697);
        developerDebugOrderIndexNumbers.add(9700);
        developerDebugOrderIndexNumbers.add(9701);
        developerDebugOrderIndexNumbers.add(9704);
        developerDebugOrderIndexNumbers.add(9707);
        developerDebugOrderIndexNumbers.add(9709);
        developerDebugOrderIndexNumbers.add(9714);
        developerDebugOrderIndexNumbers.add(9715);
        developerDebugOrderIndexNumbers.add(9773);
        developerDebugOrderIndexNumbers.add(9774);
        developerDebugOrderIndexNumbers.add(9775);
        developerDebugOrderIndexNumbers.add(9776);
        developerDebugOrderIndexNumbers.add(9777);
        developerDebugOrderIndexNumbers.add(9778);
        developerDebugOrderIndexNumbers.add(9779);
        developerDebugOrderIndexNumbers.add(9780);
        developerDebugOrderIndexNumbers.add(9781);
        developerDebugOrderIndexNumbers.add(9782);
        developerDebugOrderIndexNumbers.add(9783);
        developerDebugOrderIndexNumbers.add(216012);
        developerDebugOrderIndexNumbers.add(216055);
        developerDebugOrderIndexNumbers.add(216058);
    }

    static void developerDebugOrder(DefaultPdbApplicator applicator, TaskMonitor monitor) throws CancelledException, PdbException {
        PdbResearch.initDeveloperOrderRecordNumbers();
        for (int indexNumber : developerDebugOrderIndexNumbers) {
            monitor.checkCancelled();
            PdbResearch.checkBreak(indexNumber);
        }
    }

    static void childWalk(DefaultPdbApplicator applicator, TaskMonitor monitor) throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = applicator.getPdb().getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = applicator.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        GlobalSymbolInformation globalSymbolInformation = debugInfo.getGlobalSymbolInformation();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        monitor.setMessage("PDB: Applying typedefs...");
        monitor.initialize((long)offsets.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        for (long offset : offsets) {
            monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!PdbResearch.childWalkSym(applicator, symbolGroup.getModuleNumber(), iter)) break;
            monitor.incrementProgress(1L);
        }
    }

    private static boolean childWalkSym(DefaultPdbApplicator applicator, int streamNumber, MsSymbolIterator iter) throws PdbException, CancelledException {
        if (!iter.hasNext()) {
            return false;
        }
        AbstractMsSymbol symbol = iter.peek();
        MsSymbolApplier applier = applicator.getSymbolApplier(iter);
        if (applier instanceof TypedefSymbolApplier) {
            TypedefSymbolApplier typedefApplier = (TypedefSymbolApplier)applier;
            RecordNumber typeNumber = typedefApplier.getTypeRecordNumber();
            AbstractMsType type = applicator.getTypeRecord(typeNumber);
            System.out.println("UDT " + typedefApplier.getName() + " depends on " + type.toString());
        } else if (applier instanceof ReferenceSymbolApplier) {
            ReferenceSymbolApplier refSymbolApplier = (ReferenceSymbolApplier)applier;
            MsSymbolIterator refIter = refSymbolApplier.getRefIterFromSymbol();
            if (refIter == null) {
                throw new PdbException("PDB: Referenced Symbol Error - not refIter");
            }
            PdbResearch.childWalkSym(applicator, refIter.getStreamNumber(), refIter);
        } else if (applier instanceof DataSymbolApplier) {
            DataSymbolApplier dataSymbolApplier = (DataSymbolApplier)applier;
            MsTypeApplier typeApplier = dataSymbolApplier.getTypeApplier(symbol);
            PdbResearch.childWalkType(streamNumber, typeApplier);
        } else if (applier instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applier;
            functionSymbolApplier.getFunction();
        } else {
            PdbResearch.doNothingSetBreakPointHere();
        }
        return true;
    }

    private static boolean childWalkType(int moduleNumber, MsTypeApplier applier) {
        PdbResearch.doNothingSetBreakPointHere();
        if (applier instanceof AbstractFunctionTypeApplier) {
            PdbResearch.doNothingSetBreakPointHere();
        }
        return true;
    }

    static void studyDataTypeConflicts(DefaultPdbApplicator applicator, TaskMonitor monitor) throws CancelledException, InvalidInputException {
        DataTypeConflictHandler handler = DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER;
        DataTypeManager dtm = applicator.getDataTypeManager();
        Composite testStruct1 = PdbResearch.createComposite(dtm, "____blah____");
        PointerDataType pointer1 = new PointerDataType((DataType)testStruct1, -1, dtm);
        FunctionDefinitionDataType fn1 = new FunctionDefinitionDataType(CategoryPath.ROOT, "____fn1____", dtm);
        fn1.setReturnType((DataType)pointer1);
        fn1.setCallingConvention("__cdecl");
        fn1.setArguments(new ParameterDefinition[0]);
        Composite internalStruct1 = PdbResearch.createComposite(dtm, "____internal____");
        PointerDataType internalPointer1 = new PointerDataType((DataType)internalStruct1, -1, dtm);
        PdbResearch.fillComposite(testStruct1, monitor, (DataType)internalPointer1);
        PdbResearch.fillComposite(internalStruct1, monitor, null);
        Composite testStruct2 = PdbResearch.createComposite(dtm, "____blah____");
        PointerDataType pointer2 = new PointerDataType((DataType)testStruct2, -1, dtm);
        FunctionDefinitionDataType fn2 = new FunctionDefinitionDataType(CategoryPath.ROOT, "____fn2____", dtm);
        fn2.setReturnType((DataType)pointer2);
        fn2.setCallingConvention("__cdecl");
        fn2.setArguments(new ParameterDefinition[0]);
        Composite internalStruct2 = PdbResearch.createComposite(dtm, "____internal____");
        PointerDataType internalPointer2 = new PointerDataType((DataType)internalStruct2, -1, dtm);
        PdbResearch.fillComposite(testStruct2, monitor, (DataType)internalPointer2);
        DataType t1 = dtm.resolve((DataType)testStruct1, handler);
        DataType f1 = dtm.resolve((DataType)fn1, handler);
        DataType t2 = dtm.resolve((DataType)testStruct2, handler);
        DataType f2 = dtm.resolve((DataType)fn2, handler);
        PdbLog.message(t1.toString());
        PdbLog.message(f1.toString());
        PdbLog.message(t2.toString());
        PdbLog.message(f2.toString());
    }

    private static Composite createComposite(DataTypeManager dtm, String name) {
        StructureDataType composite = new StructureDataType(CategoryPath.ROOT, name, 0, dtm);
        return composite;
    }

    private static void fillComposite(Composite composite, TaskMonitor monitor, DataType extra) throws CancelledException {
        ArrayList<DefaultTestPdbMember> members = new ArrayList<DefaultTestPdbMember>();
        int size = 8;
        IntegerDataType intxy = IntegerDataType.dataType;
        DefaultTestPdbMember member = new DefaultTestPdbMember("x", (DataType)intxy, 0);
        members.add(member);
        member = new DefaultTestPdbMember("y", (DataType)intxy, 4);
        members.add(member);
        if (extra != null) {
            member = new DefaultTestPdbMember("z", extra, 8);
            members.add(member);
            size += extra.getLength();
        }
        if (!DefaultCompositeMember.applyDataTypeMembers(composite, false, false, size, members, msg -> PdbResearch.reconstructionWarn(msg), monitor)) {
            ((Structure)composite).deleteAll();
        }
    }

    private static void reconstructionWarn(String msg) {
        Msg.warn(null, (Object)msg);
    }

    static void studyAggregateSymbols(DefaultPdbApplicator applicator, TaskMonitor monitor) throws CancelledException, PdbException {
        HashMap<Address, List<Stuff>> mapByAddress = new HashMap<Address, List<Stuff>>();
        PdbResearch.processPublicSymbols(applicator, mapByAddress, monitor);
        PdbResearch.processGlobalSymbols(applicator, mapByAddress, monitor);
        PdbResearch.processModuleSymbols(applicator, mapByAddress, monitor);
        PdbResearch.dumpMap(mapByAddress);
    }

    private static void processPublicSymbols(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, TaskMonitor monitor) throws CancelledException, PdbException {
        AbstractPdb pdb = applicator.getPdb();
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = applicator.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        PublicSymbolInformation publicSymbolInformation = debugInfo.getPublicSymbolInformation();
        List<Long> offsets = publicSymbolInformation.getModifiedHashRecordSymbolOffsets();
        monitor.setMessage("PDB: Applying " + offsets.size() + " public symbol components...");
        monitor.initialize((long)offsets.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        for (long offset : offsets) {
            monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            PdbResearch.processPublicSymbol(applicator, map, symbol);
            PdbResearch.processProcedureSymbol(applicator, map, symbol);
            monitor.incrementProgress(1L);
        }
    }

    private static void processGlobalSymbols(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, TaskMonitor monitor) throws CancelledException, PdbException {
        AbstractPdb pdb = applicator.getPdb();
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = applicator.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        GlobalSymbolInformation globalSymbolInformation = debugInfo.getGlobalSymbolInformation();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        monitor.setMessage("PDB: Applying global symbols...");
        monitor.initialize((long)offsets.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        for (long offset : offsets) {
            monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            PdbResearch.processPublicSymbol(applicator, map, symbol);
            PdbResearch.processProcedureSymbol(applicator, map, symbol);
            monitor.incrementProgress(1L);
        }
    }

    private static void processModuleSymbols(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, TaskMonitor monitor) throws CancelledException, PdbException {
        SymbolGroup symbolGroup;
        int moduleNumber;
        AbstractPdb pdb = applicator.getPdb();
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        int totalCount = 0;
        int num = debugInfo.getNumModules();
        for (moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            monitor.checkCancelled();
            symbolGroup = applicator.getSymbolGroupForModule(moduleNumber);
            if (symbolGroup == null) continue;
            totalCount += symbolGroup.size();
        }
        monitor.setMessage("PDB: Applying " + totalCount + " module symbol components...");
        monitor.initialize((long)totalCount);
        for (moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            monitor.checkCancelled();
            symbolGroup = applicator.getSymbolGroupForModule(moduleNumber);
            if (symbolGroup == null) continue;
            MsSymbolIterator iter = symbolGroup.getSymbolIterator();
            PdbResearch.processSymbolGroup(applicator, map, moduleNumber, iter, monitor);
        }
    }

    private static void processSymbolGroup(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, int moduleNumber, MsSymbolIterator iter, TaskMonitor monitor) throws CancelledException {
        iter.initGet();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            AbstractMsSymbol symbol = iter.next();
            if (symbol != null) {
                PdbResearch.processPublicSymbol(applicator, map, symbol);
                PdbResearch.processProcedureSymbol(applicator, map, symbol);
            }
            monitor.incrementProgress(1L);
        }
    }

    private static void processPublicSymbol(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, AbstractMsSymbol symbol) {
        if (!(symbol instanceof AbstractPublicMsSymbol)) {
            return;
        }
        if (symbol instanceof AbstractPublic32MsSymbol && !((AbstractPublic32MsSymbol)symbol).isFunction()) {
            return;
        }
        String name = ((AbstractPublicMsSymbol)symbol).getName();
        Address address = applicator.getAddress((AbstractPublicMsSymbol)symbol);
        if (applicator.isInvalidAddress(address, name)) {
            return;
        }
        String demangledName = PdbResearch.getDemangledQualifiedName(name);
        Stuff stuff = demangledName != null ? new Stuff(symbol, demangledName, What.PUBLIC_QUAL_FROM_MANGLED) : new Stuff(symbol, name, What.PUBLIC_NOT_MANGLED);
        PdbResearch.addStuff(map, address, stuff);
    }

    private static void processProcedureSymbol(DefaultPdbApplicator applicator, Map<Address, List<Stuff>> map, AbstractMsSymbol symbol) {
        if (symbol instanceof AbstractProcedureMsSymbol) {
            String name = ((AbstractProcedureMsSymbol)symbol).getName();
            Address address = applicator.getAddress((AbstractProcedureMsSymbol)symbol);
            if (applicator.isInvalidAddress(address, name)) {
                return;
            }
            Stuff stuff = new Stuff(symbol, name, What.GLOBAL);
            PdbResearch.addStuff(map, address, stuff);
        }
    }

    private static void addStuff(Map<Address, List<Stuff>> map, Address address, Stuff stuff) {
        List<Stuff> list = map.get(address);
        if (list == null) {
            list = new ArrayList<Stuff>();
            map.put(address, list);
        }
        list.add(stuff);
    }

    private static void dumpMap(Map<Address, List<Stuff>> map) {
        for (Map.Entry<Address, List<Stuff>> entry : map.entrySet()) {
            Address address = entry.getKey();
            List<Stuff> list = entry.getValue();
            for (Stuff stuff : list) {
                PdbLog.message(String.valueOf(address) + " " + String.valueOf((Object)stuff.getWhat()) + " " + stuff.getName());
            }
        }
    }

    private static String getDemangledQualifiedName(String mangledString) {
        if (mangledString.charAt(0) != '?') {
            return null;
        }
        MDMangGhidra demangler = new MDMangGhidra();
        demangler.setMangledSymbol(mangledString);
        demangler.setErrorOnRemainingChars(true);
        try {
            MDParsableItem parsableItem = demangler.demangle();
            if (parsableItem instanceof MDObjectCPP) {
                MDObjectCPP mdObject = (MDObjectCPP)parsableItem;
                return mdObject.getQualifiedName().toString();
            }
            return parsableItem.toString();
        }
        catch (MDException e) {
            Msg.info(null, (Object)e.getMessage());
            return null;
        }
    }

    static void studyCompositeForwardReferenceAndDefinition(AbstractPdb pdb, TaskMonitor monitor) throws CancelledException {
        int indexNumber;
        int indexLimit = pdb.getTypeProgramInterface().getTypeIndexMaxExclusive();
        int num = indexLimit - indexNumber;
        boolean[] covered = new boolean[indexLimit];
        monitor.initialize((long)num);
        monitor.setMessage("Study: NAMES_START " + (indexLimit - indexNumber));
        PdbLog.message("STUDY_START: studyCompositeFwdRefDef");
        for (indexNumber = pdb.getTypeProgramInterface().getTypeIndexMin(); indexNumber < indexLimit; ++indexNumber) {
            monitor.checkCancelled();
            if (!covered[indexNumber]) {
                AbstractMsType type = pdb.getTypeRecord(RecordNumber.typeRecordNumber(indexNumber));
                covered[indexNumber] = true;
                String name = PdbResearch.getSpecialRecordStart(type);
                if (name != null) {
                    MsProperty p;
                    int c;
                    boolean isForwardReference = false;
                    HashMap<Integer, Set<Object>> map = new HashMap<Integer, Set<Object>>();
                    if (type instanceof AbstractCompositeMsType) {
                        AbstractCompositeMsType compType = (AbstractCompositeMsType)type;
                        c = compType.getNumElements();
                        p = compType.getMsProperty();
                        isForwardReference = p.isForwardReference();
                        if (c == 0 && !isForwardReference) {
                            PdbResearch.doNothingSetBreakPointHere();
                            if (compType.getFieldDescriptorListRecordNumber() == RecordNumber.NO_TYPE) {
                                PdbResearch.doNothingSetBreakPointHere();
                            }
                        } else if (c != 0 && isForwardReference) {
                            PdbResearch.doNothingSetBreakPointHere();
                        }
                    } else {
                        AbstractEnumMsType enumType = (AbstractEnumMsType)type;
                        c = 0;
                    }
                    String ps = type.toString();
                    Set<String> set = new HashSet<String>();
                    set.add(ps);
                    map.put(c, set);
                    PdbLog.message("----------\n" + name + "\n" + c + (isForwardReference ? " fwdref" : ""));
                    for (int innerIndexNumber = indexNumber + 1; innerIndexNumber < indexLimit; ++innerIndexNumber) {
                        AbstractMsType innerType;
                        String innerName;
                        monitor.checkCancelled();
                        if (covered[innerIndexNumber] || !name.equals(innerName = PdbResearch.getSpecialRecordStart(innerType = pdb.getTypeRecord(RecordNumber.typeRecordNumber(innerIndexNumber))))) continue;
                        covered[innerIndexNumber] = true;
                        isForwardReference = false;
                        if (type instanceof AbstractCompositeMsType) {
                            AbstractCompositeMsType compType = (AbstractCompositeMsType)innerType;
                            c = compType.getNumElements();
                            p = compType.getMsProperty();
                            isForwardReference = p.isForwardReference();
                            if (c == 0 && !isForwardReference) {
                                if (compType.getFieldDescriptorListRecordNumber() == RecordNumber.NO_TYPE) {
                                    PdbResearch.doNothingSetBreakPointHere();
                                }
                            } else if (c != 0 && isForwardReference) {
                                PdbResearch.doNothingSetBreakPointHere();
                            }
                        } else {
                            AbstractEnumMsType enumType = (AbstractEnumMsType)type;
                            c = 0;
                        }
                        String psi = innerType.toString();
                        set = (Set)map.get(c);
                        String message = "";
                        if (set == null) {
                            set = new HashSet();
                            map.put(c, set);
                            set.add(psi);
                        } else if (!set.contains(psi)) {
                            message = " <-- conflict";
                            set.add(psi);
                        } else {
                            message = " <-- repeat";
                        }
                        PdbLog.message(c + (isForwardReference ? " fwdref" : "") + message);
                        if (c != 0 || !isForwardReference) continue;
                        PdbLog.message("Orig: " + ps + "\nNew: " + psi);
                    }
                }
            }
            monitor.incrementProgress(1L);
        }
        PdbLog.message("STUDY_END: studyCompositeFwdRefDef");
    }

    private static String getSpecialRecordStart(AbstractMsType type) {
        String name;
        if (!(type instanceof AbstractCompositeMsType) && !(type instanceof AbstractEnumMsType)) {
            return null;
        }
        if (type instanceof AbstractCompositeMsType) {
            AbstractCompositeMsType compType = (AbstractCompositeMsType)type;
            name = compType instanceof AbstractClassMsType ? "class " + compType.getName() : (compType instanceof AbstractStructureMsType ? "struct " + compType.getName() : (compType instanceof AbstractUnionMsType ? "union " + compType.getName() : "interface " + compType.getName()));
        } else {
            AbstractEnumMsType enumType = (AbstractEnumMsType)type;
            name = "enum " + enumType.getName();
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    static void study1(AbstractPdb pdb, TaskMonitor monitor) throws CancelledException {
        int indexNumber;
        int indexLimit = pdb.getTypeProgramInterface().getTypeIndexMaxExclusive();
        HashSet<CallSite> uniqueNames = new HashSet<CallSite>();
        ArrayList<CallSite> orderedNames = new ArrayList<CallSite>();
        ArrayList<void> orderedRecords = new ArrayList<void>();
        monitor.initialize((long)(indexLimit - indexNumber));
        monitor.setMessage("Study: NAMES_START");
        for (indexNumber = pdb.getTypeProgramInterface().getTypeIndexMin(); indexNumber < indexLimit; ++indexNumber) {
            monitor.checkCancelled();
            AbstractMsType type = pdb.getTypeRecord(RecordNumber.typeRecordNumber(indexNumber));
            if (type instanceof AbstractCompositeMsType || type instanceof AbstractEnumMsType) {
                void var8_8;
                String name;
                if (type instanceof AbstractCompositeMsType) {
                    AbstractCompositeMsType compType = (AbstractCompositeMsType)type;
                    name = compType instanceof AbstractClassMsType ? "class " + compType.getName() : (compType instanceof AbstractStructureMsType ? "struct " + compType.getName() : (compType instanceof AbstractUnionMsType ? "union " + compType.getName() : "interface " + compType.getName()));
                    String string = compType.toString();
                } else {
                    AbstractEnumMsType enumType = (AbstractEnumMsType)type;
                    name = "enum " + enumType.getName();
                    String string = enumType.toString();
                }
                if (!uniqueNames.contains(name)) {
                    uniqueNames.add((CallSite)((Object)name));
                    orderedNames.add((CallSite)((Object)name));
                }
                orderedRecords.add(var8_8);
            }
            monitor.incrementProgress(1L);
        }
        System.out.println("DUMP_START");
        monitor.setMessage("Study: DUMP_START");
        monitor.initialize((long)orderedNames.size());
        for (String string : orderedNames) {
            for (String record : orderedRecords) {
                monitor.checkCancelled();
                if (!record.startsWith(string)) continue;
                System.out.println(record);
            }
            System.out.println("----------");
            monitor.incrementProgress(1L);
        }
        System.out.println("DUMP_END");
    }

    private static class DefaultTestPdbMember
    extends PdbMember {
        private DataType dataType;

        DefaultTestPdbMember(String name, DataType dataType, int offset) {
            super(name, dataType.getName(), offset, null);
            this.dataType = dataType;
        }

        @Override
        public String getDataTypeName() {
            return this.dataType.getName();
        }

        @Override
        protected WrappedDataType getDataType() throws CancelledException {
            boolean size;
            if (this.dataType instanceof ArrayDataType && !(size = true)) {
                return new WrappedDataType(this.dataType, true, false);
            }
            return new WrappedDataType(this.dataType, false, false);
        }
    }

    private static class Stuff {
        AbstractMsSymbol symbol;
        String name;
        What what;

        Stuff(AbstractMsSymbol symbol, String name, What what) {
            this.symbol = symbol;
            this.name = name;
            this.what = what;
        }

        AbstractMsSymbol getSymbol() {
            return this.symbol;
        }

        String getName() {
            return this.name;
        }

        What getWhat() {
            return this.what;
        }
    }

    private static enum What {
        PUBLIC_NOT_MANGLED,
        PUBLIC_QUAL_FROM_MANGLED,
        GLOBAL;

    }
}

