/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.gui.GProgressBar;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;

public class GTaskMonitor
implements TaskMonitor,
CancelledListener {
    private GProgressBar progressBar;
    private volatile boolean isCancelled;
    private boolean showProgressValue;
    private volatile String message;
    private volatile long progress;
    private volatile long max;
    private boolean indeterminate;
    private boolean cancelEnabled = true;

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.showProgressValue = showProgressValue;
        if (this.progressBar != null) {
            this.progressBar.setShowProgressValue(showProgressValue);
        }
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.progressBar != null) {
            this.progressBar.setMessage(message);
        }
    }

    public void setProgress(long value) {
        this.progress = value;
        if (this.progressBar != null) {
            this.progressBar.setProgress(value);
        }
    }

    public void initialize(long maxValue) {
        this.max = maxValue;
        this.progress = 0L;
        if (this.progressBar != null) {
            this.progressBar.initialize(maxValue);
        }
    }

    public void setMaximum(long max) {
        this.max = max;
        if (this.progressBar != null) {
            this.progressBar.setMaximum(max);
        }
    }

    public long getMaximum() {
        return this.max;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled) {
            this.setMessage("CANCELLED!");
            throw new CancelledException();
        }
    }

    public void incrementProgress(long incrementAmount) {
        this.progress += incrementAmount;
        if (this.progressBar != null) {
            this.progressBar.incrementProgress(incrementAmount);
        }
    }

    public long getProgress() {
        return this.progress;
    }

    public void cancel() {
        if (this.cancelEnabled) {
            this.isCancelled = true;
        }
    }

    public void addCancelledListener(CancelledListener mcl) {
        throw new UnsupportedOperationException();
    }

    public void removeCancelledListener(CancelledListener mcl) {
        throw new UnsupportedOperationException();
    }

    public void setCancelEnabled(boolean enable) {
        this.cancelEnabled = enable;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void clearCanceled() {
        this.isCancelled = false;
    }

    public boolean isInderminate() {
        return this.indeterminate;
    }

    public boolean isShowingProgressValue() {
        return this.showProgressValue;
    }

    public String getMessage() {
        return this.message;
    }

    public void cancelled() {
        this.cancel();
    }

    public void setProgressBar(GProgressBar gProgressBar) {
        this.progressBar = gProgressBar;
        this.progressBar.initialize(this.max);
        this.progressBar.setProgress(this.progress);
        this.progressBar.setMessage(this.message);
        this.progressBar.setCancelledListener(this);
    }
}

