/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.util.NoSuchElementException;

public class RGB16EncodingSettingsDefinition
implements EnumSettingsDefinition,
TypeDefSettingsDefinition {
    public static final RGB16Encoding DEFAULT_ENCODING = RGB16Encoding.RGB_565;
    private static final String RGB16_ENCODING_SETTINGS_NAME = "rgb16";
    private static final String DESCRIPTION = "Specifies a 16-bit RGB Color Encoding";
    private static final String DISPLAY_NAME = "RGB16 Encoding";
    private static final String[] choices = new String[]{RGB16Encoding.RGB_565.name(), RGB16Encoding.RGB_555.name(), RGB16Encoding.ARGB_1555.name()};
    public static final RGB16EncodingSettingsDefinition DEF = new RGB16EncodingSettingsDefinition();

    private RGB16EncodingSettingsDefinition() {
    }

    public RGB16Encoding getRGBEncoding(Settings settings) {
        return RGB16Encoding.valueOf(this.getValueString(settings));
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(RGB16_ENCODING_SETTINGS_NAME);
        if (value == null) {
            return 0;
        }
        int choice = (int)value.longValue();
        try {
            if (choice >= 0 || choice < choices.length) {
                return choice;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int choice) {
        try {
            if (choice > 0 || choice < choices.length) {
                settings.setLong(RGB16_ENCODING_SETTINGS_NAME, (long)choice);
                return;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        settings.clearSetting(RGB16_ENCODING_SETTINGS_NAME);
    }

    public void setRGBEncoding(Settings settings, RGB16Encoding encoding) {
        String encodingName = encoding.name();
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(encodingName)) continue;
            this.setChoice(settings, i);
            break;
        }
        throw new AssertionError((Object)("Missing RGB Encoding choice: " + String.valueOf((Object)encoding)));
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return RGB16_ENCODING_SETTINGS_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(RGB16_ENCODING_SETTINGS_NAME);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(RGB16_ENCODING_SETTINGS_NAME);
        if (l == null) {
            destSettings.clearSetting(RGB16_ENCODING_SETTINGS_NAME);
        } else {
            destSettings.setLong(RGB16_ENCODING_SETTINGS_NAME, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(RGB16_ENCODING_SETTINGS_NAME) != null;
    }

    public String getDisplayChoice(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setDisplayChoice(Settings settings, String choice) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(choice)) continue;
            this.setChoice(settings, i);
            break;
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        int choice = this.getChoice(settings);
        if (choice != 0) {
            return choices[choice];
        }
        return null;
    }

    public static enum RGB16Encoding {
        RGB_565,
        RGB_555,
        ARGB_1555;

    }
}

