/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.info;

import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.BuiltinTraceObjectInterfaceFactory;
import ghidra.trace.model.target.info.TraceObjectInfo;
import ghidra.trace.model.target.info.TraceObjectInterfaceFactory;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;

public final class TraceObjectInterfaceUtils
extends Enum<TraceObjectInterfaceUtils> {
    private static final Private PRIVATE;
    private static final /* synthetic */ TraceObjectInterfaceUtils[] $VALUES;

    public static TraceObjectInterfaceUtils[] values() {
        return (TraceObjectInterfaceUtils[])$VALUES.clone();
    }

    public static TraceObjectInterfaceUtils valueOf(String name) {
        return Enum.valueOf(TraceObjectInterfaceUtils.class, name);
    }

    public static Map<Class<?>, TraceObjectInterfaceFactory.Constructor<?>> getAllConstructors() {
        return PRIVATE.getMapByClass();
    }

    public static Stream<TraceObjectInterfaceFactory.Constructor<?>> streamConstructors(TraceObjectSchema schema) {
        return schema.getInterfaces().stream().map(PRIVATE.getMapByClass()::get);
    }

    public static boolean isTraceObject(Class<?> cls) {
        return cls == TraceObject.class || TraceObjectInterface.class.isAssignableFrom(cls);
    }

    public static Map<String, TraceObjectInterfaceFactory.Constructor<?>> getConstructorsByName() {
        return PRIVATE.getMapByName();
    }

    public static TraceObjectInfo requireAnnotation(Class<? extends TraceObjectInterface> traceIf) {
        TraceObjectInfo annot = traceIf.getAnnotation(TraceObjectInfo.class);
        if (annot == null) {
            throw new IllegalArgumentException(String.valueOf(traceIf) + " is missing @" + String.valueOf(TraceObjectInfo.class) + " annotation");
        }
        return annot;
    }

    public static String getSchemaName(Class<? extends TraceObjectInterface> traceIf) {
        return TraceObjectInterfaceUtils.requireAnnotation(traceIf).schemaName();
    }

    public static String getShortName(Class<? extends TraceObjectInterface> traceIf) {
        return TraceObjectInterfaceUtils.requireAnnotation(traceIf).shortName();
    }

    public static Collection<String> getFixedKeys(Class<? extends TraceObjectInterface> traceIf) {
        return List.of(TraceObjectInterfaceUtils.requireAnnotation(traceIf).fixedKeys());
    }

    public static <T> T getValue(TraceObject object, long snap, String key, Class<T> cls, T def) {
        TraceObjectValue value = object.getValue(snap, key);
        if (value == null) {
            return def;
        }
        return cls.cast(value.getValue());
    }

    private static /* synthetic */ TraceObjectInterfaceUtils[] $values() {
        return new TraceObjectInterfaceUtils[0];
    }

    static {
        $VALUES = TraceObjectInterfaceUtils.$values();
        PRIVATE = new Private();
    }

    private static class Private {
        private Map<Class<?>, TraceObjectInterfaceFactory.Constructor<?>> mapByClass = null;
        private Map<String, TraceObjectInterfaceFactory.Constructor<?>> mapByName = null;

        public Private() {
            ClassSearcher.addChangeListener(this::classesChanged);
        }

        private synchronized void classesChanged(ChangeEvent evt) {
            this.mapByClass = null;
        }

        private void checkRefresh() {
            if (this.mapByClass == null) {
                List<BuiltinTraceObjectInterfaceFactory> instances = ClassSearcher.getInstances(TraceObjectInterfaceFactory.class);
                if (instances.isEmpty()) {
                    Msg.warn((Object)this, (Object)"ClassSearcher not active, yet. Falling back to built-in TraceObjectInterfaces.");
                    instances = List.of(new BuiltinTraceObjectInterfaceFactory());
                }
                this.mapByClass = instances.stream().flatMap(f -> f.getInterfaceConstructors().stream()).collect(Collectors.toUnmodifiableMap(TraceObjectInterfaceFactory.Constructor::iface, Function.identity()));
                this.mapByName = this.mapByClass.values().stream().collect(Collectors.toUnmodifiableMap(c -> TraceObjectInterfaceUtils.getSchemaName(c.iface()), Function.identity()));
            }
        }

        private synchronized Map<Class<?>, TraceObjectInterfaceFactory.Constructor<?>> getMapByClass() {
            this.checkRefresh();
            return this.mapByClass;
        }

        private synchronized Map<String, TraceObjectInterfaceFactory.Constructor<?>> getMapByName() {
            this.checkRefresh();
            return this.mapByName;
        }
    }
}

