/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra.property;

import ghidra.pyghidra.property.JavaProperty;
import ghidra.pyghidra.property.JavaPropertyFactory;
import ghidra.util.Msg;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyUtils {
    private PropertyUtils() {
    }

    static Class<?> boxPrimitive(Class<?> cls) {
        if (!cls.isPrimitive()) {
            return cls;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        return cls;
    }

    public static JavaProperty<?>[] getProperties(Class<?> cls) {
        if (cls == Object.class) {
            return new JavaProperty[0];
        }
        try {
            return PropertyUtils.doGetProperties(cls);
        }
        catch (Throwable t) {
            Msg.error(PropertyUtils.class, (Object)("Failed to extract properties for " + cls.getSimpleName()), (Throwable)t);
            return new JavaProperty[0];
        }
    }

    private static JavaProperty<?>[] doGetProperties(Class<?> cls) throws Throwable {
        PropertyPairFactory factory;
        try {
            factory = new PropertyPairFactory(cls);
        }
        catch (IllegalArgumentException e) {
            return new JavaProperty[0];
        }
        return (JavaProperty[])PropertyUtils.getMethods(cls).filter(PropertyUtils::methodFilter).map(PropertyUtils::toProperty).collect(Collectors.groupingBy(PartialProperty::getName)).values().stream().map(factory::merge).flatMap(Optional::stream).toArray(JavaProperty[]::new);
    }

    private static Stream<Method> getMethods(Class<?> cls) {
        if (PropertyUtils.isPublic(cls)) {
            return Arrays.stream(cls.getMethods());
        }
        Class<?> base = cls;
        while (!PropertyUtils.isPublic(base)) {
            base = base.getSuperclass();
        }
        Stream<Method> head = Arrays.stream(base.getMethods()).filter(PropertyUtils::methodFilter);
        Stream<Method> tail = Stream.concat(Arrays.stream(base.getInterfaces()), Arrays.stream(cls.getInterfaces())).sorted(Comparator.comparing(Class::getSimpleName)).distinct().map(Class::getDeclaredMethods).flatMap(Arrays::stream).filter(PropertyUtils::methodFilter);
        return Stream.concat(head, tail).sorted(Comparator.comparing(Method::toGenericString)).distinct();
    }

    private static boolean methodFilter(Method m) {
        if (!PropertyUtils.isPublic(m)) {
            return false;
        }
        int paramCount = m.getParameterCount();
        if (paramCount > 1) {
            return false;
        }
        Class<?> resultType = m.getReturnType();
        String name = m.getName();
        int nameLength = name.length();
        if (nameLength < 3) {
            return false;
        }
        switch (name.charAt(0)) {
            case 'g': {
                if (paramCount == 0 && resultType != Void.TYPE && nameLength > 3 && name.startsWith("get")) {
                    return Character.isUpperCase(name.charAt(3));
                }
                return false;
            }
            case 'i': {
                if (paramCount == 0 && (resultType == Boolean.TYPE || resultType == Boolean.class) && nameLength > 2 && name.startsWith("is")) {
                    return Character.isUpperCase(name.charAt(2));
                }
                return false;
            }
            case 's': {
                if (paramCount == 1 && resultType == Void.TYPE && nameLength > 3 && name.startsWith("set")) {
                    return Character.isUpperCase(name.charAt(3));
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isPublic(Class<?> cls) {
        return Modifier.isPublic(cls.getModifiers());
    }

    private static boolean isPublic(Method m) {
        int mod = m.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod);
    }

    private static PartialProperty toProperty(Method m) {
        Object name = m.getName();
        name = ((String)name).charAt(0) == 'i' ? ((String)name).substring(2) : ((String)name).substring(3);
        name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        return new PartialProperty(m, (String)name);
    }

    private static class PropertyPairFactory {
        private final MethodHandles.Lookup lookup = MethodHandles.publicLookup();

        private PropertyPairFactory(Class<?> c) {
        }

        private Optional<JavaProperty<?>> merge(List<PartialProperty> pairs) {
            try {
                if (pairs.size() == 1) {
                    PartialProperty p2 = pairs.get(0);
                    MethodHandle h = this.lookup.unreflect(p2.m);
                    JavaProperty<?> res = p2.isGetter() ? JavaPropertyFactory.getProperty(p2.name, h, null) : JavaPropertyFactory.getProperty(p2.name, null, h);
                    return Optional.of(res);
                }
                PartialProperty g = pairs.stream().filter(PartialProperty::isGetter).findFirst().orElse(null);
                if (g != null) {
                    Class<?> target = PropertyUtils.boxPrimitive(g.m.getReturnType());
                    PartialProperty s = pairs.stream().filter(PartialProperty::isSetter).filter(p -> PropertyUtils.boxPrimitive(p.m.getParameterTypes()[0]) == target).findFirst().orElse(null);
                    MethodHandle gh = this.lookup.unreflect(g.m);
                    MethodHandle sh = s != null ? this.lookup.unreflect(s.m) : null;
                    return Optional.of(JavaPropertyFactory.getProperty(g.name, gh, sh));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return Optional.empty();
        }
    }

    private static class PartialProperty {
        private final Method m;
        private final String name;

        private PartialProperty(Method m, String name) {
            this.m = m;
            this.name = name;
        }

        public boolean isGetter() {
            return this.m.getParameterCount() == 0 && this.m.getReturnType() != Void.TYPE;
        }

        public boolean isSetter() {
            return this.m.getParameterCount() == 1 && this.m.getReturnType() == Void.TYPE;
        }

        public String getName() {
            return this.name;
        }
    }
}

