/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.page.PageBuilder;
import org.jboss.logging.Logger;

public class ExternalPageBuilder
extends PageBuilder<ExternalPageBuilder> {
    private static final Logger log = Logger.getLogger(ExternalPageBuilder.class);
    private static final String QWC_EXTERNAL_PAGE_JS = "qwc-external-page.js";
    private static final String EXTERNAL_URL = "externalUrl";
    private static final String DYNAMIC_URL = "dynamicUrlMethodName";
    private static final String MIME_TYPE = "mimeType";
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_JSON = "application/json";
    public static final String MIME_TYPE_YAML = "application/yaml";
    public static final String MIME_TYPE_PDF = "application/pdf";

    protected ExternalPageBuilder(String title) {
        this.title = title;
        this.componentLink = QWC_EXTERNAL_PAGE_JS;
        this.internalComponent = true;
    }

    public ExternalPageBuilder url(String url) {
        return this.url(url, null);
    }

    public ExternalPageBuilder url(String url, String externalLink) {
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("Invalid external URL, can not be empty");
        }
        this.metadata.put(EXTERNAL_URL, url);
        if (externalLink != null) {
            return (ExternalPageBuilder)this.staticLabel("<a style='color: var(--lumo-contrast-80pct);' href='" + externalLink + "' target='_blank'><vaadin-icon class='icon' icon='font-awesome-solid:up-right-from-square'></vaadin-icon></a>");
        }
        return this;
    }

    public ExternalPageBuilder dynamicUrlJsonRPCMethodName(String methodName) {
        if (methodName == null || methodName.isEmpty()) {
            throw new RuntimeException("Invalid dynamic URL Method name, can not be empty");
        }
        this.metadata.put(DYNAMIC_URL, methodName);
        return this;
    }

    public ExternalPageBuilder isHtmlContent() {
        return this.mimeType(MIME_TYPE_HTML);
    }

    public ExternalPageBuilder isJsonContent() {
        return this.mimeType(MIME_TYPE_JSON);
    }

    public ExternalPageBuilder isYamlContent() {
        return this.mimeType(MIME_TYPE_YAML);
    }

    public ExternalPageBuilder isPdfContent() {
        return this.mimeType(MIME_TYPE_PDF);
    }

    public ExternalPageBuilder mimeType(String mimeType) {
        if (mimeType == null || mimeType.isEmpty()) {
            throw new RuntimeException("Invalid mimeType, can not be empty");
        }
        if (this.metadata.containsKey(MIME_TYPE)) {
            log.warn((Object)("MimeType already set to " + this.metadata.get(MIME_TYPE) + ", overriding with new value"));
        }
        this.metadata.put(MIME_TYPE, mimeType);
        return this;
    }

    public ExternalPageBuilder doNotEmbed() {
        return this.doNotEmbed(false);
    }

    public ExternalPageBuilder doNotEmbed(boolean includeInMenu) {
        this.embed = false;
        this.includeInMenu = includeInMenu;
        return this;
    }
}

