/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.ocf.OCFResource;
import com.adobe.epubcheck.ocf.OCFResources;
import com.adobe.epubcheck.ocf.encryption.EncryptionFilter;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.mola.galimatias.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.w3c.epubcheck.constants.MIMEType;

class OCFCheckerState {
    private ValidationContext.ValidationContextBuilder context;
    private final OCFContainer.Builder containerBuilder = new OCFContainer.Builder();
    private OCFContainer container;
    private boolean containerNeedsRebuild = true;
    private final ImmutableList.Builder<URL> packageDocuments = ImmutableList.builder();
    private URL mappingDocument;
    private OCFResources resources = null;
    private final Map<URL, EPUBLocation> obfuscated = new HashMap<URL, EPUBLocation>();
    private final Map<URL, Set<PublicationType>> publicationTypes = new LinkedHashMap<URL, Set<PublicationType>>();
    private final Map<URL, String> publicationIDs = new LinkedHashMap<URL, String>();
    private final Map<URL, EPUBVersion> publicationVersions = new LinkedHashMap<URL, EPUBVersion>();
    private final Set<URL> declaredResources = new HashSet<URL>();
    private String error = "";

    public OCFCheckerState(ValidationContext context) {
        this.context = context.copy();
    }

    public void addEncryptedResource(URL resource, EncryptionFilter filter) {
        this.containerBuilder.addEncryption((URL)Preconditions.checkNotNull((Object)resource), (EncryptionFilter)Preconditions.checkNotNull((Object)filter));
        this.containerNeedsRebuild = true;
    }

    public void addError(String error) {
        this.error = Strings.nullToEmpty((String)error);
    }

    public void addMappingDocument(URL resource) {
        this.mappingDocument = resource;
        this.declaredResources.add(resource);
    }

    public void addObfuscatedResource(URL resource, EPUBLocation location) {
        this.obfuscated.put((URL)Preconditions.checkNotNull((Object)resource), (EPUBLocation)Preconditions.checkNotNull((Object)location));
    }

    public void addResource(OCFResource resource) {
        this.containerBuilder.addResource(resource);
        this.containerNeedsRebuild = true;
    }

    public OCFResources getResources() {
        return this.resources;
    }

    public void setResources(OCFResources resources) {
        this.resources = resources;
    }

    public void addRootfile(String mediaType, URL resource) {
        Preconditions.checkNotNull((Object)mediaType);
        Preconditions.checkNotNull((Object)resource);
        if (MIMEType.PACKAGE_DOC.is(mediaType)) {
            this.packageDocuments.add((Object)resource);
        }
        this.declaredResources.add(resource);
    }

    public void addType(URL url, String typeString) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)typeString);
        try {
            PublicationType type = PublicationType.valueOf(typeString.toUpperCase(Locale.ROOT));
            if (!this.publicationTypes.containsKey(url)) {
                this.publicationTypes.put(url, new LinkedHashSet());
            }
            this.publicationTypes.get(url).add(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addUniqueId(URL url, String id) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)id);
        this.publicationIDs.put(url, id);
    }

    public void addVersion(URL url, EPUBVersion version) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)((Object)version));
        this.publicationVersions.put(url, version);
    }

    public void errorReset() {
        this.error = "";
    }

    public ValidationContext.ValidationContextBuilder context() {
        return this.context.build().copy();
    }

    public OCFContainer getContainer() {
        if (this.containerNeedsRebuild) {
            this.container = this.containerBuilder.build();
            this.context = this.context.container(this.container);
            this.containerNeedsRebuild = false;
        }
        return this.container;
    }

    public String getError() {
        return this.error;
    }

    public Optional<URL> getMappingDocument() {
        return Optional.ofNullable(this.mappingDocument);
    }

    public EPUBLocation getObfuscationLocation(URL resource) {
        EPUBLocation location = this.obfuscated.get(resource);
        if (location == null) {
            throw new IllegalStateException();
        }
        return location;
    }

    public List<URL> getPackageDocuments() {
        return this.packageDocuments.build();
    }

    public Optional<String> getPublicationID() {
        Iterator<String> values = this.publicationIDs.values().iterator();
        return values.hasNext() ? Optional.of(values.next()) : Optional.empty();
    }

    public Set<PublicationType> getPublicationTypes() {
        Iterator<Set<PublicationType>> values = this.publicationTypes.values().iterator();
        return values.hasNext() ? ImmutableSet.copyOf((Collection)values.next()) : ImmutableSet.of();
    }

    public Set<PublicationType> getPublicationTypes(URL url) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0);
        Set<PublicationType> types = this.publicationTypes.get(url);
        return types != null ? ImmutableSet.copyOf(types) : ImmutableSet.of();
    }

    public Optional<EPUBVersion> getPublicationVersion() {
        Iterator<EPUBVersion> values = this.publicationVersions.values().iterator();
        return values.hasNext() ? Optional.of(values.next()) : Optional.empty();
    }

    public EPUBVersion getPublicationVersion(URL url) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0);
        EPUBVersion version = this.publicationVersions.get(url);
        return version != null ? version : EPUBVersion.Unknown;
    }

    public boolean isObfuscated(URL resource) {
        return this.obfuscated.containsKey(resource);
    }

    public void setVersion(EPUBVersion validationVersion) {
        this.context = this.context.version(validationVersion);
    }

    public void setProfile(EPUBProfile checkPublicationProfile) {
        this.context = this.context.profile(checkPublicationProfile);
    }

    public void addProperty(Property property) {
        this.context = this.context.addProperty(property);
    }

    public boolean isDeclared(URL resource) {
        return this.declaredResources.contains(resource);
    }

    public void setPackaged(boolean isPackaged) {
        this.containerBuilder.setPackaged(isPackaged);
        this.containerNeedsRebuild = true;
    }
}

