/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.util.SyntheticAccessorResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaksmaliOptions {
    public int apiLevel = 15;
    public boolean parameterRegisters = true;
    public boolean localsDirective = false;
    public boolean sequentialLabels = false;
    public boolean debugInfo = true;
    public boolean codeOffsets = false;
    public boolean accessorComments = true;
    public boolean allowOdex = false;
    public boolean deodex = false;
    public boolean implicitReferences = false;
    public boolean normalizeVirtualMethods = false;
    public static final int ALL = 1;
    public static final int ALLPRE = 2;
    public static final int ALLPOST = 4;
    public static final int ARGS = 8;
    public static final int DEST = 16;
    public static final int MERGE = 32;
    public static final int FULLMERGE = 64;
    public int registerInfo = 0;
    public Map<Integer, String> resourceIds = new HashMap<Integer, String>();
    public InlineMethodResolver inlineResolver = null;
    public ClassPath classPath = null;
    public SyntheticAccessorResolver syntheticAccessorResolver = null;

    public void loadResourceIds(Map<String, File> resourceFiles) throws SAXException, IOException {
        for (Map.Entry<String, File> entry : resourceFiles.entrySet()) {
            try {
                SAXParser saxp = SAXParserFactory.newInstance().newSAXParser();
                final String prefix = entry.getKey();
                saxp.parse(entry.getValue(), new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
                        if (qName.equals("public")) {
                            String resourceType = attr.getValue("type");
                            String resourceName = attr.getValue("name").replace('.', '_');
                            Integer resourceId = Integer.decode(attr.getValue("id"));
                            String qualifiedResourceName = String.format("%s.%s.%s", prefix, resourceType, resourceName);
                            BaksmaliOptions.this.resourceIds.put(resourceId, qualifiedResourceName);
                        }
                    }
                });
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

