/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileIterator;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryCollectionFromIndex;
import thredds.inventory.partition.IndexReader;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class DirectoryPartition
extends CollectionAbstract
implements PartitionManager {
    private final FeatureCollectionConfig config;
    private final Path topDir;
    private final IndexReader indexReader;
    private final String topCollection;

    public DirectoryPartition(FeatureCollectionConfig config, Path topDir, IndexReader indexReader, Logger logger) {
        super(null, logger);
        this.config = config;
        this.topDir = topDir;
        this.indexReader = indexReader;
        this.topCollection = config.name;
        this.collectionName = DirectoryCollection.makeCollectionName(this.topCollection, topDir);
    }

    public String getTopCollectionName() {
        return this.topCollection;
    }

    public Path getIndexPath() {
        return DirectoryCollection.makeCollectionIndexPath(this.topCollection, this.topDir);
    }

    @Override
    public String getIndexFilename() {
        return this.getIndexPath().toString();
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        if (forceCollection == null) {
            forceCollection = CollectionUpdateType.test;
        }
        DirectoryBuilder builder = new DirectoryBuilder(this.topCollection, this.topDir, null);
        builder.constructChildren(this.indexReader, forceCollection);
        ArrayList<MCollection> result = new ArrayList<MCollection>();
        for (DirectoryBuilder child : builder.getChildren()) {
            try {
                MCollection dc = DirectoryBuilder.factory(this.config, child.getDir(), this.indexReader, this.logger);
                result.add(dc);
                this.lastModified = Math.max(this.lastModified, dc.getLastModified());
            }
            catch (IOException ioe) {
                this.logger.warn("DirectoryBuilder on " + child.getDir() + " failed: skipping", (Throwable)ioe);
            }
        }
        return result;
    }

    MCollection makeChildCollection(DirectoryBuilder dpb) throws IOException {
        boolean hasIndex = dpb.findIndex();
        CollectionAbstract result = hasIndex ? new DirectoryCollectionFromIndex(dpb, this.dateExtractor, this.indexReader, this.logger) : new DirectoryCollection(this.topCollection, dpb.getDir(), this.config.olderThan, this.logger);
        return result;
    }

    @Override
    public String getRoot() {
        return this.topDir.toString();
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return new ArrayList<MFile>();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MFileIterator(this.getFilesSorted().iterator(), this.filter);
    }

    @Override
    public void close() {
    }
}

