;;; loaddefs.el --- automatically extracted autoloads (do not edit)   -*- lexical-binding: t -*-
;; Generated by the `loaddefs-generate' function.

;; This file is part of GNU Emacs.

;;; Commentary:

;; This file will be copied to ldefs-boot.el and checked in
;; periodically.

;;; Code:



;;; Generated autoloads from play/5x5.el

(autoload '5x5 "5x5" "\
Play 5x5.

The object of 5x5 is very simple, by moving around the grid and flipping
squares you must fill the grid.

5x5 keyboard bindings are:
\\<5x5-mode-map>
Flip                        \\[5x5-flip-current]
Move up                     \\[5x5-up]
Move down                   \\[5x5-down]
Move left                   \\[5x5-left]
Move right                  \\[5x5-right]
Start new game              \\[5x5-new-game]
New game with random grid   \\[5x5-randomize]
Random cracker              \\[5x5-crack-randomly]
Mutate current cracker      \\[5x5-crack-mutating-current]
Mutate best cracker         \\[5x5-crack-mutating-best]
Mutate xor cracker          \\[5x5-crack-xor-mutate]
Solve with Calc             \\[5x5-solve-suggest]
Rotate left Calc Solutions  \\[5x5-solve-rotate-left]
Rotate right Calc Solutions \\[5x5-solve-rotate-right]
Quit current game           \\[5x5-quit-game]

(fn &optional SIZE)" t)
(autoload '5x5-crack-randomly "5x5" "\
Attempt to crack 5x5 using random solutions." t)
(autoload '5x5-crack-mutating-current "5x5" "\
Attempt to crack 5x5 by mutating the current solution." t)
(autoload '5x5-crack-mutating-best "5x5" "\
Attempt to crack 5x5 by mutating the best solution." t)
(autoload '5x5-crack-xor-mutate "5x5" "\
Attempt to crack 5x5 by xoring the current and best solution.
Mutate the result." t)
(autoload '5x5-crack "5x5" "\
Attempt to find a solution for 5x5.

`5x5-crack' takes the argument BREEDER which should be a function that takes
two parameters, the first will be a grid vector array that is the current
solution and the second will be the best solution so far.  The function
should return a grid vector array that is the new solution.

(fn BREEDER)" t)
(register-definition-prefixes "5x5" '("5x5-"))


;;; Generated autoloads from vc/add-log.el

(put 'change-log-default-name 'safe-local-variable #'string-or-null-p)
(defvar add-log-current-defun-function nil "\
If non-nil, function to guess name of surrounding function.
It is called by `add-log-current-defun' with no argument, and
should return the function's name as a string, or nil if point is
outside a function.")
(custom-autoload 'add-log-current-defun-function "add-log" t)
(defvar add-log-full-name nil "\
Full name of user, for inclusion in ChangeLog daily headers.
This defaults to the value returned by the function `user-full-name'.")
(custom-autoload 'add-log-full-name "add-log" t)
(defvar add-log-mailing-address nil "\
Email addresses of user, for inclusion in ChangeLog headers.
This defaults to the value of `user-mail-address'.  In addition to
being a simple string, this value can also be a list.  All elements
will be recognized as referring to the same user; when creating a new
ChangeLog entry, one element will be chosen at random.")
(custom-autoload 'add-log-mailing-address "add-log" t)
(autoload 'prompt-for-change-log-name "add-log" "\
Prompt for a change log name.")
(autoload 'find-change-log "add-log" "\
Find a change log file for \\[add-change-log-entry] and return the name.

Optional arg FILE-NAME specifies the file to use.
If FILE-NAME is nil, use the value of `change-log-default-name'.
If `change-log-default-name' is nil, behave as though it were \"ChangeLog\"
(or whatever we use on this operating system).

If `change-log-default-name' contains a leading directory component, then
simply find it in the current directory.  Otherwise, search in the current
directory and its successive parents for a file so named.  Stop at the first
such file that exists (or has a buffer visiting it), or the first directory
that contains any of `change-log-directory-files'.  If no match is found,
use the current directory.  To override the choice of this function,
simply create an empty ChangeLog file first by hand in the desired place.

Once a file is found, `change-log-default-name' is set locally in the
current buffer to the complete file name.
Optional arg BUFFER-FILE overrides `buffer-file-name'.

(fn &optional FILE-NAME BUFFER-FILE)")
(autoload 'add-change-log-entry "add-log" "\
Find ChangeLog buffer, add an entry for today and an item for this file.
Optional arg WHOAMI (interactive prefix) non-nil means prompt for
user name and email (stored in `add-log-full-name'
and `add-log-mailing-address').

Second arg CHANGELOG-FILE-NAME is the file name of the change log.
If nil, use the value of `change-log-default-name'.  If the file
thus named exists, it is used for the new entry.  If it doesn't
exist, it is created, unless `add-log-dont-create-changelog-file' is t,
in which case a suitably named buffer that doesn't visit any file
is used for keeping entries pertaining to CHANGELOG-FILE-NAME's
directory.

Third arg OTHER-WINDOW non-nil means visit in other window.

Fourth arg NEW-ENTRY non-nil means always create a new entry at the front;
never append to an existing entry.  Option `add-log-keep-changes-together'
otherwise affects whether a new entry is created.

Fifth arg PUT-NEW-ENTRY-ON-NEW-LINE non-nil means that if a new
entry is created, put it on a new line by itself, do not put it
after a comma on an existing line.

Option `add-log-always-start-new-record' non-nil means always create a
new record, even when the last record was made on the same date and by
the same person.

The change log file can start with a copyright notice and a copying
permission notice.  The first blank line indicates the end of these
notices.

Today's date is calculated according to `add-log-time-zone-rule' if
non-nil, otherwise in local time.

(fn &optional WHOAMI CHANGELOG-FILE-NAME OTHER-WINDOW NEW-ENTRY PUT-NEW-ENTRY-ON-NEW-LINE)" t)
(autoload 'add-change-log-entry-other-window "add-log" "\
Find change log file in other window and add entry and item.
This is just like `add-change-log-entry' except that it displays
the change log file in another window.

(fn &optional WHOAMI FILE-NAME)" t)
(autoload 'change-log-mode "add-log" "\
Major mode for editing change logs; like Indented Text mode.
Prevents numeric backups and sets `left-margin' to 8 and `fill-column' to 74.
New log entries are usually made with \\[add-change-log-entry] or \\[add-change-log-entry-other-window].
Each entry behaves as a paragraph, and the entries for one day as a page.
Runs `change-log-mode-hook'.

\\{change-log-mode-map}

(fn)" t)
(autoload 'add-log-current-defun "add-log" "\
Return name of function definition point is in, or nil.

Understands C, Lisp, LaTeX (\"functions\" are chapters, sections, ...),
Texinfo (@node titles) and Perl.

Other modes are handled by a heuristic that looks in the 10K before
point for uppercase headings starting in the first column or
identifiers followed by `:' or `='.  See variables
`add-log-current-defun-header-regexp' and
`add-log-current-defun-function'.

Has a preference of looking backwards.")
(autoload 'change-log-merge "add-log" "\
Merge the contents of change log file OTHER-LOG with this buffer.
Both must be found in Change Log mode (since the merging depends on
the appropriate motion commands).  OTHER-LOG can be either a file name
or a buffer.

Entries are inserted in chronological order.  Both the current and
old-style time formats for entries are supported.

(fn OTHER-LOG)" t)
(register-definition-prefixes "add-log" '("add-log-" "change-log-"))


;;; Generated autoloads from emacs-lisp/advice.el

(defvar ad-redefinition-action 'warn "\
Defines what to do with redefinitions during Advice de/activation.
Redefinition occurs if a previously activated function that already has an
original definition associated with it gets redefined and then de/activated.
In such a case we can either accept the current definition as the new
original definition, discard the current definition and replace it with the
old original, or keep it and raise an error.  The values `accept', `discard',
`error' or `warn' govern what will be done.  `warn' is just like `accept' but
it additionally prints a warning message.  All other values will be
interpreted as `error'.")
(custom-autoload 'ad-redefinition-action "advice" t)
(defvar ad-default-compilation-action 'maybe "\
Defines whether to compile advised definitions during activation.
A value of `always' will result in unconditional compilation, `never' will
always avoid compilation, `maybe' will compile if the byte-compiler is already
loaded, and `like-original' will compile if the original definition of the
advised function is compiled or a built-in function.  Every other value will
be interpreted as `maybe'.  This variable will only be considered if the
COMPILE argument of `ad-activate' was supplied as nil.")
(custom-autoload 'ad-default-compilation-action "advice" t)
(autoload 'ad-enable-advice "advice" "\
Enables the advice of FUNCTION with CLASS and NAME.

(fn FUNCTION CLASS NAME)" t)
(autoload 'ad-disable-advice "advice" "\
Disable the advice of FUNCTION with CLASS and NAME.

(fn FUNCTION CLASS NAME)" t)
(autoload 'ad-add-advice "advice" "\
Add a piece of ADVICE to FUNCTION's list of advices in CLASS.

ADVICE has the form (NAME PROTECTED ENABLED DEFINITION), where
NAME is the advice name; PROTECTED is a flag specifying whether
to protect against non-local exits; ENABLED is a flag specifying
whether to initially enable the advice; and DEFINITION has the
form (advice . LAMBDA), where LAMBDA is a lambda expression.

If FUNCTION already has a piece of advice with the same name,
then POSITION is ignored, and the old advice is overwritten with
the new one.

If FUNCTION already has one or more pieces of advice of the
specified CLASS, then POSITION determines where the new piece
goes.  POSITION can either be `first', `last' or a number (where
0 corresponds to `first', and numbers outside the valid range are
mapped to the closest extremal position).

If FUNCTION was not advised already, its advice info will be
initialized.  Redefining a piece of advice whose name is part of
the cache-id will clear the cache.

(fn FUNCTION ADVICE CLASS POSITION)")
(autoload 'ad-activate "advice" "\
Activate all the advice information of an advised FUNCTION.
If FUNCTION has a proper original definition then an advised
definition will be generated from FUNCTION's advice info and the
definition of FUNCTION will be replaced with it.  If a previously
cached advised definition was available, it will be used.
The optional COMPILE argument determines whether the resulting function
or a compilable cached definition will be compiled.  If it is negative
no compilation will be performed, if it is positive or otherwise non-nil
the resulting function will be compiled, if it is nil the behavior depends
on the value of `ad-default-compilation-action' (which see).
Activation of an advised function that has an advice info but no actual
pieces of advice is equivalent to a call to `ad-unadvise'.  Activation of
an advised function that has actual pieces of advice but none of them are
enabled is equivalent to a call to `ad-deactivate'.  The current advised
definition will always be cached for later usage.

(fn FUNCTION &optional COMPILE)" t)
(autoload 'defadvice "advice" "\
Define a piece of advice for FUNCTION (a symbol).
The syntax of `defadvice' is as follows:

  (defadvice FUNCTION (CLASS NAME [POSITION] [ARGLIST] FLAG...)
    [DOCSTRING] [INTERACTIVE-FORM]
    BODY...)

FUNCTION ::= Name of the function to be advised.
CLASS ::= `before' | `around' | `after' | `activation' | `deactivation'.
NAME ::= Non-nil symbol that names this piece of advice.
POSITION ::= `first' | `last' | NUMBER.  Optional, defaults to `first',
    see also `ad-add-advice'.
ARGLIST ::= An optional argument list to be used for the advised function
    instead of the argument list of the original.  The first one found in
    before/around/after-advices will be used.
FLAG ::= `protect'|`disable'|`activate'|`compile'|`preactivate'.
    All flags can be specified with unambiguous initial substrings.
DOCSTRING ::= Optional documentation for this piece of advice.
INTERACTIVE-FORM ::= Optional interactive form to be used for the advised
    function.  The first one found in before/around/after-advices will be used.
BODY ::= Any s-expression.

Semantics of the various flags:
`protect': The piece of advice will be protected against non-local exits in
any code that precedes it.  If any around-advice of a function is protected
then automatically all around-advices will be protected (the complete onion).

`activate': All advice of FUNCTION will be activated immediately if
FUNCTION has been properly defined prior to this application of `defadvice'.

`compile': In conjunction with `activate' specifies that the resulting
advised function should be compiled.

`disable': The defined advice will be disabled, hence, it will not be used
during activation until somebody enables it.

`preactivate': Preactivates the advised FUNCTION at macro-expansion/compile
time.  This generates a compiled advised definition according to the current
advice state that will be used during activation if appropriate.  Only use
this if the `defadvice' gets actually compiled.

usage: (defadvice FUNCTION (CLASS NAME [POSITION] [ARGLIST] FLAG...)
          [DOCSTRING] [INTERACTIVE-FORM]
          BODY...)

(fn FUNCTION ARGS &rest BODY)" nil t)
(function-put 'defadvice 'doc-string-elt 3)
(function-put 'defadvice 'lisp-indent-function 2)
(make-obsolete 'defadvice '"use `advice-add' or `define-advice'" "30.1")
(register-definition-prefixes "advice" '("ad-"))


;;; Generated autoloads from align.el

(autoload 'align "align" "\
Attempt to align a region based on a set of alignment rules.
Interactively, BEG and END are the mark/point of the current region.

Many modes define specific alignment rules, and some of these
rules in some modes react to the current prefix argument.  For
instance, in `text-mode', \\`M-x align' will align into columns
based on space delimiters, while \\`C-u -' \\`M-x align' will align
into columns based on the \"$\" character.  See the
`align-rules-list' variable definition for the specific rules.

Also see `align-regexp', which will guide you through various
parameters for aligning text.

Non-interactively, if BEG and END are nil, the beginning and end
of the current alignment section will be calculated based on the
location of point, and the value of `align-region-separate' (or
possibly each rule's `separate' attribute).

If SEPARATE is non-nil, it overrides the value of
`align-region-separate' for all rules, except those that have their
`separate' attribute set.

RULES and EXCLUDE-RULES, if either is non-nil, will replace the
default rule lists defined in `align-rules-list' and
`align-exclude-rules-list'.  See `align-rules-list' for more details
on the format of these lists.

(fn BEG END &optional SEPARATE RULES EXCLUDE-RULES)" t)
(autoload 'align-regexp "align" "\
Align the current region using an ad-hoc rule read from the minibuffer.
BEG and END mark the limits of the region.  Interactively, this function
prompts for the regular expression REGEXP to align with.

Interactively, if you specify a prefix argument, the function
will guide you through entering the full regular expression, and
then prompts for which subexpression parenthesis GROUP (default
1) within REGEXP to modify, the amount of SPACING (default
`align-default-spacing') to use, and whether or not to REPEAT the
rule throughout the line.

See `align-rules-list' for more information about these options.

For example, let's say you had a list of phone numbers, and wanted to
align them so that the opening parentheses would line up:

    Fred (123) 456-7890
    Alice (123) 456-7890
    Mary-Anne (123) 456-7890
    Joe (123) 456-7890

There is no predefined rule to handle this, but interactively,
all you would have to do is to mark the region, call `align-regexp'
and enter \"(\".

REGEXP must contain at least one parenthesized subexpression,
typically whitespace of the form \"\\\\(\\\\s-*\\\\)\", but in
interactive use, this is automatically added to the start of your
regular expression after you enter it.  Interactively, you only
need to supply the characters to be lined up, and any preceding
whitespace is replaced.

Non-interactively, you must enter the full regular expression,
including the subexpression.

The non-interactive form of the previous example would look something like:
  (align-regexp (point-min) (point-max) \"\\\\(\\\\s-*\\\\)(\")

This function is a nothing more than a small wrapper that helps you
construct a rule to pass to `align-region', which does the real work.

(fn BEG END REGEXP &optional GROUP SPACING REPEAT)" t)
(autoload 'align-entire "align" "\
Align the selected region as if it were one alignment section.
BEG and END mark the extent of the region.  If RULES or EXCLUDE-RULES
is set to a list of rules (see `align-rules-list'), it can be used to
override the default alignment rules that would have been used to
align that section.

(fn BEG END &optional RULES EXCLUDE-RULES)" t)
(autoload 'align-current "align" "\
Call `align' on the current alignment section.
This function assumes you want to align only the current section, and
so saves you from having to specify the region.  If RULES or
EXCLUDE-RULES is set to a list of rules (see `align-rules-list'), it
can be used to override the default alignment rules that would have
been used to align that section.

(fn &optional RULES EXCLUDE-RULES)" t)
(autoload 'align-highlight-rule "align" "\
Highlight the whitespace which a given rule would have modified.
BEG and END mark the extent of the region.  TITLE identifies the rule
that should be highlighted.  If RULES or EXCLUDE-RULES is set to a
list of rules (see `align-rules-list'), it can be used to override the
default alignment rules that would have been used to identify the text
to be colored.

(fn BEG END TITLE &optional RULES EXCLUDE-RULES)" t)
(autoload 'align-unhighlight-rule "align" "\
Remove any highlighting that was added by `align-highlight-rule'." t)
(autoload 'align-newline-and-indent "align" "\
A replacement function for `newline-and-indent', aligning as it goes.
The alignment is done by calling `align' on the region that was
indented." t)
(register-definition-prefixes "align" '("align-"))


;;; Generated autoloads from allout.el

(push (purecopy '(allout 2 3)) package--builtin-versions)
(autoload 'allout-auto-activation-helper "allout" "\
Institute `allout-auto-activation'.

Intended to be used as the `allout-auto-activation' :set function.

(fn VAR VALUE)")
(autoload 'allout-setup "allout" "\
Do fundamental Emacs session for allout auto-activation.

Establishes allout processing as part of visiting a file if
`allout-auto-activation' is non-nil, or removes it otherwise.

The proper way to use this is through customizing the setting of
`allout-auto-activation'.")
(defvar allout-auto-activation nil "\
Configure allout outline mode auto-activation.

Control whether and how allout outline mode is automatically
activated when files are visited with non-nil buffer-specific
file variable `allout-layout'.

When `allout-auto-activation' is \"On\" (t), allout mode is
activated in buffers with non-nil `allout-layout', and the
specified layout is applied.

With value \"ask\", auto-mode-activation is enabled, and endorsement for
performing auto-layout is asked of the user each time.

With value \"activate\", only auto-mode-activation is enabled.
Auto-layout is not.

With value nil, inhibit any automatic allout-mode activation.")
(custom-autoload 'allout-auto-activation "allout" nil)
(put 'allout-use-hanging-indents 'safe-local-variable #'booleanp)
(put 'allout-reindent-bodies 'safe-local-variable (lambda (x) (memq x '(nil t text force))))
(put 'allout-show-bodies 'safe-local-variable #'booleanp)
(put 'allout-header-prefix 'safe-local-variable #'stringp)
(put 'allout-primary-bullet 'safe-local-variable #'stringp)
(put 'allout-plain-bullets-string 'safe-local-variable #'stringp)
(put 'allout-distinctive-bullets-string 'safe-local-variable #'stringp)
(put 'allout-use-mode-specific-leader 'safe-local-variable (lambda (x) (or (memq x '(t nil allout-mode-leaders comment-start)) (stringp x))))
(put 'allout-old-style-prefixes 'safe-local-variable #'booleanp)
(put 'allout-stylish-prefixes 'safe-local-variable #'booleanp)
(put 'allout-numbered-bullet 'safe-local-variable #'string-or-null-p)
(put 'allout-file-xref-bullet 'safe-local-variable #'string-or-null-p)
(put 'allout-presentation-padding 'safe-local-variable #'integerp)
(put 'allout-layout 'safe-local-variable (lambda (x) (or (numberp x) (listp x) (memq x '(: * + -)))))
(autoload 'allout-mode-p "allout" "\
Return t if `allout-mode' is active in current buffer." nil t)
(autoload 'allout-mode "allout" "\
Toggle Allout outline mode.

\\<allout-mode-map-value>
Allout outline mode is a minor mode that provides extensive
outline oriented formatting and manipulation.  It enables
structural editing of outlines, as well as navigation and
exposure.  It also is specifically aimed at accommodating
syntax-sensitive text like programming languages.  (For example,
see the allout code itself, which is organized as an allout
outline.)

In addition to typical outline navigation and exposure, allout includes:

 - topic-oriented authoring, including keystroke-based topic creation,
   repositioning, promotion/demotion, cut, and paste
 - incremental search with dynamic exposure and reconcealment of hidden text
 - adjustable format, so programming code can be developed in outline-structure
 - easy topic encryption and decryption, symmetric or key-pair
 - \"Hot-spot\" operation, for single-keystroke maneuvering and exposure control
 - integral outline layout, for automatic initial exposure when visiting a file
 - independent extensibility, using comprehensive exposure and authoring hooks

and many other features.

Below is a description of the key bindings, and then description
of special `allout-mode' features and terminology.  See also the
outline menubar additions for quick reference to many of the
features.  Customize `allout-auto-activation' to prepare your
Emacs session for automatic activation of `allout-mode'.

The bindings are those listed in `allout-prefixed-keybindings'
and `allout-unprefixed-keybindings'.  We recommend customizing
`allout-command-prefix' to use just `\\C-c' as the command
prefix, if the allout bindings don't conflict with any personal
bindings you have on \\C-c.  In any case, outline structure
navigation and authoring is simplified by positioning the cursor
on an item's bullet character, the \"hot-spot\" -- then you can
invoke allout commands with just the un-prefixed,
un-control-shifted command letters.  This is described further in
the HOT-SPOT Operation section.

        Exposure Control:
        ----------------
\\[allout-hide-current-subtree]   `allout-hide-current-subtree'
\\[allout-show-children] `allout-show-children'
\\[allout-show-current-subtree] `allout-show-current-subtree'
\\[allout-show-current-entry] `allout-show-current-entry'
\\[allout-show-all]   `allout-show-all'

        Navigation:
        ----------
\\[allout-next-visible-heading] `allout-next-visible-heading'
\\[allout-previous-visible-heading] `allout-previous-visible-heading'
\\[allout-up-current-level] `allout-up-current-level'
\\[allout-forward-current-level] `allout-forward-current-level'
\\[allout-backward-current-level] `allout-backward-current-level'
\\[allout-end-of-entry] `allout-end-of-entry'
\\[allout-beginning-of-current-entry] `allout-beginning-of-current-entry' (alternately, goes to hot-spot)
\\[allout-beginning-of-line]  `allout-beginning-of-line' -- like regular beginning-of-line, but
     if immediately repeated cycles to the beginning of the current item
     and then to the hot-spot (if `allout-beginning-of-line-cycles' is set).


        Topic Header Production:
        -----------------------
\\[allout-open-sibtopic] `allout-open-sibtopic' Create a new sibling after current topic.
\\[allout-open-subtopic]   `allout-open-subtopic' ... an offspring of current topic.
\\[allout-open-supertopic] `allout-open-supertopic' ... a sibling of the current topic's parent.

        Topic Level and Prefix Adjustment:
        ---------------------------------
\\[allout-shift-in] `allout-shift-in'   Shift current topic and all offspring deeper
\\[allout-shift-out] `allout-shift-out' ... less deep
\\[allout-rebullet-current-heading] `allout-rebullet-current-heading' Prompt for alternate bullet for
            current topic
\\[allout-rebullet-topic] `allout-rebullet-topic'   Reconcile bullets of topic and
            its offspring -- distinctive bullets are not changed, others
            are alternated according to nesting depth.
\\[allout-number-siblings] `allout-number-siblings'  Number bullets of topic and siblings --
           the offspring are not affected.
           With repeat count, revoke numbering.

        Topic-oriented Killing and Yanking:
        ----------------------------------
\\[allout-kill-topic] `allout-kill-topic'   Kill current topic, including offspring.
\\[allout-copy-topic-as-kill] `allout-copy-topic-as-kill' Copy current topic, including offspring.
\\[allout-kill-line]     `allout-kill-line'    Kill line, attending to outline structure.
\\[allout-copy-line-as-kill]     `allout-copy-line-as-kill' Copy line but don't delete it.
\\[allout-yank] `allout-yank'        Yank, adjusting depth of yanked topic to
                             depth of heading if yanking into bare topic
                             heading (ie, prefix sans text).
\\[allout-yank-pop]     `allout-yank-pop'       Is to `allout-yank' as `yank-pop' is to `yank'.

        Topic-oriented Encryption:
        -------------------------
\\[allout-toggle-current-subtree-encryption] `allout-toggle-current-subtree-encryption'
          Encrypt/Decrypt topic content

        Misc commands:
        -------------
\\[allout-outlinify-sticky] Activate outline mode for current buffer,
                            and establish a default file-var setting
                            for `allout-layout'.
\\[allout-mark-topic]       `allout-mark-topic'
\\[allout-copy-exposed-to-buffer] `allout-copy-exposed-to-buffer'
                            Duplicate outline, sans concealed text, to
                            buffer with name derived from derived from that
                            of current buffer -- \"*BUFFERNAME exposed*\".
\\[allout-flatten-exposed-to-buffer] `allout-flatten-exposed-to-buffer'
                            Like above `copy-exposed', but convert topic
                            prefixes to section.subsection... numeric
                            format.
\\[customize-variable] allout-auto-activation
                            Prepare Emacs session for allout outline mode
                            auto-activation.

                  Topic Encryption

Outline mode supports gpg encryption of topics, with support for
symmetric and key-pair modes, and auto-encryption of topics
pending encryption on save.

Topics pending encryption are, by default, automatically
encrypted during file saves, including checkpoint saves, to avoid
exposing the plain text of encrypted topics in the file system.
If the content of the topic containing the cursor was encrypted
for a save, it is automatically decrypted for continued editing.

NOTE: A few GnuPG v2 versions improperly preserve incorrect
symmetric decryption keys, preventing entry of the correct key on
subsequent decryption attempts until the cache times-out.  That
can take several minutes.  (Decryption of other entries is not
affected.)  Upgrade your EasyPG version, if you can, and you can
deliberately clear your gpg-agent's cache by sending it a `-HUP'
signal.

See `allout-toggle-current-subtree-encryption' function docstring
and `allout-encrypt-unencrypted-on-saves' customization variable
for details.

                 HOT-SPOT Operation

Hot-spot operation provides a means for easy, single-keystroke outline
navigation and exposure control.

When the text cursor is positioned directly on the bullet character of
a topic, regular characters (a to z) invoke the commands of the
corresponding allout-mode keymap control chars.  For example, \"f\"
would invoke the command typically bound to \"C-c<space>C-f\"
(\\[allout-forward-current-level] `allout-forward-current-level').

Thus, by positioning the cursor on a topic bullet, you can
execute the outline navigation and manipulation commands with a
single keystroke.  Regular navigation keys (eg, \\[forward-char], \\[next-line]) don't get
this special translation, so you can use them to get out of the
hot-spot and back to normal editing operation.

In allout-mode, the normal beginning-of-line command (\\[allout-beginning-of-line]) is
replaced with one that makes it easy to get to the hot-spot.  If you
repeat it immediately it cycles (if `allout-beginning-of-line-cycles'
is set) to the beginning of the item and then, if you hit it again
immediately, to the hot-spot.  Similarly, `allout-beginning-of-current-entry'
(\\[allout-beginning-of-current-entry]) moves to the hot-spot when the cursor is already located
at the beginning of the current entry.

                             Extending Allout

Allout exposure and authoring activities all have associated
hooks, by which independent code can cooperate with allout
without changes to the allout core.  Here are key ones:

`allout-mode-hook'
`allout-mode-off-hook'
`allout-exposure-change-functions'
`allout-structure-added-functions'
`allout-structure-deleted-functions'
`allout-structure-shifted-functions'
`allout-after-copy-or-kill-hook'
`allout-post-undo-hook'

                            Terminology

Topic hierarchy constituents -- TOPICS and SUBTOPICS:

ITEM:   A unitary outline element, including the HEADER and ENTRY text.
TOPIC:  An ITEM and any ITEMs contained within it, ie having greater DEPTH
        and with no intervening items of lower DEPTH than the container.
CURRENT ITEM:
        The visible ITEM most immediately containing the cursor.
DEPTH:  The degree of nesting of an ITEM; it increases with containment.
        The DEPTH is determined by the HEADER PREFIX.  The DEPTH is also
        called the:
LEVEL:  The same as DEPTH.

ANCESTORS:
        Those ITEMs whose TOPICs contain an ITEM.
PARENT: An ITEM's immediate ANCESTOR.  It has a DEPTH one less than that
        of the ITEM.
OFFSPRING:
        The ITEMs contained within an ITEM's TOPIC.
SUBTOPIC:
        An OFFSPRING of its ANCESTOR TOPICs.
CHILD:
        An immediate SUBTOPIC of its PARENT.
SIBLINGS:
        TOPICs having the same PARENT and DEPTH.

Topic text constituents:

HEADER: The first line of an ITEM, include the ITEM PREFIX and HEADER
        text.
ENTRY:  The text content of an ITEM, before any OFFSPRING, but including
        the HEADER text and distinct from the ITEM PREFIX.
BODY:   Same as ENTRY.
PREFIX: The leading text of an ITEM which distinguishes it from normal
        ENTRY text.  Allout recognizes the outline structure according
        to the strict PREFIX format.  It consists of a PREFIX-LEAD string,
        PREFIX-PADDING, and a BULLET.  The BULLET might be followed by a
        number, indicating the ordinal number of the topic among its
        siblings, or an asterisk indicating encryption, plus an optional
        space.  After that is the ITEM HEADER text, which is not part of
        the PREFIX.

        The relative length of the PREFIX determines the nesting DEPTH
        of the ITEM.
PREFIX-LEAD:
        The string at the beginning of a HEADER PREFIX, by default a `.'.
        It can be customized by changing the setting of
        `allout-header-prefix' and then reinitializing `allout-mode'.

        When the PREFIX-LEAD is set to the comment-string of a
        programming language, outline structuring can be embedded in
        program code without interfering with processing of the text
        (by Emacs or the language processor) as program code.  This
        setting happens automatically when allout mode is used in
        programming-mode buffers.  See `allout-use-mode-specific-leader'
        docstring for more detail.
PREFIX-PADDING:
        Spaces or asterisks which separate the PREFIX-LEAD and the
        bullet, determining the ITEM's DEPTH.
BULLET: A character at the end of the ITEM PREFIX, it must be one of
        the characters listed on `allout-plain-bullets-string' or
        `allout-distinctive-bullets-string'.  When creating a TOPIC,
        plain BULLETs are by default used, according to the DEPTH of the
        TOPIC.  Choice among the distinctive BULLETs is offered when you
        provide a universal argument (\\[universal-argument]) to the
        TOPIC creation command, or when explicitly rebulleting a TOPIC.  The
        significance of the various distinctive bullets is purely by
        convention.  See the documentation for the above bullet strings for
        more details.
EXPOSURE:
        The state of a TOPIC which determines the on-screen visibility
        of its OFFSPRING and contained ENTRY text.
CONCEALED:
        TOPICs and ENTRY text whose EXPOSURE is inhibited.  Concealed
        text is represented by \"...\" ellipses.

        CONCEALED TOPICs are effectively collapsed within an ANCESTOR.
CLOSED: A TOPIC whose immediate OFFSPRING and body-text is CONCEALED.
OPEN:	A TOPIC that is not CLOSED, though its OFFSPRING or BODY may be.

This is a minor mode.  If called interactively, toggle the `Allout mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `allout-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(define-obsolete-function-alias 'outlinify-sticky #'allout-outlinify-sticky "29.1")
(define-obsolete-function-alias 'outlineify-sticky #'allout-outlinify-sticky "29.1")
(autoload 'allout-outlinify-sticky "allout" "\
Activate outline mode and establish file var so it is started subsequently.

See `allout-layout' and customization of `allout-auto-activation'
for details on preparing Emacs for automatic allout activation.

(fn &optional ARG)" t)
(register-definition-prefixes "allout" '("allout-"))


;;; Generated autoloads from allout-widgets.el

(push (purecopy '(allout-widgets 1 0)) package--builtin-versions)
(autoload 'allout-widgets-setup "allout-widgets" "\
Commission or decommission `allout-widgets-mode' along with `allout-mode'.

Meant to be used by customization of `allout-widgets-auto-activation'.

(fn VARNAME VALUE)")
(defvar allout-widgets-auto-activation nil "\
Activate to enable allout icon graphics wherever allout mode is active.

Also enable `allout-auto-activation' for this to take effect upon
visiting an outline.

When this is set you can disable allout widgets in select files
by setting `allout-widgets-mode-inhibit'.

Instead of setting `allout-widgets-auto-activation' you can
explicitly invoke `allout-widgets-mode' in allout buffers where
you want allout widgets operation.

See `allout-widgets-mode' for allout widgets mode features.")
(custom-autoload 'allout-widgets-auto-activation "allout-widgets" nil)
(put 'allout-widgets-mode-inhibit 'safe-local-variable #'booleanp)
(autoload 'allout-widgets-mode "allout-widgets" "\
Toggle Allout Widgets mode.

Allout Widgets mode is an extension of Allout mode that provides
graphical decoration of outline structure.  It is meant to
operate along with `allout-mode', via `allout-mode-hook'.

The graphics include:

- guide lines connecting item bullet-icons with those of their subitems.

- icons for item bullets, varying to indicate whether or not the item
  has subitems, and if so, whether or not the item is expanded.

- cue area between the bullet-icon and the start of the body headline,
  for item numbering, encryption indicator, and distinctive bullets.

The bullet-icon and guide line graphics provide keybindings and mouse
bindings for easy outline navigation and exposure control, extending
outline hot-spot navigation (see `allout-mode').

This is a minor mode.  If called interactively, toggle the
`Allout-Widgets mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `allout-widgets-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "allout-widgets" '("allout-"))


;;; Generated autoloads from cedet/semantic/analyze.el

(register-definition-prefixes "semantic/analyze" '("semantic-a"))


;;; Generated autoloads from net/ange-ftp.el

(define-obsolete-function-alias 'ange-ftp-re-read-dir #'ange-ftp-reread-dir "29.1")
(autoload 'ange-ftp-reread-dir "ange-ftp" "\
Reread remote directory DIR to update the directory cache.
The implementation of remote FTP file names caches directory contents
for speed.  Therefore, when new remote files are created, Emacs
may not know they exist.  You can use this command to reread a specific
directory, so that Emacs will know its current contents.

(fn &optional DIR)" t)
(autoload 'ange-ftp-hook-function "ange-ftp" "\


(fn OPERATION &rest ARGS)")
(register-definition-prefixes "ange-ftp" '("ange-ftp-" "ftp-error" "internal-ange-ftp-mode"))


;;; Generated autoloads from play/animate.el

(autoload 'animate-string "animate" "\
Display STRING animations starting at position VPOS, HPOS.
The characters start at randomly chosen places,
and all slide in parallel to their final positions,
passing through `animate-n-steps' positions before the final ones.
If HPOS is nil (or omitted), center the string horizontally
in the current window.

(fn STRING VPOS &optional HPOS)")
(autoload 'animate-sequence "animate" "\
Display animation strings from LIST-OF-STRING with buffer *Animation*.
Strings will be separated from each other by SPACE lines.
 When the variable `animation-buffer-name' is non-nil display
animation in the buffer named by variable's value, creating the
buffer if one does not exist.

(fn LIST-OF-STRINGS SPACE)")
(autoload 'animate-birthday-present "animate" "\
Return a birthday present in the buffer *Birthday-Present*.
When optional arg NAME is non-nil or called-interactively, prompt for
NAME of birthday present receiver and return a birthday present in
the buffer *Birthday-Present-for-Name*.

(fn &optional NAME)" t)
(register-definition-prefixes "animate" '("animat"))


;;; Generated autoloads from ansi-color.el

(push (purecopy '(ansi-color 3 4 2)) package--builtin-versions)
(autoload 'ansi-color-for-comint-mode-on "ansi-color" "\
Set `ansi-color-for-comint-mode' to t." t)
(autoload 'ansi-color-process-output "ansi-color" "\
Maybe translate SGR control sequences of comint output into text properties.

Depending on variable `ansi-color-for-comint-mode' the comint output is
either not processed, SGR control sequences are filtered using
`ansi-color-filter-region', or SGR control sequences are translated into
text properties using `ansi-color-apply-on-region'.

The comint output is assumed to lie between the marker
`comint-last-output-start' and the process-mark.

This is a good function to put in `comint-output-filter-functions'.

(fn IGNORED)")
(autoload 'ansi-color-compilation-filter "ansi-color" "\
Maybe translate SGR control sequences into text properties.
This function depends on the `ansi-color-for-compilation-mode'
variable, and is meant to be used in `compilation-filter-hook'.")
(register-definition-prefixes "ansi-color" '("ansi-color-"))


;;; Generated autoloads from ansi-osc.el

(autoload 'ansi-osc-compilation-filter "ansi-osc" "\
Maybe collect OSC control sequences.
This function depends on the variable `ansi-osc-for-compilation-buffer',
and is meant to be used in `compilation-filter-hook'.")
(register-definition-prefixes "ansi-osc" '("ansi-osc-"))


;;; Generated autoloads from progmodes/antlr-mode.el

(push (purecopy '(antlr-mode 2 2 3)) package--builtin-versions)
(autoload 'antlr-show-makefile-rules "antlr-mode" "\
Show Makefile rules for all grammar files in the current directory.
If the `major-mode' of the current buffer has the value `makefile-mode',
the rules are directory inserted at point.  Otherwise, a *Help* buffer
is shown with the rules which are also put into the `kill-ring' for
\\[yank].

This command considers import/export vocabularies and grammar
inheritance and provides a value for the \"-glib\" option if necessary.
Customize variable `antlr-makefile-specification' for the appearance of
the rules.

If the file for a super-grammar cannot be determined, special file names
are used according to variable `antlr-unknown-file-formats' and a
commentary with value `antlr-help-unknown-file-text' is added.  The
*Help* buffer always starts with the text in `antlr-help-rules-intro'." t)
(autoload 'antlr-mode "antlr-mode" "\
Major mode for editing ANTLR grammar files.

(fn)" t)
(autoload 'antlr-set-tabs "antlr-mode" "\
Use ANTLR's convention for TABs according to `antlr-tab-offset-alist'.
Used in `antlr-mode'.  Also a useful function in `java-mode-hook'.")
(register-definition-prefixes "antlr-mode" '("antlr-"))


;;; Generated autoloads from calendar/appt.el

(autoload 'appt-add "appt" "\
Add an appointment for today at TIME with message MSG.
The time should be in either 24 hour format or am/pm format.
Optional argument WARNTIME is an integer (or string) giving the number
of minutes before the appointment at which to start warning.
The default is `appt-message-warning-time'.

(fn TIME MSG &optional WARNTIME)" t)
(autoload 'appt-activate "appt" "\
Toggle checking of appointments.
With optional numeric argument ARG, turn appointment checking on if
ARG is positive, otherwise off.

(fn &optional ARG)" t)
(register-definition-prefixes "appt" '("appt-"))


;;; Generated autoloads from apropos.el

(autoload 'apropos-read-pattern "apropos" "\
Read an apropos pattern, either a word list or a regexp.
Returns the user pattern, either a list of words which are matched
literally, or a string which is used as a regexp to search for.

SUBJECT is a string that is included in the prompt to identify what
kind of objects to search.

(fn SUBJECT)")
(autoload 'apropos-user-option "apropos" "\
Show user options that match PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also show
variables, not just user options.

(fn PATTERN &optional DO-ALL)" t)
(autoload 'apropos-variable "apropos" "\
Show variables that match PATTERN.
With the optional argument DO-NOT-ALL non-nil (or when called
interactively with the prefix \\[universal-argument]), show user
options only, i.e. behave like `apropos-user-option'.

(fn PATTERN &optional DO-NOT-ALL)" t)
(autoload 'apropos-local-variable "apropos" "\
Show buffer-local variables that match PATTERN.
Optional arg BUFFER (default: current buffer) is the buffer to check.

The output includes variables that are not yet set in BUFFER, but that
will be buffer-local when set.

(fn PATTERN &optional BUFFER)" t)
(autoload 'apropos-function "apropos" "\
Show functions that match PATTERN.

PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

This is the same as running `apropos-command' with a \\[universal-argument] prefix,
or a non-nil `apropos-do-all' argument.

(fn PATTERN)" t)
(defalias 'command-apropos #'apropos-command)
(autoload 'apropos-command "apropos" "\
Show commands (interactively callable functions) that match PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also show
noninteractive functions.

If VAR-PREDICATE is non-nil, show only variables, and only those that
satisfy the predicate VAR-PREDICATE.

When called from a Lisp program, a string PATTERN is used as a regexp,
while a list of strings is used as a word list.

(fn PATTERN &optional DO-ALL VAR-PREDICATE)" t)
(autoload 'apropos-documentation-property "apropos" "\
Like (documentation-property SYMBOL PROPERTY RAW) but handle errors.

(fn SYMBOL PROPERTY RAW)")
(autoload 'apropos "apropos" "\
Show all meaningful Lisp symbols whose names match PATTERN.
Symbols are shown if they are defined as functions, variables, or
faces, or if they have nonempty property lists, or if they are
known keywords.

PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil,
consider all symbols (if they match PATTERN).

Return list of symbols and documentation found.

The *Apropos* window will be selected if `help-window-select' is
non-nil.

(fn PATTERN &optional DO-ALL)" t)
(autoload 'apropos-library "apropos" "\
List the variables and functions defined by library FILE.
FILE should be one of the libraries currently loaded and should
thus be found in `load-history'.  If `apropos-do-all' is non-nil,
the output includes key-bindings of commands.

(fn FILE)" t)
(autoload 'apropos-value "apropos" "\
Show all symbols whose value's printed representation matches PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also looks
at function definitions (arguments, documentation and body) and at the
names and values of properties.

Returns list of symbols and values found.

(fn PATTERN &optional DO-ALL)" t)
(autoload 'apropos-local-value "apropos" "\
Show buffer-local variables whose values match PATTERN.
This is like `apropos-value', but only for buffer-local variables.
Optional arg BUFFER (default: current buffer) is the buffer to check.

(fn PATTERN &optional BUFFER)" t)
(autoload 'apropos-documentation "apropos" "\
Show symbols whose documentation contains matches for PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

Note that by default this command only searches in the functions predefined
at Emacs startup, i.e., the primitives implemented in C or preloaded in the
Emacs dump image.
With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, it searches
all currently defined documentation strings.

Returns list of symbols and documentation found.

(fn PATTERN &optional DO-ALL)" t)
(register-definition-prefixes "apropos" '("apropos-"))


;;; Generated autoloads from arc-mode.el

(autoload 'archive-mode "arc-mode" "\
Major mode for viewing an archive file in a dired-like way.
You can move around using the usual cursor motion commands.
Letters no longer insert themselves.\\<archive-mode-map>
Type \\[archive-extract] to pull a file out of the archive and into its own buffer;
or click mouse-2 on the file's line in the archive mode buffer.

If you edit a sub-file of this archive (as with the \\[archive-extract] command) and
save it, the contents of that buffer will be saved back into the
archive.

\\{archive-mode-map}

(fn &optional FORCE)")
(register-definition-prefixes "arc-mode" '("arc" "tar-archive-from-tar"))


;;; Generated autoloads from cedet/srecode/args.el

(register-definition-prefixes "srecode/args" '("srecode-"))


;;; Generated autoloads from array.el

(autoload 'array-mode "array" "\
Major mode for editing arrays.

  Array mode is a specialized mode for editing arrays.  An array is
considered to be a two-dimensional set of strings.  The strings are
NOT recognized as integers or real numbers.

  The array MUST reside at the top of the buffer.

  TABs are not respected, and may be converted into spaces at any time.
Setting the variable `array-respect-tabs' to non-nil will prevent
TAB conversion, but will cause many functions to give errors if
they encounter one.

  Upon entering array mode, you will be prompted for the values of
several variables.  Others will be calculated based on the values you
supply.  These variables are all local to the buffer.  Other buffer
in array mode may have different values assigned to the variables.
The variables are:

Variables you assign:
     `array-max-row':          The number of rows in the array.
     `array-max-column':       The number of columns in the array.
     `array-columns-per-line': The number of columns in the array
                             per line of buffer.
     `array-field-width':      The width of each field, in characters.
     `array-rows-numbered':    A logical variable describing whether to ignore
                             row numbers in the buffer.

Variables which are calculated:
     `array-line-length':      The number of characters in a buffer line.
     `array-lines-per-row':    The number of buffer lines used to
                             display each row.

  The following commands are available (an asterisk indicates it may
take a numeric prefix argument):

    *  	\\<array-mode-map>\\[array-forward-column]	  Move forward one column.
    *  	\\[array-backward-column]	  Move backward one column.
    *  	\\[array-next-row]	  Move down one row.
    *  	\\[array-previous-row]	  Move up one row.

    *   \\[array-copy-forward]	  Copy current field into the column to the right.
    *   \\[array-copy-backward]	  Copy current field into the column to the left.
    *   \\[array-copy-down]	  Copy current field into the row below.
    *   \\[array-copy-up]	  Copy current field into the row above.

    *   \\[array-copy-column-forward]   Copy current column into the column to the right.
    *   \\[array-copy-column-backward]   Copy current column into the column to the left.
    *   \\[array-copy-row-down]   Copy the current row into the row below.
    *   \\[array-copy-row-up]   Copy the current row into the row above.

        \\[array-fill-rectangle]   Copy field at mark into every cell with row and column
                  between that of point and mark.

	\\[array-what-position]	  Display the current array row and column.
	\\[array-goto-cell]	  Go to a particular array cell.

	\\[array-make-template]	  Make a template for a new array.
	\\[array-reconfigure-rows]	  Reconfigure the array.
        \\[array-expand-rows]   Expand the array (remove row numbers and
                  newlines inside rows)

        \\[array-display-local-variables]   Display current values of local variables.

Entering array mode calls the function `array-mode-hook'.

(fn)" t)
(register-definition-prefixes "array" '("array-"))


;;; Generated autoloads from textmodes/artist.el

(autoload 'artist-mode "artist" "\
Toggle Artist mode.

Artist lets you draw lines, squares, rectangles and poly-lines,
ellipses and circles with your mouse and/or keyboard.

How to quit Artist mode

 Type \\[artist-mode-off] to quit artist-mode.


How to submit a bug report

 Type \\[artist-submit-bug-report] to submit a bug report.


Drawing with the mouse:

 mouse-2
 shift mouse-2	Pops up a menu where you can select what to draw with
		mouse-1, and where you can do some settings (described
		below).

 mouse-1
 shift mouse-1	Draws lines, rectangles or poly-lines, erases, cuts, copies
		or pastes:

		Operation	Not shifted		  Shifted
		--------------------------------------------------------------
                Pen             fill-char at point        line from last point
                                                          to new point
		--------------------------------------------------------------
		Line		Line in any direction	  Straight line
		--------------------------------------------------------------
		Rectangle	Rectangle		  Square
		--------------------------------------------------------------
		Poly-line	Poly-line in any dir	  Straight poly-lines
		--------------------------------------------------------------
		Ellipses	Ellipses		  Circles
		--------------------------------------------------------------
		Text		Text (see thru)		  Text (overwrite)
		--------------------------------------------------------------
		Spray-can	Spray-can		  Set size for spray
		--------------------------------------------------------------
		Erase		Erase character		  Erase rectangle
		--------------------------------------------------------------
		Vaporize	Erase single line	  Erase connected
							  lines
		--------------------------------------------------------------
		Cut		Cut rectangle		  Cut square
		--------------------------------------------------------------
		Copy		Copy rectangle		  Copy square
		--------------------------------------------------------------
		Paste		Paste			  Paste
		--------------------------------------------------------------
		Flood-fill	Flood-fill		  Flood-fill
		--------------------------------------------------------------

		* Straight lines can only go horizontally, vertically
		  or diagonally.

		* Poly-lines are drawn while holding mouse-1 down.  When you
		  release the button, the point is set.  If you want a segment
		  to be straight, hold down shift before pressing the
		  mouse-1 button.  Click mouse-2 or mouse-3 to stop drawing
		  poly-lines.

		* See thru for text means that text already in the buffer
		  will be visible through blanks in the text rendered, while
		  overwrite means the opposite.

		* Vaporizing connected lines only vaporizes lines whose
		  _endpoints_ are connected.  See also the variable
		  `artist-vaporize-fuzziness'.

		* Cut copies, then clears the rectangle/square.

		* When drawing lines or poly-lines, you can set arrows.
		  See below under \"Arrows\" for more info.

		* The mode line shows the currently selected drawing operation.
		  In addition, if it has an asterisk (*) at the end, you
		  are currently drawing something.

		* Be patient when flood-filling -- large areas take quite
		  some time to fill.


 mouse-3	Erases character under pointer
 shift mouse-3	Erases rectangle


Settings

 Set fill	Sets the character used when filling rectangles/squares

 Set line	Sets the character used when drawing lines

 Erase char	Sets the character used when erasing

 Rubber-banding	Toggles rubber-banding

 Trimming	Toggles trimming of line-endings (that is: when the shape
		is drawn, extraneous white-space at end of lines is removed)

 Borders        Toggles the drawing of line borders around filled shapes


Drawing with keys

 \\[artist-key-set-point]		Does one of the following:
		For lines/rectangles/squares: sets the first/second endpoint
                For poly-lines: sets a point (use \\[universal-argument] \\[artist-key-set-point] to set last point)
		When erase characters: toggles erasing
		When cutting/copying: Sets first/last endpoint of rect/square
		When pasting: Pastes

 \\[artist-select-operation]	Selects what to draw

 Move around with \\[artist-next-line], \\[artist-previous-line], \\[artist-forward-char] and \\[artist-backward-char].

 \\[artist-select-fill-char]	Sets the character to use when filling
 \\[artist-select-line-char]	Sets the character to use when drawing
 \\[artist-select-erase-char]	Sets the character to use when erasing
 \\[artist-toggle-rubber-banding]	Toggles rubber-banding
 \\[artist-toggle-trim-line-endings]	Toggles trimming of line-endings
 \\[artist-toggle-borderless-shapes]	Toggles borders on drawn shapes


Arrows

 \\[artist-toggle-first-arrow]		Sets/unsets an arrow at the beginning
		of the line/poly-line

 \\[artist-toggle-second-arrow]		Sets/unsets an arrow at the end
		of the line/poly-line


Selecting operation

 There are some keys for quickly selecting drawing operations:

 \\[artist-select-op-line]	Selects drawing lines
 \\[artist-select-op-straight-line]	Selects drawing straight lines
 \\[artist-select-op-rectangle]	Selects drawing rectangles
 \\[artist-select-op-square]	Selects drawing squares
 \\[artist-select-op-poly-line]	Selects drawing poly-lines
 \\[artist-select-op-straight-poly-line]	Selects drawing straight poly-lines
 \\[artist-select-op-ellipse]	Selects drawing ellipses
 \\[artist-select-op-circle]	Selects drawing circles
 \\[artist-select-op-text-see-thru]	Selects rendering text (see thru)
 \\[artist-select-op-text-overwrite]	Selects rendering text (overwrite)
 \\[artist-select-op-spray-can]	Spray with spray-can
 \\[artist-select-op-spray-set-size]	Set size for the spray-can
 \\[artist-select-op-erase-char]	Selects erasing characters
 \\[artist-select-op-erase-rectangle]	Selects erasing rectangles
 \\[artist-select-op-vaporize-line]	Selects vaporizing single lines
 \\[artist-select-op-vaporize-lines]	Selects vaporizing connected lines
 \\[artist-select-op-cut-rectangle]	Selects cutting rectangles
 \\[artist-select-op-copy-rectangle]	Selects copying rectangles
 \\[artist-select-op-paste]	Selects pasting
 \\[artist-select-op-flood-fill]	Selects flood-filling


Variables

 This is a brief overview of the different variables.  For more info,
 see the documentation for the variables (type \\[describe-variable] <variable> RET).

 `artist-rubber-banding'              Interactively do rubber-banding or not
 `artist-first-char'                  What to set at first/second point...
 `artist-second-char'                 ...when not rubber-banding
 `artist-interface-with-rect'         Should cut/copy/paste interface with rect
 `artist-arrows'                      The arrows to use when drawing arrows
 `artist-aspect-ratio'                Character height-to-width for squares
 `artist-trim-line-endings'           Trimming of line endings
 `artist-flood-fill-right-border'     Right border when flood-filling
 `artist-flood-fill-show-incrementally'  Update display while filling
 `artist-pointer-shape'               Pointer shape to use while drawing
 `artist-ellipse-left-char'           Character to use for narrow ellipses
 `artist-ellipse-right-char'          Character to use for narrow ellipses
 `artist-borderless-shapes'           If shapes should have borders
 `artist-picture-compatibility'       Picture mode compatibility on or off
 `artist-vaporize-fuzziness'          Tolerance when recognizing lines
 `artist-spray-interval'              Seconds between repeated sprayings
 `artist-spray-radius'                Size of the spray-area
 `artist-spray-chars'                 The spray-\"color\"
 `artist-spray-new-char'              Initial spray-\"color\"

Hooks

 Turning the mode on or off runs `artist-mode-hook'.


Keymap summary

\\{artist-mode-map}

This is a minor mode.  If called interactively, toggle the `Artist mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `artist-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "artist" '("artist-"))


;;; Generated autoloads from progmodes/asm-mode.el

(autoload 'asm-mode "asm-mode" "\
Major mode for editing typical assembler code.
Features a private abbrev table and the following bindings:

\\[asm-colon]	outdent a preceding label, tab to next tab stop.
\\[tab-to-tab-stop]	tab to next tab stop.
\\[newline-and-indent]	newline, then tab to next tab stop.
\\[asm-comment]	smart placement of assembler comments.

The character used for making comments is set by the variable
`asm-comment-char' (which defaults to `?\\;').

Alternatively, you may set this variable in `asm-mode-set-comment-hook',
which is called near the beginning of mode initialization.

Turning on Asm mode runs the hook `asm-mode-hook' at the end of initialization.

Special commands:
\\{asm-mode-map}

(fn)" t)
(register-definition-prefixes "asm-mode" '("asm-"))


;;; Generated autoloads from auth-source.el

(defvar auth-source-cache-expiry 7200 "\
How many seconds passwords are cached, or nil to disable expiring.
Overrides `password-cache-expiry' through a let-binding.")
(custom-autoload 'auth-source-cache-expiry "auth-source" t)
(autoload 'auth-source-netrc-parse-all "auth-source" "\
Parse FILE and return all entries.

(fn FILE)")
(autoload 'authinfo-mode "auth-source" "\
Mode for editing .authinfo/.netrc files.

This is just like `fundamental-mode', but has basic syntax
highlighting and hides passwords.  Passwords are revealed when
point is moved into the passwords (see `authinfo-hide-elements').

\\{authinfo-mode-map}

(fn)" t)
(autoload 'read-passwd "auth-source" "\
Read a password, prompting with PROMPT, and return it.
If optional CONFIRM is non-nil, read the password twice to make sure.
Optional DEFAULT is a default password to use instead of empty input.

This function echoes `*' for each character that the user types.
You could let-bind `read-hide-char' to another hiding character, though.

Once the caller uses the password, it can erase the password
by doing (clear-string STRING).

(fn PROMPT &optional CONFIRM DEFAULT)")
(register-definition-prefixes "auth-source" '("auth" "read-passwd-"))


;;; Generated autoloads from auth-source-pass.el

(push (purecopy '(auth-source-pass 5 0 0)) package--builtin-versions)
(autoload 'auth-source-pass-enable "auth-source-pass" "\
Enable auth-source-password-store.")
(autoload 'auth-source-pass-get "auth-source-pass" "\
Return the value associated to KEY in the password-store entry ENTRY.

ENTRY is the name of a password-store entry.
The key used to retrieve the password is the symbol `secret'.

The convention used as the format for a password-store file is
the following (see URL `https://www.passwordstore.org/#organization'):

secret
key1: value1
key2: value2

(fn KEY ENTRY)")
(register-definition-prefixes "auth-source-pass" '("auth-source-pass-"))


;;; Generated autoloads from cedet/ede/auto.el

(autoload 'ede-add-project-autoload "ede/auto" "\
Add PROJAUTO, an EDE autoload definition to `ede-project-class-files'.
Optional argument FLAG indicates how this autoload should be
added.  Possible values are:
  `generic' - A generic project type.  Keep this at the very end.
  `unique' - A unique project type for a specific project.  Keep at the very
             front of the list so more generic projects don't get priority.

(fn PROJAUTO &optional FLAG)")
(register-definition-prefixes "ede/auto" '("ede-"))


;;; Generated autoloads from progmodes/autoconf.el

(autoload 'autoconf-mode "autoconf" "\
Major mode for editing Autoconf configure.ac files.

(fn)" t)
(register-definition-prefixes "autoconf" '("autoconf-"))


;;; Generated autoloads from cedet/ede/autoconf-edit.el

(register-definition-prefixes "ede/autoconf-edit" '("autoconf-"))


;;; Generated autoloads from autoinsert.el

(put 'auto-insert 'safe-local-variable #'null)
(autoload 'auto-insert "autoinsert" "\
Insert default contents into new files if variable `auto-insert' is non-nil.
Matches the visited file name against the elements of `auto-insert-alist'." t)
(autoload 'define-auto-insert "autoinsert" "\
Associate CONDITION with (additional) ACTION in `auto-insert-alist'.
Optional AFTER means to insert action after all existing actions for CONDITION,
or if CONDITION had no actions, after all other CONDITIONs.

(fn CONDITION ACTION &optional AFTER)")
(function-put 'define-auto-insert 'lisp-indent-function 'defun)
(defvar auto-insert-mode nil "\
Non-nil if Auto-Insert mode is enabled.
See the `auto-insert-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `auto-insert-mode'.")
(custom-autoload 'auto-insert-mode "autoinsert" nil)
(autoload 'auto-insert-mode "autoinsert" "\
Toggle Auto-insert mode, a global minor mode.

When Auto-insert mode is enabled, when new files are created you can
insert a template for the file depending on the mode of the buffer.

This is a global minor mode.  If called interactively, toggle the
`Auto-Insert mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='auto-insert-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "autoinsert" '("auto-insert"))


;;; Generated autoloads from autorevert.el

(autoload 'auto-revert-mode "autorevert" "\
Toggle reverting buffer when the file changes (Auto-Revert Mode).

Auto-Revert Mode is a minor mode that affects only the current
buffer.  When enabled, it reverts the buffer when the file on
disk changes.

When a buffer is reverted, a message is generated.  This can be
suppressed by setting `auto-revert-verbose' to nil.

Reverting can sometimes fail to preserve all the markers in the buffer.
To avoid that, set `revert-buffer-insert-file-contents-function' to
the slower function `revert-buffer-insert-file-contents-delicately'.

Use `global-auto-revert-mode' to automatically revert all buffers.
Use `auto-revert-tail-mode' if you know that the file will only grow
without being changed in the part that is already in the buffer.

This is a minor mode.  If called interactively, toggle the `Auto-Revert
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `auto-revert-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'turn-on-auto-revert-mode "autorevert" "\
Turn on Auto-Revert Mode.

This function is designed to be added to hooks, for example:
  (add-hook \\='c-mode-hook #\\='turn-on-auto-revert-mode)")
(autoload 'auto-revert-tail-mode "autorevert" "\
Toggle reverting tail of buffer when the file grows.

When Auto-Revert Tail Mode is enabled, the tail of the file is
constantly followed, as with the shell command `tail -f'.  This
means that whenever the file grows on disk (presumably because
some background process is appending to it from time to time),
this is reflected in the current buffer.

You can edit the buffer and turn this mode off and on again as
you please.  But make sure the background process has stopped
writing before you save the file!

When a buffer is reverted, a message is generated.  This can be
suppressed by setting `auto-revert-verbose' to nil.

Use `auto-revert-mode' for changes other than appends!

This is a minor mode.  If called interactively, toggle the
`Auto-Revert-Tail mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `auto-revert-tail-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'turn-on-auto-revert-tail-mode "autorevert" "\
Turn on Auto-Revert Tail Mode.

This function is designed to be added to hooks, for example:
  (add-hook \\='my-logfile-mode-hook #\\='turn-on-auto-revert-tail-mode)")
(defvar global-auto-revert-mode nil "\
Non-nil if Global Auto-Revert mode is enabled.
See the `global-auto-revert-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-auto-revert-mode'.")
(custom-autoload 'global-auto-revert-mode "autorevert" nil)
(autoload 'global-auto-revert-mode "autorevert" "\
Toggle Global Auto-Revert Mode.

Global Auto-Revert Mode is a global minor mode that reverts any
buffer associated with a file when the file changes on disk.  Use
`auto-revert-mode' to revert a particular buffer.

If `global-auto-revert-non-file-buffers' is non-nil, this mode
may also revert some non-file buffers, as described in the
documentation of that variable.  It ignores buffers with modes
matching `global-auto-revert-ignore-modes', and buffers with a
non-nil value of `global-auto-revert-ignore-buffer'.

When a buffer is reverted, a message is generated.  This can be
suppressed by setting `auto-revert-verbose' to nil.

This function calls the hook `global-auto-revert-mode-hook'.
It displays the text that `global-auto-revert-mode-text'
specifies in the mode line.

This is a global minor mode.  If called interactively, toggle the
`Global Auto-Revert mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='global-auto-revert-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "autorevert" '("auto-revert-" "global-auto-revert-"))


;;; Generated autoloads from emacs-lisp/avl-tree.el

(register-definition-prefixes "avl-tree" '("avl-tree-"))


;;; Generated autoloads from avoid.el

(defvar mouse-avoidance-mode nil "\
Activate Mouse Avoidance mode.
See function `mouse-avoidance-mode' for possible values.
Setting this variable directly does not take effect;
use either \\[customize] or \\[mouse-avoidance-mode].")
(custom-autoload 'mouse-avoidance-mode "avoid" nil)
(autoload 'mouse-avoidance-mode "avoid" "\
Set Mouse Avoidance mode to MODE.
MODE should be one of the symbols `banish', `exile', `jump', `animate',
`cat-and-mouse', `proteus', or `none'.

If MODE is nil, toggle mouse avoidance between `none' and `banish'
modes.  Positive numbers and symbols other than the above are treated
as equivalent to `banish'; negative numbers and `-' are equivalent to `none'.

Effects of the different modes:
 * banish: Move the mouse to the upper-right corner on any keypress.
 * exile: Move the mouse to the corner only if the cursor gets too close,
     and allow it to return once the cursor is out of the way.
 * jump: If the cursor gets too close to the mouse, displace the mouse
     a random distance & direction.
 * animate: As `jump', but shows steps along the way for illusion of motion.
 * cat-and-mouse: Same as `animate'.
 * proteus: As `animate', but changes the shape of the mouse pointer too.

(See `mouse-avoidance-threshold' for definition of \"too close\",
and `mouse-avoidance-nudge-dist' and `mouse-avoidance-nudge-var' for
definition of \"random distance\".)

(fn &optional MODE)" t)
(register-definition-prefixes "avoid" '("mouse-avoidance-"))


;;; Generated autoloads from emacs-lisp/backtrace.el

(push (purecopy '(backtrace 1 0)) package--builtin-versions)
(autoload 'backtrace "backtrace" "\
Print a trace of Lisp function calls currently active.
Output stream used is value of `standard-output'.")
(register-definition-prefixes "backtrace" '("backtrace-"))


;;; Generated autoloads from cedet/ede/base.el

(register-definition-prefixes "ede/base" '("ede-"))


;;; Generated autoloads from progmodes/bat-mode.el

(add-to-list 'auto-mode-alist '("\\.\\(bat\\|cmd\\)\\'" . bat-mode))
(autoload 'bat-mode "bat-mode" "\
Major mode for editing DOS/Windows batch files.
Start a new script from `bat-template'.  Read help pages for DOS commands
with `bat-cmd-help'.  Navigate between sections using `imenu'.
Run script using `bat-run' and `bat-run-args'.

\\{bat-mode-map}

(fn)" t)
(register-definition-prefixes "bat-mode" '("bat-"))


;;; Generated autoloads from battery.el

 (put 'battery-mode-line-string 'risky-local-variable t)
(autoload 'battery "battery" "\
Display battery status information in the echo area.
The text being displayed in the echo area is controlled by the variables
`battery-echo-area-format' and `battery-status-function'." t)
(defvar display-battery-mode nil "\
Non-nil if Display-Battery mode is enabled.
See the `display-battery-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `display-battery-mode'.")
(custom-autoload 'display-battery-mode "battery" nil)
(autoload 'display-battery-mode "battery" "\
Toggle battery status display in mode line (Display Battery mode).

The text displayed in the mode line is controlled by
`battery-mode-line-format' and `battery-status-function'.
The mode line is be updated every `battery-update-interval'
seconds.

The function which updates the mode-line display will call the
functions in `battery-update-functions', which can be used to
trigger actions based on battery-related events.

This is a global minor mode.  If called interactively, toggle the
`Display-Battery mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='display-battery-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "battery" '("battery-"))


;;; Generated autoloads from emacs-lisp/benchmark.el

(autoload 'benchmark-call "benchmark" "\
Measure the run time of calling FUNC a number REPETITIONS of times.
The result is a list (TIME GC GCTIME)
where TIME is the total time it took, in seconds.
GCTIME is the amount of time that was spent in the GC
and GC is the number of times the GC was called.

REPETITIONS can also be a floating point number, in which case it
specifies a minimum number of seconds that the benchmark execution
should take.  In that case the return value is prepended with the
number of repetitions actually used.

(fn FUNC &optional REPETITIONS)")
(autoload 'benchmark-run "benchmark" "\
Time execution of FORMS.
If REPETITIONS is supplied as a number, run FORMS that many times,
accounting for the overhead of the resulting loop.  Otherwise run
FORMS once.
Return a list of the total elapsed time for execution, the number of
garbage collections that ran, and the time taken by garbage collection.
See also `benchmark-run-compiled'.

(fn &optional REPETITIONS &rest FORMS)" nil t)
(function-put 'benchmark-run 'lisp-indent-function 1)
(autoload 'benchmark-run-compiled "benchmark" "\
Time execution of compiled version of FORMS.
This is like `benchmark-run', but what is timed is a funcall of the
byte code obtained by wrapping FORMS in a `lambda' and compiling the
result.  The overhead of the `lambda's is accounted for.

(fn &optional REPETITIONS &rest FORMS)" nil t)
(function-put 'benchmark-run-compiled 'lisp-indent-function 1)
(autoload 'benchmark "benchmark" "\
Print the time taken for REPETITIONS executions of FORM.
Interactively, REPETITIONS is taken from the prefix arg, and
the command prompts for the form to benchmark.
For non-interactive use see also `benchmark-run' and
`benchmark-run-compiled'.
FORM can also be a function in which case we measure the time it takes
to call it without any argument.

(fn REPETITIONS FORM)" t)
(autoload 'benchmark-progn "benchmark" "\
Evaluate BODY and message the time taken.
The return value is the value of the final form in BODY.

(fn &rest BODY)" nil t)
(function-put 'benchmark-progn 'lisp-indent-function 0)
(register-definition-prefixes "benchmark" '("benchmark-"))


;;; Generated autoloads from textmodes/bib-mode.el

(register-definition-prefixes "bib-mode" '("bib-"))


;;; Generated autoloads from textmodes/bibtex.el

(autoload 'bibtex-initialize "bibtex" "\
(Re)Initialize BibTeX buffers.
Visit the BibTeX files defined by `bibtex-files' and return a list
of corresponding buffers.
Initialize in these buffers `bibtex-reference-keys' if not yet set.
List of BibTeX buffers includes current buffer if CURRENT is non-nil
and the current buffer visits a file using `bibtex-mode'.
If FORCE is non-nil, (re)initialize `bibtex-reference-keys' even if
already set.  If SELECT is non-nil interactively select a BibTeX buffer.

When called interactively, FORCE is t, CURRENT is t if current buffer
visits a file using `bibtex-mode', and SELECT is t if current buffer
does not use `bibtex-mode'.

(fn &optional CURRENT FORCE SELECT)" t)
(autoload 'bibtex-mode "bibtex" "\
Major mode for editing BibTeX files.

General information on working with BibTeX mode:

Use commands such as \\<bibtex-mode-map>\\[bibtex-Book] to get a template for a specific entry.
Then fill in all desired fields using \\[bibtex-next-field] to jump from field
to field.  After having filled in all desired fields in the entry, clean the
new entry with the command \\[bibtex-clean-entry].

Some features of BibTeX mode are available only by setting the variable
`bibtex-maintain-sorted-entries' to non-nil.  However, then BibTeX mode
works only with buffers containing valid (syntactically correct) and sorted
entries.  This is usually the case, if you have created a buffer completely
with BibTeX mode and finished every new entry with \\[bibtex-clean-entry].

For third party BibTeX files, call the command \\[bibtex-convert-alien]
to fully take advantage of all features of BibTeX mode.


Special information:

A command such as \\[bibtex-Book] outlines the fields for a BibTeX book entry.

The names of optional fields start with the string OPT, and are thus ignored
by BibTeX.  The names of alternative fields from which only one is required
start with the string ALT.  The OPT or ALT string may be removed from
the name of a field with \\[bibtex-remove-OPT-or-ALT].
\\[bibtex-make-field] inserts a new field after the current one.
\\[bibtex-kill-field] kills the current field entirely.
\\[bibtex-yank] yanks the last recently killed field after the current field.
\\[bibtex-remove-delimiters] removes the double-quotes or braces around the text of the current field.
\\[bibtex-empty-field] replaces the text of the current field with the default \"\" or {}.
\\[bibtex-find-text] moves point to the end of the current field.
\\[completion-at-point] completes word fragment before point according to context.

The command \\[bibtex-clean-entry] cleans the current entry, i.e. it removes OPT/ALT
from the names of all non-empty optional or alternative fields, checks that
no required fields are empty, and does some formatting dependent on the value
of `bibtex-entry-format'.  Furthermore, it can automatically generate a key
for the BibTeX entry, see `bibtex-generate-autokey'.
Note: some functions in BibTeX mode depend on entries being in a special
format (all fields beginning on separate lines), so it is usually a bad
idea to remove `realign' from `bibtex-entry-format'.

BibTeX mode supports Imenu and hideshow minor mode (`hs-minor-mode').

----------------------------------------------------------
Entry to BibTeX mode calls the value of `bibtex-mode-hook'
if that value is non-nil.

\\{bibtex-mode-map}

(fn)" t)
(autoload 'bibtex-search-entry "bibtex" "\
Move point to the beginning of BibTeX entry named KEY.
Return position of entry if KEY is found or nil if not found.
With GLOBAL non-nil, search KEY in `bibtex-files'.  Otherwise the search
is limited to the current buffer.  Optional arg START is buffer position
where the search starts.  If it is nil, start search at beginning of buffer.
If DISPLAY is non-nil, display the buffer containing KEY.
Otherwise, use `set-buffer'.
When called interactively, START is nil, DISPLAY is t.
Also, GLOBAL is t if the current mode is not `bibtex-mode'
or `bibtex-search-entry-globally' is non-nil.
A prefix arg negates the value of `bibtex-search-entry-globally'.

(fn KEY &optional GLOBAL START DISPLAY)" t)
(register-definition-prefixes "bibtex" '("bibtex-"))


;;; Generated autoloads from textmodes/bibtex-style.el

(autoload 'bibtex-style-mode "bibtex-style" "\
Major mode for editing BibTeX style files.

(fn)" t)
(register-definition-prefixes "bibtex-style" '("bibtex-style-"))


;;; Generated autoloads from bind-key.el

(push (purecopy '(bind-key 2 4 1)) package--builtin-versions)
(defvar personal-keybindings nil "\
List of bindings performed by `bind-key'.

Elements have the form ((KEY . [MAP]) CMD ORIGINAL-CMD)")
(autoload 'bind-key "bind-key" "\
Bind KEY-NAME to COMMAND in KEYMAP (`global-map' if not passed).

KEY-NAME may be a vector, in which case it is passed straight to
`define-key'.  Or it may be a string to be interpreted as
spelled-out keystrokes, e.g., \"C-c C-z\".  See the documentation
of `edmacro-mode' for details.

COMMAND must be an interactive function or lambda form.

KEYMAP, if present, should be a keymap variable or symbol.
For example:

  (bind-key \"M-h\" #\\='some-interactive-function my-mode-map)

  (bind-key \"M-h\" #\\='some-interactive-function \\='my-mode-map)

If PREDICATE is non-nil, it is a form evaluated to determine when
a key should be bound. It must return non-nil in such cases.
Emacs can evaluate this form at any time that it does redisplay
or operates on menu data structures, so you should write it so it
can safely be called at any time.

(fn KEY-NAME COMMAND &optional KEYMAP PREDICATE)" nil t)
(autoload 'unbind-key "bind-key" "\
Unbind the given KEY-NAME, within the KEYMAP (if specified).
See `bind-key' for more details.

(fn KEY-NAME &optional KEYMAP)" nil t)
(autoload 'bind-key* "bind-key" "\
Similar to `bind-key', but overrides any mode-specific bindings.

(fn KEY-NAME COMMAND &optional PREDICATE)" nil t)
(autoload 'bind-keys "bind-key" "\
Bind multiple keys at once.

Accepts keyword arguments:
:map MAP               - a keymap into which the keybindings should be
                         added
:prefix KEY            - prefix key for these bindings
:prefix-map MAP        - name of the prefix map that should be created
                         for these bindings
:prefix-docstring STR  - docstring for the prefix-map variable
:menu-name NAME        - optional menu string for prefix map
:repeat-docstring STR  - docstring for the repeat-map variable
:repeat-map MAP        - name of the repeat map that should be created
                         for these bindings. If specified, the
                         `repeat-map' property of each command bound
                         (within the scope of the `:repeat-map' keyword)
                         is set to this map.
:exit BINDINGS         - Within the scope of `:repeat-map' will bind the
                         key in the repeat map, but will not set the
                         `repeat-map' property of the bound command.
:continue BINDINGS     - Within the scope of `:repeat-map' forces the
                         same behavior as if no special keyword had
                         been used (that is, the command is bound, and
                         it's `repeat-map' property set)
:filter FORM           - optional form to determine when bindings apply

The rest of the arguments are conses of keybinding string and a
function symbol (unquoted).

(fn &rest ARGS)" nil t)
(autoload 'bind-keys* "bind-key" "\
Bind multiple keys at once, in `override-global-map'.
Accepts the same keyword arguments as `bind-keys' (which see).

This binds keys in such a way that bindings are not overridden by
other modes.  See `override-global-mode'.

(fn &rest ARGS)" nil t)
(autoload 'describe-personal-keybindings "bind-key" "\
Display all the personal keybindings defined by `bind-key'." t)
(register-definition-prefixes "bind-key" '("bind-key" "override-global-m"))


;;; Generated autoloads from emacs-lisp/bindat.el

(register-definition-prefixes "bindat" '("bindat-"))


;;; Generated autoloads from mail/binhex.el

(defconst binhex-begin-line "^:...............................................................$" "\
Regular expression matching the start of a BinHex encoded region.")
(autoload 'binhex-decode-region-internal "binhex" "\
Binhex decode region between START and END without using an external program.
If HEADER-ONLY is non-nil only decode header and return filename.

(fn START END &optional HEADER-ONLY)" t)
(autoload 'binhex-decode-region-external "binhex" "\
Binhex decode region between START and END using external decoder.

(fn START END)" t)
(autoload 'binhex-decode-region "binhex" "\
Binhex decode region between START and END.

(fn START END)" t)
(register-definition-prefixes "binhex" '("binhex-"))


;;; Generated autoloads from play/blackbox.el

(autoload 'blackbox "blackbox" "\
Play blackbox.
Optional prefix argument is the number of balls; the default is 4.

What is blackbox?

Blackbox is a game of hide and seek played on an 8 by 8 grid (the
Blackbox).  Your opponent (Emacs, in this case) has hidden several
balls (usually 4) within this box.  By shooting rays into the box and
observing where they emerge it is possible to deduce the positions of
the hidden balls.  The fewer rays you use to find the balls, the lower
your score.

Overview of play:

\\<blackbox-mode-map>To play blackbox, type \\[blackbox].  An optional prefix argument
specifies the number of balls to be hidden in the box; the default is
four.

The cursor can be moved around the box with the standard cursor
movement keys.

To shoot a ray, move the cursor to the edge of the box and press SPC.
The result will be determined and the playfield updated.

You may place or remove balls in the box by moving the cursor into the
box and pressing \\[bb-romp].

When you think the configuration of balls you have placed is correct,
press \\[bb-done].  You will be informed whether you are correct or
not, and be given your score.  Your score is the number of letters and
numbers around the outside of the box plus five for each incorrectly
placed ball.  If you placed any balls incorrectly, they will be
indicated with `x', and their actual positions indicated with `o'.

Details:

There are three possible outcomes for each ray you send into the box:

	Detour: the ray is deflected and emerges somewhere other than
		where you sent it in.  On the playfield, detours are
		denoted by matching pairs of numbers -- one where the
		ray went in, and the other where it came out.

	Reflection: the ray is reflected and emerges in the same place
		it was sent in.  On the playfield, reflections are
		denoted by the letter `R'.

	Hit:	the ray strikes a ball directly and is absorbed.  It does
		not emerge from the box.  On the playfield, hits are
		denoted by the letter `H'.

The rules for how balls deflect rays are simple and are best shown by
example.

As a ray approaches a ball it is deflected ninety degrees.  Rays can
be deflected multiple times.  In the diagrams below, the dashes
represent empty box locations and the letter `O' represents a ball.
The entrance and exit points of each ray are marked with numbers as
described under \"Detour\" above.  Note that the entrance and exit
points are always interchangeable.  `*' denotes the path taken by the
ray.

Note carefully the relative positions of the ball and the ninety
degree deflection it causes.

    1
  - * - - - - - -         - - - - - - - -         - - - - - - - -
  - * - - - - - -         - - - - - - - -         - - - - - - - -
1 * * - - - - - -         - - - - - - - -         - O - - - - O -
  - - O - - - - -         - - O - - - - -         - - * * * * - -
  - - - - - - - -         - - - * * * * * 2     3 * * * - - * - -
  - - - - - - - -         - - - * - - - -         - - - O - * - -
  - - - - - - - -         - - - * - - - -         - - - - * * - -
  - - - - - - - -         - - - * - - - -         - - - - * - O -
                                2                         3

As mentioned above, a reflection occurs when a ray emerges from the same point
it was sent in.  This can happen in several ways:


  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - O - - -         - - O - O - - -          - - - - - - - -
R * * * * - - - -         - - - * - - - -          O - - - - - - -
  - - - - O - - -         - - - * - - - -        R - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -       R * * * * - - - -          - - - - - - - -
  - - - - - - - -         - - - - O - - -          - - - - - - - -

In the first example, the ray is deflected downwards by the upper
ball, then left by the lower ball, and finally retraces its path to
its point of origin.  The second example is similar.  The third
example is a bit anomalous but can be rationalized by realizing the
ray never gets a chance to get into the box.  Alternatively, the ray
can be thought of as being deflected downwards and immediately
emerging from the box.

A hit occurs when a ray runs straight into a ball:

  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - O - - -
  - - - - - - - -         - - - - O - - -        H * * * * - - - -
  - - - - - - - -       H * * * * O - - -          - - - * - - - -
  - - - - - - - -         - - - - O - - -          - - - O - - - -
H * * * O - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -

Be sure to compare the second example of a hit with the first example of
a reflection.

(fn NUM)" t)
(register-definition-prefixes "blackbox" '("bb-" "blackbox-"))


;;; Generated autoloads from bookmark.el

 (keymap-set ctl-x-r-map "b" #'bookmark-jump)
 (keymap-set ctl-x-r-map "m" #'bookmark-set)
 (keymap-set ctl-x-r-map "M" #'bookmark-set-no-overwrite)
 (keymap-set ctl-x-r-map "l" #'bookmark-bmenu-list)
(defvar-keymap bookmark-map :doc "\
Keymap containing bindings to bookmark functions.
It is not bound to any key by default: to bind it
so that you have a bookmark prefix, just use `global-set-key' and bind a
key of your choice to variable `bookmark-map'.  All interactive bookmark
functions have a binding in this keymap." "x" #'bookmark-set "m" #'bookmark-set "M" #'bookmark-set-no-overwrite "j" #'bookmark-jump "g" #'bookmark-jump "o" #'bookmark-jump-other-window "5" #'bookmark-jump-other-frame "i" #'bookmark-insert "e" #'edit-bookmarks "f" #'bookmark-insert-location "r" #'bookmark-rename "d" #'bookmark-delete "D" #'bookmark-delete-all "l" #'bookmark-load "w" #'bookmark-write "s" #'bookmark-save)
 (fset 'bookmark-map bookmark-map)
(autoload 'bookmark-set "bookmark" "\
Set a bookmark named NAME at the current location.
If NAME is nil, then prompt the user.

With a prefix arg (non-nil NO-OVERWRITE), do not overwrite any
existing bookmark that has the same name as NAME, but instead push the
new bookmark onto the bookmark alist.  The most recently set bookmark
with name NAME is thus the one in effect at any given time, but the
others are still there, should the user decide to delete the most
recent one.

To yank words from the text of the buffer and use them as part of the
bookmark name, type \\<bookmark-minibuffer-read-name-map>\\[bookmark-yank-word] while setting a bookmark.  Successive \\[bookmark-yank-word]'s
yank successive words.

Typing \\[universal-argument] inserts (at the bookmark name prompt) the name of the last
bookmark used in the document where the new bookmark is being set;
this helps you use a single bookmark name to track progress through a
large document.  If there is no prior bookmark for this document, then
\\[universal-argument] inserts an appropriate name based on the buffer or file.

Use \\[bookmark-delete] to remove bookmarks (you give it a name and
it removes only the first instance of a bookmark with that name from
the list of bookmarks.)

(fn &optional NAME NO-OVERWRITE)" t)
(autoload 'bookmark-set-no-overwrite "bookmark" "\
Set a bookmark named NAME at the current location.
If NAME is nil, then prompt the user.

If a bookmark named NAME already exists and prefix argument
PUSH-BOOKMARK is non-nil, then push the new bookmark onto the
bookmark alist.  Pushing it means that among bookmarks named
NAME, this one becomes the one in effect, but the others are
still there, in order, and become effective again if the user
ever deletes the most recent one.

Otherwise, if a bookmark named NAME already exists but PUSH-BOOKMARK
is nil, raise an error.

To yank words from the text of the buffer and use them as part of the
bookmark name, type \\<bookmark-minibuffer-read-name-map>\\[bookmark-yank-word] while setting a bookmark.  Successive \\[bookmark-yank-word]'s
yank successive words.

Typing \\[universal-argument] inserts (at the bookmark name prompt) the name of the last
bookmark used in the document where the new bookmark is being set;
this helps you use a single bookmark name to track progress through a
large document.  If there is no prior bookmark for this document, then
\\[universal-argument] inserts an appropriate name based on the buffer or file.

Use \\[bookmark-delete] to remove bookmarks (you give it a name and
it removes only the first instance of a bookmark with that name from
the list of bookmarks.)

(fn &optional NAME PUSH-BOOKMARK)" t)
(autoload 'bookmark-jump "bookmark" "\
Jump to bookmark BOOKMARK (a point in some file).
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

If the file pointed to by BOOKMARK no longer exists, you will be asked
if you wish to give the bookmark a new location, and `bookmark-jump'
will then jump to the new location, as well as recording it in place
of the old one in the permanent bookmark record.

BOOKMARK is usually a bookmark name (a string).  It can also be a
bookmark record, but this is usually only done by programmatic callers.

If DISPLAY-FUNC is non-nil, it is a function to invoke to display the
bookmark.  It defaults to `pop-to-buffer-same-window'.  A typical value for
DISPLAY-FUNC would be `switch-to-buffer-other-window'.

(fn BOOKMARK &optional DISPLAY-FUNC)" t)
(autoload 'bookmark-jump-other-window "bookmark" "\
Jump to BOOKMARK in another window.  See `bookmark-jump' for more.

(fn BOOKMARK)" t)
(autoload 'bookmark-jump-other-frame "bookmark" "\
Jump to BOOKMARK in another frame.  See `bookmark-jump' for more.

(fn BOOKMARK)" t)
(autoload 'bookmark-relocate "bookmark" "\
Relocate BOOKMARK-NAME to another file, reading file name with minibuffer.

This makes an already existing bookmark point to that file, instead of
the one it used to point at.  Useful when a file has been renamed
after a bookmark was set in it.

(fn BOOKMARK-NAME)" t)
(autoload 'bookmark-insert-location "bookmark" "\
Insert the name of the file associated with BOOKMARK-NAME.

Optional second arg NO-HISTORY means don't record this in the
minibuffer history list `bookmark-history'.

(fn BOOKMARK-NAME &optional NO-HISTORY)" t)
(defalias 'bookmark-locate 'bookmark-insert-location)
(autoload 'bookmark-rename "bookmark" "\
Change the name of OLD-NAME bookmark to NEW-NAME name.
If called from keyboard, prompt for OLD-NAME and NEW-NAME.
If called from menubar, select OLD-NAME from a menu and prompt for NEW-NAME.

If called from Lisp, prompt for NEW-NAME if only OLD-NAME was passed
as an argument.  If called with two strings, then no prompting is done.
You must pass at least OLD-NAME when calling from Lisp.

While you are entering the new name, consecutive \\<bookmark-minibuffer-read-name-map>\\[bookmark-yank-word]'s insert
consecutive words from the text of the buffer into the new bookmark
name.

(fn OLD-NAME &optional NEW-NAME)" t)
(autoload 'bookmark-insert "bookmark" "\
Insert the text of the file pointed to by bookmark BOOKMARK-NAME.
BOOKMARK-NAME is a bookmark name (a string), not a bookmark record.

You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

(fn BOOKMARK-NAME)" t)
(autoload 'bookmark-delete "bookmark" "\
Delete BOOKMARK-NAME from the bookmark list.

Removes only the first instance of a bookmark with that name.  If
there are one or more other bookmarks with the same name, they will
not be deleted.  Defaults to the \"current\" bookmark (that is, the
one most recently used in this file, if any).
Optional second arg BATCH means don't update the bookmark list buffer,
probably because we were called from there.

(fn BOOKMARK-NAME &optional BATCH)" t)
(autoload 'bookmark-delete-all "bookmark" "\
Permanently delete all bookmarks.
If optional argument NO-CONFIRM is non-nil, don't ask for
confirmation.

(fn &optional NO-CONFIRM)" t)
(autoload 'bookmark-write "bookmark" "\
Write bookmarks to a file (reading the file name with the minibuffer)." t)
(function-put 'bookmark-write 'interactive-only 'bookmark-save)
(autoload 'bookmark-save "bookmark" "\
Save currently defined bookmarks in FILE.
FILE defaults to `bookmark-default-file'.
With prefix PARG, query user for a file to save in.
If MAKE-DEFAULT is non-nil (interactively with prefix \\[universal-argument] \\[universal-argument])
the file we save in becomes the new default in the current Emacs
session (without affecting the value of `bookmark-default-file'.).

When you want to load in the bookmarks from a file, use
`bookmark-load', \\[bookmark-load].  That function will prompt you
for a file, defaulting to the file defined by variable
`bookmark-default-file'.

(fn &optional PARG FILE MAKE-DEFAULT)" t)
(autoload 'bookmark-load "bookmark" "\
Load bookmarks from FILE (which must be in bookmark format).
Appends loaded bookmarks to the front of the list of bookmarks.
If argument OVERWRITE is non-nil, existing bookmarks are destroyed.
Optional third arg NO-MSG means don't display any messages while loading.
If DEFAULT is non-nil make FILE the new bookmark file to watch.
Interactively, a prefix arg makes OVERWRITE and DEFAULT non-nil.

If you load a file that doesn't contain a proper bookmark alist, you
will corrupt Emacs's bookmark list.  Generally, you should only load
in files that were created with the bookmark functions in the first
place.  Your own personal bookmark file, specified by the variable
`bookmark-default-file', is maintained automatically by Emacs; you
shouldn't need to load it explicitly.

If you load a file containing bookmarks with the same names as
bookmarks already present in your Emacs, the new bookmarks will get
unique numeric suffixes \"<2>\", \"<3>\", etc.

(fn FILE &optional OVERWRITE NO-MSG DEFAULT)" t)
(autoload 'bookmark-bmenu-get-buffer "bookmark" "\
Return the Bookmark List, building it if it doesn't exists.
Don't affect the buffer ring order.")
(autoload 'bookmark-bmenu-list "bookmark" "\
Display a list of existing bookmarks.
The list is displayed in a buffer named `*Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying." t)
(defalias 'list-bookmarks 'bookmark-bmenu-list)
(defalias 'edit-bookmarks 'bookmark-bmenu-list)
(autoload 'bookmark-bmenu-search "bookmark" "\
Incremental search of bookmarks, hiding the non-matches as we go." '(bookmark-bmenu-mode))
(defvar menu-bar-bookmark-map (let ((map (make-sparse-keymap "Bookmark functions"))) (bindings--define-key map [load] '(menu-item "Load a Bookmark File..." bookmark-load :help "Load bookmarks from a bookmark file)")) (bindings--define-key map [write] '(menu-item "Save Bookmarks As..." bookmark-write :help "Write bookmarks to a file (reading the file name with the minibuffer)")) (bindings--define-key map [save] '(menu-item "Save Bookmarks" bookmark-save :help "Save currently defined bookmarks")) (bindings--define-key map [edit] '(menu-item "Edit Bookmark List" bookmark-bmenu-list :help "Display a list of existing bookmarks")) (bindings--define-key map [delete] '(menu-item "Delete Bookmark..." bookmark-delete :help "Delete a bookmark from the bookmark list")) (bindings--define-key map [delete-all] '(menu-item "Delete all Bookmarks..." bookmark-delete-all :help "Delete all bookmarks from the bookmark list")) (bindings--define-key map [rename] '(menu-item "Rename Bookmark..." bookmark-rename :help "Change the name of a bookmark")) (bindings--define-key map [locate] '(menu-item "Insert Location..." bookmark-locate :help "Insert the name of the file associated with a bookmark")) (bindings--define-key map [insert] '(menu-item "Insert Contents..." bookmark-insert :help "Insert the text of the file pointed to by a bookmark")) (bindings--define-key map [set] '(menu-item "Set Bookmark..." bookmark-set :help "Set a bookmark named inside a file.")) (bindings--define-key map [jump] '(menu-item "Jump to Bookmark..." bookmark-jump :help "Jump to a bookmark (a point in some file)")) map))
(defalias 'menu-bar-bookmark-map menu-bar-bookmark-map)
(register-definition-prefixes "bookmark" '("bookmark-" "with-buffer-modified-unmodified"))


;;; Generated autoloads from cedet/semantic/bovine.el

(register-definition-prefixes "semantic/bovine" '("semantic-"))


;;; Generated autoloads from net/browse-url.el

(defvar browse-url-browser-function 'browse-url-default-browser "\
Function to display the current buffer in a WWW browser.
This is used by the `browse-url-at-point', `browse-url-at-mouse', and
`browse-url-of-file' commands.

Also see `browse-url-secondary-browser-function' and
`browse-url-handlers'.")
(custom-autoload 'browse-url-browser-function "browse-url" t)
(defvar browse-url-default-handlers '(("\\`mailto:" . browse-url--mailto) ("\\`man:" . browse-url--man) ("\\`irc6?s?://" . browse-url--irc) (browse-url--non-html-file-url-p . browse-url-emacs)) "\
Like `browse-url-handlers' but populated by Emacs and packages.

Emacs and external packages capable of browsing certain URLs
should place their entries in this alist rather than
`browse-url-handlers' which is reserved for the user.")
(autoload 'browse-url-select-handler "browse-url" "\
Return a handler of suitable for browsing URL.
This searches `browse-url-handlers', and
`browse-url-default-handlers' for a matching handler.  Return nil
if no handler is found.

If KIND is given, the search is restricted to handlers whose
function symbol has the symbol-property `browse-url-browser-kind'
set to KIND.

Currently, it also consults `browse-url-browser-function' first
if it is set to an alist, although this usage is deprecated since
Emacs 28.1 and will be removed in a future release.

(fn URL &optional KIND)")
(autoload 'browse-url-of-file "browse-url" "\
Use a web browser to display FILE.
Display the current buffer's file if FILE is nil or if called
interactively.  Turn the filename into a URL with function
`browse-url-file-url'.  Pass the URL to a browser using the
`browse-url' function then run `browse-url-of-file-hook'.

(fn &optional FILE)" t)
(autoload 'browse-url-of-buffer "browse-url" "\
Use a web browser to display BUFFER.
See `browse-url' for details.

Display the current buffer if BUFFER is nil.  Display only the
currently visible part of BUFFER (from a temporary file) if buffer is
narrowed.

(fn &optional BUFFER)" t)
(autoload 'browse-url-of-dired-file "browse-url" "\
In Dired, ask a WWW browser to display the file named on this line.
With prefix arg, use the secondary browser instead (e.g. EWW if
`browse-url-secondary-browser-function' is set to
`eww-browse-url'.

(fn &optional SECONDARY)" t)
(autoload 'browse-url-of-region "browse-url" "\
Use a web browser to display the current region.
See `browse-url' for details.

(fn MIN MAX)" t)
(autoload 'browse-url "browse-url" "\
Open URL using a configurable method.
This will typically (by default) open URL with an external web
browser, but a wide variety of different methods can be used,
depending on the URL type.

The variables `browse-url-browser-function',
`browse-url-handlers', and `browse-url-default-handlers'
determine which browser function to use.

Interactively, this command prompts for a URL, defaulting to the
URL at or before point.

The additional ARGS are passed to the browser function.  See the
doc strings of the actual functions, starting with
`browse-url-browser-function', for information about the
significance of ARGS (most of the functions ignore it).

If ARGS are omitted, the default is to pass
`browse-url-new-window-flag' as ARGS.  Interactively, pass the
prefix arg as ARGS; if `browse-url-new-window-flag' is non-nil,
invert the prefix arg instead.

(fn URL &rest ARGS)" t)
(autoload 'browse-url-at-point "browse-url" "\
Open URL at point using a configurable method.
See `browse-url' for details.
Optional prefix argument ARG non-nil inverts the value of the option
`browse-url-new-window-flag'.

(fn &optional ARG)" t)
(autoload 'browse-url-with-browser-kind "browse-url" "\
Browse URL with a browser of the given browser KIND.
KIND is either `internal' or `external'.

When called interactively, the default browser kind is the
opposite of the browser kind of `browse-url-browser-function'.

(fn KIND URL &optional ARG)" t)
(autoload 'browse-url-at-mouse "browse-url" "\
Use a web browser to load a URL clicked with the mouse.
See `browse-url' for details.

The URL is the one around or before the position of the mouse
click but point is not changed.

(fn EVENT)" t)
(autoload 'browse-url-xdg-open "browse-url" "\
Pass the specified URL to the \"xdg-open\" command.
xdg-open is a desktop utility that calls your preferred web browser.
The optional argument IGNORED is not used.

(fn URL &optional IGNORED)" t)
(autoload 'browse-url-mozilla "browse-url" "\
Ask the Mozilla WWW browser to load URL.
Default to the URL around or before point.  The strings in variable
`browse-url-mozilla-arguments' are also passed to Mozilla.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new Mozilla window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

If `browse-url-mozilla-new-window-is-tab' is non-nil, then whenever a
document would otherwise be loaded in a new window, it is loaded in a
new tab in an existing window instead.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(make-obsolete 'browse-url-mozilla 'nil "29.1")
(autoload 'browse-url-firefox "browse-url" "\
Ask the Firefox WWW browser to load URL.
Defaults to the URL around or before point.  Passes the strings
in the variable `browse-url-firefox-arguments' to Firefox.

Interactively, if the variable `browse-url-new-window-flag' is non-nil,
loads the document in a new Firefox window.  A non-nil prefix argument
reverses the effect of `browse-url-new-window-flag'.

If `browse-url-firefox-new-window-is-tab' is non-nil, then
whenever a document would otherwise be loaded in a new window, it
is loaded in a new tab in an existing window instead.

Non-interactively, this uses the optional second argument NEW-WINDOW
instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-chromium "browse-url" "\
Ask the Chromium WWW browser to load URL.
Default to the URL around or before point.  The strings in
variable `browse-url-chromium-arguments' are also passed to
Chromium.
The optional argument NEW-WINDOW is not used.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-webpositive "browse-url" "\
Ask the WebPositive WWW browser to load URL.
Default to the URL around or before point.
The optional argument NEW-WINDOW is not used.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-default-haiku-browser "browse-url" "\
Browse URL with the system default browser.
Default to the URL around or before point.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-default-android-browser "browse-url" "\
Browse URL with the system default browser.
If `browse-url-android-share' is non-nil, try to share URL using
an external program instead.  Default to the URL around or before
point.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-emacs "browse-url" "\
Ask Emacs to load URL into a buffer and show it in another window.
Optional argument SAME-WINDOW non-nil means show the URL in the
currently selected window instead.

(fn URL &optional SAME-WINDOW)" t)
(autoload 'browse-url-gnome-moz "browse-url" "\
Ask Mozilla to load URL via the GNOME program `gnome-moz-remote'.
Default to the URL around or before point.  The strings in variable
`browse-url-gnome-moz-arguments' are also passed.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new browser window, otherwise use an
existing one.  A non-nil interactive prefix argument reverses the
effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(make-obsolete 'browse-url-gnome-moz 'nil "25.1")
(autoload 'browse-url-conkeror "browse-url" "\
Ask the Conkeror WWW browser to load URL.
Default to the URL around or before point.  Also pass the strings
in the variable `browse-url-conkeror-arguments' to Conkeror.

When called interactively, if variable
`browse-url-new-window-flag' is non-nil, load the document in a
new Conkeror window, otherwise use a random existing one.  A
non-nil interactive prefix argument reverses the effect of
`browse-url-new-window-flag'.

If variable `browse-url-conkeror-new-window-is-buffer' is
non-nil, then whenever a document would otherwise be loaded in a
new window, load it in a new buffer in an existing window instead.

When called non-interactively, use optional second argument
NEW-WINDOW instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(make-obsolete 'browse-url-conkeror 'nil "28.1")
(autoload 'browse-url-w3 "browse-url" "\
Ask the w3 WWW browser to load URL.
Default to the URL around or before point.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new window.  A non-nil interactive
prefix argument reverses the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(make-obsolete 'browse-url-w3 'nil "29.1")
(autoload 'browse-url-w3-gnudoit "browse-url" "\
Ask another Emacs running emacsclient to load the URL using the W3 browser.
The `browse-url-gnudoit-program' program is used with options given by
`browse-url-gnudoit-args'.  Default to the URL around or before point.

(fn URL &optional NEW-WINDOW)" t)
(make-obsolete 'browse-url-w3-gnudoit 'nil "25.1")
(autoload 'browse-url-text-xterm "browse-url" "\
Ask a text browser to load URL.
URL defaults to the URL around or before point.
This runs the text browser specified by `browse-url-text-browser'.
in an Xterm window using the Xterm program named by `browse-url-xterm-program'
with possible additional arguments `browse-url-xterm-args'.
The optional argument NEW-WINDOW is not used.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-text-emacs "browse-url" "\
Ask a text browser to load URL.
URL defaults to the URL around or before point.
This runs the text browser specified by `browse-url-text-browser'.
With a prefix argument, it runs a new browser process in a new buffer.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new browser process in a new term window,
otherwise use any existing one.  A non-nil interactive prefix argument
reverses the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-BUFFER)" t)
(autoload 'browse-url-irc "browse-url" "\
Call `url-irc' directly after parsing URL.
This function is a fit for options like `gnus-button-alist'.

(fn URL &rest _)")
(autoload 'browse-url-mail "browse-url" "\
Open a new mail message buffer within Emacs for the RFC 2368 URL.
Default to using the mailto: URL around or before point as the
recipient's address.  Supplying a non-nil interactive prefix argument
will cause the mail to be composed in another window rather than the
current one.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil use `compose-mail-other-window', otherwise `compose-mail'.  A
non-nil interactive prefix argument reverses the effect of
`browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-generic "browse-url" "\
Ask the WWW browser defined by `browse-url-generic-program' to load URL.
Default to the URL around or before point.  A fresh copy of the
browser is started up in a new process with possible additional arguments
`browse-url-generic-args'.  This is appropriate for browsers which
don't offer a form of remote control.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-kde "browse-url" "\
Ask the KDE WWW browser to load URL.
Default to the URL around or before point.
The optional argument NEW-WINDOW is not used.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-elinks "browse-url" "\
Ask the Elinks WWW browser to load URL.
Default to the URL around the point.

The document is loaded in a new tab of a running Elinks or, if
none yet running, a newly started instance.

The Elinks command will be prepended by the program+arguments
from `browse-url-elinks-wrapper'.

(fn URL &optional NEW-WINDOW)" t)
(autoload 'browse-url-button-open "browse-url" "\
Follow the link under point using `browse-url'.
If EXTERNAL (the prefix if used interactively), open with the
external browser instead of the default one.

(fn &optional EXTERNAL MOUSE-EVENT)" t)
(autoload 'browse-url-button-open-url "browse-url" "\
Open URL using `browse-url'.
If `current-prefix-arg' is non-nil, use
`browse-url-secondary-browser-function' instead.

(fn URL)")
(register-definition-prefixes "browse-url" '("browse-url-"))


;;; Generated autoloads from bs.el

(autoload 'bs-cycle-next "bs" "\
Select next buffer defined by buffer cycling.
The buffers taking part in buffer cycling are defined
by buffer configuration `bs-cycle-configuration-name'." t)
(autoload 'bs-cycle-previous "bs" "\
Select previous buffer defined by buffer cycling.
The buffers taking part in buffer cycling are defined
by buffer configuration `bs-cycle-configuration-name'." t)
(autoload 'bs-customize "bs" "\
Customization of group bs for Buffer Selection Menu." t)
(autoload 'bs-show "bs" "\
Make a menu of buffers so you can manipulate buffers or the buffer list.
\\<bs-mode-map>
There are many key commands similar to `Buffer-menu-mode' for
manipulating the buffer list and the buffers themselves.
User can move with [up] or [down], select a buffer
by \\[bs-select] or [SPC]

Type \\[bs-kill] to leave Buffer Selection Menu without a selection.
Type \\[describe-mode] after invocation to get help on commands available.
With prefix argument ARG show a different buffer list.  Function
`bs--configuration-name-for-prefix-arg' determine accordingly
name of buffer configuration.

(fn ARG)" t)
(register-definition-prefixes "bs" '("bs-"))


;;; Generated autoloads from play/bubbles.el

(autoload 'bubbles "bubbles" "\
Play Bubbles game.
\\<bubbles-mode-map>
The goal is to remove all bubbles with as few moves as possible.
\\[bubbles-plop] on a bubble removes that bubble and all
connected bubbles of the same color.  Unsupported bubbles fall
down, and columns that do not contain any bubbles suck the
columns on its right towards the left.

\\[bubbles-set-game-easy] sets the difficulty to easy.
\\[bubbles-set-game-medium] sets the difficulty to medium.
\\[bubbles-set-game-difficult] sets the difficulty to difficult.
\\[bubbles-set-game-hard] sets the difficulty to hard." t)
(register-definition-prefixes "bubbles" '("bubbles-"))


;;; Generated autoloads from progmodes/bug-reference.el

(put 'bug-reference-url-format 'safe-local-variable (lambda (s) (or (stringp s) (and (symbolp s) (get s 'bug-reference-url-format)))))
(put 'bug-reference-bug-regexp 'safe-local-variable 'stringp)
(autoload 'bug-reference-mode "bug-reference" "\
Toggle hyperlinking bug references in the buffer (Bug Reference mode).

This is a minor mode.  If called interactively, toggle the
`Bug-Reference mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `bug-reference-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'bug-reference-prog-mode "bug-reference" "\
Like `bug-reference-mode', but only buttonize in comments and strings.

This is a minor mode.  If called interactively, toggle the
`Bug-Reference-Prog mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `bug-reference-prog-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "bug-reference" '("bug-reference-"))


;;; Generated autoloads from emacs-lisp/byte-opt.el

(register-definition-prefixes "byte-opt" '("byte" "disassemble-offset"))


;;; Generated autoloads from emacs-lisp/bytecomp.el

(put 'byte-compile-dynamic 'safe-local-variable 'booleanp)
(put 'byte-compile-dynamic-docstrings 'safe-local-variable 'booleanp)
(put 'byte-compile-error-on-warn 'safe-local-variable 'booleanp)
(put 'byte-compile-warnings 'safe-local-variable (lambda (v) (or (symbolp v) (null (delq nil (mapcar (lambda (x) (not (symbolp x))) v))))))
(autoload 'byte-compile-warning-enabled-p "bytecomp" "\
Return non-nil if WARNING is enabled, according to `byte-compile-warnings'.

(fn WARNING &optional SYMBOL)")
(autoload 'byte-compile-disable-warning "bytecomp" "\
Change `byte-compile-warnings' to disable WARNING.
If `byte-compile-warnings' is t, set it to `(not WARNING)'.
Otherwise, if the first element is `not', add WARNING, else remove it.
Normally you should let-bind `byte-compile-warnings' before calling this,
else the global value will be modified.

(fn WARNING)")
(autoload 'byte-compile-enable-warning "bytecomp" "\
Change `byte-compile-warnings' to enable WARNING.
If `byte-compile-warnings' is t, do nothing.  Otherwise, if the
first element is `not', remove WARNING, else add it.
Normally you should let-bind `byte-compile-warnings' before calling this,
else the global value will be modified.

(fn WARNING)")
(autoload 'byte-compile-warn-obsolete "bytecomp" "\
Warn that SYMBOL (a variable, function or generalized variable) is obsolete.
TYPE is a string that say which one of these three types it is.

(fn SYMBOL TYPE)")
(autoload 'byte-force-recompile "bytecomp" "\
Recompile every `.el' file in DIRECTORY that already has a `.elc' file.
Files in subdirectories of DIRECTORY are processed also.

(fn DIRECTORY)" t)
(autoload 'byte-recompile-directory "bytecomp" "\
Recompile every `.el' file in DIRECTORY that needs recompilation.
This happens when a `.elc' file exists but is older than the `.el' file.
Files in subdirectories of DIRECTORY are processed also.

If the `.elc' file does not exist, normally this function *does not*
compile the corresponding `.el' file.  However, if the prefix argument
ARG is 0, that means do compile all those files.  A nonzero
ARG means ask the user, for each such `.el' file, whether to
compile it.  A nonzero ARG also means ask about each subdirectory
before scanning it.

If the third argument FORCE is non-nil, recompile every `.el' file
that already has a `.elc' file.

This command will normally not follow symlinks when compiling
files.  If FOLLOW-SYMLINKS is non-nil, symlinked `.el' files will
also be compiled.

(fn DIRECTORY &optional ARG FORCE FOLLOW-SYMLINKS)" t)
(put 'no-byte-compile 'safe-local-variable 'booleanp)
(autoload 'byte-compile-file "bytecomp" "\
Compile a file of Lisp code named FILENAME into a file of byte code.
The output file's name is generated by passing FILENAME to the
function `byte-compile-dest-file' (which see).
The value is non-nil if there were no errors, nil if errors.
If the file sets the file variable `no-byte-compile', it is not
compiled, any existing output file is removed, and the return
value is `no-byte-compile'.

See also `emacs-lisp-byte-compile-and-load'.

(fn FILENAME &optional LOAD)" t)
(set-advertised-calling-convention 'byte-compile-file '(filename) '"28.1")
(autoload 'compile-defun "bytecomp" "\
Compile and evaluate the current top-level form.
Print the result in the echo area.
With argument ARG, insert value in current buffer after the form.

(fn &optional ARG)" t)
(autoload 'byte-compile "bytecomp" "\
If FORM is a symbol, byte-compile its function definition.
If FORM is a lambda or a macro, byte-compile it as a function.

(fn FORM)")
(autoload 'display-call-tree "bytecomp" "\
Display a call graph of a specified file.
This lists which functions have been called, what functions called
them, and what functions they call.  The list includes all functions
whose definitions have been compiled in this Emacs session, as well as
all functions called by those functions.

The call graph does not include macros, inline functions, or
primitives that the byte-code interpreter knows about directly
(`eq', `cons', etc.).

The call tree also lists those functions which are not known to be called
(that is, to which no calls have been compiled), and which cannot be
invoked interactively.

(fn &optional FILENAME)" t)
(autoload 'batch-byte-compile-if-not-done "bytecomp" "\
Like `byte-compile-file' but doesn't recompile if already up to date.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.")
(autoload 'batch-byte-compile "bytecomp" "\
Run `byte-compile-file' on the files remaining on the command line.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.

Each file is processed even if an error occurred previously.  If
a file name denotes a directory, all Emacs Lisp source files in
that directory (that have previously been compiled) will be
recompiled if newer than the compiled files.  In this case,
NOFORCE is ignored.

For example, invoke \"emacs -batch -f batch-byte-compile $emacs/ ~/*.el\".

If NOFORCE is non-nil, don't recompile a file that seems to be
already up-to-date.

(fn &optional NOFORCE)")
(autoload 'batch-byte-recompile-directory "bytecomp" "\
Run `byte-recompile-directory' on the dirs remaining on the command line.
Must be used only with `-batch', and kills Emacs on completion.
For example, invoke `emacs -batch -f batch-byte-recompile-directory .'.

Optional argument ARG is passed as second argument ARG to
`byte-recompile-directory'; see there for its possible values
and corresponding effects.

(fn &optional ARG)")
(register-definition-prefixes "bytecomp" '("batch-byte-compile-file" "byte" "compilation-safety" "displaying-byte-compile-warnings" "emacs-lisp-" "no-byte-compile"))


;;; Generated autoloads from cedet/semantic/bovine/c.el

(register-definition-prefixes "semantic/bovine/c" '("semantic"))


;;; Generated autoloads from progmodes/c-ts-common.el

(register-definition-prefixes "c-ts-common" '("c-ts-common-"))


;;; Generated autoloads from progmodes/c-ts-mode.el

(autoload 'c-ts-mode "c-ts-mode" "\
Major mode for editing C, powered by tree-sitter.

This mode is independent from the classic cc-mode.el based
`c-mode', so configuration variables of that mode, like
`c-basic-offset', don't affect this mode.

To use tree-sitter C/C++ modes by default, evaluate

    (add-to-list \\='major-mode-remap-alist \\='(c-mode . c-ts-mode))
    (add-to-list \\='major-mode-remap-alist \\='(c++-mode . c++-ts-mode))
    (add-to-list \\='major-mode-remap-alist
                 \\='(c-or-c++-mode . c-or-c++-ts-mode))

in your init files.

(fn)" t)
(autoload 'c++-ts-mode "c-ts-mode" "\
Major mode for editing C++, powered by tree-sitter.

This mode is independent from the classic cc-mode.el based
`c++-mode', so configuration variables of that mode, like
`c-basic-offset', don't affect this mode.

To use tree-sitter C/C++ modes by default, evaluate

    (add-to-list \\='major-mode-remap-alist \\='(c-mode . c-ts-mode))
    (add-to-list \\='major-mode-remap-alist \\='(c++-mode . c++-ts-mode))
    (add-to-list \\='major-mode-remap-alist
                 \\='(c-or-c++-mode . c-or-c++-ts-mode))

in your init files.

Since this mode uses a parser, unbalanced brackets might cause
some breakage in indentation/fontification.  Therefore, it's
recommended to enable `electric-pair-mode' with this mode.

(fn)" t)
(autoload 'c-or-c++-ts-mode "c-ts-mode" "\
Analyze buffer and enable either C or C++ mode.

Some people and projects use .h extension for C++ header files
which is also the one used for C header files.  This makes
matching on file name insufficient for detecting major mode that
should be used.

This function attempts to use file contents to determine whether
the code is C or C++, and based on that chooses whether to enable
`c-ts-mode' or `c++-ts-mode'." t)
(make-obsolete 'c-or-c++-ts-mode 'c-or-c++-mode "30.1")
(register-definition-prefixes "c-ts-mode" '("c-ts-"))


;;; Generated autoloads from calendar/cal-bahai.el

(register-definition-prefixes "cal-bahai" '("calendar-bahai-" "diary-bahai-" "holiday-bahai"))


;;; Generated autoloads from calendar/cal-china.el

(put 'calendar-chinese-time-zone 'risky-local-variable t)
(register-definition-prefixes "cal-china" '("calendar-chinese-" "diary-chinese-" "holiday-chinese"))


;;; Generated autoloads from calendar/cal-coptic.el

(register-definition-prefixes "cal-coptic" '("calendar-" "diary-"))


;;; Generated autoloads from calendar/cal-dst.el

(put 'calendar-daylight-savings-starts 'risky-local-variable t)
(put 'calendar-daylight-savings-ends 'risky-local-variable t)
(put 'calendar-current-time-zone-cache 'risky-local-variable t)
(register-definition-prefixes "cal-dst" '("calendar-" "dst-"))


;;; Generated autoloads from calendar/cal-french.el

(register-definition-prefixes "cal-french" '("calendar-french-" "diary-french-date"))


;;; Generated autoloads from calendar/cal-hebrew.el

(autoload 'calendar-hebrew-list-yahrzeits "cal-hebrew" "\
List Yahrzeit dates for *Gregorian* DEATH-DATE from START-YEAR to END-YEAR.
When called interactively from the calendar window, the date of death is taken
from the cursor position.

(fn DEATH-DATE START-YEAR END-YEAR)" t)
(register-definition-prefixes "cal-hebrew" '("calendar-hebrew-" "diary-hebrew-" "holiday-hebrew"))


;;; Generated autoloads from calendar/cal-html.el

(register-definition-prefixes "cal-html" '("cal-html-"))


;;; Generated autoloads from calendar/cal-islam.el

(register-definition-prefixes "cal-islam" '("calendar-islamic-" "diary-islamic-" "holiday-islamic"))


;;; Generated autoloads from calendar/cal-iso.el

(register-definition-prefixes "cal-iso" '("calendar-iso-" "diary-iso-date"))


;;; Generated autoloads from calendar/cal-julian.el

(register-definition-prefixes "cal-julian" '("calendar-" "diary-" "holiday-julian"))


;;; Generated autoloads from calendar/cal-mayan.el

(register-definition-prefixes "cal-mayan" '("calendar-mayan-" "diary-mayan-date"))


;;; Generated autoloads from calendar/cal-menu.el

(register-definition-prefixes "cal-menu" '("cal"))


;;; Generated autoloads from calendar/cal-move.el

(register-definition-prefixes "cal-move" '("calendar-"))


;;; Generated autoloads from calendar/cal-persia.el

(register-definition-prefixes "cal-persia" '("calendar-persian-" "diary-persian-date"))


;;; Generated autoloads from calendar/cal-tex.el

(register-definition-prefixes "cal-tex" '("cal-tex-"))


;;; Generated autoloads from calendar/cal-x.el

(register-definition-prefixes "cal-x" '("calendar-" "diary-frame"))


;;; Generated autoloads from calc/calc.el

 (define-key ctl-x-map "*" 'calc-dispatch)
(autoload 'calc-dispatch "calc" "\
Invoke the GNU Emacs Calculator.  See \\[calc-dispatch-help] for details.

(fn &optional ARG)" t)
(autoload 'calc "calc" "\
The Emacs Calculator.  Full documentation is listed under `calc-mode'.

(fn &optional ARG FULL-DISPLAY INTERACTIVE)" t)
(autoload 'full-calc "calc" "\
Invoke the Calculator and give it a full-sized window.

(fn &optional INTERACTIVE)" t)
(autoload 'quick-calc "calc" "\
Do a quick calculation in the minibuffer without invoking full Calculator.
With prefix argument INSERT, insert the result in the current
buffer.  Otherwise, the result is copied into the kill ring.

(fn &optional INSERT)" t)
(autoload 'calc-eval "calc" "\
Do a quick calculation and return the result as a string.
Return value will either be the formatted result in string form,
or a list containing a character position and an error message in string form.

(fn STR &optional SEPARATOR &rest ARGS)")
(autoload 'calc-keypad "calc" "\
Invoke the Calculator in \"visual keypad\" mode.
This is most useful in the X window system.
In this mode, click on the Calc \"buttons\" using the left mouse button.
Or, position the cursor manually and do \\[calc-keypad-press].

(fn &optional INTERACTIVE)" t)
(autoload 'full-calc-keypad "calc" "\
Invoke the Calculator in full-screen \"visual keypad\" mode.
See calc-keypad for details.

(fn &optional INTERACTIVE)" t)
(autoload 'calc-grab-region "calc" "\
Parse the region as a vector of numbers and push it on the Calculator stack.

(fn TOP BOT ARG)" t)
(autoload 'calc-grab-rectangle "calc" "\
Parse a rectangle as a matrix of numbers and push it on the Calculator stack.

(fn TOP BOT ARG)" t)
(autoload 'calc-grab-sum-down "calc" "\
Parse a rectangle as a matrix of numbers and sum its columns.

(fn TOP BOT ARG)" t)
(autoload 'calc-grab-sum-across "calc" "\
Parse a rectangle as a matrix of numbers and sum its rows.

(fn TOP BOT ARG)" t)
(autoload 'calc-embedded "calc" "\
Start Calc Embedded mode on the formula surrounding point.

(fn ARG &optional END OBEG OEND)" t)
(autoload 'calc-embedded-activate "calc" "\
Scan the current editing buffer for all embedded := and => formulas.
Also looks for the equivalent TeX words, \\gets and \\evalto.

(fn &optional ARG CBUF)" t)
(autoload 'defmath "calc" "\
Define Calc function.

Like `defun' except that code in the body of the definition can
make use of the full range of Calc data types and the usual
arithmetic operations are converted to their Calc equivalents.

The prefix `calcFunc-' is added to the specified name to get the
actual Lisp function name.

See Info node `(calc)Defining Functions'.

(fn FUNC ARGS &rest BODY)" nil t)
(function-put 'defmath 'doc-string-elt 3)
(function-put 'defmath 'lisp-indent-function 'defun)
(register-definition-prefixes "calc" '("calc" "defcalcmodevar" "inexact-result" "math-" "var-"))


;;; Generated autoloads from calc/calc-aent.el

(register-definition-prefixes "calc-aent" '("calc" "math-"))


;;; Generated autoloads from calc/calc-alg.el

(register-definition-prefixes "calc-alg" '("calc" "math-"))


;;; Generated autoloads from calc/calc-arith.el

(register-definition-prefixes "calc-arith" '("calc" "math-"))


;;; Generated autoloads from calc/calc-bin.el

(register-definition-prefixes "calc-bin" '("calc" "math-"))


;;; Generated autoloads from calc/calc-comb.el

(register-definition-prefixes "calc-comb" '("calc" "math-"))


;;; Generated autoloads from calc/calc-cplx.el

(register-definition-prefixes "calc-cplx" '("calc" "math-"))


;;; Generated autoloads from calc/calc-embed.el

(register-definition-prefixes "calc-embed" '("calc-"))


;;; Generated autoloads from calc/calc-ext.el

(register-definition-prefixes "calc-ext" '("calc" "math-" "var-"))


;;; Generated autoloads from calc/calc-fin.el

(register-definition-prefixes "calc-fin" '("calc" "math-c"))


;;; Generated autoloads from calc/calc-forms.el

(register-definition-prefixes "calc-forms" '("calc" "math-" "var-TimeZone"))


;;; Generated autoloads from calc/calc-frac.el

(register-definition-prefixes "calc-frac" '("calc" "math-"))


;;; Generated autoloads from calc/calc-funcs.el

(register-definition-prefixes "calc-funcs" '("calc" "math-"))


;;; Generated autoloads from calc/calc-graph.el

(register-definition-prefixes "calc-graph" '("calc-"))


;;; Generated autoloads from calc/calc-help.el

(register-definition-prefixes "calc-help" '("calc-"))


;;; Generated autoloads from calc/calc-incom.el

(register-definition-prefixes "calc-incom" '("calc-"))


;;; Generated autoloads from calc/calc-keypd.el

(register-definition-prefixes "calc-keypd" '("calc-"))


;;; Generated autoloads from calc/calc-lang.el

(register-definition-prefixes "calc-lang" '("calc-" "math-"))


;;; Generated autoloads from calc/calc-macs.el

(register-definition-prefixes "calc-macs" '("Math-" "calc-" "math-"))


;;; Generated autoloads from calc/calc-map.el

(register-definition-prefixes "calc-map" '("calc" "math-"))


;;; Generated autoloads from calc/calc-math.el

(register-definition-prefixes "calc-math" '("calc" "math-"))


;;; Generated autoloads from calc/calc-menu.el

(register-definition-prefixes "calc-menu" '("calc-"))


;;; Generated autoloads from calc/calc-misc.el

(register-definition-prefixes "calc-misc" '("math-iipow"))


;;; Generated autoloads from calc/calc-mode.el

(register-definition-prefixes "calc-mode" '("calc-" "math-get-modes-vec"))


;;; Generated autoloads from calc/calc-mtx.el

(register-definition-prefixes "calc-mtx" '("calc" "math-"))


;;; Generated autoloads from calc/calc-nlfit.el

(register-definition-prefixes "calc-nlfit" '("calc-fit-" "math-nlfit-"))


;;; Generated autoloads from calc/calc-poly.el

(register-definition-prefixes "calc-poly" '("calcFunc-" "math-"))


;;; Generated autoloads from calc/calc-prog.el

(register-definition-prefixes "calc-prog" '("calc" "math-" "var-q"))


;;; Generated autoloads from calc/calc-rewr.el

(register-definition-prefixes "calc-rewr" '("calc" "math-"))


;;; Generated autoloads from calc/calc-rules.el

(register-definition-prefixes "calc-rules" '("calc-"))


;;; Generated autoloads from calc/calc-sel.el

(register-definition-prefixes "calc-sel" '("calc-"))


;;; Generated autoloads from calc/calc-stat.el

(register-definition-prefixes "calc-stat" '("calc" "math-"))


;;; Generated autoloads from calc/calc-store.el

(register-definition-prefixes "calc-store" '("calc"))


;;; Generated autoloads from calc/calc-stuff.el

(register-definition-prefixes "calc-stuff" '("calc" "math-"))


;;; Generated autoloads from calc/calc-trail.el

(register-definition-prefixes "calc-trail" '("calc-trail-"))


;;; Generated autoloads from calc/calc-undo.el

(autoload 'calc-undo "calc-undo" "\


(fn N)" t)
(register-definition-prefixes "calc-undo" '("calc-"))


;;; Generated autoloads from calc/calc-units.el

(register-definition-prefixes "calc-units" '("calc" "math-"))


;;; Generated autoloads from calc/calc-vec.el

(register-definition-prefixes "calc-vec" '("calc" "math-"))


;;; Generated autoloads from calc/calc-yank.el

(register-definition-prefixes "calc-yank" '("calc-" "math-number-regexp"))


;;; Generated autoloads from calc/calcalg2.el

(register-definition-prefixes "calcalg2" '("calc" "math-" "var-IntegLimit"))


;;; Generated autoloads from calc/calcalg3.el

(register-definition-prefixes "calcalg3" '("calc" "math-"))


;;; Generated autoloads from calc/calccomp.el

(register-definition-prefixes "calccomp" '("calcFunc-c" "math-"))


;;; Generated autoloads from calc/calcsel2.el

(register-definition-prefixes "calcsel2" '("calc-"))


;;; Generated autoloads from calculator.el

(autoload 'calculator "calculator" "\
Run the Emacs calculator.
See the documentation for `calculator-mode' for more information." t)
(register-definition-prefixes "calculator" '("calculator-"))


;;; Generated autoloads from calendar/calendar.el

(autoload 'calendar "calendar" "\
Display a three-month Gregorian calendar.
The three months appear side by side, with the current month in
the middle surrounded by the previous and next months.  The
cursor is put on today's date.  If optional prefix argument ARG
is non-nil, prompts for the central month and year.

Once in the calendar window, future or past months can be moved
into view.  Arbitrary months can be displayed, or the calendar
can be scrolled forward or backward.  The cursor can be moved
forward or backward by one day, one week, one month, or one year.
All of these commands take prefix arguments which, when negative,
cause movement in the opposite direction.  For convenience, the
digit keys and the minus sign are automatically prefixes.  Use
\\[describe-mode] for details of the key bindings in the calendar
window.

Displays the calendar in a separate window, or optionally in a
separate frame, depending on the value of `calendar-setup'.

If `calendar-view-diary-initially-flag' is non-nil, also displays the
diary entries for the current date (or however many days
`diary-number-of-entries' specifies).  This variable can be
overridden by `calendar-setup'.  As well as being displayed,
diary entries can also be marked on the calendar (see
`calendar-mark-diary-entries-flag').

Runs the following hooks:

`calendar-today-visible-hook', `calendar-today-invisible-hook' - after
   generating a calendar, if today's date is visible or not, respectively
`calendar-initial-window-hook' - after first creating a calendar

This function is suitable for execution in an init file.

(fn &optional ARG)" t)
(register-definition-prefixes "calendar" '("calendar-" "diary-" "holiday-buffer" "lunar-phases-buffer" "solar-sunrises-buffer"))


;;; Generated autoloads from gnus/canlock.el

(autoload 'canlock-insert-header "canlock" "\
Insert a Cancel-Key and/or a Cancel-Lock header if possible.

(fn &optional ID-FOR-KEY ID-FOR-LOCK PASSWORD)")
(autoload 'canlock-verify "canlock" "\
Verify Cancel-Lock or Cancel-Key in BUFFER.
If BUFFER is nil, the current buffer is assumed.  Signal an error if
it fails.

(fn &optional BUFFER)" t)
(register-definition-prefixes "canlock" '("canlock-"))


;;; Generated autoloads from progmodes/cc-align.el

(register-definition-prefixes "cc-align" '("c-"))


;;; Generated autoloads from progmodes/cc-awk.el

(register-definition-prefixes "cc-awk" '("awk-" "c-awk-"))


;;; Generated autoloads from progmodes/cc-bytecomp.el

(register-definition-prefixes "cc-bytecomp" '("cc-"))


;;; Generated autoloads from progmodes/cc-cmds.el

(register-definition-prefixes "cc-cmds" '("c-"))


;;; Generated autoloads from progmodes/cc-defs.el

(register-definition-prefixes "cc-defs" '("c-" "cc-bytecomp-compiling-or-loading"))


;;; Generated autoloads from progmodes/cc-engine.el

(autoload 'c-guess-basic-syntax "cc-engine" "\
Return the syntactic context of the current line.")
(register-definition-prefixes "cc-engine" '("c-"))


;;; Generated autoloads from progmodes/cc-fonts.el

(register-definition-prefixes "cc-fonts" '("autodoc-" "c++-font-lock-keywords" "c-" "doxygen-font-lock-" "gtkdoc-font-lock-" "idl-font-lock-keywords" "java" "objc-font-lock-keywords" "pike-font-lock-keywords"))


;;; Generated autoloads from progmodes/cc-guess.el

(defvar c-guess-guessed-offsets-alist nil "\
Currently guessed offsets-alist.")
(defvar c-guess-guessed-basic-offset nil "\
Currently guessed basic-offset.")
(autoload 'c-guess "cc-guess" "\
Guess the style in the region up to `c-guess-region-max', and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

(fn &optional ACCUMULATE)" t)
(autoload 'c-guess-no-install "cc-guess" "\
Guess the style in the region up to `c-guess-region-max'; don't install it.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

(fn &optional ACCUMULATE)" t)
(autoload 'c-guess-buffer "cc-guess" "\
Guess the style on the whole current buffer, and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

(fn &optional ACCUMULATE)" t)
(autoload 'c-guess-buffer-no-install "cc-guess" "\
Guess the style on the whole current buffer; don't install it.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

(fn &optional ACCUMULATE)" t)
(autoload 'c-guess-region "cc-guess" "\
Guess the style on the region and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

(fn START END &optional ACCUMULATE)" t)
(autoload 'c-guess-region-no-install "cc-guess" "\
Guess the style on the region; don't install it.

Every line of code in the region is examined and values for the following two
variables are guessed:

* `c-basic-offset', and
* the indentation values of the various syntactic symbols in
  `c-offsets-alist'.

The guessed values are put into `c-guess-guessed-basic-offset' and
`c-guess-guessed-offsets-alist'.

Frequencies of use are taken into account when guessing, so minor
inconsistencies in the indentation style shouldn't produce wrong guesses.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous examination is extended, otherwise a new
guess is made from scratch.

Note that the larger the region to guess in, the slower the guessing.
So you can limit the region with `c-guess-region-max'.

(fn START END &optional ACCUMULATE)" t)
(autoload 'c-guess-install "cc-guess" "\
Install the latest guessed style into the current buffer.
(This guessed style is a combination of `c-guess-guessed-basic-offset',
`c-guess-guessed-offsets-alist' and `c-offsets-alist'.)

The style is entered into CC Mode's style system by
`c-add-style'.  Its name is either STYLE-NAME, or a name based on
the absolute file name of the file if STYLE-NAME is nil.

(fn &optional STYLE-NAME)" t)
(register-definition-prefixes "cc-guess" '("c-guess-"))


;;; Generated autoloads from progmodes/cc-langs.el

(register-definition-prefixes "cc-langs" '("c-"))


;;; Generated autoloads from progmodes/cc-menus.el

(register-definition-prefixes "cc-menus" '("cc-imenu-"))


;;; Generated autoloads from progmodes/cc-mode.el

(push (purecopy '(cc-mode 5 33 1)) package--builtin-versions)
(autoload 'c-initialize-cc-mode "cc-mode" "\
Initialize CC Mode for use in the current buffer.
If the optional NEW-STYLE-INIT is nil or left out then all necessary
initialization to run CC Mode for the C language is done.  Otherwise
only some basic setup is done, and a call to `c-init-language-vars' or
`c-init-language-vars-for' is necessary too (which gives more
control).  See \"cc-mode.el\" for more info.

(fn &optional NEW-STYLE-INIT)")
 (add-to-list 'auto-mode-alist '("\\.\\(cc\\|hh\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.[ch]\\(pp\\|xx\\|\\+\\+\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.\\(CC?\\|HH?\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.c\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.h\\'" . c-or-c++-mode))
 (add-to-list 'auto-mode-alist '("\\.y\\(acc\\)?\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.lex\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.i\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.ii\\'" . c++-mode))
(autoload 'c-mode "cc-mode" "\
Major mode for editing C code.

To submit a problem report, enter `\\[c-submit-bug-report]' from a
`c-mode' buffer.  This automatically sets up a mail buffer with version
information already added.  You just need to add a description of the
problem, including a reproducible test case, and send the message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `c-mode-hook'.

Key bindings:
\\{c-mode-map}

(fn)" t)
(autoload 'c-or-c++-mode "cc-mode" "\
Analyze buffer and enable either C or C++ mode.

Some people and projects use .h extension for C++ header files
which is also the one used for C header files.  This makes
matching on file name insufficient for detecting major mode that
should be used.

This function attempts to use file contents to determine whether
the code is C or C++ and based on that chooses whether to enable
`c-mode' or `c++-mode'." t)
(autoload 'c++-mode "cc-mode" "\
Major mode for editing C++ code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
c++-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `c++-mode-hook'.

Key bindings:
\\{c++-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.m\\'" . objc-mode))
(autoload 'objc-mode "cc-mode" "\
Major mode for editing Objective C code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
`objc-mode' buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `objc-mode-hook'.

Key bindings:
\\{objc-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.java\\'" . java-mode))
(autoload 'java-mode "cc-mode" "\
Major mode for editing Java code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
`java-mode' buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `java-mode-hook'.

Key bindings:
\\{java-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.idl\\'" . idl-mode))
(autoload 'idl-mode "cc-mode" "\
Major mode for editing CORBA's IDL, PSDL and CIDL code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
`idl-mode' buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `idl-mode-hook'.

Key bindings:
\\{idl-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.\\(u?lpc\\|pike\\|pmod\\(\\.in\\)?\\)\\'" . pike-mode))
 (add-to-list 'interpreter-mode-alist '("pike" . pike-mode))
(autoload 'pike-mode "cc-mode" "\
Major mode for editing Pike code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
`pike-mode' buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `pike-mode-hook'.

Key bindings:
\\{pike-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.awk\\'" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("awk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("mawk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("nawk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("gawk" . awk-mode))
(autoload 'awk-mode "cc-mode" "\
Major mode for editing AWK code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
`awk-mode' buffer.  This automatically sets up a mail buffer with version
information already added.  You just need to add a description of the
problem, including a reproducible test case, and send the message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `awk-mode-hook'.

Key bindings:
\\{awk-mode-map}

(fn)" t)
(register-definition-prefixes "cc-mode" '("awk-mode-map" "c++-mode-" "c-" "idl-mode-" "java-mode-" "objc-mode-" "pike-mode-"))


;;; Generated autoloads from progmodes/cc-styles.el

(autoload 'c-set-style "cc-styles" "\
Set the current buffer to use the style STYLENAME.
STYLENAME, a string, must be an existing CC Mode style - These are contained
in the variable `c-style-alist'.

The variable `c-indentation-style' will get set to STYLENAME.

\"Setting the style\" is done by setting CC Mode's \"style variables\" to the
values indicated by the pertinent entry in `c-style-alist'.  Other variables
might get set too.

If DONT-OVERRIDE is neither nil nor t, style variables whose default values
have been set (more precisely, whose default values are not the symbol
`set-from-style') will not be changed.  This avoids overriding global settings
done in your init file.  It is useful to call c-set-style from a mode hook
in this way.

If DONT-OVERRIDE is t, style variables that already have values (i.e., whose
values are not the symbol `set-from-style') will not be overridden.  CC Mode
calls c-set-style internally in this way whilst initializing a buffer; if
c-set-style is called like this from anywhere else, it will usually behave as
a null operation.

(fn STYLENAME &optional DONT-OVERRIDE)" t)
(autoload 'c-add-style "cc-styles" "\
Add a style to `c-style-alist', or update an existing one.
STYLE is a string identifying the style to add or update.  DESCRIPTION
is an association list describing the style and must be of the form:

  ([BASESTYLE] (VARIABLE . VALUE) [(VARIABLE . VALUE) ...])

See the variable `c-style-alist' for the semantics of BASESTYLE,
VARIABLE and VALUE.  This function also sets the current style to
STYLE using `c-set-style' if the optional SET-P flag is non-nil.

(fn STYLE DESCRIPTION &optional SET-P)" t)
(autoload 'c-set-offset "cc-styles" "\
Change the value of a syntactic element symbol in `c-offsets-alist'.
SYMBOL is the syntactic element symbol to change and OFFSET is the new
offset for that syntactic element.  The optional argument is not used
and exists only for compatibility reasons.

(fn SYMBOL OFFSET &optional IGNORED)" t)
(register-definition-prefixes "cc-styles" '("c-" "cc-choose-style-for-mode"))


;;; Generated autoloads from progmodes/cc-vars.el

(autoload 'c-string-list-p "cc-vars" "\
Return non-nil if VAL is a list of strings.

(fn VAL)")
(put 'c-basic-offset 'safe-local-variable 'integerp)
(put 'c-backslash-column 'safe-local-variable 'integerp)
 (put 'c-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
 (put 'c++-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
 (put 'objc-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
 (put 'java-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
 (put 'idl-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
 (put 'pike-font-lock-extra-types 'safe-local-variable #'c-string-list-p)
(put 'c-file-style 'safe-local-variable 'string-or-null-p)
(register-definition-prefixes "cc-vars" '("awk-mode-hook" "c++-" "c-" "defcustom-c-stylevar" "idl-" "java-" "objc-" "pike-"))


;;; Generated autoloads from international/ccl.el

(autoload 'ccl-compile "ccl" "\
Return the compiled code of CCL-PROGRAM as a vector of integers.

(fn CCL-PROGRAM)")
(autoload 'ccl-dump "ccl" "\
Disassemble compiled CCL-code CODE.

(fn CODE)")
(autoload 'declare-ccl-program "ccl" "\
Declare NAME as a name of CCL program.

This macro exists for backward compatibility.  In the old version of
Emacs, to compile a CCL program which calls another CCL program not
yet defined, it must be declared as a CCL program in advance.  But,
now CCL program names are resolved not at compile time but before
execution.

Optional arg VECTOR is a compiled CCL code of the CCL program.

(fn NAME &optional VECTOR)" nil t)
(autoload 'define-ccl-program "ccl" "\
Set NAME the compiled code of CCL-PROGRAM.

CCL-PROGRAM has this form:
	(BUFFER_MAGNIFICATION
	 CCL_MAIN_CODE
	 [ CCL_EOF_CODE ])

BUFFER_MAGNIFICATION is an integer value specifying the approximate
output buffer magnification size compared with the bytes of input data
text.  It is assured that the actual output buffer has 256 bytes
more than the size calculated by BUFFER_MAGNIFICATION.
If the value is zero, the CCL program can't execute `read' and
`write' commands.

CCL_MAIN_CODE and CCL_EOF_CODE are CCL program codes.  CCL_MAIN_CODE
executed at first.  If there's no more input data when `read' command
is executed in CCL_MAIN_CODE, CCL_EOF_CODE is executed.  If
CCL_MAIN_CODE is terminated, CCL_EOF_CODE is not executed.

Here's the syntax of CCL program code in BNF notation.  The lines
starting by two semicolons (and optional leading spaces) describe the
semantics.

CCL_MAIN_CODE := CCL_BLOCK

CCL_EOF_CODE := CCL_BLOCK

CCL_BLOCK := STATEMENT | (STATEMENT [STATEMENT ...])

STATEMENT :=
	SET | IF | BRANCH | LOOP | REPEAT | BREAK | READ | WRITE | CALL
	| TRANSLATE | MAP | LOOKUP | END

SET :=	(REG = EXPRESSION)
	| (REG ASSIGNMENT_OPERATOR EXPRESSION)
	;; The following form is the same as (r0 = integer).
	| integer

EXPRESSION := ARG | (EXPRESSION OPERATOR ARG)

;; Evaluate EXPRESSION.  If the result is nonzero, execute
;; CCL_BLOCK_0.  Otherwise, execute CCL_BLOCK_1.
IF :=	(if EXPRESSION CCL_BLOCK_0 CCL_BLOCK_1)

;; Evaluate EXPRESSION.  Provided that the result is N, execute
;; CCL_BLOCK_N.
BRANCH := (branch EXPRESSION CCL_BLOCK_0 [CCL_BLOCK_1 ...])

;; Execute STATEMENTs until (break) or (end) is executed.

;; Create a block of STATEMENTs for repeating.  The STATEMENTs
;; are executed sequentially until REPEAT or BREAK is executed.
;; If REPEAT statement is executed, STATEMENTs are executed from the
;; start again.  If BREAK statements is executed, the execution
;; exits from the block.  If neither REPEAT nor BREAK is
;; executed, the execution exits from the block after executing the
;; last STATEMENT.
LOOP := (loop STATEMENT [STATEMENT ...])

;; Terminate the most inner loop.
BREAK := (break)

REPEAT :=
	;; Jump to the head of the most inner loop.
	(repeat)
	;; Same as: ((write [REG | integer | string])
	;;	     (repeat))
	| (write-repeat [REG | integer | string])
	;; Same as: ((write REG [ARRAY])
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG [ARRAY])
	;; Same as: ((write integer)
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG integer)

READ := ;; Set REG_0 to a byte read from the input text, set REG_1
	;; to the next byte read, and so on.
	(read REG_0 [REG_1 ...])
	;; Same as: ((read REG)
	;;	     (if (REG OPERATOR ARG) CCL_BLOCK_0 CCL_BLOCK_1))
	| (read-if (REG OPERATOR ARG) CCL_BLOCK_0 CCL_BLOCK_1)
	;; Same as: ((read REG)
	;;	     (branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...]))
	| (read-branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...])
	;; Read a character from the input text while parsing
	;; multibyte representation, set REG_0 to the charset ID of
	;; the character, set REG_1 to the code point of the
	;; character.  If the dimension of charset is two, set REG_1
	;; to ((CODE0 << 7) | CODE1), where CODE0 is the first code
	;; point and CODE1 is the second code point.
	| (read-multibyte-character REG_0 REG_1)

WRITE :=
	;; Write REG_0, REG_1, ... to the output buffer.  If REG_N is
	;; a multibyte character, write the corresponding multibyte
	;; representation.
	(write REG_0 [REG_1 ...])
	;; Same as: ((r7 = EXPRESSION)
	;;	     (write r7))
	| (write EXPRESSION)
	;; Write the value of `integer' to the output buffer.  If it
	;; is a multibyte character, write the corresponding multibyte
	;; representation.
	| (write integer)
	;; Write the byte sequence of `string' as is to the output
	;; buffer.
	| (write string)
	;; Same as: (write string)
	| string
	;; Provided that the value of REG is N, write Nth element of
	;; ARRAY to the output buffer.  If it is a multibyte
	;; character, write the corresponding multibyte
	;; representation.
	| (write REG ARRAY)
	;; Write a multibyte representation of a character whose
	;; charset ID is REG_0 and code point is REG_1.  If the
	;; dimension of the charset is two, REG_1 should be ((CODE0 <<
	;; 7) | CODE1), where CODE0 is the first code point and CODE1
	;; is the second code point of the character.
	| (write-multibyte-character REG_0 REG_1)

;; Call CCL program whose name is ccl-program-name.
CALL := (call ccl-program-name)

;; Terminate the CCL program.
END := (end)

;; CCL registers that can contain any integer value.  As r7 is also
;; used by CCL interpreter, its value is changed unexpectedly.
REG := r0 | r1 | r2 | r3 | r4 | r5 | r6 | r7

ARG := REG | integer

OPERATOR :=
	;; Normal arithmetic operators (same meaning as C code).
	+ | - | * | / | %

	;; Bitwise operators (same meaning as C code)
	| & | `|' | ^

	;; Shifting operators (same meaning as C code)
	| << | >>

	;; (REG = ARG_0 <8 ARG_1) means:
	;;	(REG = ((ARG_0 << 8) | ARG_1))
	| <8

	;; (REG = ARG_0 >8 ARG_1) means:
	;;	((REG = (ARG_0 >> 8))
	;;	 (r7 = (ARG_0 & 255)))
	| >8

	;; (REG = ARG_0 // ARG_1) means:
	;;	((REG = (ARG_0 / ARG_1))
	;;	 (r7 = (ARG_0 % ARG_1)))
	| //

	;; Normal comparing operators (same meaning as C code)
	| < | > | == | <= | >= | !=

	;; If ARG_0 and ARG_1 are higher and lower byte of Shift-JIS
	;; code, and CHAR is the corresponding JISX0208 character,
	;; (REG = ARG_0 de-sjis ARG_1) means:
	;;	((REG = CODE0)
	;;	 (r7 = CODE1))
	;; where CODE0 is the first code point of CHAR, CODE1 is the
	;; second code point of CHAR.
	| de-sjis

	;; If ARG_0 and ARG_1 are the first and second code point of
	;; JISX0208 character CHAR, and SJIS is the corresponding
	;; Shift-JIS code,
	;; (REG = ARG_0 en-sjis ARG_1) means:
	;;	((REG = HIGH)
	;;	 (r7 = LOW))
	;; where HIGH is the higher byte of SJIS, LOW is the lower
	;; byte of SJIS.
	| en-sjis

ASSIGNMENT_OPERATOR :=
	;; Same meaning as C code
	+= | -= | *= | /= | %= | &= | `|=' | ^= | <<= | >>=

	;; (REG <8= ARG) is the same as:
	;;	((REG <<= 8)
	;;	 (REG |= ARG))
	| <8=

	;; (REG >8= ARG) is the same as:
	;;	((r7 = (REG & 255))
	;;	 (REG >>= 8))

	;; (REG //= ARG) is the same as:
	;;	((r7 = (REG % ARG))
	;;	 (REG /= ARG))
	| //=

ARRAY := `[' integer ... `]'


TRANSLATE :=
	;; Decode character SRC, translate it by translate table
	;; TABLE, and encode it back to DST.  TABLE is specified
	;; by its id number in REG_0, SRC is specified by its
	;; charset id number and codepoint in REG_1 and REG_2
	;; respectively.
	;; On encoding, the charset of highest priority is selected.
	;; After the execution, DST is specified by its charset
	;; id number and codepoint in REG_1 and REG_2 respectively.
	(translate-character REG_0 REG_1 REG_2)

	;; Same as above except for SYMBOL specifying the name of
	;; the translate table defined by `define-translation-table'.
	| (translate-character SYMBOL REG_1 REG_2)

LOOKUP :=
	;; Look up character SRC in hash table TABLE.  TABLE is
	;; specified by its name in SYMBOL, and SRC is specified by
	;; its charset id number and codepoint in REG_1 and REG_2
	;; respectively.
	;; If its associated value is an integer, set REG_1 to that
	;; value, and set r7 to 1.  Otherwise, set r7 to 0.
	(lookup-character SYMBOL REG_1 REG_2)

	;; Look up integer value N in hash table TABLE.  TABLE is
	;; specified by its name in SYMBOL and N is specified in
	;; REG.
	;; If its associated value is a character, set REG to that
	;; value, and set r7 to 1.  Otherwise, set r7 to 0.
	| (lookup-integer SYMBOL REG(integer))

MAP :=
	;; The following statements are for internal use only.
	(iterate-multiple-map REG REG MAP-IDs)
	| (map-multiple REG REG (MAP-SET))
	| (map-single REG REG MAP-ID)

MAP-IDs := MAP-ID ...
MAP-SET := MAP-IDs | (MAP-IDs) MAP-SET
MAP-ID := integer

(fn NAME CCL-PROGRAM &optional DOC)" nil t)
(function-put 'define-ccl-program 'doc-string-elt 3)
(function-put 'define-ccl-program 'lisp-indent-function 'defun)
(autoload 'check-ccl-program "ccl" "\
Check validity of CCL-PROGRAM.
If CCL-PROGRAM is a symbol denoting a CCL program, return
CCL-PROGRAM, else return nil.
If CCL-PROGRAM is a vector and optional arg NAME (symbol) is supplied,
register CCL-PROGRAM by name NAME, and return NAME.

(fn CCL-PROGRAM &optional NAME)" nil t)
(autoload 'ccl-execute-with-args "ccl" "\
Execute CCL-PROGRAM with registers initialized by the remaining args.
The return value is a vector of resulting CCL registers.

See the documentation of `define-ccl-program' for the detail of CCL program.

(fn CCL-PROG &rest ARGS)")
(register-definition-prefixes "ccl" '("ccl-"))


;;; Generated autoloads from cdl.el

(register-definition-prefixes "cdl" '("cdl-"))


;;; Generated autoloads from cedet/cedet.el

(push (purecopy '(cedet 2 0)) package--builtin-versions)
(register-definition-prefixes "cedet" '("cedet-"))


;;; Generated autoloads from cedet/cedet-cscope.el

(register-definition-prefixes "cedet-cscope" '("cedet-cscope-"))


;;; Generated autoloads from cedet/cedet-files.el

(register-definition-prefixes "cedet-files" '("cedet-"))


;;; Generated autoloads from cedet/cedet-global.el

(register-definition-prefixes "cedet-global" '("cedet-g"))


;;; Generated autoloads from cedet/cedet-idutils.el

(register-definition-prefixes "cedet-idutils" '("cedet-idutils-"))


;;; Generated autoloads from progmodes/cfengine.el

(push (purecopy '(cfengine 1 4)) package--builtin-versions)
(autoload 'cfengine3-mode "cfengine" "\
Major mode for editing CFEngine3 input.
There are no special keybindings by default.

Action blocks are treated as defuns, i.e. \\[beginning-of-defun] moves
to the action header.

(fn)" t)
(autoload 'cfengine2-mode "cfengine" "\
Major mode for editing CFEngine2 input.
There are no special keybindings by default.

Action blocks are treated as defuns, i.e. \\[beginning-of-defun] moves
to the action header.

(fn)" t)
(autoload 'cfengine-auto-mode "cfengine" "\
Choose `cfengine2-mode' or `cfengine3-mode' by buffer contents." t)
(register-definition-prefixes "cfengine" '("cfengine"))


;;; Generated autoloads from char-fold.el

(autoload 'char-fold-to-regexp "char-fold" "\
Return a regexp matching anything that char-folds into STRING.
Any character in STRING that has an entry in
`char-fold-table' is replaced with that entry (which is a
regexp) and other characters are `regexp-quote'd.

When LAX is non-nil, then the final character also matches ligatures
partially, for instance, the search string \"f\" will match \"ﬁ\",
so when typing the search string in isearch while the cursor is on
a ligature, the search won't try to immediately advance to the next
complete match, but will stay on the partially matched ligature.

If the resulting regexp would be too long for Emacs to handle,
just return the result of calling `regexp-quote' on STRING.

FROM is for internal use.  It specifies an index in the STRING
from which to start.

(fn STRING &optional LAX FROM)")
(autoload 'describe-char-fold-equivalences "char-fold" "\
Display characters equivalent to CHAR under character-folding.
Prompt for CHAR (using `read-char-by-name', which see for how to
specify the character).  With no input, i.e. when CHAR is nil,
describe all available character equivalences of `char-fold-to-regexp'.
Optional argument LAX (interactively, the prefix argument), if
non-nil, means also include partially matching ligatures and
non-canonical equivalences.

Each line of the display shows the equivalences in two different
ways separated by a colon:

    - as the literal character or sequence
    - using an ASCII-only escape syntax

For example, for the letter \\='r\\=', the first line is

    r: ?\\N{LATIN SMALL LETTER R}

which is for the requested character itself, and a later line has

    ṟ: ?\\N{LATIN SMALL LETTER R}?\\N{COMBINING MACRON BELOW}

which clearly shows what the constituent characters are.

(fn CHAR &optional LAX)" t)
(register-definition-prefixes "char-fold" '("char-fold-"))


;;; Generated autoloads from emacs-lisp/chart.el

(register-definition-prefixes "chart" '("chart"))


;;; Generated autoloads from cedet/semantic/chart.el

(register-definition-prefixes "semantic/chart" '("semantic-chart-"))


;;; Generated autoloads from emacs-lisp/check-declare.el

(autoload 'check-declare-file "check-declare" "\
Check veracity of all `declare-function' statements in FILE.
See `check-declare-directory' for more information.

(fn FILE)" t)
(autoload 'check-declare-directory "check-declare" "\
Check veracity of all `declare-function' statements under directory ROOT.
Returns non-nil if any false statements are found.

(fn ROOT)" t)
(register-definition-prefixes "check-declare" '("check-declare-"))


;;; Generated autoloads from emacs-lisp/checkdoc.el

(put 'checkdoc-force-docstrings-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-force-history-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-permit-comma-termination-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-spellcheck-documentation-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-ispell-list-words 'safe-local-variable #'list-of-strings-p)
(put 'checkdoc-arguments-in-order-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-verb-check-experimental-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-symbol-words 'safe-local-variable #'list-of-strings-p)
(put 'checkdoc-proper-noun-regexp 'safe-local-variable 'stringp)
(put 'checkdoc-common-verbs-regexp 'safe-local-variable 'stringp)
(autoload 'checkdoc "checkdoc" "\
Interactively check the entire buffer for style errors.
The current status of the check will be displayed in a buffer which
the users will view as each check is completed." '(emacs-lisp-mode))
(autoload 'checkdoc-interactive "checkdoc" "\
Interactively check the current buffer for doc string errors.
Prefix argument START-HERE will start the checking from the current
point, otherwise the check starts at the beginning of the current
buffer.  Allows navigation forward and backwards through document
errors.  Does not check for comment or space warnings.
Optional argument SHOWSTATUS indicates that we should update the
checkdoc status window instead of the usual behavior.

(fn &optional START-HERE SHOWSTATUS)" '(emacs-lisp-mode))
(autoload 'checkdoc-message-interactive "checkdoc" "\
Interactively check the current buffer for message string errors.
Prefix argument START-HERE will start the checking from the current
point, otherwise the check starts at the beginning of the current
buffer.  Allows navigation forward and backwards through document
errors.  Does not check for comment or space warnings.
Optional argument SHOWSTATUS indicates that we should update the
checkdoc status window instead of the usual behavior.

(fn &optional START-HERE SHOWSTATUS)" '(emacs-lisp-mode))
(autoload 'checkdoc-eval-current-buffer "checkdoc" "\
Evaluate and check documentation for the current buffer.
Evaluation is done first because good documentation for something that
doesn't work is just not useful.  Comments, doc strings, and rogue
spacing are all verified." t)
(autoload 'checkdoc-current-buffer "checkdoc" "\
Check current buffer for document, comment, error style, and rogue spaces.
With a prefix argument (in Lisp, the argument TAKE-NOTES),
store all errors found in a warnings buffer,
otherwise stop after the first error.

(fn &optional TAKE-NOTES)" '(emacs-lisp-mode))
(autoload 'checkdoc-file "checkdoc" "\
Check FILE for document, comment, error style, and rogue spaces.

(fn FILE)")
(autoload 'checkdoc-start "checkdoc" "\
Start scanning the current buffer for documentation string style errors.
Only documentation strings are checked.
Use `checkdoc-continue' to continue checking if an error cannot be fixed.
Prefix argument TAKE-NOTES means to collect all the warning messages into
a separate buffer.

(fn &optional TAKE-NOTES)" '(emacs-lisp-mode))
(autoload 'checkdoc-continue "checkdoc" "\
Find the next doc string in the current buffer which has a style error.
Prefix argument TAKE-NOTES means to continue through the whole
buffer and save warnings in a separate buffer.

(fn &optional TAKE-NOTES)" '(emacs-lisp-mode))
(autoload 'checkdoc-comments "checkdoc" "\
Find missing comment sections in the current Emacs Lisp file.
Prefix argument TAKE-NOTES non-nil means to save warnings in a
separate buffer.  Otherwise print a message.  This returns the error
if there is one.

(fn &optional TAKE-NOTES)" '(emacs-lisp-mode))
(autoload 'checkdoc-rogue-spaces "checkdoc" "\
Find extra spaces at the end of lines in the current file.
Prefix argument TAKE-NOTES non-nil means to save warnings in a
separate buffer.  Otherwise print a message.  This returns the error
if there is one.
Optional argument INTERACT permits more interactive fixing.

(fn &optional TAKE-NOTES INTERACT)" '(emacs-lisp-mode))
(autoload 'checkdoc-message-text "checkdoc" "\
Scan the buffer for occurrences of the error function, and verify text.
Optional argument TAKE-NOTES causes all errors to be logged.

(fn &optional TAKE-NOTES)" '(emacs-lisp-mode))
(autoload 'checkdoc-eval-defun "checkdoc" "\
Evaluate the current form with `eval-defun' and check its documentation.
Evaluation is done first so the form will be read before the
documentation is checked.  If there is a documentation error, then the display
of what was evaluated will be overwritten by the diagnostic message." t)
(autoload 'checkdoc-defun "checkdoc" "\
Examine the doc string of the function or variable under point.
Call `error' if the doc string has problems.  If NO-ERROR is
non-nil, then do not call error, but call `message' instead.
If the doc string passes the test, then check the function for rogue white
space at the end of each line.

(fn &optional NO-ERROR)" t)
(autoload 'checkdoc-dired "checkdoc" "\
In Dired, run `checkdoc' on marked files.
Skip anything that doesn't have the Emacs Lisp library file
extension (\".el\").
When called from Lisp, FILES is a list of filenames.

(fn FILES)" '(dired-mode))
(autoload 'checkdoc-ispell "checkdoc" "\
Check the style and spelling of everything interactively.
Calls `checkdoc' with spell-checking turned on.
Prefix argument is the same as for `checkdoc'." t)
(autoload 'checkdoc-ispell-current-buffer "checkdoc" "\
Check the style and spelling of the current buffer.
Calls `checkdoc-current-buffer' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-current-buffer'." t)
(autoload 'checkdoc-ispell-interactive "checkdoc" "\
Check the style and spelling of the current buffer interactively.
Calls `checkdoc-interactive' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-interactive'." t)
(autoload 'checkdoc-ispell-message-interactive "checkdoc" "\
Check the style and spelling of message text interactively.
Calls `checkdoc-message-interactive' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-message-interactive'." t)
(autoload 'checkdoc-ispell-message-text "checkdoc" "\
Check the style and spelling of message text interactively.
Calls `checkdoc-message-text' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-message-text'." t)
(autoload 'checkdoc-ispell-start "checkdoc" "\
Check the style and spelling of the current buffer.
Calls `checkdoc-start' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-start'." t)
(autoload 'checkdoc-ispell-continue "checkdoc" "\
Check the style and spelling of the current buffer after point.
Calls `checkdoc-continue' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-continue'." t)
(autoload 'checkdoc-ispell-comments "checkdoc" "\
Check the style and spelling of the current buffer's comments.
Calls `checkdoc-comments' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-comments'." t)
(autoload 'checkdoc-ispell-defun "checkdoc" "\
Check the style and spelling of the current defun with Ispell.
Calls `checkdoc-defun' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-defun'." t)
(autoload 'checkdoc-minor-mode "checkdoc" "\
Toggle automatic docstring checking (Checkdoc minor mode).

In Checkdoc minor mode, the usual bindings for `eval-defun' which is
bound to \\<checkdoc-minor-mode-map>\\[checkdoc-eval-defun] and `checkdoc-eval-current-buffer' are overridden to include
checking of documentation strings.

\\{checkdoc-minor-mode-map}

This is a minor mode.  If called interactively, toggle the `Checkdoc
minor mode' mode.  If the prefix argument is positive, enable the mode,
and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `checkdoc-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'checkdoc-package-keywords "checkdoc" "\
Find package keywords that aren't in `finder-known-keywords'." t)
(register-definition-prefixes "checkdoc" '("checkdoc-"))


;;; Generated autoloads from language/china-util.el

(autoload 'decode-hz-region "china-util" "\
Decode HZ/ZW encoded text in the current region.
Return the length of resulting text.

(fn BEG END)" t)
(autoload 'decode-hz-buffer "china-util" "\
Decode HZ/ZW encoded text in the current buffer." t)
(autoload 'encode-hz-region "china-util" "\
Encode the text in the current region to HZ.
Return the length of resulting text.

(fn BEG END)" t)
(autoload 'encode-hz-buffer "china-util" "\
Encode the text in the current buffer to HZ." t)
(autoload 'post-read-decode-hz "china-util" "\


(fn LEN)")
(autoload 'pre-write-encode-hz "china-util" "\


(fn FROM TO)")
(register-definition-prefixes "china-util" '("decode-hz-line-continuation" "hz-" "hz/zw-start-gb" "iso2022-" "zw-start-gb"))


;;; Generated autoloads from chistory.el

(autoload 'repeat-matching-complex-command "chistory" "\
Edit and re-evaluate complex command with name matching PATTERN.
Matching occurrences are displayed, most recent first, until you select
a form for evaluation.  If PATTERN is empty (or nil), every form in the
command history is offered.  The form is placed in the minibuffer for
editing and the result is evaluated.

(fn &optional PATTERN)" t)
(autoload 'list-command-history "chistory" "\
List history of commands that used the minibuffer.
The number of commands listed is controlled by `list-command-history-max'.
Calls value of `list-command-history-filter' (if non-nil) on each history
element to judge if that element should be excluded from the list.

The buffer is left in Command History mode." t)
(autoload 'command-history "chistory" "\
Examine commands from variable `command-history' in a buffer.
The number of commands listed is controlled by `list-command-history-max'.
The command history is filtered by `list-command-history-filter' if non-nil.
Use \\<command-history-mode-map>\\[command-history-repeat] to repeat the command on the current line.

Otherwise much like Emacs-Lisp Mode except that there is no self-insertion
and digits provide prefix arguments.  Tab does not indent.
\\{command-history-mode-map}

This command always recompiles the Command History listing
and runs the normal hook `command-history-hook'." t)
(register-definition-prefixes "chistory" '("command-history-" "default-command-history-filter" "list-command-history-"))


;;; Generated autoloads from emacs-lisp/cl-extra.el

(register-definition-prefixes "cl-extra" '("cl-"))


;;; Generated autoloads from progmodes/cl-font-lock.el

(defvar cl-font-lock-built-in-mode nil "\
Non-nil if Cl-Font-Lock-Built-In mode is enabled.
See the `cl-font-lock-built-in-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `cl-font-lock-built-in-mode'.")
(custom-autoload 'cl-font-lock-built-in-mode "cl-font-lock" nil)
(autoload 'cl-font-lock-built-in-mode "cl-font-lock" "\
Highlight built-in functions, variables, and types in `lisp-mode'.

This is a global minor mode.  If called interactively, toggle the
`Cl-Font-Lock-Built-In mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='cl-font-lock-built-in-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "cl-font-lock" '("cl-font-lock-"))


;;; Generated autoloads from emacs-lisp/cl-generic.el

(push (purecopy '(cl-generic 1 0)) package--builtin-versions)


;;; Generated autoloads from emacs-lisp/cl-indent.el

(autoload 'common-lisp-indent-function "cl-indent" "\
Function to indent the arguments of a Lisp function call.
This is suitable for use as the value of the variable
`lisp-indent-function'.  INDENT-POINT is the point at which the
indentation function is called, and STATE is the
`parse-partial-sexp' state at that position.  Browse the
`lisp-indent' customize group for options affecting the behavior
of this function.

If the indentation point is in a call to a Lisp function, that
function's `common-lisp-indent-function' property specifies how
this function should indent it.  Possible values for this
property are:

* defun, meaning indent according to `lisp-indent-defun-method';
  i.e., like (4 &lambda &body), as explained below.

* any other symbol, meaning a function to call.  The function should
  take the arguments: PATH STATE INDENT-POINT SEXP-COLUMN NORMAL-INDENT.
  PATH is a list of integers describing the position of point in terms of
  list-structure with respect to the containing lists.  For example, in
  ((a b c (d foo) f) g), foo has a path of (0 3 1).  In other words,
  to reach foo take the 0th element of the outermost list, then
  the 3rd element of the next list, and finally the 1st element.
  STATE and INDENT-POINT are as in the arguments to
  `common-lisp-indent-function'.  SEXP-COLUMN is the column of
  the open parenthesis of the innermost containing list.
  NORMAL-INDENT is the column the indentation point was
  originally in.  This function should behave like `lisp-indent-259'.

* an integer N, meaning indent the first N arguments like
  function arguments, and any further arguments like a body.
  This is equivalent to (4 4 ... &body).

* a list.  The list element in position M specifies how to indent the Mth
  function argument.  If there are fewer elements than function arguments,
  the last list element applies to all remaining arguments.  The accepted
  list elements are:

  * nil, meaning the default indentation.

  * an integer, specifying an explicit indentation.

  * &lambda.  Indent the argument (which may be a list) by 4.

  * &rest.  When used, this must be the penultimate element.  The
    element after this one applies to all remaining arguments.

  * &body.  This is equivalent to &rest lisp-body-indent, i.e., indent
    all remaining elements by `lisp-body-indent'.

  * &whole.  This must be followed by nil, an integer, or a
    function symbol.  This indentation is applied to the
    associated argument, and as a base indent for all remaining
    arguments.  For example, an integer P means indent this
    argument by P, and all remaining arguments by P, plus the
    value specified by their associated list element.

  * a symbol.  A function to call, with the 6 arguments specified above.

  * a list, with elements as described above.  This applies when the
    associated function argument is itself a list.  Each element of the list
    specifies how to indent the associated argument.

For example, the function `case' has an indent property
(4 &rest (&whole 2 &rest 1)), meaning:
  * indent the first argument by 4.
  * arguments after the first should be lists, and there may be any number
    of them.  The first list element has an offset of 2, all the rest
    have an offset of 2+1=3.

If the current mode is actually `emacs-lisp-mode', look for a
`common-lisp-indent-function-for-elisp' property before looking
at `common-lisp-indent-function' and, if set, use its value
instead.

(fn INDENT-POINT STATE)")
(register-definition-prefixes "cl-indent" '("common-lisp-" "lisp-"))


;;; Generated autoloads from emacs-lisp/cl-lib.el

(push (purecopy '(cl-lib 1 0)) package--builtin-versions)
(defvar cl-custom-print-functions nil "\
This is a list of functions that format user objects for printing.
Each function is called in turn with three arguments: the object, the
stream, and the print level (currently ignored).  If it is able to
print the object it returns true; otherwise it returns nil and the
printer proceeds to the next function on the list.

This variable is not used at present, but it is defined in hopes that
a future Emacs interpreter will be able to use it.")
(autoload 'cl-incf "cl-lib" "\
Increment PLACE by X (1 by default).
PLACE may be a symbol, or any generalized variable allowed by `setf'.
The return value is the incremented value of PLACE.

If X is specified, it should be an expression that should
evaluate to a number.

(fn PLACE &optional X)" nil t)
(defvar cl-old-struct-compat-mode nil "\
Non-nil if Cl-Old-Struct-Compat mode is enabled.
See the `cl-old-struct-compat-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `cl-old-struct-compat-mode'.")
(custom-autoload 'cl-old-struct-compat-mode "cl-lib" nil)
(autoload 'cl-old-struct-compat-mode "cl-lib" "\
Enable backward compatibility with old-style structs.

This can be needed when using code byte-compiled using the old
macro-expansion of `cl-defstruct' that used vectors objects instead
of record objects.

This is a global minor mode.  If called interactively, toggle the
`Cl-Old-Struct-Compat mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='cl-old-struct-compat-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "cl-lib" '("cl-"))


;;; Generated autoloads from emacs-lisp/cl-macs.el

(register-definition-prefixes "cl-macs" '("cl-"))


;;; Generated autoloads from emacs-lisp/cl-print.el

(push (purecopy '(cl-print 1 0)) package--builtin-versions)
(autoload 'cl-print-object "cl-print" "\
Dispatcher to print OBJECT on STREAM according to its type.
You can add methods to it to customize the output.
But if you just want to print something, don't call this directly:
call other entry points instead, such as `cl-prin1'.

(fn OBJECT STREAM)")
(autoload 'cl-prin1 "cl-print" "\
Print OBJECT on STREAM according to its type.
Output is further controlled by the variables
`cl-print-readably', `cl-print-compiled', along with output
variables for the standard printing functions.  See Info
node `(elisp)Output Variables'.

(fn OBJECT &optional STREAM)")
(autoload 'cl-prin1-to-string "cl-print" "\
Return a string containing the `cl-prin1'-printed representation of OBJECT.

(fn OBJECT)")
(autoload 'cl-print-to-string-with-limit "cl-print" "\
Return a string containing a printed representation of VALUE.
Attempt to get the length of the returned string under LIMIT
characters with appropriate settings of `print-level',
`print-length', and `cl-print-string-length'.  Use
PRINT-FUNCTION to print, which should take the arguments VALUE
and STREAM and which should respect `print-length',
`print-level', and `cl-print-string-length'.  LIMIT may be nil or
zero in which case PRINT-FUNCTION will be called with these
settings bound to nil, and it can also be t in which case
PRINT-FUNCTION will be called with their current values.

Use this function with `cl-prin1' to print an object,
abbreviating it with ellipses to fit within a size limit.

(fn PRINT-FUNCTION VALUE LIMIT)")
(register-definition-prefixes "cl-print" '("cl-print-" "help-byte-code"))


;;; Generated autoloads from emacs-lisp/cl-seq.el

(register-definition-prefixes "cl-seq" '("cl--"))


;;; Generated autoloads from progmodes/cmacexp.el

(autoload 'c-macro-expand "cmacexp" "\
Expand C macros in the region, using the C preprocessor.
Normally display output in temp buffer, but
prefix arg means replace the region with it.

`c-macro-preprocessor' specifies the preprocessor to use.
If the user option `c-macro-prompt-flag' is non-nil
prompt for arguments to the preprocessor (e.g. `-DDEBUG -I ./include'),
otherwise use `c-macro-cppflags'.

Noninteractive args are START, END, SUBST.
For use inside Lisp programs, see also `c-macro-expansion'.

(fn START END SUBST)" t)
(register-definition-prefixes "cmacexp" '("c-macro-"))


;;; Generated autoloads from progmodes/cmake-ts-mode.el

(autoload 'cmake-ts-mode "cmake-ts-mode" "\
Major mode for editing CMake files, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "cmake-ts-mode" '("cmake-ts-mode-"))


;;; Generated autoloads from cmuscheme.el

(autoload 'run-scheme "cmuscheme" "\
Run an inferior Scheme process, input and output via buffer `*scheme*'.
If there is a process already running in `*scheme*', switch to that buffer.
With argument, allows you to edit the command line (default is value
of `scheme-program-name').
If the file `~/.emacs_SCHEMENAME' or `~/.emacs.d/init_SCHEMENAME.scm' exists,
it is given as initial input.
Note that this may lose due to a timing error if the Scheme processor
discards input when it starts up.
Runs the hook `inferior-scheme-mode-hook' (after the `comint-mode-hook'
is run).
(Type \\[describe-mode] in the process buffer for a list of commands.)

(fn CMD)" t)
(register-definition-prefixes "cmuscheme" '("cmuscheme-load-hook" "inferior-scheme-" "scheme-" "switch-to-scheme"))


;;; Generated autoloads from color.el

(autoload 'color-name-to-rgb "color" "\
Convert COLOR string to a list of normalized RGB components.
COLOR should be a color name (e.g. \"white\") or an RGB triplet
string (e.g. \"#ffff1122eecc\").

COLOR can also be the symbol `unspecified' or one of the strings
\"unspecified-fg\" or \"unspecified-bg\", in which case the
return value is nil.

Normally the return value is a list of three floating-point
numbers, (RED GREEN BLUE), each between 0.0 and 1.0 inclusive.

Optional argument FRAME specifies the frame where the color is to be
displayed.  If FRAME is omitted or nil, use the selected frame.
If FRAME cannot display COLOR, return nil.

(fn COLOR &optional FRAME)")
(register-definition-prefixes "color" '("color-"))


;;; Generated autoloads from comint.el

(defvar comint-output-filter-functions '(ansi-color-process-output comint-postoutput-scroll-to-bottom comint-watch-for-password-prompt) "\
Functions to call after output is inserted into the buffer.
One possible function is `comint-postoutput-scroll-to-bottom'.
These functions get one argument, a string containing the text as originally
inserted.  Note that this might not be the same as the buffer contents between
`comint-last-output-start' and the buffer's `process-mark', if other filter
functions have already modified the buffer.

See also `comint-preoutput-filter-functions'.

You can use `add-hook' to add functions to this list
either globally or locally.")
(autoload 'make-comint-in-buffer "comint" "\
Make a Comint process NAME in BUFFER, running PROGRAM.
If BUFFER is nil, it defaults to NAME surrounded by `*'s.
If there is a running process in BUFFER, it is not restarted.

PROGRAM should be one of the following:
- a string, denoting an executable program to create via
  `start-file-process'
- a cons pair of the form (HOST . SERVICE), denoting a TCP
  connection to be opened via `open-network-stream'
- nil, denoting a newly-allocated pty.

Optional fourth arg STARTFILE is the name of a file, whose
contents are sent to the process as its initial input.

If PROGRAM is a string, any more args are arguments to PROGRAM.

Return the (possibly newly created) process buffer.

(fn NAME BUFFER PROGRAM &optional STARTFILE &rest SWITCHES)")
(autoload 'make-comint "comint" "\
Make a Comint process NAME in a buffer, running PROGRAM.
The name of the buffer is made by surrounding NAME with `*'s.
PROGRAM should be either a string denoting an executable program to create
via `start-file-process', or a cons pair of the form (HOST . SERVICE) denoting
a TCP connection to be opened via `open-network-stream'.  If there is already
a running process in that buffer, it is not restarted.  Optional third arg
STARTFILE is the name of a file, whose contents are sent to the
process as its initial input.

If PROGRAM is a string, any more args are arguments to PROGRAM.

Returns the (possibly newly created) process buffer.

(fn NAME PROGRAM &optional STARTFILE &rest SWITCHES)")
(autoload 'comint-run "comint" "\
Run PROGRAM in a Comint buffer and switch to that buffer.

If SWITCHES are supplied, they are passed to PROGRAM.  With prefix argument
\\[universal-argument] prompt for SWITCHES as well as PROGRAM.

The buffer name is made by surrounding the file name of PROGRAM with `*'s.
The file name is used to make a symbol name, such as `comint-sh-hook', and any
hooks on this symbol are run in the buffer.

See `make-comint' and `comint-exec'.

(fn PROGRAM &optional SWITCHES)" t)
(function-put 'comint-run 'interactive-only 'make-comint)
(defvar comint-file-name-prefix (purecopy "") "\
Prefix prepended to absolute file names taken from process input.
This is used by Comint's and shell's completion functions, and by shell's
directory tracking functions.")
(autoload 'comint-redirect-send-command "comint" "\
Send COMMAND to process in current buffer, with output to OUTPUT-BUFFER.
With prefix arg ECHO, echo output in process buffer.

If NO-DISPLAY is non-nil, do not show the output buffer.

(fn COMMAND OUTPUT-BUFFER ECHO &optional NO-DISPLAY)" '(comint-mode))
(autoload 'comint-redirect-send-command-to-process "comint" "\
Send COMMAND to PROCESS, with output to OUTPUT-BUFFER.
With prefix arg, echo output in process buffer.

If NO-DISPLAY is non-nil, do not show the output buffer.

(fn COMMAND OUTPUT-BUFFER PROCESS ECHO &optional NO-DISPLAY)" '(comint-mode))
(autoload 'comint-redirect-results-list "comint" "\
Send COMMAND to current process.
Return a list of expressions in the output which match REGEXP.
REGEXP-GROUP is the regular expression group in REGEXP to use.

(fn COMMAND REGEXP REGEXP-GROUP)")
(autoload 'comint-redirect-results-list-from-process "comint" "\
Send COMMAND to PROCESS.
Return a list of expressions in the output which match REGEXP.
REGEXP-GROUP is the regular expression group in REGEXP to use.

(fn PROCESS COMMAND REGEXP REGEXP-GROUP)")
(register-definition-prefixes "comint" '("comint-"))


;;; Generated autoloads from emacs-lisp/comp.el

(put 'no-native-compile 'safe-local-variable 'booleanp)
(autoload 'comp-c-func-name "comp" "\
Given NAME, return a name suitable for the native code.
Add PREFIX in front of it.  If FIRST is not nil, pick the first
available name ignoring compilation context and potential name
clashes.

(fn NAME PREFIX &optional FIRST)")
(autoload 'comp-trampoline-compile "comp" "\
Synthesize compile and return a trampoline for SUBR-NAME.

(fn SUBR-NAME)")
(autoload 'comp-clean-up-stale-eln "comp" "\
Remove all FILE*.eln* files found in `native-comp-eln-load-path'.
The files to be removed are those produced from the original source
filename (including FILE).

(fn FILE)")
(autoload 'comp-lookup-eln "comp" "\
Given a Lisp source FILENAME return the corresponding .eln file if found.
Search happens in `native-comp-eln-load-path'.

(fn FILENAME)")
(autoload 'native-compile "comp" "\
Compile FUNCTION-OR-FILE into native code.
This is the synchronous entry-point for the Emacs Lisp native
compiler.  FUNCTION-OR-FILE is a function symbol, a form, or the
filename of an Emacs Lisp source file.  If OUTPUT is non-nil, use
it as the filename for the compiled object.  If FUNCTION-OR-FILE
is a filename, if the compilation was successful return the
filename of the compiled object.  If FUNCTION-OR-FILE is a
function symbol or a form, if the compilation was successful
return the compiled function.

(fn FUNCTION-OR-FILE &optional OUTPUT)")
(function-put 'native-compile 'function-type '(function ((or string symbol) &optional string) (or native-comp-function string)))
(autoload 'batch-native-compile "comp" "\
Perform batch native compilation of remaining command-line arguments.

Native compilation equivalent of `batch-byte-compile'.
Use this from the command line, with `-batch'; it won't work
in an interactive Emacs session.
Optional argument FOR-TARBALL non-nil means the file being compiled
as part of building the source tarball, in which case the .eln file
will be placed under the native-lisp/ directory (actually, in the
last directory in `native-comp-eln-load-path').

(fn &optional FOR-TARBALL)")
(autoload 'batch-byte+native-compile "comp" "\
Like `batch-native-compile', but used for bootstrap.
Generate .elc files in addition to the .eln files.
Force the produced .eln to be outputted in the eln system
directory (the last entry in `native-comp-eln-load-path') unless
`native-compile-target-directory' is non-nil.  If the environment
variable \"NATIVE_DISABLED\" is set, only byte compile.")
(register-definition-prefixes "comp" '("comp-" "native-comp" "no-native-compile"))


;;; Generated autoloads from cedet/semantic/wisent/comp.el

(register-definition-prefixes "semantic/wisent/comp" '("wisent-"))


;;; Generated autoloads from emacs-lisp/comp-common.el

(autoload 'comp-function-type-spec "comp-common" "\
Return the type specifier of FUNCTION.

This function returns a cons cell whose car is the function specifier,
and cdr is a symbol, either `inferred' or `declared'.  If the symbol is
`inferred', the type specifier is automatically inferred from the code
itself by the native compiler; if it is `declared', the type specifier
comes from `comp-primitive-type-specifiers' or the function type declaration
itself.

(fn FUNCTION)")
(register-definition-prefixes "comp-common" '("comp-" "native-comp-"))


;;; Generated autoloads from emacs-lisp/comp-cstr.el

(register-definition-prefixes "comp-cstr" '("comp-" "with-comp-cstr-accessors"))


;;; Generated autoloads from emacs-lisp/comp-run.el

(autoload 'comp-subr-trampoline-install "comp-run" "\
Make SUBR-NAME effectively advice-able when called from native code.

(fn SUBR-NAME)")
(autoload 'native--compile-async "comp-run" "\
Compile FILES asynchronously.
FILES is one filename or a list of filenames or directories.

If optional argument RECURSIVELY is non-nil, recurse into
subdirectories of given directories.

If optional argument LOAD is non-nil, request to load the file
after compiling.

The optional argument SELECTOR has the following valid values:

nil -- Select all files.
a string -- A regular expression selecting files with matching names.
a function -- A function selecting files with matching names.

The variable `native-comp-async-jobs-number' specifies the number
of (commands) to run simultaneously.

LOAD can also be the symbol `late'.  This is used internally if
the byte code has already been loaded when this function is
called.  It means that we request the special kind of load
necessary in that situation, called \"late\" loading.

During a \"late\" load, instead of executing all top-level forms
of the original files, only function definitions are
loaded (paying attention to have these effective only if the
bytecode definition was not changed in the meantime).

(fn FILES &optional RECURSIVELY LOAD SELECTOR)")
(autoload 'native-compile-async "comp-run" "\
Compile FILES asynchronously.
FILES is one file or a list of filenames or directories.

If optional argument RECURSIVELY is non-nil, recurse into
subdirectories of given directories.

If optional argument LOAD is non-nil, request to load the file
after compiling.

The optional argument SELECTOR has the following valid values:

nil -- Select all files.
a string -- A regular expression selecting files with matching names.
a function -- A function selecting files with matching names.

The variable `native-comp-async-jobs-number' specifies the number
of (commands) to run simultaneously.

(fn FILES &optional RECURSIVELY LOAD SELECTOR)")
(register-definition-prefixes "comp-run" '("comp-" "native-"))


;;; Generated autoloads from vc/compare-w.el

(autoload 'compare-windows "compare-w" "\
Compare text in current window with text in another window.
The option `compare-windows-get-window-function' defines how
to get another window.

Compares the text starting at point in each window,
moving over text in each one as far as they match.

This command pushes the mark in each window
at the prior location of point in that window.
If both windows display the same buffer,
the mark is pushed twice in that buffer:
first in the other window, then in the selected window.

A prefix arg IGNORE-WHITESPACE, means reverse the value of variable
`compare-ignore-whitespace'.  If `compare-ignore-whitespace' is
nil, then a prefix arg means ignore changes in whitespace.  If
`compare-ignore-whitespace' is non-nil, then a prefix arg means
don't ignore changes in whitespace.  The variable
`compare-windows-whitespace' controls how whitespace is skipped.
If `compare-ignore-case' is non-nil, changes in case are also
ignored.

If `compare-windows-sync' is non-nil, then successive calls of
this command work in interlaced mode:
on first call it advances points to the next difference,
on second call it synchronizes points by skipping the difference,
on third call it again advances points to the next difference and so on.

(fn IGNORE-WHITESPACE)" t)
(register-definition-prefixes "compare-w" '("compare-"))


;;; Generated autoloads from emacs-lisp/compat.el

 (push (list 'compat
            emacs-major-version
            emacs-minor-version
            9999)
      package--builtin-versions)
(register-definition-prefixes "compat" '("compat-"))


;;; Generated autoloads from image/compface.el

(register-definition-prefixes "compface" '("uncompface"))


;;; Generated autoloads from progmodes/compile.el

(defvar compilation-mode-hook nil "\
List of hook functions run by `compilation-mode'.")
(custom-autoload 'compilation-mode-hook "compile" t)
(defvar compilation-start-hook nil "\
Hook run after starting a new compilation process.
The hook is run with one argument, the new process.")
(custom-autoload 'compilation-start-hook "compile" t)
(defvar compilation-window-height nil "\
Number of lines in a compilation window.
If nil, use Emacs default.")
(custom-autoload 'compilation-window-height "compile" t)
(defvar compilation-process-setup-function #'ignore "\
Function to call to customize the compilation process.
This function is called immediately before the compilation process is
started.  It can be used to set any variables or functions that are used
while processing the output of the compilation process.")
(defvar compilation-buffer-name-function #'compilation--default-buffer-name "\
Function to compute the name of a compilation buffer.
The function receives one argument, the name of the major mode of the
compilation buffer.  It should return a string.
By default, it returns `(concat \"*\" (downcase name-of-mode) \"*\")'.")
(defvar compilation-finish-functions nil "\
Functions to call when a compilation process finishes.
Each function is called with two arguments: the compilation buffer,
and a string describing how the process finished.")
(put 'compilation-directory 'safe-local-variable 'stringp)
(defvar compilation-ask-about-save t "\
Non-nil means \\[compile] asks which buffers to save before compiling.
Otherwise, it saves all modified buffers without asking.")
(custom-autoload 'compilation-ask-about-save "compile" t)
(defvar compilation-search-path '(nil) "\
List of directories to search for source files named in error messages.
Elements should be directory names, not file names of directories.
The value nil as an element means to try the default directory.")
(custom-autoload 'compilation-search-path "compile" t)
(defvar compile-command (purecopy "make -k ") "\
Last shell command used to do a compilation; default for next compilation.

Sometimes it is useful for files to supply local values for this variable.
You might also use mode hooks to specify it in certain modes, like this:

    (add-hook \\='c-mode-hook
       (lambda ()
	 (unless (or (file-exists-p \"makefile\")
		     (file-exists-p \"Makefile\"))
           (setq-local compile-command
		(concat \"make -k \"
			(if buffer-file-name
			  (shell-quote-argument
			    (file-name-sans-extension buffer-file-name))))))))

It's often useful to leave a space at the end of the value.")
(custom-autoload 'compile-command "compile" t)
(put 'compile-command 'safe-local-variable (lambda (a) (and (stringp a) (if (boundp 'compilation-read-command) compilation-read-command t))))
(defvar compilation-disable-input nil "\
If non-nil, send end-of-file as compilation process input.
This only affects platforms that support asynchronous processes (see
`start-process'); synchronous compilation processes never accept input.")
(custom-autoload 'compilation-disable-input "compile" t)
(autoload 'compile "compile" "\
Compile the program including the current buffer.  Default: run `make'.
Runs COMMAND, a shell command, in a separate process asynchronously
with output going to the buffer `*compilation*'.

You can then use the command \\[next-error] to find the next error message
and move to the source code that caused it.

If optional second arg COMINT is t the buffer will be in Comint mode with
`compilation-shell-minor-mode'.

Interactively, prompts for the command if the variable
`compilation-read-command' is non-nil; otherwise uses `compile-command'.
With prefix arg, always prompts.
Additionally, with universal prefix arg, compilation buffer will be in
comint mode, i.e. interactive.

To run more than one compilation at once, start one then rename
the `*compilation*' buffer to some other name with
\\[rename-buffer].  Then _switch buffers_ and start the new compilation.
It will create a new `*compilation*' buffer.

On most systems, termination of the main compilation process
kills its subprocesses.

The name used for the buffer is actually whatever is returned by
the function in `compilation-buffer-name-function', so you can set that
to a function that generates a unique name.

(fn COMMAND &optional COMINT)" t)
(autoload 'compilation--default-buffer-name "compile" "\


(fn NAME-OF-MODE)")
(autoload 'compilation-start "compile" "\
Run compilation command COMMAND (low level interface).
If COMMAND starts with a cd command, that becomes the `default-directory'.
The rest of the arguments are optional; for them, nil means use the default.

MODE is the major mode to set in the compilation buffer.  Mode
may also be t meaning use `compilation-shell-minor-mode' under `comint-mode'.

If NAME-FUNCTION is non-nil, call it with one argument (the mode name)
to determine the buffer name.  Otherwise, the default is to
reuses the current buffer if it has the proper major mode,
else use or create a buffer with name based on the major mode.

If HIGHLIGHT-REGEXP is non-nil, `next-error' will temporarily highlight
the matching section of the visited source line; the default is to use the
global value of `compilation-highlight-regexp'.

If CONTINUE is non-nil, the buffer won't be emptied before
compilation is started.  This can be useful if you wish to
combine the output from several compilation commands in the same
buffer.  The new output will be at the end of the buffer, and
point is not changed.

Returns the compilation buffer created.

(fn COMMAND &optional MODE NAME-FUNCTION HIGHLIGHT-REGEXP CONTINUE)")
(autoload 'compilation-mode "compile" "\
Major mode for compilation log buffers.
\\<compilation-mode-map>To visit the source for a line-numbered error,
move point to the error message line and type \\[compile-goto-error].
To kill the compilation, type \\[kill-compilation].

Runs `compilation-mode-hook' with `run-mode-hooks' (which see).

\\{compilation-mode-map}

(fn &optional NAME-OF-MODE)" t)
(put 'define-compilation-mode 'doc-string-elt 3)
(autoload 'compilation-shell-minor-mode "compile" "\
Toggle Compilation Shell minor mode.

When Compilation Shell minor mode is enabled, all the
error-parsing commands of the Compilation major mode are
available but bound to keys that don't collide with Shell mode.
See `compilation-mode'.

This is a minor mode.  If called interactively, toggle the
`Compilation-Shell minor mode' mode.  If the prefix argument is
positive, enable the mode, and if it is zero or negative, disable the
mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `compilation-shell-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

\\{compilation-shell-minor-mode-map}

(fn &optional ARG)" t)
(autoload 'compilation-minor-mode "compile" "\
Toggle Compilation minor mode.

When Compilation minor mode is enabled, all the error-parsing
commands of Compilation major mode are available.  See
`compilation-mode'.

This is a minor mode.  If called interactively, toggle the `Compilation
minor mode' mode.  If the prefix argument is positive, enable the mode,
and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `compilation-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

\\{compilation-minor-mode-map}

(fn &optional ARG)" t)
(autoload 'compilation-next-error-function "compile" "\
Advance to the next error message and visit the file where the error was.
This is the value of `next-error-function' in Compilation buffers.

(fn N &optional RESET)" t)
(register-definition-prefixes "compile" '("compil" "define-compilation-mode" "kill-compilation" "recompile"))


;;; Generated autoloads from cedet/srecode/compile.el

(register-definition-prefixes "srecode/compile" '("srecode-"))


;;; Generated autoloads from cedet/semantic/analyze/complete.el

(register-definition-prefixes "semantic/analyze/complete" '("semantic-analyze-"))


;;; Generated autoloads from cedet/semantic/complete.el

(register-definition-prefixes "semantic/complete" '("semantic-"))


;;; Generated autoloads from completion.el

(defvar dynamic-completion-mode nil "\
Non-nil if Dynamic-Completion mode is enabled.
See the `dynamic-completion-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `dynamic-completion-mode'.")
(custom-autoload 'dynamic-completion-mode "completion" nil)
(autoload 'dynamic-completion-mode "completion" "\
Toggle dynamic word-completion on or off.

When this minor mode is turned on, typing \\`M-RET' or \\`C-RET'
invokes the command `complete', which completes the word or
symbol at point using the record of words/symbols you used
previously and the previously-inserted completions.  Typing
a word or moving point across it constitutes \"using\" the
word.

By default, the database of all the dynamic completions that
were inserted by \\[complete] is saved on the file specified
by `save-completions-file-name' when you exit Emacs, and will
be loaded from that file when this mode is enabled in a future
Emacs session.

The following important options control the various aspects of
this mode: `enable-completion', `save-completions-flag', and
`save-completions-retention-time'.  Few other less important
options can be found in the `completion' group.

This is a global minor mode.  If called interactively, toggle the
`Dynamic-Completion mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='dynamic-completion-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "completion" '("*c-def-regexp*" "*lisp-def-regexp*" "accept-completion" "add-" "cdabbrev-" "check-completion-length" "clear-all-completions" "cmpl-" "complet" "current-completion-source" "delete-completion" "enable-completion" "find-" "inside-locate-completion-entry" "interactive-completion-string-reader" "kill-" "list-all-completions" "load-completions-from-file" "make-c" "next-cdabbrev" "num-cmpl-sources" "reset-cdabbrev" "save" "set-c" "symbol-" "use-completion-"))


;;; Generated autoloads from completion-preview.el

(autoload 'completion-preview-mode "completion-preview" "\
Show in-buffer completion suggestions in a preview as you type.

This mode automatically shows and updates the completion preview
according to the text around point.
\\<completion-preview-active-mode-map>When the preview is visible, \\[completion-preview-insert] accepts the
completion suggestion, \\[completion-preview-complete] completes up to
the longest common prefix of all completion candidates,
\\[completion-preview-next-candidate] cycles forward to the next
completion suggestion, and \\[completion-preview-prev-candidate] cycles
backward.

This is a minor mode.  If called interactively, toggle the
`Completion-Preview mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `completion-preview-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-completion-preview-mode 'globalized-minor-mode t)
(defvar global-completion-preview-mode nil "\
Non-nil if Global Completion-Preview mode is enabled.
See the `global-completion-preview-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-completion-preview-mode'.")
(custom-autoload 'global-completion-preview-mode "completion-preview" nil)
(autoload 'global-completion-preview-mode "completion-preview" "\
Toggle Completion-Preview mode in all buffers.
With prefix ARG, enable Global Completion-Preview mode if ARG is
positive; otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Completion-Preview mode is enabled in all buffers where
`completion-preview-mode' would do it.

See `completion-preview-mode' for more information on
Completion-Preview mode.

`global-completion-preview-modes' is used to control which modes this
minor mode is used in.

(fn &optional ARG)" t)
(defvar global-completion-preview-modes '((not archive-mode calc-mode compilation-mode diff-mode dired-mode image-mode minibuffer-mode minibuffer-inactive-mode org-agenda-mode special-mode wdired-mode) t) "\
Which major modes `completion-preview-mode' is switched on in.
This variable can be either t (all major modes), nil (no major modes),
or a list of modes and (not modes) to switch use this minor mode or
not.  For instance

  (c-mode (not message-mode mail-mode) text-mode)

means \"use this mode in all modes derived from `c-mode', don't use in
modes derived from `message-mode' or `mail-mode', but do use in other
modes derived from `text-mode'\".  An element with value t means \"use\"
and nil means \"don't use\".  There's an implicit nil at the end of the
list.")
(custom-autoload 'global-completion-preview-modes "completion-preview" t)
(register-definition-prefixes "completion-preview" '("completion-preview-"))


;;; Generated autoloads from textmodes/conf-mode.el

(autoload 'conf-mode "conf-mode" "\
Mode for Unix and Windows Conf files and Java properties.
Most conf files know only three kinds of constructs: parameter
assignments optionally grouped into sections and comments.  Yet
there is a great range of variation in the exact syntax of conf
files.  See below for various wrapper commands that set up the
details for some of the most widespread variants.

This mode sets up font locking, outline, imenu and it provides
alignment support through `conf-align-assignments'.  If strings
come out wrong, try `conf-quote-normal'.

Some files allow continuation lines, either with a backslash at
the end of line, or by indenting the next line (further).  These
constructs cannot currently be recognized.

Because of this great variety of nuances, which are often not
even clearly specified, please don't expect it to get every file
quite right.  Patches that clearly identify some special case,
without breaking the general ones, are welcome.

If instead you start this mode with the generic `conf-mode'
command, it will parse the buffer.  It will generally well
identify the first four cases listed below.  If the buffer
doesn't have enough contents to decide, this is identical to
`conf-windows-mode' on Windows, elsewhere to `conf-unix-mode'.
See also `conf-space-mode', `conf-colon-mode', `conf-javaprop-mode',
`conf-ppd-mode' and `conf-xdefaults-mode'.

\\{conf-mode-map}

(fn)" t)
(autoload 'conf-unix-mode "conf-mode" "\
Conf Mode starter for Unix style Conf files.
Comments start with `#'.  For details see `conf-mode'.

(fn)" t)
(autoload 'conf-windows-mode "conf-mode" "\
Conf Mode starter for Windows style Conf files.
Comments start with `;'.
For details see `conf-mode'.  Example:

; Conf mode font-locks this right on Windows and with \\[conf-windows-mode]

[ExtShellFolderViews]
Default={5984FFE0-28D4-11CF-AE66-08002B2E1262}
{5984FFE0-28D4-11CF-AE66-08002B2E1262}={5984FFE0-28D4-11CF-AE66-08002B2E1262}

[{5984FFE0-28D4-11CF-AE66-08002B2E1262}]
PersistMoniker=file://Folder.htt

(fn)" t)
(autoload 'conf-javaprop-mode "conf-mode" "\
Conf Mode starter for Java properties files.
Comments start with `#'.  Example:

# Conf mode font-locks this right with \\[conf-javaprop-mode] (Java properties)

name:value
name=value
name value
x.1 =
x.2.y.1.z.1 =
x.2.y.1.z.2.zz =

(fn)" t)
(autoload 'conf-space-mode "conf-mode" "\
Conf Mode starter for space separated conf files.
\"Assignments\" are with ` '.  Keywords before the parameters are
recognized according to the variable `conf-space-keywords-alist'.
Alternatively, you can specify a value for the file local variable
`conf-space-keywords'.
Use the function `conf-space-keywords' if you want to specify keywords
in an interactive fashion instead.

For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-space-mode] (space separated)

image/jpeg			jpeg jpg jpe
image/png			png
image/tiff			tiff tif

# Or with keywords (from a recognized file name):
class desktop
# Standard multimedia devices
add /dev/audio		desktop
add /dev/mixer		desktop

(fn)" t)
(autoload 'conf-space-keywords "conf-mode" "\
Enter Conf Space mode using regexp KEYWORDS to match the keywords.
See `conf-space-mode'.

(fn KEYWORDS)" t)
(autoload 'conf-colon-mode "conf-mode" "\
Conf Mode starter for Colon files.
\"Assignments\" are with `:'.
For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-colon-mode] (colon)

<Multi_key> <exclam> <exclam>		: \"\\241\"	exclamdown
<Multi_key> <c> <slash>			: \"\\242\"	cent

(fn)" t)
(autoload 'conf-ppd-mode "conf-mode" "\
Conf Mode starter for Adobe/CUPS PPD files.
Comments start with `*%' and \"assignments\" are with `:'.
For details see `conf-mode'.  Example:

*% Conf mode font-locks this right with \\[conf-ppd-mode] (PPD)

*DefaultTransfer: Null
*Transfer Null.Inverse: \"{ 1 exch sub }\"

(fn)" t)
(autoload 'conf-xdefaults-mode "conf-mode" "\
Conf Mode starter for Xdefaults files.
Comments start with `!' and \"assignments\" are with `:'.
For details see `conf-mode'.  Example:

! Conf mode font-locks this right with \\[conf-xdefaults-mode] (.Xdefaults)

*background:			gray99
*foreground:			black

(fn)" t)
(autoload 'conf-toml-mode "conf-mode" "\
Conf Mode starter for TOML files.
Comments start with `#' and \"assignments\" are with `='.
For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-toml-mode]

[entry]
value = \"some string\"

(fn)" t)
(autoload 'conf-desktop-mode "conf-mode" "\
Conf Mode started for freedesktop.org Desktop files.
Comments start with `#' and \"assignments\" are with `='.
For details see `conf-mode'.

# Conf mode font-locks this correctly with \\[conf-desktop-mode]
	[Desktop Entry]
	Name=GNU Image Manipulation Program
	Name[oc]=Editor d'imatge GIMP
	Exec=gimp-2.8 %U
	Terminal=false

(fn)" t)
(register-definition-prefixes "conf-mode" '("conf-"))


;;; Generated autoloads from cedet/ede/config.el

(register-definition-prefixes "ede/config" '("ede-"))


;;; Generated autoloads from play/cookie1.el

(autoload 'cookie "cookie1" "\
Return a random phrase from PHRASE-FILE.
When the phrase file is read in, display STARTMSG at the beginning
of load, ENDMSG at the end.
Interactively, PHRASE-FILE defaults to `cookie-file', unless that
is nil or a prefix argument is used.

(fn PHRASE-FILE &optional STARTMSG ENDMSG)" t)
(autoload 'cookie-insert "cookie1" "\
Insert random phrases from PHRASE-FILE; COUNT of them.
When the phrase file is read in, display STARTMSG at the beginning
of load, ENDMSG at the end.

(fn PHRASE-FILE &optional COUNT STARTMSG ENDMSG)")
(autoload 'cookie-snarf "cookie1" "\
Read the PHRASE-FILE, return it as a vector of strings.
Emit STARTMSG and ENDMSG before and after.  Cache the result; second
and subsequent calls on the same file won't go to disk.

(fn PHRASE-FILE &optional STARTMSG ENDMSG)")
(register-definition-prefixes "cookie1" '("cookie"))


;;; Generated autoloads from emacs-lisp/copyright.el

(put 'copyright-at-end-flag 'safe-local-variable 'booleanp)
(put 'copyright-names-regexp 'safe-local-variable 'stringp)
(put 'copyright-year-ranges 'safe-local-variable 'booleanp)
(autoload 'copyright-update "copyright" "\
Update copyright notice to indicate the current year.
With prefix ARG, replace the years in the notice rather than adding
the current year after them.  If necessary, and
`copyright-current-gpl-version' is set, any copying permissions
following the copyright are updated as well.
If non-nil, INTERACTIVEP tells the function to behave as when it's called
interactively.

(fn &optional ARG INTERACTIVEP)" t)
(autoload 'copyright-fix-years "copyright" "\
Convert 2 digit years to 4 digit years.
Uses heuristic: year >= 50 means 19xx, < 50 means 20xx.
If `copyright-year-ranges' (which see) is non-nil, also
independently replaces consecutive years with a range." t)
(autoload 'copyright "copyright" "\
Insert a copyright by $ORGANIZATION notice at cursor.

(fn &optional STR ARG)" t)
(autoload 'copyright-update-directory "copyright" "\
Update copyright notice for all files in DIRECTORY matching MATCH.
If FIX is non-nil, run `copyright-fix-years' instead.

(fn DIRECTORY MATCH &optional FIX)" t)
(register-definition-prefixes "copyright" '("copyright-"))


;;; Generated autoloads from progmodes/cperl-mode.el

(put 'cperl-file-style 'safe-local-variable 'stringp)
(put 'cperl-indent-level 'safe-local-variable 'integerp)
(put 'cperl-brace-offset 'safe-local-variable 'integerp)
(put 'cperl-continued-brace-offset 'safe-local-variable 'integerp)
(put 'cperl-label-offset 'safe-local-variable 'integerp)
(put 'cperl-continued-statement-offset 'safe-local-variable 'integerp)
(put 'cperl-extra-newline-before-brace 'safe-local-variable 'booleanp)
(put 'cperl-merge-trailing-else 'safe-local-variable 'booleanp)
(autoload 'cperl-mode "cperl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all C brackets.
Tab indents for Perl code.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.

Various characters in Perl almost always come in pairs: {}, (), [],
sometimes <>.  When the user types the first, she gets the second as
well, with optional special formatting done on {}.  (Disabled by
default.)  You can always quote (with \\[quoted-insert]) the left
\"paren\" to avoid the expansion.  The processing of < is special,
since most the time you mean \"less\".  CPerl mode tries to guess
whether you want to type pair <>, and inserts is if it
appropriate.  You can set `cperl-electric-parens-string' to the string that
contains the parens from the above list you want to be electrical.
Electricity of parens is controlled by `cperl-electric-parens'.
You may also set `cperl-electric-parens-mark' to have electric parens
look for active mark and \"embrace\" a region if possible.'

CPerl mode provides expansion of the Perl control constructs:

   if, else, elsif, unless, while, until, continue, do,
   for, foreach, formy and foreachmy.

and POD directives (Disabled by default, see `cperl-electric-keywords'.)

The user types the keyword immediately followed by a space, which
causes the construct to be expanded, and the point is positioned where
she is most likely to want to be.  E.g., when the user types a space
following \"if\" the following appears in the buffer: if () { or if ()
} { } and the cursor is between the parentheses.  The user can then
type some boolean expression within the parens.  Having done that,
typing \\[cperl-linefeed] places you - appropriately indented - on a
new line between the braces (if you typed \\[cperl-linefeed] in a POD
directive line, then appropriate number of new lines is inserted).

If CPerl decides that you want to insert \"English\" style construct like

            bite if angry;

it will not do any expansion.  See also help on variable
`cperl-extra-newline-before-brace'.  (Note that one can switch the
help message on expansion by setting `cperl-message-electric-keyword'
to nil.)

\\[cperl-linefeed] is a convenience replacement for typing carriage
return.  It places you in the next line with proper indentation, or if
you type it inside the inline block of control construct, like

            foreach (@lines) {print; print}

and you are on a boundary of a statement inside braces, it will
transform the construct into a multiline and will place you into an
appropriately indented blank line.  If you need a usual
`newline-and-indent' behavior, it is on \\[newline-and-indent],
see documentation on `cperl-electric-linefeed'.

Use \\[cperl-invert-if-unless] to change a construction of the form

	    if (A) { B }

into

            B if A;

\\{cperl-mode-map}

Setting the variable `cperl-font-lock' to t switches on `font-lock-mode',
`cperl-electric-lbrace-space' to t switches on electric space between $
and {, `cperl-electric-parens-string' is the string that contains
parentheses that should be electric in CPerl (see also
`cperl-electric-parens-mark' and `cperl-electric-parens'), setting
`cperl-electric-keywords' enables electric expansion of control
structures in CPerl.  `cperl-electric-linefeed' governs which one of two
linefeed behavior is preferable.  You can enable all these options
simultaneously by setting `cperl-hairy' to t.  In this case you can
switch separate options off by setting them to `null'.  Note that one may
undo the extra whitespace inserted by semis and braces in
`auto-newline'-mode by consequent \\[cperl-electric-backspace].

Short one-liner-style help is available on \\[cperl-get-help],
and one can run perldoc or man via menu.

It is possible to show this help automatically after some idle time.
This is regulated by variable `cperl-lazy-help-time'.  Default with
`cperl-hairy' (if the value of `cperl-lazy-help-time' is nil) is 5
secs idle time .  It is also possible to switch this on/off from the
menu, or via \\[cperl-toggle-autohelp].

Use \\[cperl-lineup] to vertically lineup some construction - put the
beginning of the region at the start of construction, and make region
span the needed amount of lines.

Variables `cperl-pod-here-scan', `cperl-pod-here-fontify',
`cperl-pod-face', `cperl-pod-head-face' control processing of POD and
here-docs sections.  Results of scan are used for indentation too.

Variables controlling indentation style:
 `cperl-tab-always-indent'
    Non-nil means TAB in CPerl mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 `cperl-indent-left-aligned-comments'
    Non-nil means that the comment starting in leftmost column should indent.
 `cperl-auto-newline'
    Non-nil means automatically newline before and after braces,
    and after colons and semicolons, inserted in Perl code.  The following
    \\[cperl-electric-backspace] will remove the inserted whitespace.
    Insertion after colons requires both this variable and
    `cperl-auto-newline-after-colon' set.
 `cperl-auto-newline-after-colon'
    Non-nil means automatically newline even after colons.
    Subject to `cperl-auto-newline' setting.
 `cperl-indent-level'
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 `cperl-continued-statement-offset'
    Extra indentation given to a substatement, such as the
    then-clause of an if, or body of a while, or just a statement continuation.
 `cperl-continued-brace-offset'
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `cperl-continued-statement-offset'.
 `cperl-brace-offset'
    Extra indentation for line if it starts with an open brace.
 `cperl-brace-imaginary-offset'
    An open brace following other text is treated as if it the line started
    this far to the right of the actual line indentation.
 `cperl-label-offset'
    Extra indentation for line that is a label.
 `cperl-min-label-indent'
    Minimal indentation for line that is a label.

Settings for classic indent-styles: K&R BSD=C++ GNU PBP PerlStyle=Whitesmith
  `cperl-indent-level'                5   4       2   4   4
  `cperl-brace-offset'                0   0       0   0   0
  `cperl-continued-brace-offset'     -5  -4       0   0   0
  `cperl-label-offset'               -5  -4      -2  -2  -4
  `cperl-continued-statement-offset'  5   4       2   4   4

CPerl knows several indentation styles, and may bulk set the
corresponding variables.  Use \\[cperl-set-style] to do this or
set the `cperl-file-style' user option.  Use
\\[cperl-set-style-back] to restore the memorized preexisting
values (both available from menu).  See examples in
`cperl-style-examples'.

Part of the indentation style is how different parts of if/elsif/else
statements are broken into lines; in CPerl, this is reflected on how
templates for these constructs are created (controlled by
`cperl-extra-newline-before-brace'), and how reflow-logic should treat
\"continuation\" blocks of else/elsif/continue, controlled by the same
variable, and by `cperl-extra-newline-before-brace-multiline',
`cperl-merge-trailing-else', `cperl-indent-region-fix-constructs'.

If `cperl-indent-level' is 0, the statement after opening brace in
column 0 is indented on
`cperl-brace-offset'+`cperl-continued-statement-offset'.

Turning on CPerl mode calls the hooks in the variable `cperl-mode-hook'
with no args.

DO NOT FORGET to read micro-docs (available from `Perl' menu)
or as help on variables `cperl-tips', `cperl-problems',
`cperl-praise', `cperl-speed'.

(fn)" t)
(autoload 'cperl-perldoc "cperl-mode" "\
Run `perldoc' on WORD.

(fn WORD)" t)
(autoload 'cperl-perldoc-at-point "cperl-mode" "\
Run a `perldoc' on the word around point." t)
(register-definition-prefixes "cperl-mode" '("cperl-"))


;;; Generated autoloads from progmodes/cpp.el

(autoload 'cpp-highlight-buffer "cpp" "\
Highlight C code according to preprocessor conditionals.
This command pops up a buffer which you should edit to specify
what kind of highlighting to use, and the criteria for highlighting.
A prefix arg suppresses display of that buffer.

(fn ARG)" t)
(autoload 'cpp-parse-edit "cpp" "\
Edit display information for cpp conditionals." t)
(register-definition-prefixes "cpp" '("cpp-"))


;;; Generated autoloads from cedet/srecode/cpp.el

(register-definition-prefixes "srecode/cpp" '("srecode-"))


;;; Generated autoloads from cedet/ede/cpp-root.el

(register-definition-prefixes "ede/cpp-root" '("ede-cpp-root-"))


;;; Generated autoloads from emacs-lisp/crm.el

(autoload 'completing-read-multiple "crm" "\
Read multiple strings in the minibuffer, with completion.
The arguments are the same as those of `completing-read'.
\\<crm-local-completion-map>
Input multiple strings by separating each one with a string that
matches the regexp `crm-separator'.  For example, if the separator
regexp is \",\", entering \"alice,bob,eve\" specifies the strings
\"alice\", \"bob\", and \"eve\".

We refer to contiguous strings of non-separator-characters as
\"elements\".  In this example there are three elements.

Completion is available on a per-element basis.  For example, if the
contents of the minibuffer are \"alice,bob,eve\" and point is between
\"l\" and \"i\", pressing \\[minibuffer-complete] operates on the element \"alice\".

This function returns a list of the strings that were read,
with empty strings removed.

(fn PROMPT TABLE &optional PREDICATE REQUIRE-MATCH INITIAL-INPUT HIST DEF INHERIT-INPUT-METHOD)")
(register-definition-prefixes "crm" '("crm-"))


;;; Generated autoloads from cedet/semantic/symref/cscope.el

(register-definition-prefixes "semantic/symref/cscope" '("semantic-symref-cscope--line-re"))


;;; Generated autoloads from progmodes/csharp-mode.el

(add-to-list 'auto-mode-alist '("\\.cs\\'" . csharp-mode))
(autoload 'csharp-mode "csharp-mode" "\
Major mode for editing Csharp code.

Key bindings:
\\{csharp-mode-map}

(fn)" t)
(autoload 'csharp-ts-mode "csharp-mode" "\
Major mode for editing C# code.

(fn)" t)
(register-definition-prefixes "csharp-mode" '("codedoc-font-lock-" "csharp-"))


;;; Generated autoloads from textmodes/css-mode.el

(autoload 'css-ts-mode "css-mode" "\
Major mode to edit Cascading Style Sheets (CSS).
\\<css-ts-mode-map>

This mode provides syntax highlighting, indentation, completion,
and documentation lookup for CSS, based on the tree-sitter
library.

Use `\\[completion-at-point]' to complete CSS properties,
property values, pseudo-elements, pseudo-classes, at-rules,
bang-rules, and HTML tags, classes and IDs.  Completion
candidates for HTML class names and IDs are found by looking
through open HTML mode buffers.

Use `\\[info-lookup-symbol]' to look up documentation of CSS
properties, at-rules, pseudo-classes, and pseudo-elements on the
Mozilla Developer Network (MDN).

Use `\\[fill-paragraph]' to reformat CSS declaration blocks.  It
can also be used to fill comments.

\\{css-mode-map}

(fn)" t)
(autoload 'css-mode "css-mode" "\
Major mode to edit Cascading Style Sheets (CSS).
\\<css-mode-map>
This mode provides syntax highlighting, indentation, completion,
and documentation lookup for CSS.

Use `\\[completion-at-point]' to complete CSS properties, property values,
pseudo-elements, pseudo-classes, at-rules, bang-rules, and HTML
tags, classes and IDs.  Completion candidates for HTML class
names and IDs are found by looking through open HTML mode
buffers.

Use `\\[info-lookup-symbol]' to look up documentation of CSS properties, at-rules,
pseudo-classes, and pseudo-elements on the Mozilla Developer
Network (MDN).

Use `\\[fill-paragraph]' to reformat CSS declaration blocks.  It can also
be used to fill comments.

\\{css-mode-map}

(fn)" t)
 (add-to-list 'auto-mode-alist '("\\.scss\\'" . scss-mode))
(autoload 'scss-mode "css-mode" "\
Major mode to edit \"Sassy CSS\" files.

(fn)" t)
(autoload 'css-lookup-symbol "css-mode" "\
Display the CSS documentation for SYMBOL, as found on MDN.
When this command is used interactively, it picks a default
symbol based on the CSS text before point -- either an @-keyword,
a property name, a pseudo-class, or a pseudo-element, depending
on what is seen near point.

(fn SYMBOL)" t)
(register-definition-prefixes "css-mode" '("css-" "scss-"))


;;; Generated autoloads from cedet/srecode/ctxt.el

(register-definition-prefixes "srecode/ctxt" '("srecode-"))


;;; Generated autoloads from cedet/semantic/ctxt.el

(register-definition-prefixes "semantic/ctxt" '("semantic-"))


;;; Generated autoloads from emulation/cua-base.el

(defvar cua-mode nil "\
Non-nil if Cua mode is enabled.
See the `cua-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `cua-mode'.")
(custom-autoload 'cua-mode "cua-base" nil)
(autoload 'cua-mode "cua-base" "\
Toggle Common User Access style editing (CUA mode).

CUA mode is a global minor mode.  When enabled, typed text
replaces the active selection, and you can use C-z, C-x, C-c, and
C-v to undo, cut, copy, and paste in addition to the normal Emacs
bindings.  The C-x and C-c keys only do cut and copy when the
region is active, so in most cases, they do not conflict with the
normal function of these prefix keys.

If you really need to perform a command which starts with one of
the prefix keys even when the region is active, you have three
options:
- press the prefix key twice very quickly (within 0.2 seconds),
- press the prefix key and the following key within 0.2 seconds, or
- use the SHIFT key with the prefix key, i.e. C-S-x or C-S-c.

You can customize `cua-enable-cua-keys' to completely disable the
CUA bindings, or `cua-prefix-override-inhibit-delay' to change
the prefix fallback behavior.

This is a global minor mode.  If called interactively, toggle the `Cua
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='cua-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'cua-selection-mode "cua-base" "\
Enable CUA selection mode without the C-z/C-x/C-c/C-v bindings.

(fn ARG)" t)
(register-definition-prefixes "cua-base" '("cua-"))


;;; Generated autoloads from emulation/cua-gmrk.el

(register-definition-prefixes "cua-gmrk" '("cua-"))


;;; Generated autoloads from emulation/cua-rect.el

(autoload 'cua-rectangle-mark-mode "cua-rect" "\
Toggle the region as rectangular.

Activates the region if needed.  Only lasts until the region is deactivated.

This is a minor mode.  If called interactively, toggle the
`Cua-Rectangle-Mark mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `cua-rectangle-mark-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "cua-rect" '("cua-"))


;;; Generated autoloads from emacs-lisp/cursor-sensor.el

(defvar cursor-sensor-inhibit nil "\
When non-nil, suspend `cursor-sensor-mode' and `cursor-intangible-mode'.
By convention, this is a list of symbols where each symbol stands for the
\"cause\" of the suspension.")
(autoload 'cursor-intangible-mode "cursor-sensor" "\
Keep cursor outside of any `cursor-intangible' text property.

This is a minor mode.  If called interactively, toggle the
`Cursor-Intangible mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `cursor-intangible-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'cursor-sensor-mode "cursor-sensor" "\
Handle the `cursor-sensor-functions' text property.

This property should hold a list of functions which react to the motion
of the cursor.  They're called with three arguments (WINDOW OLDPOS DIR)
where WINDOW is the affected window, OLDPOS is the last known position of
the cursor and DIR can be `entered' or `left' depending on whether the cursor
is entering the area covered by the text-property property or leaving it.

This is a minor mode.  If called interactively, toggle the
`Cursor-Sensor mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `cursor-sensor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "cursor-sensor" '("cursor-sensor-"))


;;; Generated autoloads from cus-dep.el

(register-definition-prefixes "cus-dep" '("custom-" "generated-custom-dependencies-file"))


;;; Generated autoloads from cus-edit.el

(defvar custom-browse-sort-alphabetically nil "\
If non-nil, sort customization group alphabetically in `custom-browse'.")
(custom-autoload 'custom-browse-sort-alphabetically "cus-edit" t)
(defvar custom-buffer-sort-alphabetically t "\
Whether to sort customization groups alphabetically in Custom buffer.")
(custom-autoload 'custom-buffer-sort-alphabetically "cus-edit" t)
(defvar custom-menu-sort-alphabetically nil "\
If non-nil, sort each customization group alphabetically in menus.")
(custom-autoload 'custom-menu-sort-alphabetically "cus-edit" t)
(autoload 'customize-set-value "cus-edit" "\
Set VARIABLE to VALUE, and return VALUE.  VALUE is a Lisp object.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

(fn VARIABLE VALUE &optional COMMENT)" t)
(autoload 'customize-set-variable "cus-edit" "\
Set the default for VARIABLE to VALUE, and return VALUE.
VALUE is a Lisp object.

If VARIABLE has a `custom-set' property, that is used for setting
VARIABLE, otherwise `set-default' is used.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

(fn VARIABLE VALUE &optional COMMENT)" t)
(autoload 'setopt "cus-edit" "\
Set VARIABLE/VALUE pairs, and return the final VALUE.
This is like `setq', but is meant for user options instead of
plain variables.  This means that `setopt' will execute any
`custom-set' form associated with VARIABLE.

Note that `setopt' will emit a warning if the type of a VALUE
does not match the type of the corresponding VARIABLE as
declared by `defcustom'.  (VARIABLE will be assigned the value
even if it doesn't match the type.)

(fn [VARIABLE VALUE]...)" nil t)
(autoload 'setopt--set "cus-edit" "\


(fn VARIABLE VALUE)")
(autoload 'customize-save-variable "cus-edit" "\
Set the default for VARIABLE to VALUE, and save it for future sessions.
Return VALUE.

If VARIABLE has a `custom-set' property, that is used for setting
VARIABLE, otherwise `set-default' is used.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

(fn VARIABLE VALUE &optional COMMENT)" t)
(autoload 'customize-push-and-save "cus-edit" "\
Add ELTS to LIST-VAR and save for future sessions, safely.
ELTS should be a list.  This function adds each entry to the
value of LIST-VAR using `add-to-list'.

If Emacs is initialized, call `customize-save-variable' to save
the resulting list value now.  Otherwise, add an entry to
`after-init-hook' to save it after initialization.

(fn LIST-VAR ELTS)")
(autoload 'customize "cus-edit" "\
Select a customization buffer which you can use to set user options.
User options are structured into \"groups\".
Initially the top-level group `Emacs' and its immediate subgroups
are shown; the contents of those subgroups are initially hidden." t)
(autoload 'customize-mode "cus-edit" "\
Customize options related to a major or minor mode.
By default the current major mode is used.  With a prefix
argument or if the current major mode has no known group, prompt
for the MODE to customize.

(fn MODE)" t)
(autoload 'customize-group "cus-edit" "\
Customize GROUP, which must be a customization group.
If OTHER-WINDOW is non-nil, display in another window.

(fn &optional GROUP OTHER-WINDOW)" t)
(autoload 'customize-group-other-window "cus-edit" "\
Customize GROUP, which must be a customization group, in another window.

(fn &optional GROUP)" t)
(defalias 'customize-variable 'customize-option)
(autoload 'customize-option "cus-edit" "\
Customize SYMBOL, which must be a user option.

(fn SYMBOL)" t)
(autoload 'customize-toggle-option "cus-edit" "\
Toggle the value of boolean option SYMBOL for this session.

(fn SYMBOL)" t)
(defalias 'toggle-option #'customize-toggle-option)
(defalias 'customize-variable-other-window 'customize-option-other-window)
(autoload 'customize-option-other-window "cus-edit" "\
Customize SYMBOL, which must be a user option.
Show the buffer in another window, but don't select it.

(fn SYMBOL)" t)
(defvar customize-package-emacs-version-alist nil "\
Alist mapping versions of a package to Emacs versions.
We use this for packages that have their own names, but are released
as part of Emacs itself.

Each elements looks like this:

     (PACKAGE (PVERSION . EVERSION)...)

Here PACKAGE is the name of a package, as a symbol.  After
PACKAGE come one or more elements, each associating a
package version PVERSION with the first Emacs version
EVERSION in which it (or a subsequent version of PACKAGE)
was first released.  Both PVERSION and EVERSION are strings.
PVERSION should be a string that this package used in
the :package-version keyword for `defcustom', `defgroup',
and `defface'.

For example, the MH-E package updates this alist as follows:

     (add-to-list \\='customize-package-emacs-version-alist
                  \\='(MH-E (\"6.0\" . \"22.1\") (\"6.1\" . \"22.1\")
                         (\"7.0\" . \"22.1\") (\"7.1\" . \"22.1\")
                         (\"7.2\" . \"22.1\") (\"7.3\" . \"22.1\")
                         (\"7.4\" . \"22.1\") (\"8.0\" . \"22.1\")))

The value of PACKAGE needs to be unique and it needs to match the
PACKAGE value appearing in the :package-version keyword.  Since
the user might see the value in an error message, a good choice is
the official name of the package, such as MH-E or Gnus.")
(define-obsolete-function-alias 'customize-changed-options #'customize-changed "28.1")
(autoload 'customize-changed "cus-edit" "\
Customize all settings whose meanings have changed in Emacs itself.
This includes new user options and faces, and new customization
groups, as well as older options and faces whose meanings or
default values have changed since the previous major Emacs
release.

With argument SINCE-VERSION (a string), customize all settings
that were added or redefined since that version.

(fn &optional SINCE-VERSION)" t)
(autoload 'customize-face "cus-edit" "\
Customize FACE, which should be a face name or nil.
If FACE is nil, customize all faces.  If FACE is actually a
face-alias, customize the face it is aliased to.

If OTHER-WINDOW is non-nil, display in another window.

Interactively, when point is on text which has a face specified,
suggest to customize that face, if it's customizable.

(fn &optional FACE OTHER-WINDOW)" t)
(autoload 'customize-face-other-window "cus-edit" "\
Show customization buffer for face FACE in other window.
If FACE is actually a face-alias, customize the face it is aliased to.

Interactively, when point is on text which has a face specified,
suggest to customize that face, if it's customizable.

(fn &optional FACE)" t)
(autoload 'customize-unsaved "cus-edit" "\
Customize all options and faces set in this session but not saved." t)
(autoload 'customize-rogue "cus-edit" "\
Customize all user variables modified outside customize." t)
(autoload 'customize-saved "cus-edit" "\
Customize all saved options and faces." t)
(autoload 'customize-apropos "cus-edit" "\
Customize loaded options, faces and groups matching PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of
words, search for matches for any two (or more) of those words.

If TYPE is `options', include only options.
If TYPE is `faces', include only faces.
If TYPE is `groups', include only groups.

(fn PATTERN &optional TYPE)" t)
(autoload 'customize-apropos-options "cus-edit" "\
Customize all loaded customizable options matching REGEXP.

(fn REGEXP &optional IGNORED)" t)
(autoload 'customize-apropos-faces "cus-edit" "\
Customize all loaded faces matching REGEXP.

(fn REGEXP)" t)
(autoload 'customize-apropos-groups "cus-edit" "\
Customize all loaded groups matching REGEXP.

(fn REGEXP)" t)
(autoload 'custom-prompt-customize-unsaved-options "cus-edit" "\
Prompt user to customize any unsaved customization options.
Return nil if user chooses to customize, for use in
`kill-emacs-query-functions'.")
(autoload 'custom-buffer-create "cus-edit" "\
Create a buffer containing OPTIONS.
Optional NAME is the name of the buffer.
OPTIONS should be an alist of the form ((SYMBOL WIDGET)...), where
SYMBOL is a customization option, and WIDGET is a widget for editing
that option.
DESCRIPTION is unused.

(fn OPTIONS &optional NAME DESCRIPTION)")
(autoload 'custom-buffer-create-other-window "cus-edit" "\
Create a buffer containing OPTIONS, and display it in another window.
The result includes selecting that window.
Optional NAME is the name of the buffer.
OPTIONS should be an alist of the form ((SYMBOL WIDGET)...), where
SYMBOL is a customization option, and WIDGET is a widget for editing
that option.
DESCRIPTION is unused.

(fn OPTIONS &optional NAME DESCRIPTION)")
(autoload 'customize-browse "cus-edit" "\
Create a tree browser for the customize hierarchy.

(fn &optional GROUP)" t)
(defvar custom-file nil "\
File used for storing customization information.
The default is nil, which means to use your init file
as specified by `user-init-file'.  If the value is not nil,
it should be an absolute file name.

You can set this option through Custom, if you carefully read the
last paragraph below.  However, usually it is simpler to write
something like the following in your init file:

(setq custom-file \"~/.config/emacs-custom.el\")
(load custom-file)

Note that both lines are necessary: the first line tells Custom to
save all customizations in this file, but does not load it.

When you change this variable outside Custom, look in the
previous custom file (usually your init file) for the
forms `(custom-set-variables ...)'  and `(custom-set-faces ...)',
and copy them (whichever ones you find) to the new custom file.
This will preserve your existing customizations.

If you save this option using Custom, Custom will write all
currently saved customizations, including the new one for this
option itself, into the file you specify, overwriting any
`custom-set-variables' and `custom-set-faces' forms already
present in that file.  It will not delete any customizations from
the old custom file.  You should do that manually if that is what you
want.  You also have to put something like (load \"CUSTOM-FILE\")
in your init file, where CUSTOM-FILE is the actual name of the
file.  Otherwise, Emacs will not load the file when it starts up,
and hence will not set `custom-file' to that file either.")
(custom-autoload 'custom-file "cus-edit" t)
(autoload 'custom-save-all "cus-edit" "\
Save all customizations in `custom-file'.")
(autoload 'customize-save-customized "cus-edit" "\
Save all user options which have been set in this session." t)
(autoload 'custom-menu-create "cus-edit" "\
Create menu for customization group SYMBOL.
The menu is in a format applicable to `easy-menu-define'.

(fn SYMBOL)")
(autoload 'customize-menu-create "cus-edit" "\
Return a customize menu for customization group SYMBOL.
If optional NAME is given, use that as the name of the menu.
Otherwise the menu will be named `Customize'.
The format is suitable for use with `easy-menu-define'.

(fn SYMBOL &optional NAME)")
(autoload 'customize-icon "cus-edit" "\
Customize ICON.

(fn ICON)" t)
(autoload 'custom-set-icons "cus-edit" "\
Install user customizations of icon specs specified in ARGS.
These settings are registered as theme `user'.
The arguments should each be a list of the form:

  (SYMBOL EXP)

This stores EXP (without evaluating it) as the saved spec for SYMBOL.

(fn &rest ARGS)")
(autoload 'custom-save-icons "cus-edit" "\
Save all customized icons in `custom-file'.")
(autoload 'customize-dirlocals "cus-edit" "\
Customize Directory Local Variables in the current directory.

With optional argument FILENAME non-nil, customize the `.dir-locals.el' file
that FILENAME specifies.

(fn &optional FILENAME)" t)
(register-definition-prefixes "cus-edit" '("Custom-" "cus" "widget-"))


;;; Generated autoloads from cus-theme.el

(autoload 'customize-create-theme "cus-theme" "\
Create or edit a custom theme.
THEME, if non-nil, should be an existing theme to edit.  If THEME
is `user', the resulting *Custom Theme* buffer also contains a
checkbox for removing the theme settings specified in the buffer
from the Custom save file.
BUFFER, if non-nil, should be a buffer to use; the default is
named *Custom Theme*.

(fn &optional THEME BUFFER)" t)
(autoload 'custom-theme-visit-theme "cus-theme" "\
Set up a Custom buffer to edit custom theme THEME.

(fn THEME)" t)
(autoload 'describe-theme "cus-theme" "\
Display a description of the Custom theme THEME (a symbol).

(fn THEME)" t)
(autoload 'customize-themes "cus-theme" "\
Display a selectable list of Custom themes.
When called from Lisp, BUFFER should be the buffer to use; if
omitted, a buffer named *Custom Themes* is used.

(fn &optional BUFFER)" t)
(register-definition-prefixes "cus-theme" '("custom-" "describe-theme-"))


;;; Generated autoloads from cedet/ede/custom.el

(register-definition-prefixes "ede/custom" '("ede-"))


;;; Generated autoloads from vc/cvs-status.el

(autoload 'cvs-status-mode "cvs-status" "\
Mode used for cvs status output.

(fn)" t)
(register-definition-prefixes "cvs-status" '("cvs-"))


;;; Generated autoloads from progmodes/cwarn.el

(autoload 'cwarn-mode "cwarn" "\
Minor mode that highlights suspicious C and C++ constructions.

Suspicious constructs are highlighted using `font-lock-warning-face'.

Note, in addition to enabling this minor mode, the major mode must
be included in the variable `cwarn-configuration'.  By default C and
C++ modes are included.

This is a minor mode.  If called interactively, toggle the `Cwarn mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `cwarn-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-cwarn-mode 'globalized-minor-mode t)
(defvar global-cwarn-mode nil "\
Non-nil if Global Cwarn mode is enabled.
See the `global-cwarn-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-cwarn-mode'.")
(custom-autoload 'global-cwarn-mode "cwarn" nil)
(autoload 'global-cwarn-mode "cwarn" "\
Toggle Cwarn mode in all buffers.
With prefix ARG, enable Global Cwarn mode if ARG is positive;
otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Cwarn mode is enabled in all buffers where
`turn-on-cwarn-mode-if-enabled' would do it.

See `cwarn-mode' for more information on Cwarn mode.

(fn &optional ARG)" t)
(register-definition-prefixes "cwarn" '("cwarn-" "turn-on-cwarn-mode-if-enabled"))


;;; Generated autoloads from language/cyril-util.el

(autoload 'cyrillic-encode-koi8-r-char "cyril-util" "\
Return KOI8-R external character code of CHAR if appropriate.

(fn CHAR)")
(autoload 'cyrillic-encode-alternativnyj-char "cyril-util" "\
Return ALTERNATIVNYJ external character code of CHAR if appropriate.

(fn CHAR)")
(autoload 'standard-display-cyrillic-translit "cyril-util" "\
Display a Cyrillic buffer using a transliteration.
For readability, the table is slightly
different from the one used for the input method `cyrillic-translit'.

The argument is a string which specifies which language you are using;
that affects the choice of transliterations slightly.
Possible values are listed in `cyrillic-language-alist'.
If the argument is t, we use the default cyrillic transliteration.
If the argument is nil, we return the display table to its standard state.

(fn &optional CYRILLIC-LANGUAGE)" t)
(register-definition-prefixes "cyril-util" '("cyrillic-language-alist"))


;;; Generated autoloads from dabbrev.el

(put 'dabbrev-case-fold-search 'risky-local-variable t)
(put 'dabbrev-case-replace 'risky-local-variable t)
 (define-key esc-map "/" 'dabbrev-expand)
 (define-key esc-map [?\C-/] 'dabbrev-completion)
(autoload 'dabbrev-completion "dabbrev" "\
Completion on current word.
Like \\[dabbrev-expand] but finds all expansions in the current buffer
and presents suggestions for completion.

With a prefix argument ARG, it searches all buffers accepted by the
function pointed out by `dabbrev-friend-buffer-function' to find the
completions.

If the prefix argument is 16 (which comes from \\[universal-argument] \\[universal-argument]),
then it searches *all* buffers.

(fn &optional ARG)" t)
(autoload 'dabbrev-expand "dabbrev" "\
Expand previous word \"dynamically\".

Expands to the most recent, preceding word for which this is a prefix.
If no suitable preceding word is found, words following point are
considered.  If still no suitable word is found, then look in the
buffers accepted by the function pointed out by variable
`dabbrev-friend-buffer-function', if `dabbrev-check-other-buffers'
says so.  Then, if `dabbrev-check-all-buffers' is non-nil, look in
all the other buffers, subject to constraints specified
by `dabbrev-ignored-buffer-names' and `dabbrev-ignored-buffer-regexps'.

A positive prefix argument, N, says to take the Nth backward *distinct*
possibility.  A negative argument says search forward.

If the cursor has not moved from the end of the previous expansion and
no argument is given, replace the previously-made expansion
with the next possible expansion not yet tried.

The variable `dabbrev-backward-only' may be used to limit the
direction of search to backward if set non-nil.

See also `dabbrev-abbrev-char-regexp' and \\[dabbrev-completion].

(fn ARG)" t)
(register-definition-prefixes "dabbrev" '("dabbrev-"))


;;; Generated autoloads from cedet/data-debug.el

(autoload 'data-debug-new-buffer "data-debug" "\
Create a new data-debug buffer with NAME.

(fn NAME)")
(register-definition-prefixes "data-debug" '("data-debug-"))


;;; Generated autoloads from cedet/semantic/db.el

(register-definition-prefixes "semantic/db" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-debug.el

(register-definition-prefixes "semantic/db-debug" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-ebrowse.el

(register-definition-prefixes "semantic/db-ebrowse" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-el.el

(register-definition-prefixes "semantic/db-el" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-file.el

(register-definition-prefixes "semantic/db-file" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-find.el

(register-definition-prefixes "semantic/db-find" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-global.el

(register-definition-prefixes "semantic/db-global" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-javascript.el

(register-definition-prefixes "semantic/db-javascript" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-mode.el

(register-definition-prefixes "semantic/db-mode" '("semanticdb-"))


;;; Generated autoloads from cedet/semantic/db-ref.el

(register-definition-prefixes "semantic/db-ref" '("semanticdb-ref-"))


;;; Generated autoloads from cedet/semantic/db-typecache.el

(register-definition-prefixes "semantic/db-typecache" '("semanticdb-"))


;;; Generated autoloads from net/dbus.el

(autoload 'dbus-handle-event "dbus" "\
Handle events from the D-Bus.
EVENT is a D-Bus event, see `dbus-check-event'.  HANDLER, being
part of the event, is called with arguments ARGS (without type information).
If the HANDLER returns a `dbus-error', it is propagated as return message.

(fn EVENT)" t)
(function-put 'dbus-handle-event 'completion-predicate #'ignore)
(autoload 'dbus-monitor "dbus" "\
Invoke `dbus-register-monitor' interactively, and switch to the buffer.
BUS is either a Lisp keyword, `:system' or `:session', or a
string denoting the bus address.  The value nil defaults to `:session'.

(fn &optional BUS)" t)
(register-definition-prefixes "dbus" '("dbus-"))


;;; Generated autoloads from progmodes/dcl-mode.el

(autoload 'dcl-mode "dcl-mode" "\
Major mode for editing DCL-files.

This mode indents command lines in blocks.  (A block is commands between
THEN-ELSE-ENDIF and between lines matching dcl-block-begin-regexp and
dcl-block-end-regexp.)

Labels are indented to a fixed position unless they begin or end a block.
Whole-line comments (matching dcl-comment-line-regexp) are not indented.
Data lines are not indented.

Key bindings:

\\{dcl-mode-map}
Commands not usually bound to keys:

\\[dcl-save-nondefault-options]		Save changed options
\\[dcl-save-all-options]		Save all options
\\[dcl-save-option]			Save any option
\\[dcl-save-mode]			Save buffer mode

Variables controlling indentation style and extra features:

 dcl-basic-offset
    Extra indentation within blocks.

 dcl-continuation-offset
    Extra indentation for continued lines.

 dcl-margin-offset
    Indentation for the first command line in a file or SUBROUTINE.

 dcl-margin-label-offset
    Indentation for a label.

 dcl-comment-line-regexp
    Lines matching this regexp will not be indented.

 dcl-block-begin-regexp
 dcl-block-end-regexp
    Regexps that match command lines that begin and end, respectively,
    a block of command lines that will be given extra indentation.
    Command lines between THEN-ELSE-ENDIF are always indented; these variables
    make it possible to define other places to indent.
    Set to nil to disable this feature.

 dcl-calc-command-indent-function
    Can be set to a function that customizes indentation for command lines.
    Two such functions are included in the package:
	dcl-calc-command-indent-multiple
	dcl-calc-command-indent-hang

 dcl-calc-cont-indent-function
    Can be set to a function that customizes indentation for continued lines.
    One such function is included in the package:
	dcl-calc-cont-indent-relative    (set by default)

 dcl-tab-always-indent
    If t, pressing TAB always indents the current line.
    If nil, pressing TAB indents the current line if point is at the left
    margin.

 dcl-electric-characters
    Non-nil causes lines to be indented at once when a label, ELSE or ENDIF is
    typed.

 dcl-electric-reindent-regexps
    Use this variable and function dcl-electric-character to customize
    which words trigger electric indentation.

 dcl-tempo-comma
 dcl-tempo-left-paren
 dcl-tempo-right-paren
    These variables control the look of expanded templates.

 dcl-imenu-generic-expression
    Default value for `imenu-generic-expression'.  The default includes
    SUBROUTINE labels in the main listing and sub-listings for
    other labels, CALL, GOTO and GOSUB statements.

 dcl-imenu-label-labels
 dcl-imenu-label-goto
 dcl-imenu-label-gosub
 dcl-imenu-label-call
    Change the text that is used as sub-listing labels in imenu.

Turning on DCL mode calls the value of the variable `dcl-mode-hook'
with no args, if that value is non-nil.


The following example uses the default values for all variables:

$! This is a comment line that is not indented (it matches
$! dcl-comment-line-regexp)
$! Next follows the first command line.  It is indented dcl-margin-offset.
$       i = 1
$       ! Other comments are indented like command lines.
$       ! A margin label indented dcl-margin-label-offset:
$ label:
$       if i.eq.1
$       then
$           ! Lines between THEN-ELSE and ELSE-ENDIF are
$           ! indented dcl-basic-offset
$           loop1: ! This matches dcl-block-begin-regexp...
$               ! ...so this line is indented dcl-basic-offset
$               text = \"This \" + - ! is a continued line
                       \"lined up with the command line\"
$               type sys$input
Data lines are not indented at all.
$           endloop1: ! This matches dcl-block-end-regexp
$       endif
$


There is some minimal font-lock support (see vars
`dcl-font-lock-defaults' and `dcl-font-lock-keywords').

(fn)" t)
(register-definition-prefixes "dcl-mode" '("dcl-"))


;;; Generated autoloads from emacs-lisp/debug.el

(setq debugger 'debug)
(autoload 'debug "debug" "\
Enter debugger.  \\<debugger-mode-map>`\\[debugger-continue]' returns from the debugger.

In interactive sessions, this switches to a backtrace buffer and shows
the Lisp backtrace of function calls there.  In batch mode (more accurately,
when `noninteractive' is non-nil), it shows the Lisp backtrace on the
standard error stream (unless `backtrace-on-error-noninteractive' is nil),
and then kills Emacs, causing it to exit with a negative exit code.

Arguments are mainly for use when this is called from the internals
of the evaluator.

You may call with no args, or you may pass nil as the first arg and
any other args you like.  In that case, the list of args after the
first will be printed into the backtrace buffer.

If `inhibit-redisplay' is non-nil when this function is called,
the debugger will not be entered.

(fn &rest ARGS)" t)
(autoload 'debug-on-entry "debug" "\
Request FUNCTION to invoke debugger each time it is called.

When called interactively, prompt for FUNCTION in the minibuffer.

This works by modifying the definition of FUNCTION.  If you tell the
debugger to continue, FUNCTION's execution proceeds.  If FUNCTION is a
normal function or a macro written in Lisp, you can also step through
its execution.  FUNCTION can also be a primitive that is not a special
form, in which case stepping is not possible.  Break-on-entry for
primitive functions only works when that function is called from Lisp.

Use \\[cancel-debug-on-entry] to cancel the effect of this command.
Redefining FUNCTION also cancels it.

(fn FUNCTION)" t)
(autoload 'cancel-debug-on-entry "debug" "\
Undo effect of \\[debug-on-entry] on FUNCTION.
If FUNCTION is nil, cancel `debug-on-entry' for all functions.
When called interactively, prompt for FUNCTION in the minibuffer.
To specify a nil argument interactively, exit with an empty minibuffer.

(fn &optional FUNCTION)" t)
(autoload 'debug-on-variable-change "debug" "\
Trigger a debugger invocation when VARIABLE is changed.

When called interactively, prompt for VARIABLE in the minibuffer.

This works by calling `add-variable-watcher' on VARIABLE.  If you
quit from the debugger, this will abort the change (unless the
change is caused by the termination of a let-binding).

The watchpoint may be circumvented by C code that changes the
variable directly (i.e., not via `set').  Changing the value of
the variable (e.g., `setcar' on a list variable) will not trigger
watchpoint.

Use \\[cancel-debug-on-variable-change] to cancel the effect of
this command.  Uninterning VARIABLE or making it an alias of
another symbol also cancels it.

(fn VARIABLE)" t)
(defalias 'debug-watch #'debug-on-variable-change)
(autoload 'cancel-debug-on-variable-change "debug" "\
Undo effect of \\[debug-on-variable-change] on VARIABLE.
If VARIABLE is nil, cancel `debug-on-variable-change' for all variables.
When called interactively, prompt for VARIABLE in the minibuffer.
To specify a nil argument interactively, exit with an empty minibuffer.

(fn &optional VARIABLE)" t)
(defalias 'cancel-debug-watch #'cancel-debug-on-variable-change)
(register-definition-prefixes "debug" '("debug" "inhibit-debug-on-entry"))


;;; Generated autoloads from cedet/semantic/bovine/debug.el

(register-definition-prefixes "semantic/bovine/debug" '("semantic-"))


;;; Generated autoloads from cedet/semantic/analyze/debug.el

(register-definition-prefixes "semantic/analyze/debug" '("semantic-analyze"))


;;; Generated autoloads from cedet/semantic/debug.el

(register-definition-prefixes "semantic/debug" '("semantic-debug-"))


;;; Generated autoloads from play/decipher.el

(autoload 'decipher "decipher" "\
Format a buffer of ciphertext for cryptanalysis and enter Decipher mode." t)
(autoload 'decipher-mode "decipher" "\
Major mode for decrypting monoalphabetic substitution ciphers.
Lower-case letters enter plaintext.
Upper-case letters are commands.

The buffer is made read-only so that normal Emacs commands cannot
modify it.

The most useful commands are:
\\<decipher-mode-map>
\\[decipher-digram-list]  Display a list of all digrams & their frequency
\\[decipher-frequency-count]  Display the frequency of each ciphertext letter
\\[decipher-adjacency-list]  Show adjacency list for current letter (lists letters appearing next to it)
\\[decipher-make-checkpoint]  Save the current cipher alphabet (checkpoint)
\\[decipher-restore-checkpoint]  Restore a saved cipher alphabet (checkpoint)

(fn)" t)
(register-definition-prefixes "decipher" '("decipher-"))


;;; Generated autoloads from cedet/semantic/decorate.el

(register-definition-prefixes "semantic/decorate" '("semantic-"))


;;; Generated autoloads from delim-col.el

(autoload 'delimit-columns-customize "delim-col" "\
Customize the `columns' group." t)
(autoload 'delimit-columns-region "delim-col" "\
Prettify all columns in a text region.

START and END delimit the text region.

If you have, for example, the following columns:

       a       b       c       d
       aaaa    bb      ccc     ddddd

Depending on your settings (see below), you then obtain the
following result:

       [ a   , b  , c      , d     ]
       [ aaaa, bb , ccc    , ddddd ]

See the `delimit-columns-str-before',
`delimit-columns-str-after', `delimit-columns-str-separator',
`delimit-columns-before', `delimit-columns-after',
`delimit-columns-separator', `delimit-columns-format' and
`delimit-columns-extra' variables for customization of the
look.

(fn START END)" t)
(autoload 'delimit-columns-rectangle "delim-col" "\
Prettify all columns in a text rectangle.

See `delimit-columns-region' for what this entails.

START and END delimit the corners of the text rectangle.

(fn START END)" t)
(register-definition-prefixes "delim-col" '("delimit-columns-"))


;;; Generated autoloads from delsel.el

(defalias 'pending-delete-mode 'delete-selection-mode)
(defvar delete-selection-mode nil "\
Non-nil if Delete-Selection mode is enabled.
See the `delete-selection-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `delete-selection-mode'.")
(custom-autoload 'delete-selection-mode "delsel" nil)
(autoload 'delete-selection-mode "delsel" "\
Toggle Delete Selection mode.

When Delete Selection mode is enabled, typed text replaces the selection
if the selection is active.  Otherwise, typed text is just inserted at
point regardless of any selection.

See `delete-selection-helper' and `delete-selection-pre-hook' for
information on adapting behavior of commands in Delete Selection mode.

This is a global minor mode.  If called interactively, toggle the
`Delete-Selection mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='delete-selection-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'delete-active-region "delsel" "\
Delete the active region.
If KILLP is non-nil, or if called interactively with a prefix argument,
the active region is killed instead of deleted.

(fn &optional KILLP)" t)
(register-definition-prefixes "delsel" '("del" "minibuffer-keyboard-quit"))


;;; Generated autoloads from cedet/semantic/dep.el

(register-definition-prefixes "semantic/dep" '("defcustom-mode-local-semantic-dependency-system-include-path" "semantic-"))


;;; Generated autoloads from emacs-lisp/derived.el

(autoload 'define-derived-mode "derived" "\
Create a new mode CHILD which is a variant of an existing mode PARENT.

The arguments are as follows:

CHILD:     the name of the command for the derived mode.
PARENT:    the name of the command for the parent mode (e.g. `text-mode')
           or nil if there is no parent.
NAME:      a string that will appear in the mode line (e.g. \"HTML\")
DOCSTRING: an optional documentation string--if you do not supply one,
           the function will attempt to invent something useful.
KEYWORD-ARGS:
           optional arguments in the form of pairs of keyword and value.
           The following keyword arguments are currently supported:

           :group GROUP
                   Declare the customization group that corresponds
                   to this mode.  The command `customize-mode' uses this.
           :syntax-table TABLE
                   Use TABLE instead of the default (CHILD-syntax-table).
                   A nil value means to simply use the same syntax-table
                   as the parent.
           :abbrev-table TABLE
                   Use TABLE instead of the default (CHILD-abbrev-table).
                   A nil value means to simply use the same abbrev-table
                   as the parent.
           :after-hook FORM
                   A single Lisp form which is evaluated after the mode
                   hooks have been run.  It should not be quoted.
           :interactive BOOLEAN
                   Whether the derived mode should be `interactive' or not.
                   The default is t.

BODY:      forms to execute just before running the
           hooks for the new mode.  Do not use `interactive' here.

Here is how you could define LaTeX-Thesis mode as a variant of LaTeX mode:

  (define-derived-mode LaTeX-thesis-mode LaTeX-mode \"LaTeX-Thesis\")

You could then make new key bindings for `LaTeX-thesis-mode-map'
without changing regular LaTeX mode.  In this example, BODY is empty,
and DOCSTRING is generated by default.

As a more complex example, the following command uses `sgml-mode' as
the parent, and then sets the variable `case-fold-search' to nil:

  (define-derived-mode article-mode sgml-mode \"Article\"
    \"Major mode for editing technical articles.\"
    (setq case-fold-search nil))

Note that if the documentation string had been left out, it would have
been generated automatically, with a reference to the keymap.

The new mode runs the hook named MODE-hook.  For `foo-mode',
the hook will be named `foo-mode-hook'.

See Info node `(elisp)Derived Modes' for more details.

(fn CHILD PARENT NAME [DOCSTRING] [KEYWORD-ARGS...] &rest BODY)" nil t)
(function-put 'define-derived-mode 'doc-string-elt 4)
(function-put 'define-derived-mode 'lisp-indent-function 'defun)
(register-definition-prefixes "derived" '("derived-mode-"))


;;; Generated autoloads from descr-text.el

(autoload 'describe-text-properties "descr-text" "\
Describe widgets, buttons, overlays, and text properties at POS.
POS is taken to be in BUFFER or in current buffer if nil.
Interactively, describe them for the character after point.
If optional second argument OUTPUT-BUFFER is non-nil,
insert the output into that buffer, and don't initialize or clear it
otherwise.

(fn POS &optional OUTPUT-BUFFER BUFFER)" t)
(autoload 'describe-char "descr-text" "\
Describe position POS (interactively, point) and the char after POS.
POS is taken to be in BUFFER, or the current buffer if BUFFER is nil.
The information is displayed in buffer `*Help*'.

The position information includes POS; the total size of BUFFER; the
region limits, if narrowed; the column number; and the horizontal
scroll amount, if the buffer is horizontally scrolled.

The character information includes:
 its codepoint;
 its charset (see `char-charset'), overridden by the `charset' text
   property at POS, if any;
 the codepoint of the character in the above charset;
 the character's script (as defined by `char-script-table')
 the character's syntax, as produced by `syntax-after'
   and `internal-describe-syntax-value';
 its category (see `char-category-set' and `describe-char-categories');
 how to input the character using the keyboard and input methods;
 how the character is encoded in BUFFER and in BUFFER's file;
 the font and font glyphs used to display the character;
 the composition information for displaying the character (if relevant);
 the character's canonical name and other properties defined by the
   Unicode Data Base;
 and widgets, buttons, overlays, and text properties relevant to POS.

(fn POS &optional BUFFER)" t)
(autoload 'describe-char-eldoc "descr-text" "\
Return a description of character at point for use by ElDoc mode.

Return nil if character at point is a printable ASCII
character (i.e. codepoint between 32 and 127 inclusively).
Otherwise return a description formatted by
`describe-char-eldoc--format' function taking into account value
of `eldoc-echo-area-use-multiline-p' variable and width of
minibuffer window for width limit.

This function can be used as a value of
`eldoc-documentation-functions' variable.

(fn CALLBACK &rest _)")
(register-definition-prefixes "descr-text" '("describe-"))


;;; Generated autoloads from desktop.el

(defvar desktop-save-mode nil "\
Non-nil if Desktop-Save mode is enabled.
See the `desktop-save-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `desktop-save-mode'.")
(custom-autoload 'desktop-save-mode "desktop" nil)
(autoload 'desktop-save-mode "desktop" "\
Toggle desktop saving (Desktop Save mode).

When Desktop Save mode is enabled, the state of Emacs is saved from one
session to another.  The saved Emacs \"desktop configuration\" includes the
buffers, their file names, major modes, buffer positions, window and frame
configuration, and some important global variables.

To enable this feature for future sessions, customize `desktop-save-mode'
to t, or add this line in your init file:

    (desktop-save-mode 1)

When this mode is enabled, Emacs will save the desktop when it exits
(this may prompt you, see the option `desktop-save').  The next time
Emacs starts, if this mode is active it will restore the desktop.

To manually save the desktop at any time, use the command \\[desktop-save].
To load it, use \\[desktop-read].

Once a desktop file exists, Emacs will auto-save it according to the
option `desktop-auto-save-timeout'.

To see all the options you can set, browse the `desktop' customization group.

For further details, see info node `(emacs)Saving Emacs Sessions'.

This is a global minor mode.  If called interactively, toggle the
`Desktop-Save mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='desktop-save-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar desktop-locals-to-save '(desktop-locals-to-save truncate-lines case-fold-search case-replace fill-column overwrite-mode change-log-default-name line-number-mode column-number-mode size-indication-mode buffer-file-coding-system buffer-display-time indent-tabs-mode tab-width indicate-buffer-boundaries indicate-empty-lines show-trailing-whitespace) "\
List of local variables to save for each buffer.
The variables are saved only when they really are local.  Conventional minor
modes are restored automatically; they should not be listed here.")
(custom-autoload 'desktop-locals-to-save "desktop" t)
(defvar-local desktop-save-buffer nil "\
When non-nil, save buffer status in desktop file.

If the value is a function, it is called by `desktop-save' with argument
DESKTOP-DIRNAME to obtain auxiliary information to save in the desktop
file along with the state of the buffer for which it was called.

When file names are returned, they should be formatted using the call
\"(desktop-file-name FILE-NAME DESKTOP-DIRNAME)\".

Later, when `desktop-read' evaluates the desktop file, auxiliary information
is passed as the argument DESKTOP-BUFFER-MISC to functions in
`desktop-buffer-mode-handlers'.")
(defvar desktop-buffer-mode-handlers nil "\
Alist of major mode specific functions to restore a desktop buffer.
Functions listed are called by `desktop-create-buffer' when `desktop-read'
evaluates the desktop file.  List elements must have the form

   (MAJOR-MODE . RESTORE-BUFFER-FUNCTION).

Buffers with a major mode not specified here, are restored by the default
handler `desktop-restore-file-buffer'.

Handlers are called with argument list

   (DESKTOP-BUFFER-FILE-NAME DESKTOP-BUFFER-NAME DESKTOP-BUFFER-MISC)

Furthermore, they may use the following variables:

   `desktop-file-version'
   `desktop-buffer-major-mode'
   `desktop-buffer-minor-modes'
   `desktop-buffer-point'
   `desktop-buffer-mark'
   `desktop-buffer-read-only'
   `desktop-buffer-locals'

If a handler returns a buffer, then the saved mode settings
and variable values for that buffer are copied into it.

Modules that define a major mode that needs a special handler should contain
code like

   (defun foo-restore-desktop-buffer
   ...
   (add-to-list \\='desktop-buffer-mode-handlers
                \\='(foo-mode . foo-restore-desktop-buffer))

The major mode function must either be autoloaded, or of the form
\"foobar-mode\" and defined in library \"foobar\", so that desktop
can guess how to load the mode's definition.")
(put 'desktop-buffer-mode-handlers 'risky-local-variable t)
(defvar desktop-minor-mode-handlers nil "\
Alist of functions to restore non-standard minor modes.
Functions are called by `desktop-create-buffer' to restore minor modes.
List elements must have the form

   (MINOR-MODE . RESTORE-FUNCTION).

Minor modes not specified here, are restored by the standard minor mode
function.

Handlers are called with argument list

   (DESKTOP-BUFFER-LOCALS)

Furthermore, they may use the following variables:

   `desktop-file-version'
   `desktop-buffer-file-name'
   `desktop-buffer-name'
   `desktop-buffer-major-mode'
   `desktop-buffer-minor-modes'
   `desktop-buffer-point'
   `desktop-buffer-mark'
   `desktop-buffer-read-only'
   `desktop-buffer-misc'

When a handler is called, the buffer has been created and the major mode has
been set, but local variables listed in desktop-buffer-locals has not yet been
created and set.

Modules that define a minor mode that needs a special handler should contain
code like

   (defun foo-desktop-restore
   ...
   (add-to-list \\='desktop-minor-mode-handlers
                \\='(foo-mode . foo-desktop-restore))

The minor mode function must either be autoloaded, or of the form
\"foobar-mode\" and defined in library \"foobar\", so that desktop
can guess how to load the mode's definition.

See also `desktop-minor-mode-table'.")
(put 'desktop-minor-mode-handlers 'risky-local-variable t)
(autoload 'desktop-clear "desktop" "\
Empty the Desktop.
This kills all buffers except for internal ones and those with names matched by
a regular expression in the list `desktop-clear-preserve-buffers'.
Furthermore, it clears the variables listed in `desktop-globals-to-clear'.
When called interactively and `desktop-restore-frames' is non-nil, it also
deletes all frames except the selected one (and its minibuffer frame,
if different)." t)
(autoload 'desktop-save "desktop" "\
Save the state of Emacs in a desktop file in directory DIRNAME.
Optional argument RELEASE non-nil says we're done with this
desktop, in which case this function releases the lock of the
desktop file in DIRNAME.
If ONLY-IF-CHANGED is non-nil, compare the current desktop
information to that in the desktop file, and if the desktop
information has not changed since it was last saved, then do
not rewrite the file.

To restore the desktop, use `desktop-read'.

This function can save the desktop in either format version
208 (which only Emacs 25.1 and later can read) or version
206 (which is readable by any Emacs from version 22.1 onwards).
By default, it will use the same format the desktop file had when
it was last saved, or version 208 when writing a fresh desktop
file.

To upgrade a version 206 file to version 208, call this command
explicitly with a prefix argument: \\[universal-argument] \\[desktop-save].
If you are upgrading from Emacs 24 or older, we recommend to do
this once you decide you no longer need compatibility with versions
of Emacs before 25.1.

To downgrade a version 208 file to version 206, use a double prefix
argument: \\[universal-argument] \\[universal-argument] \\[desktop-save].

Emacs will ask for confirmation when you upgrade or downgrade your
desktop file.

In a non-interactive call, VERSION can be given as an integer, either
206 or 208, to specify the format version in which to save the file,
no questions asked.

(fn DIRNAME &optional RELEASE ONLY-IF-CHANGED VERSION)" t)
(autoload 'desktop-remove "desktop" "\
Delete desktop file in `desktop-dirname'.
This function also sets `desktop-dirname' to nil." t)
(autoload 'desktop-read "desktop" "\
Read and process the desktop file in directory DIRNAME.
Look for a desktop file in DIRNAME, or if DIRNAME is omitted, look in
directories listed in `desktop-path'.  If a desktop file is found, it
is processed and `desktop-after-read-hook' is run.  If no desktop file
is found, clear the desktop and run `desktop-no-desktop-file-hook'.
Interactively, with prefix arg \\[universal-argument], ask for DIRNAME.
This function is a no-op when Emacs is running in batch mode.
It returns t if a desktop file was loaded, nil otherwise.

(fn DIRNAME)" t)
(autoload 'desktop-change-dir "desktop" "\
Change to desktop saved in DIRNAME.
Kill the desktop as specified by variables `desktop-save-mode' and
`desktop-save', then clear the desktop and load the desktop file in
directory DIRNAME.

(fn DIRNAME)" t)
(autoload 'desktop-save-in-desktop-dir "desktop" "\
Save the desktop in directory `desktop-dirname'." t)
(autoload 'desktop-revert "desktop" "\
Revert to the last loaded desktop." t)
(register-definition-prefixes "desktop" '("desktop-"))


;;; Generated autoloads from cedet/ede/detect.el

(register-definition-prefixes "ede/detect" '("ede-"))


;;; Generated autoloads from gnus/deuglify.el

(autoload 'gnus-article-outlook-unwrap-lines "deuglify" "\
Unwrap lines that appear to be wrapped citation lines.
You can control what lines will be unwrapped by frobbing
`gnus-outlook-deuglify-unwrap-min' and `gnus-outlook-deuglify-unwrap-max',
indicating the minimum and maximum length of an unwrapped citation line.  If
NODISPLAY is non-nil, don't redisplay the article buffer.

(fn &optional NODISPLAY)" '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-article-outlook-repair-attribution "deuglify" "\
Repair a broken attribution line.
If NODISPLAY is non-nil, don't redisplay the article buffer.

(fn &optional NODISPLAY)" '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-article-outlook-rearrange-citation "deuglify" "\
Repair broken citations.
If NODISPLAY is non-nil, don't redisplay the article buffer.

(fn &optional NODISPLAY)" '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-outlook-deuglify-article "deuglify" "\
Full deuglify of broken Outlook (Express) articles.
Treat \"smartquotes\", unwrap lines, repair attribution and
rearrange citation.  If NODISPLAY is non-nil, don't redisplay the
article buffer.

(fn &optional NODISPLAY)" '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-article-outlook-deuglify-article "deuglify" "\
Deuglify broken Outlook (Express) articles and redisplay." '(gnus-article-mode gnus-summary-mode))
(register-definition-prefixes "deuglify" '("gnus-outlook-"))


;;; Generated autoloads from dframe.el

(register-definition-prefixes "dframe" '("dframe-"))


;;; Generated autoloads from calendar/diary-lib.el

(autoload 'diary "diary-lib" "\
Generate the diary window for ARG days starting with the current date.
If no argument is provided, the number of days of diary entries is governed
by the variable `diary-number-of-entries'.  A value of ARG less than 1
does nothing.  This function is suitable for execution in an init file.

(fn &optional ARG)" t)
(autoload 'diary-mail-entries "diary-lib" "\
Send a mail message showing diary entries for next NDAYS days.
If no prefix argument is given, NDAYS is set to `diary-mail-days'.
Mail is sent to the address specified by `diary-mail-addr'.

Here is an example of a script to call `diary-mail-entries',
suitable for regular scheduling using cron (or at).  Note that
since `emacs -script' does not load your init file, you should
ensure that all relevant variables are set.

#!/usr/bin/emacs -script
;; diary-rem.el - run the Emacs diary-reminder

(setq diary-mail-days 3
      diary-file \"/path/to/diary.file\"
      calendar-date-style \\='european
      diary-mail-addr \"user@host.name\")

(diary-mail-entries)

# diary-rem.el ends here

(fn &optional NDAYS)" t)
(autoload 'diary-mode "diary-lib" "\
Major mode for editing the diary file.

(fn)" t)
(register-definition-prefixes "diary-lib" '("calendar-mark-" "diary-"))


;;; Generated autoloads from net/dictionary.el

(autoload 'dictionary-mode "dictionary" "\
Mode for searching a dictionary.

This is a mode for searching a dictionary server implementing the
protocol defined in RFC 2229.

This is a quick reference to this mode describing the default key bindings:
\\<dictionary-mode-map>
 \\[dictionary-close]	close the dictionary buffer
 \\[describe-mode]	display this help
 \\[dictionary-search]	ask for a new word to search
 \\[dictionary-lookup-definition]	search for word at point
 \\[forward-button] or \\`TAB'	move point to the next link
 \\[backward-button] or \\`S-TAB'	move point to the previous link

 \\[dictionary-match-words]	ask for a pattern and list all matching words
 \\[dictionary-select-dictionary]	select the default dictionary
 \\[dictionary-select-strategy]	select the default search strategy

 \\`RET'	visit link at point
 \\`<mouse-2>'	visit clicked link

(fn)" t)
(autoload 'dictionary "dictionary" "\
Create a new dictionary buffer and install `dictionary-mode'." t)
(autoload 'dictionary-search "dictionary" "\
Search for WORD in all the known dictionaries.
Interactively, prompt for WORD, and offer the word at point as default.

Optional argument DICTIONARY means restrict the search to only
that one dictionary.  Interactively, with prefix argument,
prompt for DICTIONARY.

(fn WORD &optional DICTIONARY)" t)
(autoload 'dictionary-lookup-definition "dictionary" "\
Unconditionally lookup the word at point." t)
(autoload 'dictionary-match-words "dictionary" "\
Search PATTERN in current default dictionary using default strategy.

(fn &optional PATTERN &rest IGNORED)" t)
(autoload 'dictionary-mouse-popup-matching-words "dictionary" "\
Display entries matching the word at the cursor retrieved using EVENT.

(fn EVENT)" t)
(autoload 'dictionary-popup-matching-words "dictionary" "\
Display entries matching WORD or the current word if not given.

(fn &optional WORD)" t)
(autoload 'dictionary-tooltip-mode "dictionary" "\
Display tooltips for the current word.

This function can be used to enable or disable the tooltip mode
for the current buffer (based on ARG).  If global-tooltip-mode is
active it will overwrite that mode for the current buffer.

(fn &optional ARG)" t)
(autoload 'global-dictionary-tooltip-mode "dictionary" "\
Enable/disable `dictionary-tooltip-mode' for all buffers.

Internally it provides a default for the `dictionary-tooltip-mode'.
It can be overwritten for each buffer using `dictionary-tooltip-mode'.

Note: (global-dictionary-tooltip-mode 0) will not disable the mode
any buffer where (dictionary-tooltip-mode 1) has been called.

(fn &optional ARG)" t)
(autoload 'dictionary-context-menu "dictionary" "\
Populate MENU with dictionary commands at CLICK.
When you add this function to `context-menu-functions',
the context menu will contain an item that searches
the word at mouse click.

(fn MENU CLICK)")
(register-definition-prefixes "dictionary" '("dictionary-" "global-dictionary-tooltip-mode" "help-word"))


;;; Generated autoloads from cedet/srecode/dictionary.el

(register-definition-prefixes "srecode/dictionary" '("srecode-"))


;;; Generated autoloads from net/dictionary-connection.el

(register-definition-prefixes "dictionary-connection" '("dictionary-connection-"))


;;; Generated autoloads from vc/diff.el

(defvar diff-switches (purecopy "-u") "\
A string or list of strings specifying switches to be passed to diff.

This variable is also used in the `vc-diff' command (and related
commands) if the backend-specific diff switch variable isn't
set (`vc-git-diff-switches' for git, for instance), and
`vc-diff-switches' isn't set.")
(custom-autoload 'diff-switches "diff" t)
(defvar diff-command (purecopy "diff") "\
The command to use to run diff.")
(custom-autoload 'diff-command "diff" t)
(autoload 'diff "diff" "\
Find and display the differences between OLD and NEW files.
When called interactively, read NEW, then OLD, using the
minibuffer.  The default for NEW is the current buffer's file
name, and the default for OLD is a backup file for NEW, if one
exists.  If NO-ASYNC is non-nil, call diff synchronously.

When called interactively with a prefix argument SWITCHES, prompt
interactively for diff switches.  Otherwise, the switches
specified in the variable `diff-switches' are passed to the diff
command.

Non-interactively, OLD and NEW may each be a file or a buffer.

(fn OLD NEW &optional SWITCHES NO-ASYNC)" t)
(autoload 'diff-backup "diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'.
With prefix arg SWITCHES, prompt for diff switches.

(fn FILE &optional SWITCHES)" t)
(autoload 'diff-latest-backup-file "diff" "\
Return the latest existing backup of file FN, or nil.

(fn FN)")
(autoload 'diff-buffer-with-file "diff" "\
View the differences between BUFFER and its associated file.
This requires the external program `diff' to be in your `exec-path'.

(fn &optional BUFFER)" t)
(autoload 'diff-buffers "diff" "\
Find and display the differences between OLD and NEW buffers.

When called interactively, read NEW, then OLD, using the
minibuffer.  The default for NEW is the current buffer, and the
default for OLD is the most recently selected other buffer.
If NO-ASYNC is non-nil, call diff synchronously.

When called interactively with a prefix argument, prompt
interactively for diff switches.  Otherwise, the switches
specified in the variable `diff-switches' are passed to the
diff command.

OLD and NEW may each be a buffer or a buffer name.

Also see the `diff-entire-buffers' variable.

(fn OLD NEW &optional SWITCHES NO-ASYNC)" t)
(register-definition-prefixes "diff" '("diff-"))


;;; Generated autoloads from vc/diff-mode.el

(autoload 'diff-mode "diff-mode" "\
Major mode for viewing/editing context diffs.
Supports unified and context diffs as well as (to a lesser extent)
normal diffs.

When the buffer is read-only, the ESC prefix is not necessary.
If you edit the buffer manually, `diff-mode' will try to update the hunk
headers for you on-the-fly.

You can also switch between context diff and unified diff with \\[diff-context->unified],
or vice versa with \\[diff-unified->context] and you can also reverse the direction of
a diff with \\[diff-reverse-direction].

\\{diff-mode-map}

(fn)" t)
(autoload 'diff-minor-mode "diff-mode" "\
Toggle Diff minor mode.

\\{diff-minor-mode-map}

This is a minor mode.  If called interactively, toggle the `Diff minor
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `diff-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar diff-add-log-use-relative-names nil "\
Use relative file names when generating ChangeLog skeletons.
The files will be relative to the root directory of the VC
repository.  This option affects the behavior of
`diff-add-log-current-defuns'.")
(custom-autoload 'diff-add-log-use-relative-names "diff-mode" t)
(put 'diff-add-log-use-relative-names 'safe-local-variable #'booleanp)
(autoload 'diff-vc-deduce-fileset "diff-mode")
(register-definition-prefixes "diff-mode" '("diff-"))


;;; Generated autoloads from net/dig.el

(autoload 'dig "dig" "\
Query addresses of a DOMAIN using dig.
See `dig-invoke' for an explanation for the parameters.
When called interactively, DOMAIN is prompted for.

If given a \\[universal-argument] prefix, also prompt for the QUERY-TYPE parameter.

If given a \\[universal-argument] \\[universal-argument] prefix, also prompt for the SERVER parameter.

(fn DOMAIN &optional QUERY-TYPE QUERY-CLASS QUERY-OPTION DIG-OPTION SERVER)" t)
(register-definition-prefixes "dig" '("dig-"))


;;; Generated autoloads from cedet/ede/dired.el

(register-definition-prefixes "ede/dired" '("ede-dired-"))


;;; Generated autoloads from dired.el

(defvar dired-listing-switches (purecopy "-al") "\
Switches passed to `ls' for Dired.  MUST contain the `l' option.
May contain all other options that don't contradict `-l';
may contain even `F', `b', `i' and `s'.  See also the variable
`dired-ls-F-marks-symlinks' concerning the `F' switch.

If you have files with names with embedded newline characters, adding
`b' to the switches will allow Dired to handle those files better.

Options that include embedded whitespace must be quoted
like this: \"--option=value with spaces\"; you can use
`combine-and-quote-strings' to produce the correct quoting of
each option.

On systems such as MS-DOS and MS-Windows, which use `ls' emulation in Lisp,
some of the `ls' switches are not supported; see the doc string of
`insert-directory' in `ls-lisp.el' for more details.

For remote Dired buffers, this option supports connection-local values.")
(custom-autoload 'dired-listing-switches "dired" t)
(defvar-local dired-directory nil "\
The directory name or wildcard spec that this Dired directory lists.
Local to each Dired buffer.  May be a list, in which case the car is the
directory name and the cdr is the list of files to mention.
The directory name must be absolute, but need not be fully expanded.")
 (define-key ctl-x-map "d" 'dired)
(autoload 'dired "dired" "\
\"Edit\" directory DIRNAME--delete, rename, print, etc. some files in it.
Optional second argument SWITCHES specifies the options to be used
when invoking `insert-directory-program', usually `ls', which produces
the listing of the directory files and their attributes.
Interactively, a prefix argument will cause the command to prompt
for SWITCHES.

If DIRNAME is a string, Dired displays a list of files in DIRNAME (which
may also have shell wildcards appended to select certain files).

If DIRNAME is a cons, its first element is taken as the directory name
and the rest as an explicit list of files to make directory entries for.
In this case, SWITCHES are applied to each of the files separately, and
therefore switches that control the order of the files in the produced
listing have no effect.

\\<dired-mode-map>You can flag files for deletion with \\[dired-flag-file-deletion] and then
delete them by typing \\[dired-do-flagged-delete].
Type \\[describe-mode] after entering Dired for more info.

If DIRNAME is already in a Dired buffer, that buffer is used without refresh.

(fn DIRNAME &optional SWITCHES)" t)
 (define-key ctl-x-4-map "d" 'dired-other-window)
(autoload 'dired-other-window "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but select in another window.

(fn DIRNAME &optional SWITCHES)" t)
 (define-key ctl-x-5-map "d" 'dired-other-frame)
(autoload 'dired-other-frame "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but make a new frame.

(fn DIRNAME &optional SWITCHES)" t)
 (define-key tab-prefix-map "d" 'dired-other-tab)
(autoload 'dired-other-tab "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but make a new tab.

(fn DIRNAME &optional SWITCHES)" t)
(autoload 'dired-noselect "dired" "\
Like `dired' but return the Dired buffer as value, do not select it.

(fn DIR-OR-LIST &optional SWITCHES)")
(autoload 'dired-mode "dired" "\
Mode for \"editing\" directory listings.
In Dired, you are \"editing\" a list of the files in a directory and
  (optionally) its subdirectories, in the format of `ls -lR'.
  Each directory is a page: use \\[backward-page] and \\[forward-page] to move pagewise.
\"Editing\" means that you can run shell commands on files, visit,
  compress, load or byte-compile them, change their file attributes
  and insert subdirectories into the same buffer.  You can \"mark\"
  files for later commands or \"flag\" them for deletion, either file
  by file or all files matching certain criteria.
You can move using the usual cursor motion commands.\\<dired-mode-map>
The buffer is read-only.  Digits are prefix arguments.
Type \\[dired-flag-file-deletion] to flag a file `D' for deletion.
Type \\[dired-mark] to Mark a file or subdirectory for later commands.
  Most commands operate on the marked files and use the current file
  if no files are marked.  Use a numeric prefix argument to operate on
  the next ARG (or previous -ARG if ARG<0) files, or just `1'
  to operate on the current file only.  Prefix arguments override marks.
  Mark-using commands display a list of failures afterwards.  Type \\[dired-summary]
  to see why something went wrong.
Type \\[dired-unmark] to Unmark a file or all files of an inserted subdirectory.
Type \\[dired-unmark-backward] to back up one line and unmark or unflag.
Type \\[dired-do-flagged-delete] to delete (eXpunge) the files flagged `D'.
Type \\[dired-find-file] to Find the current line's file
  (or dired it in another buffer, if it is a directory).
Type \\[dired-find-file-other-window] to find file or Dired directory in Other window.
Type \\[dired-maybe-insert-subdir] to Insert a subdirectory in this buffer.
Type \\[dired-do-rename] to Rename a file or move the marked files to another directory.
Type \\[dired-do-copy] to Copy files.
Type \\[dired-sort-toggle-or-edit] to toggle Sorting by name/date or change the `ls' switches.
Type \\[revert-buffer] to read all currently expanded directories aGain.
  This retains all marks and hides subdirs again that were hidden before.
Use \\`SPC' and \\`DEL' to move down and up by lines.

If Dired ever gets confused, you can either type \\[revert-buffer] to read the
directories again, type \\[dired-do-redisplay] to relist the file at point or the marked files or a
subdirectory, or type \\[dired-build-subdir-alist] to parse the buffer
again for the directory tree.

See the `dired' customization group for a list of user options.

This mode runs the following hooks:

  `dired-before-readin-hook'
  `dired-after-readin-hook'
  `dired-mode-hook'

Keybindings:
\\{dired-mode-map}

(fn &optional DIRNAME SWITCHES)")
 (put 'dired-find-alternate-file 'disabled t)
(autoload 'dired-jump "dired" "\
Jump to Dired buffer corresponding to current buffer.
If in a buffer visiting a file, Dired that file's directory and
move to that file's line in the directory listing.

If the current buffer isn't visiting a file, Dired `default-directory'.

If in Dired already, pop up a level and goto old directory's line.
In case the proper Dired file line cannot be found, refresh the Dired
buffer and try again.

When OTHER-WINDOW is non-nil, jump to Dired buffer in other window.

When FILE-NAME is non-nil, jump to its line in Dired.
Interactively with prefix argument, read FILE-NAME.

(fn &optional OTHER-WINDOW FILE-NAME)" t)
(autoload 'dired-jump-other-window "dired" "\
Like \\[dired-jump] (`dired-jump') but in other window.

(fn &optional FILE-NAME)" t)
(register-definition-prefixes "dired" '("dired-"))


;;; Generated autoloads from dired-aux.el

(register-definition-prefixes "dired-aux" '("dired-" "shell-command-guess"))


;;; Generated autoloads from dired-x.el

(register-definition-prefixes "dired-x" '("dired-" "virtual-dired"))


;;; Generated autoloads from dirtrack.el

(autoload 'dirtrack-mode "dirtrack" "\
Toggle directory tracking in shell buffers (Dirtrack mode).

This method requires that your shell prompt contain the current
working directory at all times, and that you set the variable
`dirtrack-list' to match the prompt.

This is an alternative to `shell-dirtrack-mode', which works by
tracking `cd' and similar commands which change the shell working
directory.

This is a minor mode.  If called interactively, toggle the `Dirtrack
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `dirtrack-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'dirtrack "dirtrack" "\
Determine the current directory from the process output for a prompt.
This filter function is used by `dirtrack-mode'.  It looks for
the prompt specified by `dirtrack-list', and calls
`shell-process-cd' if the directory seems to have changed away
from `default-directory'.

(fn INPUT)")
(register-definition-prefixes "dirtrack" '("dirtrack-"))


;;; Generated autoloads from emacs-lisp/disass.el

(autoload 'disassemble "disass" "\
Print disassembled code for OBJECT in (optional) BUFFER.
OBJECT can be a symbol defined as a function, or a function itself
(a lambda expression or a byte-code-function object).
If OBJECT is not already compiled, we compile it, but do not
redefine OBJECT if it is a symbol.

(fn OBJECT &optional BUFFER INDENT INTERACTIVE-P)" t)
(register-definition-prefixes "disass" '("disassemble-" "re-disassemble"))


;;; Generated autoloads from disp-table.el

(autoload 'make-display-table "disp-table" "\
Return a new, empty display table.")
(autoload 'display-table-slot "disp-table" "\
Return the value of the extra slot in DISPLAY-TABLE named SLOT.
SLOT may be a number from 0 to 5 inclusive, or a slot name (symbol).
Valid symbols are `truncation', `wrap', `escape', `control',
`selective-display', and `vertical-border'.

(fn DISPLAY-TABLE SLOT)")
(autoload 'set-display-table-slot "disp-table" "\
Set the value of the extra slot in DISPLAY-TABLE named SLOT to VALUE.
SLOT may be a number from 0 to 5 inclusive, or a name (symbol).
Valid symbols are `truncation', `wrap', `escape', `control',
`selective-display', and `vertical-border'.

(fn DISPLAY-TABLE SLOT VALUE)")
(autoload 'describe-display-table "disp-table" "\
Describe the display table DT in a help buffer.

(fn DT)")
(autoload 'describe-current-display-table "disp-table" "\
Describe the display table in use in the selected window and buffer." t)
(autoload 'standard-display-8bit "disp-table" "\
Display characters representing raw bytes in the range L to H literally.

On a terminal display, each character in the range is displayed
by sending the corresponding byte directly to the terminal.

On a graphic display, each character in the range is displayed
using the default font by a glyph whose code is the corresponding
byte.

Note that ASCII printable characters (SPC to TILDA) are displayed
in the default way after this call.

(fn L H)")
(autoload 'standard-display-default "disp-table" "\
Display characters in the range L to H using the default notation.

(fn L H)")
(autoload 'standard-display-ascii "disp-table" "\
Display character C using printable string S.

(fn C S)")
(autoload 'standard-display-g1 "disp-table" "\
Display character C as character SC in the g1 character set.
This function assumes that your terminal uses the SO/SI characters;
it is meaningless for a graphical frame.

(fn C SC)")
(autoload 'standard-display-graphic "disp-table" "\
Display character C as character GC in graphics character set.
This function assumes VT100-compatible escapes; it is meaningless
for a graphical frame.

(fn C GC)")
(autoload 'standard-display-underline "disp-table" "\
Display character C as character UC plus underlining.

(fn C UC)")
(autoload 'create-glyph "disp-table" "\
Allocate a glyph code to display by sending STRING to the terminal.

(fn STRING)")
(autoload 'make-glyph-code "disp-table" "\
Return a glyph code representing char CHAR with face FACE.

(fn CHAR &optional FACE)")
(autoload 'glyph-char "disp-table" "\
Return the character of glyph code GLYPH.

(fn GLYPH)")
(autoload 'glyph-face "disp-table" "\
Return the face of glyph code GLYPH, or nil if glyph has default face.

(fn GLYPH)")
(autoload 'standard-display-european "disp-table" "\
Semi-obsolete way to toggle display of ISO 8859 European characters.

This function is semi-obsolete; you probably don't need it, or else you
probably should use `set-language-environment' or `set-locale-environment'.

This function enables European character display if ARG is positive,
disables it if negative.  Otherwise, it toggles European character display.

When this mode is enabled, characters in the range of 160 to 255
display not as octal escapes, but as accented characters.  Codes 146
and 160 display as apostrophe and space, even though they are not the
ASCII codes for apostrophe and space.

Enabling European character display with this command noninteractively
from Lisp code also selects Latin-1 as the language environment.
This provides increased compatibility for users who call this function
in `.emacs'.

(fn ARG)")
(autoload 'standard-display-by-replacement-char "disp-table" "\
Produce code to display characters between FROM and TO using REPL.
This function produces a buffer with code to set up `standard-display-table'
such that characters that cannot be displayed by the terminal, and
don't already have their display set up in `standard-display-table', will
be represented by a replacement character.  You can evaluate the produced
code to use the setup for the current Emacs session, or copy the code
into your init file, to make Emacs use it for subsequent sessions.

Interactively, the produced code arranges for any character in
the range [#x100..#x10FFFF] that the terminal cannot display to
be represented by the #xFFFD Unicode replacement character.

When called from Lisp, FROM and TO define the range of characters for
which to produce the setup code for `standard-display-table'.  If they
are omitted, they default to #x100 and #x10FFFF respectively, covering
the entire non-ASCII range of Unicode characters.
REPL is the replacement character to use.  If it's omitted, it defaults
to #xFFFD, the Unicode replacement character, usually displayed as a
black diamond with a question mark inside.
The produced code sets up `standard-display-table' to show REPL with
the `homoglyph' face, making the replacements stand out on display.

This command is most useful with text-mode terminals, such as the
Linux console, for which Emacs has a reliable way of determining
which characters can be displayed and which cannot.

(fn &optional REPL FROM TO)" t)
(register-definition-prefixes "disp-table" '("display-table-print-array"))


;;; Generated autoloads from display-fill-column-indicator.el

(autoload 'display-fill-column-indicator-mode "display-fill-column-indicator" "\
Toggle display of `fill-column' indicator.

This uses `display-fill-column-indicator' internally.

To change the position of the column displayed by default
customize `display-fill-column-indicator-column'.  You can change the
character for the indicator setting `display-fill-column-indicator-character'.
The globalized version is `global-display-fill-column-indicator-mode',
which see.
This minor mode assumes the buffer uses a fixed-pitch font; if you
use variable-pitch fonts, the indicators on different lines might
not appear aligned.
See Info node `Displaying Boundaries' for details.

This is a minor mode.  If called interactively, toggle the
`Display-Fill-Column-Indicator mode' mode.  If the prefix argument is
positive, enable the mode, and if it is zero or negative, disable the
mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `display-fill-column-indicator-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-display-fill-column-indicator-mode 'globalized-minor-mode t)
(defvar global-display-fill-column-indicator-mode nil "\
Non-nil if Global Display-Fill-Column-Indicator mode is enabled.
See the `global-display-fill-column-indicator-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-display-fill-column-indicator-mode'.")
(custom-autoload 'global-display-fill-column-indicator-mode "display-fill-column-indicator" nil)
(autoload 'global-display-fill-column-indicator-mode "display-fill-column-indicator" "\
Toggle Display-Fill-Column-Indicator mode in all buffers.
With prefix ARG, enable Global Display-Fill-Column-Indicator mode if
ARG is positive; otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Display-Fill-Column-Indicator mode is enabled in all buffers where
`display-fill-column-indicator--turn-on' would do it.

See `display-fill-column-indicator-mode' for more information on
Display-Fill-Column-Indicator mode.

`global-display-fill-column-indicator-modes' is used to control which
modes this minor mode is used in.

(fn &optional ARG)" t)
(defvar global-display-fill-column-indicator-modes '((not special-mode) t) "\
Which major modes `display-fill-column-indicator-mode' is switched on in.
This variable can be either t (all major modes), nil (no major modes),
or a list of modes and (not modes) to switch use this minor mode or
not.  For instance

  (c-mode (not message-mode mail-mode) text-mode)

means \"use this mode in all modes derived from `c-mode', don't use in
modes derived from `message-mode' or `mail-mode', but do use in other
modes derived from `text-mode'\".  An element with value t means \"use\"
and nil means \"don't use\".  There's an implicit nil at the end of the
list.")
(custom-autoload 'global-display-fill-column-indicator-modes "display-fill-column-indicator" t)
(register-definition-prefixes "display-fill-column-indicator" '("display-fill-column-indicator--turn-on"))


;;; Generated autoloads from display-line-numbers.el

(autoload 'display-line-numbers-mode "display-line-numbers" "\
Toggle display of line numbers in the buffer.

This uses `display-line-numbers' internally.

To change the type of line numbers displayed by default,
customize `display-line-numbers-type'.  To change the type while
the mode is on, set `display-line-numbers' directly.

This is a minor mode.  If called interactively, toggle the
`Display-Line-Numbers mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `display-line-numbers-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-display-line-numbers-mode 'globalized-minor-mode t)
(defvar global-display-line-numbers-mode nil "\
Non-nil if Global Display-Line-Numbers mode is enabled.
See the `global-display-line-numbers-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-display-line-numbers-mode'.")
(custom-autoload 'global-display-line-numbers-mode "display-line-numbers" nil)
(autoload 'global-display-line-numbers-mode "display-line-numbers" "\
Toggle Display-Line-Numbers mode in all buffers.
With prefix ARG, enable Global Display-Line-Numbers mode if ARG is
positive; otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Display-Line-Numbers mode is enabled in all buffers where
`display-line-numbers--turn-on' would do it.

See `display-line-numbers-mode' for more information on
Display-Line-Numbers mode.

(fn &optional ARG)" t)
(defvar header-line-indent "" "\
String of spaces to indent the beginning of header-line due to line numbers.
This is intended to be used in `header-line-format', and requires
the `header-line-indent-mode' to be turned on, in order for the width
of this string to be kept updated when the line-number width changes
on display.  An example of a `header-line-format' that uses this
variable might look like this:

  (\"\" header-line-indent THE-REST...)

where THE-REST is the format string which produces the actual text
of the header-line.
Also see `header-line-indent-width'.")
(defvar header-line-indent-width 0 "\
The width of the current line number display in the window.
This is measured in units of the frame's canonical columns.
This is updated when `header-line-indent-mode' is switched on,
and is intended for use in `:align-to' display specifications
that are part of `header-line-format', when portions of header-line
text should be aligned to respective parts of buffer text.
Also see `header-line-indent'.")
(autoload 'header-line-indent-mode "display-line-numbers" "\
Minor mode to help with alignment of header line when line numbers are shown.

This minor mode should be turned on in buffers which display header-line
that needs to be aligned with buffer text when `display-line-numbers-mode'
is turned on in the buffer.

Buffers that have this switched on should have a `header-line-format'
that uses the `header-line-indent' or the `header-line-indent-width'
variables, which this mode will keep up-to-date with the current
display of line numbers.  For example, a `header-line-format' that
looks like this:

  (\"\" header-line-indent THE-REST...)

will make sure the text produced by THE-REST (which should be
a header-line format string) is always indented to be aligned on
display with the first column of buffer text.

The `header-line-indent-width' variable is also kept updated,
and can be used, for instance, in `:align-to' specs as part
of `header-line-format', like this:

  (space :align-to (+ header-line-indent-width 10))

See also `line-number-display-width'.

This is a minor mode.  If called interactively, toggle the
`Header-Line-Indent mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `header-line-indent-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "display-line-numbers" '("display-line-numbers-" "header-line-indent--"))


;;; Generated autoloads from play/dissociate.el

(autoload 'dissociated-press "dissociate" "\
Dissociate the text of the current buffer.
Output goes in buffer named *Dissociation*,
which is redisplayed each time text is added to it.
Every so often the user must say whether to continue.
If ARG is positive, require ARG chars of continuity.
If ARG is negative, require -ARG words of continuity.
Default is 2.

(fn &optional ARG)" t)


;;; Generated autoloads from dnd.el

(defvar dnd-protocol-alist `((,(purecopy "^file:///") . dnd-open-local-file) (,(purecopy "^file://[^/]") . dnd-open-file) (,(purecopy "^file:/[^/]") . dnd-open-local-file) (,(purecopy "^file:[^/]") . dnd-open-local-file) (,(purecopy "^\\(https?\\|ftp\\|nfs\\)://") . dnd-open-file)) "\
The functions to call for different protocols when a drop is made.
This variable is used by `dnd-handle-multiple-urls'.
The list contains of (REGEXP . FUNCTION) pairs.
The functions shall take two arguments, URL, which is the URL dropped and
ACTION which is the action to be performed for the drop (move, copy, link,
private or ask).
If a function's `dnd-multiple-handler' property is set, it is provided
a list of each URI dropped instead.
If no match is found here, and the value of `browse-url-browser-function'
is a pair of (REGEXP . FUNCTION), those regexps are tried for a match.
If no match is found, the URL is inserted as text by calling `dnd-insert-text'.
The function shall return the action done (move, copy, link or private)
if some action was made, or nil if the URL is ignored.")
(custom-autoload 'dnd-protocol-alist "dnd" t)
(register-definition-prefixes "dnd" '("dnd-"))


;;; Generated autoloads from net/dns.el

(autoload 'dns-query "dns" "\
Query a DNS server for NAME of TYPE.
If FULL, return the entire record returned.
If REVERSE, look up an IP address.

(fn NAME &optional TYPE FULL REVERSE)")
(register-definition-prefixes "dns" '("dns-"))


;;; Generated autoloads from textmodes/dns-mode.el

(autoload 'dns-mode "dns-mode" "\
Major mode for viewing and editing DNS master files.
This mode is derived from text mode.  It adds syntax
highlighting, and some commands for handling DNS master files.
Its keymap inherits from `text-mode' and it has the same
variables for customizing indentation.  It has its own abbrev
table and its own syntax table.

Turning on DNS mode runs `dns-mode-hook'.

(fn)" t)
 (defalias 'zone-mode 'dns-mode)
(autoload 'dns-mode-soa-increment-serial "dns-mode" "\
Locate SOA record and increment the serial field." t)
(register-definition-prefixes "dns-mode" '("dns-mode-"))


;;; Generated autoloads from cedet/semantic/doc.el

(register-definition-prefixes "semantic/doc" '("semantic-doc"))


;;; Generated autoloads from doc-view.el

(autoload 'doc-view-mode-p "doc-view" "\
Return non-nil if document type TYPE is available for `doc-view'.
Document types are symbols like `dvi', `ps', `pdf', `epub',
`cbz', `fb2', `xps', `oxps', or`odf' (any OpenDocument format).

(fn TYPE)")
(autoload 'doc-view-mode "doc-view" "\
Major mode in DocView buffers.

DocView Mode is an Emacs document viewer.  It displays PDF, PS
and DVI files (as PNG or SVG images) in Emacs buffers.

You can use \\<doc-view-mode-map>\\[doc-view-toggle-display] to
toggle between displaying the document or editing it as text.
\\{doc-view-mode-map}" t)
(autoload 'doc-view-mode-maybe "doc-view" "\
Switch to `doc-view-mode' if possible.
If the required external tools are not available, then fallback
to the next best mode.")
(autoload 'doc-view-minor-mode "doc-view" "\
Toggle displaying buffer via Doc View (Doc View minor mode).

See the command `doc-view-mode' for more information on this mode.

This is a minor mode.  If called interactively, toggle the `Doc-View
minor mode' mode.  If the prefix argument is positive, enable the mode,
and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `doc-view-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'doc-view-bookmark-jump "doc-view" "\


(fn BMK)")
(register-definition-prefixes "doc-view" '("doc-view-"))


;;; Generated autoloads from progmodes/dockerfile-ts-mode.el

(autoload 'dockerfile-ts-mode "dockerfile-ts-mode" "\
Major mode for editing Dockerfiles, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "dockerfile-ts-mode" '("dockerfile-ts-mode--"))


;;; Generated autoloads from play/doctor.el

(autoload 'doctor "doctor" "\
Switch to *doctor* buffer and start giving psychotherapy." t)
(register-definition-prefixes "doctor" '("doc"))


;;; Generated autoloads from cedet/srecode/document.el

(register-definition-prefixes "srecode/document" '("srecode-document-"))


;;; Generated autoloads from dom.el

(register-definition-prefixes "dom" '("dom-"))


;;; Generated autoloads from dos-fns.el

(register-definition-prefixes "dos-fns" '("dos"))


;;; Generated autoloads from dos-vars.el

(register-definition-prefixes "dos-vars" '("dos-codepage-setup-hook" "msdos-shells"))


;;; Generated autoloads from dos-w32.el

(register-definition-prefixes "dos-w32" '("file-name-buffer-file-type-alist" "find-" "w32-"))


;;; Generated autoloads from double.el

(autoload 'double-mode "double" "\
Toggle special insertion on double keypresses (Double mode).

When Double mode is enabled, some keys will insert different
strings when pressed twice.  See `double-map' for details.

This is a minor mode.  If called interactively, toggle the `Double mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `double-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "double" '("double-"))


;;; Generated autoloads from play/dunnet.el

(autoload 'dunnet "dunnet" "\
Switch to *dungeon* buffer and start game." t)
(register-definition-prefixes "dunnet" '("dun" "obj-special"))


;;; Generated autoloads from dynamic-setting.el

(register-definition-prefixes "dynamic-setting" '("dynamic-setting-handle-config-changed-event" "font-setting-change-default-font"))


;;; Generated autoloads from emacs-lisp/easy-mmode.el

(autoload 'define-minor-mode "easy-mmode" "\
Define a new minor mode MODE.
This defines the toggle command MODE and (by default) a control variable
MODE (you can override this with the :variable keyword, see below).
DOC is the documentation for the mode toggle command.

The defined mode command takes one optional (prefix) argument.
Interactively with no prefix argument, it toggles the mode.
A prefix argument enables the mode if the argument is positive,
and disables it otherwise.

When called from Lisp, the mode command toggles the mode if the
argument is `toggle', disables the mode if the argument is a
non-positive integer, and enables the mode otherwise (including
if the argument is omitted or nil or a positive integer).

If DOC is nil, give the mode command a basic doc-string
documenting what its argument does.  If the word \"ARG\" does not
appear in DOC, a paragraph is added to DOC explaining
usage of the mode argument.

BODY contains code to execute each time the mode is enabled or disabled.
  It is executed after toggling the mode, and before running MODE-hook.
  Before the actual body code, you can write keyword arguments, i.e.
  alternating keywords and values.  If you provide BODY, then you must
  provide at least one keyword argument (e.g. `:lighter nil`).
  The following special keywords are supported (other keywords are passed
  to `defcustom' if the minor mode is global):

:global GLOBAL	If non-nil specifies that the minor mode is not meant to be
		buffer-local, so don't make the variable MODE buffer-local.
		By default, the mode is buffer-local.
:init-value VAL	the initial value of the mode's variable.
		Note that the minor mode function won't be called by setting
		this option, so the value *reflects* the minor mode's natural
		initial state, rather than *setting* it.
		In the vast majority of cases it should be nil.
		Not used if you also specify :variable.
:lighter SPEC	Text displayed in the mode line when the mode is on.
:keymap MAP	Keymap bound to the mode keymap.  Defaults to `MODE-map'.
                If non-nil, it should be an unquoted variable name (whose value
                is a keymap), or an expression that returns either a keymap or
		a list of (KEY . BINDING) pairs where KEY and BINDING are
		suitable for `define-key'.  If you supply a KEYMAP argument
		that is not a symbol, this macro defines the variable MODE-map
		and gives it the value that KEYMAP specifies.
:interactive VAL  Whether this mode should be a command or not.  The default
                is to make it one; use nil to avoid that.  If VAL is a list,
                it's interpreted as a list of major modes this minor mode
                is useful in.
:variable PLACE	The location to use instead of the variable MODE to store
		the state of the mode.	This can be simply a different
		named variable, or a generalized variable.
		PLACE can also be of the form (GET . SET), where GET is
		an expression that returns the current state, and SET is
		a function that takes one argument, the new state, which should
                be assigned to PLACE.  If you specify a :variable, this function
                does not define a MODE variable (nor any of the terms used
		in :variable).
:after-hook     A single Lisp form which is evaluated after the mode hooks
                have been run.  It should not be quoted.

For example, you could write
  (define-minor-mode foo-mode \"If enabled, foo on you!\"
    :lighter \" Foo\" :require \\='foo :global t :group \\='hassle :version \"27.5\"
    ...BODY CODE...)

For backward compatibility with the Emacs<21 calling convention,
the keywords can also be preceded by the obsolete triplet
INIT-VALUE LIGHTER KEYMAP.

(fn MODE DOC [KEYWORD VAL ... &rest BODY])" nil t)
(function-put 'define-minor-mode 'doc-string-elt 2)
(function-put 'define-minor-mode 'lisp-indent-function 'defun)
(defalias 'define-global-minor-mode #'define-globalized-minor-mode)
(autoload 'define-globalized-minor-mode "easy-mmode" "\
Make a global mode GLOBAL-MODE corresponding to buffer-local minor MODE.
TURN-ON is a function that will be called with no args in every buffer
and that should try to turn MODE on if applicable for that buffer.

Each of KEY VALUE is a pair of CL-style keyword arguments.
The :predicate key specifies in which major modes should the
globalized minor mode be switched on.  The value should be t (meaning
switch on the minor mode in all major modes), nil (meaning don't
switch on in any major mode), a list of modes (meaning switch on only
in those modes and their descendants), or a list (not MODES...),
meaning switch on in any major mode except MODES.  The value can also
mix all of these forms, see the info node `Defining Minor Modes' for
details.  The :predicate key causes the macro to create a user option
named the same as MODE, but ending with \"-modes\" instead of \"-mode\".
That user option can then be used to customize in which modes this
globalized minor mode will be switched on.
As the minor mode defined by this function is always global, any
:global keyword is ignored.
Other keywords have the same meaning as in `define-minor-mode',
which see.  In particular, :group specifies the custom group.
The most useful keywords are those that are passed on to the `defcustom'.
It normally makes no sense to pass the :lighter or :keymap keywords
to `define-globalized-minor-mode', since these are usually passed to
the buffer-local version of the minor mode.

BODY contains code to execute each time the mode is enabled or disabled.
It is executed after toggling the mode, and before running
GLOBAL-MODE-hook.

If MODE's set-up depends on the major mode in effect when it was
enabled, then disabling and reenabling MODE should make MODE work
correctly with the current major mode.  This is important to
prevent problems with derived modes, that is, major modes that
call another major mode in their body.

When a major mode is initialized, MODE is actually turned on just
after running the major mode's hook.  However, MODE is not turned
on if the hook has explicitly disabled it.

(fn GLOBAL-MODE MODE TURN-ON [KEY VALUE]... BODY...)" nil t)
(function-put 'define-globalized-minor-mode 'doc-string-elt 2)
(function-put 'define-globalized-minor-mode 'lisp-indent-function 'defun)
(autoload 'easy-mmode-define-keymap "easy-mmode" "\
Return a keymap built from bindings BS.
BS must be a list of (KEY . BINDING) where
KEY and BINDINGS are suitable for `define-key'.
Optional NAME is passed to `make-sparse-keymap'.
Optional map M can be used to modify an existing map.
ARGS is a list of additional keyword arguments.

Valid keywords and arguments are:

  :name      Name of the keymap; overrides NAME argument.
  :dense     Non-nil for a dense keymap.
  :inherit   Parent keymap.
  :group     Ignored.
  :suppress  Non-nil to call `suppress-keymap' on keymap,
             `nodigits' to suppress digits as prefix arguments.

(fn BS &optional NAME M ARGS)")
(make-obsolete 'easy-mmode-define-keymap 'define-keymap "29.1")
(autoload 'easy-mmode-defmap "easy-mmode" "\
Define a constant M whose value is the result of `easy-mmode-define-keymap'.
The M, BS, and ARGS arguments are as per that function.  DOC is
the constant's documentation.

This macro is deprecated; use `defvar-keymap' instead.

(fn M BS DOC &rest ARGS)" nil t)
(function-put 'easy-mmode-defmap 'doc-string-elt 3)
(function-put 'easy-mmode-defmap 'lisp-indent-function 1)
(make-obsolete 'easy-mmode-defmap 'defvar-keymap "29.1")
(autoload 'easy-mmode-defsyntax "easy-mmode" "\
Define variable ST as a syntax-table.
CSS contains a list of syntax specifications of the form (CHAR . SYNTAX).

(fn ST CSS DOC &rest ARGS)" nil t)
(function-put 'easy-mmode-defsyntax 'doc-string-elt 3)
(function-put 'easy-mmode-defsyntax 'lisp-indent-function 1)
(define-obsolete-function-alias 'easy-mmode-define-minor-mode #'define-minor-mode "30.1")
(define-obsolete-function-alias 'easy-mmode-define-global-mode #'define-globalized-minor-mode "30.1")
(register-definition-prefixes "easy-mmode" '("easy-mmode-"))


;;; Generated autoloads from progmodes/ebnf-abn.el

(register-definition-prefixes "ebnf-abn" '("ebnf-abn-"))


;;; Generated autoloads from progmodes/ebnf-bnf.el

(register-definition-prefixes "ebnf-bnf" '("ebnf-"))


;;; Generated autoloads from progmodes/ebnf-dtd.el

(register-definition-prefixes "ebnf-dtd" '("ebnf-dtd-"))


;;; Generated autoloads from progmodes/ebnf-ebx.el

(register-definition-prefixes "ebnf-ebx" '("ebnf-ebx-"))


;;; Generated autoloads from progmodes/ebnf-iso.el

(register-definition-prefixes "ebnf-iso" '("ebnf-"))


;;; Generated autoloads from progmodes/ebnf-otz.el

(register-definition-prefixes "ebnf-otz" '("ebnf-"))


;;; Generated autoloads from progmodes/ebnf-yac.el

(register-definition-prefixes "ebnf-yac" '("ebnf-yac-"))


;;; Generated autoloads from progmodes/ebnf2ps.el

(autoload 'ebnf-customize "ebnf2ps" "\
Customization for ebnf group." t)
(autoload 'ebnf-print-directory "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-print-buffer'.

(fn &optional DIRECTORY)" t)
(autoload 'ebnf-print-file "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after process termination.

See also `ebnf-print-buffer'.

(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t)
(autoload 'ebnf-print-buffer "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the buffer.

When called with a numeric prefix argument (\\[universal-argument]), prompts the user for
the name of a file to save the PostScript image in, instead of sending
it to the printer.

More specifically, the FILENAME argument is treated as follows: if it
is nil, send the image to the printer.  If FILENAME is a string, save
the PostScript image in a file with that name.  If FILENAME is a
number, prompt the user for the name of the file to save in.

(fn &optional FILENAME)" t)
(autoload 'ebnf-print-region "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the region.
Like `ebnf-print-buffer', but prints just the current region.

(fn FROM TO &optional FILENAME)" t)
(autoload 'ebnf-spool-directory "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-spool-buffer'.

(fn &optional DIRECTORY)" t)
(autoload 'ebnf-spool-file "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of the file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after process termination.

See also `ebnf-spool-buffer'.

(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t)
(autoload 'ebnf-spool-buffer "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of the buffer.
Like `ebnf-print-buffer' except that the PostScript image is saved in a
local buffer to be sent to the printer later.

Use the command `ebnf-despool' to send the spooled images to the printer." t)
(autoload 'ebnf-spool-region "ebnf2ps" "\
Generate a PostScript syntactic chart image of the region and spool locally.
Like `ebnf-spool-buffer', but spools just the current region.

Use the command `ebnf-despool' to send the spooled images to the printer.

(fn FROM TO)" t)
(autoload 'ebnf-eps-directory "ebnf2ps" "\
Generate EPS files from EBNF files in DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-eps-buffer'.

(fn &optional DIRECTORY)" t)
(autoload 'ebnf-eps-file "ebnf2ps" "\
Generate an EPS file from EBNF file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after EPS generation.

See also `ebnf-eps-buffer'.

(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t)
(autoload 'ebnf-eps-buffer "ebnf2ps" "\
Generate a PostScript syntactic chart image of the buffer in an EPS file.

Generate an EPS file for each production in the buffer.
The EPS file name has the following form:

   <PREFIX><PRODUCTION>.eps

<PREFIX>     is given by variable `ebnf-eps-prefix'.
	     The default value is \"ebnf--\".

<PRODUCTION> is the production name.
	     Some characters in the production file name are replaced to
	     produce a valid file name.  For example, the production name
	     \"A/B + C\" is modified to produce \"A_B_+_C\", and the EPS
	     file name used in this case will be \"ebnf--A_B_+_C.eps\".

WARNING: This function does *NOT* ask any confirmation to override existing
	 files." t)
(autoload 'ebnf-eps-region "ebnf2ps" "\
Generate a PostScript syntactic chart image of the region in an EPS file.

Generate an EPS file for each production in the region.
The EPS file name has the following form:

   <PREFIX><PRODUCTION>.eps

<PREFIX>     is given by variable `ebnf-eps-prefix'.
	     The default value is \"ebnf--\".

<PRODUCTION> is the production name.
	     Some characters in the production file name are replaced to
	     produce a valid file name.  For example, the production name
	     \"A/B + C\" is modified to produce \"A_B_+_C\", and the EPS
	     file name used in this case will be \"ebnf--A_B_+_C.eps\".

WARNING: This function does *NOT* ask any confirmation to override existing
	 files.

(fn FROM TO)" t)
(defalias 'ebnf-despool #'ps-despool)
(autoload 'ebnf-syntax-directory "ebnf2ps" "\
Do a syntactic analysis of the files in DIRECTORY.

If DIRECTORY is nil, use `default-directory'.

Only the files in DIRECTORY that match `ebnf-file-suffix-regexp' (which see)
are processed.

See also `ebnf-syntax-buffer'.

(fn &optional DIRECTORY)" t)
(autoload 'ebnf-syntax-file "ebnf2ps" "\
Do a syntactic analysis of the named FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after syntax checking.

See also `ebnf-syntax-buffer'.

(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t)
(autoload 'ebnf-syntax-buffer "ebnf2ps" "\
Do a syntactic analysis of the current buffer." t)
(autoload 'ebnf-syntax-region "ebnf2ps" "\
Do a syntactic analysis of a region.

(fn FROM TO)" t)
(autoload 'ebnf-setup "ebnf2ps" "\
Return the current ebnf2ps setup.")
(autoload 'ebnf-find-style "ebnf2ps" "\
Return style definition if NAME is already defined; otherwise, return nil.

See `ebnf-style-database' documentation.

(fn NAME)" t)
(autoload 'ebnf-insert-style "ebnf2ps" "\
Insert a new style NAME with inheritance INHERITS and values VALUES.

See `ebnf-style-database' documentation.

(fn NAME INHERITS &rest VALUES)" t)
(autoload 'ebnf-delete-style "ebnf2ps" "\
Delete style NAME.

See `ebnf-style-database' documentation.

(fn NAME)" t)
(autoload 'ebnf-merge-style "ebnf2ps" "\
Merge values of style NAME with style VALUES.

See `ebnf-style-database' documentation.

(fn NAME &rest VALUES)" t)
(autoload 'ebnf-apply-style "ebnf2ps" "\
Set STYLE as the current style.

Returns the old style symbol.

See `ebnf-style-database' documentation.

(fn STYLE)" t)
(autoload 'ebnf-reset-style "ebnf2ps" "\
Reset current style.

Returns the old style symbol.

See `ebnf-style-database' documentation.

(fn &optional STYLE)" t)
(autoload 'ebnf-push-style "ebnf2ps" "\
Push the current style onto a stack and set STYLE as the current style.

Returns the old style symbol.

See also `ebnf-pop-style'.

See `ebnf-style-database' documentation.

(fn &optional STYLE)" t)
(autoload 'ebnf-pop-style "ebnf2ps" "\
Pop a style from the stack of pushed styles and set it as the current style.

Returns the old style symbol.

See also `ebnf-push-style'.

See `ebnf-style-database' documentation." t)
(register-definition-prefixes "ebnf2ps" '("ebnf-"))


;;; Generated autoloads from progmodes/ebrowse.el

(autoload 'ebrowse-tree-mode "ebrowse" "\
Major mode for Ebrowse class tree buffers.
Each line corresponds to a class in a class tree.
Letters do not insert themselves, they are commands.
File operations in the tree buffer work on class tree data structures.
E.g. \\[save-buffer] writes the tree to the file it was loaded from.

Tree mode key bindings:
\\{ebrowse-tree-mode-map}

(fn)" t)
(autoload 'ebrowse-electric-choose-tree "ebrowse" "\
Return a buffer containing a tree or nil if no tree found or canceled." t)
(autoload 'ebrowse-member-mode "ebrowse" "\
Major mode for Ebrowse member buffers.

(fn)" t)
(autoload 'ebrowse-tags-view-declaration "ebrowse" "\
View declaration of member at point." t)
(autoload 'ebrowse-tags-find-declaration "ebrowse" "\
Find declaration of member at point." t)
(autoload 'ebrowse-tags-view-definition "ebrowse" "\
View definition of member at point." t)
(autoload 'ebrowse-tags-find-definition "ebrowse" "\
Find definition of member at point." t)
(autoload 'ebrowse-tags-find-declaration-other-window "ebrowse" "\
Find declaration of member at point in other window." t)
(autoload 'ebrowse-tags-view-definition-other-window "ebrowse" "\
View definition of member at point in other window." t)
(autoload 'ebrowse-tags-find-definition-other-window "ebrowse" "\
Find definition of member at point in other window." t)
(autoload 'ebrowse-tags-find-declaration-other-frame "ebrowse" "\
Find definition of member at point in other frame." t)
(autoload 'ebrowse-tags-view-definition-other-frame "ebrowse" "\
View definition of member at point in other frame." t)
(autoload 'ebrowse-tags-find-definition-other-frame "ebrowse" "\
Find definition of member at point in other frame." t)
(autoload 'ebrowse-tags-complete-symbol "ebrowse" "\
Perform completion on the C++ symbol preceding point.
A second call of this function without changing point inserts the next match.
A call with prefix PREFIX reads the symbol to insert from the minibuffer with
completion.

(fn PREFIX)" t)
(autoload 'ebrowse-tags-loop-continue "ebrowse" "\
Repeat last operation on files in tree.
FIRST-TIME non-nil means this is not a repetition, but the first time.
TREE-BUFFER if indirectly specifies which files to loop over.

(fn &optional FIRST-TIME TREE-BUFFER)" t)
(autoload 'ebrowse-tags-search "ebrowse" "\
Search for REGEXP in all files in a tree.
If marked classes exist, process marked classes, only.
If regular expression is nil, repeat last search.

(fn REGEXP)" t)
(autoload 'ebrowse-tags-query-replace "ebrowse" "\
Query replace FROM with TO in all files of a class tree.
With prefix arg, process files of marked classes only.

As each match is found, the user must type a character saying
what to do with it.  Type SPC or `y' to replace the match,
DEL or `n' to skip and go to the next match.  For more directions,
type \\[help-command] at that time.

(fn FROM TO)" t)
(autoload 'ebrowse-tags-search-member-use "ebrowse" "\
Search for call sites of a member.
If FIX-NAME is specified, search uses of that member.
Otherwise, read a member name from the minibuffer.
Searches in all files mentioned in a class tree for something that
looks like a function call to the member.

(fn &optional FIX-NAME)" t)
(autoload 'ebrowse-back-in-position-stack "ebrowse" "\
Move backward in the position stack.
Prefix arg ARG says how much.

(fn ARG)" t)
(autoload 'ebrowse-forward-in-position-stack "ebrowse" "\
Move forward in the position stack.
Prefix arg ARG says how much.

(fn ARG)" t)
(autoload 'ebrowse-electric-position-menu "ebrowse" "\
List positions in the position stack in an electric buffer." t)
(autoload 'ebrowse-save-tree "ebrowse" "\
Save current tree in same file it was loaded from." t)
(autoload 'ebrowse-save-tree-as "ebrowse" "\
Write the current tree data structure to a file.
Read the file name from the minibuffer if interactive.
Otherwise, FILE-NAME specifies the file to save the tree in.

(fn &optional FILE-NAME)" t)
(autoload 'ebrowse-statistics "ebrowse" "\
Display statistics for a class tree." t)
(register-definition-prefixes "ebrowse" '("ebrowse-" "electric-buffer-menu-mode-hook"))


;;; Generated autoloads from ebuff-menu.el

(autoload 'electric-buffer-list "ebuff-menu" "\
Pop up the Buffer Menu in an \"electric\" window.
If you type SPC or RET (`Electric-buffer-menu-select'), that
selects the buffer at point and quits the \"electric\" window.
Otherwise, you can move around in the Buffer Menu, marking
buffers to be selected, saved or deleted; these other commands
are much like those of `Buffer-menu-mode'.

Run hooks in `electric-buffer-menu-mode-hook' on entry.

\\<electric-buffer-menu-mode-map>
\\[keyboard-quit] or \\[Electric-buffer-menu-quit] -- exit buffer menu, returning to previous window and buffer
  configuration.  If the very first character typed is a space, it
  also has this effect.
\\[Electric-buffer-menu-select] -- select buffer of line point is on.
  Also show buffers marked with m in other windows,
  deletes buffers marked with \"D\", and saves those marked with \"S\".
\\[Buffer-menu-mark] -- mark buffer to be displayed.
\\[Buffer-menu-not-modified] -- clear modified-flag on that buffer.
\\[Buffer-menu-save] -- mark that buffer to be saved.
\\[Buffer-menu-delete] or \\[Buffer-menu-delete-backwards] -- mark that buffer to be deleted.
\\[Buffer-menu-unmark] -- remove all kinds of marks from current line.
\\[Buffer-menu-unmark-all] -- remove all kinds of marks from all lines.
\\[Electric-buffer-menu-mode-view-buffer] -- view buffer, returning when done.
\\[Buffer-menu-backup-unmark] -- back up a line and remove marks.

(fn ARG)" t)
(register-definition-prefixes "ebuff-menu" '("Electric-buffer-menu-" "electric-buffer-"))


;;; Generated autoloads from echistory.el

(autoload 'Electric-command-history-redo-expression "echistory" "\
Edit current history line in minibuffer and execute result.
With prefix arg NOCONFIRM, execute current line as-is without editing.

(fn &optional NOCONFIRM)" t)
(register-definition-prefixes "echistory" '("Electric-history-" "electric-"))


;;; Generated autoloads from ecomplete.el

(autoload 'ecomplete-setup "ecomplete" "\
Read the .ecompleterc file.")
(register-definition-prefixes "ecomplete" '("ecomplete-"))


;;; Generated autoloads from cedet/ede.el

(push (purecopy '(ede 2 0)) package--builtin-versions)
(defvar global-ede-mode nil "\
Non-nil if Global Ede mode is enabled.
See the `global-ede-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-ede-mode'.")
(custom-autoload 'global-ede-mode "ede" nil)
(autoload 'global-ede-mode "ede" "\
Toggle global EDE (Emacs Development Environment) mode.

This global minor mode enables `ede-minor-mode' in all buffers in
an EDE controlled project.

This is a global minor mode.  If called interactively, toggle the
`Global Ede mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='global-ede-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "ede" '("ede" "global-ede-mode-map" "project-try-ede"))


;;; Generated autoloads from cedet/semantic/ede-grammar.el

(register-definition-prefixes "semantic/ede-grammar" '("semantic-ede-"))


;;; Generated autoloads from emacs-lisp/edebug.el

(defvar edebug-all-defs nil "\
If non-nil, evaluating defining forms instruments for Edebug.
This applies to `eval-defun', `eval-region' and `eval-buffer'.
`eval-region' is also called by `eval-last-sexp', and
`eval-print-last-sexp'.

You can use the command `edebug-all-defs' to toggle the value of this
variable.  You may wish to make it local to each buffer with
(make-local-variable \\='edebug-all-defs) in your
`emacs-lisp-mode-hook'.

Note that this user option has no effect unless the edebug
package has been loaded.")
(custom-autoload 'edebug-all-defs "edebug" t)
(defvar edebug-all-forms nil "\
Non-nil means evaluation of all forms will instrument for Edebug.
This doesn't apply to loading or evaluations in the minibuffer.
Use the command `edebug-all-forms' to toggle the value of this option.")
(custom-autoload 'edebug-all-forms "edebug" t)
(autoload 'edebug-basic-spec "edebug" "\
Return t if SPEC uses only extant spec symbols.
An extant spec symbol is a symbol that is not a function and has a
`edebug-form-spec' property.

(fn SPEC)")
(defalias 'edebug-defun #'edebug-eval-top-level-form)
(autoload 'edebug-eval-top-level-form "edebug" "\
Evaluate the top level form point is in, stepping through with Edebug.
This is like `eval-defun' except that it steps the code for Edebug
before evaluating it.  It displays the value in the echo area
using `eval-expression' (which see).

If you do this on a function definition such as a defun or defmacro,
it defines the function and instruments its definition for Edebug,
so it will do Edebug stepping when called later.  It displays
`Edebug: FUNCTION' in the echo area to indicate that FUNCTION is now
instrumented for Edebug.

If the current defun is actually a call to `defvar' or `defcustom',
evaluating it this way resets the variable using its initial value
expression even if the variable already has some other value.
(Normally `defvar' and `defcustom' do not alter the value if there
already is one.)" t)
(autoload 'edebug-all-defs "edebug" "\
Toggle edebugging of all definitions." t)
(autoload 'edebug-all-forms "edebug" "\
Toggle edebugging of all forms." t)
(register-definition-prefixes "edebug" '("edebug"))


;;; Generated autoloads from vc/ediff.el

(push (purecopy '(ediff 2 81 6)) package--builtin-versions)
(autoload 'ediff-files "ediff" "\
Run Ediff on a pair of files, FILE-A and FILE-B.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn FILE-A FILE-B &optional STARTUP-HOOKS)" t)
(autoload 'ediff-files3 "ediff" "\
Run Ediff on three files, FILE-A, FILE-B, and FILE-C.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn FILE-A FILE-B FILE-C &optional STARTUP-HOOKS)" t)
(defalias 'ediff3 #'ediff-files3)
(defalias 'ediff #'ediff-files)
(autoload 'ediff-current-file "ediff" "\
Start ediff between current buffer and its file on disk.
This command can be used instead of `revert-buffer'.  If there is
nothing to revert then this command fails." t)
(autoload 'ediff-backup "ediff" "\
Run Ediff on FILE and its backup file.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, `ediff' it with its original.

(fn FILE)" t)
(autoload 'ediff-buffers "ediff" "\
Run Ediff on a pair of buffers, BUFFER-A and BUFFER-B.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.  JOB-NAME is a
symbol describing the Ediff job type; it defaults to
`ediff-buffers', but can also be one of
`ediff-merge-files-with-ancestor', `ediff-last-dir-ancestor',
`ediff-last-dir-C', `ediff-buffers3', `ediff-merge-buffers', or
`ediff-merge-buffers-with-ancestor'.

(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS JOB-NAME)" t)
(defalias 'ebuffers #'ediff-buffers)
(autoload 'ediff-buffers3 "ediff" "\
Run Ediff on three buffers, BUFFER-A, BUFFER-B, and BUFFER-C.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.  JOB-NAME is a
symbol describing the Ediff job type; it defaults to
`ediff-buffers3', but can also be one of
`ediff-merge-files-with-ancestor', `ediff-last-dir-ancestor',
`ediff-last-dir-C', `ediff-buffers', `ediff-merge-buffers', or
`ediff-merge-buffers-with-ancestor'.

(fn BUFFER-A BUFFER-B BUFFER-C &optional STARTUP-HOOKS JOB-NAME)" t)
(defalias 'ebuffers3 #'ediff-buffers3)
(autoload 'ediff-directories "ediff" "\
Run Ediff on directories DIR1 and DIR2, comparing files.
Consider only files that have the same name in both directories.

REGEXP is nil or a regular expression; only file names that match
the regexp are considered.

(fn DIR1 DIR2 REGEXP)" t)
(defalias 'edirs #'ediff-directories)
(autoload 'ediff-directory-revisions "ediff" "\
Run Ediff on a directory, DIR1, comparing its files with their revisions.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.

(fn DIR1 REGEXP)" t)
(defalias 'edir-revisions #'ediff-directory-revisions)
(autoload 'ediff-directories3 "ediff" "\
Run Ediff on directories DIR1, DIR2, and DIR3, comparing files.
Consider only files that have the same name in all three directories.

REGEXP is nil or a regular expression; only file names that match
the regexp are considered.

(fn DIR1 DIR2 DIR3 REGEXP)" t)
(defalias 'edirs3 #'ediff-directories3)
(autoload 'ediff-merge-directories "ediff" "\
Run Ediff on a pair of directories, DIR1 and DIR2, merging files that have
the same name in both.  The third argument, REGEXP, is nil or a regular
expression; only file names that match the regexp are considered.
MERGE-AUTOSTORE-DIR is the directory in which to store merged files.

(fn DIR1 DIR2 REGEXP &optional MERGE-AUTOSTORE-DIR)" t)
(defalias 'edirs-merge #'ediff-merge-directories)
(autoload 'ediff-merge-directories-with-ancestor "ediff" "\
Merge files in DIR1 and DIR2 using files in ANCESTOR-DIR as ancestors.
Ediff merges files that have identical names in DIR1, DIR2.  If a pair of files
in DIR1 and DIR2 doesn't have an ancestor in ANCESTOR-DIR, Ediff will merge
without ancestor.  The fourth argument, REGEXP, is nil or a regular expression;
only file names that match the regexp are considered.
MERGE-AUTOSTORE-DIR is the directory in which to store merged files.

(fn DIR1 DIR2 ANCESTOR-DIR REGEXP &optional MERGE-AUTOSTORE-DIR)" t)
(autoload 'ediff-merge-directory-revisions "ediff" "\
Run Ediff on a directory, DIR1, merging its files with their revisions.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.
MERGE-AUTOSTORE-DIR is the directory in which to store merged files.

(fn DIR1 REGEXP &optional MERGE-AUTOSTORE-DIR)" t)
(defalias 'edir-merge-revisions #'ediff-merge-directory-revisions)
(autoload 'ediff-merge-directory-revisions-with-ancestor "ediff" "\
Run Ediff on DIR1 and merge its files with their revisions and ancestors.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.
MERGE-AUTOSTORE-DIR is the directory in which to store merged files.

(fn DIR1 REGEXP &optional MERGE-AUTOSTORE-DIR)" t)
(defalias 'edir-merge-revisions-with-ancestor 'ediff-merge-directory-revisions-with-ancestor)
(defalias 'edirs-merge-with-ancestor 'ediff-merge-directories-with-ancestor)
(autoload 'ediff-windows-wordwise "ediff" "\
Compare WIND-A and WIND-B, which are selected by clicking, wordwise.
This compares the portions of text visible in each of the two windows.
With prefix argument, DUMB-MODE, or on a non-graphical display, works as
follows:
If WIND-A is nil, use selected window.
If WIND-B is nil, use window next to WIND-A.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn DUMB-MODE &optional WIND-A WIND-B STARTUP-HOOKS)" t)
(autoload 'ediff-windows-linewise "ediff" "\
Compare WIND-A and WIND-B, which are selected by clicking, linewise.
This compares the portions of text visible in each of the two windows.
With prefix argument, DUMB-MODE, or on a non-graphical display, works as
follows:
If WIND-A is nil, use selected window.
If WIND-B is nil, use window next to WIND-A.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn DUMB-MODE &optional WIND-A WIND-B STARTUP-HOOKS)" t)
(autoload 'ediff-regions-wordwise "ediff" "\
Run Ediff on a pair of regions in specified buffers.
BUFFER-A and BUFFER-B are the buffers to be compared.
Regions (i.e., point and mark) can be set in advance or marked interactively.
This function might be slow for large regions.  If you find it slow,
use `ediff-regions-linewise' instead.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS)" t)
(autoload 'ediff-regions-linewise "ediff" "\
Run Ediff on a pair of regions in specified buffers.
BUFFER-A and BUFFER-B are the buffers to be compared.
Regions (i.e., point and mark) can be set in advance or marked interactively.
Each region is enlarged to contain full lines.
This function is effective for large regions, over 100-200
lines.  For small regions, use `ediff-regions-wordwise'.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS)" t)
(defalias 'ediff-merge 'ediff-merge-files)
(autoload 'ediff-merge-files "ediff" "\
Merge two files without ancestor.
FILE-A and FILE-B are the names of the files to be merged.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.  MERGE-BUFFER-FILE
is the name of the file to be associated with the merge buffer..

(fn FILE-A FILE-B &optional STARTUP-HOOKS MERGE-BUFFER-FILE)" t)
(autoload 'ediff-merge-files-with-ancestor "ediff" "\
Merge two files with ancestor.
FILE-A and FILE-B are the names of the files to be merged, and
FILE-ANCESTOR is the name of the ancestor file.  STARTUP-HOOKS is
a list of functions that Emacs calls without arguments after
setting up the Ediff buffers.  MERGE-BUFFER-FILE is the name of
the file to be associated with the merge buffer.

(fn FILE-A FILE-B FILE-ANCESTOR &optional STARTUP-HOOKS MERGE-BUFFER-FILE)" t)
(defalias 'ediff-merge-with-ancestor 'ediff-merge-files-with-ancestor)
(autoload 'ediff-merge-buffers "ediff" "\
Merge buffers without ancestor.
BUFFER-A and BUFFER-B are the buffers to be merged.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.  JOB-NAME is a
symbol describing the Ediff job type; it defaults to
`ediff-merge-buffers', but can also be one of
`ediff-merge-files-with-ancestor', `ediff-last-dir-ancestor',
`ediff-last-dir-C', `ediff-buffers', `ediff-buffers3', or
`ediff-merge-buffers-with-ancestor'.  MERGE-BUFFER-FILE is the
name of the file to be associated with the merge buffer.

(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS JOB-NAME MERGE-BUFFER-FILE)" t)
(autoload 'ediff-merge-buffers-with-ancestor "ediff" "\
Merge buffers with ancestor.
BUFFER-A and BUFFER-B are the buffers to be merged, and
BUFFER-ANCESTOR is their ancestor.  STARTUP-HOOKS is a list of
functions that Emacs calls without arguments after setting up the
Ediff buffers.  JOB-NAME is a symbol describing the Ediff job
type; it defaults to `ediff-merge-buffers-with-ancestor', but can
also be one of `ediff-merge-files-with-ancestor',
`ediff-last-dir-ancestor', `ediff-last-dir-C', `ediff-buffers',
`ediff-buffers3', or `ediff-merge-buffers'.  MERGE-BUFFER-FILE is
the name of the file to be associated with the merge buffer.

(fn BUFFER-A BUFFER-B BUFFER-ANCESTOR &optional STARTUP-HOOKS JOB-NAME MERGE-BUFFER-FILE)" t)
(autoload 'ediff-merge-revisions "ediff" "\
Run Ediff by merging two revisions of a file.
The file is the optional FILE argument or the file visited by the
current buffer.  STARTUP-HOOKS is a list of functions that Emacs
calls without arguments after setting up the Ediff buffers.
MERGE-BUFFER-FILE is the name of the file to be associated with
the merge buffer.

(fn &optional FILE STARTUP-HOOKS MERGE-BUFFER-FILE)" t)
(autoload 'ediff-merge-revisions-with-ancestor "ediff" "\
Run Ediff by merging two revisions of a file with a common ancestor.
The file is the optional FILE argument or the file visited by the
current buffer.  STARTUP-HOOKS is a list of functions that Emacs
calls without arguments after setting up the Ediff buffers.
MERGE-BUFFER-FILE is the name of the file to be associated with
the merge buffer.

(fn &optional FILE STARTUP-HOOKS MERGE-BUFFER-FILE)" t)
(autoload 'ediff-patch-file "ediff" "\
Query for a file name, and then run Ediff by patching that file.
If optional PATCH-BUF is given, use the patch in that buffer
and don't ask the user.
If prefix argument ARG, then: if even argument, assume that the
patch is in a buffer.  If odd -- assume it is in a file.

(fn &optional ARG PATCH-BUF)" t)
(autoload 'ediff-patch-buffer "ediff" "\
Run Ediff by patching the buffer specified at prompt.
Without the optional prefix ARG, asks if the patch is in some buffer and
prompts for the buffer or a file, depending on the answer.
With ARG=1, assumes the patch is in a file and prompts for the file.
With ARG=2, assumes the patch is in a buffer and prompts for the buffer.
PATCH-BUF is an optional argument, which specifies the buffer that contains the
patch.  If not given, the user is prompted according to the prefix argument.

(fn &optional ARG PATCH-BUF)" t)
(defalias 'epatch 'ediff-patch-file)
(defalias 'epatch-buffer 'ediff-patch-buffer)
(autoload 'ediff-revision "ediff" "\
Run Ediff by comparing versions of a file.
The file is an optional FILE argument or the file entered at the prompt.
Default: the file visited by the current buffer.
Uses `vc.el' or `rcs.el' depending on `ediff-version-control-package'.
STARTUP-HOOKS is a list of functions that Emacs calls without
arguments after setting up the Ediff buffers.

(fn &optional FILE STARTUP-HOOKS)" t)
(defalias 'erevision 'ediff-revision)
(autoload 'ediff-version "ediff" "\
Return string describing the version of Ediff.
When called interactively, displays the version." t)
(autoload 'ediff-documentation "ediff" "\
Display Ediff's manual.
With optional NODE, goes to that node.

(fn &optional NODE)" t)
(autoload 'ediff-files-command "ediff" "\
Call `ediff-files' with the next two command line arguments.")
(autoload 'ediff3-files-command "ediff" "\
Call `ediff3-files' with the next three command line arguments.")
(autoload 'ediff-merge-command "ediff" "\
Call `ediff-merge-files' with the next two command line arguments.")
(autoload 'ediff-merge-with-ancestor-command "ediff" "\
Call `ediff-merge-files-with-ancestor' with next three command line arguments.")
(autoload 'ediff-directories-command "ediff" "\
Call `ediff-directories' with the next three command line arguments.")
(autoload 'ediff-directories3-command "ediff" "\
Call `ediff-directories3' with the next four command line arguments.")
(autoload 'ediff-merge-directories-command "ediff" "\
Call `ediff-merge-directories' with the next three command line arguments.")
(autoload 'ediff-merge-directories-with-ancestor-command "ediff" "\
Call `ediff-merge-directories-with-ancestor' with the next four command line
arguments.")
(register-definition-prefixes "ediff" '("ediff-"))


;;; Generated autoloads from vc/ediff-diff.el

(register-definition-prefixes "ediff-diff" '("ediff-"))


;;; Generated autoloads from vc/ediff-help.el

(autoload 'ediff-customize "ediff-help" nil t)
(register-definition-prefixes "ediff-help" '("ediff-"))


;;; Generated autoloads from vc/ediff-init.el

(register-definition-prefixes "ediff-init" '("ediff-" "stipple-pixmap"))


;;; Generated autoloads from vc/ediff-merg.el

(register-definition-prefixes "ediff-merg" '("ediff-"))


;;; Generated autoloads from vc/ediff-mult.el

(autoload 'ediff-show-registry "ediff-mult" "\
Display Ediff's registry." t)
(defalias 'eregistry #'ediff-show-registry)
(register-definition-prefixes "ediff-mult" '("ediff-"))


;;; Generated autoloads from vc/ediff-ptch.el

(register-definition-prefixes "ediff-ptch" '("ediff-"))


;;; Generated autoloads from vc/ediff-util.el

(autoload 'ediff-toggle-multiframe "ediff-util" "\
Switch from multiframe display to single-frame display and back.
To change the default, set the variable `ediff-window-setup-function',
which see." t)
(autoload 'ediff-toggle-use-toolbar "ediff-util" "\
Enable or disable Ediff toolbar.
Works only in versions of Emacs that support toolbars.
To change the default, set the variable `ediff-use-toolbar-p', which see." t)
(register-definition-prefixes "ediff-util" '("ediff-"))


;;; Generated autoloads from vc/ediff-vers.el

(register-definition-prefixes "ediff-vers" '("ediff-" "rcs-ediff-view-revision"))


;;; Generated autoloads from vc/ediff-wind.el

(register-definition-prefixes "ediff-wind" '("ediff-"))


;;; Generated autoloads from cedet/semantic/edit.el

(register-definition-prefixes "semantic/edit" '("semantic-"))


;;; Generated autoloads from editorconfig.el

(push (purecopy '(editorconfig 0 11 0)) package--builtin-versions)
(defvar editorconfig-mode nil "\
Non-nil if Editorconfig mode is enabled.
See the `editorconfig-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `editorconfig-mode'.")
(custom-autoload 'editorconfig-mode "editorconfig" nil)
(autoload 'editorconfig-mode "editorconfig" "\
Toggle EditorConfig feature.

This is a global minor mode.  If called interactively, toggle the
`Editorconfig mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='editorconfig-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "editorconfig" '("editorconfig-"))


;;; Generated autoloads from editorconfig-conf-mode.el

(autoload 'editorconfig-conf-mode "editorconfig-conf-mode" "\
Major mode for editing .editorconfig files.

(fn)" t)
(add-to-list 'auto-mode-alist '("\\.editorconfig\\'" . editorconfig-conf-mode))
(register-definition-prefixes "editorconfig-conf-mode" '("editorconfig-conf-mode-"))


;;; Generated autoloads from editorconfig-core.el

(register-definition-prefixes "editorconfig-core" '("editorconfig-core-"))


;;; Generated autoloads from editorconfig-core-handle.el

(register-definition-prefixes "editorconfig-core-handle" '("editorconfig-core-handle"))


;;; Generated autoloads from editorconfig-fnmatch.el

(register-definition-prefixes "editorconfig-fnmatch" '("editorconfig-fnmatch-"))


;;; Generated autoloads from editorconfig-tools.el

(autoload 'editorconfig-apply "editorconfig-tools" "\
Get and apply EditorConfig properties to current buffer.

This function does not respect the values of `editorconfig-exclude-modes' and
`editorconfig-exclude-regexps' and always applies available properties.
Use `editorconfig-mode-apply' instead to make use of these variables." t)
(autoload 'editorconfig-find-current-editorconfig "editorconfig-tools" "\
Find the closest .editorconfig file for current file." t)
(autoload 'editorconfig-display-current-properties "editorconfig-tools" "\
Display EditorConfig properties extracted for current buffer." t)
(defalias 'describe-editorconfig-properties #'editorconfig-display-current-properties)
(register-definition-prefixes "editorconfig-tools" '("editorconfig-mode-apply"))


;;; Generated autoloads from edmacro.el

(autoload 'edit-kbd-macro "edmacro" "\
Edit a keyboard macro.
At the prompt, type any key sequence which is bound to a keyboard macro.
Or, type \\[kmacro-end-and-call-macro] or \\`RET' to edit the last
keyboard macro, \\[view-lossage] to edit the last 300
keystrokes as a keyboard macro, or \\[execute-extended-command]
to edit a macro by its command name.
With a prefix argument, format the macro in a more concise way.

(fn KEYS &optional PREFIX FINISH-HOOK STORE-HOOK)" t)
(autoload 'edit-last-kbd-macro "edmacro" "\
Edit the most recently defined keyboard macro.

(fn &optional PREFIX)" t)
(autoload 'edit-named-kbd-macro "edmacro" "\
Edit a keyboard macro which has been given a name by `name-last-kbd-macro'.

(fn &optional PREFIX)" t)
(autoload 'read-kbd-macro "edmacro" "\
Read the region as a keyboard macro definition.
The region between START and END is interpreted as spelled-out keystrokes,
e.g., \"M-x abc RET\".  See documentation for `edmacro-mode' for details.
Leading/trailing \"C-x (\" and \"C-x )\" in the text are allowed and ignored.
The resulting macro is installed as the \"current\" keyboard macro.

In Lisp, may also be called with a single STRING argument in which case
the result is returned rather than being installed as the current macro.
The result is a vector of input events.
Second argument NEED-VECTOR means to return an event vector always.

(fn START &optional END)" t)
(autoload 'format-kbd-macro "edmacro" "\
Return the keyboard macro MACRO as a human-readable string.
This string is suitable for passing to `read-kbd-macro'.
Second argument VERBOSE means to put one command per line with comments.
If VERBOSE is `1', put everything on one line.  If VERBOSE is omitted
or nil, use a compact 80-column format.

(fn &optional MACRO VERBOSE)")
(register-definition-prefixes "edmacro" '("edmacro-"))


;;; Generated autoloads from emulation/edt.el

(autoload 'edt-set-scroll-margins "edt" "\
Set scroll margins.
Argument TOP is the top margin in number of lines or percent of window.
Argument BOTTOM is the bottom margin in number of lines or percent of window.

(fn TOP BOTTOM)" t)
(autoload 'edt-emulation-on "edt" "\
Turn on EDT Emulation." t)
(register-definition-prefixes "edt" '("edt-"))


;;; Generated autoloads from emulation/edt-lk201.el

(register-definition-prefixes "edt-lk201" '("*EDT-keys*"))


;;; Generated autoloads from emulation/edt-mapper.el

(register-definition-prefixes "edt-mapper" '("edt-"))


;;; Generated autoloads from emulation/edt-pc.el

(register-definition-prefixes "edt-pc" '("*EDT-keys*"))


;;; Generated autoloads from emulation/edt-vt100.el

(register-definition-prefixes "edt-vt100" '("edt-set-term-width-"))


;;; Generated autoloads from progmodes/eglot.el

(push (purecopy '(eglot 1 17 30)) package--builtin-versions)
(define-obsolete-function-alias 'eglot-update #'eglot-upgrade-eglot "29.1")
(autoload 'eglot "eglot" "\
Start LSP server for PROJECT's buffers under MANAGED-MAJOR-MODES.

This starts a Language Server Protocol (LSP) server suitable for
the buffers of PROJECT whose `major-mode' is among
MANAGED-MAJOR-MODES.  CLASS is the class of the LSP server to
start and CONTACT specifies how to connect to the server.

Interactively, the command attempts to guess MANAGED-MAJOR-MODES,
CLASS, CONTACT, and LANGUAGE-IDS from `eglot-server-programs',
according to the current buffer's `major-mode'.  PROJECT is
guessed from `project-find-functions'.  The search for active
projects in this context binds `eglot-lsp-context' (which see).

If it can't guess, it prompts the user for the mode and the
server.  With a single \\[universal-argument] prefix arg, it
always prompts for COMMAND.  With two \\[universal-argument], it
also always prompts for MANAGED-MAJOR-MODE.

The LSP server of CLASS is started (or contacted) via CONTACT.
If this operation is successful, current *and future* file
buffers of MANAGED-MAJOR-MODE inside PROJECT become \"managed\"
by the LSP server, meaning the information about their contents is
exchanged periodically with the server to provide enhanced
code-analysis via `xref-find-definitions', `flymake-mode',
`eldoc-mode', and `completion-at-point', among others.

PROJECT is a project object as returned by `project-current'.

CLASS is a subclass of `eglot-lsp-server'.

CONTACT specifies how to contact the server.  It is a
keyword-value plist used to initialize CLASS or a plain list as
described in `eglot-server-programs', which see.

LANGUAGE-IDS is a list of language ID string to send to the
server for each element in MANAGED-MAJOR-MODES.

INTERACTIVE is ignored and provided for backward compatibility.

(fn MANAGED-MAJOR-MODES PROJECT CLASS CONTACT LANGUAGE-IDS &optional INTERACTIVE)" t)
(autoload 'eglot-ensure "eglot" "\
Start Eglot session for current buffer if there isn't one.

Only use this function (in major mode hooks, etc) if you are
confident that Eglot can be started safely and efficiently for
*every* buffer visited where these hooks may execute.

Since it is difficult to establish this confidence fully, it's
often wise to use the interactive command `eglot' instead.  This
command only needs to be invoked once per project, as all other
files of a given major mode visited within the same project will
automatically become managed with no further user intervention
needed.")
(autoload 'eglot-upgrade-eglot "eglot" "\
Update Eglot to latest version.

(fn &rest _)" t)
(put 'eglot-workspace-configuration 'safe-local-variable #'listp)
(put 'eglot--debbugs-or-github-bug-uri 'bug-reference-url-format t)
(defun eglot--debbugs-or-github-bug-uri nil (format (if (string= (match-string 2) "github") "https://github.com/joaotavora/eglot/issues/%s" "https://debbugs.gnu.org/%s") (match-string 3)))
(register-definition-prefixes "eglot" '("eglot-"))


;;; Generated autoloads from ehelp.el

(autoload 'with-electric-help "ehelp" "\
Pop up an \"electric\" help buffer.
THUNK is a function of no arguments which is called to initialize the
contents of BUFFER.  BUFFER defaults to `*Help*'.  BUFFER will be
erased before THUNK is called unless NOERASE is non-nil.  THUNK will
be called while BUFFER is current and with `standard-output' bound to
the buffer specified by BUFFER.

If THUNK returns nil, we display BUFFER starting at the top, and shrink
the window to fit.  If THUNK returns non-nil, we don't do those things.

After THUNK has been called, this function \"electrically\" pops up a
window in which BUFFER is displayed and allows the user to scroll
through that buffer in `electric-help-mode'.  The window's height will
be at least MINHEIGHT if this value is non-nil.

If THUNK returns nil, we display BUFFER starting at the top, and
shrink the window to fit if `electric-help-shrink-window' is non-nil.
If THUNK returns non-nil, we don't do those things.

When the user exits (with `electric-help-exit', or otherwise), the help
buffer's window disappears (i.e., we use `save-window-excursion'), and
BUFFER is put back into its original major mode.

(fn THUNK &optional BUFFER NOERASE MINHEIGHT)")
(autoload 'electric-helpify "ehelp" "\


(fn FUN &optional NAME)")
(register-definition-prefixes "ehelp" '("ehelp-" "electric-"))


;;; Generated autoloads from emacs-lisp/eieio.el

(push (purecopy '(eieio 1 4)) package--builtin-versions)
(autoload 'make-instance "eieio" "\
Make a new instance of CLASS based on INITARGS.
For example:

  (make-instance \\='foo)

INITARGS is a property list with keywords based on the `:initarg'
for each slot.  For example:

  (make-instance \\='foo :slot1 value1 :slotN valueN)

(fn CLASS &rest INITARGS)")
(register-definition-prefixes "eieio" '("child-of-class-p" "defclass" "eieio-" "find-class" "obj" "oref" "oset" "same-class-p" "set-slot-value" "slot-" "with-slots"))


;;; Generated autoloads from emacs-lisp/eieio-base.el

(register-definition-prefixes "eieio-base" '("eieio-"))


;;; Generated autoloads from emacs-lisp/eieio-core.el

(push (purecopy '(eieio-core 1 4)) package--builtin-versions)
(autoload 'eieio-defclass-autoload "eieio-core" "\
Create autoload symbols for the EIEIO class CNAME.
SUPERCLASSES are the superclasses that CNAME inherits from.
DOC is the docstring for CNAME.
This function creates a mock-class for CNAME and adds it into
SUPERCLASSES as children.
It creates an autoload function for CNAME's constructor.

(fn CNAME SUPERCLASSES FILENAME DOC)")
(register-definition-prefixes "eieio-core" '("cl--generic-struct-tag" "class-" "eieio-" "inconsistent-class-hierarchy" "invalid-slot-" "unbound-slot"))


;;; Generated autoloads from emacs-lisp/eieio-custom.el

(autoload 'customize-object "eieio-custom" "\
Customize OBJ in a custom buffer.
Optional argument GROUP is the sub-group of slots to display.

(fn OBJ &optional GROUP)")
(register-definition-prefixes "eieio-custom" '("eieio-"))


;;; Generated autoloads from emacs-lisp/eieio-datadebug.el

(register-definition-prefixes "eieio-datadebug" '("data-debug-insert-object-"))


;;; Generated autoloads from emacs-lisp/eieio-opt.el

(autoload 'eieio-browse "eieio-opt" "\
Create an object browser window to show all objects.
If optional ROOT-CLASS, then start with that, otherwise start with
variable `eieio-default-superclass'.

(fn &optional ROOT-CLASS)" t)
(define-obsolete-function-alias 'eieio-help-class 'cl--describe-class "25.1")
(autoload 'eieio-help-constructor "eieio-opt" "\
Describe CTR if it is a class constructor.

(fn CTR)")
(make-obsolete 'eieio-help-constructor '"use `describe-function' or `cl--describe-class'." "29.1")
(register-definition-prefixes "eieio-opt" '("eieio-"))


;;; Generated autoloads from emacs-lisp/eieio-speedbar.el

(register-definition-prefixes "eieio-speedbar" '("eieio-speedbar"))


;;; Generated autoloads from cedet/srecode/el.el

(register-definition-prefixes "srecode/el" '("srecode-semantic-apply-tag-to-dict"))


;;; Generated autoloads from cedet/semantic/bovine/el.el

(register-definition-prefixes "semantic/bovine/el" '("semantic-"))


;;; Generated autoloads from emacs-lisp/eldoc.el

(push (purecopy '(eldoc 1 15 0)) package--builtin-versions)


;;; Generated autoloads from elec-pair.el

(defvar electric-pair-mode nil "\
Non-nil if Electric-Pair mode is enabled.
See the `electric-pair-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `electric-pair-mode'.")
(custom-autoload 'electric-pair-mode "elec-pair" nil)
(autoload 'electric-pair-mode "elec-pair" "\
Toggle automatic parens pairing (Electric Pair mode).

Electric Pair mode is a global minor mode.  When enabled, typing
an open parenthesis automatically inserts the corresponding
closing parenthesis, and vice versa.  (Likewise for brackets, etc.).
If the region is active, the parentheses (brackets, etc.) are
inserted around the region instead.

To toggle the mode in a single buffer, use `electric-pair-local-mode'.

This is a global minor mode.  If called interactively, toggle the
`Electric-Pair mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='electric-pair-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'electric-pair-local-mode "elec-pair" "\
Toggle `electric-pair-mode' only in this buffer.

This is a minor mode.  If called interactively, toggle the
`Electric-Pair-Local mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `electric-pair-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "elec-pair" '("electric-pair-"))


;;; Generated autoloads from elide-head.el

(autoload 'elide-head-mode "elide-head" "\
Toggle eliding (hiding) header material in the current buffer.

When Elide Header mode is enabled, headers are hidden according
to `elide-head-headers-to-hide'.

This is suitable as an entry on `find-file-hook' or appropriate
mode hooks.

This is a minor mode.  If called interactively, toggle the `Elide-Head
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `elide-head-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'elide-head "elide-head" "\
Hide header material in buffer according to `elide-head-headers-to-hide'.

The header is made invisible with an overlay.  With a prefix
argument ARG, show an elided material again.

This is suitable as an entry on `find-file-hook' or appropriate
mode hooks.

(fn &optional ARG)" t)
(make-obsolete 'elide-head 'elide-head-mode "29.1")
(register-definition-prefixes "elide-head" '("elide-head-"))


;;; Generated autoloads from emacs-lisp/elint.el

(autoload 'elint-file "elint" "\
Lint the file FILE.

(fn FILE)" t)
(autoload 'elint-directory "elint" "\
Lint all the .el files in DIRECTORY.
A complicated directory may require a lot of memory.

(fn DIRECTORY)" t)
(autoload 'elint-current-buffer "elint" "\
Lint the current buffer.
If necessary, this first calls `elint-initialize'." t)
(autoload 'elint-defun "elint" "\
Lint the function at point.
If necessary, this first calls `elint-initialize'." t)
(autoload 'elint-initialize "elint" "\
Initialize elint.
If elint is already initialized, this does nothing, unless
optional prefix argument REINIT is non-nil.

(fn &optional REINIT)" t)
(register-definition-prefixes "elint" '("elint-"))


;;; Generated autoloads from progmodes/elixir-ts-mode.el

(autoload 'elixir-ts-mode "elixir-ts-mode" "\
Major mode for editing Elixir, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "elixir-ts-mode" '("elixir-ts-"))


;;; Generated autoloads from emacs-lisp/elp.el

(autoload 'elp-instrument-function "elp" "\
Instrument FUNSYM for profiling.
FUNSYM must be a symbol of a defined function.

(fn FUNSYM)" t)
(autoload 'elp-instrument-list "elp" "\
Instrument, for profiling, all functions in `elp-function-list'.
Use optional LIST if provided instead.
If called interactively, prompt for LIST in the minibuffer;
type \"nil\" to use `elp-function-list'.

(fn &optional LIST)" t)
(autoload 'elp-instrument-package "elp" "\
Instrument for profiling, all functions which start with PREFIX.
For example, to instrument all ELP functions, do the following:

    \\[elp-instrument-package] RET elp- RET

Note that only functions that are currently loaded will be
instrumented.  If you run this function, and then later load
further functions that start with PREFIX, they will not be
instrumented automatically.

(fn PREFIX)" t)
(autoload 'elp-results "elp" "\
Display current profiling results.
If `elp-reset-after-results' is non-nil, then current profiling
information for all instrumented functions is reset after results are
displayed." t)
(register-definition-prefixes "elp" '("elp-"))


;;; Generated autoloads from eshell/em-alias.el

(register-definition-prefixes "em-alias" '("eshell" "pcomplete/eshell-mode/alias"))


;;; Generated autoloads from eshell/em-banner.el

(register-definition-prefixes "em-banner" '("eshell-banner-"))


;;; Generated autoloads from eshell/em-basic.el

(register-definition-prefixes "em-basic" '("eshell" "pcomplete/eshell-mode/eshell-debug"))


;;; Generated autoloads from eshell/em-cmpl.el

(register-definition-prefixes "em-cmpl" '("eshell-"))


;;; Generated autoloads from eshell/em-dirs.el

(register-definition-prefixes "em-dirs" '("eshell"))


;;; Generated autoloads from eshell/em-elecslash.el

(register-definition-prefixes "em-elecslash" '("eshell-elec"))


;;; Generated autoloads from eshell/em-extpipe.el

(register-definition-prefixes "em-extpipe" '("eshell-"))


;;; Generated autoloads from eshell/em-glob.el

(register-definition-prefixes "em-glob" '("eshell-"))


;;; Generated autoloads from eshell/em-hist.el

(register-definition-prefixes "em-hist" '("em-hist-unload-function" "eshell"))


;;; Generated autoloads from eshell/em-ls.el

(register-definition-prefixes "em-ls" '("em-ls-unload-function" "eshell"))


;;; Generated autoloads from eshell/em-pred.el

(register-definition-prefixes "em-pred" '("eshell-"))


;;; Generated autoloads from eshell/em-prompt.el

(register-definition-prefixes "em-prompt" '("eshell-"))


;;; Generated autoloads from eshell/em-rebind.el

(register-definition-prefixes "em-rebind" '("eshell-"))


;;; Generated autoloads from eshell/em-script.el

(autoload 'eshell-execute-file "em-script" "\
Execute a series of Eshell commands in FILE, passing ARGS.
If DESTINATION is t, write the command output to the current buffer.  If
nil, don't write the output anywhere.  For any other value, output to
the corresponding Eshell target (see `eshell-get-target').

Comments begin with `#'.

(fn FILE &optional ARGS DESTINATION)")
(autoload 'eshell-batch-file "em-script" "\
Execute an Eshell script as a batch script from the command line.
Inside your Eshell script file, you can add the following at the
top in order to make it into an executable script:

  #!/usr/bin/env -S emacs --batch -f eshell-batch-file")
(register-definition-prefixes "em-script" '("eshell"))


;;; Generated autoloads from eshell/em-smart.el

(register-definition-prefixes "em-smart" '("em-smart-unload-hook" "eshell-"))


;;; Generated autoloads from eshell/em-term.el

(register-definition-prefixes "em-term" '("eshell-"))


;;; Generated autoloads from eshell/em-tramp.el

(register-definition-prefixes "em-tramp" '("eshell"))


;;; Generated autoloads from eshell/em-unix.el

(register-definition-prefixes "em-unix" '("eshell"))


;;; Generated autoloads from eshell/em-xtra.el

(register-definition-prefixes "em-xtra" '("eshell/"))


;;; Generated autoloads from cedet/ede/emacs.el

(register-definition-prefixes "ede/emacs" '("ede-emacs-"))


;;; Generated autoloads from textmodes/emacs-authors-mode.el

(autoload 'emacs-authors-mode "emacs-authors-mode" "\
Major mode for viewing \"etc/AUTHORS\" from the Emacs distribution.
Provides some basic font locking and not much else.

(fn)" t)
(define-obsolete-function-alias 'etc-authors-mode #'emacs-authors-mode "29.1")
(register-definition-prefixes "emacs-authors-mode" '("emacs-authors-" "etc-authors-"))


;;; Generated autoloads from emacs-lock.el

(autoload 'emacs-lock-mode "emacs-lock" "\
Toggle Emacs Lock mode in the current buffer.
If called with a plain prefix argument, ask for the locking mode
to be used.

Initially, if the user does not pass an explicit locking mode, it
defaults to `emacs-lock-default-locking-mode' (which see);
afterwards, the locking mode most recently set on the buffer is
used instead.

When called from Elisp code, ARG can be any locking mode:

 exit   -- Emacs cannot exit while the buffer is locked
 kill   -- the buffer cannot be killed, but Emacs can exit as usual
 all    -- the buffer is locked against both actions

Other values are interpreted as usual.

See also `emacs-lock-unlockable-modes', which exempts buffers under
some major modes from being locked under some circumstances.

(fn &optional ARG)" t)
(register-definition-prefixes "emacs-lock" '("emacs-lock-"))


;;; Generated autoloads from textmodes/emacs-news-mode.el

(autoload 'emacs-news-mode "emacs-news-mode" "\
Major mode for editing the Emacs NEWS file.

(fn)" t)
(autoload 'emacs-news-view-mode "emacs-news-mode" "\
Major mode for viewing the Emacs NEWS file.

(fn)" t)
(register-definition-prefixes "emacs-news-mode" '("emacs-news-"))


;;; Generated autoloads from mail/emacsbug.el

(autoload 'report-emacs-bug "emacsbug" "\
Report a bug in GNU Emacs.
Prompts for bug subject.  Leaves you in a mail buffer.

Already submitted bugs can be found in the Emacs bug tracker:

  https://debbugs.gnu.org/cgi/pkgreport.cgi?package=emacs;max-bugs=100;base-order=1;bug-rev=1

(fn TOPIC &optional UNUSED)" t)
(set-advertised-calling-convention 'report-emacs-bug '(topic) '"24.5")
(autoload 'emacs-build-description "emacsbug" "\
Insert a description of the current Emacs build in the current buffer." t)
(autoload 'submit-emacs-patch "emacsbug" "\
Send an Emacs patch to the Emacs maintainers.
Interactively, you will be prompted for SUBJECT and a patch FILE
name (which will be attached to the mail).  You will end up in a
Message buffer where you can explain more about the patch.

(fn SUBJECT FILE)" t)
(register-definition-prefixes "emacsbug" '("report-emacs-bug-"))


;;; Generated autoloads from vc/emerge.el

(autoload 'emerge-files "emerge" "\
Run Emerge on two files FILE-A and FILE-B.

(fn ARG FILE-A FILE-B FILE-OUT &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-files-with-ancestor "emerge" "\
Run Emerge on two files, giving another file as the ancestor.

(fn ARG FILE-A FILE-B FILE-ANCESTOR FILE-OUT &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-buffers "emerge" "\
Run Emerge on two buffers BUFFER-A and BUFFER-B.

(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-buffers-with-ancestor "emerge" "\
Run Emerge on two buffers, giving another buffer as the ancestor.

(fn BUFFER-A BUFFER-B BUFFER-ANCESTOR &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-files-command "emerge")
(autoload 'emerge-files-with-ancestor-command "emerge")
(autoload 'emerge-files-remote "emerge" "\


(fn FILE-A FILE-B FILE-OUT)")
(autoload 'emerge-files-with-ancestor-remote "emerge" "\


(fn FILE-A FILE-B FILE-ANC FILE-OUT)")
(autoload 'emerge-revisions "emerge" "\
Emerge two RCS revisions of a file.

(fn ARG FILE REVISION-A REVISION-B &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-revisions-with-ancestor "emerge" "\
Emerge two RCS revisions of a file, with another revision as ancestor.

(fn ARG FILE REVISION-A REVISION-B ANCESTOR &optional STARTUP-HOOKS QUIT-HOOKS)" t)
(autoload 'emerge-merge-directories "emerge" "\


(fn A-DIR B-DIR ANCESTOR-DIR OUTPUT-DIR)" t)
(register-definition-prefixes "emerge" '("emerge-"))


;;; Generated autoloads from international/emoji.el

 (autoload 'emoji-insert "emoji" nil t)
 (autoload 'emoji-recent "emoji" nil t)
 (autoload 'emoji-search "emoji" nil t)
(autoload 'emoji-list "emoji" "\
List emojis and allow selecting and inserting one of them.
Select the emoji by typing \\<emoji-list-mode-map>\\[emoji-list-select] on its picture.
The glyph will be inserted into the buffer that was current
when the command was invoked." t)
(autoload 'emoji-describe "emoji" "\
Display the name of the grapheme cluster composed from GLYPH.
GLYPH should be a string of one or more characters which together
produce an emoji.  Interactively, GLYPH is the emoji at point (it
could also be any character, not just emoji).

If called from Lisp, return the name as a string; return nil if
the name is not known.

(fn GLYPH &optional INTERACTIVE)" t)
 (autoload 'emoji-list-select "emoji" nil t)
(autoload 'emoji--init "emoji" "\


(fn &optional FORCE INHIBIT-ADJUST)")
(autoload 'emoji-zoom-increase "emoji" "\
Increase the size of the character under point.
FACTOR is the multiplication factor for the size.

(fn &optional FACTOR)" t)
(autoload 'emoji-zoom-decrease "emoji" "\
Decrease the size of the character under point." t)
(autoload 'emoji-zoom-reset "emoji" "\
Reset the size of the character under point." t)
(register-definition-prefixes "emoji" '("emoji-"))


;;; Generated autoloads from textmodes/enriched.el

(autoload 'enriched-mode "enriched" "\
Minor mode for editing text/enriched files.

These are files with embedded formatting information in the MIME standard
text/enriched format.

Turning the mode on or off runs `enriched-mode-hook'.

More information about Enriched mode is available in the file
\"enriched.txt\" in `data-directory'.

Commands:

\\{enriched-mode-map}

This is a minor mode.  If called interactively, toggle the `Enriched
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `enriched-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'enriched-encode "enriched" "\


(fn FROM TO ORIG-BUF)")
(autoload 'enriched-decode "enriched" "\


(fn FROM TO)")
(register-definition-prefixes "enriched" '("enriched-"))


;;; Generated autoloads from epa.el

(autoload 'epa-list-keys "epa" "\
List all keys matched with NAME from the public keyring.

(fn &optional NAME)" t)
(autoload 'epa-list-secret-keys "epa" "\
List all keys matched with NAME from the private keyring.

(fn &optional NAME)" t)
(autoload 'epa-select-keys "epa" "\
Display a user's keyring and ask him to select keys.
CONTEXT is an `epg-context'.
PROMPT is a string to prompt with.
NAMES is a list of strings to be matched with keys.  If it is nil, all
the keys are listed.
If SECRET is non-nil, list secret keys instead of public keys.

(fn CONTEXT PROMPT &optional NAMES SECRET)")
(autoload 'epa-decrypt-file "epa" "\
Decrypt DECRYPT-FILE into PLAIN-FILE.
If you do not specify PLAIN-FILE, this functions prompts for the value to use.

(fn DECRYPT-FILE &optional PLAIN-FILE)" t)
(autoload 'epa-verify-file "epa" "\
Verify FILE.

(fn FILE)" t)
(autoload 'epa-sign-file "epa" "\
Sign FILE by SIGNERS keys selected.

(fn FILE SIGNERS MODE)" t)
(autoload 'epa-encrypt-file "epa" "\
Encrypt FILE for RECIPIENTS.

(fn FILE RECIPIENTS)" t)
(autoload 'epa-decrypt-region "epa" "\
Decrypt the current region between START and END.

If MAKE-BUFFER-FUNCTION is non-nil, call it to prepare an output buffer.
It should return that buffer.  If it copies the input, it should
delete the text now being decrypted.  It should leave point at the
proper place to insert the plaintext.

Be careful about using this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data in the region should be treated, you
should consider using the string based counterpart
`epg-decrypt-string', or the file based counterpart
`epg-decrypt-file' instead.

For example:

(let ((context (epg-make-context \\='OpenPGP)))
  (decode-coding-string
    (epg-decrypt-string context (buffer-substring start end))
    \\='utf-8))

(fn START END &optional MAKE-BUFFER-FUNCTION)" t)
(autoload 'epa-decrypt-armor-in-region "epa" "\
Decrypt OpenPGP armors in the current region between START and END.

Don't use this command in Lisp programs!
See the reason described in the `epa-decrypt-region' documentation.

(fn START END)" t)
(function-put 'epa-decrypt-armor-in-region 'interactive-only 't)
(autoload 'epa-verify-region "epa" "\
Verify the current region between START and END.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data in the region should be treated, you
should consider using the string based counterpart
`epg-verify-string', or the file based counterpart
`epg-verify-file' instead.

For example:

(let ((context (epg-make-context \\='OpenPGP)))
  (decode-coding-string
    (epg-verify-string context (buffer-substring start end))
    \\='utf-8))

(fn START END)" t)
(function-put 'epa-verify-region 'interactive-only 't)
(autoload 'epa-verify-cleartext-in-region "epa" "\
Verify OpenPGP cleartext signed messages in current region from START to END.

Don't use this command in Lisp programs!
See the reason described in the `epa-verify-region' documentation.

(fn START END)" t)
(function-put 'epa-verify-cleartext-in-region 'interactive-only 't)
(autoload 'epa-sign-region "epa" "\
Sign the current region between START and END by SIGNERS keys selected.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data should be treated, you should consider
using the string based counterpart `epg-sign-string', or the file
based counterpart `epg-sign-file' instead.

For example:

(let ((context (epg-make-context \\='OpenPGP)))
  (epg-sign-string
    context
    (encode-coding-string (buffer-substring start end) \\='utf-8)))

(fn START END SIGNERS MODE)" t)
(function-put 'epa-sign-region 'interactive-only 't)
(autoload 'epa-encrypt-region "epa" "\
Encrypt the current region between START and END for RECIPIENTS.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data should be treated, you should consider
using the string based counterpart `epg-encrypt-string', or the
file based counterpart `epg-encrypt-file' instead.

For example:

(let ((context (epg-make-context \\='OpenPGP)))
  (epg-encrypt-string
    context
    (encode-coding-string (buffer-substring start end) \\='utf-8)
    nil))

(fn START END RECIPIENTS SIGN SIGNERS)" t)
(function-put 'epa-encrypt-region 'interactive-only 't)
(autoload 'epa-delete-keys "epa" "\
Delete selected KEYS.

(fn KEYS &optional ALLOW-SECRET)" t)
(autoload 'epa-import-keys "epa" "\
Import keys from FILE.

(fn FILE)" t)
(autoload 'epa-import-keys-region "epa" "\
Import keys from the region.

(fn START END)" t)
(autoload 'epa-import-armor-in-region "epa" "\
Import keys in the OpenPGP armor format in the current region from START to END.

(fn START END)" t)
(autoload 'epa-export-keys "epa" "\
Export selected KEYS to FILE.

(fn KEYS FILE)" t)
(autoload 'epa-insert-keys "epa" "\
Insert selected KEYS after the point.

(fn KEYS)" t)
(register-definition-prefixes "epa" '("epa-"))


;;; Generated autoloads from epa-dired.el

(autoload 'epa-dired-do-decrypt "epa-dired" "\
Decrypt marked files." t)
(autoload 'epa-dired-do-verify "epa-dired" "\
Verify marked files." t)
(autoload 'epa-dired-do-sign "epa-dired" "\
Sign marked files." t)
(autoload 'epa-dired-do-encrypt "epa-dired" "\
Encrypt marked files." t)


;;; Generated autoloads from epa-file.el

(autoload 'epa-file-handler "epa-file" "\


(fn OPERATION &rest ARGS)")
(autoload 'epa-file-enable "epa-file" nil t)
(autoload 'epa-file-disable "epa-file" nil t)
(register-definition-prefixes "epa-file" '("epa-"))


;;; Generated autoloads from epa-ks.el

(autoload 'epa-search-keys "epa-ks" "\
Ask a keyserver for all keys matching QUERY.

The keyserver to be used is specified by `epa-keyserver'.

If EXACT is non-nil (interactively, prefix argument), require
exact matches.

Note that the request may fail if the query is not specific
enough, since keyservers have strict timeout settings.

(fn QUERY EXACT)" t)
(register-definition-prefixes "epa-ks" '("epa-k"))


;;; Generated autoloads from epa-mail.el

(autoload 'epa-mail-mode "epa-mail" "\
A minor-mode for composing encrypted/clearsigned mails.

This is a minor mode.  If called interactively, toggle the `epa-mail
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `epa-mail-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'epa-mail-decrypt "epa-mail" "\
Decrypt OpenPGP armors in the current buffer.
The buffer is expected to contain a mail message." t)
(function-put 'epa-mail-decrypt 'interactive-only 't)
(autoload 'epa-mail-verify "epa-mail" "\
Verify OpenPGP cleartext signed messages in the current buffer.
The buffer is expected to contain a mail message." t)
(function-put 'epa-mail-verify 'interactive-only 't)
(autoload 'epa-mail-sign "epa-mail" "\
Sign the current buffer.
The buffer is expected to contain a mail message, and signing is
performed with your default key.
With prefix argument, asks you to select interactively the key to
use from your key ring.

(fn START END SIGNERS MODE)" t)
(function-put 'epa-mail-sign 'interactive-only 't)
(autoload 'epa-mail-encrypt "epa-mail" "\
Encrypt the outgoing mail message in the current buffer.
Takes the recipients from the text in the header in the buffer
and translates them through `epa-mail-aliases'.
With prefix argument, asks you to select among them interactively
and also whether and how to sign.

Called from Lisp, the optional argument RECIPIENTS is a list
of recipient addresses, t to perform symmetric encryption,
or nil meaning use the defaults.

SIGNERS is a list of keys to sign the message with.

(fn &optional RECIPIENTS SIGNERS)" t)
(autoload 'epa-mail-import-keys "epa-mail" "\
Import keys in the OpenPGP armor format in the current buffer.
The buffer is expected to contain a mail message." t)
(function-put 'epa-mail-import-keys 'interactive-only 't)
(defvar epa-global-mail-mode nil "\
Non-nil if Epa-Global-Mail mode is enabled.
See the `epa-global-mail-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `epa-global-mail-mode'.")
(custom-autoload 'epa-global-mail-mode "epa-mail" nil)
(autoload 'epa-global-mail-mode "epa-mail" "\
Minor mode to hook EasyPG into Mail mode.

This is a global minor mode.  If called interactively, toggle the
`Epa-Global-Mail mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='epa-global-mail-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "epa-mail" '("epa-mail-"))


;;; Generated autoloads from epg.el

(push (purecopy '(epg 1 0 0)) package--builtin-versions)
(autoload 'epg-make-context "epg" "\
Return a context object.

(fn &optional PROTOCOL ARMOR TEXTMODE INCLUDE-CERTS CIPHER-ALGORITHM DIGEST-ALGORITHM COMPRESS-ALGORITHM)")
(register-definition-prefixes "epg" '("epg-"))


;;; Generated autoloads from epg-config.el

(autoload 'epg-find-configuration "epg-config" "\
Find or create a usable configuration to handle PROTOCOL.
This function first looks at the existing configuration found by
the previous invocation of this function, unless NO-CACHE is non-nil.

Then it walks through PROGRAM-ALIST or
`epg-config--program-alist'.  If `epg-gpg-program' or
`epg-gpgsm-program' is already set with custom, use it.
Otherwise, it tries the programs listed in the entry until the
version requirement is met.

(fn PROTOCOL &optional NO-CACHE PROGRAM-ALIST)")
(autoload 'epg-configuration "epg-config" "\
Return a list of internal configuration parameters of `epg-gpg-program'.")
(make-obsolete 'epg-configuration 'epg-find-configuration "25.1")
(autoload 'epg-check-configuration "epg-config" "\
Verify that a sufficient version of GnuPG is installed.
CONFIG should be a `epg-configuration' object (a plist).
REQ-VERSIONS should be a list with elements of the form (MIN
. MAX) where MIN and MAX are version strings indicating a
semi-open range of acceptable versions.  REQ-VERSIONS may also be
a single minimum version string.

(fn CONFIG &optional REQ-VERSIONS)")
(autoload 'epg-expand-group "epg-config" "\
Look at CONFIG and try to expand GROUP.

(fn CONFIG GROUP)")
(register-definition-prefixes "epg-config" '("epg-"))


;;; Generated autoloads from erc/erc.el

(push (purecopy '(erc 5 6 0 30 1)) package--builtin-versions)
(dolist (symbol '( erc-sasl erc-spelling ; 29
                  erc-imenu erc-nicks)) ; 30
 (custom-add-load symbol symbol))
(custom-autoload 'erc-modules "erc")
(autoload 'erc-select-read-args "erc" "\
Prompt for connection parameters and return them in a plist.
By default, collect `:server', `:port', `:nickname', and
`:password'.  With a non-nil prefix argument, also prompt for
`:user' and `:full-name'.  Also return various environmental
properties needed by entry-point commands, like `erc-tls'.")
(autoload 'erc-server-select "erc" "\
Interactively connect to a server from `erc-server-alist'." t)
(make-obsolete 'erc-server-select 'erc-tls "30.1")
(autoload 'erc "erc" "\
Connect to an Internet Relay Chat SERVER on a non-TLS PORT.
Use NICK and USER, when non-nil, to inform the IRC commands of
the same name, possibly factoring in a non-nil FULL-NAME as well.
When PASSWORD is non-nil, also send an opening server password
via the \"PASS\" command.  Interactively, prompt for SERVER,
PORT, NICK, and PASSWORD, along with USER and FULL-NAME when
given a prefix argument.  Non-interactively, expect the rarely
needed ID parameter, when non-nil, to be a symbol or a string for
naming the server buffer and identifying the connection
unequivocally.  Once connected, return the server buffer.  (See
Info node `(erc) Connecting' for details about all mentioned
parameters.)

Together with `erc-tls', this command serves as the main entry
point for ERC, the powerful, modular, and extensible IRC client.
Non-interactively, both commands accept the following keyword
arguments, with their defaults supplied by the indicated
\"compute\" functions:

  :server    `erc-compute-server'
  :port      `erc-compute-port'
  :nick      `erc-compute-nick'
  :user      `erc-compute-user'
  :password   N/A
  :full-name `erc-compute-full-name'
  :id'        N/A

For example, when called in the following manner

   (erc :server \"irc.libera.chat\" :full-name \"J. Random Hacker\")

ERC assigns SERVER and FULL-NAME the associated keyword values
and defers to `erc-compute-port', `erc-compute-user', and
`erc-compute-nick' for those respective parameters.

(fn &key SERVER PORT NICK USER PASSWORD FULL-NAME ID)" t)
(defalias 'erc-select #'erc)
(autoload 'erc-tls "erc" "\
Connect to an IRC server over a TLS-encrypted connection.
Interactively, prompt for SERVER, PORT, NICK, and PASSWORD, along
with USER and FULL-NAME when given a prefix argument.
Non-interactively, also accept a CLIENT-CERTIFICATE, which should
be a list containing the file name of the certificate's key
followed by that of the certificate itself.  Alternatively,
accept a value of t instead of a list, to tell ERC to query
`auth-source' for the certificate's details.

Example client certificate (CertFP) usage:

    (erc-tls :server \"irc.libera.chat\" :port 6697
             :client-certificate
             \\='(\"/home/bandali/my-cert.key\"
               \"/home/bandali/my-cert.crt\"))

See the alternative entry-point command `erc' as well as Info
node `(erc) Connecting' for a fuller description of the various
parameters, like ID.

(fn &key SERVER PORT NICK USER PASSWORD FULL-NAME CLIENT-CERTIFICATE ID)" t)
(autoload 'erc-handle-irc-url "erc" "\
Use ERC to IRC on HOST:PORT in CHANNEL.
If ERC is already connected to HOST:PORT, simply /join CHANNEL.
Otherwise, connect to HOST:PORT as NICK and /join CHANNEL.

Beginning with ERC 5.5, new connections require human intervention.
Customize `erc-url-connect-function' to override this.

(fn HOST PORT CHANNEL NICK PASSWORD &optional SCHEME)")
(register-definition-prefixes "erc" '("erc-"))


;;; Generated autoloads from erc/erc-autoaway.el

(register-definition-prefixes "erc-autoaway" '("erc-auto"))


;;; Generated autoloads from erc/erc-backend.el

(register-definition-prefixes "erc-backend" '("erc-"))


;;; Generated autoloads from erc/erc-button.el

(register-definition-prefixes "erc-button" '("erc-"))


;;; Generated autoloads from erc/erc-capab.el

(register-definition-prefixes "erc-capab" '("erc-capab-identify-"))


;;; Generated autoloads from erc/erc-common.el

(register-definition-prefixes "erc-common" '("define-erc-module" "erc-"))


;;; Generated autoloads from erc/erc-compat.el

(register-definition-prefixes "erc-compat" '("erc-"))


;;; Generated autoloads from erc/erc-dcc.el

(register-definition-prefixes "erc-dcc" '("erc-" "pcomplete/erc-mode/"))


;;; Generated autoloads from erc/erc-desktop-notifications.el

(register-definition-prefixes "erc-desktop-notifications" '("erc-notifications-"))


;;; Generated autoloads from erc/erc-ezbounce.el

(register-definition-prefixes "erc-ezbounce" '("erc-ezb-"))


;;; Generated autoloads from erc/erc-fill.el

(register-definition-prefixes "erc-fill" '("erc-"))


;;; Generated autoloads from erc/erc-goodies.el

(register-definition-prefixes "erc-goodies" '("erc-"))


;;; Generated autoloads from erc/erc-ibuffer.el

(register-definition-prefixes "erc-ibuffer" '("erc-"))


;;; Generated autoloads from erc/erc-identd.el

(register-definition-prefixes "erc-identd" '("erc-identd-"))


;;; Generated autoloads from erc/erc-imenu.el

(register-definition-prefixes "erc-imenu" '("erc-"))


;;; Generated autoloads from erc/erc-join.el

(register-definition-prefixes "erc-join" '("erc-"))


;;; Generated autoloads from erc/erc-lang.el

(register-definition-prefixes "erc-lang" '("erc-cmd-LANG" "iso-639-1-languages" "language"))


;;; Generated autoloads from erc/erc-list.el

(register-definition-prefixes "erc-list" '("erc-"))


;;; Generated autoloads from erc/erc-log.el

(register-definition-prefixes "erc-log" '("erc-"))


;;; Generated autoloads from erc/erc-match.el

(register-definition-prefixes "erc-match" '("erc-"))


;;; Generated autoloads from erc/erc-menu.el

(register-definition-prefixes "erc-menu" '("erc-menu-"))


;;; Generated autoloads from erc/erc-netsplit.el

(register-definition-prefixes "erc-netsplit" '("erc-"))


;;; Generated autoloads from erc/erc-networks.el

(autoload 'erc-determine-network "erc-networks" "\
Return the name of the network or \"Unknown\" as a symbol.
Use the server parameter NETWORK if provided, otherwise parse the
server name and search for a match in `erc-networks-alist'.")
(make-obsolete 'erc-determine-network '"maybe see `erc-networks--determine'" "29.1")
(register-definition-prefixes "erc-networks" '("erc-"))


;;; Generated autoloads from erc/erc-nicks.el

(register-definition-prefixes "erc-nicks" '("erc-nicks-"))


;;; Generated autoloads from erc/erc-notify.el

(register-definition-prefixes "erc-notify" '("erc-"))


;;; Generated autoloads from erc/erc-page.el

(register-definition-prefixes "erc-page" '("erc-"))


;;; Generated autoloads from erc/erc-pcomplete.el

(register-definition-prefixes "erc-pcomplete" '("erc-pcomplet" "pcomplete"))


;;; Generated autoloads from erc/erc-replace.el

(register-definition-prefixes "erc-replace" '("erc-replace-"))


;;; Generated autoloads from erc/erc-ring.el

(register-definition-prefixes "erc-ring" '("erc-"))


;;; Generated autoloads from erc/erc-sasl.el

(register-definition-prefixes "erc-sasl" '("erc-sasl-"))


;;; Generated autoloads from erc/erc-services.el

(register-definition-prefixes "erc-services" '("erc-"))


;;; Generated autoloads from erc/erc-sound.el

(register-definition-prefixes "erc-sound" '("erc-"))


;;; Generated autoloads from erc/erc-speedbar.el

(register-definition-prefixes "erc-speedbar" '("erc-"))


;;; Generated autoloads from erc/erc-spelling.el

(register-definition-prefixes "erc-spelling" '("erc-spelling-"))


;;; Generated autoloads from erc/erc-stamp.el

(register-definition-prefixes "erc-stamp" '("erc-"))


;;; Generated autoloads from erc/erc-status-sidebar.el

(register-definition-prefixes "erc-status-sidebar" '("erc-status-sidebar-"))


;;; Generated autoloads from erc/erc-track.el

(register-definition-prefixes "erc-track" '("erc-"))


;;; Generated autoloads from erc/erc-truncate.el

(register-definition-prefixes "erc-truncate" '("erc-"))


;;; Generated autoloads from erc/erc-xdcc.el

(register-definition-prefixes "erc-xdcc" '("erc-"))


;;; Generated autoloads from emacs-lisp/ert.el

(autoload 'ert-deftest "ert" "\
Define NAME (a symbol) as a test.

BODY is evaluated as a `progn' when the test is run.  It should
signal a condition on failure or just return if the test passes.

`should', `should-not', `should-error', `skip-when', and
`skip-unless' are useful for assertions in BODY.

Use `ert' to run tests interactively.

Tests that are expected to fail can be marked as such
using :expected-result.  See `ert-test-result-type-p' for a
description of valid values for RESULT-TYPE.

Macros in BODY are expanded when the test is defined, not when it
is run.  If a macro (possibly with side effects) is to be tested,
it has to be wrapped in `(eval (quote ...))'.

If NAME is already defined as a test and Emacs is running
in batch mode, an error is signaled.

(fn NAME () [DOCSTRING] [:expected-result RESULT-TYPE] [:tags \\='(TAG...)] BODY...)" nil t)
(function-put 'ert-deftest 'doc-string-elt 3)
(function-put 'ert-deftest 'lisp-indent-function 2)
(autoload 'ert-run-tests-batch "ert" "\
Run the tests specified by SELECTOR, printing results to the terminal.

SELECTOR selects which tests to run as described in `ert-select-tests' when
called with its second argument t, except if SELECTOR is nil, in which case
all tests rather than none will be run; this makes the command line
 \"emacs -batch -l my-tests.el -f ert-run-tests-batch-and-exit\" useful.

Returns the stats object.

(fn &optional SELECTOR)")
(autoload 'ert-run-tests-batch-and-exit "ert" "\
Like `ert-run-tests-batch', but exits Emacs when done.

The exit status will be 0 if all test results were as expected, 1
on unexpected results, or 2 if the tool detected an error outside
of the tests (e.g. invalid SELECTOR or bug in the code that runs
the tests).

(fn &optional SELECTOR)")
(autoload 'ert-run-tests-interactively "ert" "\
Run the tests specified by SELECTOR and display the results in a buffer.

SELECTOR selects which tests to run as described in `ert-select-tests'
when called with its second argument t.  Interactively, prompt for
SELECTOR; the default t means run all the defined tests.

(fn SELECTOR)" t)
(defalias 'ert #'ert-run-tests-interactively)
(autoload 'ert-describe-test "ert" "\
Display the documentation for TEST-OR-TEST-NAME (a symbol or ert-test).

(fn TEST-OR-TEST-NAME)" t)
(register-definition-prefixes "ert" '("ert-"))


;;; Generated autoloads from emacs-lisp/ert-font-lock.el

(autoload 'ert-font-lock-deftest "ert-font-lock" "\
Define test NAME (a symbol) using assertions from TEST-STR.

Other than MAJOR-MODE and TEST-STR parameters, this macro accepts
the same parameters and keywords as `ert-deftest' and is intended
to be used through `ert'.

(fn NAME () [DOCSTRING] [:expected-result RESULT-TYPE] [:tags \\='(TAG...)] MAJOR-MODE TEST-STR)" nil t)
(function-put 'ert-font-lock-deftest 'doc-string-elt 3)
(function-put 'ert-font-lock-deftest 'lisp-indent-function 2)
(autoload 'ert-font-lock-deftest-file "ert-font-lock" "\
Define test NAME (a symbol) using assertions from FILE.

FILE - path to a file with assertions in ERT resource director as
return by `ert-resource-directory'.

Other than MAJOR-MODE and FILE parameters, this macro accepts the
same parameters and keywords as `ert-deftest' and is intended to
be used through `ert'.

(fn NAME () [DOCSTRING] [:expected-result RESULT-TYPE] [:tags \\='(TAG...)] MAJOR-MODE FILE)" nil t)
(function-put 'ert-font-lock-deftest-file 'doc-string-elt 3)
(function-put 'ert-font-lock-deftest-file 'lisp-indent-function 2)
(autoload 'ert-font-lock-test-string "ert-font-lock" "\
Check font faces in TEST-STRING set by MODE.

The function is meant to be run from within an ERT test.

(fn TEST-STRING MODE)")
(autoload 'ert-font-lock-test-file "ert-font-lock" "\
Check font faces in FILENAME set by MODE.

The function is meant to be run from within an ERT test.

(fn FILENAME MODE)")
(register-definition-prefixes "ert-font-lock" '("ert-font-lock--"))


;;; Generated autoloads from emacs-lisp/ert-x.el

(autoload 'ert-kill-all-test-buffers "ert-x" "\
Kill all test buffers that are still live." t)
(register-definition-prefixes "ert-x" '("ert-"))


;;; Generated autoloads from progmodes/erts-mode.el

(autoload 'erts-mode "erts-mode" "\
Major mode for editing erts (Emacs testing) files.
This mode mainly provides some font locking.

\\{erts-mode-map}

(fn)" t)
(register-definition-prefixes "erts-mode" '("erts-"))


;;; Generated autoloads from eshell/esh-arg.el

(register-definition-prefixes "esh-arg" '("eshell-"))


;;; Generated autoloads from eshell/esh-cmd.el

(register-definition-prefixes "esh-cmd" '("eshell"))


;;; Generated autoloads from eshell/esh-ext.el

(register-definition-prefixes "esh-ext" '("eshell"))


;;; Generated autoloads from eshell/esh-io.el

(register-definition-prefixes "esh-io" '("eshell-"))


;;; Generated autoloads from eshell/esh-mode.el

(autoload 'eshell-mode "esh-mode" "\
Emacs shell interactive mode.

(fn)" t)
(autoload 'eshell-bookmark-jump "esh-mode" "\
Default bookmark handler for Eshell buffers.

(fn BOOKMARK)")
(register-definition-prefixes "esh-mode" '("eshell"))


;;; Generated autoloads from eshell/esh-module.el

(register-definition-prefixes "esh-module" '("eshell-"))


;;; Generated autoloads from eshell/esh-opt.el

(register-definition-prefixes "esh-opt" '("eshell-"))


;;; Generated autoloads from eshell/esh-proc.el

(register-definition-prefixes "esh-proc" '("eshell"))


;;; Generated autoloads from eshell/esh-util.el

(register-definition-prefixes "esh-util" '("eshell-"))


;;; Generated autoloads from eshell/esh-var.el

(register-definition-prefixes "esh-var" '("eshell" "pcomplete/eshell-mode/"))


;;; Generated autoloads from eshell/eshell.el

(push (purecopy '(eshell 2 4 2)) package--builtin-versions)
(autoload 'eshell "eshell" "\
Create an interactive Eshell buffer.
Start a new Eshell session, or switch to an already active
session.  Return the buffer selected (or created).

With a nonnumeric prefix arg, create a new session.

With a numeric prefix arg (as in `\\[universal-argument] 42 \\[eshell]'), switch
to the session with that number, or create it if it doesn't
already exist.

The buffer name used for Eshell sessions is determined by the
value of `eshell-buffer-name', which see.

Eshell is a shell-like command interpreter.  For more
information on Eshell, see Info node `(eshell)Top'.

(fn &optional ARG)" t)
(autoload 'eshell-command "eshell" "\
Execute the Eshell command string COMMAND.
If TO-CURRENT-BUFFER is non-nil (interactively, with the prefix
argument), then insert output into the current buffer at point.

(fn COMMAND &optional TO-CURRENT-BUFFER)" t)
(autoload 'eshell-command-result "eshell" "\
Execute the given Eshell COMMAND, and return the result.
The result might be any Lisp object.
If STATUS-VAR is a symbol, it will be set to the exit status of the
command.  This is the only way to determine whether the value returned
corresponding to a successful execution.

(fn COMMAND &optional STATUS-VAR)")
(register-definition-prefixes "eshell" '("eshell-"))


;;; Generated autoloads from progmodes/etags.el

(defvar tags-file-name nil "\
File name of tags table.
To switch to a new tags table, do not set this variable; instead,
invoke `visit-tags-table', which is the only reliable way of
setting the value of this variable, whether buffer-local or global.
Use the `etags' program to make a tags table file.")
 (put 'tags-file-name 'variable-interactive (purecopy "fVisit tags table: "))
 (put 'tags-file-name 'safe-local-variable 'stringp)
(defvar tags-case-fold-search 'default "\
Whether tags operations should be case-sensitive.
A value of t means case-insensitive, a value of nil means case-sensitive.
Any other value means use the setting of `case-fold-search'.")
(custom-autoload 'tags-case-fold-search "etags" t)
(put 'tags-case-fold-search 'safe-local-variable 'symbolp)
(defvar tags-table-list nil "\
List of file names of tags tables to search.
An element that is a directory means the file \"TAGS\" in that directory.
To switch to a new list of tags tables, setting this variable is sufficient.
If you set this variable, do not also set `tags-file-name'.
Use the `etags' program to make a tags table file.")
(custom-autoload 'tags-table-list "etags" t)
(defvar tags-compression-info-list (purecopy '("" ".Z" ".bz2" ".gz" ".xz" ".tgz")) "\
List of extensions tried by etags when `auto-compression-mode' is on.
An empty string means search the non-compressed file.")
(custom-autoload 'tags-compression-info-list "etags" t)
(defvar tags-add-tables 'ask-user "\
Control whether to add a new tags table to the current list.
t means do; nil means don't (always start a new list).
Any other value means ask the user whether to add a new tags table
to the current list (as opposed to starting a new list).")
(custom-autoload 'tags-add-tables "etags" t)
(defvar find-tag-hook nil "\
Hook to be run by \\[find-tag] after finding a tag.  See `run-hooks'.
The value in the buffer in which \\[find-tag] is done is used,
not the value in the buffer \\[find-tag] goes to.")
(custom-autoload 'find-tag-hook "etags" t)
(defvar find-tag-default-function nil "\
A function of no arguments used by \\[find-tag] to pick a default tag.
If nil, and the symbol that is the value of `major-mode'
has a `find-tag-default-function' property (see `put'), that is used.
Otherwise, `find-tag-default' is used.")
(custom-autoload 'find-tag-default-function "etags" t)
(autoload 'tags-table-mode "etags" "\
Major mode for tags table file buffers.

(fn)" t)
(autoload 'visit-tags-table "etags" "\
Tell tags commands to use tags table file FILE.
FILE should be the name of a file created with the `etags' program.
A directory name is ok too; it means file TAGS in that directory.

Normally \\[visit-tags-table] sets the global value of `tags-file-name'.
With a prefix arg, set the buffer-local value instead.  When called
from Lisp, if the optional arg LOCAL is non-nil, set the local value.
When you find a tag with \\[find-tag], the buffer it finds the tag
in is given a local value of this variable which is the name of the tags
file the tag was in.

(fn FILE &optional LOCAL)" t)
(autoload 'visit-tags-table-buffer "etags" "\
Select the buffer containing the current tags table.
Optional arg CONT specifies which tags table to visit.
If CONT is a string, visit that file as a tags table.
If CONT is t, visit the next table in `tags-table-list'.
If CONT is the atom `same', don't look for a new table;
 just select the buffer visiting `tags-file-name'.
If CONT is nil or absent, choose a first buffer from information in
 `tags-file-name', `tags-table-list', `tags-table-list-pointer'.
Optional second arg CBUF, if non-nil, specifies the initial buffer,
which is important if that buffer has a local value of `tags-file-name'.
Returns t if it visits a tags table, or nil if there are no more in the list.

(fn &optional CONT CBUF)")
(autoload 'tags-reset-tags-tables "etags" "\
Reset tags state to cancel effect of any previous \\[visit-tags-table] or \\[find-tag]." t)
(autoload 'tags-table-files "etags" "\
Return a list of files in the current tags table.
Assumes the tags table is the current buffer.  The file names are returned
as they appeared in the `etags' command that created the table, usually
without directory names.")
(autoload 'tags-lazy-completion-table "etags")
 (defun tags-completion-at-point-function ()
  (if (or tags-table-list tags-file-name)
      (progn
        (load "etags")
        (tags-completion-at-point-function))))
(autoload 'find-tag-noselect "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Returns the buffer containing the tag's definition and moves its point there,
but does not select the buffer.
The default for TAGNAME is the expression in the buffer near point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

(fn TAGNAME &optional NEXT-P REGEXP-P)" t)
(autoload 'find-tag "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition, and move point there.
The default for TAGNAME is the expression in the buffer around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

(fn TAGNAME &optional NEXT-P REGEXP-P)" t)
(make-obsolete 'find-tag 'xref-find-definitions "25.1")
(autoload 'find-tag-other-window "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another window, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

(fn TAGNAME &optional NEXT-P REGEXP-P)" t)
(make-obsolete 'find-tag-other-window 'xref-find-definitions-other-window "25.1")
(autoload 'find-tag-other-frame "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another frame, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

(fn TAGNAME &optional NEXT-P)" t)
(make-obsolete 'find-tag-other-frame 'xref-find-definitions-other-frame "25.1")
(autoload 'find-tag-regexp "etags" "\
Find tag (in current tags table) whose name matches REGEXP.
Select the buffer containing the tag's definition and move point there.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg OTHER-WINDOW is non-nil, select the buffer in another window.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

(fn REGEXP &optional NEXT-P OTHER-WINDOW)" t)
(make-obsolete 'find-tag-regexp 'xref-find-apropos "25.1")
(defalias 'pop-tag-mark 'xref-go-back)
(defalias 'next-file 'tags-next-file)
(autoload 'tags-next-file "etags" "\
Select next file among files in current tags table.

A first argument of t (prefix arg, if interactive) initializes to the
beginning of the list of files in the tags table.  If the argument is
neither nil nor t, it is evalled to initialize the list of files.

Non-nil second argument NOVISIT means use a temporary buffer
 to save time and avoid uninteresting warnings.

Value is nil if the file was already visited;
if the file was newly read in, the value is the filename.

(fn &optional INITIALIZE NOVISIT)" t)
(autoload 'tags-loop-continue "etags" "\
Continue last \\[tags-search] or \\[tags-query-replace] command.
Used noninteractively with non-nil argument to begin such a command (the
argument is passed to `next-file', which see).

(fn &optional FIRST-TIME)" t)
(make-obsolete 'tags-loop-continue 'fileloop-continue "27.1")
(autoload 'tags-search "etags" "\
Search through all files listed in tags table for match for REGEXP.
Stops when a match is found.
To continue searching for next match, use the command \\[fileloop-continue].

If FILES if non-nil should be a list or an iterator returning the
files to search.  The search will be restricted to these files.

Also see the documentation of the `tags-file-name' variable.

(fn REGEXP &optional FILES)" t)
(autoload 'tags-query-replace "etags" "\
Do `query-replace-regexp' of FROM with TO on all files listed in tags table.
Third arg DELIMITED (prefix arg) means replace only word-delimited matches.
If you exit (\\[keyboard-quit], RET or q), you can resume the query replace
with the command \\[fileloop-continue].

As each match is found, the user must type a character saying
what to do with it.  Type SPC or `y' to replace the match,
DEL or `n' to skip and go to the next match.  For more directions,
type \\[help-command] at that time.

For non-interactive use, this is superseded by `fileloop-initialize-replace'.

(fn FROM TO &optional DELIMITED FILES)" t)
(set-advertised-calling-convention 'tags-query-replace '(from to &optional delimited) '"27.1")
(autoload 'list-tags "etags" "\
Display list of tags in file FILE.
Interactively, prompt for FILE, with completion, offering the current
buffer's file name as the defaul.
This command searches only the first table in the list of tags tables,
and does not search included tables.
FILE should be as it was submitted to the `etags' command, which usually
means relative to the directory of the tags table file.

(fn FILE &optional NEXT-MATCH)" t)
(autoload 'tags-apropos "etags" "\
Display list of all tags in tags table REGEXP matches.

(fn REGEXP)" t)
(make-obsolete 'tags-apropos 'xref-find-apropos "25.1")
(autoload 'select-tags-table "etags" "\
Select a tags table file from a menu of those you have already used.
The list of tags tables to select from is stored in `tags-table-set-list';
see the doc of that variable if you want to add names to the list." t)
(autoload 'complete-tag "etags" "\
Perform tags completion on the text around point.
Completes to the set of names listed in the current tags table.
The string to complete is chosen in the same way as the default
for \\[find-tag] (which see)." t)
(autoload 'etags--xref-backend "etags")
(register-definition-prefixes "etags" '("default-tags-table-function" "etags-" "file-of-tag" "find-tag-" "goto-tag-location-function" "initialize-new-tags-table" "last-tag" "list-tags-function" "select-tags-table-" "snarf-tag-function" "tag" "verify-tags-table-function"))


;;; Generated autoloads from progmodes/etags-regen.el

(put 'etags-regen-regexp-alist 'safe-local-variable (lambda (value) (and (listp value) (seq-every-p (lambda (group) (and (consp group) (listp (car group)) (listp (cdr group)) (seq-every-p #'stringp (car group)) (seq-every-p #'stringp (cdr group)))) value))))
(put 'etags-regen-file-extensions 'safe-local-variable (lambda (value) (and (listp value) (seq-every-p #'stringp value))))
(put 'etags-regen-ignores 'safe-local-variable (lambda (value) (and (listp value) (seq-every-p #'stringp value))))
(defvar etags-regen-mode nil "\
Non-nil if Etags-Regen mode is enabled.
See the `etags-regen-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `etags-regen-mode'.")
(custom-autoload 'etags-regen-mode "etags-regen" nil)
(autoload 'etags-regen-mode "etags-regen" "\
Minor mode to automatically generate and update tags tables.

This minor mode generates the tags table automatically based on
the current project configuration, and later updates it as you
edit the files and save the changes.

If you select a tags table manually (for example, using
\\[visit-tags-table]), then this mode will be effectively
disabled for the entire session.  Use \\[tags-reset-tags-tables]
to countermand the effect of a previous \\[visit-tags-table].

This is a global minor mode.  If called interactively, toggle the
`Etags-Regen mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='etags-regen-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "etags-regen" '("etags-regen-"))


;;; Generated autoloads from language/ethio-util.el

(autoload 'setup-ethiopic-environment-internal "ethio-util")
(autoload 'ethio-sera-to-fidel-buffer "ethio-util" "\
Convert the current buffer from SERA to FIDEL.

FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional argument SECONDARY is non-nil, assume the
buffer begins with the secondary language; otherwise with the
primary language.

If the 2nd optional argument FORCE is non-nil, perform conversion
even if the buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and `ethio-use-three-dot-question'.

(fn &optional SECONDARY FORCE)" t)
(autoload 'ethio-sera-to-fidel-region "ethio-util" "\
Convert the characters in region from SERA to FIDEL.

FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 3rd argument SECONDARY is given and non-nil, assume the
region begins with the secondary language; otherwise with the
primary language.

If the 4th argument FORCE is given and non-nil, perform
conversion even if the buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and `ethio-use-three-dot-question'.

(fn BEGIN END &optional SECONDARY FORCE)" t)
(autoload 'ethio-sera-to-fidel-marker "ethio-util" "\
Convert regions surrounded by \"<sera>\" and \"</sera>\" from SERA to FIDEL.
FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
Assume that each region begins with `ethio-primary-language'.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

(fn &optional FORCE)" t)
(autoload 'ethio-fidel-to-sera-buffer "ethio-util" "\
Convert all the FIDEL characters in the current buffer to the SERA format.
FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional argument SECONDARY is non-nil, try to convert the
region so that it begins with the secondary language; otherwise with the
primary language.

If the 2nd optional argument FORCE is non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

(fn &optional SECONDARY FORCE)" t)
(autoload 'ethio-fidel-to-sera-region "ethio-util" "\
Convert all the FIDEL characters in the region to the SERA format.

FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 3rd argument SECONDARY is given and non-nil, convert
the region so that it begins with the secondary language; otherwise with
the primary language.

If the 4th argument FORCE is given and non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

(fn BEGIN END &optional SECONDARY FORCE)" t)
(autoload 'ethio-fidel-to-sera-marker "ethio-util" "\
Convert the regions surrounded by \"<sera>\" and \"</sera>\" from FIDEL to SERA.
FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

(fn &optional FORCE)" t)
(autoload 'ethio-modify-vowel "ethio-util" "\
Modify the vowel of the FIDEL that is under the cursor.
FIDEL is the Amharic/Ethiopic alphabet." t)
(autoload 'ethio-replace-space "ethio-util" "\
Replace ASCII spaces with Ethiopic word separators in the region.

In the specified region, replace word separators surrounded by two
Ethiopic characters, depending on the first argument CH, which should
be 1, 2, or 3.

If CH = 1, word separator will be replaced with an ASCII space.
If CH = 2, with two ASCII spaces.
If CH = 3, with the Ethiopic colon-like word separator.

The 2nd and 3rd arguments BEGIN and END specify the region.

(fn CH BEGIN END)" t)
(autoload 'ethio-input-special-character "ethio-util" "\
This function is deprecated.

(fn ARG)" t)
(autoload 'ethio-fidel-to-tex-buffer "ethio-util" "\
Convert each FIDEL characters in the current buffer into a fidel-tex command.
FIDEL is the Amharic/Ethiopic alphabet." t)
(autoload 'ethio-tex-to-fidel-buffer "ethio-util" "\
Convert fidel-tex commands in the current buffer into FIDEL chars.
FIDEL is the Amharic/Ethiopic alphabet." t)
(autoload 'ethio-fidel-to-java-buffer "ethio-util" "\
Convert Ethiopic characters in the buffer into the Java escape sequences.

Each escape sequence is of the form \\uXXXX, where XXXX is the
character's codepoint (in hex) in Unicode.

If `ethio-java-save-lowercase' is non-nil, use [0-9a-f].
Otherwise, [0-9A-F].")
(autoload 'ethio-java-to-fidel-buffer "ethio-util" "\
Convert the Java escape sequences in the buffer into Ethiopic characters.")
(autoload 'ethio-find-file "ethio-util" "\
Transliterate file content into Ethiopic depending on filename suffix.
If the file-name extension is \".sera\", convert from SERA to FIDEL.
If the file-name extension is \".html\", convert regions enclosed
by \"<sera>..</sera>\" from SERA to FIDEL.
If the file-name extension is \".tex\", convert fidel-tex commands
to FIDEL characters.
If the file-name extension is \".java\", convert Java escape sequences
to FIDEL characters.

FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.")
(autoload 'ethio-write-file "ethio-util" "\
Transliterate Ethiopic characters to ASCII depending on the file extension.
If the file-name extension is \".sera\", convert from FIDEL to SERA.
If the file-name extension is \".html\", convert FIDEL characters to
SERA regions enclosed by \"<sera>..</sera>\".
If the file-name extension is \".tex\", convert FIDEL characters
to fidel-tex commands.
If the file-name extension is \".java\", convert FIDEL characters to
Java escape sequences.

FIDEL is the Amharic alphabet; SERA (System for Ethiopic Representation
in ASCII) is the Latin representation of Ethiopic script.")
(autoload 'ethio-insert-ethio-space "ethio-util" "\
Insert the Ethiopic word delimiter (the colon-like character).
With ARG, insert that many delimiters.

(fn ARG)" t)
(autoload 'ethio-composition-function "ethio-util" "\


(fn POS TO FONT-OBJECT STRING DIRECTION)")
(register-definition-prefixes "ethio-util" '("ethio-" "exit-ethiopic-environment"))


;;; Generated autoloads from leim/quail/ethiopic.el

(register-definition-prefixes "quail/ethiopic" '("ethio-select-a-translation"))


;;; Generated autoloads from net/eudc.el

(autoload 'eudc-set-server "eudc" "\
Set the directory server to SERVER using PROTOCOL.
Unless NO-SAVE is non-nil, the server is saved as the default
server for future sessions.

(fn SERVER PROTOCOL &optional NO-SAVE)" t)
(autoload 'eudc-get-email "eudc" "\
Get the email field of NAME from the directory server.
If ERROR is non-nil, report an error if there is none.

(fn NAME &optional ERROR)" t)
(autoload 'eudc-get-phone "eudc" "\
Get the phone field of NAME from the directory server.
If ERROR is non-nil, report an error if there is none.

(fn NAME &optional ERROR)" t)
(autoload 'eudc-expand-try-all "eudc" "\
Wrap `eudc-expand-inline' with a prefix argument.
If TRY-ALL-SERVERS -- the prefix argument when called
interactively -- is non-nil, collect results from all servers.
If TRY-ALL-SERVERS is nil, do not try subsequent servers after
one server returns any match.

(fn &optional TRY-ALL-SERVERS)" t)
(autoload 'eudc-expand-inline "eudc" "\
Query the directory server, and expand the query string before point.
The query string consists of the buffer substring from the point back to
the preceding comma, colon or beginning of line.
The variable `eudc-inline-query-format' controls how to associate the
individual inline query words with directory attribute names.
After querying the server for the given string, the expansion specified by
`eudc-inline-expansion-format' is inserted in the buffer at point.
If SAVE-QUERY-AS-KILL is non-nil, then save the pre-expansion
text to the kill ring.  `eudc-expansion-save-query-as-kill' being
non-nil inverts the meaning of SAVE-QUERY-AS-KILL.
Multiple servers can be tried with the same query until one finds a match,
see `eudc-inline-expansion-servers'.  If TRY-ALL-SERVERS is
non-nil, collect results from all servers.

(fn &optional SAVE-QUERY-AS-KILL TRY-ALL-SERVERS)" t)
(autoload 'eudc-format-inline-expansion-result "eudc" "\
Format a query result according to `eudc-inline-expansion-format'.

(fn RES QUERY-ATTRS)")
(autoload 'eudc-query-with-words "eudc" "\
Query the directory server, and return the matching responses.
The variable `eudc-inline-query-format' controls how to associate the
individual QUERY-WORDS with directory attribute names.
After querying the server for the given string, the expansion
specified by `eudc-inline-expansion-format' is applied to the
matches before returning them.
Multiple servers can be tried with the same query until one finds a match,
see `eudc-inline-expansion-servers'.   When TRY-ALL-SERVERS is non-nil,
keep collecting results from subsequent servers after the first match.

(fn QUERY-WORDS &optional TRY-ALL-SERVERS)")
(autoload 'eudc-query-form "eudc" "\
Display a form to query the directory server.
If given a non-nil argument GET-FIELDS-FROM-SERVER, the function first
queries the server for the existing fields and displays a corresponding form.

(fn &optional GET-FIELDS-FROM-SERVER)" t)
(autoload 'eudc-load-eudc "eudc" "\
Load the Emacs Unified Directory Client.
This does nothing except loading eudc by autoload side-effect." t)
(defvar eudc-tools-menu (let ((map (make-sparse-keymap "Directory Servers"))) (define-key map [phone] `(menu-item ,(purecopy "Get Phone") eudc-get-phone :help ,(purecopy "Get the phone field of name from the directory server"))) (define-key map [email] `(menu-item ,(purecopy "Get Email") eudc-get-email :help ,(purecopy "Get the email field of NAME from the directory server"))) (define-key map [separator-eudc-email] menu-bar-separator) (define-key map [expand-inline] `(menu-item ,(purecopy "Expand Inline Query") eudc-expand-inline :help ,(purecopy "Query the directory server, and expand the query string before point"))) (define-key map [query] `(menu-item ,(purecopy "Query with Form") eudc-query-form :help ,(purecopy "Display a form to query the directory server"))) (define-key map [separator-eudc-query] menu-bar-separator) (define-key map [new] `(menu-item ,(purecopy "New Server") eudc-set-server :help ,(purecopy "Set the directory server to SERVER using PROTOCOL"))) (define-key map [load] `(menu-item ,(purecopy "Load Hotlist of Servers") eudc-load-eudc :help ,(purecopy "Load the Emacs Unified Directory Client"))) map))
(fset 'eudc-tools-menu (symbol-value 'eudc-tools-menu))
(register-definition-prefixes "eudc" '("eudc-"))


;;; Generated autoloads from net/eudc-bob.el

(autoload 'eudc-display-generic-binary "eudc-bob" "\
Display a button for unidentified binary DATA.

(fn DATA)")
(autoload 'eudc-display-url "eudc-bob" "\
Display URL and make it clickable.

(fn URL)")
(autoload 'eudc-display-mail "eudc-bob" "\
Display e-mail address and make it clickable.

(fn MAIL)")
(autoload 'eudc-display-sound "eudc-bob" "\
Display a button to play the sound DATA.

(fn DATA)")
(autoload 'eudc-display-jpeg-inline "eudc-bob" "\
Display the JPEG DATA inline at point if possible.

(fn DATA)")
(autoload 'eudc-display-jpeg-as-button "eudc-bob" "\
Display a button for the JPEG DATA.

(fn DATA)")
(register-definition-prefixes "eudc-bob" '("eudc-bob-"))


;;; Generated autoloads from net/eudc-capf.el

(autoload 'eudc-capf-complete "eudc-capf" "\
Email address completion function for `completion-at-point-functions'.

This function checks whether the current major mode is one of the
modes listed in `eudc-capf-modes', and whether point is on a line
with a message header listing email recipients, that is, a line
whose beginning matches `message-email-recipient-header-regexp',
and, if the check succeeds, searches for records matching the
words before point.

The return value is either nil when no match is found, or a
completion table as required for functions listed in
`completion-at-point-functions'.")
(autoload 'eudc-capf-message-expand-name "eudc-capf" "\
Email address completion function for `message-completion-alist'.

When this function is added to `message-completion-alist',
replacing any existing entry for `message-expand-name' there,
with an appropriate regular expression such as for example
`message-email-recipient-header-regexp', then EUDC will be
queried for email addresses, and the results delivered to
`completion-at-point'.")
(register-definition-prefixes "eudc-capf" '("eudc-capf-modes"))


;;; Generated autoloads from net/eudc-export.el

(autoload 'eudc-insert-record-at-point-into-bbdb "eudc-export" "\
Insert record at point into the BBDB database.
This function can only be called from a directory query result buffer." t)
(autoload 'eudc-try-bbdb-insert "eudc-export" "\
Call `eudc-insert-record-at-point-into-bbdb' if on a record." t)
(register-definition-prefixes "eudc-export" '("eudc-"))


;;; Generated autoloads from net/eudc-hotlist.el

(autoload 'eudc-edit-hotlist "eudc-hotlist" "\
Edit the hotlist of directory servers in a specialized buffer." t)
(register-definition-prefixes "eudc-hotlist" '("eudc-hotlist-"))


;;; Generated autoloads from net/eudc-vars.el

(register-definition-prefixes "eudc-vars" '("eudc-"))


;;; Generated autoloads from net/eudcb-bbdb.el

(register-definition-prefixes "eudcb-bbdb" '("eudc-bbdb-"))


;;; Generated autoloads from net/eudcb-ecomplete.el

(autoload 'eudc-ecomplete-query-internal "eudcb-ecomplete" "\
Query `ecomplete' with QUERY.
QUERY is a list of cons cells (ATTR . VALUE).  Since `ecomplete'
does not provide attributes in the usual sense, the
back-end-specific attribute names in
`eudc-ecomplete-attributes-translation-alist' are used as the
KEY (that is, the \"type\" of match) when looking for matches in
`ecomplete-database'.

RETURN-ATTRS is ignored.

(fn QUERY &optional RETURN-ATTRS)")
(register-definition-prefixes "eudcb-ecomplete" '("eudc-ecomplete-attributes-translation-alist"))


;;; Generated autoloads from net/eudcb-ldap.el

(register-definition-prefixes "eudcb-ldap" '("eudc-"))


;;; Generated autoloads from net/eudcb-mab.el

(register-definition-prefixes "eudcb-mab" '("eudc-"))


;;; Generated autoloads from net/eudcb-macos-contacts.el

(register-definition-prefixes "eudcb-macos-contacts" '("eudc-macos-contacts-"))


;;; Generated autoloads from net/eudcb-mailabbrev.el

(autoload 'eudc-mailabbrev-query-internal "eudcb-mailabbrev" "\
Query `mailabbrev' with QUERY.
QUERY is a list of cons cells (ATTR . VALUE).  Since `mailabbrev'
does not provide attributes in the usual sense, only the email,
name, and firstname attributes in the QUERY are considered, and
their values are matched against the alias names in the mailrc
file.  When a mailrc alias is a distribution list, that is it
expands to more that one email address, the individual recipient
specifications are formatted using `eudc-rfc5322-make-address',
and returned as a comma-separated list in the email address
attribute.

RETURN-ATTRS is a list of attributes to return, defaulting to
`eudc-default-return-attributes'.

(fn QUERY &optional RETURN-ATTRS)")


;;; Generated autoloads from emacs-lisp/ewoc.el

(autoload 'ewoc-create "ewoc" "\
Create an empty ewoc.

The ewoc will be inserted in the current buffer at the current position.

PRETTY-PRINTER should be a function that takes one argument, an
element, and inserts a string representing it in the buffer (at
point).  The string PRETTY-PRINTER inserts may be empty or span
several lines.  The PRETTY-PRINTER should use `insert', and not
`insert-before-markers'.

Optional second and third arguments HEADER and FOOTER are strings,
possibly empty, that will always be present at the top and bottom,
respectively, of the ewoc.

Normally, a newline is automatically inserted after the header,
the footer and every node's printed representation.  Optional
fourth arg NOSEP non-nil inhibits this.

(fn PRETTY-PRINTER &optional HEADER FOOTER NOSEP)")
(register-definition-prefixes "ewoc" '("ewoc-"))


;;; Generated autoloads from net/eww.el

(defvar eww-suggest-uris '(eww-links-at-point thing-at-point-url-at-point eww-current-url eww-bookmark-urls) "\
List of functions called to form the list of default URIs for `eww'.
Each of the elements is a function returning either a string or a list
of strings.  The results will be joined into a single list with
duplicate entries (if any) removed.")
(custom-autoload 'eww-suggest-uris "eww" t)
(autoload 'eww-browse "eww" "\
Function to be run to parse command line URLs.
This is meant to be used for MIME handlers or command line use.

Setting the handler for \"text/x-uri;\" to
\"emacs -f eww-browse %u\" will then start up Emacs and call eww
to browse the url.

This can also be used on the command line directly:

 emacs -f eww-browse https://gnu.org

will start Emacs and browse the GNU web site." t)
(autoload 'eww "eww" "\
Fetch URL and render the page.
If the input doesn't look like an URL or a domain name, the
word(s) will be searched for via `eww-search-prefix'.

If NEW-BUFFER is non-nil (interactively, the prefix arg), use a
new buffer instead of reusing the default EWW buffer.

If BUFFER, the data to be rendered is in that buffer.  In that
case, this function doesn't actually fetch URL.  BUFFER will be
killed after rendering.

For more information, see Info node `(eww) Top'.

(fn URL &optional NEW-BUFFER BUFFER)" t)
 (defalias 'browse-web 'eww)
(autoload 'eww-open-file "eww" "\
Render FILE using EWW.
If NEW-BUFFER is non-nil (interactively, the prefix arg), use a
new buffer instead of reusing the default EWW buffer.

(fn FILE &optional NEW-BUFFER)" t)
(autoload 'eww-search-words "eww" "\
Search the web for the text in the region.
If region is active (and not whitespace), search the web for
the text between region beginning and end.  Else, prompt the
user for a search string.  See the variable `eww-search-prefix'
for the search engine used." t)
(autoload 'eww-mode "eww" "\
Mode for browsing the web.

\\{eww-mode-map}

(fn)" t)
(autoload 'eww-browse-url "eww" "\
Ask the EWW browser to load URL.

Interactively, if the variable `browse-url-new-window-flag' is non-nil,
loads the document in a new buffer tab on the window tab-line.  A non-nil
prefix argument reverses the effect of `browse-url-new-window-flag'.

If `tab-bar-mode' is enabled, then whenever a document would
otherwise be loaded in a new buffer, it is loaded in a new tab
in the tab-bar on an existing frame.  See more options in
`eww-browse-url-new-window-is-tab'.

Non-interactively, this uses the optional second argument NEW-WINDOW
instead of `browse-url-new-window-flag'.

(fn URL &optional NEW-WINDOW)")
(autoload 'eww-list-bookmarks "eww" "\
Display the bookmarks." t)
(autoload 'eww-bookmark-jump "eww" "\
Default bookmark handler for EWW buffers.

(fn BOOKMARK)")
(register-definition-prefixes "eww" '("eww-"))


;;; Generated autoloads from progmodes/executable.el

(autoload 'executable-command-find-posix-p "executable" "\
Check if PROGRAM handles arguments Posix-style.
If PROGRAM is non-nil, use that instead of \"find\".

(fn &optional PROGRAM)")
(autoload 'executable-interpret "executable" "\
Run script with user-specified args, and collect output in a buffer.
While script runs asynchronously, you can use the \\[next-error]
command to find the next error.  The buffer is also in `comint-mode' and
`compilation-shell-minor-mode', so that you can answer any prompts.

(fn COMMAND)" t)
(autoload 'executable-set-magic "executable" "\
Set this buffer's interpreter to INTERPRETER with optional ARGUMENT.
The variables `executable-magicless-file-regexp', `executable-prefix-env',
`executable-insert', `executable-query' and `executable-chmod' control
when and how magic numbers are inserted or replaced and scripts made
executable.

(fn INTERPRETER &optional ARGUMENT NO-QUERY-FLAG INSERT-FLAG)" t)
(autoload 'executable-make-buffer-file-executable-if-script-p "executable" "\
Make file executable according to umask if not already executable.
If file already has any execute bits set at all, do not change existing
file modes.")
(register-definition-prefixes "executable" '("executable-"))


;;; Generated autoloads from image/exif.el

(register-definition-prefixes "exif" '("exif-"))


;;; Generated autoloads from expand.el

(autoload 'expand-add-abbrevs "expand" "\
Add a list of abbreviations to abbrev table TABLE.
ABBREVS is a list of abbrev definitions; each abbrev description entry
has the form (ABBREV EXPANSION ARG).

ABBREV is the abbreviation to replace.

EXPANSION is the replacement string or a function which will make the
expansion.  For example, you could use the DMacros or skeleton packages
to generate such functions.

ARG is an optional argument which can be a number or a list of
numbers.  If ARG is a number, point is placed ARG chars from the
beginning of the expanded text.

If ARG is a list of numbers, point is placed according to the first
member of the list, but you can visit the other specified positions
cyclically with the functions `expand-jump-to-previous-slot' and
`expand-jump-to-next-slot'.

If ARG is omitted, point is placed at the end of the expanded text.

(fn TABLE ABBREVS)")
(autoload 'expand-abbrev-hook "expand" "\
Abbrev hook used to do the expansion job of expand abbrevs.
See `expand-add-abbrevs'.  Value is non-nil if expansion was done.")
(autoload 'expand-jump-to-previous-slot "expand" "\
Move the cursor to the previous slot in the last abbrev expansion.
This is used only in conjunction with `expand-add-abbrevs'." t)
(autoload 'expand-jump-to-next-slot "expand" "\
Move the cursor to the next slot in the last abbrev expansion.
This is used only in conjunction with `expand-add-abbrevs'." t)
 (define-key abbrev-map "p" 'expand-jump-to-previous-slot)
 (define-key abbrev-map "n" 'expand-jump-to-next-slot)
(register-definition-prefixes "expand" '("expand-"))


;;; Generated autoloads from cedet/srecode/expandproto.el

(register-definition-prefixes "srecode/expandproto" '("srecode-"))


;;; Generated autoloads from external-completion.el

(push (purecopy '(external-completion 0 1)) package--builtin-versions)
(register-definition-prefixes "external-completion" '("external-completion-"))


;;; Generated autoloads from cedet/srecode/extract.el

(register-definition-prefixes "srecode/extract" '("srecode-extract"))


;;; Generated autoloads from ezimage.el

(register-definition-prefixes "ezimage" '("defezimage" "ezimage-"))


;;; Generated autoloads from progmodes/f90.el

(autoload 'f90-mode "f90" "\
Major mode for editing Fortran 90,95 code in free format.
For fixed format code, use `fortran-mode'.

\\[f90-indent-line] indents the current line.
\\[f90-indent-new-line] indents current line and creates a new indented line.
\\[f90-indent-subprogram] indents the current subprogram.

Type \\=`? or \\=`\\[help-command] to display a list of built-in abbrevs for F90 keywords.

Key definitions:
\\{f90-mode-map}

Variables controlling indentation style and extra features:

`f90-do-indent'
  Extra indentation within do blocks (default 3).
`f90-if-indent'
  Extra indentation within if/select/where/forall blocks (default 3).
`f90-type-indent'
  Extra indentation within type/enum/interface/block-data blocks (default 3).
`f90-program-indent'
  Extra indentation within program/module/subroutine/function blocks
  (default 2).
`f90-associate-indent'
  Extra indentation within associate blocks (default 2).
`f90-critical-indent'
  Extra indentation within critical/block blocks (default 2).
`f90-continuation-indent'
  Extra indentation applied to continuation lines (default 5).
`f90-comment-region'
  String inserted by function \\[f90-comment-region] at start of each
  line in region (default \"!!!$\").
`f90-indented-comment-re'
  Regexp determining the type of comment to be intended like code
  (default \"!\").
`f90-directive-comment-re'
  Regexp of comment-like directive like \"!HPF\\\\$\", not to be indented
  (default \"!hpf\\\\$\").
`f90-break-delimiters'
  Regexp holding list of delimiters at which lines may be broken
  (default \"[-+*/><=,% \\t]\").
`f90-break-before-delimiters'
  Non-nil causes `f90-do-auto-fill' to break lines before delimiters
  (default t).
`f90-beginning-ampersand'
  Automatic insertion of `&' at beginning of continuation lines (default t).
`f90-smart-end'
  From an END statement, check and fill the end using matching block start.
  Allowed values are `blink', `no-blink', and nil, which determine
  whether to blink the matching beginning (default `blink').
`f90-auto-keyword-case'
  Automatic change of case of keywords (default nil).
  The possibilities are `downcase-word', `upcase-word', `capitalize-word'.
`f90-leave-line-no'
  Do not left-justify line numbers (default nil).

Turning on F90 mode calls the value of the variable `f90-mode-hook'
with no args, if that value is non-nil.

(fn)" t)
(register-definition-prefixes "f90" '("f90-"))


;;; Generated autoloads from face-remap.el

(autoload 'face-remap-add-relative "face-remap" "\
Add a face remapping entry of FACE to SPECS in the current buffer.
Return a cookie which can be used to delete this remapping with
`face-remap-remove-relative'.

The remaining arguments, SPECS, should form a list of faces.
Each list element should be either a face name or a property list
of face attribute/value pairs.  If more than one face is listed,
that specifies an aggregate face, in the same way as in a `face'
text property, except for possible priority changes noted below.

The face remapping specified by SPECS takes effect alongside the
remappings from other calls to `face-remap-add-relative' for the
same FACE, as well as the normal definition of FACE (at lowest
priority).  This function tries to sort multiple remappings for
the same face, so that remappings specifying relative face
attributes are applied after remappings specifying absolute face
attributes.

The base (lowest priority) remapping may be set to something
other than the normal definition of FACE via `face-remap-set-base'.

(fn FACE &rest SPECS)")
(autoload 'face-remap-reset-base "face-remap" "\
Set the base remapping of FACE to the normal definition of FACE.
This causes the remappings specified by `face-remap-add-relative'
to apply on top of the normal definition of FACE.

(fn FACE)")
(autoload 'face-remap-set-base "face-remap" "\
Set the base remapping of FACE in the current buffer to SPECS.
This causes the remappings specified by `face-remap-add-relative'
to apply on top of the face specification given by SPECS.

The remaining arguments, SPECS, specify the base of the remapping.
Each one of SPECS should be either a face name or a property list
of face attribute/value pairs, like in a `face' text property.

If SPECS is empty or a single face `eq' to FACE, call `face-remap-reset-base'
to use the normal definition of FACE as the base remapping; note that
this is different from SPECS containing a single value nil, which means
not to inherit from the global definition of FACE at all.

(fn FACE &rest SPECS)")
(autoload 'text-scale-set "face-remap" "\
Set the scale factor of the default face in the current buffer to LEVEL.
If LEVEL is non-zero, `text-scale-mode' is enabled, otherwise it is disabled.

LEVEL is a number of steps, with 0 representing the default size.
Each step scales the height of the default face by the variable
`text-scale-mode-step' (a negative number decreases the height by
the same amount).

(fn LEVEL)" t)
(autoload 'text-scale-increase "face-remap" "\
Increase the font size of the default face in current buffer by INC steps.
If the new height is other than the default, `text-scale-mode' is enabled.

Each step scales the height of the default face by the variable
`text-scale-mode-step' (a negative number of steps decreases the
height by the same amount).  As a special case, an argument of 0
will remove any scaling currently active.

(fn INC)" t)
(autoload 'text-scale-decrease "face-remap" "\
Decrease the font size of the default face in the current buffer by DEC steps.
See `text-scale-increase' for more details.

(fn DEC)" t)
 (define-key ctl-x-map [(control ?+)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?-)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?=)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?0)] 'text-scale-adjust)
(autoload 'text-scale-adjust "face-remap" "\
Adjust the font size in the current buffer by INC steps.
Interactively, INC is the prefix numeric argument, and defaults to 1.

The actual adjustment made depends on the final component of the
keybinding used to invoke the command, with all modifiers removed:

   \\`+', \\`='   Increase font size in current buffer by one step
   \\`-'      Decrease font size in current buffer by one step
   \\`0'      Reset the font size to the global default

After adjusting, continue to read input events and further adjust
the font size as long as the input event (with all modifiers removed)
is one of the above characters.

Each step scales the height of the default face by the factor that
is the value of `text-scale-mode-step' (a negative number of steps
decreases the height by that factor).  As a special case, an argument
of 0 will remove any scaling currently active, thus resetting the
font size to the original value.

This command is a special-purpose wrapper around the
`text-scale-increase' command which makes repetition convenient
even when it is bound in a non-top-level keymap.  For binding in
a top-level keymap, `text-scale-increase' or
`text-scale-decrease' may be more appropriate.

Most faces are affected by these font size changes, but not faces
that have an explicit `:height' setting.  The two exceptions to
this are the `default' and `header-line' faces: they will both be
scaled even if they have an explicit `:height' setting.

See also the related command `global-text-scale-adjust'.  Unlike
that command, which scales the font size with a increment (and can
also optionally resize frames to keep the same number of lines and
characters per line), `text-scale-adjust' scales the font size with
a factor, `text-scale-mode-step'.  With a small `text-scale-mode-step'
factor, the two commands behave similarly.

(fn INC)" t)
 (define-key global-map [pinch] 'text-scale-pinch)
(autoload 'text-scale-pinch "face-remap" "\
Adjust the height of the default face by the scale in the pinch event EVENT.

(fn EVENT)" t)
 (define-key ctl-x-map [(control meta ?+)] 'global-text-scale-adjust)
 (define-key ctl-x-map [(control meta ?=)] 'global-text-scale-adjust)
 (define-key ctl-x-map [(control meta ?-)] 'global-text-scale-adjust)
 (define-key ctl-x-map [(control meta ?0)] 'global-text-scale-adjust)
(autoload 'global-text-scale-adjust "face-remap" "\
Change (a.k.a. \"adjust\") the font size of all faces by INCREMENT.

Interactively, INCREMENT is the prefix numeric argument, and defaults
to 1.  Positive values of INCREMENT increase the font size, negative
values decrease it.

When you invoke this command, it performs the initial change of the
font size, and after that allows further changes by typing one of the
following keys immediately after invoking the command:

   \\`+', \\`='   Globally increase the height of the default face
   \\`-'      Globally decrease the height of the default face
   \\`0'      Globally reset the height of the default face

(The change of the font size produced by these keys depends on the
final component of the key sequence, with all modifiers removed.)

Buffer-local face adjustments have higher priority than global
face adjustments.

The variable `global-text-scale-adjust-resizes-frames' controls
whether the frames are resized to keep the same number of lines
and characters per line when the font size is adjusted.

See also the related command `text-scale-adjust'.  Unlike that
command, which scales the font size with a factor,
`global-text-scale-adjust' scales the font size with an
increment.

(fn INCREMENT)" t)
(autoload 'buffer-face-mode "face-remap" "\
Minor mode for a buffer-specific default face.

When enabled, the face specified by the variable
`buffer-face-mode-face' is used to display the buffer text.

This is a minor mode.  If called interactively, toggle the `Buffer-Face
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `buffer-face-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'buffer-face-set "face-remap" "\
Enable `buffer-face-mode', using face specs SPECS.
Each argument in SPECS should be a face, i.e. either a face name
or a property list of face attributes and values.  If more than
one face is listed, that specifies an aggregate face, like in a
`face' text property.  If SPECS is nil or omitted, disable
`buffer-face-mode'.

This function makes the variable `buffer-face-mode-face' buffer
local, and sets it to FACE.

(fn &rest SPECS)" t)
(autoload 'buffer-face-toggle "face-remap" "\
Toggle `buffer-face-mode', using face specs SPECS.
Each argument in SPECS should be a face, i.e. either a face name
or a property list of face attributes and values.  If more than
one face is listed, that specifies an aggregate face, like in a
`face' text property.

If `buffer-face-mode' is already enabled, and is currently using
the face specs SPECS, then it is disabled; if `buffer-face-mode'
is disabled, or is enabled and currently displaying some other
face, then is left enabled, but the face changed to reflect SPECS.

This function will make the variable `buffer-face-mode-face'
buffer local, and set it to SPECS.

(fn &rest SPECS)" t)
(autoload 'variable-pitch-mode "face-remap" "\
Variable-pitch default-face mode.
An interface to `buffer-face-mode' which uses the `variable-pitch' face.
Besides the choice of face, it is the same as `buffer-face-mode'.

(fn &optional ARG)" t)
(register-definition-prefixes "face-remap" '("buffer-face-mode-" "face-" "global-text-scale-adjust-" "internal-lisp-face-attributes" "text-scale-"))


;;; Generated autoloads from facemenu.el

 (autoload 'facemenu-menu "facemenu" nil nil 'keymap)
(define-key global-map [C-down-mouse-2] 'facemenu-menu)
(autoload 'list-colors-display "facemenu" "\
Display names of defined colors, and show what they look like.
If the optional argument LIST is non-nil, it should be a list of
colors to display.  Otherwise, this command computes a list of
colors that the current display can handle.  Customize
`list-colors-sort' to change the order in which colors are shown.
Type \\<help-mode-map>\\[revert-buffer] after customizing `list-colors-sort' to redisplay colors in
the new order.

If the optional argument BUFFER-NAME is nil, it defaults to \"*Colors*\".

If the optional argument CALLBACK is non-nil, it should be a
function to call each time the user types RET or clicks on a
color.  The function should accept a single argument, the color name.

(fn &optional LIST BUFFER-NAME CALLBACK)" t)
(register-definition-prefixes "facemenu" '("facemenu-" "list-colors-"))


;;; Generated autoloads from emacs-lisp/faceup.el

(push (purecopy '(faceup 0 0 6)) package--builtin-versions)
(autoload 'faceup-view-buffer "faceup" "\
Display the faceup representation of the current buffer." t)
(autoload 'faceup-write-file "faceup" "\
Save the faceup representation of the current buffer to the file FILE-NAME.

Unless a name is given, the file will be named xxx.faceup, where
xxx is the file name associated with the buffer.

If optional second arg CONFIRM is non-nil, this function
asks for confirmation before overwriting an existing file.
Interactively, confirmation is required unless you supply a prefix argument.

(fn &optional FILE-NAME CONFIRM)" t)
(autoload 'faceup-render-view-buffer "faceup" "\
Convert BUFFER containing Faceup markup to a new buffer and display it.

(fn &optional BUFFER)" t)
(autoload 'faceup-clean-buffer "faceup" "\
Remove faceup markup from buffer." t)
(autoload 'faceup-defexplainer "faceup" "\
Define an Ert explainer function for FUNCTION.

FUNCTION must return an explanation when the test fails and
`faceup-test-explain' is set.

(fn FUNCTION)" nil t)
(register-definition-prefixes "faceup" '("faceup-"))


;;; Generated autoloads from cedet/semantic/analyze/fcn.el

(register-definition-prefixes "semantic/analyze/fcn" '("semantic-analyze-"))


;;; Generated autoloads from mail/feedmail.el

(push (purecopy '(feedmail 11)) package--builtin-versions)
(autoload 'feedmail-send-it "feedmail" "\
Send the current mail buffer using the Feedmail package.
This is a suitable value for `send-mail-function'.  It can be used
with various lower-level mechanisms to provide features such as queueing.")
(autoload 'feedmail-run-the-queue-no-prompts "feedmail" "\
Like `feedmail-run-the-queue', but suppress confirmation prompts.

(fn &optional ARG)" t)
(autoload 'feedmail-run-the-queue-global-prompt "feedmail" "\
Like `feedmail-run-the-queue', but with a global confirmation prompt.
This is generally most useful if run non-interactively, since you can
bail out with an appropriate answer to the global confirmation prompt.

(fn &optional ARG)" t)
(autoload 'feedmail-run-the-queue "feedmail" "\
Visit each message in the feedmail queue directory and send it out.
Return value is a list of three things: number of messages sent, number of
messages skipped, and number of non-message things in the queue (commonly
backup file names and the like).

(fn &optional ARG)" t)
(autoload 'feedmail-queue-reminder "feedmail" "\
Perform some kind of reminder activity about queued and draft messages.
Called with an optional symbol argument which says what kind of event
is triggering the reminder activity.  The default is `on-demand', which
is what you typically would use if you were putting this in your Emacs start-up
or mail hook code.  Other recognized values for WHAT-EVENT (these are passed
internally by feedmail):

   after-immediate      (a message has just been sent in immediate mode)
   after-queue          (a message has just been queued)
   after-draft          (a message has just been placed in the draft directory)
   after-run            (the queue has just been run, possibly sending messages)

WHAT-EVENT is used as a key into the table `feedmail-queue-reminder-alist'.  If
the associated value is a function, it is called without arguments and is
expected to perform the reminder activity.  You can supply your own reminder
functions by redefining `feedmail-queue-reminder-alist'.  If you don't want any
reminders, you can set `feedmail-queue-reminder-alist' to nil.

(fn &optional WHAT-EVENT)" t)
(register-definition-prefixes "feedmail" '("feedmail-"))


;;; Generated autoloads from ffap.el

(defvar ffap-file-finder #'find-file "\
The command called by `find-file-at-point' to find a file.")
(custom-autoload 'ffap-file-finder "ffap" t)
(autoload 'ffap-next "ffap" "\
Search buffer for next file or URL, and run ffap.
Optional argument BACK says to search backwards.
Optional argument WRAP says to try wrapping around if necessary.
Interactively: use a single prefix \\[universal-argument] to search backwards,
double prefix to wrap forward, triple to wrap backwards.
Actual search is done by the function `ffap-next-guess'.

(fn &optional BACK WRAP)" t)
(autoload 'ffap-machine-at-point "ffap" "\
Return machine name at point if it exists, or nil.")
(autoload 'ffap-url-at-point "ffap" "\
Return URL from around point if it exists, or nil.

Sets the variable `ffap-string-at-point-region' to the bounds of URL, if any.")
(autoload 'find-file-at-point "ffap" "\
Find FILENAME, guessing a default from text around point.
If `ffap-url-regexp' is not nil, the FILENAME may also be an URL.
With a prefix, this command behaves exactly like `ffap-file-finder'.
If `ffap-require-prefix' is set, the prefix meaning is reversed.
See also the variables `ffap-dired-wildcards',
`ffap-url-unwrap-local', `ffap-url-unwrap-remote',
`ffap-file-name-with-spaces', and the functions `ffap-file-at-point'
and `ffap-url-at-point'.

(fn &optional FILENAME)" t)
(defalias 'ffap 'find-file-at-point)
(autoload 'ffap-menu "ffap" "\
Put up a menu of files and URLs mentioned in this buffer.
Then set mark, jump to choice, and try to fetch it.  The menu is
cached in `ffap-menu-alist', and rebuilt by `ffap-menu-rescan'.
The optional RESCAN argument (a prefix, interactively) forces
a rebuild.  Searches with `ffap-menu-regexp'.

(fn &optional RESCAN)" t)
(autoload 'ffap-at-mouse "ffap" "\
Find file or URL guessed from text around mouse click.
Interactively, calls `ffap-at-mouse-fallback' if no guess is found.
Return value:
  * if a guess string is found, return it (after finding it)
  * if the fallback is called, return whatever it returns
  * otherwise, nil

(fn E)" t)
(autoload 'dired-at-point "ffap" "\
Start Dired, defaulting to file at point.  See `ffap'.
If `dired-at-point-require-prefix' is set, the prefix meaning is reversed.

(fn &optional FILENAME)" t)
(autoload 'ffap-guess-file-name-at-point "ffap" "\
Try to get a file name at point.
This hook is intended to be put in `file-name-at-point-functions'.")
(autoload 'ffap-bindings "ffap" "\
Evaluate the forms in variable `ffap-bindings'." t)
(register-definition-prefixes "ffap" '("dired-at-point-" "ffap-" "find-file-literally-at-point"))


;;; Generated autoloads from cedet/srecode/fields.el

(register-definition-prefixes "srecode/fields" '("srecode-"))


;;; Generated autoloads from filecache.el

(autoload 'file-cache-add-directory "filecache" "\
Add all files in DIRECTORY to the file cache.
If called from Lisp with a non-nil REGEXP argument is non-nil,
only add files whose names match REGEXP.

(fn DIRECTORY &optional REGEXP)" t)
(autoload 'file-cache-add-directory-list "filecache" "\
Add DIRECTORIES (a list of directory names) to the file cache.
If called interactively, read the directory names one by one.
If the optional REGEXP argument is non-nil, only files which match it
will be added to the cache.  Note that the REGEXP is applied to the
files in each directory, not to the directory list itself.

(fn DIRECTORIES &optional REGEXP)" t)
(autoload 'file-cache-add-file "filecache" "\
Add FILE to the file cache.

(fn FILE)" t)
(autoload 'file-cache-add-directory-using-find "filecache" "\
Use the `find' command to add files to the file cache.
Find is run in DIRECTORY.

(fn DIRECTORY)" t)
(autoload 'file-cache-add-directory-using-locate "filecache" "\
Use the `locate' command to add files to the file cache.
STRING is passed as an argument to the locate command.

(fn STRING)" t)
(autoload 'file-cache-add-directory-recursively "filecache" "\
Add DIR and any subdirectories to the file-cache.
This function does not use any external programs.
If the optional REGEXP argument is non-nil, only files which match it
will be added to the cache.  Note that the REGEXP is applied to the
files in each directory, not to the directory list itself.

(fn DIR &optional REGEXP)" t)
(autoload 'file-cache-minibuffer-complete "filecache" "\
Complete a filename in the minibuffer using a preloaded cache.
Filecache does two kinds of substitution: it completes on names in
the cache, and, once it has found a unique name, it cycles through
the directories that the name is available in.  With a prefix argument,
the name is considered already unique; only the second substitution
(directories) is done.

(fn ARG)" t)
(register-definition-prefixes "filecache" '("file-cache-"))


;;; Generated autoloads from fileloop.el

(autoload 'fileloop-initialize "fileloop" "\
Initialize a new round of operation on several files.
FILES can be either a list of file names, or an iterator (used with `iter-next')
which returns a file name at each step.
SCAN-FUNCTION is a function called with no argument inside a buffer
and it should return non-nil if that buffer has something on which to operate.
OPERATE-FUNCTION is a function called with no argument; it is expected
to perform the operation on the current file buffer and when done
should return non-nil to mean that we should immediately continue
operating on the next file and nil otherwise.

(fn FILES SCAN-FUNCTION OPERATE-FUNCTION)")
(autoload 'fileloop-initialize-search "fileloop" "\


(fn REGEXP FILES CASE-FOLD)")
(autoload 'fileloop-initialize-replace "fileloop" "\
Initialize a new round of query&replace on several files.
FROM is a regexp and TO is the replacement to use.
FILES describes the files, as in `fileloop-initialize'.
CASE-FOLD can be t, nil, or `default':
  if it is nil, matching of FROM is case-sensitive.
  if it is t, matching of FROM is case-insensitive, except
     when `search-upper-case' is non-nil and FROM includes
     upper-case letters.
  if it is `default', the function uses the value of
     `case-fold-search' instead.
DELIMITED if non-nil means replace only word-delimited matches.

(fn FROM TO FILES CASE-FOLD &optional DELIMITED)")
(register-definition-prefixes "fileloop" '("fileloop-"))


;;; Generated autoloads from filenotify.el

(autoload 'file-notify-handle-event "filenotify" "\
Handle a file system monitoring event, coming from backends.
If OBJECT is a filewatch event, call its callback.
Otherwise, signal a `file-notify-error'.

(fn OBJECT)" t)
(function-put 'file-notify-handle-event 'completion-predicate #'ignore)
(register-definition-prefixes "filenotify" '("file-notify-"))


;;; Generated autoloads from cedet/ede/files.el

(register-definition-prefixes "ede/files" '("ede-"))


;;; Generated autoloads from files-x.el

(autoload 'add-file-local-variable "files-x" "\
Add file-local VARIABLE with its VALUE to the Local Variables list.

This command deletes all existing settings of VARIABLE (except `mode'
and `eval') and adds a new file-local VARIABLE with VALUE to the
Local Variables list.

If there is no Local Variables list in the current file buffer
then this function adds the first line containing the string
`Local Variables:' and the last line containing the string `End:'.

(fn VARIABLE VALUE &optional INTERACTIVE)" t)
(autoload 'delete-file-local-variable "files-x" "\
Delete all settings of file-local VARIABLE from the Local Variables list.

(fn VARIABLE &optional INTERACTIVE)" t)
(autoload 'add-file-local-variable-prop-line "files-x" "\
Add file-local VARIABLE with its VALUE to the -*- line.

This command deletes all existing settings of VARIABLE (except `mode'
and `eval') and adds a new file-local VARIABLE with VALUE to
the -*- line.

If there is no -*- line at the beginning of the current file buffer
then this function adds it.

(fn VARIABLE VALUE &optional INTERACTIVE)" t)
(autoload 'delete-file-local-variable-prop-line "files-x" "\
Delete all settings of file-local VARIABLE from the -*- line.

(fn VARIABLE &optional INTERACTIVE)" t)
(autoload 'add-dir-local-variable "files-x" "\
Add directory-local VARIABLE with its VALUE and MODE to .dir-locals.el.

With a prefix argument, prompt for the file to modify.

When called from Lisp, FILE may be the expanded name of the dir-locals file
where to add VARIABLE.

(fn MODE VARIABLE VALUE &optional FILE)" t)
(autoload 'delete-dir-local-variable "files-x" "\
Delete all MODE settings of dir-local VARIABLE from .dir-locals.el.

With a prefix argument, prompt for the file to modify.

When called from Lisp, FILE may be the expanded name of the dir-locals file
from where to delete VARIABLE.

(fn MODE VARIABLE &optional FILE)" t)
(autoload 'copy-file-locals-to-dir-locals "files-x" "\
Copy file-local variables to .dir-locals.el.

With a prefix argument, prompt for the file to modify.

When called from Lisp, FILE may be the expanded name of the dir-locals file
where to copy the file-local variables.

(fn &optional FILE)" t)
(autoload 'copy-dir-locals-to-file-locals "files-x" "\
Copy directory-local variables to the Local Variables list." t)
(autoload 'copy-dir-locals-to-file-locals-prop-line "files-x" "\
Copy directory-local variables to the -*- line." t)
(defvar enable-connection-local-variables t "\
Non-nil means enable use of connection-local variables.")
(autoload 'connection-local-set-profiles "files-x" "\
Add PROFILES for CRITERIA.
CRITERIA is a plist identifying a connection and the application
using this connection, see `connection-local-criteria-alist'.
PROFILES are the names of connection profiles (a symbol).

When a connection to a remote server is opened and CRITERIA
matches to that server, the connection-local variables from
PROFILES are applied to the corresponding process buffer.  The
variables for a connection profile are defined using
`connection-local-set-profile-variables'.

(fn CRITERIA &rest PROFILES)")
(autoload 'connection-local-set-profile-variables "files-x" "\
Map the symbol PROFILE to a list of variable settings.
VARIABLES is a list that declares connection-local variables for
the connection profile.  An element in VARIABLES is an alist
whose elements are of the form (VAR . VALUE).

When a connection to a remote server is opened, the server's
connection profiles are found.  A server may be assigned a
connection profile using `connection-local-set-profiles'.  Then
variables are set in the server's process buffer according to the
VARIABLES list of the connection profile.  The list is processed
in order.

(fn PROFILE VARIABLES)")
(autoload 'connection-local-update-profile-variables "files-x" "\
Update the variable settings for PROFILE in-place.
VARIABLES is a list that declares connection-local variables for
the connection profile.  An element in VARIABLES is an alist
whose elements are of the form (VAR . VALUE).

Unlike `connection-local-set-profile-variables' (which see), this
function preserves the values of any existing variable
definitions that aren't listed in VARIABLES.

(fn PROFILE VARIABLES)")
(autoload 'hack-connection-local-variables "files-x" "\
Read connection-local variables according to CRITERIA.
Store the connection-local variables in buffer local
variable `connection-local-variables-alist'.

This does nothing if `enable-connection-local-variables' is nil.

(fn CRITERIA)")
(autoload 'hack-connection-local-variables-apply "files-x" "\
Apply connection-local variables identified by CRITERIA.
Other local variables, like file-local and dir-local variables,
will not be changed.

(fn CRITERIA)")
(autoload 'with-connection-local-variables "files-x" "\
Apply connection-local variables according to `default-directory'.
Execute BODY, and unwind connection-local variables.

(fn &rest BODY)" nil t)
(autoload 'with-connection-local-application-variables "files-x" "\
Apply connection-local variables for APPLICATION in `default-directory'.
Execute BODY, and unwind connection-local variables.

(fn APPLICATION &rest BODY)" nil t)
(function-put 'with-connection-local-application-variables 'lisp-indent-function 1)
(autoload 'with-connection-local-variables-1 "files-x" "\
Apply connection-local variables according to `default-directory'.
Call BODY-FUN with no args, and then unwind connection-local variables.

(fn BODY-FUN)")
(autoload 'setq-connection-local "files-x" "\
Set each VARIABLE connection-locally to VALUE.

When `connection-local-profile-name-for-setq' is set, assign each
variable's value on that connection profile, and set that profile
for `connection-local-criteria'.  You can use this in combination
with `with-connection-local-variables', as in

  (with-connection-local-variables
    (setq-connection-local VARIABLE VALUE))

If there's no connection-local profile to use, just set the
variables normally, as with `setq'.

The variables are literal symbols and should not be quoted.  The
second VALUE is not computed until after the first VARIABLE is
set, and so on; each VALUE can use the new value of variables set
earlier in the `setq-connection-local'.  The return value of the
`setq-connection-local' form is the value of the last VALUE.

(fn [VARIABLE VALUE]...)" nil t)
(autoload 'connection-local-p "files-x" "\
Non-nil if VARIABLE has a connection-local binding in `default-directory'.
`default-directory' must be a remote file name.
If APPLICATION is nil, the value of
`connection-local-default-application' is used.

(fn VARIABLE &optional APPLICATION)" nil t)
(autoload 'connection-local-value "files-x" "\
Return connection-local VARIABLE for APPLICATION in `default-directory'.
`default-directory' must be a remote file name.
If APPLICATION is nil, the value of
`connection-local-default-application' is used.
If VARIABLE does not have a connection-local binding, the return
value is the default binding of the variable.

(fn VARIABLE &optional APPLICATION)" nil t)
(autoload 'path-separator "files-x" "\
The connection-local value of `path-separator'.")
(autoload 'null-device "files-x" "\
The connection-local value of `null-device'.")
(register-definition-prefixes "files-x" '("connection-local-" "dir-locals-to-string" "modify-" "read-"))


;;; Generated autoloads from filesets.el

(autoload 'filesets-init "filesets" "\
Filesets initialization.
Set up hooks, load the cache file -- if existing -- and build the menu.")
(register-definition-prefixes "filesets" '("filesets-"))


;;; Generated autoloads from cedet/semantic/symref/filter.el

(register-definition-prefixes "semantic/symref/filter" '("semantic-symref-"))


;;; Generated autoloads from cedet/srecode/filters.el

(register-definition-prefixes "srecode/filters" '("srecode-comment-prefix"))


;;; Generated autoloads from cedet/srecode/find.el

(register-definition-prefixes "srecode/find" '("srecode-"))


;;; Generated autoloads from cedet/semantic/find.el

(register-definition-prefixes "semantic/find" '("semantic-"))


;;; Generated autoloads from find-cmd.el

(push (purecopy '(find-cmd 0 6)) package--builtin-versions)
(autoload 'find-cmd "find-cmd" "\
Initiate the building of a find command.
For example:

(find-cmd \\='(prune (name \".svn\" \".git\" \".CVS\"))
          \\='(and (or (name \"*.pl\" \"*.pm\" \"*.t\")
                    (mtime \"+1\"))
                (fstype \"nfs\" \"ufs\"))))

`default-directory' is used as the initial search path.  The
result is a string that should be ready for the command line.

(fn &rest SUBFINDS)")
(register-definition-prefixes "find-cmd" '("find-"))


;;; Generated autoloads from find-dired.el

(autoload 'find-dired "find-dired" "\
Run `find' and go into Dired mode on a buffer of the output.
The command run (after changing into DIR) is essentially

    find . \\( ARGS \\) -ls

except that the car of the variable `find-ls-option' specifies what to
use in place of \"-ls\" as the final argument.

If your `find' program is not a GNU Find, the columns in the produced
Dired display might fail to align.  We recommend to install GNU Find in
those cases (you may need to customize the value of `find-program' if
you do so), which attempts to align the columns.

Collect output in the \"*Find*\" buffer.  To kill the job before
it finishes, type \\[kill-find].

For more information on how to write valid find expressions for
ARGS, see Info node `(find) Finding Files'.  If you are not
using GNU findutils (on macOS and *BSD systems), see instead the
man page for \"find\".

(fn DIR ARGS)" t)
(autoload 'find-dired-with-command "find-dired" "\
Run `find' and go into Dired mode on a buffer of the output.
The user-supplied COMMAND is run after changing into DIR and should look like

    find . GLOBALARGS \\( ARGS \\) -ls

The car of the variable `find-ls-option' specifies what to
use in place of \"-ls\" as the starting input.

Collect output in the \"*Find*\" buffer.  To kill the job before
it finishes, type \\[kill-find].

(fn DIR COMMAND)" t)
(autoload 'find-name-dired "find-dired" "\
Search DIR recursively for files matching the globbing PATTERN,
and run Dired on those files.
PATTERN is a shell wildcard (not an Emacs regexp) and need not be quoted.
The default command run (after changing into DIR) is

    find . -name \\='PATTERN\\=' -ls

See `find-name-arg' to customize the arguments.

(fn DIR PATTERN)" t)
(autoload 'find-grep-dired "find-dired" "\
Find files in DIR that contain matches for REGEXP and start Dired on output.
The command run (after changing into DIR) is

  find . \\( -type f -exec `grep-program' `find-grep-options' \\
    -e REGEXP {} \\; \\) -ls

where the first string in the value of the variable `find-ls-option'
specifies what to use in place of \"-ls\" as the final argument.

(fn DIR REGEXP)" t)
(register-definition-prefixes "find-dired" '("find-" "kill-find"))


;;; Generated autoloads from find-file.el

(defvar ff-special-constructs `((,(purecopy "^#\\s *\\(include\\|import\\)\\s +[<\"]\\(.*\\)[>\"]") \, (lambda nil (match-string 2)))) "\
List of special constructs recognized by `ff-treat-as-special'.
Each element, tried in order, has the form (REGEXP . EXTRACT).
If REGEXP matches the current line (from the beginning of the line),
`ff-treat-as-special' calls function EXTRACT with no args.
If EXTRACT returns nil, keep trying.  Otherwise, return the
filename that EXTRACT returned.")
(custom-autoload 'ff-special-constructs "find-file" t)
(autoload 'ff-get-other-file "find-file" "\
Find the header or source file corresponding to this file.
See also the documentation for `ff-find-other-file'.

If optional IN-OTHER-WINDOW is non-nil, find the file in another window.

(fn &optional IN-OTHER-WINDOW)" t)
(defalias 'ff-find-related-file #'ff-find-other-file)
(autoload 'ff-find-other-file "find-file" "\
Find the header or source file corresponding to this file.
Being on a `#include' line pulls in that file.

If optional IN-OTHER-WINDOW is non-nil, find the file in the other window.
If optional IGNORE-INCLUDE is non-nil, ignore being on `#include' lines.

If optional EVENT is non-nil (default `last-nonmenu-event', move
point to the end position of that event before calling the
various ff-* hooks.

Variables of interest include:

 - `ff-case-fold-search'
   Non-nil means ignore cases in matches (see `case-fold-search').
   If you have extensions in different cases, you will want this to be nil.

 - `ff-always-in-other-window'
   If non-nil, always open the other file in another window, unless an
   argument is given to `ff-find-other-file'.

 - `ff-ignore-include'
   If non-nil, ignores #include lines.

 - `ff-always-try-to-create'
   If non-nil, always attempt to create the other file if it was not found.

 - `ff-quiet-mode'
   If non-nil, does not trace which directories are being searched.

 - `ff-special-constructs'
   A list of regular expressions specifying how to recognize special
   constructs such as include files etc, and an associated method for
   extracting the filename from that construct.

 - `ff-other-file-alist'
   Alist of extensions to find given the current file's extension.

 - `ff-search-directories'
   List of directories searched through with each extension specified in
   `ff-other-file-alist' that matches this file's extension.

 - `ff-pre-find-hook'
   List of functions to be called before the search for the file starts.

 - `ff-pre-load-hook'
   List of functions to be called before the other file is loaded.

 - `ff-post-load-hook'
   List of functions to be called after the other file is loaded.

 - `ff-not-found-hook'
   List of functions to be called if the other file could not be found.

 - `ff-file-created-hook'
   List of functions to be called if the other file has been created.

(fn &optional IN-OTHER-WINDOW IGNORE-INCLUDE EVENT)" t)
(define-obsolete-function-alias 'ff-mouse-find-other-file #'ff-find-other-file "28.1")
(define-obsolete-function-alias 'ff-mouse-find-other-file-other-window #'ff-find-other-file-other-window "28.1")
(autoload 'ff-find-other-file-other-window "find-file" "\
Visit the file you point at in another window.

(fn EVENT)" t)
(register-definition-prefixes "find-file" '("cc-" "ff-" "modula2-other-file-alist"))


;;; Generated autoloads from emacs-lisp/find-func.el

(autoload 'find-library "find-func" "\
Find the Emacs Lisp source of LIBRARY.

Interactively, prompt for LIBRARY using the one at or near point.

This function searches `find-library-source-path' if non-nil, and
`load-path' otherwise.

See the `find-library-include-other-files' user option for
customizing the candidate completions.

(fn LIBRARY)" t)
(autoload 'read-library-name "find-func" "\
Read and return a library name, defaulting to the one near point.

A library name is the filename of an Emacs Lisp library located
in a directory under `load-path' (or `find-library-source-path',
if non-nil).")
(autoload 'find-library-other-window "find-func" "\
Find the Emacs Lisp source of LIBRARY in another window.

See `find-library' for more details.

(fn LIBRARY)" t)
(autoload 'find-library-other-frame "find-func" "\
Find the Emacs Lisp source of LIBRARY in another frame.

See `find-library' for more details.

(fn LIBRARY)" t)
(autoload 'find-function-search-for-symbol "find-func" "\
Search for SYMBOL's definition of type TYPE in LIBRARY.
Visit the library in a buffer, and return a cons cell (BUFFER . POSITION),
or just (BUFFER . nil) if the definition can't be found in the file.

If TYPE is nil, look for a function definition.
Otherwise, TYPE specifies the kind of definition,
and it is interpreted via `find-function-regexp-alist'.
The search is done in the source for library LIBRARY.

(fn SYMBOL TYPE LIBRARY)")
(autoload 'find-function-noselect "find-func" "\
Return a pair (BUFFER . POINT) pointing to the definition of FUNCTION.

Finds the source file containing the definition of FUNCTION
in a buffer and the point of the definition.  The buffer is
not selected.  If the function definition can't be found in
the buffer, returns (BUFFER).

If FUNCTION is a built-in function, this function normally
attempts to find it in the Emacs C sources; however, if LISP-ONLY
is non-nil, signal an error instead.

(fn FUNCTION &optional LISP-ONLY)")
(autoload 'find-function "find-func" "\
Find the definition of the FUNCTION near point.

Finds the source file containing the definition of the function
near point (selected by `function-called-at-point') in a buffer and
places point before the definition.
Set mark before moving, if the buffer already existed.

See also `find-function-recenter-line' and `find-function-after-hook'.

(fn FUNCTION)" t)
(autoload 'find-function-other-window "find-func" "\
Find, in another window, the definition of FUNCTION near point.

See `find-function' for more details.

(fn FUNCTION)" t)
(autoload 'find-function-other-frame "find-func" "\
Find, in another frame, the definition of FUNCTION near point.

See `find-function' for more details.

(fn FUNCTION)" t)
(autoload 'find-variable-noselect "find-func" "\
Return a pair `(BUFFER . POINT)' pointing to the definition of VARIABLE.

Finds the library containing the definition of VARIABLE in a buffer and
the point of the definition.  The buffer is not selected.
If the variable's definition can't be found in the buffer, return (BUFFER).

(fn VARIABLE &optional FILE)")
(autoload 'find-variable "find-func" "\
Find the definition of the VARIABLE at or before point.

Finds the library containing the definition of the variable
near point (selected by `variable-at-point') in a buffer and
places point before the definition.

Set mark before moving, if the buffer already existed.

See also `find-function-recenter-line' and `find-function-after-hook'.

(fn VARIABLE)" t)
(autoload 'find-variable-other-window "find-func" "\
Find, in another window, the definition of VARIABLE near point.

See `find-variable' for more details.

(fn VARIABLE)" t)
(autoload 'find-variable-other-frame "find-func" "\
Find, in another frame, the definition of VARIABLE near point.

See `find-variable' for more details.

(fn VARIABLE)" t)
(autoload 'find-definition-noselect "find-func" "\
Return a pair `(BUFFER . POINT)' pointing to the definition of SYMBOL.
If the definition can't be found in the buffer, return (BUFFER).
TYPE says what type of definition: nil for a function, `defvar' for a
variable, `defface' for a face.  This function does not switch to the
buffer nor display it.

(fn SYMBOL TYPE &optional FILE)")
(autoload 'find-face-definition "find-func" "\
Find the definition of FACE.  FACE defaults to the name near point.

Finds the Emacs Lisp library containing the definition of the face
near point (selected by `variable-at-point') in a buffer and
places point before the definition.

Set mark before moving, if the buffer already existed.

See also `find-function-recenter-line' and `find-function-after-hook'.

(fn FACE)" t)
(autoload 'find-function-on-key "find-func" "\
Find the function that KEY invokes.  KEY is a string.
Set mark before moving, if the buffer already existed.

(fn KEY)" t)
(autoload 'find-function-on-key-other-window "find-func" "\
Find, in the other window, the function that KEY invokes.
See `find-function-on-key'.

(fn KEY)" t)
(autoload 'find-function-on-key-other-frame "find-func" "\
Find, in the other frame, the function that KEY invokes.
See `find-function-on-key'.

(fn KEY)" t)
(autoload 'find-function-at-point "find-func" "\
Find directly the function at point in the other window." t)
(autoload 'find-variable-at-point "find-func" "\
Find directly the variable at point in the other window." t)
(autoload 'find-function-setup-keys "find-func" "\
Define some key bindings for the `find-function' family of functions.")
(register-definition-prefixes "find-func" '("find-" "read-library-name--find-files"))


;;; Generated autoloads from find-lisp.el

(autoload 'find-lisp-find-dired "find-lisp" "\
Find the files within DIR whose names match REGEXP.
A Dired buffer with the results will be opened.

(fn DIR REGEXP)" t)
(autoload 'find-lisp-find-dired-subdirectories "find-lisp" "\
Find all subdirectories of DIR.

(fn DIR)" t)
(autoload 'find-lisp-find-dired-subdirs-other-window "find-lisp" "\
Same as `find-lisp-find-dired-subdirectories', but use another window.

(fn DIR)" t)
(autoload 'find-lisp-find-dired-filter "find-lisp" "\
Change the filter on a `find-lisp-find-dired' buffer to REGEXP.

(fn REGEXP)" t)
(register-definition-prefixes "find-lisp" '("find-lisp-"))


;;; Generated autoloads from finder.el

(autoload 'finder-list-keywords "finder" "\
Display descriptions of the keywords in the Finder buffer." t)
(autoload 'finder-commentary "finder" "\
Display FILE's commentary section.
FILE should be in a form suitable for passing to `locate-library'.

(fn FILE)" t)
(autoload 'finder-by-keyword "finder" "\
Find packages matching a given keyword." t)
(register-definition-prefixes "finder" '("finder-" "generated-finder-keywords-file"))


;;; Generated autoloads from flow-ctrl.el

(autoload 'enable-flow-control "flow-ctrl" "\
Toggle flow control handling.
When handling is enabled, user can type C-s as C-\\, and C-q as C-^.
With arg, enable flow control mode if arg is positive, otherwise disable.

(fn &optional ARGUMENT)" t)
(autoload 'enable-flow-control-on "flow-ctrl" "\
Enable flow control if using one of a specified set of terminal types.
Use `(enable-flow-control-on \"vt100\" \"h19\")' to enable flow control
on VT-100 and H19 terminals.  When flow control is enabled,
you must type C-\\ to get the effect of a C-s, and type C-^
to get the effect of a C-q.

(fn &rest LOSING-TERMINAL-TYPES)")
(register-definition-prefixes "flow-ctrl" '("flow-control-c-"))


;;; Generated autoloads from mail/flow-fill.el

(autoload 'fill-flowed-encode "flow-fill" "\


(fn &optional BUFFER)")
(autoload 'fill-flowed "flow-fill" "\
Apply RFC2646 decoding to BUFFER.
If BUFFER is nil, default to the current buffer.

If DELETE-SPACE, delete RFC2646 spaces padding at the end of
lines.

(fn &optional BUFFER DELETE-SPACE)")
(register-definition-prefixes "flow-fill" '("fill-flowed-"))


;;; Generated autoloads from progmodes/flymake.el

(push (purecopy '(flymake 1 3 7)) package--builtin-versions)
(autoload 'flymake-log "flymake" "\
Log, at level LEVEL, the message MSG formatted with ARGS.
LEVEL is passed to `display-warning', which is used to display
the warning.  If this form is included in a file,
the generated warning contains an indication of the file that
generated it.

(fn LEVEL MSG &rest ARGS)" nil t)
(autoload 'flymake-make-diagnostic "flymake" "\
Make a Flymake diagnostic for LOCUS's region from BEG to END.
LOCUS is a buffer object or a string designating a file name.

TYPE is a diagnostic symbol and TEXT is string describing the
problem detected in this region.  DATA is any object that the
caller wishes to attach to the created diagnostic for later
retrieval with `flymake-diagnostic-data'.

If LOCUS is a buffer BEG and END should be buffer positions
inside it.  If LOCUS designates a file, BEG and END should be a
cons (LINE . COL) indicating a file position.  In this second
case, END may be omitted in which case the region is computed
using `flymake-diag-region' if the diagnostic is appended to an
actual buffer.

OVERLAY-PROPERTIES is an alist of properties attached to the
created diagnostic, overriding the default properties and any
properties listed in the `flymake-overlay-control' property of
the diagnostic's type symbol.

(fn LOCUS BEG END TYPE TEXT &optional DATA OVERLAY-PROPERTIES)")
(autoload 'flymake-diagnostics "flymake" "\
Get Flymake diagnostics in region determined by BEG and END.

If neither BEG or END is supplied, use whole accessible buffer,
otherwise if BEG is non-nil and END is nil, consider only
diagnostics at BEG.

(fn &optional BEG END)")
(autoload 'flymake-diag-region "flymake" "\
Compute BUFFER's region (BEG . END) corresponding to LINE and COL.
If COL is nil, return a region just for LINE.  Return nil if the
region is invalid.  This function saves match data.

(fn BUFFER LINE &optional COL)")
(autoload 'flymake-mode "flymake" "\
Toggle Flymake mode on or off.

Flymake is an Emacs minor mode for on-the-fly syntax checking.
Flymake collects diagnostic information from multiple sources,
called backends, and visually annotates the buffer with the
results.

Flymake performs these checks while the user is editing.
The customization variables `flymake-start-on-flymake-mode',
`flymake-no-changes-timeout' determine the exact circumstances
whereupon Flymake decides to initiate a check of the buffer.

The commands `flymake-goto-next-error' and
`flymake-goto-prev-error' can be used to navigate among Flymake
diagnostics annotated in the buffer.

By default, `flymake-mode' doesn't override the \\[next-error] command, but
if you're using Flymake a lot (and don't use the regular compilation
mechanisms that often), it can be useful to put something like
the following in your init file:

  (setq next-error-function \\='flymake-goto-next-error)

The visual appearance of each type of diagnostic can be changed
by setting properties `flymake-overlay-control', `flymake-bitmap'
and `flymake-severity' on the symbols of diagnostic types (like
`:error', `:warning' and `:note').

Activation or deactivation of backends used by Flymake in each
buffer happens via the special hook
`flymake-diagnostic-functions'.

Some backends may take longer than others to respond or complete,
and some may decide to disable themselves if they are not
suitable for the current buffer.  The commands
`flymake-running-backends', `flymake-disabled-backends' and
`flymake-reporting-backends' summarize the situation, as does the
special *Flymake log* buffer.

This is a minor mode.  If called interactively, toggle the `Flymake
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `flymake-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

\\{flymake-mode-map}

(fn &optional ARG)" t)
(autoload 'flymake-mode-on "flymake" "\
Turn Flymake mode on.")
(autoload 'flymake-mode-off "flymake" "\
Turn Flymake mode off.")
(register-definition-prefixes "flymake" '("flymake-"))


;;; Generated autoloads from progmodes/flymake-cc.el

(autoload 'flymake-cc "flymake-cc" "\
Flymake backend for GNU-style C compilers.
This backend uses `flymake-cc-command' (which see) to launch a
process that is passed the current buffer's contents via stdin.
REPORT-FN is Flymake's callback.

(fn REPORT-FN &rest ARGS)")
(register-definition-prefixes "flymake-cc" '("flymake-cc-"))


;;; Generated autoloads from progmodes/flymake-proc.el

(push (purecopy '(flymake-proc 1 0)) package--builtin-versions)
(register-definition-prefixes "flymake-proc" '("flymake-proc-"))


;;; Generated autoloads from textmodes/flyspell.el

(autoload 'flyspell-prog-mode "flyspell" "\
Turn on `flyspell-mode' for comments and strings." t)
(defvar flyspell-mode nil "Non-nil if Flyspell mode is enabled.")
(autoload 'flyspell-mode "flyspell" "\
Toggle on-the-fly spell checking (Flyspell mode).

Flyspell mode is a buffer-local minor mode.  When enabled, it
spawns a single Ispell process and checks each word.  The default
flyspell behavior is to highlight incorrect words.

This mode is geared toward text modes.  In buffers that contain
code, `flyspell-prog-mode' is usually a better choice.

Bindings:
\\[ispell-word]: correct words (using Ispell).
\\[flyspell-auto-correct-word]: automatically correct word.
\\[flyspell-auto-correct-previous-word]: automatically correct the last misspelled word.
\\[flyspell-correct-word] (or down-mouse-2): popup correct words.

Hooks:
This runs `flyspell-mode-hook' after flyspell mode is entered or exit.

Remark:
`flyspell-mode' uses `ispell-mode'.  Thus all Ispell options are
valid.  For instance, a different dictionary can be used by
invoking `ispell-change-dictionary'.

Consider using the `ispell-parser' to check your text.  For instance
consider adding:
(add-hook \\='tex-mode-hook (lambda () (setq ispell-parser \\='tex)))
in your init file.

\\[flyspell-region] checks all words inside a region.
\\[flyspell-buffer] checks the whole buffer.

This is a minor mode.  If called interactively, toggle the `Flyspell
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `flyspell-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'turn-on-flyspell "flyspell" "\
Unconditionally turn on Flyspell mode.")
(autoload 'turn-off-flyspell "flyspell" "\
Unconditionally turn off Flyspell mode.")
(autoload 'flyspell--mode-off "flyspell" "\
Turn Flyspell mode off.")
(autoload 'flyspell-region "flyspell" "\
Flyspell text between BEG and END.

Make sure `flyspell-mode' is turned on if you want the highlight
of a misspelled word removed when you've corrected it.

(fn BEG END)" t)
(autoload 'flyspell-buffer "flyspell" "\
Flyspell whole buffer." t)
(register-definition-prefixes "flyspell" '("flyspell-" "mail-mode-flyspell-verify" "make-flyspell-overlay" "sgml-mode-flyspell-verify" "tex"))


;;; Generated autoloads from foldout.el

(push (purecopy '(foldout 1 10)) package--builtin-versions)
(register-definition-prefixes "foldout" '("foldout-"))


;;; Generated autoloads from follow.el

(autoload 'turn-on-follow-mode "follow" "\
Turn on Follow mode.  Please see the function `follow-mode'.")
(autoload 'turn-off-follow-mode "follow" "\
Turn off Follow mode.  Please see the function `follow-mode'.")
(autoload 'follow-mode "follow" "\
Toggle Follow mode.

Follow mode is a minor mode that combines windows into one tall
virtual window.  This is accomplished by two main techniques:

* The windows always displays adjacent sections of the buffer.
  This means that whenever one window is moved, all the
  others will follow.  (Hence the name Follow mode.)

* Should point (cursor) end up outside a window, another
  window displaying that point is selected, if possible.  This
  makes it possible to walk between windows using normal cursor
  movement commands.

Follow mode comes to its prime when used on a large screen and two or
more side-by-side windows are used.  The user can, with the help of
Follow mode, use these full-height windows as though they were one.
Imagine yourself editing a large function, or section of text, and
being able to use 144 or 216 lines instead of the normal 72... (your
mileage may vary).

To split one large window into two side-by-side windows, the commands
\\[split-window-right] or \\[follow-delete-other-windows-and-split] can be used.

Only windows displayed in the same frame follow each other.

This command runs the normal hook `follow-mode-hook'.

Keys specific to Follow mode:
\\{follow-mode-map}

This is a minor mode.  If called interactively, toggle the `Follow mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `follow-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'follow-scroll-up-window "follow" "\
Scroll text in a Follow mode window up by that window's size.
The other windows in the window chain will scroll synchronously.

If called with no ARG, the `next-screen-context-lines' last lines of
the window will be visible after the scroll.

If called with an argument, scroll ARG lines up.
Negative ARG means scroll downward.

Works like `scroll-up' when not in Follow mode.

(fn &optional ARG)" t)
(autoload 'follow-scroll-down-window "follow" "\
Scroll text in a Follow mode window down by that window's size.
The other windows in the window chain will scroll synchronously.

If called with no ARG, the `next-screen-context-lines' top lines of
the window in the chain will be visible after the scroll.

If called with an argument, scroll ARG lines down.
Negative ARG means scroll upward.

Works like `scroll-down' when not in Follow mode.

(fn &optional ARG)" t)
(autoload 'follow-scroll-up "follow" "\
Scroll text in a Follow mode window chain up.

If called with no ARG, the `next-screen-context-lines' last lines of
the bottom window in the chain will be visible in the top window.

If called with an argument, scroll ARG lines up.
Negative ARG means scroll downward.

Works like `scroll-up' when not in Follow mode.

(fn &optional ARG)" t)
(autoload 'follow-scroll-down "follow" "\
Scroll text in a Follow mode window chain down.

If called with no ARG, the `next-screen-context-lines' top lines of
the top window in the chain will be visible in the bottom window.

If called with an argument, scroll ARG lines down.
Negative ARG means scroll upward.

Works like `scroll-down' when not in Follow mode.

(fn &optional ARG)" t)
(autoload 'follow-delete-other-windows-and-split "follow" "\
Create two side by side windows and enter Follow mode.

Execute this command to display as much as possible of the text
in the selected window.  All other windows, in the current
frame, are deleted and the selected window is split in two
side-by-side windows.  Follow mode is activated, hence the
two windows always will display two successive pages.
(If one window is moved, the other one will follow.)

If ARG is positive, the leftmost window is selected.  If negative,
the rightmost is selected.  If ARG is nil, the leftmost window is
selected if the original window is the first one in the frame.

(fn &optional ARG)" t)
(register-definition-prefixes "follow" '("follow-"))


;;; Generated autoloads from international/fontset.el

(register-definition-prefixes "fontset" '("build-default-fontset-data" "charset-script-alist" "create-" "fontset-" "generate-fontset-menu" "set" "standard-fontset-spec" "x-" "xlfd-"))


;;; Generated autoloads from mail/footnote.el

(autoload 'footnote-mode "footnote" "\
Toggle Footnote mode.

Footnote mode is a buffer-local minor mode.  If enabled, it
provides footnote support for `message-mode'.  To get started,
play around with the following keys:
\\{footnote-minor-mode-map}

This is a minor mode.  If called interactively, toggle the `Footnote
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `footnote-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "footnote" '("footnote-"))


;;; Generated autoloads from cedet/semantic/format.el

(register-definition-prefixes "semantic/format" '("semantic-"))


;;; Generated autoloads from format-spec.el

(autoload 'format-spec "format-spec" "\
Return a string based on FORMAT and SPECIFICATION.
FORMAT is a string containing `format'-like specs like \"su - %u %k\".
SPECIFICATION is an alist mapping format specification characters
to their substitutions.

For instance:

  (format-spec \"su - %u %l\"
               \\=`((?u . ,(user-login-name))
                 (?l . \"ls\")))

Each %-spec may contain optional flag, width, and precision
specifiers, as follows:

  %<flags><width><precision>character

The following flags are allowed:

* 0: Pad to the width, if given, with zeros instead of spaces.
* -: Pad to the width, if given, on the right instead of the left.
* <: Truncate to the width and precision, if given, on the left.
* >: Truncate to the width and precision, if given, on the right.
* ^: Convert to upper case.
* _: Convert to lower case.

The width and precision specifiers behave like the corresponding
ones in `format' when applied to %s.

For example, \"%<010b\" means \"substitute into the output the
value associated with ?b in SPECIFICATION, either padding it with
leading zeros or truncating leading characters until it's ten
characters wide\".

the substitution for a specification character can also be a
function, taking no arguments and returning a string to be used
for the replacement.  It will only be called if FORMAT uses that
character.  For example:

  (format-spec \"%n\"
               \\=`((?n . ,(lambda ()
                          (read-number \"Number: \")))))

Note that it is best to make sure the function is not quoted,
like above, so that it is compiled by the byte-compiler.

Any text properties of FORMAT are copied to the result, with any
text properties of a %-spec itself copied to its substitution.

IGNORE-MISSING indicates how to handle %-spec characters not
present in SPECIFICATION.  If it is nil or omitted, emit an
error; if it is the symbol `ignore', leave those %-specs verbatim
in the result, including their text properties, if any; if it is
the symbol `delete', remove those %-specs from the result;
otherwise do the same as for the symbol `ignore', but also leave
any occurrences of \"%%\" in FORMAT verbatim in the result.

If SPLIT, instead of returning a single string, a list of strings
is returned, where each format spec is its own element.

(fn FORMAT SPECIFICATION &optional IGNORE-MISSING SPLIT)")
(register-definition-prefixes "format-spec" '("format-spec-"))


;;; Generated autoloads from forms.el

(autoload 'forms-mode "forms" "\
Major mode to visit files in a field-structured manner using a form.

Commands:                        Equivalent keys in read-only mode:
 TAB            forms-next-field          TAB
 C-c TAB        forms-next-field
 C-c <          forms-first-record         <
 C-c >          forms-last-record          >
 C-c ?          describe-mode              ?
 C-c C-k        forms-delete-record
 C-c C-q        forms-toggle-read-only     q
 C-c C-o        forms-insert-record
 C-c C-l        forms-jump-record          l
 C-c C-n        forms-next-record          n
 C-c C-p        forms-prev-record          p
 C-c C-r        forms-search-reverse       r
 C-c C-s        forms-search-forward       s
 C-c C-x        forms-exit                 x

(fn &optional PRIMARY)" t)
(autoload 'forms-find-file "forms" "\
Visit a file in Forms mode.

(fn FN)" t)
(autoload 'forms-find-file-other-window "forms" "\
Visit a file in Forms mode in other window.

(fn FN)" t)
(register-definition-prefixes "forms" '("forms-"))


;;; Generated autoloads from progmodes/fortran.el

(autoload 'fortran-mode "fortran" "\
Major mode for editing Fortran code in fixed format.
For free format code, use `f90-mode'.

\\[fortran-indent-line] indents the current Fortran line correctly.
Note that DO statements must not share a common CONTINUE.

Type ;? or ;\\[help-command] to display a list of built-in abbrevs for Fortran keywords.

Key definitions:
\\{fortran-mode-map}

Variables controlling indentation style and extra features:

`fortran-comment-line-start'
  To use comments starting with `!', set this to the string \"!\".
`fortran-do-indent'
  Extra indentation within DO blocks (default 3).
`fortran-if-indent'
  Extra indentation within IF blocks (default 3).
`fortran-structure-indent'
  Extra indentation within STRUCTURE, UNION, MAP and INTERFACE blocks.
  (default 3)
`fortran-continuation-indent'
  Extra indentation applied to continuation statements (default 5).
`fortran-comment-line-extra-indent'
  Amount of extra indentation for text in full-line comments (default 0).
`fortran-comment-indent-style'
  How to indent the text in full-line comments.  Allowed values are:
  nil         don't change the indentation
  `fixed'     indent to `fortran-comment-line-extra-indent' beyond the
              value of either
                `fortran-minimum-statement-indent-fixed' (fixed format) or
                `fortran-minimum-statement-indent-tab' (TAB format),
              depending on the continuation format in use.
  `relative'  indent to `fortran-comment-line-extra-indent' beyond the
              indentation for a line of code.
  (default `fixed')
`fortran-comment-indent-char'
  Single-character string to be inserted instead of space for
  full-line comment indentation (default \" \").
`fortran-minimum-statement-indent-fixed'
  Minimum indentation for statements in fixed format mode (default 6).
`fortran-minimum-statement-indent-tab'
  Minimum indentation for statements in TAB format mode (default 9).
`fortran-line-number-indent'
  Maximum indentation for line numbers (default 1).  A line number will
  get less than this much indentation if necessary to avoid reaching
  column 5.
`fortran-check-all-num-for-matching-do'
  Non-nil causes all numbered lines to be treated as possible \"continue\"
  statements (default nil).
`fortran-blink-matching-if'
  Non-nil causes \\[fortran-indent-line] on an ENDIF (or ENDDO) statement
  to blink on the matching IF (or DO [WHILE]).  (default nil)
`fortran-continuation-string'
  Single-character string to be inserted in column 5 of a continuation
  line (default \"$\").
`fortran-comment-region'
  String inserted by \\[fortran-comment-region] at start of each line in
  the region (default \"c$$$\").
`fortran-electric-line-number'
  Non-nil causes line number digits to be moved to the correct column
  as typed (default t).
`fortran-break-before-delimiters'
  Non-nil causes lines to be broken before delimiters (default t).

Turning on Fortran mode calls the value of the variable `fortran-mode-hook'
with no args, if that value is non-nil.

(fn)" t)
(register-definition-prefixes "fortran" '("fortran-"))


;;; Generated autoloads from play/fortune.el

(autoload 'fortune-add-fortune "fortune" "\
Add STRING to a fortune file FILE.

Interactively, if called with a prefix argument,
read the file name to use.  Otherwise use the value of `fortune-file'.

(fn STRING FILE)" t)
(autoload 'fortune-from-region "fortune" "\
Append the current region to a local fortune-like data file.

Interactively, if called with a prefix argument,
read the file name to use.  Otherwise use the value of `fortune-file'.

(fn BEG END FILE)" t)
(autoload 'fortune-compile "fortune" "\
Compile fortune file.

If called with a prefix asks for the FILE to compile, otherwise uses
the value of `fortune-file'.  This currently cannot handle directories.

(fn &optional FILE)" t)
(autoload 'fortune-to-signature "fortune" "\
Create signature from output of the fortune program.

If called with a prefix asks for the FILE to choose the fortune from,
otherwise uses the value of `fortune-file'.  If you want to have fortune
choose from a set of files in a directory, call interactively with prefix
and choose the directory as the fortune-file.

(fn &optional FILE)" t)
(autoload 'fortune-message "fortune" "\
Display a fortune cookie to the mini-buffer.
If called with a prefix, it has the same behavior as `fortune'.
Optional FILE is a fortune file from which a cookie will be selected.

(fn &optional FILE)" t)
(autoload 'fortune "fortune" "\
Display a fortune cookie.
If called with a prefix asks for the FILE to choose the fortune from,
otherwise uses the value of `fortune-file'.  If you want to have fortune
choose from a set of files in a directory, call interactively with prefix
and choose the directory as the fortune-file.

(fn &optional FILE)" t)
(register-definition-prefixes "fortune" '("fortune-"))


;;; Generated autoloads from frameset.el

(defvar frameset-session-filter-alist (append '((left . frameset-filter-iconified) (minibuffer . frameset-filter-minibuffer) (top . frameset-filter-iconified)) (mapcar (lambda (p) (cons p :never)) frame-internal-parameters)) "\
Minimum set of parameters to filter for live (on-session) framesets.
DO NOT MODIFY.  See `frameset-filter-alist' for a full description.")
(defvar frameset-persistent-filter-alist (append '((background-color . frameset-filter-sanitize-color) (bottom . frameset-filter-shelve-param) (buffer-list . :never) (buffer-predicate . :never) (buried-buffer-list . :never) (client . :never) (delete-before . :never) (font . frameset-filter-font-param) (font-backend . :never) (foreground-color . frameset-filter-sanitize-color) (frameset--text-pixel-height . :save) (frameset--text-pixel-width . :save) (fullscreen . frameset-filter-shelve-param) (GUI:bottom . frameset-filter-unshelve-param) (GUI:font . frameset-filter-unshelve-param) (GUI:fullscreen . frameset-filter-unshelve-param) (GUI:height . frameset-filter-unshelve-param) (GUI:left . frameset-filter-unshelve-param) (GUI:right . frameset-filter-unshelve-param) (GUI:top . frameset-filter-unshelve-param) (GUI:width . frameset-filter-unshelve-param) (height . frameset-filter-shelve-param) (left . frameset-filter-shelve-param) (parent-frame . :never) (mouse-wheel-frame . :never) (right . frameset-filter-shelve-param) (top . frameset-filter-shelve-param) (tty . frameset-filter-tty-to-GUI) (tty-type . frameset-filter-tty-to-GUI) (width . frameset-filter-shelve-param) (window-system . :never)) frameset-session-filter-alist) "\
Parameters to filter for persistent framesets.
DO NOT MODIFY.  See `frameset-filter-alist' for a full description.")
(defvar frameset-filter-alist frameset-persistent-filter-alist "\
Alist of frame parameters and filtering functions.

This alist is the default value of the FILTERS argument of
`frameset-save' and `frameset-restore' (which see).

Initially, `frameset-filter-alist' is set to, and shares the value of,
`frameset-persistent-filter-alist'.  You can override any item in
this alist by `push'ing a new item onto it.  If, for some reason, you
intend to modify existing values, do

  (setq frameset-filter-alist (copy-tree frameset-filter-alist))

before changing anything.

On saving, PARAMETERS is the parameter alist of each frame processed,
and FILTERED is the parameter alist that gets saved to the frameset.

On restoring, PARAMETERS is the parameter alist extracted from the
frameset, and FILTERED is the resulting frame parameter alist used
to restore the frame.

Elements of `frameset-filter-alist' are conses (PARAM . ACTION),
where PARAM is a parameter name (a symbol identifying a frame
parameter), and ACTION can be:

 nil       The parameter is copied to FILTERED.
 :never    The parameter is never copied to FILTERED.
 :save     The parameter is copied only when saving the frame.
 :restore  The parameter is copied only when restoring the frame.
 FILTER    A filter function.

FILTER can be a symbol FILTER-FUN, or a list (FILTER-FUN ARGS...).
FILTER-FUN is invoked with

  (apply FILTER-FUN CURRENT FILTERED PARAMETERS SAVING ARGS)

where

 CURRENT     A cons (PARAM . VALUE), where PARAM is the one being
	     filtered and VALUE is its current value.
 FILTERED    The resulting alist (so far).
 PARAMETERS  The complete alist of parameters being filtered,
 SAVING      Non-nil if filtering before saving state, nil if filtering
	       before restoring it.
 ARGS        Any additional arguments specified in the ACTION.

FILTER-FUN is allowed to modify items in FILTERED, but no other arguments.
It must return:
 nil                      Skip CURRENT (do not add it to FILTERED).
 t                        Add CURRENT to FILTERED as is.
 (NEW-PARAM . NEW-VALUE)  Add this to FILTERED instead of CURRENT.

Frame parameters not on this alist are passed intact, as if they were
defined with ACTION = nil.")
(autoload 'frameset-frame-id "frameset" "\
Return the frame id of FRAME, if it has one; else, return nil.
A frame id is a string that uniquely identifies a frame.
It is persistent across `frameset-save' / `frameset-restore'
invocations, and once assigned is never changed unless the same
frame is duplicated (via `frameset-restore'), in which case the
newest frame keeps the id and the old frame's is set to nil.

(fn FRAME)")
(autoload 'frameset-frame-id-equal-p "frameset" "\
Return non-nil if FRAME's id matches ID.

(fn FRAME ID)")
(autoload 'frameset-frame-with-id "frameset" "\
Return the live frame with id ID, if exists; else nil.
If FRAME-LIST is a list of frames, check these frames only.
If nil, check all live frames.

(fn ID &optional FRAME-LIST)")
(autoload 'frameset-save "frameset" "\
Return a frameset for FRAME-LIST, a list of frames.
Dead frames and non-frame objects are silently removed from the list.
If nil, FRAME-LIST defaults to the output of `frame-list' (all live frames).
APP, NAME and DESCRIPTION are optional data; see the docstring of the
`frameset' defstruct for details.
FILTERS is an alist of parameter filters; if nil, the value of the variable
`frameset-filter-alist' is used instead.
PREDICATE is a predicate function, which must return non-nil for frames that
should be saved; if PREDICATE is nil, all frames from FRAME-LIST are saved.
PROPERTIES is a user-defined property list to add to the frameset.

(fn FRAME-LIST &key APP NAME DESCRIPTION FILTERS PREDICATE PROPERTIES)")
(autoload 'frameset-restore "frameset" "\
Restore a FRAMESET into the current display(s).

PREDICATE is a function called with two arguments, the parameter alist
and the window-state of the frame being restored, in that order (see
the docstring of the `frameset' defstruct for additional details).
If PREDICATE returns nil, the frame described by that parameter alist
and window-state is not restored.

FILTERS is an alist of parameter filters; if nil, the value of
`frameset-filter-alist' is used instead.

REUSE-FRAMES selects the policy to reuse frames when restoring:
  t        All existing frames can be reused.
  nil      No existing frame can be reused.
  match    Only frames with matching frame ids can be reused.
  PRED     A predicate function; it receives as argument a live frame,
             and must return non-nil to allow reusing it, nil otherwise.

FORCE-DISPLAY can be:
  t        Frames are restored in the current display.
  nil      Frames are restored, if possible, in their original displays.
  delete   Frames in other displays are deleted instead of restored.
  PRED     A function called with two arguments, the parameter alist and
	     the window state (in that order).  It must return t, nil or
	     `delete', as above but affecting only the frame that will
	     be created from that parameter alist.

FORCE-ONSCREEN can be:
  t        Force onscreen only those frames that are fully offscreen.
  nil      Do not force any frame back onscreen.
  all      Force onscreen any frame fully or partially offscreen.
  PRED     A function called with three arguments,
	   - the live frame just restored,
	   - a list (LEFT TOP WIDTH HEIGHT), describing the frame,
	   - a list (LEFT TOP WIDTH HEIGHT), describing the workarea.
	   It must return non-nil to force the frame onscreen, nil otherwise.

CLEANUP-FRAMES allows \"cleaning up\" the frame list after
restoring a frameset:
  t        Delete all frames that were not created or restored upon.
  nil      Keep all frames.
  FUNC     A function called with two arguments:
           - FRAME, a live frame.
           - ACTION, which can be one of
             :rejected  Frame existed, but was not a candidate for reuse.
             :ignored   Frame existed, was a candidate, but wasn't reused.
             :reused    Frame existed, was a candidate, and restored upon.
             :created   Frame didn't exist, was created and restored upon.
           Return value is ignored.

Note the timing and scope of the operations described above: REUSE-FRAMES
affects existing frames; PREDICATE, FILTERS and FORCE-DISPLAY affect the frame
being restored before that happens; FORCE-ONSCREEN affects the frame once
it has been restored; and CLEANUP-FRAMES affects all frames alive after the
restoration, including those that have been reused or created anew.

All keyword parameters default to nil.

(fn FRAMESET &key PREDICATE FILTERS REUSE-FRAMES FORCE-DISPLAY FORCE-ONSCREEN CLEANUP-FRAMES)")
(autoload 'frameset-to-register "frameset" "\
Store the current frameset in register REGISTER.
Use \\[jump-to-register] to restore the frameset.
Argument is a character, naming the register.

Interactively, reads the register using `register-read-with-preview'.

(fn REGISTER)" t)
(register-definition-prefixes "frameset" '("frameset-"))


;;; Generated autoloads from fringe.el

(unless (fboundp 'define-fringe-bitmap) (defun define-fringe-bitmap (_bitmap _bits &optional _height _width _align) "Define fringe bitmap BITMAP from BITS of size HEIGHT x WIDTH.
BITMAP is a symbol identifying the new fringe bitmap.
BITS is either a string or a vector of integers.
HEIGHT is height of bitmap.  If HEIGHT is nil, use length of BITS.
WIDTH must be an integer between 1 and 16, or nil which defaults to 8.
Optional fifth arg ALIGN may be one of `top', `center', or `bottom',
indicating the positioning of the bitmap relative to the rows where it
is used; the default is to center the bitmap.  Fifth arg may also be a
list (ALIGN PERIODIC) where PERIODIC non-nil specifies that the bitmap
should be repeated.
If BITMAP already exists, the existing definition is replaced."))
(register-definition-prefixes "fringe" '("fringe-" "set-fringe-"))


;;; Generated autoloads from cedet/semantic/fw.el

(register-definition-prefixes "semantic/fw" '("semantic"))


;;; Generated autoloads from play/gamegrid.el

(register-definition-prefixes "gamegrid" '("gamegrid-"))


;;; Generated autoloads from play/gametree.el

(register-definition-prefixes "gametree" '("gametree-"))


;;; Generated autoloads from cedet/semantic/bovine/gcc.el

(register-definition-prefixes "semantic/bovine/gcc" '("semantic-"))


;;; Generated autoloads from progmodes/gdb-mi.el

(defvar gdb-enable-debug nil "\
Non-nil if Gdb-Enable-Debug mode is enabled.
See the `gdb-enable-debug' command
for a description of this minor mode.")
(custom-autoload 'gdb-enable-debug "gdb-mi" nil)
(autoload 'gdb-enable-debug "gdb-mi" "\
Toggle logging of transaction between Emacs and Gdb.

The log is stored in `gdb-debug-log' as an alist with elements
whose cons is send, send-item or recv and whose cdr is the string
being transferred.  This list may grow up to a size of
`gdb-debug-log-max' after which the oldest element (at the end of
the list) is deleted every time a new one is added (at the front).

This is a global minor mode.  If called interactively, toggle the
`Gdb-Enable-Debug mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='gdb-enable-debug)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'gdb "gdb-mi" "\
Run gdb passing it COMMAND-LINE as arguments.

If COMMAND-LINE names a program FILE to debug, gdb will run in
a buffer named *gud-FILE*, and the directory containing FILE
becomes the initial working directory and source-file directory
for your debugger.
If COMMAND-LINE requests that gdb attaches to a process PID, gdb
will run in *gud-PID*, otherwise it will run in *gud*; in these
cases the initial working directory is the `default-directory' of
the buffer in which this command was invoked.

COMMAND-LINE should include \"-i=mi\" to use gdb's MI text interface.
Note that the old \"--annotate\" option is no longer supported.

If option `gdb-many-windows' is nil (the default value) then gdb just
pops up the GUD buffer unless `gdb-show-main' is t.  In this case
it starts with two windows: one displaying the GUD buffer and the
other with the source file with the main routine of the inferior.

If option `gdb-many-windows' is t, regardless of the value of
`gdb-show-main', the layout below will appear.  Keybindings are
shown in some of the buffers.

Watch expressions appear in the speedbar/slowbar.

The following commands help control operation :

`gdb-many-windows'    - Toggle the number of windows gdb uses.
`gdb-restore-windows' - To restore the window layout.

See Info node `(emacs)GDB Graphical Interface' for a more
detailed description of this mode.


+----------------------------------------------------------------------+
|                               GDB Toolbar                            |
+-----------------------------------+----------------------------------+
| GUD buffer (I/O of GDB)           | Locals buffer                    |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
+-----------------------------------+----------------------------------+
| Source buffer                     | I/O buffer (of debugged program) |
|                                   | (comint-mode)                    |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
+-----------------------------------+----------------------------------+
| Stack buffer                      | Breakpoints buffer               |
| RET      gdb-select-frame         | SPC    gdb-toggle-breakpoint     |
|                                   | RET    gdb-goto-breakpoint       |
|                                   | D      gdb-delete-breakpoint     |
+-----------------------------------+----------------------------------+

(fn COMMAND-LINE)" t)
(register-definition-prefixes "gdb-mi" '("breakpoint" "def-gdb-" "gdb" "gud-" "hollow-right-triangle"))


;;; Generated autoloads from emacs-lisp/generator.el

(register-definition-prefixes "generator" '("cps-" "iter-"))


;;; Generated autoloads from emacs-lisp/generic.el

(defvar generic-mode-list nil "\
A list of mode names for `generic-mode'.
Do not add entries to this list directly; use `define-generic-mode'
instead (which see).")
(autoload 'define-generic-mode "generic" "\
Create a new generic mode MODE.

A \"generic\" mode is a simple major mode with basic support for
comment syntax and Font Lock mode, but otherwise does not have
any special keystrokes or functionality available.

MODE is the name of the command for the generic mode; don't quote it.
The optional DOCSTRING is the documentation for the mode command.  If
you do not supply it, `define-generic-mode' uses a default
documentation string instead.

COMMENT-LIST is a list in which each element is either a character, a
string of one or two characters, or a cons cell.  A character or a
string is set up in the mode's syntax table as a \"comment starter\".
If the entry is a cons cell, the `car' is set up as a \"comment
starter\" and the `cdr' as a \"comment ender\".  (Use nil for the
latter if you want comments to end at the end of the line.)  Note that
the syntax table has limitations about what comment starters and
enders are actually possible.

KEYWORD-LIST is a list of keywords to highlight with
`font-lock-keyword-face'.  Each keyword should be a string.

FONT-LOCK-LIST is a list of additional expressions to highlight.  Each
element of this list should have the same form as an element of
`font-lock-keywords'.

AUTO-MODE-LIST is a list of regular expressions to add to
`auto-mode-alist'.  These regular expressions are added when Emacs
runs the macro expansion.

FUNCTION-LIST is a list of functions to call to do some additional
setup.  The mode command calls these functions just before it runs the
mode hook `MODE-hook'.

See the file generic-x.el for some examples of `define-generic-mode'.

(fn MODE COMMENT-LIST KEYWORD-LIST FONT-LOCK-LIST AUTO-MODE-LIST FUNCTION-LIST &optional DOCSTRING)" nil t)
(function-put 'define-generic-mode 'lisp-indent-function 1)
(function-put 'define-generic-mode 'doc-string-elt 7)
(autoload 'generic-mode-internal "generic" "\
Go into the generic mode MODE.

(fn MODE COMMENT-LIST KEYWORD-LIST FONT-LOCK-LIST FUNCTION-LIST)")
(autoload 'generic-mode "generic" "\
Enter generic mode MODE.

Generic modes provide basic comment and font-lock functionality
for \"generic\" files.  (Files which are too small to warrant their
own mode, but have comment characters, keywords, and the like.)

To define a generic-mode, use the function `define-generic-mode'.
Some generic modes are defined in `generic-x.el'.

(fn MODE)" t)
(autoload 'generic-make-keywords-list "generic" "\
Return a `font-lock-keywords' construct that highlights KEYWORD-LIST.
KEYWORD-LIST is a list of keyword strings that should be
highlighted with face FACE.  This function calculates a regular
expression that matches these keywords and concatenates it with
PREFIX and SUFFIX.  Then it returns a construct based on this
regular expression that can be used as an element of
`font-lock-keywords'.

(fn KEYWORD-LIST FACE &optional PREFIX SUFFIX)")
(make-obsolete 'generic-make-keywords-list 'regexp-opt "24.4")
(register-definition-prefixes "generic" '("generic-"))


;;; Generated autoloads from cedet/ede/generic.el

(register-definition-prefixes "ede/generic" '("ede-generic-"))


;;; Generated autoloads from cedet/srecode/getset.el

(register-definition-prefixes "srecode/getset" '("srecode-"))


;;; Generated autoloads from progmodes/glasses.el

(autoload 'glasses-mode "glasses" "\
Minor mode for making identifiers likeThis readable.

When this mode is active, it tries to add virtual
separators (like underscores) at places they belong to.

This is a minor mode.  If called interactively, toggle the `Glasses
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `glasses-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "glasses" '("glasses-"))


;;; Generated autoloads from cedet/semantic/symref/global.el

(register-definition-prefixes "semantic/symref/global" '("semantic-symref-global--line-re"))


;;; Generated autoloads from textmodes/glyphless-mode.el

(autoload 'glyphless-display-mode "glyphless-mode" "\
Minor mode for displaying glyphless characters in the current buffer.

If enabled, all glyphless characters will be displayed as boxes
that display their acronyms.

This is a minor mode.  If called interactively, toggle the
`Glyphless-Display mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `glyphless-display-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "glyphless-mode" '("glyphless-mode-"))


;;; Generated autoloads from gnus/gmm-utils.el

(autoload 'gmm-regexp-concat "gmm-utils" "\
Potentially concat a list of regexps into a single one.
The concatenation is done with logical ORs.

(fn REGEXP)")
(autoload 'gmm-message "gmm-utils" "\
If LEVEL is lower than `gmm-verbose' print ARGS using `message'.

Guideline for numbers:
1 - error messages
3 - non-serious error messages
5 - messages for things that take a long time
7 - not very important messages on stuff
9 - messages inside loops.

(fn LEVEL &rest ARGS)")
(autoload 'gmm-error "gmm-utils" "\
Beep an error if LEVEL is equal to or less than `gmm-verbose'.
ARGS are passed to `message'.

(fn LEVEL &rest ARGS)")
(autoload 'gmm-widget-p "gmm-utils" "\
Non-nil if SYMBOL is a widget.

(fn SYMBOL)")
(autoload 'gmm-tool-bar-from-list "gmm-utils" "\
Make a tool bar from ICON-LIST.

Within each entry of ICON-LIST, the first element is a menu
command, the second element is an icon file name and the third
element is a test function.  You can use \\[describe-key]
<menu-entry> to find out the name of a menu command.  The fourth
and all following elements are passed as the PROPS argument to the
function `tool-bar-local-item'.

If ZAP-LIST is a list, remove those item from the default
`tool-bar-map'.  If it is t, start with a new sparse map.  You
can use \\[describe-key] <icon> to find out the name of an icon
item.  When \\[describe-key] <icon> shows \"<tool-bar> <new-file>
runs the command find-file\", then use `new-file' in ZAP-LIST.

DEFAULT-MAP specifies the default key map for ICON-LIST.

(fn ICON-LIST ZAP-LIST DEFAULT-MAP)")
(register-definition-prefixes "gmm-utils" '("defun-gmm" "gmm-"))


;;; Generated autoloads from gnus/gnus.el

(push (purecopy '(gnus 5 13)) package--builtin-versions)
(custom-autoload 'gnus-select-method "gnus")
(autoload 'gnus-child-no-server "gnus" "\
Read network news as a child, without connecting to the local server.

(fn &optional ARG)" t)
(autoload 'gnus-slave-no-server "gnus" "\
Read network news as a child, without connecting to the local server.

(fn &optional ARG)" t)
(autoload 'gnus-no-server "gnus" "\
Read network news.
If ARG is a positive number, Gnus will use that as the startup level.
If ARG is nil, Gnus will be started at level 2.  If ARG is non-nil
and not a positive number, Gnus will prompt the user for the name of
an NNTP server to use.
As opposed to `gnus', this command will not connect to the local
server.

(fn &optional ARG CHILD)" t)
(autoload 'gnus-child "gnus" "\
Read news as a child.

(fn &optional ARG)" t)
(autoload 'gnus-slave "gnus" "\
Read news as a child.

(fn &optional ARG)" t)
(autoload 'gnus-other-frame "gnus" "\
Pop up a frame to read news.
This will call one of the Gnus commands which is specified by the user
option `gnus-other-frame-function' (default `gnus') with the argument
ARG if Gnus is not running, otherwise pop up a Gnus frame and run the
command specified by `gnus-other-frame-resume-function'.
The optional second argument DISPLAY should be a standard display string
such as \"unix:0\" to specify where to pop up a frame.  If DISPLAY is
omitted or the function `make-frame-on-display' is not available, the
current display is used.

(fn &optional ARG DISPLAY)" t)
(autoload 'gnus "gnus" "\
Read network news.
If ARG is non-nil and a positive number, Gnus will use that as the
startup level.  If ARG is non-nil and not a positive number, Gnus will
prompt the user for the name of an NNTP server to use.

(fn &optional ARG DONT-CONNECT CHILD)" t)
(register-definition-prefixes "gnus" '("gnus-"))


;;; Generated autoloads from gnus/gnus-agent.el

(autoload 'gnus-unplugged "gnus-agent" "\
Start Gnus unplugged." t)
(autoload 'gnus-plugged "gnus-agent" "\
Start Gnus plugged." t)
(autoload 'gnus-child-unplugged "gnus-agent" "\
Read news as a child unplugged.

(fn &optional ARG)" t)
(autoload 'gnus-slave-unplugged "gnus-agent" "\
Read news as a child unplugged.

(fn &optional ARG)" t)
(autoload 'gnus-agentize "gnus-agent" "\
Allow Gnus to be an offline newsreader.

The `gnus-agentize' function is now called internally by gnus when
`gnus-agent' is set.  If you wish to avoid calling `gnus-agentize',
customize `gnus-agent' to nil.

This will modify the `gnus-setup-news-hook', and
`message-send-mail-real-function' variables, and install the Gnus agent
minor mode in all Gnus buffers." t)
(autoload 'gnus-agent-possibly-save-gcc "gnus-agent" "\
Save GCC if Gnus is unplugged.")
(autoload 'gnus-agent-rename-group "gnus-agent" "\
Rename fully-qualified OLD-GROUP as NEW-GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group renaming is
supported.

(fn OLD-GROUP NEW-GROUP)")
(autoload 'gnus-agent-delete-group "gnus-agent" "\
Delete fully-qualified GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group deletion is
supported.

(fn GROUP)")
(autoload 'gnus-agent-get-undownloaded-list "gnus-agent" "\
Construct list of articles that have not been downloaded.")
(autoload 'gnus-agent-possibly-alter-active "gnus-agent" "\
Possibly expand a group's active range to include articles
downloaded into the agent.

(fn GROUP ACTIVE &optional INFO)")
(autoload 'gnus-agent-find-parameter "gnus-agent" "\
Search for GROUPs SYMBOL in the group's parameters, the group's
topic parameters, the group's category, or the customizable
variables.  Returns the first non-nil value found.

(fn GROUP SYMBOL)")
(autoload 'gnus-agent-batch-fetch "gnus-agent" "\
Start Gnus and fetch session." t)
(autoload 'gnus-agent-batch "gnus-agent" "\
Start Gnus, send queue and fetch session." t)
(autoload 'gnus-agent-regenerate "gnus-agent" "\
Regenerate all agent covered files.
CLEAN is obsolete and ignored.

(fn &optional CLEAN REREAD)" t)
(register-definition-prefixes "gnus-agent" '("gnus-"))


;;; Generated autoloads from gnus/gnus-art.el

(autoload 'gnus-article-prepare-display "gnus-art" "\
Make the current buffer look like a nice article.")
(register-definition-prefixes "gnus-art" '("article-" "gnus-"))


;;; Generated autoloads from gnus/gnus-async.el

(register-definition-prefixes "gnus-async" '("gnus-"))


;;; Generated autoloads from gnus/gnus-bcklg.el

(register-definition-prefixes "gnus-bcklg" '("gnus-backlog-"))


;;; Generated autoloads from gnus/gnus-bookmark.el

(autoload 'gnus-bookmark-set "gnus-bookmark" "\
Set a bookmark for this article." '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-bookmark-jump "gnus-bookmark" "\
Jump to a Gnus bookmark (BMK-NAME).

(fn &optional BMK-NAME)" t)
(autoload 'gnus-bookmark-bmenu-list "gnus-bookmark" "\
Display a list of existing Gnus bookmarks.
The list is displayed in a buffer named `*Gnus Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying." t)
(register-definition-prefixes "gnus-bookmark" '("gnus-bookmark-"))


;;; Generated autoloads from gnus/gnus-cache.el

(autoload 'gnus-jog-cache "gnus-cache" "\
Go through all groups and put the articles into the cache.

Usage:
$ emacs -batch -l ~/.emacs -l gnus -f gnus-jog-cache" t)
(autoload 'gnus-cache-generate-active "gnus-cache" "\
Generate the cache active file.

(fn &optional DIRECTORY)" t)
(autoload 'gnus-cache-generate-nov-databases "gnus-cache" "\
Generate NOV files recursively starting in DIR.

(fn DIR)" t)
(autoload 'gnus-cache-rename-group "gnus-cache" "\
Rename OLD-GROUP as NEW-GROUP.
Always updates the cache, even when disabled, as the old cache
files would corrupt Gnus when the cache was next enabled.  It
depends on the caller to determine whether group renaming is
supported.

(fn OLD-GROUP NEW-GROUP)")
(autoload 'gnus-cache-delete-group "gnus-cache" "\
Delete GROUP from the cache.
Always updates the cache, even when disabled, as the old cache
files would corrupt gnus when the cache was next enabled.
Depends upon the caller to determine whether group deletion is
supported.

(fn GROUP)")
(register-definition-prefixes "gnus-cache" '("gnus-"))


;;; Generated autoloads from gnus/gnus-cite.el

(register-definition-prefixes "gnus-cite" '("gnus-" "turn-o"))


;;; Generated autoloads from gnus/gnus-cloud.el

(register-definition-prefixes "gnus-cloud" '("gnus-cloud-"))


;;; Generated autoloads from gnus/gnus-cus.el

(register-definition-prefixes "gnus-cus" '("category-fields" "gnus-"))


;;; Generated autoloads from gnus/gnus-dbus.el

(register-definition-prefixes "gnus-dbus" '("gnus-dbus-"))


;;; Generated autoloads from gnus/gnus-delay.el

(autoload 'gnus-delay-article "gnus-delay" "\
Delay this article by some time.
DELAY is a string, giving the length of the time.  Possible values are:

* <digits><units> for <units> in minutes (`m'), hours (`h'), days (`d'),
  weeks (`w'), months (`M'), or years (`Y');

* YYYY-MM-DD for a specific date.  The time of day is given by the
  variable `gnus-delay-default-hour', minute and second are zero.

* hh:mm for a specific time.  Use 24h format.  If it is later than this
  time, then the deadline is tomorrow, else today.

The value of `message-draft-headers' determines which headers are
generated when the article is delayed.  Remaining headers are
generated when the article is sent.

(fn DELAY)" '(message-mode))
(autoload 'gnus-delay-send-queue "gnus-delay" "\
Send all the delayed messages that are due now." t)
(autoload 'gnus-delay-initialize "gnus-delay" "\
Initialize the gnus-delay package.
This sets up a key binding in `message-mode' to delay a message.
This tells Gnus to look for delayed messages after getting new news.

The optional arg NO-KEYMAP is ignored.
Checking delayed messages is skipped if optional arg NO-CHECK is non-nil.

(fn &optional NO-KEYMAP NO-CHECK)")
(register-definition-prefixes "gnus-delay" '("gnus-delay-"))


;;; Generated autoloads from gnus/gnus-demon.el

(register-definition-prefixes "gnus-demon" '("gnus-"))


;;; Generated autoloads from gnus/gnus-diary.el

(autoload 'gnus-user-format-function-d "gnus-diary" "\


(fn HEADER)")
(autoload 'gnus-user-format-function-D "gnus-diary" "\


(fn HEADER)")
(register-definition-prefixes "gnus-diary" '("gnus-"))


;;; Generated autoloads from gnus/gnus-dired.el

(autoload 'turn-on-gnus-dired-mode "gnus-dired" "\
Convenience method to turn on `gnus-dired-mode'." t)
(register-definition-prefixes "gnus-dired" '("gnus-dired-"))


;;; Generated autoloads from gnus/gnus-draft.el

(autoload 'gnus-draft-reminder "gnus-draft" "\
Reminder user if there are unsent drafts." t)
(register-definition-prefixes "gnus-draft" '("gnus-"))


;;; Generated autoloads from gnus/gnus-dup.el

(register-definition-prefixes "gnus-dup" '("gnus-"))


;;; Generated autoloads from gnus/gnus-eform.el

(register-definition-prefixes "gnus-eform" '("gnus-edit-form"))


;;; Generated autoloads from gnus/gnus-fun.el

(autoload 'gnus--random-face-with-type "gnus-fun" "\
Return file from DIR with extension EXT.
Omit matches of OMIT, and process them by FUN.

(fn DIR EXT OMIT FUN)")
(autoload 'message-goto-eoh "message" nil t)
(autoload 'gnus-random-x-face "gnus-fun" "\
Return X-Face header data chosen randomly from `gnus-x-face-directory'.

Files matching `gnus-x-face-omit-files' are not considered." t)
(autoload 'gnus-insert-random-x-face-header "gnus-fun" "\
Insert a random X-Face header from `gnus-x-face-directory'." t)
(autoload 'gnus-x-face-from-file "gnus-fun" "\
Insert an X-Face header based on an image FILE.

Depending on `gnus-convert-image-to-x-face-command' it may accept
different input formats.

(fn FILE)" t)
(autoload 'gnus-face-from-file "gnus-fun" "\
Return a Face header based on an image FILE.

Depending on `gnus-convert-image-to-face-command' it may accept
different input formats.

(fn FILE)" t)
(autoload 'gnus-convert-face-to-png "gnus-fun" "\
Convert FACE (which is base64-encoded) to a PNG.
The PNG is returned as a string.

(fn FACE)")
(autoload 'gnus-convert-png-to-face "gnus-fun" "\
Convert FILE to a Face.
FILE should be a PNG file that's 48x48 and smaller than or equal to
726 bytes.

(fn FILE)")
(autoload 'gnus-random-face "gnus-fun" "\
Return randomly chosen Face from `gnus-face-directory'.

Files matching `gnus-face-omit-files' are not considered." t)
(autoload 'gnus-insert-random-face-header "gnus-fun" "\
Insert a random Face header from `gnus-face-directory'.")
(register-definition-prefixes "gnus-fun" '("gnus-"))


;;; Generated autoloads from gnus/gnus-gravatar.el

(autoload 'gnus-treat-from-gravatar "gnus-gravatar" "\
Display gravatar in the From header.
If gravatar is already displayed, remove it.

(fn &optional FORCE)" '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-treat-mail-gravatar "gnus-gravatar" "\
Display gravatars in the Cc and To headers.
If gravatars are already displayed, remove them.

(fn &optional FORCE)" '(gnus-article-mode gnus-summary-mode))
(register-definition-prefixes "gnus-gravatar" '("gnus-gravatar-"))


;;; Generated autoloads from gnus/gnus-group.el

(autoload 'gnus-fetch-group "gnus-group" "\
Start Gnus if necessary and enter GROUP.
If ARTICLES, display those articles.
Returns whether the fetching was successful or not.

(fn GROUP &optional ARTICLES)" t)
(autoload 'gnus-fetch-group-other-frame "gnus-group" "\
Pop up a frame and enter GROUP.

(fn GROUP)" t)
(autoload 'gnus-read-ephemeral-emacs-bug-group "gnus-group" "\
Browse Emacs bug reports with IDS in an ephemeral group.
The arguments have the same meaning as those of
`gnus-read-ephemeral-bug-group', which see.

(fn IDS &optional WINDOW-CONF)" t)
(register-definition-prefixes "gnus-group" '("gnus-"))


;;; Generated autoloads from gnus/gnus-html.el

(autoload 'gnus-article-html "gnus-html" "\


(fn &optional HANDLE)")
(autoload 'gnus-html-prefetch-images "gnus-html" "\


(fn SUMMARY)")
(register-definition-prefixes "gnus-html" '("gnus-"))


;;; Generated autoloads from gnus/gnus-icalendar.el

(autoload 'gnus-icalendar-mm-inline "gnus-icalendar" "\


(fn HANDLE)")
(register-definition-prefixes "gnus-icalendar" '("gnus-icalendar"))


;;; Generated autoloads from gnus/gnus-int.el

(register-definition-prefixes "gnus-int" '("gnus-"))


;;; Generated autoloads from gnus/gnus-kill.el

(defalias 'gnus-batch-kill 'gnus-batch-score)
(autoload 'gnus-batch-score "gnus-kill" "\
Run batched scoring.
Usage: emacs -batch -l ~/.emacs -l gnus -f gnus-batch-score" t)
(register-definition-prefixes "gnus-kill" '("gnus-"))


;;; Generated autoloads from gnus/gnus-logic.el

(register-definition-prefixes "gnus-logic" '("gnus-"))


;;; Generated autoloads from gnus/gnus-mh.el

(register-definition-prefixes "gnus-mh" '("gnus-"))


;;; Generated autoloads from gnus/gnus-ml.el

(autoload 'turn-on-gnus-mailing-list-mode "gnus-ml")
(autoload 'gnus-mailing-list-insinuate "gnus-ml" "\
Setup group parameters from List-Post header.
If FORCE is non-nil, replace the old ones.

(fn &optional FORCE)" t)
(autoload 'gnus-mailing-list-mode "gnus-ml" "\
Minor mode for providing mailing-list commands.

\\{gnus-mailing-list-mode-map}

This is a minor mode.  If called interactively, toggle the
`Gnus-Mailing-List mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `gnus-mailing-list-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "gnus-ml" '("gnus-mailing-list-"))


;;; Generated autoloads from gnus/gnus-mlspl.el

(autoload 'gnus-group-split-setup "gnus-mlspl" "\
Set up the split for `nnmail-split-fancy'.
Sets things up so that nnmail-split-fancy is used for mail
splitting, and defines the variable nnmail-split-fancy according with
group parameters.

If AUTO-UPDATE is non-nil (prefix argument accepted, if called
interactively), it makes sure nnmail-split-fancy is re-computed before
getting new mail, by adding `gnus-group-split-update' to
`gnus-get-top-new-news-hook'.

A non-nil CATCH-ALL replaces the current value of
`gnus-group-split-default-catch-all-group'.  This variable is only used
by gnus-group-split-update, and only when its CATCH-ALL argument is
nil.  This argument may contain any fancy split, that will be added as
the last split in a `|' split produced by `gnus-group-split-fancy',
unless overridden by any group marked as a catch-all group.  Typical
uses are as simple as the name of a default mail group, but more
elaborate fancy splits may also be useful to split mail that doesn't
match any of the group-specified splitting rules.  See
`gnus-group-split-fancy' for details.

(fn &optional AUTO-UPDATE CATCH-ALL)" t)
(autoload 'gnus-group-split-update "gnus-mlspl" "\
Computes `nnmail-split-fancy' from group params and CATCH-ALL.
It does this by calling (gnus-group-split-fancy nil nil CATCH-ALL).

If CATCH-ALL is nil, `gnus-group-split-default-catch-all-group' is used
instead.  This variable is set by `gnus-group-split-setup'.

(fn &optional CATCH-ALL)" t)
(autoload 'gnus-group-split "gnus-mlspl" "\
Use information from group parameters in order to split mail.
See `gnus-group-split-fancy' for more information.

`gnus-group-split' is a valid value for `nnmail-split-methods'.")
(autoload 'gnus-group-split-fancy "gnus-mlspl" "\
Uses information from group parameters in order to split mail.
It can be embedded into `nnmail-split-fancy' lists with the SPLIT

(: gnus-group-split-fancy GROUPS NO-CROSSPOST CATCH-ALL)

GROUPS may be a regular expression or a list of group names, that will
be used to select candidate groups.  If it is omitted or nil, all
existing groups are considered.

if NO-CROSSPOST is omitted or nil, a & split will be returned,
otherwise, a | split, that does not allow crossposting, will be
returned.

For each selected group, a SPLIT is composed like this: if SPLIT-SPEC
is specified, this split is returned as-is (unless it is nil: in this
case, the group is ignored).  Otherwise, if TO-ADDRESS, TO-LIST and/or
EXTRA-ALIASES are specified, a regexp that matches any of them is
constructed (extra-aliases may be a list).  Additionally, if
SPLIT-REGEXP is specified, the regexp will be extended so that it
matches this regexp too, and if SPLIT-EXCLUDE is specified, RESTRICT
clauses will be generated.

If CATCH-ALL is nil, no catch-all handling is performed, regardless of
catch-all marks in group parameters.  Otherwise, if there is no
selected group whose SPLIT-REGEXP matches the empty string, nor is
there a selected group whose SPLIT-SPEC is `catch-all', this fancy
split (say, a group name) will be appended to the returned SPLIT list,
as the last element of a `|' SPLIT.

For example, given the following group parameters:

nnml:mail.bar:
((to-address . \"bar@femail.com\")
 (split-regexp . \".*@femail\\\\.com\"))
nnml:mail.foo:
((to-list . \"foo@nowhere.gov\")
 (extra-aliases \"foo@localhost\" \"foo-redist@home\")
 (split-exclude \"bugs-foo\" \"rambling-foo\")
 (admin-address . \"foo-request@nowhere.gov\"))
nnml:mail.others:
((split-spec . catch-all))

Calling (gnus-group-split-fancy nil nil \"mail.others\") returns:

(| (& (any \"\\\\(bar@femail\\\\.com\\\\|.*@femail\\\\.com\\\\)\"
	   \"mail.bar\")
      (any \"\\\\(foo@nowhere\\\\.gov\\\\|foo@localhost\\\\|foo-redist@home\\\\)\"
	   - \"bugs-foo\" - \"rambling-foo\" \"mail.foo\"))
   \"mail.others\")

(fn &optional GROUPS NO-CROSSPOST CATCH-ALL)")
(register-definition-prefixes "gnus-mlspl" '("gnus-group-split-"))


;;; Generated autoloads from gnus/gnus-msg.el

(autoload 'gnus-msg-mail "gnus-msg" "\
Start editing a mail message to be sent.
Like `message-mail', but with Gnus paraphernalia, particularly the
Gcc: header for archiving purposes.
If Gnus isn't running, a plain `message-mail' setup is used
instead.

(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-ACTION YANK-ACTION SEND-ACTIONS RETURN-ACTION)" t)
(autoload 'gnus-button-mailto "gnus-msg" "\
Mail to ADDRESS.

(fn ADDRESS)")
(autoload 'gnus-button-reply "gnus-msg" "\
Like `message-reply'.

(fn &optional TO-ADDRESS WIDE)" t)
(define-mail-user-agent 'gnus-user-agent 'gnus-msg-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)
(register-definition-prefixes "gnus-msg" '("gnus-"))


;;; Generated autoloads from gnus/gnus-notifications.el

(autoload 'gnus-notifications "gnus-notifications" "\
Send a notification on new message.
This check for new messages that are in group with a level lower
or equal to `gnus-notifications-minimum-level' and send a
notification using `notifications-notify' for it.

This is typically a function to add in
`gnus-after-getting-new-news-hook'")
(register-definition-prefixes "gnus-notifications" '("gnus-notifications-"))


;;; Generated autoloads from gnus/gnus-picon.el

(autoload 'gnus-treat-from-picon "gnus-picon" "\
Display picons in the From header.
If picons are already displayed, remove them." '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-treat-mail-picon "gnus-picon" "\
Display picons in the Cc and To headers.
If picons are already displayed, remove them." '(gnus-article-mode gnus-summary-mode))
(autoload 'gnus-treat-newsgroups-picon "gnus-picon" "\
Display picons in the Newsgroups and Followup-To headers.
If picons are already displayed, remove them." '(gnus-article-mode gnus-summary-mode))
(register-definition-prefixes "gnus-picon" '("gnus-picon-"))


;;; Generated autoloads from gnus/gnus-range.el

(autoload 'gnus-sorted-difference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
The tail of LIST1 is not copied.

(fn LIST1 LIST2)")
(autoload 'gnus-sorted-ndifference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
LIST1 is modified.

(fn LIST1 LIST2)")
(autoload 'gnus-sorted-complement "gnus-range" "\
Return a list of elements that are in LIST1 or LIST2 but not both.
Both lists have to be sorted over <.

(fn LIST1 LIST2)")
(autoload 'gnus-intersection "gnus-range" "\


(fn LIST1 LIST2)")
(make-obsolete 'gnus-intersection 'seq-intersection "28.1")
(autoload 'gnus-sorted-intersection "gnus-range" "\
Return intersection of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <.

(fn LIST1 LIST2)")
(defalias 'gnus-set-sorted-intersection #'gnus-sorted-nintersection)
(autoload 'gnus-sorted-nintersection "gnus-range" "\
Return intersection of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <.

(fn LIST1 LIST2)")
(autoload 'gnus-sorted-union "gnus-range" "\
Return union of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <.

(fn LIST1 LIST2)")
(autoload 'gnus-sorted-nunion "gnus-range" "\
Return union of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <.

(fn LIST1 LIST2)")
(autoload 'gnus-add-to-sorted-list "gnus-range" "\
Add NUM into sorted LIST by side effect.

(fn LIST NUM)")
(register-definition-prefixes "gnus-range" '("gnus-"))


;;; Generated autoloads from gnus/gnus-registry.el

(autoload 'gnus-registry-initialize "gnus-registry" "\
Initialize the Gnus registry." t)
(register-definition-prefixes "gnus-registry" '("gnus-"))


;;; Generated autoloads from gnus/gnus-rfc1843.el

(register-definition-prefixes "gnus-rfc1843" '("rfc1843-"))


;;; Generated autoloads from gnus/gnus-rmail.el

(register-definition-prefixes "gnus-rmail" '("gnus-"))


;;; Generated autoloads from gnus/gnus-salt.el

(register-definition-prefixes "gnus-salt" '("gnus-"))


;;; Generated autoloads from gnus/gnus-score.el

(register-definition-prefixes "gnus-score" '("gnus-"))


;;; Generated autoloads from gnus/gnus-search.el

(register-definition-prefixes "gnus-search" '("gnus-search-"))


;;; Generated autoloads from gnus/gnus-sieve.el

(autoload 'gnus-sieve-update "gnus-sieve" "\
Update the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost), then
execute gnus-sieve-update-shell-command.
See the documentation for these variables and functions for details." t)
(autoload 'gnus-sieve-generate "gnus-sieve" "\
Generate the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost).
See the documentation for these variables and functions for details." t)
(autoload 'gnus-sieve-article-add-rule "gnus-sieve" nil '(gnus-article-mode gnus-summary-mode))
(register-definition-prefixes "gnus-sieve" '("gnus-sieve-"))


;;; Generated autoloads from gnus/gnus-spec.el

(autoload 'gnus-update-format "gnus-spec" "\
Update the format specification near point.

(fn VAR)" t)
(register-definition-prefixes "gnus-spec" '("gnus-"))


;;; Generated autoloads from gnus/gnus-srvr.el

(register-definition-prefixes "gnus-srvr" '("gnus-"))


;;; Generated autoloads from gnus/gnus-start.el

(autoload 'gnus-declare-backend "gnus-start" "\
Declare back end NAME with ABILITIES as a Gnus back end.

(fn NAME &rest ABILITIES)")
(register-definition-prefixes "gnus-start" '("gnus-"))


;;; Generated autoloads from gnus/gnus-sum.el

(autoload 'gnus-summary-bookmark-jump "gnus-sum" "\
Handler function for record returned by `gnus-summary-bookmark-make-record'.
BOOKMARK is a bookmark name or a bookmark record.

(fn BOOKMARK)")
(register-definition-prefixes "gnus-sum" '("gnus-"))


;;; Generated autoloads from gnus/gnus-topic.el

(register-definition-prefixes "gnus-topic" '("gnus-"))


;;; Generated autoloads from gnus/gnus-undo.el

(register-definition-prefixes "gnus-undo" '("gnus-"))


;;; Generated autoloads from gnus/gnus-util.el

(register-definition-prefixes "gnus-util" '("gnus-"))


;;; Generated autoloads from gnus/gnus-uu.el

(register-definition-prefixes "gnus-uu" '("gnus-"))


;;; Generated autoloads from gnus/gnus-vm.el

(register-definition-prefixes "gnus-vm" '("gnus-"))


;;; Generated autoloads from gnus/gnus-win.el

(autoload 'gnus-add-configuration "gnus-win" "\
Add the window configuration CONF to `gnus-buffer-configuration'.

(fn CONF)")
(register-definition-prefixes "gnus-win" '("gnus-"))


;;; Generated autoloads from net/gnutls.el

(register-definition-prefixes "gnutls" '("gnutls-" "open-gnutls-stream"))


;;; Generated autoloads from progmodes/go-ts-mode.el

(autoload 'go-ts-mode "go-ts-mode" "\
Major mode for editing Go, powered by tree-sitter.

\\{go-ts-mode-map}

(fn)" t)
(autoload 'go-mod-ts-mode "go-ts-mode" "\
Major mode for editing go.mod files, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "go-ts-mode" '("go-"))


;;; Generated autoloads from play/gomoku.el

(autoload 'gomoku "gomoku" "\
Start a Gomoku game between you and Emacs.

If a game is in progress, this command allows you to resume it.
If optional arguments N and M are given, an N by M board is used.
If prefix arg is given for N, M is prompted for.

You and Emacs play in turn by marking a free square.  You mark it with X
and Emacs marks it with O.  The winner is the first to get five contiguous
marks horizontally, vertically or in diagonal.

You play by moving the cursor over the square you choose and hitting
\\<gomoku-mode-map>\\[gomoku-human-plays].

This program actually plays a simplified or archaic version of the
Gomoku game, and ought to be upgraded to use the full modern rules.

Use \\[describe-mode] for more info.

(fn &optional N M)" t)
(register-definition-prefixes "gomoku" '("gomoku-"))


;;; Generated autoloads from net/goto-addr.el

(autoload 'goto-address-at-point "goto-addr" "\
Compose a new message to the e-mail address or open URL at point.

Compose message to address at point.  See documentation for
`goto-address-find-address-at-point'.

If no e-mail address is found at point, open the URL at or before
point using `browse-url'.  With a prefix argument, open the URL
using `browse-url-secondary-browser-function' instead.

(fn &optional EVENT)" t)
(autoload 'goto-address "goto-addr" "\
Sets up goto-address functionality in the current buffer.
Allows user to use mouse/keyboard command to click to go to a URL
or to send e-mail.
By default, goto-address binds `goto-address-at-point' to mouse-2 and C-c RET
only on URLs and e-mail addresses.

Also fontifies the buffer appropriately (see `goto-address-fontify-p' and
`goto-address-highlight-p' for more information)." t)
(put 'goto-address 'safe-local-eval-function t)
(autoload 'goto-address-mode "goto-addr" "\
Minor mode to buttonize URLs and e-mail addresses in the current buffer.

This is a minor mode.  If called interactively, toggle the `Goto-Address
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `goto-address-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-goto-address-mode 'globalized-minor-mode t)
(defvar global-goto-address-mode nil "\
Non-nil if Global Goto-Address mode is enabled.
See the `global-goto-address-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-goto-address-mode'.")
(custom-autoload 'global-goto-address-mode "goto-addr" nil)
(autoload 'global-goto-address-mode "goto-addr" "\
Toggle Goto-Address mode in all buffers.
With prefix ARG, enable Global Goto-Address mode if ARG is positive;
otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Goto-Address mode is enabled in all buffers where
`goto-addr-mode--turn-on' would do it.

See `goto-address-mode' for more information on Goto-Address mode.

(fn &optional ARG)" t)
(autoload 'goto-address-prog-mode "goto-addr" "\
Like `goto-address-mode', but only for comments and strings.

This is a minor mode.  If called interactively, toggle the
`Goto-Address-Prog mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `goto-address-prog-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "goto-addr" '("goto-addr"))


;;; Generated autoloads from cedet/semantic/wisent/grammar.el

(autoload 'wisent-grammar-mode "semantic/wisent/grammar" "\
Major mode for editing Wisent grammars.

(fn)" t)
(register-definition-prefixes "semantic/wisent/grammar" '("semantic-grammar-" "wisent-"))


;;; Generated autoloads from cedet/semantic/bovine/grammar.el

(autoload 'bovine-grammar-mode "semantic/bovine/grammar" "\
Major mode for editing Bovine grammars.

(fn)" t)
(register-definition-prefixes "semantic/bovine/grammar" '("bovine-" "semantic-grammar-"))


;;; Generated autoloads from cedet/semantic/grammar.el

(register-definition-prefixes "semantic/grammar" '("semantic-"))


;;; Generated autoloads from image/gravatar.el

(autoload 'gravatar-retrieve "gravatar" "\
Asynchronously retrieve a gravatar for MAIL-ADDRESS.
When finished, call CALLBACK as (apply CALLBACK GRAVATAR CBARGS),
where GRAVATAR is either an image descriptor, or the symbol
`error' if the retrieval failed.

(fn MAIL-ADDRESS CALLBACK &optional CBARGS)")
(autoload 'gravatar-retrieve-synchronously "gravatar" "\
Synchronously retrieve a gravatar for MAIL-ADDRESS.
Value is either an image descriptor, or the symbol `error' if the
retrieval failed.

(fn MAIL-ADDRESS)")
(register-definition-prefixes "gravatar" '("gravatar-"))


;;; Generated autoloads from progmodes/grep.el

(defvar grep-window-height nil "\
Number of lines in a grep window.  If nil, use `compilation-window-height'.")
(custom-autoload 'grep-window-height "grep" t)
(defvar grep-highlight-matches 'auto-detect "\
Use special markers to highlight grep matches.

Some grep programs are able to surround matches with special
markers in grep output.  Such markers can be used to highlight
matches in grep mode.  This requires `font-lock-mode' to be active
in grep buffers, so if you have globally disabled `font-lock-mode',
you will not get highlighting.

This option sets the environment variable GREP_COLORS to specify
markers for highlighting and adds the --color option in front of
any explicit grep options before starting the grep.

When this option is `auto', grep uses `--color=auto' to highlight
matches only when it outputs to a terminal (when `grep' is the last
command in the pipe), thus avoiding the use of any potentially-harmful
escape sequences when standard output goes to a file or pipe.

To make grep highlight matches even into a pipe, you need the option
`always' that forces grep to use `--color=always' to unconditionally
output escape sequences.

If the value is `auto-detect' (the default), `grep' will call
`grep-compute-defaults' to compute the value.  To change the
default value, use \\[customize] or call the function
`grep-apply-setting'.")
(custom-autoload 'grep-highlight-matches "grep" nil)
(defvar grep-command nil "\
The default grep command for \\[grep].
If the grep program used supports an option to always include file names
in its output (such as the `-H' option to GNU grep), it's a good idea to
include it when specifying `grep-command'.

In interactive usage, the actual value of this variable is set up
by `grep-compute-defaults'; to change the default value, use
\\[customize] or call the function `grep-apply-setting'.

Also see `grep-command-position'.")
(custom-autoload 'grep-command "grep" nil)
(defvar grep-find-command nil "\
The default find command for \\[grep-find].
In interactive usage, the actual value of this variable is set up
by `grep-compute-defaults'; to change the default value, use
\\[customize] or call the function `grep-apply-setting'.

This variable can either be a string, or a cons of the
form (COMMAND . POSITION).  In the latter case, COMMAND will be
used as the default command, and point will be placed at POSITION
for easier editing.")
(custom-autoload 'grep-find-command "grep" nil)
(defvar grep-setup-hook nil "\
List of hook functions run by `grep-process-setup' (see `run-hooks').")
(custom-autoload 'grep-setup-hook "grep" t)
(defvar grep-match-face 'match "\
Face name to use for grep matches.")
(defconst grep-regexp-alist `((,(concat "^\\(?:" "\\(?1:[^\0\n]+\\)\\(?3:\0\\)\\(?2:[0-9]+\\):" "\\|" "\\(?1:" "\\(?:[a-zA-Z]:\\)?" "[^\n:]+?[^\n/:]\\):[\11 ]*\\(?2:[1-9][0-9]*\\)[\11 ]*:" "\\)") 1 2 (,(lambda nil (when grep-highlight-matches (let* ((beg (match-end 0)) (end (save-excursion (goto-char beg) (line-end-position))) (mbeg (text-property-any beg end 'font-lock-face grep-match-face))) (when mbeg (- mbeg beg))))) \, (lambda nil (when grep-highlight-matches (let* ((beg (match-end 0)) (end (save-excursion (goto-char beg) (line-end-position))) (mbeg (text-property-any beg end 'font-lock-face grep-match-face)) (mend (and mbeg (next-single-property-change mbeg 'font-lock-face nil end)))) (when mend (- mend beg 1)))))) nil nil (3 '(face nil display ":"))) ("^Binary file \\(.+\\) matches" 1 nil nil 0 1)) "\
Regexp used to match grep hits.
See `compilation-error-regexp-alist' for format details.")
(defvar grep-program (purecopy "grep") "\
The default grep program for `grep-command' and `grep-find-command'.
This variable's value takes effect when `grep-compute-defaults' is called.")
(defvar find-program (purecopy "find") "\
The default find program.
This is used by commands like `grep-find-command', `find-dired'
and others.")
(defvar xargs-program (purecopy "xargs") "\
The default xargs program for `grep-find-command'.
See `grep-find-use-xargs'.
This variable's value takes effect when `grep-compute-defaults' is called.")
(defvar grep-find-use-xargs nil "\
How to invoke find and grep.
If `exec', use `find -exec {} ;'.
If `exec-plus' use `find -exec {} +'.
If `gnu', use `find -print0' and `xargs -0'.
If `gnu-sort', use `find -print0', `sort -z' and `xargs -0'.
Any other value means to use `find -print' and `xargs'.

This variable's value takes effect when `grep-compute-defaults' is called.")
(custom-autoload 'grep-find-use-xargs "grep" nil)
(defvar grep-history nil "\
History list for grep.")
(defvar grep-find-history nil "\
History list for `grep-find'.")
(autoload 'grep-process-setup "grep" "\
Setup compilation variables and buffer for `grep'.
Set up `compilation-exit-message-function' and run `grep-setup-hook'.")
(autoload 'grep-compute-defaults "grep" "\
Compute the defaults for the `grep' command.
The value depends on `grep-command', `grep-template',
`grep-use-null-device', `grep-find-command', `grep-find-template',
`grep-use-null-filename-separator', `grep-find-use-xargs',
`grep-highlight-matches', and `grep-quoting-style'.")
(autoload 'grep-mode "grep" "\
Sets `grep-last-buffer' and `compilation-window-height'.

(fn)")
(autoload 'grep "grep" "\
Run Grep with user-specified COMMAND-ARGS.
The output from the command goes to the \"*grep*\" buffer.

While Grep runs asynchronously, you can use \\[next-error] (M-x next-error),
or \\<grep-mode-map>\\[compile-goto-error] in the *grep* buffer, to go to the lines where Grep found
matches.  To kill the Grep job before it finishes, type \\[kill-compilation].

Noninteractively, COMMAND-ARGS should specify the Grep command-line
arguments.

For doing a recursive `grep', see the `rgrep' command.  For running
Grep in a specific directory, see `lgrep'.

This command uses a special history list for its COMMAND-ARGS, so you
can easily repeat a grep command.

A prefix argument says to default the COMMAND-ARGS based on the current
tag the cursor is over, substituting it into the last Grep command
in the Grep command history (or into `grep-command' if that history
list is empty).

(fn COMMAND-ARGS)" t)
(autoload 'grep-find "grep" "\
Run grep via find, with user-specified args COMMAND-ARGS.
Collect output in the \"*grep*\" buffer.
While find runs asynchronously, you can use the \\[next-error] command
to find the text that grep hits refer to.

This command uses a special history list for its arguments, so you can
easily repeat a find command.

(fn COMMAND-ARGS)" t)
(defalias 'find-grep #'grep-find)
(autoload 'lgrep "grep" "\
Run grep, searching for REGEXP in FILES in directory DIR.
The search is limited to file names matching shell pattern FILES.
FILES may use abbreviations defined in `grep-files-aliases', e.g.
entering `ch' is equivalent to `*.[ch]'.  As whitespace triggers
completion when entering a pattern, including it requires
quoting, e.g. `\\[quoted-insert]<space>'.

With \\[universal-argument] prefix, you can edit the constructed shell command line
before it is executed.
With two \\[universal-argument] prefixes, directly edit and run `grep-command'.

Collect output in the \"*grep*\" buffer.  While grep runs asynchronously, you
can use \\[next-error] (M-x next-error), or \\<grep-mode-map>\\[compile-goto-error] in the grep output buffer,
to go to the lines where grep found matches.

This command shares argument histories with \\[rgrep] and \\[grep].

If CONFIRM is non-nil, the user will be given an opportunity to edit the
command before it's run.

(fn REGEXP &optional FILES DIR CONFIRM)" t)
(autoload 'rgrep "grep" "\
Recursively grep for REGEXP in FILES in directory tree rooted at DIR.
The search is limited to file names matching shell pattern FILES.
FILES may use abbreviations defined in `grep-files-aliases', e.g.
entering `ch' is equivalent to `*.[ch]'.  As whitespace triggers
completion when entering a pattern, including it requires
quoting, e.g. `\\[quoted-insert]<space>'.

With \\[universal-argument] prefix, you can edit the constructed shell command line
before it is executed.
With two \\[universal-argument] prefixes, directly edit and run `grep-find-command'.

Collect output in the \"*grep*\" buffer.  While the recursive grep is running,
you can use \\[next-error] (M-x next-error), or \\<grep-mode-map>\\[compile-goto-error] in the grep output buffer,
to visit the lines where matches were found.  To kill the job
before it finishes, type \\[kill-compilation].

This command shares argument histories with \\[lgrep] and \\[grep-find].

When called programmatically and FILES is nil, REGEXP is expected
to specify a command to run.

If CONFIRM is non-nil, the user will be given an opportunity to edit the
command before it's run.

Interactively, the user can use \\<read-regexp-map>\\[read-regexp-toggle-case-fold] while entering the regexp
to indicate whether the grep should be case sensitive or not.

(fn REGEXP &optional FILES DIR CONFIRM)" t)
(autoload 'zrgrep "grep" "\
Recursively grep for REGEXP in gzipped FILES in tree rooted at DIR.
Like `rgrep' but uses `zgrep' for `grep-program', sets the default
file name to `*.gz', and sets `grep-highlight-matches' to `always'.

If CONFIRM is non-nil, the user will be given an opportunity to edit the
command before it's run.

(fn REGEXP &optional FILES DIR CONFIRM TEMPLATE)" t)
(defalias 'rzgrep #'zrgrep)
(register-definition-prefixes "grep" '("grep-" "kill-grep" "rgrep-"))


;;; Generated autoloads from cedet/semantic/symref/grep.el

(register-definition-prefixes "semantic/symref/grep" '("semantic-symref-"))


;;; Generated autoloads from gnus/gssapi.el

(register-definition-prefixes "gssapi" '("gssapi-program" "open-gssapi-stream"))


;;; Generated autoloads from progmodes/gud.el

(autoload 'gud-gdb "gud" "\
Run gdb passing it COMMAND-LINE as arguments.
If COMMAND-LINE names a program FILE to debug, gdb will run in
a buffer named *gud-FILE*, and the directory containing FILE
becomes the initial working directory and source-file directory
for your debugger.  If you don't want `default-directory' to
change to the directory of FILE, specify FILE without leading
directories, in which case FILE should reside either in the
directory of the buffer from which this command is invoked, or
it can be found by searching PATH.

If COMMAND-LINE requests that gdb attaches to a process PID, gdb
will run in *gud-PID*, otherwise it will run in *gud*; in these
cases the initial working directory is the `default-directory' of
the buffer in which this command was invoked.

(fn COMMAND-LINE)" t)
(autoload 'sdb "gud" "\
Run sdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

(fn COMMAND-LINE)" t)
(autoload 'dbx "gud" "\
Run dbx on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

(fn COMMAND-LINE)" t)
(autoload 'xdb "gud" "\
Run xdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

You can set the variable `gud-xdb-directories' to a list of program source
directories if your program contains sources from more than one directory.

(fn COMMAND-LINE)" t)
(autoload 'perldb "gud" "\
Debug a perl program with gud.
Interactively, this will prompt you for a command line.

Noninteractively, COMMAND-LINE should be on the form
\"perl -d perl-file.pl\".

The directory containing the perl program becomes the initial
working directory and source-file directory for your debugger.

(fn COMMAND-LINE)" t)
(autoload 'pdb "gud" "\
Run COMMAND-LINE in the `*gud-FILE*' buffer to debug Python programs.

COMMAND-LINE should include the pdb executable
name (`gud-pdb-command-name') and the file to be debugged.

If called interactively, the command line will be prompted for.

The directory containing this file becomes the initial working
directory and source-file directory for your debugger.

(fn COMMAND-LINE)" t)
(autoload 'guiler "gud" "\
Run guiler on program FILE in buffer `*gud-FILE*'.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

(fn COMMAND-LINE)" t)
(autoload 'jdb "gud" "\
Run jdb with command line COMMAND-LINE in a buffer.
The buffer is named \"*gud*\" if no initial class is given or
\"*gud-<initial-class-basename>*\" if there is.  If the \"-classpath\"
switch is given, omit all whitespace between it and its value.

See `gud-jdb-use-classpath' and `gud-jdb-classpath' documentation for
information on how jdb accesses source files.  Alternatively (if
`gud-jdb-use-classpath' is nil), see `gud-jdb-directories' for the
original source file access method.

For general information about commands available to control jdb from
gud, see `gud-mode'.

(fn COMMAND-LINE)" t)
(autoload 'gdb-script-mode "gud" "\
Major mode for editing GDB scripts.

(fn)" t)
(defvar gud-tooltip-mode nil "\
Non-nil if Gud-Tooltip mode is enabled.
See the `gud-tooltip-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `gud-tooltip-mode'.")
(custom-autoload 'gud-tooltip-mode "gud" nil)
(autoload 'gud-tooltip-mode "gud" "\
Toggle the display of GUD tooltips.

This is a global minor mode.  If called interactively, toggle the
`Gud-Tooltip mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='gud-tooltip-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'lldb "gud" "\
Run LLDB passing it COMMAND-LINE as arguments.
If COMMAND-LINE names a program FILE to debug, LLDB will run in
a buffer named *gud-FILE*, and the directory containing FILE
becomes the initial working directory and source-file directory
for the debug session.  If you don't want `default-directory' to
change to the directory of FILE, specify FILE without leading
directories, in which case FILE should reside either in the
directory of the buffer from which this command is invoked, or
it can be found by searching PATH.

If COMMAND-LINE requests that LLDB attaches to a process PID, LLDB
will run in *gud-PID*, otherwise it will run in *gud*; in these
cases the initial working directory is the `default-directory' of
the buffer in which this command was invoked.

Please note that completion framework that complete while you
type, like Corfu, do not work well with this mode.  You should
consider to turn them off in this mode.

This command runs functions from `lldb-mode-hook'.

(fn COMMAND-LINE)" t)
(register-definition-prefixes "gud" '("gdb-" "gud-"))


;;; Generated autoloads from emacs-lisp/gv.el

(autoload 'gv-get "gv" "\
Build the code that applies DO to PLACE.
PLACE must be a valid generalized variable.
DO must be a function; it will be called with 2 arguments: GETTER and SETTER,
where GETTER is a (copyable) Elisp expression that returns the value of PLACE,
and SETTER is a function which returns the code to set PLACE when called
with a (not necessarily copyable) Elisp expression that returns the value to
set it to.
DO must return an Elisp expression.

(fn PLACE DO)")
(autoload 'gv-letplace "gv" "\
Build the code manipulating the generalized variable PLACE.
GETTER will be bound to a copyable expression that returns the value
of PLACE.
SETTER will be bound to a function that takes an expression V and returns
a new expression that sets PLACE to V.
BODY should return some Elisp expression E manipulating PLACE via GETTER
and SETTER.
The returned value will then be an Elisp expression that first evaluates
all the parts of PLACE that can be evaluated and then runs E.

(fn (GETTER SETTER) PLACE &rest BODY)" nil t)
(function-put 'gv-letplace 'lisp-indent-function 2)
(autoload 'gv-define-expander "gv" "\
Use HANDLER to handle NAME as a generalized var.
NAME is a symbol: the name of a function, macro, or special form.
HANDLER is a function which takes an argument DO followed by the same
arguments as NAME.  DO is a function as defined in `gv-get'.

(fn NAME HANDLER)" nil t)
(function-put 'gv-define-expander 'lisp-indent-function 1)
(autoload 'gv--defun-declaration "gv" "\


(fn SYMBOL NAME ARGS HANDLER &optional FIX)")
(defsubst gv--expander-defun-declaration (&rest args) (apply #'gv--defun-declaration 'gv-expander args))
(defsubst gv--setter-defun-declaration (&rest args) (apply #'gv--defun-declaration 'gv-setter args))
(or (assq 'gv-expander defun-declarations-alist) (let ((x (list 'gv-expander #'gv--expander-defun-declaration))) (push x macro-declarations-alist) (push x defun-declarations-alist)))
(or (assq 'gv-setter defun-declarations-alist) (push (list 'gv-setter #'gv--setter-defun-declaration) defun-declarations-alist))
(let ((spec (get 'compiler-macro 'edebug-declaration-spec))) (put 'gv-expander 'edebug-declaration-spec spec) (put 'gv-setter 'edebug-declaration-spec spec))
(autoload 'gv-define-setter "gv" "\
Define a setter method for generalized variable NAME.
This macro is an easy-to-use substitute for `gv-define-expander' that works
well for simple place forms.
Assignments of VAL to (NAME ARGS...) are expanded by binding the argument
forms (VAL ARGS...) according to ARGLIST, then executing BODY, which must
return a Lisp form that does the assignment.
The first arg in ARGLIST (the one that receives VAL) receives an expression
which can do arbitrary things, whereas the other arguments are all guaranteed
to be pure and copyable.  Example use:
  (gv-define-setter aref (v a i) \\=`(aset ,a ,i ,v))

(fn NAME ARGLIST &rest BODY)" nil t)
(function-put 'gv-define-setter 'lisp-indent-function 2)
(autoload 'gv-define-simple-setter "gv" "\
Define a simple setter method for generalized variable NAME.
This macro is an easy-to-use substitute for `gv-define-expander' that works
well for simple place forms.  Assignments of VAL to (NAME ARGS...) are
turned into calls of the form (SETTER ARGS... VAL).

If FIX-RETURN is non-nil, then SETTER is not assumed to return VAL and
instead the assignment is turned into something equivalent to
  (let ((temp VAL))
    (SETTER ARGS... temp)
    temp)
so as to preserve the semantics of `setf'.

(fn NAME SETTER &optional FIX-RETURN)" nil t)
(autoload 'setf "gv" "\
Set each PLACE to the value of its VAL.
This is a generalized version of `setq'; the PLACEs may be symbolic
references such as (car x) or (aref x i), as well as plain symbols.
For example, (setf (cadr x) y) is equivalent to (setcar (cdr x) y).
The return value is the last VAL in the list.

(fn PLACE VAL PLACE VAL ...)" nil t)
(def-edebug-elem-spec 'gv-place '(form))
(autoload 'gv-ref "gv" "\
Return a reference to PLACE.
This is like the `&' operator of the C language.
Note: this only works reliably with lexical binding mode, except for very
simple PLACEs such as (symbol-function \\='foo) which will also work in dynamic
binding mode.

(fn PLACE)" nil t)
(register-definition-prefixes "gv" '("gv-" "make-obsolete-generalized-variable"))


;;; Generated autoloads from play/handwrite.el

(autoload 'handwrite "handwrite" "\
Turn the buffer into a \"handwritten\" document.
The functions `handwrite-10pt', `handwrite-11pt', `handwrite-12pt'
and `handwrite-13pt' set up for various sizes of output.

Variables: `handwrite-linespace'     (default 12)
           `handwrite-fontsize'      (default 11)
           `handwrite-numlines'      (default 60)
           `handwrite-pagenumbering' (default nil)" t)
(register-definition-prefixes "handwrite" '("handwrite-" "menu-bar-handwrite-map"))


;;; Generated autoloads from leim/quail/hangul.el

(autoload 'hangul-input-method-activate "quail/hangul" "\
Activate Hangul input method INPUT-METHOD.
FUNC is a function to handle input key.
HELP-TEXT is a text set in `hangul-input-method-help-text'.

(fn INPUT-METHOD FUNC HELP-TEXT &rest ARGS)")
(register-definition-prefixes "quail/hangul" '("hangul" "notzerop"))


;;; Generated autoloads from language/hanja-util.el

(register-definition-prefixes "hanja-util" '("han"))


;;; Generated autoloads from play/hanoi.el

(autoload 'hanoi "hanoi" "\
Towers of Hanoi diversion.  Use NRINGS rings.

(fn NRINGS)" t)
(autoload 'hanoi-unix "hanoi" "\
Towers of Hanoi, 32-bit UNIX doomsday version.
Display 32-ring towers that have been progressing at one move per
second since 1970-01-01 00:00:00 UTC.

Repent before ring 31 moves." t)
(autoload 'hanoi-unix-64 "hanoi" "\
Like `hanoi-unix', but with a 64-bit clock." t)
(register-definition-prefixes "hanoi" '("hanoi-"))


;;; Generated autoloads from mail/hashcash.el

(autoload 'hashcash-insert-payment "hashcash" "\
Insert X-Payment and X-Hashcash headers with a payment for ARG.

(fn ARG)" t)
(autoload 'hashcash-insert-payment-async "hashcash" "\
Insert X-Payment and X-Hashcash headers with a payment for ARG
Only start calculation.  Results are inserted when ready.

(fn ARG)" t)
(autoload 'hashcash-verify-payment "hashcash" "\
Verify a hashcash payment.

(fn TOKEN &optional RESOURCE AMOUNT)")
(autoload 'mail-add-payment "hashcash" "\
Add X-Payment: and X-Hashcash: headers with a hashcash payment
for each recipient address.  Prefix arg sets default payment temporarily.
Set ASYNC to t to start asynchronous calculation.  (See
`mail-add-payment-async').

(fn &optional ARG ASYNC)" t)
(autoload 'mail-add-payment-async "hashcash" "\
Add X-Payment: and X-Hashcash: headers with a hashcash payment
for each recipient address.  Prefix arg sets default payment temporarily.
Calculation is asynchronous.

(fn &optional ARG)" t)
(autoload 'mail-check-payment "hashcash" "\
Look for a valid X-Payment: or X-Hashcash: header.
Prefix arg sets default accept amount temporarily.

(fn &optional ARG)" t)
(register-definition-prefixes "hashcash" '("hashcash-"))


;;; Generated autoloads from progmodes/heex-ts-mode.el

(autoload 'heex-ts-mode "heex-ts-mode" "\
Major mode for editing HEEx, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "heex-ts-mode" '("heex-ts-"))


;;; Generated autoloads from help-at-pt.el

(autoload 'help-at-pt-string "help-at-pt" "\
Return the help-echo string at point.
Normally, the string produced by the `help-echo' text or overlay
property, or nil, is returned.
If KBD is non-nil, `kbd-help' is used instead, and any
`help-echo' property is ignored.  In this case, the return value
can also be t, if that is the value of the `kbd-help' property.

(fn &optional KBD)")
(autoload 'help-at-pt-kbd-string "help-at-pt" "\
Return the keyboard help string at point.
If the `kbd-help' text or overlay property at point produces a
string, return it.  Otherwise, use the `help-echo' property.
If this produces no string either, return nil.")
(autoload 'display-local-help "help-at-pt" "\
Display local help in the echo area.
This command, by default, displays a short help message, namely
the string produced by the `kbd-help' property at point.  If
`kbd-help' does not produce a string, but the `help-echo'
property does, then that string is printed instead.

The string is passed through `substitute-command-keys' before it
is displayed.

If INHIBIT-WARNING is non-nil, this prevents display of a message
in case there is no help.

If DESCRIBE-BUTTON in non-nil (interactively, the prefix arg), and
there's a button/widget at point, pop a buffer describing that
button/widget instead.

(fn &optional INHIBIT-WARNING DESCRIBE-BUTTON)" t)
(autoload 'help-at-pt-cancel-timer "help-at-pt" "\
Cancel any timer set by `help-at-pt-set-timer'.
This disables `help-at-pt-display-when-idle'." t)
(autoload 'help-at-pt-set-timer "help-at-pt" "\
Enable `help-at-pt-display-when-idle'.
This is done by setting a timer, if none is currently active." t)
(defvar help-at-pt-display-when-idle 'never "\
Automatically show local help on point-over.
If the value is t, the string obtained from any `kbd-help' or
`help-echo' property at point is automatically printed in the
echo area, if nothing else is already displayed there, or after a
quit.  If both `kbd-help' and `help-echo' produce help strings,
`kbd-help' is used.  If the value is a list, the help only gets
printed if there is a text or overlay property at point that is
included in this list.  Suggested properties are `keymap',
`local-map', `button' and `kbd-help'.  Any value other than t or
a non-empty list disables the feature.

The text printed from the `help-echo' property is often only
relevant when using the mouse.  The presence of a `kbd-help'
property guarantees that non mouse specific help is available.

This variable only takes effect after a call to
`help-at-pt-set-timer'.  The help gets printed after Emacs has
been idle for `help-at-pt-timer-delay' seconds.  You can call
`help-at-pt-cancel-timer' to cancel the timer set by, and the
effect of, `help-at-pt-set-timer'.

When this variable is set through Custom, `help-at-pt-set-timer'
is called automatically, unless the value is `never', in which
case `help-at-pt-cancel-timer' is called.  Specifying an empty
list of properties through Custom will set the timer, thus
enabling buffer local values.  It sets the actual value to nil.
Thus, Custom distinguishes between a nil value and other values
that disable the feature, which Custom identifies with `never'.
The default is `never'.")
(custom-autoload 'help-at-pt-display-when-idle "help-at-pt" nil)
(autoload 'scan-buf-move-to-region "help-at-pt" "\
Go to the start of the next region with non-nil PROP property.
Then run HOOK, which should be a quoted symbol that is a normal
hook variable, or an expression evaluating to such a symbol.
Adjacent areas with different non-nil PROP properties are
considered different regions.

With numeric argument ARG, move to the start of the ARGth next
such region, then run HOOK.  If ARG is negative, move backward.
If point is already in a region, then that region does not count
toward ARG.  If ARG is 0 and point is inside a region, move to
the start of that region.  If ARG is 0 and point is not in a
region, print a message to that effect, but do not move point and
do not run HOOK.  If there are not enough regions to move over,
an error results and the number of available regions is mentioned
in the error message.  Point is not moved and HOOK is not run.

(fn PROP &optional ARG HOOK)")
(autoload 'scan-buf-next-region "help-at-pt" "\
Go to the start of the next region with non-nil help-echo.
Print the help found there using `display-local-help'.  Adjacent
areas with different non-nil help-echo properties are considered
different regions.

With numeric argument ARG, move to the start of the ARGth next
help-echo region.  If ARG is negative, move backward.  If point
is already in a help-echo region, then that region does not count
toward ARG.  If ARG is 0 and point is inside a help-echo region,
move to the start of that region.  If ARG is 0 and point is not
in such a region, just print a message to that effect.  If there
are not enough regions to move over, an error results and the
number of available regions is mentioned in the error message.

A potentially confusing subtlety is that point can be in a
help-echo region without any local help being available.  This is
because `help-echo' can be a function evaluating to nil.  This
rarely happens in practice.

(fn &optional ARG)" t)
(autoload 'scan-buf-previous-region "help-at-pt" "\
Go to the start of the previous region with non-nil help-echo.
Print the help found there using `display-local-help'.  Adjacent
areas with different non-nil help-echo properties are considered
different regions.  With numeric argument ARG, behaves like
`scan-buf-next-region' with argument -ARG.

(fn &optional ARG)" t)
(register-definition-prefixes "help-at-pt" '("help-at-pt-" "scan-buf-move-hook"))


;;; Generated autoloads from help-fns.el

(autoload 'describe-function "help-fns" "\
Display the full documentation of FUNCTION (a symbol).
When called from Lisp, FUNCTION may also be a function object.

See the `help-enable-symbol-autoload' variable for special
handling of autoloaded functions.

(fn FUNCTION)" t)
(autoload 'help-find-source "help-fns" "\
Switch to a buffer visiting the source of what is being described in *Help*." t)
(autoload 'describe-command "help-fns" "\
Display the full documentation of COMMAND (a symbol).
When called from Lisp, COMMAND may also be a function object.

(fn COMMAND)" t)
(autoload 'help-C-file-name "help-fns" "\
Return the name of the C file where SUBR-OR-VAR is defined.
KIND should be `var' for a variable or `subr' for a subroutine.
If we can't find the file name, nil is returned.

(fn SUBR-OR-VAR KIND)")
(autoload 'find-lisp-object-file-name "help-fns" "\
Guess the file that defined the Lisp object OBJECT, of type TYPE.
OBJECT should be a symbol associated with a function, variable, or face;
  alternatively, it can be a function definition.
If TYPE is `defvar', search for a variable definition.
If TYPE is `defface', search for a face definition.
If TYPE is not a symbol, search for a function definition.

The return value is the absolute name of a readable file where OBJECT is
defined.  If several such files exist, preference is given to a file
found via `load-path'.  The return value can also be `C-source', which
means that OBJECT is a function or variable defined in C, but
it's currently unknown where.  If no suitable file is found,
return nil.

If ALSO-C-SOURCE is non-nil, instead of returning `C-source',
this function will attempt to locate the definition of OBJECT in
the C sources, too.

(fn OBJECT TYPE &optional ALSO-C-SOURCE)")
(autoload 'describe-function-1 "help-fns" "\


(fn FUNCTION)")
(autoload 'variable-at-point "help-fns" "\
Return the bound variable symbol found at or before point.
Return 0 if there is no such symbol.
If ANY-SYMBOL is non-nil, don't insist the symbol be bound.

(fn &optional ANY-SYMBOL)")
(autoload 'describe-variable "help-fns" "\
Display the full documentation of VARIABLE (a symbol).
Returns the documentation as a string, also.
If VARIABLE has a buffer-local value in BUFFER or FRAME
(default to the current buffer and current frame),
it is displayed along with the global value.

(fn VARIABLE &optional BUFFER FRAME)" t)
(autoload 'describe-face "help-fns" "\
Display the properties of face FACE on FRAME.
Interactively, FACE defaults to the faces of the character after point
and FRAME defaults to the selected frame.

If the optional argument FRAME is given, report on face FACE in that frame.
If FRAME is t, report on the defaults for face FACE (for new frames).
If FRAME is omitted or nil, use the selected frame.

(fn FACE &optional FRAME)" t)
(autoload 'describe-symbol "help-fns" "\
Display the full documentation of SYMBOL.
Will show the info of SYMBOL as a function, variable, and/or face.
Optional arguments BUFFER and FRAME specify for which buffer and
frame to show the information about SYMBOL; they default to the
current buffer and the selected frame, respectively.

(fn SYMBOL &optional BUFFER FRAME)" t)
(autoload 'describe-syntax "help-fns" "\
Describe the syntax specifications in the syntax table of BUFFER.
The descriptions are inserted in a help buffer, which is then displayed.
BUFFER defaults to the current buffer.

(fn &optional BUFFER)" t)
(autoload 'describe-categories "help-fns" "\
Describe the category specifications in the current category table.
The descriptions are inserted in a buffer, which is then displayed.
If BUFFER is non-nil, then describe BUFFER's category table instead.
BUFFER should be a buffer or a buffer name.

(fn &optional BUFFER)" t)
(autoload 'describe-keymap "help-fns" "\
Describe key bindings in KEYMAP.
When called interactively, prompt for a variable that has a
keymap value.

(fn KEYMAP)" t)
(autoload 'describe-mode "help-fns" "\
Display documentation of current major mode and minor modes.
A brief summary of the minor modes comes first, followed by the
major mode description.  This is followed by detailed
descriptions of the minor modes, each on a separate page.

For this to work correctly for a minor mode, the mode's indicator
variable (listed in `minor-mode-alist') must also be a function
whose documentation describes the minor mode.

If called from Lisp with a non-nil BUFFER argument, display
documentation for the major and minor modes of that buffer.

When `describe-mode-outline' is non-nil, Outline minor mode
is enabled in the Help buffer.

(fn &optional BUFFER)" t)
(autoload 'describe-widget "help-fns" "\
Display a buffer with information about a widget.
You can use this command to describe buttons (e.g., the links in a *Help*
buffer), editable fields of the customization buffers, etc.

Interactively, click on a widget to describe it, or hit RET to describe the
widget at point.

When called from Lisp, POS may be a buffer position or a mouse position list.

Calls each function of the list `describe-widget-functions' in turn, until
one of them returns non-nil.

(fn &optional POS)" t)
(autoload 'doc-file-to-man "help-fns" "\
Produce an nroff buffer containing the doc-strings from the DOC file.

(fn FILE)" t)
(autoload 'doc-file-to-info "help-fns" "\
Produce a texinfo buffer with sorted doc-strings from the DOC file.

(fn FILE)" t)
(autoload 'help-fns-function-name "help-fns" "\
Return a short buttonized string representing FUNCTION.
The string is propertized with a button; clicking on that
provides further details about FUNCTION.
FUNCTION can be a function, a built-in, a keyboard macro,
or a compile function.
This function is intended to be used to display various
callable symbols in buffers in a way that allows the user
to find out more details about the symbols.

(fn FUNCTION)")
(register-definition-prefixes "help-fns" '("describe-" "help-" "keymap-name-history"))


;;; Generated autoloads from help-macro.el

(defvar three-step-help nil "\
Non-nil means give more info about Help command in three steps.
The three steps are simple prompt, prompt with all options, and
window listing and describing the options.
A value of nil means skip the middle step, so that \\[help-command] \\[help-command]
gives the window that lists the options.")
(custom-autoload 'three-step-help "help-macro" t)
(autoload 'help--help-screen "help-macro" "\


(fn HELP-LINE HELP-TEXT HELPED-MAP BUFFER-NAME)")
(register-definition-prefixes "help-macro" '("help-for-help-use-variable-pitch" "make-help-screen"))


;;; Generated autoloads from help-mode.el

(autoload 'help-mode--add-function-link "help-mode" "\


(fn STR FUN)")
(autoload 'help-mode "help-mode" "\
Major mode for viewing help text and navigating references in it.
Also see the `help-enable-variable-value-editing' variable.

Commands:
\\{help-mode-map}

(fn)" t)
(autoload 'help-mode-setup "help-mode" "\
Enter Help mode in the current buffer.")
(make-obsolete 'help-mode-setup 'nil "29.1")
(autoload 'help-mode-finish "help-mode" "\
Finalize Help mode setup in current buffer.")
(make-obsolete 'help-mode-finish 'nil "29.1")
(autoload 'help-setup-xref "help-mode" "\
Invoked from commands using the \"*Help*\" buffer to install some xref info.

ITEM is a (FUNCTION . ARGS) pair appropriate for recreating the help
buffer after following a reference.  INTERACTIVE-P is non-nil if the
calling command was invoked interactively.  In this case the stack of
items for help buffer \"back\" buttons is cleared.

This should be called very early, before the output buffer is cleared,
because we want to record the \"previous\" position of point so we can
restore it properly when going back.

(fn ITEM INTERACTIVE-P)")
(autoload 'help-buffer "help-mode" "\
Return the name of a buffer for inserting help.
If `help-xref-following' is non-nil and the current buffer is
derived from `help-mode', this is the name of the current buffer.

Otherwise, return \"*Help*\", creating a buffer with that name if
it does not already exist.")
(autoload 'help-make-xrefs "help-mode" "\
Parse and hyperlink documentation cross-references in the given BUFFER.

Find cross-reference information in a buffer and activate such cross
references for selection with `help-follow-symbol'.  Cross-references have
the canonical form `...'  and the type of reference may be
disambiguated by the preceding word(s) used in
`help-xref-symbol-regexp'.  Faces only get cross-referenced if
preceded or followed by the word `face'.  Variables without
variable documentation do not get cross-referenced, unless
preceded by the word `variable' or `option'.

If the variable `help-xref-mule-regexp' is non-nil, find also
cross-reference information related to multilingual environment
(e.g., coding-systems).  This variable is also used to disambiguate
the type of reference as the same way as `help-xref-symbol-regexp'.

A special reference `back' is made to return back through a stack of
help buffers.  Variable `help-back-label' specifies the text for
that.

(fn &optional BUFFER)" t)
(autoload 'help-xref-button "help-mode" "\
Make a hyperlink for cross-reference text previously matched.
MATCH-NUMBER is the subexpression of interest in the last matched
regexp.  TYPE is the type of button to use.  Any remaining arguments are
passed to the button's help-function when it is invoked.
See `help-make-xrefs'.

This function removes quotes surrounding the match if the
variable `help-clean-buttons' is non-nil.

(fn MATCH-NUMBER TYPE &rest ARGS)")
(autoload 'help-insert-xref-button "help-mode" "\
Insert STRING and make a hyperlink from cross-reference text on it.
TYPE is the type of button to use.  Any remaining arguments are passed
to the button's help-function when it is invoked.
See `help-make-xrefs'.

(fn STRING TYPE &rest ARGS)")
(autoload 'help-xref-on-pp "help-mode" "\
Add xrefs for symbols in `pp's output between FROM and TO.

(fn FROM TO)")
(define-obsolete-function-alias 'help-xref-interned #'describe-symbol "25.1")
(autoload 'help-bookmark-jump "help-mode" "\
Jump to `help-mode' bookmark BOOKMARK.
Handler function for record returned by `help-bookmark-make-record'.
BOOKMARK is a bookmark name or a bookmark record.

(fn BOOKMARK)")
(register-definition-prefixes "help-mode" '("describe-symbol-backends" "help-"))


;;; Generated autoloads from emacs-lisp/helper.el

(autoload 'Helper-describe-bindings "helper" "\
Describe local key bindings of current mode." t)
(autoload 'Helper-help "helper" "\
Provide help for current mode." t)
(register-definition-prefixes "helper" '("Helper-"))


;;; Generated autoloads from hex-util.el

(register-definition-prefixes "hex-util" '("decode-hex-string" "encode-hex-string"))


;;; Generated autoloads from hexl.el

(autoload 'hexl-mode "hexl" "\
A mode for editing binary files in hex dump format.
\\<hexl-mode-map>This is not an ordinary major mode; it alters some aspects
of the current mode's behavior, but not all; also, you can exit
Hexl mode and return to the previous mode using \\[hexl-mode-exit].

This function automatically converts a buffer into the hexl format
using the function `hexlify-buffer'.

Each line in the buffer has an \"address\" (displayed in hexadecimal)
representing the offset into the file that the characters on this line
are at and 16 characters from the file (displayed as hexadecimal
values grouped every `hexl-bits' bits, and as their ASCII values).

If any of the characters (displayed as ASCII characters) are
unprintable (control or meta characters) they will be replaced by
periods.

If `hexl-mode' is invoked with an argument the buffer is assumed to be
in hexl format.

A sample format:

  HEX ADDR: 0011 2233 4455 6677 8899 aabb ccdd eeff     ASCII-TEXT
  --------  ---- ---- ---- ---- ---- ---- ---- ----  ----------------
  00000000: 5468 6973 2069 7320 6865 786c 2d6d 6f64  This is hexl-mod
  00000010: 652e 2020 4561 6368 206c 696e 6520 7265  e.  Each line re
  00000020: 7072 6573 656e 7473 2031 3620 6279 7465  presents 16 byte
  00000030: 7320 6173 2068 6578 6164 6563 696d 616c  s as hexadecimal
  00000040: 2041 5343 4949 0a61 6e64 2070 7269 6e74   ASCII.and print
  00000050: 6162 6c65 2041 5343 4949 2063 6861 7261  able ASCII chara
  00000060: 6374 6572 732e 2020 416e 7920 636f 6e74  cters.  Any cont
  00000070: 726f 6c20 6f72 206e 6f6e 2d41 5343 4949  rol or non-ASCII
  00000080: 2063 6861 7261 6374 6572 730a 6172 6520   characters.are
  00000090: 6469 7370 6c61 7965 6420 6173 2070 6572  displayed as per
  000000a0: 696f 6473 2069 6e20 7468 6520 7072 696e  iods in the prin
  000000b0: 7461 626c 6520 6368 6172 6163 7465 7220  table character
  000000c0: 7265 6769 6f6e 2e0a                      region..

Movement is as simple as movement in a normal Emacs text buffer.
Most cursor movement bindings are the same: use \\[hexl-backward-char], \\[hexl-forward-char], \\[hexl-next-line], and \\[hexl-previous-line]
to move the cursor left, right, down, and up.

Advanced cursor movement commands (ala \\[hexl-beginning-of-line], \\[hexl-end-of-line], \\[hexl-beginning-of-buffer], and \\[hexl-end-of-buffer]) are
also supported.

There are several ways to change text in hexl mode:

Self-inserting characters are bound to `hexl-self-insert' so you
can simply type the character and it will insert itself (actually
overstrike) into the buffer.  However, inserting non-ASCII characters
requires caution: the buffer's coding-system should correspond to
the encoding on disk, and multibyte characters should be inserted
with cursor on the first byte of a multibyte sequence whose length
is identical to the length of the multibyte sequence to be inserted,
otherwise this could produce invalid multibyte sequences.  Non-ASCII
characters in ISO-2022 encodings should preferably inserted byte by
byte, to avoid problems caused by the designation sequences before
the actual characters.

\\[hexl-quoted-insert] followed by another keystroke allows you to insert the key even if
it isn't bound to self-insert.  An octal number can be supplied in place
of another key to insert the octal number's ASCII representation.

\\[hexl-insert-hex-char] will insert a given hexadecimal value
into the buffer at the current address.

\\[hexl-insert-octal-char] will insert a given octal value
into the buffer at the current address.

\\[hexl-insert-decimal-char] will insert a given decimal value
into the buffer at the current address..

\\[hexl-mode-exit] will exit `hexl-mode'.

Note: saving the file with any of the usual Emacs commands
will actually convert it back to binary format while saving.

You can use \\[hexl-find-file] to visit a file in Hexl mode.

\\[describe-bindings] for advanced commands.

(fn &optional ARG)" t)
(autoload 'hexl-find-file "hexl" "\
Edit file FILENAME as a binary file in hex dump format.
Switch to a buffer visiting file FILENAME, creating one if none exists,
and edit the file in `hexl-mode'.  The buffer's coding-system will be
no-conversion, unlike if you visit it normally and then invoke `hexl-mode'.

(fn FILENAME)" t)
(autoload 'hexlify-buffer "hexl" "\
Convert a binary buffer to hexl format.
This discards the buffer's undo information." t)
(register-definition-prefixes "hexl" '("dehexlify-buffer" "hexl-"))


;;; Generated autoloads from hfy-cmap.el

(autoload 'htmlfontify-load-rgb-file "hfy-cmap" "\
Load an X11 style rgb.txt FILE.
Search `hfy-rgb-load-path' if FILE is not specified.
Loads the variable `hfy-rgb-txt-color-map', which is used by
`hfy-fallback-color-values'.

(fn &optional FILE)" t)
(autoload 'hfy-fallback-color-values "hfy-cmap" "\
Use a fallback method for obtaining the rgb values for a color.

(fn COLOR-STRING)")
(register-definition-prefixes "hfy-cmap" '("hfy-" "htmlfontify-unload-rgb-file"))


;;; Generated autoloads from hi-lock.el

(autoload 'hi-lock-mode "hi-lock" "\
Toggle selective highlighting of patterns (Hi Lock mode).

Hi Lock mode is automatically enabled when you invoke any of the
highlighting commands listed below, such as \\[highlight-regexp].
To enable Hi Lock mode in all buffers, use `global-hi-lock-mode'
or add (global-hi-lock-mode 1) to your init file.

In buffers where Font Lock mode is enabled, patterns are
highlighted using font lock.  In buffers where Font Lock mode is
disabled, patterns are applied using overlays; in this case, the
highlighting will not be updated as you type.  The Font Lock mode
is considered \"enabled\" in a buffer if its `major-mode'
causes `font-lock-specified-p' to return non-nil, which means
the major mode specifies support for Font Lock.

When Hi Lock mode is enabled, a \"Regexp Highlighting\" submenu
is added to the \"Edit\" menu.  The commands in the submenu,
which can be called interactively, are:

\\[highlight-regexp] REGEXP FACE
  Highlight matches of pattern REGEXP in current buffer with FACE.

\\[highlight-phrase] PHRASE FACE
  Highlight matches of phrase PHRASE in current buffer with FACE.
  (PHRASE can be any REGEXP, but spaces will be replaced by matches
  to whitespace and initial lower-case letters will become case insensitive.)

\\[highlight-lines-matching-regexp] REGEXP FACE
  Highlight lines containing matches of REGEXP in current buffer with FACE.

\\[highlight-symbol-at-point]
  Highlight the symbol found near point without prompting, using the next
  available face automatically.

\\[unhighlight-regexp] REGEXP
  Remove highlighting on matches of REGEXP in current buffer.

\\[hi-lock-write-interactive-patterns]
  Write active REGEXPs into buffer as comments (if possible).  They may
  be read the next time file is loaded or when the \\[hi-lock-find-patterns] command
  is issued.  The inserted regexps are in the form of font lock keywords.
  (See `font-lock-keywords'.)  They may be edited and re-loaded with \\[hi-lock-find-patterns],
  any valid `font-lock-keywords' form is acceptable.  When a file is
  loaded the patterns are read if `hi-lock-file-patterns-policy' is
  `always', or if it's `ask' and the user responds y to the prompt,
  or if `hi-lock-file-patterns-policy' is bound to a function and that
  function returns t.

\\[hi-lock-find-patterns]
  Re-read patterns stored in buffer (in the format produced by \\[hi-lock-write-interactive-patterns]).

When hi-lock is started and if the mode is not excluded or patterns
rejected, the beginning of the buffer is searched for lines of the
form:
  Hi-lock: (FOO ...)

where (FOO ...) is a list of patterns.  The patterns must start before
position (number of characters into buffer)
`hi-lock-file-patterns-range'.  Patterns will be read until
Hi-lock: end is found.  A mode is excluded if it's in the list
`hi-lock-exclude-modes'.

This is a minor mode.  If called interactively, toggle the `Hi-Lock
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `hi-lock-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(put 'global-hi-lock-mode 'globalized-minor-mode t)
(defvar global-hi-lock-mode nil "\
Non-nil if Global Hi-Lock mode is enabled.
See the `global-hi-lock-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-hi-lock-mode'.")
(custom-autoload 'global-hi-lock-mode "hi-lock" nil)
(autoload 'global-hi-lock-mode "hi-lock" "\
Toggle Hi-Lock mode in all buffers.
With prefix ARG, enable Global Hi-Lock mode if ARG is positive;
otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Hi-Lock mode is enabled in all buffers where
`turn-on-hi-lock-if-enabled' would do it.

See `hi-lock-mode' for more information on Hi-Lock mode.

(fn &optional ARG)" t)
(defalias 'highlight-lines-matching-regexp 'hi-lock-line-face-buffer)
(autoload 'hi-lock-line-face-buffer "hi-lock" "\
Highlight all lines that match REGEXP using FACE.
The lines that match REGEXP will be displayed by merging
the attributes of FACE with any other face attributes
of text in those lines.

Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.

If REGEXP contains upper case characters (excluding those preceded by `\\')
and `search-upper-case' is non-nil, the matching is case-sensitive.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.

(fn REGEXP &optional FACE)" t)
(defalias 'highlight-regexp 'hi-lock-face-buffer)
(autoload 'hi-lock-face-buffer "hi-lock" "\
Set face of each match of REGEXP to FACE.
Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.  Limit face setting to the
corresponding SUBEXP (interactively, the prefix argument) of REGEXP.
If SUBEXP is omitted or nil, the entire REGEXP is highlighted.

LIGHTER is a human-readable string that can be used to select
a regexp to unhighlight by its name instead of selecting a possibly
complex regexp or closure.

If REGEXP contains upper case characters (excluding those preceded by `\\')
and `search-upper-case' is non-nil, the matching is case-sensitive.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.  The Font Lock mode
is considered \"enabled\" in a buffer if its `major-mode'
causes `font-lock-specified-p' to return non-nil, which means
the major mode specifies support for Font Lock.

(fn REGEXP &optional FACE SUBEXP LIGHTER)" t)
(defalias 'highlight-phrase 'hi-lock-face-phrase-buffer)
(autoload 'hi-lock-face-phrase-buffer "hi-lock" "\
Set face of each match of phrase REGEXP to FACE.
Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.

If REGEXP contains upper case characters (excluding those preceded by `\\')
and `search-upper-case' is non-nil, the matching is case-sensitive.
Also set `search-spaces-regexp' to the value of `search-whitespace-regexp'.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.  The Font Lock mode
is considered \"enabled\" in a buffer if its `major-mode'
causes `font-lock-specified-p' to return non-nil, which means
the major mode specifies support for Font Lock.

(fn REGEXP &optional FACE)" t)
(defalias 'highlight-symbol-at-point 'hi-lock-face-symbol-at-point)
(autoload 'hi-lock-face-symbol-at-point "hi-lock" "\
Highlight each instance of the symbol at point.
Uses the next face from `hi-lock-face-defaults' without prompting,
unless you use a prefix argument.
Uses `find-tag-default-as-symbol-regexp' to retrieve the symbol at point.

If REGEXP contains upper case characters (excluding those preceded by `\\')
and `search-upper-case' is non-nil, the matching is case-sensitive.

This uses Font lock mode if it is enabled; otherwise it uses overlays,
in which case the highlighting will not update as you type.  The Font
Lock mode is considered \"enabled\" in a buffer if its `major-mode'
causes `font-lock-specified-p' to return non-nil, which means
the major mode specifies support for Font Lock." t)
(defalias 'unhighlight-regexp 'hi-lock-unface-buffer)
(autoload 'hi-lock-unface-buffer "hi-lock" "\
Remove highlighting of each match to REGEXP set by hi-lock.
Interactively, prompt for REGEXP, accepting only regexps
previously inserted by hi-lock interactive functions.
If REGEXP is t (or if \\[universal-argument] was specified interactively),
then remove all hi-lock highlighting.

(fn REGEXP)" t)
(autoload 'hi-lock-write-interactive-patterns "hi-lock" "\
Write interactively added patterns, if any, into buffer at point.

Interactively added patterns are those normally specified using
`highlight-regexp' and `highlight-lines-matching-regexp'; they can
be found in variable `hi-lock-interactive-patterns'." t)
(autoload 'hi-lock-find-patterns "hi-lock" "\
Add patterns from the current buffer to the list of hi-lock patterns." t)
(autoload 'hi-lock-context-menu "hi-lock" "\
Populate MENU with a menu item to highlight symbol at CLICK.

(fn MENU CLICK)")
(register-definition-prefixes "hi-lock" '("hi-lock-" "highlight-symbol-at-mouse" "turn-on-hi-lock-if-enabled"))


;;; Generated autoloads from progmodes/hideif.el

(autoload 'hide-ifdef-mode "hideif" "\
Toggle features to hide/show #ifdef blocks (Hide-Ifdef mode).

Hide-Ifdef mode is a buffer-local minor mode for use with C and
C-like major modes.  When enabled, code within #ifdef constructs
that the C preprocessor would eliminate may be hidden from view.
Several variables affect how the hiding is done:

`hide-ifdef-env'
        An association list of defined and undefined symbols for the
        current project.  Initially, the global value of `hide-ifdef-env'
        is used.  This variable was a buffer-local variable, which limits
        hideif to parse only one C/C++ file at a time.  We've extended
        hideif to support parsing a C/C++ project containing multiple C/C++
        source files opened simultaneously in different buffers.  Therefore
        `hide-ifdef-env' can no longer be buffer local but must be global.

`hide-ifdef-define-alist'
        An association list of defined symbol lists.
        Use `hide-ifdef-set-define-alist' to save the current `hide-ifdef-env'
        and `hide-ifdef-use-define-alist' to set the current `hide-ifdef-env'
        from one of the lists in `hide-ifdef-define-alist'.

`hide-ifdef-lines'
        Set to non-nil to not show #if, #ifdef, #ifndef, #else, and
        #endif lines when hiding.

`hide-ifdef-initially'
        Indicates whether `hide-ifdefs' should be called when Hide-Ifdef mode
        is activated.

`hide-ifdef-read-only'
        Set to non-nil if you want to make buffers read only while hiding.
        After `show-ifdefs', read-only status is restored to previous value.

\\{hide-ifdef-mode-map}

This is a minor mode.  If called interactively, toggle the `Hide-Ifdef
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `hide-ifdef-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "hideif" '("backward-ifdef" "down-ifdef" "forward-ifdef" "hide-ifdef" "hif-" "next-ifdef" "previous-ifdef" "show-ifdef" "up-ifdef"))


;;; Generated autoloads from progmodes/hideshow.el

(defvar hs-special-modes-alist (mapcar #'purecopy '((c-mode "{" "}" "/[*/]" nil nil) (c-ts-mode "{" "}" "/[*/]" nil nil) (c++-mode "{" "}" "/[*/]" nil nil) (c++-ts-mode "{" "}" "/[*/]" nil nil) (bibtex-mode ("@\\S(*\\(\\s(\\)" 1)) (java-mode "{" "}" "/[*/]" nil nil) (java-ts-mode "{" "}" "/[*/]" nil nil) (js-mode "{" "}" "/[*/]" nil) (js-ts-mode "{" "}" "/[*/]" nil) (lua-ts-mode "{\\|\\[\\[" "}\\|\\]\\]" "--" nil) (mhtml-mode "{\\|<[^/>]*?" "}\\|</[^/>]*[^/]>" "<!--" mhtml-forward nil))) "\
Alist for initializing the hideshow variables for different modes.
Each element has the form
  (MODE START END COMMENT-START FORWARD-SEXP-FUNC ADJUST-BEG-FUNC
   FIND-BLOCK-BEGINNING-FUNC FIND-NEXT-BLOCK-FUNC
   LOOKING-AT-BLOCK-START-P-FUNC).

If non-nil, hideshow will use these values as regexps to define blocks
and comments, respectively for major mode MODE.

START, END and COMMENT-START are regular expressions.  A block is
defined as text surrounded by START and END.

As a special case, START may be a list of the form (COMPLEX-START
MDATA-SELECTOR), where COMPLEX-START is a regexp with multiple parts and
MDATA-SELECTOR an integer that specifies which sub-match is the proper
place to adjust point, before calling `hs-forward-sexp-func'.  Point
is adjusted to the beginning of the specified match.  For example,
see the `hs-special-modes-alist' entry for `bibtex-mode'.

For some major modes, `forward-sexp' does not work properly.  In those
cases, FORWARD-SEXP-FUNC specifies another function to use instead.

See the documentation for `hs-adjust-block-beginning' to see what is the
use of ADJUST-BEG-FUNC.

See the documentation for `hs-find-block-beginning-func' to see
what is the use of FIND-BLOCK-BEGINNING-FUNC.

See the documentation for `hs-find-next-block-func' to see what
is the use of FIND-NEXT-BLOCK-FUNC.

See the documentation for `hs-looking-at-block-start-p-func' to
see what is the use of LOOKING-AT-BLOCK-START-P-FUNC.

If any of the elements is left nil or omitted, hideshow tries to guess
appropriate values.  The regexps should not contain leading or trailing
whitespace.  Case does not matter.")
(autoload 'hs-minor-mode "hideshow" "\
Minor mode to selectively hide/show code and comment blocks.

When hideshow minor mode is on, the menu bar is augmented with hideshow
commands and the hideshow commands are enabled.
The value (hs . t) is added to `buffer-invisibility-spec'.

The main commands are: `hs-hide-all', `hs-show-all', `hs-hide-block',
`hs-show-block', `hs-hide-level' and `hs-toggle-hiding'.  There is also
`hs-hide-initial-comment-block'.

Turning hideshow minor mode off reverts the menu bar and the
variables to default values and disables the hideshow commands.

Lastly, the normal hook `hs-minor-mode-hook' is run using `run-hooks'.

Key bindings:
\\{hs-minor-mode-map}

This is a minor mode.  If called interactively, toggle the `hs minor
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `hs-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'turn-off-hideshow "hideshow" "\
Unconditionally turn off `hs-minor-mode'.")
(register-definition-prefixes "hideshow" '("hs-"))


;;; Generated autoloads from emacs-lisp/hierarchy.el

(register-definition-prefixes "hierarchy" '("hierarchy-"))


;;; Generated autoloads from hilit-chg.el

(autoload 'highlight-changes-mode "hilit-chg" "\
Toggle highlighting changes in this buffer (Highlight Changes mode).

When Highlight Changes is enabled, changes are marked with a text
property.  Normally they are displayed in a distinctive face, but
command \\[highlight-changes-visible-mode] can be used to toggle
this on and off.

Other functions for buffers in this mode include:
\\[highlight-changes-next-change] - move point to beginning of next change
\\[highlight-changes-previous-change] - move to beginning of previous change
\\[highlight-changes-remove-highlight] - remove the change face from the region
\\[highlight-changes-rotate-faces] - rotate different \"ages\" of changes
through	various faces.
\\[highlight-compare-with-file] - mark text as changed by comparing this
buffer with the contents of a file
\\[highlight-compare-buffers] highlights differences between two buffers.

This is a minor mode.  If called interactively, toggle the
`Highlight-Changes mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `highlight-changes-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'highlight-changes-visible-mode "hilit-chg" "\
Toggle visibility of highlighting due to Highlight Changes mode.

Highlight Changes Visible mode only has an effect when Highlight
Changes mode is on.  When enabled, the changed text is displayed
in a distinctive face.

The default value can be customized with variable
`highlight-changes-visibility-initial-state'.

This command does not itself set Highlight Changes mode.

This is a minor mode.  If called interactively, toggle the
`Highlight-Changes-Visible mode' mode.  If the prefix argument is
positive, enable the mode, and if it is zero or negative, disable the
mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `highlight-changes-visible-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'highlight-changes-remove-highlight "hilit-chg" "\
Remove the change face from the region between BEG and END.
This allows you to manually remove highlighting from uninteresting changes.

(fn BEG END)" t)
(autoload 'highlight-changes-next-change "hilit-chg" "\
Move to the beginning of the next change, if in Highlight Changes mode." t)
(autoload 'highlight-changes-previous-change "hilit-chg" "\
Move to the beginning of the previous change, if in Highlight Changes mode." t)
(autoload 'highlight-changes-rotate-faces "hilit-chg" "\
\"Age\" changes if in Highlight Changes mode and the changes are visible.

Current changes are displayed in the face described by the first element
of `highlight-changes-face-list', one level older changes are shown in
face described by the second element, and so on.  Very old changes remain
shown in the last face in the list.

You can automatically rotate colors when the buffer is saved by adding
this function to `write-file-functions' as a buffer-local value.  To do
this, eval the following in the buffer to be saved:

  (add-hook \\='write-file-functions \\='highlight-changes-rotate-faces nil t)" t)
(autoload 'highlight-compare-buffers "hilit-chg" "\
Compare two buffers and highlight the differences.

The default is the current buffer and the one in the next window.

If either buffer is modified and is visiting a file, you are prompted
to save the file.

Unless the buffer is unmodified and visiting a file, the buffer is
written to a temporary file for comparison.

If a buffer is read-only, differences will be highlighted but no property
changes are made, so \\[highlight-changes-next-change] and
\\[highlight-changes-previous-change] will not work.

(fn BUF-A BUF-B)" t)
(autoload 'highlight-compare-with-file "hilit-chg" "\
Compare this buffer with a file, and highlight differences.

If the buffer has a backup filename, it is used as the default when
this function is called interactively.

If the current buffer is visiting the file being compared against, it
also will have its differences highlighted.  Otherwise, the file is
read in temporarily but the buffer is deleted.

If the buffer is read-only, differences will be highlighted but no property
changes are made, so \\[highlight-changes-next-change] and
\\[highlight-changes-previous-change] will not work.

(fn FILE-B)" t)
(put 'global-highlight-changes-mode 'globalized-minor-mode t)
(defvar global-highlight-changes-mode nil "\
Non-nil if Global Highlight-Changes mode is enabled.
See the `global-highlight-changes-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-highlight-changes-mode'.")
(custom-autoload 'global-highlight-changes-mode "hilit-chg" nil)
(autoload 'global-highlight-changes-mode "hilit-chg" "\
Toggle Highlight-Changes mode in all buffers.
With prefix ARG, enable Global Highlight-Changes mode if ARG is
positive; otherwise, disable it.

If called from Lisp, toggle the mode if ARG is `toggle'.
Enable the mode if ARG is nil, omitted, or is a positive number.
Disable the mode if ARG is a negative number.

Highlight-Changes mode is enabled in all buffers where
`highlight-changes-mode-turn-on' would do it.

See `highlight-changes-mode' for more information on Highlight-Changes
mode.

(fn &optional ARG)" t)
(register-definition-prefixes "hilit-chg" '("highlight-" "hilit-chg-"))


;;; Generated autoloads from hippie-exp.el

(defvar hippie-expand-try-functions-list '(try-complete-file-name-partially try-complete-file-name try-expand-all-abbrevs try-expand-list try-expand-line try-expand-dabbrev try-expand-dabbrev-all-buffers try-expand-dabbrev-from-kill try-complete-lisp-symbol-partially try-complete-lisp-symbol) "\
The list of expansion functions tried in order by `hippie-expand'.
To change the behavior of `hippie-expand', remove, change the order of,
or insert functions in this list.")
(custom-autoload 'hippie-expand-try-functions-list "hippie-exp" t)
(autoload 'hippie-expand "hippie-exp" "\
Try to expand text before point, using multiple methods.
The expansion functions in `hippie-expand-try-functions-list' are
tried in order, until a possible expansion is found.  Repeated
application of `hippie-expand' inserts successively possible
expansions.
With a positive numeric argument, jumps directly to the ARG next
function in this list.  With a negative argument or just \\[universal-argument],
undoes the expansion.

(fn ARG)" t)
(autoload 'make-hippie-expand-function "hippie-exp" "\
Construct a function similar to `hippie-expand'.
Make it use the expansion functions in TRY-LIST.  An optional second
argument VERBOSE non-nil makes the function verbose.

(fn TRY-LIST &optional VERBOSE)")
(register-definition-prefixes "hippie-exp" '("he-" "hippie-expand-" "try-"))


;;; Generated autoloads from hl-line.el

(autoload 'hl-line-mode "hl-line" "\
Toggle highlighting of the current line (Hl-Line mode).

Hl-Line mode is a buffer-local minor mode.  If
`hl-line-sticky-flag' is non-nil, Hl-Line mode highlights the
line about the buffer's point in all windows.  Caveat: the
buffer's point might be different from the point of a
non-selected window.  Hl-Line mode uses the function
`hl-line-highlight' on `post-command-hook' in this case.

When `hl-line-sticky-flag' is nil, Hl-Line mode highlights the
line about point in the selected window only.

This is a minor mode.  If called interactively, toggle the `Hl-Line
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `hl-line-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar global-hl-line-mode nil "\
Non-nil if Global Hl-Line mode is enabled.
See the `global-hl-line-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-hl-line-mode'.")
(custom-autoload 'global-hl-line-mode "hl-line" nil)
(autoload 'global-hl-line-mode "hl-line" "\
Toggle line highlighting in all buffers (Global Hl-Line mode).

If `global-hl-line-sticky-flag' is non-nil, Global Hl-Line mode
highlights the line about the current buffer's point in all live
windows.

Global-Hl-Line mode uses the function `global-hl-line-highlight'
on `post-command-hook'.

This is a global minor mode.  If called interactively, toggle the
`Global Hl-Line mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='global-hl-line-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "hl-line" '("global-hl-line-" "hl-line-"))


;;; Generated autoloads from net/hmac-def.el

(register-definition-prefixes "hmac-def" '("define-hmac-function"))


;;; Generated autoloads from net/hmac-md5.el

(register-definition-prefixes "hmac-md5" '("hmac-md5" "md5-binary"))


;;; Generated autoloads from calendar/holidays.el

(defvar holiday-general-holidays (mapcar 'purecopy '((holiday-fixed 1 1 "New Year's Day") (holiday-float 1 1 3 "Martin Luther King Day") (holiday-fixed 2 2 "Groundhog Day") (holiday-fixed 2 14 "Valentine's Day") (holiday-float 2 1 3 "President's Day") (holiday-fixed 3 17 "St. Patrick's Day") (holiday-fixed 4 1 "April Fools' Day") (holiday-float 5 0 2 "Mother's Day") (holiday-float 5 1 -1 "Memorial Day") (holiday-fixed 6 14 "Flag Day") (holiday-float 6 0 3 "Father's Day") (holiday-fixed 7 4 "Independence Day") (holiday-float 9 1 1 "Labor Day") (holiday-float 10 1 2 "Columbus Day") (holiday-fixed 10 31 "Halloween") (holiday-fixed 11 11 "Veteran's Day") (holiday-float 11 4 4 "Thanksgiving"))) "\
General holidays.  Default value is for the United States.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-general-holidays "holidays" t)
(put 'holiday-general-holidays 'risky-local-variable t)
(defvar holiday-oriental-holidays (mapcar 'purecopy '((holiday-chinese-new-year) (if calendar-chinese-all-holidays-flag (append (holiday-chinese 1 15 "Lantern Festival") (holiday-chinese-qingming) (holiday-chinese 5 5 "Dragon Boat Festival") (holiday-chinese 7 7 "Double Seventh Festival") (holiday-chinese 8 15 "Mid-Autumn Festival") (holiday-chinese 9 9 "Double Ninth Festival") (holiday-chinese-winter-solstice))))) "\
Oriental holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-oriental-holidays "holidays" t)
(put 'holiday-oriental-holidays 'risky-local-variable t)
(defvar holiday-local-holidays nil "\
Local holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-local-holidays "holidays" t)
(put 'holiday-local-holidays 'risky-local-variable t)
(defvar holiday-other-holidays nil "\
User defined holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-other-holidays "holidays" t)
(put 'holiday-other-holidays 'risky-local-variable t)
(defvar holiday-hebrew-holidays (mapcar 'purecopy '((holiday-hebrew-passover) (holiday-hebrew-rosh-hashanah) (holiday-hebrew-hanukkah) (if calendar-hebrew-all-holidays-flag (append (holiday-hebrew-tisha-b-av) (holiday-hebrew-misc))))) "\
Jewish holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-hebrew-holidays "holidays" t)
(put 'holiday-hebrew-holidays 'risky-local-variable t)
(defvar holiday-christian-holidays (mapcar 'purecopy '((holiday-easter-etc) (holiday-fixed 12 25 "Christmas") (if calendar-christian-all-holidays-flag (append (holiday-fixed 1 6 "Epiphany") (holiday-julian 12 25 "Christmas (Julian calendar)") (holiday-greek-orthodox-easter) (holiday-fixed 8 15 "Assumption") (holiday-advent 0 "Advent"))))) "\
Christian holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-christian-holidays "holidays" t)
(put 'holiday-christian-holidays 'risky-local-variable t)
(defvar holiday-islamic-holidays (mapcar 'purecopy '((holiday-islamic-new-year) (holiday-islamic 9 1 "Ramadan Begins") (if calendar-islamic-all-holidays-flag (append (holiday-islamic 1 10 "Ashura") (holiday-islamic 3 12 "Mulad-al-Nabi") (holiday-islamic 7 26 "Shab-e-Mi'raj") (holiday-islamic 8 15 "Shab-e-Bara't") (holiday-islamic 9 27 "Shab-e Qadr") (holiday-islamic 10 1 "Id-al-Fitr") (holiday-islamic 12 10 "Id-al-Adha"))))) "\
Islamic holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-islamic-holidays "holidays" t)
(put 'holiday-islamic-holidays 'risky-local-variable t)
(defvar holiday-bahai-holidays (mapcar 'purecopy '((holiday-bahai-new-year) (holiday-bahai-ridvan) (holiday-fixed 5 23 "Declaration of the Báb") (holiday-fixed 5 29 "Ascension of Bahá’u’lláh") (holiday-fixed 7 9 "Martyrdom of the Báb") (holiday-fixed 10 20 "Birth of the Báb") (holiday-fixed 11 12 "Birth of Bahá’u’lláh") (if calendar-bahai-all-holidays-flag (append (holiday-fixed 11 26 "Day of the Covenant") (holiday-fixed 11 28 "Ascension of `Abdu’l-Bahá"))))) "\
Bahá’í holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-bahai-holidays "holidays" t)
(put 'holiday-bahai-holidays 'risky-local-variable t)
(defvar holiday-solar-holidays (mapcar 'purecopy '((solar-equinoxes-solstices) (holiday-sexp calendar-daylight-savings-starts (format "Daylight Saving Time Begins %s" (solar-time-string (/ calendar-daylight-savings-starts-time (float 60)) calendar-standard-time-zone-name))) (holiday-sexp calendar-daylight-savings-ends (format "Daylight Saving Time Ends %s" (solar-time-string (/ calendar-daylight-savings-ends-time (float 60)) calendar-daylight-time-zone-name))))) "\
Sun-related holidays.
See the documentation for `calendar-holidays' for details.")
(custom-autoload 'holiday-solar-holidays "holidays" t)
(put 'holiday-solar-holidays 'risky-local-variable t)
(put 'calendar-holidays 'risky-local-variable t)
(autoload 'holidays "holidays" "\
Display the holidays for last month, this month, and next month.
If called with an optional prefix argument ARG, prompts for month and year.
This function is suitable for execution in an init file.

(fn &optional ARG)" t)
(autoload 'list-holidays "holidays" "\
Display holidays for years Y1 to Y2 (inclusive).
Y2 defaults to Y1.  The optional list of holidays L defaults to
`calendar-holidays'.  If you want to control what holidays are
displayed, use a different list.  For example,

  (list-holidays 2006 2006
    (append holiday-general-holidays holiday-local-holidays))

will display holidays for the year 2006 defined in the two
mentioned lists, and nothing else.

When called interactively, this command offers a choice of
holidays, based on the variables `holiday-solar-holidays' etc.  See the
documentation of `calendar-holidays' for a list of the variables
that control the choices, as well as a description of the format
of a holiday list.

The optional LABEL is used to label the buffer created.

The list of holiday lists is computed by the
`holiday-available-holiday-lists' and you can alter the results
by redefining that function, or use `add-function' to add
values.

(fn Y1 &optional Y2 L LABEL)" t)
(defalias 'holiday-list 'list-holidays)
(register-definition-prefixes "holidays" '("calendar-" "holiday-"))


;;; Generated autoloads from cedet/semantic/html.el

(register-definition-prefixes "semantic/html" '("semantic-"))


;;; Generated autoloads from textmodes/html-ts-mode.el

(autoload 'html-ts-mode "html-ts-mode" "\
Major mode for editing Html, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "html-ts-mode" '("html-ts-mode-"))


;;; Generated autoloads from htmlfontify.el

(autoload 'htmlfontify-buffer "htmlfontify" "\
Create a new buffer, named for the current buffer + a .html extension,
containing an inline CSS-stylesheet and formatted CSS-markup HTML
that reproduces the look of the current Emacs buffer as closely
as possible.

Dangerous characters in the existing buffer are turned into HTML
entities, so you should even be able to do HTML-within-HTML
fontified display.

You should, however, note that random control or non-ASCII
characters such as ^L (U+000C FORM FEED (FF)) or ¤ (U+00A4
CURRENCY SIGN) won't get mapped yet.

If the SRCDIR and FILE arguments are set, lookup etags derived
entries in the `hfy-tags-cache' and add HTML anchors and
hyperlinks as appropriate.

(fn &optional SRCDIR FILE)" t)
(autoload 'htmlfontify-copy-and-link-dir "htmlfontify" "\
Trawl SRCDIR and write fontified-and-hyperlinked output in DSTDIR.
F-EXT and L-EXT specify values for `hfy-extn' and `hfy-link-extn'.

You may also want to set `hfy-page-header' and `hfy-page-footer'.

(fn SRCDIR DSTDIR &optional F-EXT L-EXT)" t)
(register-definition-prefixes "htmlfontify" '("hfy-" "htmlfontify-"))


;;; Generated autoloads from cedet/semantic/ia.el

(register-definition-prefixes "semantic/ia" '("semantic-ia-"))


;;; Generated autoloads from cedet/semantic/ia-sb.el

(register-definition-prefixes "semantic/ia-sb" '("semantic-ia-s"))


;;; Generated autoloads from ibuf-ext.el

(register-definition-prefixes "ibuf-ext" '("ibuffer-"))


;;; Generated autoloads from ibuf-macs.el

(autoload 'define-ibuffer-column "ibuf-macs" "\
Define a column SYMBOL for use with `ibuffer-formats'.

BODY will be called with `buffer' bound to the buffer object, and
`mark' bound to the current mark on the buffer.  The original ibuffer
buffer will be bound to `ibuffer-buf'.

If NAME is given, it will be used as a title for the column.
Otherwise, the title will default to a capitalized version of the
SYMBOL's name.  PROPS is a plist of additional properties to add to
the text, such as `mouse-face'.  And SUMMARIZER, if given, is a
function which will be passed a list of all the strings in its column;
it should return a string to display at the bottom.

If HEADER-MOUSE-MAP is given, it will be used as a keymap for the
title of the column.

Note that this macro expands into a `defun' for a function named
ibuffer-make-column-NAME.  If INLINE is non-nil, then the form will be
inlined into the compiled format versions.  This means that if you
change its definition, you should explicitly call
`ibuffer-recompile-formats'.

(fn SYMBOL (&key NAME INLINE PROPS SUMMARIZER) &rest BODY)" nil t)
(function-put 'define-ibuffer-column 'lisp-indent-function 'defun)
(autoload 'define-ibuffer-sorter "ibuf-macs" "\
Define a method of sorting named NAME.
DOCUMENTATION is the documentation of the function, which will be called
`ibuffer-do-sort-by-NAME'.
DESCRIPTION is a short string describing the sorting method.

For sorting, the forms in BODY will be evaluated with `a' bound to one
buffer object, and `b' bound to another.  BODY should return a non-nil
value if and only if `a' is \"less than\" `b'.

(fn NAME DOCUMENTATION (&key DESCRIPTION) &rest BODY)" nil t)
(function-put 'define-ibuffer-sorter 'lisp-indent-function 1)
(function-put 'define-ibuffer-sorter 'doc-string-elt 2)
(autoload 'define-ibuffer-op "ibuf-macs" "\
Generate a function which operates on a buffer.
OP becomes the name of the function; if it doesn't begin with
`ibuffer-do-', then that is prepended to it.
When an operation is performed, this function will be called once for
each marked buffer, with that buffer current.

ARGS becomes the formal parameters of the function.
DOCUMENTATION becomes the docstring of the function.
INTERACTIVE becomes the interactive specification of the function.
MARK describes which type of mark (:deletion, or nil) this operation
uses.  :deletion means the function operates on buffers marked for
deletion, otherwise it acts on normally marked buffers.
MODIFIER-P describes how the function modifies buffers.  This is used
to set the modification flag of the Ibuffer buffer itself.  Valid
values are:
 nil - the function never modifiers buffers
 t - the function it always modifies buffers
 :maybe - attempt to discover this information by comparing the
  buffer's modification flag.
DANGEROUS is a boolean which should be set if the user should be
prompted before performing this operation.
OPSTRING is a string which will be displayed to the user after the
operation is complete, in the form:
 \"Operation complete; OPSTRING x buffers\"
ACTIVE-OPSTRING is a string which will be displayed to the user in a
confirmation message, in the form:
 \"Really ACTIVE-OPSTRING x buffers?\"
BEFORE is a form to evaluate before start the operation.
AFTER is a form to evaluate once the operation is complete.
COMPLEX means this function is special; if COMPLEX is nil BODY
evaluates once for each marked buffer, MBUF, with MBUF current
and saving the point.  If COMPLEX is non-nil, BODY evaluates
without requiring MBUF current.
BODY define the operation; they are forms to evaluate per each
marked buffer.  BODY is evaluated with `buf' bound to the
buffer object.

(fn OP ARGS DOCUMENTATION (&key INTERACTIVE MARK MODIFIER-P DANGEROUS OPSTRING ACTIVE-OPSTRING BEFORE AFTER COMPLEX) &rest BODY)" nil t)
(function-put 'define-ibuffer-op 'lisp-indent-function 2)
(function-put 'define-ibuffer-op 'doc-string-elt 3)
(autoload 'define-ibuffer-filter "ibuf-macs" "\
Define a filter named NAME.
DOCUMENTATION is the documentation of the function.
READER is a form which should read a qualifier from the user.
DESCRIPTION is a short string describing the filter.
ACCEPT-LIST is a boolean; if non-nil, the filter accepts either
a single condition or a list of them; in the latter
case the filter is the `or' composition of the conditions.

BODY should contain forms which will be evaluated to test whether or
not a particular buffer should be displayed or not.  The forms in BODY
will be evaluated with BUF bound to the buffer object, and QUALIFIER
bound to the current value of the filter.

(fn NAME DOCUMENTATION (&key READER DESCRIPTION) &rest BODY)" nil t)
(function-put 'define-ibuffer-filter 'lisp-indent-function 2)
(function-put 'define-ibuffer-filter 'doc-string-elt 2)
(register-definition-prefixes "ibuf-macs" '("ibuffer-"))


;;; Generated autoloads from ibuffer.el

(autoload 'ibuffer-list-buffers "ibuffer" "\
Display a list of buffers, in another window.
If optional argument FILES-ONLY is non-nil, then add a filter for
buffers which are visiting a file.

(fn &optional FILES-ONLY)" t)
(autoload 'ibuffer-other-window "ibuffer" "\
Like `ibuffer', but displayed in another window by default.
If optional argument FILES-ONLY is non-nil, then add a filter for
buffers which are visiting a file.

(fn &optional FILES-ONLY)" t)
(autoload 'ibuffer "ibuffer" "\
Begin using Ibuffer to edit a list of buffers.
Type \\<ibuffer-mode-map>\\[describe-mode] after entering ibuffer for more information.

All arguments are optional.
OTHER-WINDOW-P says to use another window.
NAME specifies the name of the buffer (defaults to \"*Ibuffer*\").
QUALIFIERS is an initial set of filtering qualifiers to use;
  see `ibuffer-filtering-qualifiers'.
NOSELECT means don't select the Ibuffer buffer.
SHRINK means shrink the buffer to minimal size.  The special
  value `onewindow' means always use another window.
FILTER-GROUPS is an initial set of filtering groups to use;
  see `ibuffer-filter-groups'.
FORMATS is the value to use for `ibuffer-formats'.
  If specified, then the variable `ibuffer-formats' will have
  that value locally in this buffer.

(fn &optional OTHER-WINDOW-P NAME QUALIFIERS NOSELECT SHRINK FILTER-GROUPS FORMATS)" t)
(autoload 'ibuffer-jump "ibuffer" "\
Call Ibuffer and set point at the line listing the current buffer.
If optional arg OTHER-WINDOW is non-nil, then use another window.

(fn &optional OTHER-WINDOW)" t)
(register-definition-prefixes "ibuffer" '("ibuffer-"))


;;; Generated autoloads from calendar/icalendar.el

(autoload 'icalendar-export-file "icalendar" "\
Export diary file to iCalendar format.
All diary entries in the file DIARY-FILENAME are converted to iCalendar
format.  The result is appended to the file ICAL-FILENAME.

(fn DIARY-FILENAME ICAL-FILENAME)" t)
(autoload 'icalendar-export-region "icalendar" "\
Export region in diary file to iCalendar format.
All diary entries in the region from MIN to MAX in the current buffer are
converted to iCalendar format.  The result is appended to the file
ICAL-FILENAME.
This function attempts to return t if something goes wrong.  In this
case an error string which describes all the errors and problems is
written into the buffer `*icalendar-errors*'.

(fn MIN MAX ICAL-FILENAME)" t)
(autoload 'icalendar-import-file "icalendar" "\
Import an iCalendar file and append to a diary file.
Argument ICAL-FILENAME output iCalendar file.
Argument DIARY-FILENAME input `diary-file'.
Optional argument NON-MARKING determines whether events are created as
non-marking or not.

(fn ICAL-FILENAME DIARY-FILENAME &optional NON-MARKING)" t)
(autoload 'icalendar-import-buffer "icalendar" "\
Extract iCalendar events from current buffer.

This function searches the current buffer for the first iCalendar
object, reads it and adds all VEVENT elements to the diary
DIARY-FILENAME.

It will ask for each appointment whether to add it to the diary
unless DO-NOT-ASK is non-nil.  When called interactively,
DO-NOT-ASK is nil, so that you are asked for each event.

NON-MARKING determines whether diary events are created as
non-marking.

Return code t means that importing worked well, return code nil
means that an error has occurred.  Error messages will be in the
buffer `*icalendar-errors*'.

(fn &optional DIARY-FILENAME DO-NOT-ASK NON-MARKING)" t)
(register-definition-prefixes "icalendar" '("icalendar-"))


;;; Generated autoloads from icomplete.el

(defvar fido-mode nil "\
Non-nil if Fido mode is enabled.
See the `fido-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `fido-mode'.")
(custom-autoload 'fido-mode "icomplete" nil)
(autoload 'fido-mode "icomplete" "\
An enhanced `icomplete-mode' that emulates `ido-mode'.

This global minor mode makes minibuffer completion behave
more like `ido-mode' than regular `icomplete-mode'.

This is a global minor mode.  If called interactively, toggle the `Fido
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='fido-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar icomplete-mode nil "\
Non-nil if Icomplete mode is enabled.
See the `icomplete-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `icomplete-mode'.")
(custom-autoload 'icomplete-mode "icomplete" nil)
(autoload 'icomplete-mode "icomplete" "\
Toggle incremental minibuffer completion (Icomplete mode).

When this global minor mode is enabled, typing in the minibuffer
continuously displays a list of possible completions that match
the string you have typed.  See `icomplete-completions' for a
description of how prospective completions are displayed.

For more information, see Info node `(emacs)Icomplete'.
For options you can set, `\\[customize-group] icomplete'.

You can use the following key bindings to navigate and select
completions:

\\{icomplete-minibuffer-map}

This is a global minor mode.  If called interactively, toggle the
`Icomplete mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='icomplete-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar icomplete-vertical-mode nil "\
Non-nil if Icomplete-Vertical mode is enabled.
See the `icomplete-vertical-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `icomplete-vertical-mode'.")
(custom-autoload 'icomplete-vertical-mode "icomplete" nil)
(autoload 'icomplete-vertical-mode "icomplete" "\
Toggle vertical candidate display in `icomplete-mode' or `fido-mode'.

If none of these modes are on, turn on `icomplete-mode'.

As many completion candidates as possible are displayed, depending on
the value of `max-mini-window-height', and the way the mini-window is
resized depends on `resize-mini-windows'.

This is a global minor mode.  If called interactively, toggle the
`Icomplete-Vertical mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='icomplete-vertical-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(defvar fido-vertical-mode nil "\
Non-nil if Fido-Vertical mode is enabled.
See the `fido-vertical-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `fido-vertical-mode'.")
(custom-autoload 'fido-vertical-mode "icomplete" nil)
(autoload 'fido-vertical-mode "icomplete" "\
Toggle vertical candidate display in `fido-mode'.

When turning on, if non-vertical `fido-mode' is off, turn it on.
If it's on, just add the vertical display.

This is a global minor mode.  If called interactively, toggle the
`Fido-Vertical mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='fido-vertical-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(when (locate-library "obsolete/iswitchb")
 (autoload 'iswitchb-mode "iswitchb" "Toggle Iswitchb mode." t)
 (make-obsolete 'iswitchb-mode
   "use `icomplete-mode' or `ido-mode' instead." "24.4"))
(register-definition-prefixes "icomplete" '("icomplete-"))


;;; Generated autoloads from progmodes/icon.el

(autoload 'icon-mode "icon" "\
Major mode for editing Icon code.
Expression and list commands understand all Icon brackets.
Tab indents for Icon code.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{icon-mode-map}
Variables controlling indentation style:
 icon-tab-always-indent
    Non-nil means TAB in Icon mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 icon-auto-newline
    Non-nil means automatically newline before and after braces
    inserted in Icon code.
 icon-indent-level
    Indentation of Icon statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 icon-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 icon-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `icon-continued-statement-offset'.
 icon-brace-offset
    Extra indentation for line if it starts with an open brace.
 icon-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.

Turning on Icon mode calls the value of the variable `icon-mode-hook'
with no args, if that value is non-nil.

(fn)" t)
(register-definition-prefixes "icon" '("beginning-of-icon-defun" "calculate-icon-indent" "electric-icon-brace" "end-of-icon-defun" "icon-" "indent-icon-exp" "mark-icon-function"))


;;; Generated autoloads from emacs-lisp/icons.el

(autoload 'describe-icon "icons" "\
Pop to a buffer to describe ICON.

(fn ICON)" t)
(register-definition-prefixes "icons" '("button" "define-icon" "icon"))


;;; Generated autoloads from cedet/semantic/idle.el

(register-definition-prefixes "semantic/idle" '("define-semantic-idle-service" "global-semantic-idle-summary-mode" "semantic-"))


;;; Generated autoloads from progmodes/idlw-complete-structtag.el

(register-definition-prefixes "idlw-complete-structtag" '("idlwave-"))


;;; Generated autoloads from progmodes/idlw-help.el

(register-definition-prefixes "idlw-help" '("idlwave-"))


;;; Generated autoloads from progmodes/idlw-shell.el

(autoload 'idlwave-shell "idlw-shell" "\
Run an inferior IDL, with I/O through buffer `(idlwave-shell-buffer)'.
If buffer exists but shell process is not running, start new IDL.
If buffer exists and shell process is running, just switch to the buffer.

When called with a prefix ARG, or when `idlwave-shell-use-dedicated-frame'
is non-nil, the shell buffer and the source buffers will be in
separate frames.

The command to run comes from variable `idlwave-shell-explicit-file-name',
with options taken from `idlwave-shell-command-line-options'.

The buffer is put in `idlwave-shell-mode', providing commands for sending
input and controlling the IDL job.  See help on `idlwave-shell-mode'.
See also the variable `idlwave-shell-prompt-pattern'.

(Type \\[describe-mode] in the shell buffer for a list of commands.)

(fn &optional ARG)" t)
(register-definition-prefixes "idlw-shell" '("idlwave-"))


;;; Generated autoloads from progmodes/idlw-toolbar.el

(register-definition-prefixes "idlw-toolbar" '("idlwave-toolbar"))


;;; Generated autoloads from progmodes/idlwave.el

(push (purecopy '(idlwave 6 1 22)) package--builtin-versions)
(autoload 'idlwave-mode "idlwave" "\
Major mode for editing IDL source files (version 6.1_em22).

The main features of this mode are

1. Indentation and Formatting
   --------------------------
   Like other Emacs programming modes, C-j inserts a newline and indents.
   TAB is used for explicit indentation of the current line.

   To start a continuation line, use \\[idlwave-split-line].  This
   function can also be used in the middle of a line to split the line
   at that point.  When used inside a long constant string, the string
   is split at that point with the `+' concatenation operator.

   Comments are indented as follows:

   `;;;' Indentation remains unchanged.
   `;;'  Indent like the surrounding code
   `;'   Indent to a minimum column.

   The indentation of comments starting in column 0 is never changed.

   Use \\[idlwave-fill-paragraph] to refill a paragraph inside a
   comment.  The indentation of the second line of the paragraph
   relative to the first will be retained.  Use
   \\[auto-fill-mode] to toggle auto-fill mode for these
   comments.  When the variable `idlwave-fill-comment-line-only' is
   nil, code can also be auto-filled and auto-indented.

   To convert pre-existing IDL code to your formatting style, mark the
   entire buffer with \\[mark-whole-buffer] and execute
   \\[idlwave-expand-region-abbrevs].  Then mark the entire buffer
   again followed by \\[indent-region] (`indent-region').

2. Routine Info
   ------------
   IDLWAVE displays information about the calling sequence and the
   accepted keyword parameters of a procedure or function with
   \\[idlwave-routine-info].  \\[idlwave-find-module] jumps to the
   source file of a module.  These commands know about system
   routines, all routines in idlwave-mode buffers and (when the
   idlwave-shell is active) about all modules currently compiled under
   this shell.  It also makes use of pre-compiled or custom-scanned
   user and library catalogs many popular libraries ship with by
   default.  Use \\[idlwave-update-routine-info] to update this
   information, which is also used for completion (see item 4).

3. Online IDL Help
   ---------------

   \\[idlwave-context-help] displays the IDL documentation relevant
   for the system variable, keyword, or routines at point.  A single
   key stroke gets you directly to the right place in the docs.  See
   the manual to configure where and how the HTML help is displayed.

4. Completion
   ----------
   \\[idlwave-complete] completes the names of procedures, functions
   class names, keyword parameters, system variables and tags, class
   tags, structure tags, filenames and much more.  It is context
   sensitive and figures out what is expected at point.  Lower case
   strings are completed in lower case, other strings in mixed or
   upper case.

5. Code Templates and Abbreviations
   --------------------------------
   Many Abbreviations are predefined to expand to code fragments and templates.
   The abbreviations start generally with a `\\'.  Some examples:

   \\pr        PROCEDURE template
   \\fu        FUNCTION template
   \\c         CASE statement template
   \\sw        SWITCH statement template
   \\f         FOR loop template
   \\r         REPEAT Loop template
   \\w         WHILE loop template
   \\i         IF statement template
   \\elif      IF-ELSE statement template
   \\b         BEGIN

   For a full list, use \\[idlwave-list-abbrevs].  Some templates also
   have direct keybindings - see the list of keybindings below.

   \\[idlwave-doc-header] inserts a documentation header at the
   beginning of the current program unit (pro, function or main).
   Change log entries can be added to the current program unit with
   \\[idlwave-doc-modification].

6. Automatic Case Conversion
   -------------------------
   The case of reserved words and some abbrevs is controlled by
   `idlwave-reserved-word-upcase' and `idlwave-abbrev-change-case'.

7. Automatic END completion
   ------------------------
   If the variable `idlwave-expand-generic-end' is non-nil, each END typed
   will be converted to the specific version, like ENDIF, ENDFOR, etc.

8. Hooks
   -----
   Turning on `idlwave-mode' runs `idlwave-mode-hook'.

9. Documentation and Customization
   -------------------------------
   Info documentation for this package is available.  Use
   \\[idlwave-info] to display (complain to your sysadmin if that does
   not work).  For Postscript, PDF, and HTML versions of the
   documentation, check IDLWAVE's website at URL
   `https://github.com/jdtsmith/idlwave'.
   IDLWAVE has customize support - see the group `idlwave'.

10.Keybindings
   -----------
   Here is a list of all keybindings of this mode.
   If some of the key bindings below show with ??, use \\[describe-key]
   followed by the key sequence to see what the key sequence does.

\\{idlwave-mode-map}

(fn)" t)
(register-definition-prefixes "idlwave" '("idlwave-"))


;;; Generated autoloads from ido.el

(defvar ido-mode nil "\
Determines for which buffer/file Ido should be enabled.
The following values are possible:
- `buffer': Turn only on Ido buffer behavior (switching, killing,
  displaying...)
- `file': Turn only on Ido file behavior (finding, writing, inserting...)
- `both': Turn on Ido buffer and file behavior.
-  nil: Turn off any Ido switching.

Setting this variable directly does not take effect;
use either \\[customize] or the function `ido-mode'.")
(custom-autoload 'ido-mode "ido" nil)
(autoload 'ido-mode "ido" "\
Toggle Ido mode on or off.
With ARG, turn Ido mode on if arg is positive, off otherwise.
Turning on Ido mode will remap (via a minor-mode keymap) the default
keybindings for the `find-file' and `switch-to-buffer' families of
commands to the Ido versions of these functions.
However, if ARG arg equals `files', remap only commands for files, or
if it equals `buffers', remap only commands for buffer switching.
This function also adds a hook to the minibuffer.

(fn &optional ARG)" t)
(autoload 'ido-switch-buffer "ido" "\
Switch to another buffer.
The buffer is displayed according to `ido-default-buffer-method' -- the
default is to show it in the same window, unless it is already visible
in another frame.

As you type in a string, all of the buffers matching the string are
displayed if substring-matching is used (default).  Look at
`ido-enable-prefix' and `ido-toggle-prefix'.  When you have found the
buffer you want, it can then be selected.  As you type, most keys have
their normal keybindings, except for the following: \\<ido-buffer-completion-map>

RET	Select the buffer at the front of the list of matches.
	If the list is empty, possibly prompt to create new buffer.

\\[ido-select-text]	Use the current input string verbatim.

\\[ido-next-match]	Put the first element at the end of the list.
\\[ido-prev-match]	Put the last element at the start of the list.
\\[ido-complete]	Complete a common suffix to the current string that matches
	all buffers.  If there is only one match, select that buffer.
	If there is no common suffix, show a list of all matching buffers
	in a separate window.
\\[ido-edit-input]	Edit input string.
\\[ido-fallback-command]	Fallback to non-ido version of current command.
\\[ido-toggle-regexp]	Toggle regexp searching.
\\[ido-toggle-prefix]	Toggle between substring and prefix matching.
\\[ido-toggle-case]	Toggle case-sensitive searching of buffer names.
\\[ido-completion-help]	Show list of matching buffers in separate window.
\\[ido-enter-find-file]	Drop into `ido-find-file'.
\\[ido-kill-buffer-at-head]	Kill buffer at head of buffer list.
\\[ido-toggle-ignore]	Toggle ignoring buffers listed in `ido-ignore-buffers'." t)
(autoload 'ido-switch-buffer-other-window "ido" "\
Switch to another buffer and show it in another window.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'." t)
(autoload 'ido-display-buffer "ido" "\
Display a buffer in another window but don't select it.

If ACTION (the prefix argument interactively), display the buffer
in another windown even if it's already displayed in the current
window.

The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

(fn &optional ACTION)" t)
(autoload 'ido-display-buffer-other-frame "ido" "\
Display a buffer preferably in another frame.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'." t)
(autoload 'ido-kill-buffer "ido" "\
Kill a buffer.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'." t)
(autoload 'ido-insert-buffer "ido" "\
Insert contents of a buffer in current buffer after point.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'." t)
(autoload 'ido-switch-buffer-other-frame "ido" "\
Switch to another buffer and show it in another frame.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'." t)
(autoload 'ido-find-file-in-dir "ido" "\
Switch to another file starting from DIR.

(fn DIR)" t)
(autoload 'ido-find-file "ido" "\
Edit file with name obtained via minibuffer.
The file is displayed according to `ido-default-file-method' -- the
default is to show it in the same window, unless it is already visible
in another frame.

The file name is selected interactively by typing a substring.  As you
type in a string, all of the filenames matching the string are displayed
if substring-matching is used (default).  Look at `ido-enable-prefix' and
`ido-toggle-prefix'.  When you have found the filename you want, it can
then be selected.  As you type, most keys have their normal keybindings,
except for the following: \\<ido-file-completion-map>

RET	Select the file at the front of the list of matches.
	If the list is empty, possibly prompt to create new file.

\\[ido-select-text]	Use the current input string verbatim.

\\[ido-next-match]	Put the first element at the end of the list.
\\[ido-prev-match]	Put the last element at the start of the list.
\\[ido-complete]	Complete a common suffix to the current string that matches
	all files.  If there is only one match, select that file.
	If there is no common suffix, show a list of all matching files
	in a separate window.
\\[ido-magic-delete-char]	Open the specified directory in Dired mode.
\\[ido-edit-input]	Edit input string (including directory).
\\[ido-prev-work-directory]	Go to previous directory in work directory history.
\\[ido-next-work-directory]	Go to next directory in work directory history.
\\[ido-merge-work-directories]	Search for file in the work directory history.
\\[ido-forget-work-directory]	Remove current directory from the work directory history.
\\[ido-prev-work-file]	Cycle to previous file in work file history.
\\[ido-next-work-file]	Cycle to next file in work file history.
\\[ido-wide-find-file-or-pop-dir]	Prompt for a file and use find to locate it.
\\[ido-wide-find-dir-or-delete-dir]	Prompt for a directory and use find to locate it.
\\[ido-make-directory]	Prompt for a directory to create in current directory.
\\[ido-fallback-command]	Fallback to non-Ido version of current command.
\\[ido-toggle-regexp]	Toggle regexp searching.
\\[ido-toggle-prefix]	Toggle between substring and prefix matching.
\\[ido-toggle-case]	Toggle case-sensitive searching of file names.
\\[ido-toggle-literal]	Toggle literal reading of this file.
\\[ido-completion-help]	Show list of matching files in separate window.
\\[ido-toggle-ignore]	Toggle ignoring files listed in `ido-ignore-files'.
\\[ido-reread-directory]	Reread the current directory." t)
(autoload 'ido-find-file-other-window "ido" "\
Switch to another file and show it in another window.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-alternate-file "ido" "\
Find another file, select its buffer, kill previous buffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-alternate-file-other-window "ido" "\
Find file as a replacement for the file in the next window.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-file-read-only "ido" "\
Edit file read-only with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-file-read-only-other-window "ido" "\
Edit file read-only in other window with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-file-read-only-other-frame "ido" "\
Edit file read-only in other frame with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-display-file "ido" "\
Display a file in another window but don't select it.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-find-file-other-frame "ido" "\
Switch to another file and show it in another frame.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-write-file "ido" "\
Write current buffer to a file.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-insert-file "ido" "\
Insert contents of file in current buffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-dired "ido" "\
Call `dired' the Ido way.
The directory is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-dired-other-window "ido" "\
\"Edit\" a directory.  Like `ido-dired' but select in another window.
The directory is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-dired-other-frame "ido" "\
\"Edit\" a directory.  Like `ido-dired' but make a new frame.
The directory is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'." t)
(autoload 'ido-read-buffer "ido" "\
Ido replacement for the built-in `read-buffer'.
Return the name of a buffer selected.
PROMPT is the prompt to give to the user.  DEFAULT if given is the default
buffer to be selected, which will go to the front of the list.
If REQUIRE-MATCH is non-nil, an existing buffer must be selected.
Optional arg PREDICATE if non-nil is a function limiting the
buffers that can be considered.

(fn PROMPT &optional DEFAULT REQUIRE-MATCH PREDICATE)")
(autoload 'ido-read-file-name "ido" "\
Ido replacement for the built-in `read-file-name'.
Read file name, prompting with PROMPT and completing in directory DIR.
See `read-file-name' for additional parameters.

(fn PROMPT &optional DIR DEFAULT-FILENAME MUSTMATCH INITIAL PREDICATE)")
(autoload 'ido-read-directory-name "ido" "\
Ido replacement for the built-in `read-directory-name'.
Read directory name, prompting with PROMPT and completing in directory DIR.
See `read-directory-name' for additional parameters.

(fn PROMPT &optional DIR DEFAULT-DIRNAME MUSTMATCH INITIAL)")
(autoload 'ido-completing-read "ido" "\
Ido replacement for the built-in `completing-read'.
Read a string in the minibuffer with Ido-style completion.
PROMPT is a string to prompt with; normally it ends in a colon and a space.
CHOICES is a list of strings which are the possible completions.
PREDICATE and INHERIT-INPUT-METHOD are currently ignored; they are included
 to be compatible with `completing-read'.
If REQUIRE-MATCH is non-nil, the user is not allowed to exit unless
 the input is (or completes to) an element of CHOICES or is null.
 If the input is null, `ido-completing-read' returns DEF, or an empty
 string if DEF is nil, regardless of the value of REQUIRE-MATCH.
If INITIAL-INPUT is non-nil, insert it in the minibuffer initially,
 with point positioned at the end.
HIST, if non-nil, specifies a history list.
DEF, if non-nil, is the default value.

(fn PROMPT CHOICES &optional PREDICATE REQUIRE-MATCH INITIAL-INPUT HIST DEF INHERIT-INPUT-METHOD)")
(register-definition-prefixes "ido" '("ido-"))


;;; Generated autoloads from cedet/semantic/symref/idutils.el

(register-definition-prefixes "semantic/symref/idutils" '("semantic-symref-idutils--line-re"))


;;; Generated autoloads from ielm.el

(autoload 'ielm "ielm" "\
Interactively evaluate Emacs Lisp expressions.
Switches to the buffer named BUF-NAME if provided (`*ielm*' by default),
or creates it if it does not exist.
See `inferior-emacs-lisp-mode' for details.

(fn &optional BUF-NAME)" t)
(register-definition-prefixes "ielm" '("ielm-" "inferior-emacs-lisp-mode"))


;;; Generated autoloads from mail/ietf-drums.el

(register-definition-prefixes "ietf-drums" '("ietf-drums-"))


;;; Generated autoloads from mail/ietf-drums-date.el

(register-definition-prefixes "ietf-drums-date" '("date-parse-error" "ietf-drums-"))


;;; Generated autoloads from iimage.el

(autoload 'iimage-mode "iimage" "\
Toggle Iimage mode on or off.

This is a minor mode.  If called interactively, toggle the `Iimage mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `iimage-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "iimage" '("iimage-" "turn-off-iimage-mode"))


;;; Generated autoloads from image.el

(autoload 'image-type-from-data "image" "\
Determine the image type from image data DATA.
Value is a symbol specifying the image type or nil if type cannot
be determined.

(fn DATA)")
(autoload 'image-type-from-buffer "image" "\
Determine the image type from data in the current buffer.
Value is a symbol specifying the image type or nil if type cannot
be determined.")
(autoload 'image-type-from-file-header "image" "\
Determine the type of image file FILE from its first few bytes.
Value is a symbol specifying the image type, or nil if type cannot
be determined.

(fn FILE)")
(autoload 'image-type-from-file-name "image" "\
Determine the type of image file FILE from its name.
Value is a symbol specifying the image type, or nil if type cannot
be determined.

(fn FILE)")
(make-obsolete 'image-type-from-file-name 'image-supported-file-p "29.1")
(autoload 'image-type "image" "\
Determine and return image type.
SOURCE is an image file name or image data.
Optional TYPE is a symbol describing the image type.  If TYPE is omitted
or nil, try to determine the image type from its first few bytes
of image data.  If that doesn't work, and SOURCE is a file name,
use its file extension as image type.

Optional DATA-P non-nil means SOURCE is a string containing image
data.  If DATA-P is a symbol with a name on the format
`image/jpeg', that may be used as a hint to determine the image
type if we can't otherwise guess it.

(fn SOURCE &optional TYPE DATA-P)")
(autoload 'image-type-available-p "image" "\
Return t if image type TYPE is available.
Image types are symbols like `xbm' or `jpeg'.

(fn TYPE)")
(autoload 'image-type-auto-detected-p "image" "\
Return t if the current buffer contains an auto-detectable image.
This function is intended to be used from `magic-fallback-mode-alist'.

The buffer is considered to contain an auto-detectable image if
its beginning matches an image type in `image-type-header-regexps',
and that image type is present in `image-type-auto-detectable' with a
non-nil value.  If that value is non-nil, but not t, then the image type
must be available.")
(autoload 'create-image "image" "\
Create an image from FILE-OR-DATA.
FILE-OR-DATA is an image file name or image data.  If it is a relative
file name, the function will look for it along `image-load-path'.

Optional TYPE is a symbol describing the image type.  If TYPE is omitted
or nil, try to determine the image type from its first few bytes
of image data.  If that doesn't work, and FILE-OR-DATA is a file name,
use its file extension as image type.

Optional DATA-P non-nil means FILE-OR-DATA is a string containing image data.

Optional PROPS are additional image attributes to assign to the image,
like, e.g. `:mask MASK'.  See Info node `(elisp)Image Descriptors' for
the list of supported properties; see the nodes following that node
for properties specific to certain image types.

If the property `:scale' is not given and the display has a high
resolution (more exactly, when the average width of a character
in the default font is more than 10 pixels), the image is
automatically scaled up in proportion to the default font.

Value is the image created, or nil if images of type TYPE are not supported.

Images should not be larger than specified by `max-image-size'.

(fn FILE-OR-DATA &optional TYPE DATA-P &rest PROPS)")
(autoload 'put-image "image" "\
Put image IMAGE in front of POS in the current buffer.
IMAGE must be an image created with `create-image' or `defimage'.
IMAGE is displayed by putting an overlay into the current buffer with a
`before-string' STRING that has a `display' property whose value is the
image.  STRING defaults to \"x\" if it's nil or omitted.
Upon success, this function returns the created overlay with its
`put-image' property set to t.

POS may be an integer or marker.
AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.

(fn IMAGE POS &optional STRING AREA)")
(autoload 'insert-image "image" "\
Insert IMAGE into current buffer at point.
IMAGE is displayed by inserting STRING into the current buffer
with a `display' property whose value is the image.

STRING defaults to a single space if you omit it, which means
that the inserted image will behave as whitespace syntactically.

AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.

SLICE specifies slice of IMAGE to insert.  SLICE nil or omitted
means insert whole image.  SLICE is a list (X Y WIDTH HEIGHT)
specifying the X and Y positions and WIDTH and HEIGHT of image area
to insert.  A float value 0.0 - 1.0 means relative to the width or
height of the image; integer values are taken as pixel values.

Normally `isearch' is able to search for STRING in the buffer
even if it's hidden behind a displayed image.  If INHIBIT-ISEARCH
is non-nil, this is inhibited.

(fn IMAGE &optional STRING AREA SLICE INHIBIT-ISEARCH)")
(autoload 'insert-sliced-image "image" "\
Insert IMAGE into current buffer at point.
IMAGE is displayed by inserting STRING into the current buffer
with a `display' property whose value is the image.  The default
STRING is a single space.
AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.
The image is automatically split into ROWS x COLS slices.

(fn IMAGE &optional STRING AREA ROWS COLS)")
(autoload 'remove-images "image" "\
Remove images between START and END in BUFFER.
Remove only images that were put in BUFFER with calls to `put-image'.
BUFFER nil or omitted means use the current buffer.

(fn START END &optional BUFFER)")
(autoload 'find-image "image" "\
Find an image that satisfies one of a list of image specifications.

SPECS is a list of image specifications.

Each image specification in SPECS is a property list.  The
contents of a specification are image type dependent; see the
info node `(elisp)Image Descriptors' for details.  All specifications
must at least contain either the property `:file FILE' or `:data DATA',
where FILE is the file from which to load the image, and DATA is a
string containing the actual image data.  If the property `:type TYPE'
is omitted or nil, try to determine the image type from its first few
bytes of image data.  If that doesn't work, and the property `:file
FILE' provide a file name, use its file extension as indication of the
image type.  If `:type TYPE' is provided, it must match the actual type
determined for FILE or DATA by `create-image'.

The function returns the image specification for the first specification
in the list whose TYPE is supported and FILE, if specified, exists.  It
returns nil if no specification in the list can be satisfied.

If CACHE is non-nil, results are cached and returned on subsequent calls.

The image is looked for in `image-load-path'.

Image files should not be larger than specified by `max-image-size'.

(fn SPECS &optional CACHE)")
(autoload 'defimage "image" "\
Define SYMBOL as an image, and return SYMBOL.

SPECS is a list of image specifications.  DOC is an optional
documentation string.

Each image specification in SPECS is a property list.  The contents of
a specification are image type dependent.  All specifications must at
least contain the properties `:type TYPE' and either `:file FILE' or
`:data DATA', where TYPE is a symbol specifying the image type,
e.g. `xbm', FILE is the file to load the image from, and DATA is a
string containing the actual image data.  The first image
specification whose TYPE is supported, and FILE exists, is used to
define SYMBOL.

Example:

   (defimage test-image ((:type xpm :file \"~/test1.xpm\")
                         (:type xbm :file \"~/test1.xbm\")))

(fn SYMBOL SPECS &optional DOC)" nil t)
(function-put 'defimage 'doc-string-elt 3)
(function-put 'defimage 'lisp-indent-function 'defun)
(autoload 'imagemagick-register-types "image" "\
Register file types that can be handled by ImageMagick.
This function is called at startup, after loading the init file.
It registers the ImageMagick types returned by `imagemagick-filter-types'.

Registered image types are added to `auto-mode-alist', so that
Emacs visits them in Image mode.  They are also added to
`image-type-file-name-regexps', so that the `image-type' function
recognizes these files as having image type `imagemagick'.

If Emacs is compiled without ImageMagick support, this does nothing.")
(autoload 'image-at-point-p "image" "\
Return non-nil if there is an image at point.")
(register-definition-prefixes "image" '("find-image--cache" "image" "unknown-image-type"))


;;; Generated autoloads from image/image-converter.el

(autoload 'image-converter-add-handler "image-converter" "\
Make Emacs use CONVERTER to parse image files whose names end with SUFFIX.
CONVERTER is a function with two arguments, the file name or a string
with the image data, and a non-nil value if the first argument is image data.
The converter should produce the image in the current buffer, converted to
the format given by `image-convert-to-format'.
SUFFIX should not include the leading dot.

(fn SUFFIX CONVERTER)")
(register-definition-prefixes "image-converter" '("image-convert"))


;;; Generated autoloads from image/image-crop.el

(autoload 'image-cut "image-crop" "\
Cut a rectangle from the image under point, filling it with COLOR.
COLOR defaults to the value of `image-cut-color'.
Interactively, with prefix argument, prompt for COLOR to use.

This command presents the image with a rectangular area superimposed
on it, and allows moving and resizing the area to define which
part of it to cut.

While moving/resizing the cutting area, the following key bindings
are available:

`q':   Exit without changing anything.
`RET': Crop/cut the image.
`m':   Make mouse movements move the rectangle instead of altering the
       rectangle shape.
`s':   Same as `m', but make the rectangle into a square first.

After cutting the image, you can save it by `M-x image-save' or
\\<image-map>\\[image-save] when point is over the image.

(fn &optional COLOR)" t)
(autoload 'image-crop "image-crop" "\
Crop the image under point.
This command presents the image with a rectangular area superimposed
on it, and allows moving and resizing the area to define which
part of it to crop.

While moving/resizing the cropping area, the following key bindings
are available:

`q':   Exit without changing anything.
`RET': Crop/cut the image.
`m':   Make mouse movements move the rectangle instead of altering the
       rectangle shape.
`s':   Same as `m', but make the rectangle into a square first.

After cropping the image, you can save it by `M-x image-save' or
\\<image-map>\\[image-save] when point is over the image.

When called from Lisp, if CUT is non-nil, remove a rectangle from
the image instead of cropping the image.  In that case, CUT should
be the name of a color to fill the rectangle.

(fn &optional CUT)" t)
(register-definition-prefixes "image-crop" '("image-c"))


;;; Generated autoloads from image/image-dired.el

(push (purecopy '(image-dired 0 5)) package--builtin-versions)
(put 'image-dired-thumbnail-storage 'safe-local-variable (lambda (x) (eq x 'per-directory)))
(autoload 'image-dired-dired-with-window-configuration "image-dired" "\
Open directory DIR and create a default window configuration.

Convenience command that:

 - opens Dired in folder DIR;
 - splits windows in most useful (?) way; and
 - sets `truncate-lines' to t

After the command has finished, you would typically mark some
image files in Dired and type
\\[image-dired-display-thumbs] (`image-dired-display-thumbs').

If called with prefix argument ARG, skip splitting of windows.

The current window configuration is saved and can be restored by
calling `image-dired-restore-window-configuration'.

(fn DIR &optional ARG)" t)
(autoload 'image-dired-display-thumbs "image-dired" "\
Display thumbnails of all marked files, in `image-dired-thumbnail-buffer'.
If a thumbnail image does not exist for a file, it is created on the
fly.  With prefix argument ARG, display only thumbnail for file at
point (this is useful if you have marked some files but want to show
another one).

Recommended usage is to split the current frame horizontally so that
you have the Dired buffer in the left window and the
`image-dired-thumbnail-buffer' buffer in the right window.

With optional argument APPEND, append thumbnail to thumbnail buffer
instead of erasing it first.

Optional argument DO-NOT-POP controls if `pop-to-buffer' should be
used or not.  If non-nil, use `display-buffer' instead of
`pop-to-buffer'.  This is used from functions like
`image-dired-next-line-and-display' and
`image-dired-previous-line-and-display' where we do not want the
thumbnail buffer to be selected.

(fn &optional ARG APPEND DO-NOT-POP)" '(nil dired-mode))
(autoload 'image-dired-show-all-from-dir "image-dired" "\
Make a thumbnail buffer for all images in DIR and display it.
Any file matching `image-dired--file-name-regexp' is considered an
image file.

If the number of image files in DIR exceeds
`image-dired-show-all-from-dir-max-files', ask for confirmation
before creating the thumbnail buffer.  If that variable is nil,
never ask for confirmation.

(fn DIR)" t)
(defalias 'image-dired 'image-dired-show-all-from-dir)
(autoload 'image-dired-bookmark-jump "image-dired" "\
Default bookmark handler for Image-Dired buffers.

(fn BOOKMARK)")
(define-obsolete-function-alias 'tumme #'image-dired "24.4")
(define-obsolete-function-alias 'image-dired-setup-dired-keybindings #'image-dired-minor-mode "26.1")
(register-definition-prefixes "image-dired" '("image-dired-"))


;;; Generated autoloads from image/image-dired-dired.el

(autoload 'image-dired-dired-toggle-marked-thumbs "image-dired-dired" "\
Toggle thumbnails in front of marked file names in the Dired buffer.
If no file is marked, toggle display of thumbnail on the current file's line.
ARG, if non-nil (interactively, the prefix argument), specifies the files
whose thumbnail display to toggle instead of the marked files: if ARG is an
integer, use the next ARG (or previous -ARG, if ARG<0) files; any other
value of ARG means toggle thumbnail display of the current line's file.

(fn &optional ARG)" '(dired-mode))
(autoload 'image-dired-jump-thumbnail-buffer "image-dired-dired" "\
Jump to thumbnail buffer." '(dired-mode))
(autoload 'image-dired-minor-mode "image-dired-dired" "\
Setup easy-to-use keybindings for Image-Dired in Dired mode.

This minor mode adds these additional bindings:
\\<image-dired-minor-mode-map>
  \\[image-dired-next-line-and-display]		Move to next line and display thumbnail image.
  \\[image-dired-previous-line-and-display]		Move to previous line and display thumbnail image.
  \\[image-dired-mark-and-display-next]		Mark current file and display next thumbnail image.
  \\[image-dired-jump-thumbnail-buffer]		Jump to thumbnail buffer.

For reference, these are the default Image-Dired bindings that
are always available in Dired:
\\<dired-mode-map>
  \\[image-dired-display-thumbs]		Display thumbnails of all marked files.
  \\[image-dired-tag-files]		Tag marked file(s).
  \\[image-dired-delete-tag]		Remove tag for selected file(s).
  \\[image-dired-jump-thumbnail-buffer]		Jump to thumbnail buffer.
  \\[image-dired-dired-display-image]		Display current image file.
  \\[image-dired-dired-display-external]		Display file at point using an external viewer.
  \\[image-dired-display-thumbs-append]		Append thumbnails to thumbnail buffer.
  \\[image-dired-display-thumb]		Display thumbnails of all marked files.
  \\[image-dired-dired-comment-files]		Add comment to current or marked files in Dired.
  \\[image-dired-mark-tagged-files]		Use REGEXP to mark files with matching tag.
  \\[image-dired-dired-toggle-marked-thumbs]	Toggle thumbnails in front of file names.
  \\[image-dired-dired-edit-comment-and-tags]		Edit comment and tags of marked images.

This is a minor mode.  If called interactively, toggle the `Image-Dired
minor mode' mode.  If the prefix argument is positive, enable the mode,
and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `image-dired-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'image-dired-display-thumbs-append "image-dired-dired" "\
Append thumbnails to `image-dired-thumbnail-buffer'." '(dired-mode))
(autoload 'image-dired-display-thumb "image-dired-dired" "\
Shorthand for `image-dired-display-thumbs' with prefix argument." '(dired-mode))
(autoload 'image-dired-dired-display-external "image-dired-dired" "\
Display file at point using an external viewer.
The viewer is specified by the value of `image-dired-external-viewer'." '(dired-mode))
(autoload 'image-dired-dired-display-image "image-dired-dired" "\
Display current image file.
See documentation for `image-dired-display-image' for more information.

(fn &optional _)" '(dired-mode))
(set-advertised-calling-convention 'image-dired-dired-display-image 'nil '"29.1")
(autoload 'image-dired-mark-tagged-files "image-dired-dired" "\
Mark files whose tag matches REGEXP.
A `tag' is a keyword, a piece of meta data, associated with an
image file and stored in image-dired's database file.  This command
prompts for a regexp, and then matches it against all the tags
of all the image files in the database file.  The files that have a
matching tag will be marked in the Dired buffer.

(fn REGEXP)" '(dired-mode))
(register-definition-prefixes "image-dired-dired" '("image-dired-"))


;;; Generated autoloads from image/image-dired-external.el

(register-definition-prefixes "image-dired-external" '("image-dired-"))


;;; Generated autoloads from image/image-dired-tags.el

(autoload 'image-dired-tag-files "image-dired-tags" "\
Tag file(s) which are marked in a Dired buffer.
With prefix ARG, tag the file at point.

(fn ARG)" '(dired-mode))
(autoload 'image-dired-delete-tag "image-dired-tags" "\
Remove tag for selected file(s).
With prefix argument ARG, remove tag from file at point.

(fn ARG)" '(dired-mode))
(autoload 'image-dired-dired-comment-files "image-dired-tags" "\
Add comment to current or marked files in Dired." '(dired-mode))
(autoload 'image-dired-dired-edit-comment-and-tags "image-dired-tags" "\
Edit comment and tags of current or marked image files.
Edit comment and tags for all marked image files in an
easy-to-use form." '(dired-mode))
(register-definition-prefixes "image-dired-tags" '("image-dired-"))


;;; Generated autoloads from image/image-dired-util.el

(register-definition-prefixes "image-dired-util" '("image-dired-"))


;;; Generated autoloads from image-file.el

(defvar image-file-name-extensions (purecopy '("png" "jpeg" "jpg" "gif" "tiff" "tif" "xbm" "xpm" "pbm" "pgm" "ppm" "pnm" "svg" "webp")) "\
A list of image-file filename extensions.
Filenames having one of these extensions are considered image files,
in addition to those matching `image-file-name-regexps'.

See `auto-image-file-mode'; if `auto-image-file-mode' is enabled,
setting this variable directly does not take effect unless
`auto-image-file-mode' is re-enabled; this happens automatically when
the variable is set using \\[customize].")
(custom-autoload 'image-file-name-extensions "image-file" nil)
(defvar image-file-name-regexps nil "\
List of regexps matching image-file filenames.
Filenames matching one of these regexps are considered image files,
in addition to those with an extension in `image-file-name-extensions'.

See function `auto-image-file-mode'; if `auto-image-file-mode' is
enabled, setting this variable directly does not take effect unless
`auto-image-file-mode' is re-enabled; this happens automatically when
the variable is set using \\[customize].")
(custom-autoload 'image-file-name-regexps "image-file" nil)
(autoload 'image-file-name-regexp "image-file" "\
Return a regular expression matching image-file filenames.")
(autoload 'insert-image-file "image-file" "\
Insert the image file FILE into the current buffer.
Optional arguments VISIT, BEG, END, and REPLACE are interpreted
as for the command `insert-file-contents'.  Return list of
absolute file name and number of characters inserted.

(fn FILE &optional VISIT BEG END REPLACE)")
(defvar auto-image-file-mode nil "\
Non-nil if Auto-Image-File mode is enabled.
See the `auto-image-file-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `auto-image-file-mode'.")
(custom-autoload 'auto-image-file-mode "image-file" nil)
(autoload 'auto-image-file-mode "image-file" "\
Toggle visiting of image files as images (Auto Image File mode).

An image file is one whose name has an extension in
`image-file-name-extensions', or matches a regexp in
`image-file-name-regexps'.

This is a global minor mode.  If called interactively, toggle the
`Auto-Image-File mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='auto-image-file-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "image-file" '("image-file-"))


;;; Generated autoloads from image-mode.el

(autoload 'image-mode "image-mode" "\
Major mode for image files.
You can use \\<image-mode-map>\\[image-toggle-display] or \\[image-toggle-hex-display] to toggle between display
as an image and display as text or hex.

Key bindings:
\\{image-mode-map}" t)
(autoload 'image-minor-mode "image-mode" "\
Toggle Image minor mode in this buffer.

Image minor mode provides the key \\<image-mode-map>\\[image-toggle-display], to switch back to
`image-mode' and display an image file as the actual image.

This is a minor mode.  If called interactively, toggle the `Image minor
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `image-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'image-mode-to-text "image-mode" "\
Set current buffer's modes be a non-image major mode, plus `image-minor-mode'.
A non-image major mode displays an image file as text.")
(autoload 'image-bookmark-jump "image-mode" "\


(fn BMK)")
(register-definition-prefixes "image-mode" '("image-"))


;;; Generated autoloads from net/imap.el

(register-definition-prefixes "imap" '("imap-"))


;;; Generated autoloads from cedet/semantic/imenu.el

(register-definition-prefixes "semantic/imenu" '("semantic-"))


;;; Generated autoloads from imenu.el

(defvar imenu-sort-function nil "\
The function to use for sorting the index mouse-menu.

Affects only the mouse index menu.  If you want to change
the sorting order of completions, you can customize
the option `completion-category-overrides' and set
`display-sort-function' for the category `imenu'.

Set this to nil if you don't want any sorting (faster).
The items in the menu are then presented in the order they were found
in the buffer.

Set it to `imenu--sort-by-name' if you want alphabetic sorting.

The function should take two arguments and return t if the first
element should come before the second.  The arguments are cons cells;
(NAME . POSITION).  Look at `imenu--sort-by-name' for an example.")
(custom-autoload 'imenu-sort-function "imenu" t)
(defvar-local imenu-generic-expression nil "\
List of definition matchers for creating an Imenu index.
Each element of this list should have the form

  (MENU-TITLE REGEXP INDEX [FUNCTION] [ARGUMENTS...])

MENU-TITLE should be nil (in which case the matches for this
element are put in the top level of the buffer index) or a
string (which specifies the title of a submenu into which the
matches are put).
REGEXP is a regular expression matching a definition construct
which is to be displayed in the menu.  REGEXP may also be a
function of no arguments.  If REGEXP is a function, it is
expected to search backwards, return non-nil if it finds a
definition construct, and set `match-data' for that construct.
INDEX is an integer specifying which subexpression of REGEXP
matches the definition's name; this subexpression is displayed as
the menu item.
FUNCTION, if present, specifies a function to call when the index
item is selected by the user.  This function is called with
arguments consisting of the item name, the buffer position, and
the ARGUMENTS.

The variable `imenu-case-fold-search' determines whether or not
the regexp matches are case sensitive, and `imenu-syntax-alist'
can be used to alter the syntax table for the search.

If non-nil this pattern is passed to `imenu--generic-function' to
create a buffer index.

For example, see the value of `fortran-imenu-generic-expression'
used by `fortran-mode' with `imenu-syntax-alist' set locally so that
characters which normally have \"symbol\" syntax are considered to have
\"word\" syntax during matching.")
(put 'imenu-generic-expression 'risky-local-variable t)
(defvar-local imenu-create-index-function 'imenu-default-create-index-function "\
The function to use for creating an index alist of the current buffer.

It should be a function that takes no arguments and returns
an index alist of the current buffer.  The function is
called within a `save-excursion'.

See `imenu--index-alist' for the format of the buffer index alist.")
(defvar-local imenu-submenus-on-top t "\
Flag specifying whether items with sublists should be kept at top.

For some indexes, such as those describing sections in a document, it
makes sense to keep their original order even in the menubar.")
(defvar-local imenu-prev-index-position-function 'beginning-of-defun "\
Function for finding the next index position.

If `imenu-create-index-function' is set to
`imenu-default-create-index-function', then you must set this variable
to a function that will find the next index, looking backwards in the
file.

The function should leave point at the place to be connected to the
index and it should return nil when it doesn't find another index.")
(defvar-local imenu-extract-index-name-function nil "\
Function for extracting the index item name, given a position.

This function is called after `imenu-prev-index-position-function'
finds a position for an index item, with point at that position.
It should return the name for that index item.")
(defvar-local imenu-name-lookup-function nil "\
Function to compare string with index item.

This function will be called with two strings, and should return
non-nil if they match.

If nil, comparison is done with `string='.
Set this to some other function for more advanced comparisons,
such as \"begins with\" or \"name matches and number of
arguments match\".")
(defvar-local imenu-default-goto-function 'imenu-default-goto-function "\
The default function called when selecting an Imenu item.
The function in this variable is called when selecting a normal index-item.")
(put 'imenu--index-alist 'risky-local-variable t)
(defvar-local imenu-syntax-alist nil "\
Alist of syntax table modifiers to use while in `imenu--generic-function'.

The car of the assocs may be either a character or a string and the
cdr is a syntax description appropriate for `modify-syntax-entry'.  For
a string, all the characters in the string get the specified syntax.

This is typically used to give word syntax to characters which
normally have symbol syntax to simplify `imenu-expression'
and speed-up matching.")
(defvar-local imenu-case-fold-search t "\
Defines whether `imenu--generic-function' should fold case when matching.

This variable should be set (only) by initialization code
for modes which use `imenu--generic-function'.  If it is not set, but
`font-lock-defaults' is set, then font-lock's setting is used.")
(autoload 'imenu-add-to-menubar "imenu" "\
Add an `imenu' entry to the menu bar for the current buffer.
NAME is a string used to name the menu bar item.
See the command `imenu' for more information.

(fn NAME)" t)
(autoload 'imenu-add-menubar-index "imenu" "\
Add an Imenu \"Index\" entry on the menu bar for the current buffer.

A trivial interface to `imenu-add-to-menubar' suitable for use in a hook." t)
(autoload 'imenu "imenu" "\
Jump to a place in the buffer chosen using a buffer menu or mouse menu.
INDEX-ITEM specifies the position.  See `imenu-choose-buffer-index'
for more information.

(fn INDEX-ITEM)" t)
(register-definition-prefixes "imenu" '("imenu-"))


;;; Generated autoloads from cedet/semantic/decorate/include.el

(register-definition-prefixes "semantic/decorate/include" '("semantic-decoration-"))


;;; Generated autoloads from language/ind-util.el

(autoload 'indian-compose-region "ind-util" "\
Compose the region according to `composition-function-table'.

(fn FROM TO)" t)
(autoload 'indian-compose-string "ind-util" "\


(fn STRING)")
(autoload 'in-is13194-post-read-conversion "ind-util" "\


(fn LEN)")
(autoload 'in-is13194-pre-write-conversion "ind-util" "\


(fn FROM TO)")
(autoload 'indian-2-column-to-ucs-region "ind-util" "\
Convert old Emacs Devanagari characters to UCS.

(fn FROM TO)" t)
(register-definition-prefixes "ind-util" '("combinatorial" "indian-" "is13194-"))


;;; Generated autoloads from indent-aux.el

(defvar kill-ring-deindent-mode nil "\
Non-nil if Kill-Ring-Deindent mode is enabled.
See the `kill-ring-deindent-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `kill-ring-deindent-mode'.")
(custom-autoload 'kill-ring-deindent-mode "indent-aux" nil)
(autoload 'kill-ring-deindent-mode "indent-aux" "\
Toggle removal of indentation from text saved to the kill ring.

When this minor mode is enabled, text saved into the kill ring is
indented towards the left by the column number at the start of
that text.

This is a global minor mode.  If called interactively, toggle the
`Kill-Ring-Deindent mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='kill-ring-deindent-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "indent-aux" '("kill-ring-deindent-buffer-substring-function"))


;;; Generated autoloads from leim/quail/indian.el

(register-definition-prefixes "quail/indian" '("indian-mlm-mozhi-u" "inscript-" "quail-" "tamil"))


;;; Generated autoloads from progmodes/inf-lisp.el

(autoload 'inferior-lisp "inf-lisp" "\
Run an inferior Lisp process, input and output via buffer `*inferior-lisp*'.
If there is a process already running in `*inferior-lisp*', just switch
to that buffer.

With argument, allows you to edit the command line (default is value
of `inferior-lisp-program').  Runs the hooks from
`inferior-lisp-mode-hook' (after the `comint-mode-hook' is run).

If any parts of the command name contains spaces, they should be
quoted using shell quote syntax.

(Type \\[describe-mode] in the process buffer for a list of commands.)

(fn CMD)" t)
(defalias 'run-lisp 'inferior-lisp)
(register-definition-prefixes "inf-lisp" '("inferior-lisp-" "lisp-" "switch-to-lisp"))


;;; Generated autoloads from info.el

(defvar Info-default-directory-list nil "\
Default list of directories to search for Info documentation files.
They are searched in the order they are given in the list.
Therefore, the directory of Info files that come with Emacs
normally should come last (so that local files override standard ones),
unless Emacs is installed into a non-standard directory.  In the latter
case, the directory of Info files that come with Emacs should be
first in this list.

Once Info is started, the list of directories to search
comes from the variable `Info-directory-list'.

This variable is used as the default for initializing
`Info-directory-list' when Info is started, unless the
environment variable INFOPATH is set.")
(custom-autoload 'Info-default-directory-list "info" t)
(autoload 'info-other-window "info" "\
Like `info' but show the Info buffer in another window.

(fn &optional FILE-OR-NODE BUFFER)" t)
 (put 'info 'info-file (purecopy "emacs"))
(autoload 'info "info" "\
Enter Info, the documentation browser.
Optional argument FILE-OR-NODE specifies the file to examine;
the default is the top-level directory of Info.
Called from a program, FILE-OR-NODE may specify an Info node of the form
\"(FILENAME)NODENAME\".
Optional argument BUFFER specifies the Info buffer name;
the default buffer name is *info*.  If BUFFER exists,
just switch to BUFFER.  Otherwise, create a new buffer
with the top-level Info directory.

In interactive use, a non-numeric prefix argument directs
this command to read a file name from the minibuffer.

A numeric prefix argument of N selects an Info buffer named \"*info*<N>\".

The search path for Info files is in the variable `Info-directory-list'.
The top-level Info directory is made by combining all the files named `dir'
in all the directories in that path.

See a list of available Info commands in `Info-mode'.

(fn &optional FILE-OR-NODE BUFFER)" t)
(autoload 'info-emacs-manual "info" "\
Display the Emacs manual in Info mode." t)
(autoload 'info-emacs-bug "info" "\
Display the \"Reporting Bugs\" section of the Emacs manual in Info mode." t)
(autoload 'info-standalone "info" "\
Run Emacs as a standalone Info reader.
Usage:  emacs -f info-standalone [filename]
In standalone mode, \\<Info-mode-map>\\[quit-window] exits Emacs itself.")
(autoload 'Info-on-current-buffer "info" "\
Use Info mode to browse the current Info buffer.
With a prefix arg, this queries for the node name to visit first;
otherwise, that defaults to `Top'.

(fn &optional NODENAME)" t)
(autoload 'Info-directory "info" "\
Go to the Info directory node." t)
(autoload 'Info-index "info" "\
Look up a string TOPIC in the index for this manual and go to that entry.
If there are no exact matches to the specified topic, this chooses
the first match which is a case-insensitive substring of a topic.
Use the \\<Info-mode-map>\\[Info-index-next] command to see the other matches.
Give an empty topic name to go to the Index node itself.

(fn TOPIC)" t)
(autoload 'info-apropos "info" "\
Search indices of all known Info files on your system for STRING.
If REGEXP (interactively, the prefix), use a regexp match.

Display a menu of the possible matches.

(fn STRING &optional REGEXP)" t)
(autoload 'info-finder "info" "\
Display descriptions of the keywords in the Finder virtual manual.
In interactive use, a prefix argument directs this command to read
a list of keywords separated by comma.  After that, it displays a node
with a list of packages that contain all specified keywords.

(fn &optional KEYWORDS)" t)
(autoload 'Info-mode "info" "\
Info mode provides commands for browsing through the Info documentation tree.
Documentation in Info is divided into \"nodes\", each of which discusses
one topic and contains references to other nodes which discuss related
topics.  Info has commands to follow the references and show you other nodes.

\\<Info-mode-map>\\[Info-help]	Invoke the Info tutorial.
\\[quit-window]	Quit Info: reselect previously selected buffer.

Selecting other nodes:
\\[Info-mouse-follow-nearest-node]
	Follow a node reference you click on.
	  This works with menu items, cross references, and
	  the \"next\", \"previous\" and \"up\", depending on where you click.
\\[Info-follow-nearest-node]	Follow a node reference near point, like \\[Info-mouse-follow-nearest-node].
\\[Info-next]	Move to the \"next\" node of this node.
\\[Info-prev]	Move to the \"previous\" node of this node.
\\[Info-up]	Move \"up\" from this node.
\\[Info-menu]	Pick menu item specified by name (or abbreviation).
	  Picking a menu item causes another node to be selected.
\\[Info-directory]	Go to the Info directory node.
\\[Info-top-node]	Go to the Top node of this file.
\\[Info-final-node]	Go to the final node in this file.
\\[Info-backward-node]	Go backward one node, considering all nodes as forming one sequence.
\\[Info-forward-node]	Go forward one node, considering all nodes as forming one sequence.
\\[Info-next-reference]	Move cursor to next cross-reference or menu item.
\\[Info-prev-reference]	Move cursor to previous cross-reference or menu item.
\\[Info-follow-reference]	Follow a cross reference.  Reads name of reference.
\\[Info-history-back]	Move back in history to the last node you were at.
\\[Info-history-forward]	Move forward in history to the node you returned from after using \\[Info-history-back].
\\[Info-history]	Go to menu of visited nodes.
\\[Info-toc]	Go to table of contents of the current Info file.

Moving within a node:
\\[Info-scroll-up]	Normally, scroll forward a full screen.
	  Once you scroll far enough in a node that its menu appears on the
	  screen but after point, the next scroll moves into its first
	  subnode.  When after all menu items (or if there is no menu),
	  move up to the parent node.
\\[Info-scroll-down]	Normally, scroll backward.  If the beginning of the buffer is
	  already visible, try to go to the previous menu entry, or up
	  if there is none.
\\[beginning-of-buffer]	Go to beginning of node.
\\[end-of-buffer]	Go to end of node.

Advanced commands:
\\[Info-search]	Search through this Info file for specified regexp,
	  and select the node in which the next occurrence is found.
\\[Info-search-case-sensitively]	Search through this Info file for specified regexp case-sensitively.
\\[isearch-forward], \\[isearch-forward-regexp]	Use Isearch to search through multiple Info nodes.
\\[Info-index]	Search for a topic in this manual's Index and go to index entry.
\\[Info-index-next]	(comma) Move to the next match from a previous \\<Info-mode-map>\\[Info-index] command.
\\[Info-virtual-index]	Look for a string and display the index node with results.
\\[info-apropos]	Look for a string in the indices of all manuals.
\\[Info-goto-node]	Move to node specified by name.
	  You may include a filename as well, as (FILENAME)NODENAME.
1 .. 9	Pick first ... ninth item in node's menu.
	  Every third `*' is highlighted to help pick the right number.
\\[Info-copy-current-node-name]	Put name of current Info node in the kill ring.
\\[clone-buffer]	Select a new cloned Info buffer in another window.
\\[universal-argument] \\[info]	Move to new Info file with completion.
\\[universal-argument] N \\[info]	Select Info buffer with prefix number in the name *info*<N>.

(fn)" t)
 (put 'Info-goto-emacs-command-node 'info-file (purecopy "emacs"))
(autoload 'Info-goto-emacs-command-node "info" "\
Go to the Info node in the Emacs manual for command COMMAND.
The command is found by looking up in Emacs manual's indices
or in another manual found via COMMAND's `info-file' property or
the variable `Info-file-list-for-emacs'.
COMMAND must be a symbol or string.

(fn COMMAND)" t)
 (put 'Info-goto-emacs-key-command-node 'info-file (purecopy "emacs"))
(autoload 'Info-goto-emacs-key-command-node "info" "\
Go to the node in the Emacs manual which describes the command bound to KEY.
KEY is a string.
Interactively, if the binding is `execute-extended-command', a command is read.
The command is found by looking up in Emacs manual's indices
or in another manual found via COMMAND's `info-file' property or
the variable `Info-file-list-for-emacs'.

(fn KEY)" t)
(autoload 'Info-speedbar-browser "info" "\
Initialize speedbar to display an Info node browser.
This will add a speedbar major display mode." t)
(autoload 'Info-bookmark-jump "info" "\
This implements the `handler' function interface for the record
type returned by `Info-bookmark-make-record', which see.

(fn BMK)")
(autoload 'info-display-manual "info" "\
Display an Info buffer displaying MANUAL.
If there is an existing Info buffer for MANUAL, display it.
Otherwise, visit the manual in a new Info buffer.  In interactive
use, a prefix argument directs this command to limit the
completion alternatives to currently visited manuals.

(fn MANUAL)" t)
(register-definition-prefixes "info" '("Info-" "info-"))


;;; Generated autoloads from info-look.el

(autoload 'info-lookup-reset "info-look" "\
Throw away all cached data.
This command is useful if the user wants to start at the beginning without
quitting Emacs, for example, after some Info documents were updated on the
system." t)
 (put 'info-lookup-symbol 'info-file "emacs")
(autoload 'info-lookup-symbol "info-look" "\
Look up and display documentation of SYMBOL in the relevant Info manual.
SYMBOL should be an identifier: a function or method, a macro, a variable,
a data type, a class, etc.

Interactively, prompt for SYMBOL; you can use \\<minibuffer-local-completion-map>\\[next-history-element] in the minibuffer
to yank the default argument value into the minibuffer so you can edit it.
The default symbol is the one found at point.

MODE is the major mode whose Info manuals to search for the documentation
of SYMBOL.  It defaults to the current buffer's `major-mode'; if that
mode doesn't have any Info manuals known to Emacs, the command will
prompt for MODE to use, with completion.  With prefix arg, the command
always prompts for MODE.

Is SAME-WINDOW, try to reuse the current window instead of
popping up a new one.

(fn SYMBOL &optional MODE SAME-WINDOW)" t)
 (put 'info-lookup-file 'info-file "emacs")
(autoload 'info-lookup-file "info-look" "\
Look up and display documentation of FILE in the relevant Info manual.
FILE should be the name of a file; a notable example is a standard header
file that is part of the C or C++ standard library.

Interactively, prompt for FILE; you can use \\<minibuffer-local-completion-map>\\[next-history-element] in the minibuffer
to yank the default argument value into the minibuffer so you can edit it.
The default file name is the one found at point.

MODE is the major mode whose Info manuals to search for the documentation
of FILE.  It defaults to the current buffer's `major-mode'; if that
mode doesn't have any Info manuals known to Emacs, the command will
prompt for MODE to use, with completion.  With prefix arg, the command
always prompts for MODE.

(fn FILE &optional MODE)" t)
(autoload 'info-complete-symbol "info-look" "\
Perform completion on symbol preceding point.

(fn &optional MODE)" t)
(autoload 'info-complete-file "info-look" "\
Perform completion on file preceding point.

(fn &optional MODE)" t)
(register-definition-prefixes "info-look" '("info-"))


;;; Generated autoloads from info-xref.el

(push (purecopy '(info-xref 3)) package--builtin-versions)
(autoload 'info-xref-check "info-xref" "\
Check external references in FILENAME, an info document.
Interactively from an `Info-mode' or `texinfo-mode' buffer the
current info file is the default.

Results are shown in a `compilation-mode' buffer.  The format is
a bit rough, but there shouldn't be many problems normally.  The
file:line:column: is the info document, but of course normally
any correction should be made in the original .texi file.
Finding the right place in the .texi is a manual process.

When a target info file doesn't exist there's obviously no way to
validate node references within it.  A message is given for
missing target files once per source document.  It could be
simply that you don't have the target installed, or it could be a
mistake in the reference.

Indirect info files are understood, just pass the top-level
foo.info to `info-xref-check' and it traverses all sub-files.
Compressed info files are accepted too as usual for `Info-mode'.

\"makeinfo\" checks references internal to an info document, but
not external references, which makes it rather easy for mistakes
to creep in or node name changes to go unnoticed.
`Info-validate' doesn't check external references either.

(fn FILENAME)" t)
(autoload 'info-xref-check-all "info-xref" "\
Check external references in all info documents in the info path.
`Info-directory-list' and `Info-additional-directory-list' are
the info paths.  See `info-xref-check' for how each file is
checked.

The search for \"all\" info files is rather permissive, since
info files don't necessarily have a \".info\" extension and in
particular the Emacs manuals normally don't.  If you have a
source code directory in `Info-directory-list' then a lot of
extraneous files might be read.  This will be time consuming but
should be harmless." t)
(autoload 'info-xref-check-all-custom "info-xref" "\
Check info references in all customize groups and variables.
Info references can be in `custom-manual' or `info-link' entries
of the `custom-links' for a variable.

Any `custom-load' autoloads in variables are loaded in order to
get full link information.  This will be a lot of Lisp packages
and can take a long time." t)
(autoload 'info-xref-docstrings "info-xref" "\
Check docstring info node references in source files.
The given files are searched for docstring hyperlinks like

    Info node `(elisp)Documentation Tips'

and those links checked by attempting to visit the target nodes
as per `info-xref-check' does.

Interactively filenames are read as a wildcard pattern like
\"foo*.el\", with the current file as a default.  Usually this
will be lisp sources, but anything with such hyperlinks can be
checked, including the Emacs .c sources (or the etc/DOC file of
all builtins).

Because info node hyperlinks are found by a simple regexp search
in the files, the Lisp code checked doesn't have to be loaded,
and links can be in the file commentary or elsewhere too.  Even
.elc files can usually be checked successfully if you don't have
the sources handy.

(fn FILENAME-LIST)" t)
(register-definition-prefixes "info-xref" '("info-xref-"))


;;; Generated autoloads from informat.el

(autoload 'Info-tagify "informat" "\
Create or update Info file tag table in current buffer or in a region.

(fn &optional INPUT-BUFFER-NAME)" t)
(defvar Info-split-threshold 262144 "\
The number of characters by which `Info-split' splits an info file.")
(custom-autoload 'Info-split-threshold "informat" t)
(autoload 'Info-split "informat" "\
Split an info file into an indirect file plus bounded-size subfiles.
Each subfile will be up to the number of characters that
`Info-split-threshold' specifies, plus one node.

To use this command, first visit a large Info file that has a tag
table.  The buffer is modified into a (small) indirect info file which
should be saved in place of the original visited file.

The subfiles are written in the same directory the original file is
in, with names generated by appending `-' and a number to the original
file name.  The indirect file still functions as an Info file, but it
contains just the tag table and a directory of subfiles." t)
(autoload 'Info-validate "informat" "\
Check current buffer for validity as an Info file.
Check that every node pointer points to an existing node." t)
(autoload 'batch-info-validate "informat" "\
Run `Info-validate' on the files remaining on the command line.
Must be used only with -batch, and kills Emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-info-validate $info/ ~/*.info\"")
(register-definition-prefixes "informat" '("Info-validate-"))


;;; Generated autoloads from emacs-lisp/inline.el

(autoload 'define-inline "inline" "\
Define an inline function NAME with arguments ARGS and body in BODY.

This is like `defmacro', but has several advantages.
See Info node `(elisp)Defining Functions' for more details.

(fn NAME ARGS &rest BODY)" nil t)
(function-put 'define-inline 'lisp-indent-function 'defun)
(function-put 'define-inline 'doc-string-elt 3)
(register-definition-prefixes "inline" '("inline-"))


;;; Generated autoloads from cedet/srecode/insert.el

(register-definition-prefixes "srecode/insert" '("srecode-"))


;;; Generated autoloads from leim/quail/ipa.el

(register-definition-prefixes "quail/ipa" '("ipa-x-sampa-"))


;;; Generated autoloads from international/isearch-x.el

(autoload 'isearch-toggle-specified-input-method "isearch-x" "\
Select an input method and turn it on in interactive search." t)
(autoload 'isearch-toggle-input-method "isearch-x" "\
Toggle input method in interactive search." t)
(autoload 'isearch-transient-input-method "isearch-x" "\
Activate transient input method in interactive search." t)
(autoload 'isearch-process-search-multibyte-characters "isearch-x" "\


(fn LAST-CHAR &optional COUNT)")
(register-definition-prefixes "isearch-x" '("isearch-"))


;;; Generated autoloads from isearchb.el

(push (purecopy '(isearchb 1 5)) package--builtin-versions)
(autoload 'isearchb-activate "isearchb" "\
Active isearchb mode for subsequent alphanumeric keystrokes.
Executing this command again will terminate the search; or, if
the search has not yet begun, will toggle to the last buffer
accessed via isearchb." t)
(register-definition-prefixes "isearchb" '("isearchb"))


;;; Generated autoloads from international/iso-ascii.el

(register-definition-prefixes "iso-ascii" '("iso-ascii-"))


;;; Generated autoloads from international/iso-cvt.el

(autoload 'iso-spanish "iso-cvt" "\
Translate net conventions for Spanish to ISO 8859-1.
Translate the region between FROM and TO using the table
`iso-spanish-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-german "iso-cvt" "\
Translate net conventions for German to ISO 8859-1.
Translate the region FROM and TO using the table
`iso-german-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-iso2tex "iso-cvt" "\
Translate ISO 8859-1 characters to TeX sequences.
Translate the region between FROM and TO using the table
`iso-iso2tex-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-tex2iso "iso-cvt" "\
Translate TeX sequences to ISO 8859-1 characters.
Translate the region between FROM and TO using the table
`iso-tex2iso-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-gtex2iso "iso-cvt" "\
Translate German TeX sequences to ISO 8859-1 characters.
Translate the region between FROM and TO using the table
`iso-gtex2iso-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-iso2gtex "iso-cvt" "\
Translate ISO 8859-1 characters to German TeX sequences.
Translate the region between FROM and TO using the table
`iso-iso2gtex-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-iso2duden "iso-cvt" "\
Translate ISO 8859-1 characters to Duden sequences.
Translate the region between FROM and TO using the table
`iso-iso2duden-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-iso2sgml "iso-cvt" "\
Translate ISO 8859-1 characters in the region to SGML entities.
Use entities from \"ISO 8879:1986//ENTITIES Added Latin 1//EN\".
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-sgml2iso "iso-cvt" "\
Translate SGML entities in the region to ISO 8859-1 characters.
Use entities from \"ISO 8879:1986//ENTITIES Added Latin 1//EN\".
Optional arg BUFFER is ignored (for use in `format-alist').

(fn FROM TO &optional BUFFER)" t)
(autoload 'iso-cvt-read-only "iso-cvt" "\
Warn that format is read-only.

(fn &rest IGNORE)" t)
(autoload 'iso-cvt-write-only "iso-cvt" "\
Warn that format is write-only.

(fn &rest IGNORE)" t)
(autoload 'iso-cvt-define-menu "iso-cvt" "\
Add submenus to the File menu, to convert to and from various formats." t)
(register-definition-prefixes "iso-cvt" '("iso-"))


;;; Generated autoloads from calendar/iso8601.el

(register-definition-prefixes "iso8601" '("iso8601-"))


;;; Generated autoloads from textmodes/ispell.el

(put 'ispell-check-comments 'safe-local-variable (lambda (a) (memq a '(nil t exclusive))))
(defvar ispell-personal-dictionary nil "\
File name of your personal spelling dictionary, or nil.
If nil, the default personal dictionary for your spelling checker is used.
Due to a misfeature of Hunspell, if the value is an absolute file name, the
file by that name must already exist for Hunspell to be able to use it.")
(custom-autoload 'ispell-personal-dictionary "ispell" t)
(put 'ispell-local-dictionary 'safe-local-variable 'string-or-null-p)
(defconst ispell-menu-map (let ((map (make-sparse-keymap "Spell"))) (define-key map [ispell-change-dictionary] `(menu-item ,(purecopy "Change Dictionary...") ispell-change-dictionary :help ,(purecopy "Supply explicit dictionary file name"))) (define-key map [ispell-kill-ispell] `(menu-item ,(purecopy "Kill Process") (lambda nil (interactive) (ispell-kill-ispell nil 'clear)) :enable (and (boundp 'ispell-process) ispell-process (eq (ispell-process-status) 'run)) :help ,(purecopy "Terminate Ispell subprocess"))) (define-key map [ispell-pdict-save] `(menu-item ,(purecopy "Save Dictionary") (lambda nil (interactive) (ispell-pdict-save t t)) :help ,(purecopy "Save personal dictionary"))) (define-key map [ispell-customize] `(menu-item ,(purecopy "Customize...") (lambda nil (interactive) (customize-group 'ispell)) :help ,(purecopy "Customize spell checking options"))) (define-key map [ispell-help] `(menu-item ,(purecopy "Help") (lambda nil (interactive) (describe-function 'ispell-help)) :help ,(purecopy "Show standard Ispell keybindings and commands"))) (define-key map [flyspell-mode] `(menu-item ,(purecopy "Automatic spell checking (Flyspell)") flyspell-mode :help ,(purecopy "Check spelling while you edit the text") :button (:toggle bound-and-true-p flyspell-mode))) (define-key map [ispell-complete-word] `(menu-item ,(purecopy "Complete Word") ispell-complete-word :help ,(purecopy "Complete word at cursor using dictionary"))) (define-key map [ispell-complete-word-interior-frag] `(menu-item ,(purecopy "Complete Word Fragment") ispell-complete-word-interior-frag :help ,(purecopy "Complete word fragment at cursor"))) (define-key map [ispell-continue] `(menu-item ,(purecopy "Continue Spell-Checking") ispell-continue :enable (and (boundp 'ispell-region-end) (marker-position ispell-region-end) (equal (marker-buffer ispell-region-end) (current-buffer))) :help ,(purecopy "Continue spell checking last region"))) (define-key map [ispell-word] `(menu-item ,(purecopy "Spell-Check Word") ispell-word :help ,(purecopy "Spell-check word at cursor"))) (define-key map [ispell-comments-and-strings] `(menu-item ,(purecopy "Spell-Check Comments") ispell-comments-and-strings :help ,(purecopy "Spell-check only comments and strings"))) (define-key map [ispell-region] `(menu-item ,(purecopy "Spell-Check Region") ispell-region :enable mark-active :help ,(purecopy "Spell-check text in marked region"))) (define-key map [ispell-message] `(menu-item ,(purecopy "Spell-Check Message") ispell-message :visible (eq major-mode 'mail-mode) :help ,(purecopy "Skip headers and included message text"))) (define-key map [ispell-buffer] `(menu-item ,(purecopy "Spell-Check Buffer") ispell-buffer :help ,(purecopy "Check spelling of selected buffer"))) map) "\
Key map for ispell menu.")
(fset 'ispell-menu-map (symbol-value 'ispell-menu-map))
(defvar ispell-skip-region-alist `((ispell-words-keyword forward-line) (ispell-dictionary-keyword forward-line) (ispell-pdict-keyword forward-line) (ispell-parsing-keyword forward-line) (,(purecopy "^---*BEGIN PGP [A-Z ]*--*") \, (purecopy "^---*END PGP [A-Z ]*--*")) (,(purecopy "^begin [0-9][0-9][0-9] [^ \11]+$") \, (purecopy "\nend\n")) (,(purecopy "^%!PS-Adobe-[123].0") \, (purecopy "\n%%EOF\n")) (,(purecopy "^---* \\(Start of \\)?[Ff]orwarded [Mm]essage") \, (purecopy "^---* End of [Ff]orwarded [Mm]essage"))) "\
Alist expressing beginning and end of regions not to spell check.
The alist key must be a regular expression.
Valid forms include:
  (KEY) - just skip the key.
  (KEY . REGEXP) - skip to the end of REGEXP.  REGEXP may be string or symbol.
  (KEY REGEXP) - skip to end of REGEXP.  REGEXP must be a string.
  (KEY FUNCTION ARGS) - FUNCTION called with ARGS returns end of region.")
(defvar ispell-tex-skip-alists (purecopy '((("\\\\addcontentsline" ispell-tex-arg-end 2) ("\\\\add\\(tocontents\\|vspace\\)" ispell-tex-arg-end) ("\\\\\\([aA]lph\\|arabic\\)" ispell-tex-arg-end) ("\\\\cref" ispell-tex-arg-end) ("\\\\bibliographystyle" ispell-tex-arg-end) ("\\\\makebox" ispell-tex-arg-end 0) ("\\\\e?psfig" ispell-tex-arg-end) ("\\\\document\\(class\\|style\\)" . "\\\\begin[ \11\n]*{document}")) (("\\(figure\\|table\\)\\*?" ispell-tex-arg-end 0) ("list" ispell-tex-arg-end 2) ("program" . "\\\\end[ \11]*{program}") ("verbatim\\*?" . "\\\\end[ \11]*{verbatim\\*?}")))) "\
Lists of regions to be skipped in TeX mode.
First list is used raw.
Second list has key placed inside \\begin{}.

Delete or add any regions you want to be automatically selected
for skipping in latex mode.")
(defconst ispell-html-skip-alists '(("<[cC][oO][dD][eE]\\>[^>]*>" "</[cC][oO][dD][eE]*>") ("<[sS][cC][rR][iI][pP][tT]\\>[^>]*>" "</[sS][cC][rR][iI][pP][tT]>") ("<[aA][pP][pP][lL][eE][tT]\\>[^>]*>" "</[aA][pP][pP][lL][eE][tT]>") ("<[vV][eE][rR][bB]\\>[^>]*>" "<[vV][eE][rR][bB]\\>[^>]*>") ("<[tT][tT]/" "/") ("<[^ \11\n>]" ">") ("&[^ \11\n;]" "[; \11\n]")) "\
Lists of start and end keys to skip in HTML buffers.
Same format as `ispell-skip-region-alist'.
Note - substrings of other matches must come last
 (e.g. \"<[tT][tT]/\" and \"<[^ \\t\\n>]\").")
(put 'ispell-local-pdict 'safe-local-variable 'stringp)
 (define-key esc-map "$" 'ispell-word)
(autoload 'ispell-word "ispell" "\
Check spelling of word under or before the cursor.
If the word is not found in dictionary, display possible corrections
in a window allowing you to choose one.

If optional argument FOLLOWING is non-nil or if `ispell-following-word'
is non-nil when called interactively, then the following word
(rather than preceding) is checked when the cursor is not over a word.
When the optional argument QUIETLY is non-nil or `ispell-quietly' is non-nil
when called interactively, non-corrective messages are suppressed.

With a prefix argument (or if CONTINUE is non-nil),
resume interrupted spell-checking of a buffer or region.

Interactively, in Transient Mark mode when the mark is active, call
`ispell-region' to check the active region for spelling errors.
Non-interactively, this happens if REGION is non-nil.

Word syntax is controlled by the definition of the chosen dictionary,
which is in `ispell-local-dictionary-alist' or `ispell-dictionary-alist'.

This will check or reload the dictionary.  Use \\[ispell-change-dictionary]
or \\[ispell-region] to update the Ispell process.

Return values:
nil           word is correct or spelling is accepted.
0             word is inserted into buffer-local definitions.
\"word\"        word corrected from word list.
(\"word\" arg)  word is hand entered.
quit          spell session exited.

(fn &optional FOLLOWING QUIETLY CONTINUE REGION)" t)
(autoload 'ispell-pdict-save "ispell" "\
Check to see if the personal dictionary has been modified.
If so, ask if it needs to be saved.
If NO-QUERY is non-nil, save the personal dictionary without asking.
Interactively, if `ispell-silently-savep' is non-nil, don't ask.
If FORCE-SAVE is non-nil, suggest to save the personal dictionary even
if not modified; this always happens interactively.

(fn &optional NO-QUERY FORCE-SAVE)" t)
(autoload 'ispell-help "ispell" "\
Display a list of the options available when a misspelling is encountered.

Selections are:

\\`0'..\\`9'  Replace the word with a digit offered in the *Choices* buffer.
\\`SPC' Accept word this time.
\\`i'   Accept word and insert into private dictionary.
\\`a'   Accept word for this session.
\\`A'   Accept word and place in `buffer-local dictionary'.
\\`r'   Replace word with typed-in value.  Rechecked.
\\`R'   Replace word with typed-in value.  Query-replaced in buffer.  Rechecked.
\\`?'   Show these commands.
\\`x'   Exit spelling buffer.  Move cursor to original point.
\\`X'   Exit spelling buffer.  Leaves cursor at the current point, and permits
         the aborted check to be completed later.
\\`q'   Quit spelling session (Kills ispell process).
\\`l'   Look up typed-in replacement in alternate dictionary.  Wildcards okay.
\\`u'   Like \\`i', but the word is lower-cased first.
\\`m'   Place typed-in value in personal dictionary, then recheck current word.
\\`C-l' Redraw screen.
\\`C-r' Recursive edit.
\\`C-z' Suspend Emacs or iconify frame.")
(autoload 'ispell-kill-ispell "ispell" "\
Kill current Ispell process (so that you may start a fresh one).
With NO-ERROR, just return non-nil if there was no Ispell running.
With CLEAR, buffer session localwords are cleaned.

(fn &optional NO-ERROR CLEAR)" t)
(autoload 'ispell-change-dictionary "ispell" "\
Change to dictionary DICT for Ispell.
If ARG is non-nil (interactively, the prefix arg), set it \"globally\",
for all buffers.  Otherwise, set it \"locally\", just for this buffer.

By just answering RET you can find out the name of the current dictionary.

(fn DICT &optional ARG)" t)
(autoload 'ispell-region "ispell" "\
Interactively check region between REG-START and REG-END for spelling errors.
Leave the mark at the last misspelled word that the user was queried about.

Return nil if spell session was terminated, otherwise returns shift offset
amount for last line processed.

(fn REG-START REG-END &optional RECHECKP SHIFT)" t)
(autoload 'ispell-comments-and-strings "ispell" "\
Check comments and strings in the current buffer for spelling errors.
If called interactively with an active region, check only comments and
strings in the region.
When called from Lisp, START and END buffer positions can be provided
to limit the check.

(fn &optional START END)" t)
(autoload 'ispell-comment-or-string-at-point "ispell" "\
Check the comment or string containing point for spelling errors." t)
(autoload 'ispell-buffer "ispell" "\
Check the current buffer for spelling errors interactively.
Leave the mark at the last misspelled word that the user was queried about." t)
(autoload 'ispell-buffer-with-debug "ispell" "\
`ispell-buffer' with some output sent to `ispell-debug-buffer'.
If APPEND is non-nil, don't erase previous debugging output.

(fn &optional APPEND)" t)
(autoload 'ispell-continue "ispell" "\
Continue a halted spelling session beginning with the current word." t)
(autoload 'ispell-completion-at-point "ispell" "\
Word completion function for use in `completion-at-point-functions'.")
(autoload 'ispell-complete-word "ispell" "\
Try to complete the word before or at point.
If optional INTERIOR-FRAG is non-nil, then the word may be a character
sequence inside of a word.

Standard ispell choices are then available.

This command uses a word-list file specified
by `ispell-alternate-dictionary' or by `ispell-complete-word-dict';
if none of those name an existing word-list file, this command
signals an error.

(fn &optional INTERIOR-FRAG)" t)
(autoload 'ispell-complete-word-interior-frag "ispell" "\
Completes word matching character sequence inside a word." t)
(autoload 'ispell "ispell" "\
Interactively check a region or buffer for spelling errors.
If `transient-mark-mode' is on, and a region is active, spell-check
that region.  Otherwise spell-check the buffer.

Ispell dictionaries are not distributed with Emacs.  If you are
looking for a dictionary, please see the distribution of the GNU ispell
program, or do an Internet search; there are various dictionaries
available on the net." t)
(autoload 'ispell-minor-mode "ispell" "\
Toggle last-word spell checking (Ispell minor mode).

Ispell minor mode is a buffer-local minor mode.  When enabled,
typing SPC or RET warns you if the previous word is incorrectly
spelled.

All the buffer-local variables and dictionaries are ignored.  To
read them into the running Ispell process, type \\[ispell-word]
SPC.

For spell-checking \"on the fly\", not just after typing SPC or
RET, use `flyspell-mode'.

This is a minor mode.  If called interactively, toggle the `ISpell minor
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `ispell-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'ispell-message "ispell" "\
Check the spelling of a mail message or news post.
Don't check spelling of message headers except the Subject field.
Don't check included messages.

To abort spell checking of a message region and send the message anyway,
use the \\`x' command.  (Any subsequent regions will be checked.)
The \\`X' command aborts sending the message so that you can edit the buffer.

To spell-check whenever a message is sent, include the appropriate lines
in your init file:
   (add-hook \\='message-send-hook #\\='ispell-message)  ;; GNUS 5
   (add-hook \\='news-inews-hook #\\='ispell-message)    ;; GNUS 4
   (add-hook \\='mail-send-hook  #\\='ispell-message)
   (add-hook \\='mh-before-send-letter-hook #\\='ispell-message)

You can bind this to a key in GNUS or mail by adding to
`news-reply-mode-hook' or `mail-mode-hook' the following lambda expression:
   (lambda () (local-set-key \"\\C-ci\" \\='ispell-message))" t)
(register-definition-prefixes "ispell" '("check-ispell-version" "ispell-"))


;;; Generated autoloads from international/ja-dic-cnv.el

(register-definition-prefixes "ja-dic-cnv" '("batch-skkdic-convert" "ja-dic-filename" "skkdic-"))


;;; Generated autoloads from international/ja-dic-utl.el

(register-definition-prefixes "ja-dic-utl" '("skkdic-"))


;;; Generated autoloads from language/japan-util.el

(autoload 'setup-japanese-environment-internal "japan-util")
(autoload 'japanese-katakana "japan-util" "\
Convert argument to Katakana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument HANKAKU t means to convert to `hankaku' Katakana
(`japanese-jisx0201-kana'), in which case return value
may be a string even if OBJ is a character if two Katakanas are
necessary to represent OBJ.

(fn OBJ &optional HANKAKU)")
(autoload 'japanese-hiragana "japan-util" "\
Convert argument to Hiragana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

(fn OBJ)")
(autoload 'japanese-hankaku "japan-util" "\
Convert argument to `hankaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument ASCII-ONLY non-nil means to return only ASCII character.

(fn OBJ &optional ASCII-ONLY)")
(autoload 'japanese-zenkaku "japan-util" "\
Convert argument to `zenkaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

(fn OBJ)")
(autoload 'japanese-katakana-region "japan-util" "\
Convert Japanese `hiragana' chars in the region to `katakana' chars.
Optional argument HANKAKU t means to convert to `hankaku katakana' character
of which charset is `japanese-jisx0201-kana'.

(fn FROM TO &optional HANKAKU)" t)
(autoload 'japanese-hiragana-region "japan-util" "\
Convert Japanese `katakana' chars in the region to `hiragana' chars.

(fn FROM TO)" t)
(autoload 'japanese-hankaku-region "japan-util" "\
Convert Japanese `zenkaku' chars in the region to `hankaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument ASCII-ONLY non-nil means to convert only to ASCII char.

(fn FROM TO &optional ASCII-ONLY)" t)
(autoload 'japanese-zenkaku-region "japan-util" "\
Convert hankaku' chars in the region to Japanese `zenkaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument KATAKANA-ONLY non-nil means to convert only KATAKANA char.

(fn FROM TO &optional KATAKANA-ONLY)" t)
(autoload 'read-hiragana-string "japan-util" "\
Read a Hiragana string from the minibuffer, prompting with string PROMPT.
If non-nil, second arg INITIAL-INPUT is a string to insert before reading.

(fn PROMPT &optional INITIAL-INPUT)")
(register-definition-prefixes "japan-util" '("japanese-"))


;;; Generated autoloads from leim/quail/japanese.el

(register-definition-prefixes "quail/japanese" '("quail-japanese-"))


;;; Generated autoloads from cedet/semantic/java.el

(register-definition-prefixes "semantic/java" '("semantic-"))


;;; Generated autoloads from cedet/semantic/wisent/java-tags.el

(register-definition-prefixes "semantic/wisent/java-tags" '("semantic-" "wisent-java-parse-error"))


;;; Generated autoloads from progmodes/java-ts-mode.el

(autoload 'java-ts-mode "java-ts-mode" "\
Major mode for editing Java, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "java-ts-mode" '("java-ts-mode-"))


;;; Generated autoloads from cedet/semantic/wisent/javascript.el

(register-definition-prefixes "semantic/wisent/javascript" '("semantic-" "wisent-javascript-jv-expand-tag"))


;;; Generated autoloads from jka-compr.el

(defvar jka-compr-inhibit nil "\
Non-nil means inhibit automatic uncompression temporarily.
Lisp programs can bind this to t to do that.
It is not recommended to set this variable permanently to anything but nil.")
(autoload 'jka-compr-handler "jka-compr" "\


(fn OPERATION &rest ARGS)")
(autoload 'jka-compr-uninstall "jka-compr" "\
Uninstall jka-compr.
This removes the entries in `file-name-handler-alist' and `auto-mode-alist'
and `inhibit-local-variables-suffixes' that were added
by `jka-compr-install'.")
(register-definition-prefixes "jka-compr" '("compression-error" "jka-compr-"))


;;; Generated autoloads from progmodes/js.el

(push (purecopy '(js 9)) package--builtin-versions)
(autoload 'js-base-mode "js" "\
Generic major mode for editing JavaScript.

This mode is intended to be inherited by concrete major modes.
Currently there are `js-mode' and `js-ts-mode'.

(fn)" t)
(autoload 'js-mode "js" "\
Major mode for editing JavaScript.

(fn)" t)
(autoload 'js-ts-mode "js" "\
Major mode for editing JavaScript.

\\<js-ts-mode-map>

(fn)" t)
(autoload 'js-json-mode "js" "\


(fn)" t)
(autoload 'js-jsx-mode "js" "\
Major mode for editing JavaScript+JSX.

Simply makes `js-jsx-syntax' buffer-local and sets it to t.

`js-mode' may detect and enable support for JSX automatically if
it appears to be used in a JavaScript file.  You could also
customize `js-jsx-regexps' to improve that detection; or, you
could set `js-jsx-syntax' to t in your init file, or in a
.dir-locals.el file, or using file variables; or, you could call
`js-jsx-enable' in `js-mode-hook'.  You may be better served by
one of the aforementioned options instead of using this mode.

(fn)" t)
 (defalias 'javascript-mode 'js-mode)
(dolist (name (list "node" "nodejs" "gjs" "rhino")) (add-to-list 'interpreter-mode-alist (cons (purecopy name) 'js-mode)))
(register-definition-prefixes "js" '("js-"))


;;; Generated autoloads from json.el

(push (purecopy '(json 1 5)) package--builtin-versions)
(register-definition-prefixes "json" '("json-"))


;;; Generated autoloads from progmodes/json-ts-mode.el

(autoload 'json-ts-mode "json-ts-mode" "\
Major mode for editing JSON, powered by tree-sitter.

(fn)" t)
(register-definition-prefixes "json-ts-mode" '("json-ts-"))


;;; Generated autoloads from jsonrpc.el

(push (purecopy '(jsonrpc 1 0 25)) package--builtin-versions)
(register-definition-prefixes "jsonrpc" '("jsonrpc-"))


;;; Generated autoloads from kermit.el

(register-definition-prefixes "kermit" '("kermit-"))


;;; Generated autoloads from emulation/keypad.el

(defvar keypad-setup nil "\
Specifies the keypad setup for unshifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")
(custom-autoload 'keypad-setup "keypad" nil)
(defvar keypad-numlock-setup nil "\
Specifies the keypad setup for unshifted keypad keys when NumLock is on.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")
(custom-autoload 'keypad-numlock-setup "keypad" nil)
(defvar keypad-shifted-setup nil "\
Specifies the keypad setup for shifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")
(custom-autoload 'keypad-shifted-setup "keypad" nil)
(defvar keypad-numlock-shifted-setup nil "\
Specifies the keypad setup for shifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")
(custom-autoload 'keypad-numlock-shifted-setup "keypad" nil)
(autoload 'keypad-setup "keypad" "\
Set keypad bindings in `function-key-map' according to SETUP.
If optional second argument NUMLOCK is non-nil, the NumLock On bindings
are changed.  Otherwise, the NumLock Off bindings are changed.
If optional third argument SHIFT is non-nil, the shifted keypad
keys are bound.

 Setup      Binding
 -------------------------------------------------------------
 `prefix'   Command prefix argument, i.e.  M-0 .. M-9 and M--
 `S-cursor' Bind shifted keypad keys to the shifted cursor movement keys.
 `cursor'   Bind keypad keys to the cursor movement keys.
 `numeric'  Plain numeric keypad, i.e. 0 .. 9 and .  (or DECIMAL arg)
 `none'     Removes all bindings for keypad keys in `function-key-map';
            this enables any user-defined bindings for the keypad keys
            in the global and local keymaps.

If SETUP is `numeric' and the optional fourth argument DECIMAL is non-nil,
the decimal key on the keypad is mapped to DECIMAL instead of `.'

(fn SETUP &optional NUMLOCK SHIFT DECIMAL)")


;;; Generated autoloads from international/kinsoku.el

(autoload 'kinsoku "kinsoku" "\
Go to a line breaking position near point by doing `kinsoku' processing.
LINEBEG is a buffer position we can't break a line before.

`Kinsoku' processing is to prohibit specific characters to be placed
at beginning of line or at end of line.  Characters not to be placed
at beginning and end of line have character category `>' and `<'
respectively.  This restriction is dissolved by making a line longer or
shorter.

`Kinsoku' is a Japanese word which originally means ordering to stay
in one place, and is used for the text processing described above in
the context of text formatting.

(fn LINEBEG)")
(register-definition-prefixes "kinsoku" '("kinsoku-"))


;;; Generated autoloads from international/kkc.el

(defvar kkc-after-update-conversion-functions nil "\
Functions to run after a conversion is selected in `japanese' input method.
With this input method, a user can select a proper conversion from
candidate list.  Each time he changes the selection, functions in this
list are called with two arguments; starting and ending buffer
positions that contains the current selection.")
(autoload 'kkc-region "kkc" "\
Convert Kana string in the current region to Kanji-Kana mixed string.
Users can select a desirable conversion interactively.
When called from a program, expects two arguments,
positions FROM and TO (integers or markers) specifying the target region.
When it returns, the point is at the tail of the selected conversion,
and the return value is the length of the conversion.

(fn FROM TO)" t)
(register-definition-prefixes "kkc" '("kkc-"))


;;; Generated autoloads from kmacro.el

 (global-set-key "\C-x(" #'kmacro-start-macro)
 (global-set-key "\C-x)" #'kmacro-end-macro)
 (global-set-key "\C-xe" #'kmacro-end-and-call-macro)
 (global-set-key [f3] #'kmacro-start-macro-or-insert-counter)
 (global-set-key [f4] #'kmacro-end-or-call-macro)
 (global-set-key "\C-x\C-k" #'kmacro-keymap)
 (autoload 'kmacro-keymap "kmacro" "Keymap for keyboard macro commands." t 'keymap)
(define-obsolete-function-alias 'kmacro-exec-ring-item #'funcall "29.1" "Execute item ITEM from the macro ring.
ARG is the number of times to execute the item.")
(autoload 'kmacro-start-macro "kmacro" "\
Record subsequent keyboard input, defining a keyboard macro.
The commands are recorded even as they are executed.
Use \\[kmacro-end-macro] to finish recording and make the macro available.
Use \\[kmacro-end-and-call-macro] to execute the macro.

Non-nil arg (prefix arg) means append to last macro defined.

With \\[universal-argument] prefix, append to last keyboard macro
defined.  Depending on `kmacro-execute-before-append', this may begin
by re-executing the last macro as if you typed it again.

Otherwise, it sets `kmacro-counter' to ARG or 0 if missing before
defining the macro.

Use \\[kmacro-insert-counter] to insert (and increment) the macro counter.
The counter value can be set or modified via \\[kmacro-set-counter] and \\[kmacro-add-counter].
The format of the counter can be modified via \\[kmacro-set-format].

Use \\[kmacro-name-last-macro] to give it a name that will remain valid even
after another macro is defined.
Use \\[kmacro-bind-to-key] to bind it to a key sequence.

(fn ARG)" t)
(autoload 'kmacro-end-macro "kmacro" "\
Finish defining a keyboard macro.
The definition was started by \\[kmacro-start-macro].
The macro is now available for use via \\[kmacro-call-macro],
or it can be given a name with \\[kmacro-name-last-macro] and then invoked
under that name.

With numeric ARG, repeat the macro that many times,
counting the definition just completed as the first repetition.
An argument of zero means repeat until error.

(fn ARG)" t)
(autoload 'kmacro-call-macro "kmacro" "\
Call the keyboard MACRO that you defined with \\[kmacro-start-macro].
A prefix argument serves as a repeat count.  Zero means repeat until error.
MACRO defaults to `last-kbd-macro'.

When you call the macro, you can call the macro again by repeating
just the last key in the key sequence that you used to call this
command.  See `kmacro-call-repeat-key' and `kmacro-call-repeat-with-arg'
for details on how to adjust or disable this behavior.

To give a macro a name so you can call it even after defining others,
use \\[kmacro-name-last-macro].

(fn ARG &optional NO-REPEAT END-MACRO MACRO)" t)
(autoload 'kmacro-start-macro-or-insert-counter "kmacro" "\
Record subsequent keyboard input, defining a keyboard macro.
The commands are recorded even as they are executed.

Initializes the macro's `kmacro-counter' to ARG (or 0 if no prefix arg)
before defining the macro.

With \\[universal-argument], appends to current keyboard macro (keeping
the current value of `kmacro-counter').

When used during defining/executing a macro, inserts the current value
of `kmacro-counter' and increments the counter value by ARG (or by 1 if no
prefix argument).  With just \\[universal-argument], inserts the previous
value of `kmacro-counter', and does not modify the counter; this is
different from incrementing the counter by zero.  (The previous value
of the counter is the one it had before the last increment.)

The macro counter can be set directly via \\[kmacro-set-counter] and \\[kmacro-add-counter].
The format of the inserted value of the counter can be controlled
via \\[kmacro-set-format].

(fn ARG)" t)
(autoload 'kmacro-end-or-call-macro "kmacro" "\
End kbd macro if currently being defined; else call last kbd macro.
With numeric prefix ARG, repeat macro that many times.
With \\[universal-argument], call second macro in macro ring.

(fn ARG &optional NO-REPEAT)" t)
(autoload 'kmacro-end-and-call-macro "kmacro" "\
Call last keyboard macro, ending it first if currently being defined.
With numeric prefix ARG, repeat macro that many times.
Zero argument means repeat until there is an error.

To give a macro a name, so you can call it even after defining other
macros, use \\[kmacro-name-last-macro].

(fn ARG &optional NO-REPEAT)" t)
(autoload 'kmacro-end-call-mouse "kmacro" "\
Move point to the position clicked with the mouse and call last kbd macro.
If kbd macro currently being defined end it before activating it.

(fn EVENT)" t)
(autoload 'kmacro "kmacro" "\
Create a `kmacro' for macro bound to symbol or key.
KEYS should be a vector or a string that obeys `key-valid-p'.

(fn KEYS &optional COUNTER FORMAT)")
(autoload 'kmacro-lambda-form "kmacro" "\


(fn MAC &optional COUNTER FORMAT)")
(make-obsolete 'kmacro-lambda-form 'kmacro "29.1")
(autoload 'kmacro-name-last-macro "kmacro" "\
Assign a name to the last keyboard macro defined.
Argument SYMBOL is the name to define.
The symbol's function definition becomes the keyboard macro string.
Such a \"function\" cannot be called from Lisp, but it is a valid editor command.

(fn SYMBOL)" t)
(defalias 'kmacro-menu #'list-keyboard-macros)
(autoload 'list-keyboard-macros "kmacro" "\
List the keyboard macros." t)
(register-definition-prefixes "kmacro" '("kmacro-"))


;;; Generated autoloads from language/korea-util.el

(defvar default-korean-keyboard (purecopy (if (string-search "3" (or (getenv "HANGUL_KEYBOARD_TYPE") "")) "3" "")) "\
The kind of Korean keyboard for Korean (Hangul) input method.
\"\" for 2, \"3\" for 3, and \"3f\" for 3f.")
(autoload 'setup-korean-environment-internal "korea-util")
(register-definition-prefixes "korea-util" '("exit-korean-environment" "isearch-" "korean-key-bindings" "quail-hangul-switch-" "toggle-korean-input-method"))


;;; Generated autoloads from leim/quail/lao.el

(register-definition-prefixes "quail/lao" '("lao-" "quail-lao-update-translation"))


;;; Generated autoloads from language/lao-util.el

(autoload 'lao-compose-string "lao-util" "\


(fn STR)")
(autoload 'lao-transcribe-single-roman-syllable-to-lao "lao-util" "\
Transcribe a Romanized Lao syllable in the region FROM and TO to Lao string.
Only the first syllable is transcribed.
The value has the form: (START END LAO-STRING), where
START and END are the beginning and end positions of the Roman Lao syllable,
LAO-STRING is the Lao character transcription of it.

Optional 3rd arg STR, if non-nil, is a string to search for Roman Lao
syllable.  In that case, FROM and TO are indexes to STR.

(fn FROM TO &optional STR)")
(autoload 'lao-transcribe-roman-to-lao-string "lao-util" "\
Transcribe Romanized Lao string STR to Lao character string.

(fn STR)")
(autoload 'lao-composition-function "lao-util" "\


(fn GSTRING DIRECTION)")
(autoload 'lao-compose-region "lao-util" "\


(fn FROM TO)" t)
(register-definition-prefixes "lao-util" '("lao-"))


;;; Generated autoloads from international/latexenc.el

(defvar latex-inputenc-coding-alist (purecopy '(("ansinew" . windows-1252) ("applemac" . mac-roman) ("ascii" . us-ascii) ("cp1250" . windows-1250) ("cp1252" . windows-1252) ("cp1257" . cp1257) ("cp437de" . cp437) ("cp437" . cp437) ("cp850" . cp850) ("cp852" . cp852) ("cp858" . cp858) ("cp865" . cp865) ("latin1" . iso-8859-1) ("latin2" . iso-8859-2) ("latin3" . iso-8859-3) ("latin4" . iso-8859-4) ("latin5" . iso-8859-9) ("latin9" . iso-8859-15) ("latin10" . iso-8859-16) ("next" . next) ("utf8" . utf-8) ("utf8x" . utf-8))) "\
Mapping from LaTeX encodings in \"inputenc.sty\" to Emacs coding systems.
LaTeX encodings are specified with \"\\usepackage[encoding]{inputenc}\".
Used by the function `latexenc-find-file-coding-system'.")
(custom-autoload 'latex-inputenc-coding-alist "latexenc" t)
(autoload 'latexenc-inputenc-to-coding-system "latexenc" "\
Return the corresponding coding-system for the specified input encoding.
Return nil if no matching coding system can be found.

(fn INPUTENC)")
(autoload 'latexenc-coding-system-to-inputenc "latexenc" "\
Return the corresponding input encoding for the specified coding system.
Return nil if no matching input encoding can be found.

(fn CS)")
(autoload 'latexenc-find-file-coding-system "latexenc" "\
Determine the coding system of a LaTeX file if it uses \"inputenc.sty\".
The mapping from LaTeX's \"inputenc.sty\" encoding names to Emacs
coding system names is determined from `latex-inputenc-coding-alist'.

(fn ARG-LIST)")
(register-definition-prefixes "latexenc" '("latexenc-dont-use-"))


;;; Generated autoloads from international/latin1-disp.el

(defvar latin1-display nil "\
Set up Latin-1/ASCII display for ISO8859 character sets.
This is done for each character set in the list `latin1-display-sets',
if no font is available to display it.  Characters are displayed using
the corresponding Latin-1 characters where they match.  Otherwise
ASCII sequences are used, mostly following the Latin prefix input
methods.  Some different ASCII sequences are used if
`latin1-display-mnemonic' is non-nil.

This option also treats some characters in the `mule-unicode-...'
charsets if you don't have a Unicode font with which to display them.

Setting this variable directly does not take effect;
use either \\[customize] or the command `latin1-display'.")
(custom-autoload 'latin1-display "latin1-disp" nil)
(autoload 'latin1-display "latin1-disp" "\
Set up Latin-1/ASCII display for the arguments character SETS.
See option `latin1-display' for the method.  The members of the list
must be in `latin1-display-sets'.  With no arguments, reset the
display for all of `latin1-display-sets'.  See also
`latin1-display-setup'.

(fn &rest SETS)")
(defvar latin1-display-ucs-per-lynx nil "\
Set up Latin-1/ASCII display for Unicode characters.
This uses the transliterations of the Lynx browser.  The display isn't
changed if the display can render Unicode characters.

Setting this variable directly does not take effect;
use either \\[customize] or the command `latin1-display-ucs-per-lynx'.")
(custom-autoload 'latin1-display-ucs-per-lynx "latin1-disp" nil)
(autoload 'latin1-display-ucs-per-lynx "latin1-disp" "\
Set up Latin-1/ASCII display for Unicode characters.
This uses the transliterations of the Lynx browser.

With argument ARG, turn such display on if ARG is positive, otherwise
turn it off and display Unicode characters literally.  The display
isn't changed if the display can render Unicode characters.

(fn ARG)" t)
(register-definition-prefixes "latin1-disp" '("latin1-display-"))


;;; Generated autoloads from progmodes/ld-script.el

(autoload 'ld-script-mode "ld-script" "\
A major mode to edit GNU ld script files.

(fn)" t)
(register-definition-prefixes "ld-script" '("ld-script-"))


;;; Generated autoloads from net/ldap.el

(register-definition-prefixes "ldap" '("ldap-"))


;;; Generated autoloads from textmodes/less-css-mode.el

(put 'less-css-compile-at-save 'safe-local-variable #'booleanp)
(put 'less-css-lessc-options 'safe-local-variable t)
(put 'less-css-output-directory 'safe-local-variable #'stringp)
(put 'less-css-input-file-name 'safe-local-variable #'stringp)
 (add-to-list 'auto-mode-alist '("\\.less\\'" . less-css-mode))
(autoload 'less-css-mode "less-css-mode" "\
Major mode for editing Less files (https://lesscss.org/).
Special commands:
\\{less-css-mode-map}

(fn)" t)
(register-definition-prefixes "less-css-mode" '("less-css-"))


;;; Generated autoloads from emacs-lisp/let-alist.el

(push (purecopy '(let-alist 1 0 6)) package--builtin-versions)
(autoload 'let-alist "let-alist" "\
Let-bind dotted symbols to their cdrs in ALIST and execute BODY.
Dotted symbol is any symbol starting with a `.'.  Only those present
in BODY are let-bound and this search is done at compile time.

For instance, the following code

  (let-alist alist
    (if (and .title .body)
        .body
      .site
      .site.contents))

essentially expands to

  (let ((.title (cdr (assq \\='title alist)))
        (.body  (cdr (assq \\='body alist)))
        (.site  (cdr (assq \\='site alist)))
        (.site.contents (cdr (assq \\='contents (cdr (assq \\='site alist))))))
    (if (and .title .body)
        .body
      .site
      .site.contents))

If you nest `let-alist' invocations, the inner one can't access
the variables of the outer one.  You can, however, access alists
inside the original alist by using dots inside the symbol, as
displayed in the example above.

Note that there is no way to differentiate the case where a key
is missing from when it is present, but its value is nil.  Thus,
the following form evaluates to nil:

    (let-alist \\='((some-key . nil))
      .some-key)

(fn ALIST &rest BODY)" nil t)
(function-put 'let-alist 'lisp-indent-function 1)
(register-definition-prefixes "let-alist" '("let-alist--"))


;;; Generated autoloads from cedet/semantic/lex.el

(register-definition-prefixes "semantic/lex" '("define-lex" "semantic-"))


;;; Generated autoloads from cedet/semantic/lex-spp.el

(register-definition-prefixes "semantic/lex-spp" '("define-lex-spp-" "semantic-lex-"))


;;; Generated autoloads from play/life.el

(autoload 'life "life" "\
Run Conway's Life simulation.
The starting pattern is randomly selected from `life-patterns'.

Prefix arg is the number of tenths of a second to sleep between
generations (the default is `life-step-time').

When called from Lisp, optional argument STEP-TIME is the time to
sleep in seconds.

(fn &optional STEP-TIME)" t)
(register-definition-prefixes "life" '("life-"))


;;; Generated autoloads from cedet/ede/linux.el

(register-definition-prefixes "ede/linux" '("ede-linux-" "project-linux-"))


;;; Generated autoloads from emacs-lisp/lisp-mnt.el

(register-definition-prefixes "lisp-mnt" '("lm-"))


;;; Generated autoloads from cedet/semantic/symref/list.el

(register-definition-prefixes "semantic/symref/list" '("semantic-symref-"))


;;; Generated autoloads from emacs-lisp/loaddefs-gen.el

(put 'autoload-compute-prefixes 'safe-local-variable #'booleanp)
(put 'generated-autoload-file 'safe-local-variable 'stringp)
(put 'generated-autoload-load-name 'safe-local-variable 'stringp)
(autoload 'loaddefs-generate "loaddefs-gen" "\
Generate loaddefs files for Lisp files in one or more directories given by DIR.
DIR can be either a single directory or a list of directories.

The autoloads will be written to OUTPUT-FILE.  If any Lisp file
binds `generated-autoload-file' as a file-local variable, write
its autoloads into the specified file instead.

The function does NOT recursively descend into subdirectories of the
directories specified by DIR.

Optional argument EXCLUDED-FILES, if non-nil, should be a list of
files, such as preloaded files, whose autoloads should not be written
to OUTPUT-FILE.

If EXTRA-DATA is non-nil, it should be a string; include that string
at the beginning of the generated file.  This will also force the
generation of OUTPUT-FILE even if there are no autoloads to put into
that file.

If INCLUDE-PACKAGE-VERSION is non-nil, include package version data.

If GENERATE-FULL is non-nil, regenerate all the loaddefs files anew,
instead of just updating them with the new/changed autoloads.

(fn DIR OUTPUT-FILE &optional EXCLUDED-FILES EXTRA-DATA INCLUDE-PACKAGE-VERSION GENERATE-FULL)")
(autoload 'loaddefs-generate-batch "loaddefs-gen" "\
Generate loaddefs.el files in batch mode.
This scans for ;;;###autoload forms and related things.

The first element on the command line should be the (main)
loaddefs.el output file, and the rest are the directories to
use.")
 (load "theme-loaddefs.el" t)
(register-definition-prefixes "loaddefs-gen" '("autoload-" "generated-autoload-" "loaddefs-generate--" "no-update-autoloads"))


;;; Generated autoloads from loadhist.el

(autoload 'unload-feature "loadhist" "\
Unload the library that provided FEATURE.
If the feature is required by any other loaded code, and prefix arg FORCE
is nil, raise an error.

Standard unloading activities include restoring old autoloads for
functions defined by the library, removing such functions from
hooks and `auto-mode-alist', undoing their ELP profiling,
unproviding any features provided by the library, and canceling
timers held in variables defined by the library.

If a function `FEATURE-unload-function' is defined, this function
calls it with no arguments, before doing anything else.  That function
can do whatever is appropriate to undo the loading of the library.  If
`FEATURE-unload-function' returns non-nil, that suppresses the
standard unloading of the library.  Otherwise the standard unloading
proceeds.

`FEATURE-unload-function' has access to the package's list of
definitions in the variable `unload-function-defs-list' and could
remove symbols from it in the event that the package has done
something strange, such as redefining an Emacs function.

(fn FEATURE &optional FORCE)" t)
(register-definition-prefixes "loadhist" '("feature-" "file-" "loadhist-unload-filename" "read-feature" "unload-"))


;;; Generated autoloads from cedet/ede/locate.el

(register-definition-prefixes "ede/locate" '("ede-locate-"))


;;; Generated autoloads from locate.el

(defvar locate-ls-subdir-switches (purecopy "-al") "\
`ls' switches for inserting subdirectories in `*Locate*' buffers.
This should contain the \"-l\" switch, but not the \"-F\" or \"-b\" switches.")
(custom-autoload 'locate-ls-subdir-switches "locate" t)
(autoload 'locate "locate" "\
Run the program `locate', putting results in `*Locate*' buffer.
Pass it SEARCH-STRING as argument.  Interactively, prompt for SEARCH-STRING.
With prefix arg ARG, prompt for the exact shell command to run instead.

This program searches for those file names in a database that match
SEARCH-STRING and normally outputs all matching absolute file names,
one per line.  The database normally consists of all files on your
system, or of all files that you have access to.  Consult the
documentation of the program for the details about how it determines
which file names match SEARCH-STRING.  (Those details vary highly with
the version.)

You can specify another program for this command to run by customizing
the variables `locate-command' or `locate-make-command-line'.

The main use of FILTER is to implement `locate-with-filter'.  See
the docstring of that function for its meaning.

After preparing the results buffer, this runs `dired-mode-hook' and
then `locate-post-command-hook'.

(fn SEARCH-STRING &optional FILTER ARG)" t)
(autoload 'locate-with-filter "locate" "\
Run the executable program `locate' with a filter.
This function is similar to the function `locate', which see.
The difference is that, when invoked interactively, the present function
prompts for both SEARCH-STRING and FILTER.  It passes SEARCH-STRING
to the locate executable program.  It produces a `*Locate*' buffer
that lists only those lines in the output of the locate program that
contain a match for the regular expression FILTER; this is often useful
to constrain a big search.

ARG is the interactive prefix arg, which has the same effect as in `locate'.

When called from Lisp, this function is identical with `locate',
except that FILTER is not optional.

(fn SEARCH-STRING FILTER &optional ARG)" t)
(register-definition-prefixes "locate" '("locate-"))


;;; Generated autoloads from vc/log-edit.el

(autoload 'log-edit "log-edit" "\
Setup a buffer to enter a VC commit log message.
The buffer is put in mode MODE, or `log-edit-mode' if MODE is nil.
\\<log-edit-mode-map>
If SETUP is non-nil, erase the buffer and run `log-edit-hook'.
Set mark and point around the entire contents of the buffer, so
that it is easy to kill the contents of the buffer with
\\[kill-region].  Once the user is done editing the message, he
or she is expected to invoke the command \\[log-edit-done] (`log-edit-done'),
which will call CALLBACK, a function to do the actual commit.

PARAMS, if non-nil, is an alist of variables and buffer-local
values to give to those variables in the Log Edit buffer.  Possible
keys and associated values are:
 `log-edit-listfun' -- function taking no arguments that returns the list of
    files that are concerned by the current operation (using relative names);
 `log-edit-diff-function' -- function taking no arguments that
    displays a diff of the files concerned by the current operation.
 `vc-log-fileset' -- the VC fileset to be committed (if any).

If BUFFER is non-nil, `log-edit' will switch to that buffer, use it
to edit the log message and go back to the current buffer when
done.  Otherwise, this function will use the current buffer.

(fn CALLBACK &optional SETUP PARAMS BUFFER MODE &rest IGNORE)")
(register-definition-prefixes "log-edit" '("log-edit-"))


;;; Generated autoloads from vc/log-view.el

(autoload 'log-view-mode "log-view" "\
Major mode for browsing CVS log output.

(fn)" t)
(autoload 'log-view-get-marked "log-view" "\
Return the list of tags for the marked log entries.")
(register-definition-prefixes "log-view" '("log-view-"))


;;; Generated autoloads from lpr.el

(defvar lpr-windows-system (memq system-type '(ms-dos windows-nt)) "\
Non-nil if running on MS-DOS or MS Windows.")
(defvar lpr-lp-system (memq system-type '(usg-unix-v hpux)) "\
Non-nil if running on a system type that uses the \"lp\" command.")
(defvar printer-name (and (eq system-type 'ms-dos) "PRN") "\
The name of a local printer to which data is sent for printing.
(Note that PostScript files are sent to `ps-printer-name', which see.)

On Unix-like systems, a string value should be a name understood by
lpr's -P option; otherwise the value should be nil.

On MS-DOS and MS-Windows systems, a string value is taken as the name of
a printer device or port, provided `lpr-command' is set to \"\".
Typical non-default settings would be \"LPT1\" to \"LPT3\" for parallel
printers, or \"COM1\" to \"COM4\" or \"AUX\" for serial printers, or
\"//hostname/printer\" for a shared network printer.  You can also set
it to the name of a file, in which case the output gets appended to that
file.  If you want to discard the printed output, set this to \"NUL\".")
(custom-autoload 'printer-name "lpr" t)
(defvar lpr-switches nil "\
List of strings to pass as extra options for the printer program.
It is recommended to set `printer-name' instead of including an explicit
switch on this list.
See `lpr-command'.")
(custom-autoload 'lpr-switches "lpr" t)
(defvar lpr-command (purecopy (cond (lpr-windows-system "") (lpr-lp-system "lp") (t "lpr"))) "\
Name of program for printing a file.

On MS-DOS and MS-Windows systems, if the value is an empty string then
Emacs will write directly to the printer port named by `printer-name'.
The programs `print' and `nprint' (the standard print programs on
Windows NT and Novell Netware respectively) are handled specially, using
`printer-name' as the destination for output; any other program is
treated like `lpr' except that an explicit filename is given as the last
argument.")
(custom-autoload 'lpr-command "lpr" t)
(autoload 'lpr-buffer "lpr" "\
Print buffer contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command." t)
(autoload 'print-buffer "lpr" "\
Paginate and print buffer contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.

See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command." t)
(autoload 'lpr-region "lpr" "\
Print region contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command.

(fn START END)" t)
(autoload 'print-region "lpr" "\
Paginate and print the region contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.

See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command.

(fn START END)" t)
(register-definition-prefixes "lpr" '("lpr-" "print"))


;;; Generated autoloads from leim/quail/lrt.el

(register-definition-prefixes "quail/lrt" '("quail-lrt-update-translation"))


;;; Generated autoloads from ls-lisp.el

(defvar ls-lisp-support-shell-wildcards t "\
Non-nil means ls-lisp treats file patterns as shell wildcards.
Otherwise they are treated as Emacs regexps (for backward compatibility).")
(custom-autoload 'ls-lisp-support-shell-wildcards "ls-lisp" t)
(register-definition-prefixes "ls-lisp" '("ls-lisp-"))


;;; Generated autoloads from progmodes/lua-ts-mode.el

(autoload 'lua-ts-inferior-lua "lua-ts-mode" "\
Run a Lua interpreter in an inferior process." t)
(autoload 'lua-ts-mode "lua-ts-mode" "\
Major mode for editing Lua files, powered by tree-sitter.

\\{lua-ts-mode-map}

(fn)" t)
(register-definition-prefixes "lua-ts-mode" '("lua-ts-"))


;;; Generated autoloads from calendar/lunar.el

(autoload 'lunar-phases "lunar" "\
Display the quarters of the moon for last month, this month, and next month.
If called with an optional prefix argument ARG, prompts for month and year.
This function is suitable for execution in an init file.

(fn &optional ARG)" t)
(register-definition-prefixes "lunar" '("calendar-lunar-phases" "diary-lunar-phases" "lunar-"))


;;; Generated autoloads from progmodes/m4-mode.el

(autoload 'm4-mode "m4-mode" "\
A major mode to edit m4 macro files.

(fn)" t)
(register-definition-prefixes "m4-mode" '("m4-"))


;;; Generated autoloads from macros.el

(defalias 'name-last-kbd-macro #'kmacro-name-last-macro)
(autoload 'insert-kbd-macro "macros" "\
Insert in buffer the definition of kbd macro MACRONAME, as Lisp code.
MACRONAME should be a symbol.
Optional second arg KEYS means also record the keys it is on
(this is the prefix argument, when calling interactively).

This Lisp code will, when executed, define the kbd macro with the same
definition it has now.  If you say to record the keys, the Lisp code
will also rebind those keys to the macro.  Only global key bindings
are recorded since executing this Lisp code always makes global
bindings.

To save a kbd macro, visit a file of Lisp code such as your `~/.emacs',
use this command, and then save the file.

(fn MACRONAME &optional KEYS)" t)
(autoload 'kbd-macro-query "macros" "\
Query user during kbd macro execution.

With prefix argument FLAG, enter recursive edit, reading
keyboard commands even within a kbd macro.  You can give
different commands each time the macro executes.

Without prefix argument, ask whether to continue running the
macro.

Your options are: \\<query-replace-map>

\\[act]	Finish this iteration normally and continue with the next.
\\[skip]	Skip the rest of this iteration, and start the next.
\\[exit]	Stop the macro entirely right now.
\\[recenter]	Redisplay the screen, then ask again.
\\[edit]	Enter recursive edit; ask again when you exit from that.

(fn FLAG)" t)
(autoload 'apply-macro-to-region-lines "macros" "\
Apply last keyboard macro to all lines in the region.
For each line that begins in the region, move to the beginning of
the line, and run the last keyboard macro.

When called from lisp, this function takes two arguments TOP and
BOTTOM, describing the current region.  TOP must be before BOTTOM.
The optional third argument MACRO specifies a keyboard macro to
execute.

This is useful for quoting or unquoting included text, adding and
removing comments, or producing tables where the entries are regular.

For example, in Usenet articles, sections of text quoted from another
author are indented, or have each line start with `>'.  To quote a
section of text, define a keyboard macro which inserts `>', put point
and mark at opposite ends of the quoted section, and use
\\[apply-macro-to-region-lines] to mark the entire section.

Suppose you wanted to build a keyword table in C where each entry
looked like this:

    { \"foo\", foo_data, foo_function },
    { \"bar\", bar_data, bar_function },
    { \"baz\", baz_data, baz_function },

You could enter the names in this format:

    foo
    bar
    baz

and write a macro to massage a word into a table entry:

    \\C-x (
       \\M-d { \"\\C-y\", \\C-y_data, \\C-y_function },
    \\C-x )

and then select the region of un-tablified names and use
\\[apply-macro-to-region-lines] to build the table from the names.

(fn TOP BOTTOM &optional MACRO)" t)
 (define-key ctl-x-map "q" 'kbd-macro-query)
(register-definition-prefixes "macros" '("macros--insert-vector-macro"))


;;; Generated autoloads from mail/mail-extr.el

(autoload 'mail-extract-address-components "mail-extr" "\
Extract full name and canonical address from ADDRESS.
ADDRESS should be in RFC 822 (or later) format.
Returns a list of the form (FULL-NAME CANONICAL-ADDRESS).  If no
name can be extracted, FULL-NAME will be nil.  Also see
`mail-extr-ignore-single-names' and
`mail-extr-ignore-realname-equals-mailbox-name'.

If the optional argument ALL is non-nil, then ADDRESS can contain zero
or more recipients, separated by commas, and we return a list of
the form ((FULL-NAME CANONICAL-ADDRESS) ...) with one element for
each recipient.  If ALL is nil, then if ADDRESS contains more than
one recipients, all but the first is ignored.

ADDRESS may be a string or a buffer.  If it is a buffer, the visible
(narrowed) portion of the buffer will be interpreted as the address.
(This feature exists so that the clever caller might be able to avoid
consing a string.)

This function is primarily meant for when you're displaying the
result to the user: Many prettifications are applied to the
result returned.  If you want to decode an address for further
non-display use, you should probably use
`mail-header-parse-address' instead.  Also see
`mail-header-parse-address-lax' for a function that's less strict
than `mail-header-parse-address', but does less post-processing
to the results.

(fn ADDRESS &optional ALL)")
(autoload 'what-domain "mail-extr" "\
Convert mail domain DOMAIN to the country it corresponds to.

(fn DOMAIN)" t)
(register-definition-prefixes "mail-extr" '("mail-extr-"))


;;; Generated autoloads from mail/mail-hist.el

(autoload 'mail-hist-define-keys "mail-hist" "\
Define keys for accessing mail header history.  For use in hooks.")
(autoload 'mail-hist-enable "mail-hist")
(defvar mail-hist-keep-history t "\
Non-nil means keep a history for headers and text of outgoing mail.")
(custom-autoload 'mail-hist-keep-history "mail-hist" t)
(autoload 'mail-hist-put-headers-into-history "mail-hist" "\
Put headers and contents of this message into mail header history.
Each header has its own independent history, as does the body of the
message.

This function normally would be called when the message is sent.")
(register-definition-prefixes "mail-hist" '("mail-hist-"))


;;; Generated autoloads from mail/mail-parse.el

(register-definition-prefixes "mail-parse" '("mail-"))


;;; Generated autoloads from mail/mail-prsvr.el

(register-definition-prefixes "mail-prsvr" '("mail-parse-"))


;;; Generated autoloads from gnus/mail-source.el

(register-definition-prefixes "mail-source" '("mail-source"))


;;; Generated autoloads from mail/mail-utils.el

(defvar mail-use-rfc822 nil "\
If non-nil, use a full, hairy RFC 822 (or later) parser on mail addresses.
Otherwise, (the default) use a smaller, somewhat faster, and
often correct parser.")
(custom-autoload 'mail-use-rfc822 "mail-utils" t)
(defvar mail-dont-reply-to-names nil "\
Regexp specifying addresses to prune from a reply message.
If this is nil, it is set the first time you compose a reply, to
a value which excludes your own email address.

Matching addresses are excluded from the Cc field in replies, and
also the To field, unless this would leave an empty To field.")
(custom-autoload 'mail-dont-reply-to-names "mail-utils" t)
(autoload 'mail-file-babyl-p "mail-utils" "\
Return non-nil if FILE is a Babyl file.

(fn FILE)")
(autoload 'mail-quote-printable "mail-utils" "\
Convert a string to the \"quoted printable\" Q encoding if necessary.
If the string contains only ASCII characters and no troublesome ones,
we return it unconverted.

If the optional argument WRAPPER is non-nil,
we add the wrapper characters =?ISO-8859-1?Q?....?=.

(fn STRING &optional WRAPPER)")
(autoload 'mail-quote-printable-region "mail-utils" "\
Convert the region to the \"quoted printable\" Q encoding.
If the optional argument WRAPPER is non-nil,
we add the wrapper characters =?ISO-8859-1?Q?....?=.

(fn BEG END &optional WRAPPER)" t)
(autoload 'mail-unquote-printable "mail-utils" "\
Undo the \"quoted printable\" encoding.
If the optional argument WRAPPER is non-nil,
we expect to find and remove the wrapper characters =?ISO-8859-1?Q?....?=.

(fn STRING &optional WRAPPER)")
(autoload 'mail-unquote-printable-region "mail-utils" "\
Undo the \"quoted printable\" encoding in buffer from BEG to END.
If the optional argument WRAPPER is non-nil,
we expect to find and remove the wrapper characters =?ISO-8859-1?Q?....?=.
On encountering malformed quoted-printable text, exits with an error,
unless NOERROR is non-nil, in which case it continues, and returns nil
when finished.  Returns non-nil on successful completion.
If UNIBYTE is non-nil, insert converted characters as unibyte.
That is useful if you are going to character code decoding afterward,
as Rmail does.

(fn BEG END &optional WRAPPER NOERROR UNIBYTE)" t)
(autoload 'mail-fetch-field "mail-utils" "\
Return the value of the header field whose type is FIELD-NAME.
If second arg LAST is non-nil, use the last field of type FIELD-NAME.
If third arg ALL is non-nil, concatenate all such fields with commas between.
If 4th arg LIST is non-nil, return a list of all such fields.
If 5th arg DELETE is non-nil, delete all header lines that are
included in the result.
The buffer should be narrowed to just the header, else false
matches may be returned from the message body.

(fn FIELD-NAME &optional LAST ALL LIST DELETE)")
(register-definition-prefixes "mail-utils" '("mail-"))


;;; Generated autoloads from mail/mailabbrev.el

(defvar mail-abbrevs-mode nil "\
Non-nil if Mail-Abbrevs mode is enabled.
See the `mail-abbrevs-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `mail-abbrevs-mode'.")
(custom-autoload 'mail-abbrevs-mode "mailabbrev" nil)
(autoload 'mail-abbrevs-mode "mailabbrev" "\
Toggle abbrev expansion of mail aliases (Mail Abbrevs mode).

Mail Abbrevs mode is a global minor mode.  When enabled,
abbrev-like expansion is performed when editing certain mail
headers (those specified by `mail-abbrev-mode-regexp'), based on
the entries in your `mail-personal-alias-file'.

This is a global minor mode.  If called interactively, toggle the
`Mail-Abbrevs mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='mail-abbrevs-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'mail-abbrevs-setup "mailabbrev" "\
Initialize use of the `mailabbrev' package.")
(autoload 'build-mail-abbrevs "mailabbrev" "\
Read mail aliases from personal mail alias file and set `mail-abbrevs'.
By default this is the file specified by `mail-personal-alias-file'.

(fn &optional FILE RECURSIVEP)")
(autoload 'define-mail-abbrev "mailabbrev" "\
Define NAME as a mail alias abbrev that translates to DEFINITION.
If DEFINITION contains multiple addresses, separate them with commas.

Optional argument FROM-MAILRC-FILE means that DEFINITION comes
from a mailrc file.  In that case, addresses are separated with
spaces and addresses with embedded spaces are surrounded by
double-quotes.

(fn NAME DEFINITION &optional FROM-MAILRC-FILE)" t)
(register-definition-prefixes "mailabbrev" '("mail-" "merge-mail-abbrevs" "rebuild-mail-abbrevs"))


;;; Generated autoloads from mail/mailalias.el

(defvar mail-complete-style 'angles "\
Specifies how \\[mail-complete] formats the full name when it completes.
If nil, they contain just the return address like:
	king@grassland.com
If `parens', they look like:
	king@grassland.com (Elvis Parsley)
If `angles', they look like:
	Elvis Parsley <king@grassland.com>")
(custom-autoload 'mail-complete-style "mailalias" t)
(autoload 'expand-mail-aliases "mailalias" "\
Expand all mail aliases in suitable header fields found between BEG and END.
If interactive, expand in header fields.
Suitable header fields are `To', `From', `Cc' and `Bcc', `Reply-To', and
their `Resent-' variants.

Optional second arg EXCLUDE may be a regular expression defining text to be
removed from alias expansions.

(fn BEG END &optional EXCLUDE)" t)
(autoload 'define-mail-alias "mailalias" "\
Define NAME as a mail alias that translates to DEFINITION.
This means that sending a message to NAME will actually send to DEFINITION.

Normally, the addresses in DEFINITION must be separated by commas.
If FROM-MAILRC-FILE is non-nil, then addresses in DEFINITION
can be separated by spaces; an address can contain spaces
if it is quoted with double-quotes.

(fn NAME DEFINITION &optional FROM-MAILRC-FILE)" t)
(autoload 'mail-completion-at-point-function "mailalias" "\
Compute completion data for mail aliases.
For use on `completion-at-point-functions'.")
(register-definition-prefixes "mailalias" '("build-mail-aliases" "mail-"))


;;; Generated autoloads from net/mailcap.el

(autoload 'mailcap-mime-type-to-extension "mailcap" "\
Return a file name extension based on a MIME-TYPE.
For instance, `image/png' will result in `png'.

(fn MIME-TYPE)")
(register-definition-prefixes "mailcap" '("mailcap-"))


;;; Generated autoloads from mail/mailclient.el

(autoload 'mailclient-send-it "mailclient" "\
Pass current buffer on to the system's mail client.
Suitable value for `send-mail-function'.
The mail client is taken to be the handler of mailto URLs.")
(register-definition-prefixes "mailclient" '("mailclient-"))


;;; Generated autoloads from mail/mailheader.el

(register-definition-prefixes "mailheader" '("mail-header"))


;;; Generated autoloads from net/mairix.el

(autoload 'mairix-search "mairix" "\
Call Mairix with SEARCH.
If THREADS is non-nil, also display whole threads of found
messages.  Results will be put into the default search file.

(fn SEARCH THREADS)" t)
(autoload 'mairix-use-saved-search "mairix" "\
Use a saved search for querying Mairix." t)
(autoload 'mairix-edit-saved-searches-customize "mairix" "\
Edit the list of saved searches in a customization buffer." t)
(autoload 'mairix-search-from-this-article "mairix" "\
Search messages from sender of the current article.
This is effectively a shortcut for calling `mairix-search' with
f:current_from.  If prefix THREADS is non-nil, include whole
threads.

(fn THREADS)" t)
(autoload 'mairix-search-thread-this-article "mairix" "\
Search thread for the current article.
This is effectively a shortcut for calling `mairix-search'
with m:msgid of the current article and enabled threads." t)
(autoload 'mairix-widget-search-based-on-article "mairix" "\
Create mairix query based on current article using widgets." t)
(autoload 'mairix-edit-saved-searches "mairix" "\
Edit current mairix searches." t)
(autoload 'mairix-widget-search "mairix" "\
Create mairix query interactively using graphical widgets.
MVALUES may contain values from current article.

(fn &optional MVALUES)" t)
(autoload 'mairix-update-database "mairix" "\
Call mairix for updating the database for SERVERS.
Mairix will be called asynchronously unless
`mairix-synchronous-update' is t.  Mairix will be called with
`mairix-update-options'." t)
(register-definition-prefixes "mairix" '("mairix-"))


;;; Generated autoloads from cedet/semantic/bovine/make.el

(register-definition-prefixes "semantic/bovine/make" '("semantic-"))


;;; Generated autoloads from cedet/ede/make.el

(register-definition-prefixes "ede/make" '("ede-"))


;;; Generated autoloads from progmodes/make-mode.el

(autoload 'makefile-mode "make-mode" "\
Major mode for editing standard Makefiles.

If you are editing a file for a different make, try one of the
variants `makefile-automake-mode', `makefile-gmake-mode',
`makefile-makepp-mode', `makefile-bsdmake-mode' or,
`makefile-imake-mode'.  All but the last should be correctly
chosen based on the file name, except if it is *.mk.  This
function ends by invoking the function(s) `makefile-mode-hook'.

It is strongly recommended to use `font-lock-mode', because that
provides additional parsing information.  This is used for
example to see that a rule action `echo foo: bar' is a not rule
dependency, despite the colon.

\\{makefile-mode-map}

Makefile mode can be configured by modifying the following variables:

`makefile-target-colon':
    The string that gets appended to all target names
    inserted by `makefile-insert-target'.
    \":\" or \"::\" are quite common values.

`makefile-macro-assign':
   The string that gets appended to all macro names
   inserted by `makefile-insert-macro'.
   The normal value should be \" = \", since this is what
   standard make expects.  However, newer makes such as dmake
   allow a larger variety of different macro assignments, so you
   might prefer to use \" += \" or \" := \" .

`makefile-tab-after-target-colon':
   If you want a TAB (instead of a space) to be appended after the
   target colon, then set this to a non-nil value.

`makefile-pickup-everything-picks-up-filenames-p':
   If this variable is set to a non-nil value then
   `makefile-pickup-everything' also picks up filenames as targets
   (i.e. it calls `makefile-pickup-filenames-as-targets'), otherwise
   filenames are omitted.

`makefile-cleanup-continuations':
   If this variable is set to a non-nil value then Makefile mode
   will assure that no line in the file ends with a backslash
   (the continuation character) followed by any whitespace.
   This is done by silently removing the trailing whitespace, leaving
   the backslash itself intact.
   IMPORTANT: Please note that enabling this option causes Makefile mode
   to MODIFY A FILE WITHOUT YOUR CONFIRMATION when \"it seems necessary\".

`makefile-special-targets-list':
   List of special targets.  You will be offered to complete
   on one of those in the minibuffer whenever you enter a `.'.
   at the beginning of a line in Makefile mode.

(fn)" t)
(autoload 'makefile-automake-mode "make-mode" "\
An adapted `makefile-mode' that knows about automake.

(fn)" t)
(autoload 'makefile-gmake-mode "make-mode" "\
An adapted `makefile-mode' that knows about gmake.

(fn)" t)
(autoload 'makefile-makepp-mode "make-mode" "\
An adapted `makefile-mode' that knows about makepp.

(fn)" t)
(autoload 'makefile-bsdmake-mode "make-mode" "\
An adapted `makefile-mode' that knows about BSD make.

(fn)" t)
(autoload 'makefile-imake-mode "make-mode" "\
An adapted `makefile-mode' that knows about imake.

(fn)" t)
(register-definition-prefixes "make-mode" '("makefile-"))


;;; Generated autoloads from cedet/ede/makefile-edit.el

(register-definition-prefixes "ede/makefile-edit" '("makefile-"))


;;; Generated autoloads from textmodes/makeinfo.el

(register-definition-prefixes "makeinfo" '("makeinfo-"))


;;; Generated autoloads from man.el

(defalias 'manual-entry 'man)
(autoload 'man "man" "\
Get a Un*x manual page and put it in a buffer.
This command is the top-level command in the man package.
It runs a Un*x command to retrieve and clean a manpage in the
background and places the results in a `Man-mode' browsing
buffer.  The variable `Man-width' defines the number of columns in
formatted manual pages.  The buffer is displayed immediately.
The variable `Man-notify-method' defines how the buffer is displayed.
If a buffer already exists for this man page, it will be displayed
without running the man command.

For a manpage from a particular section, use either of the
following.  \"cat(1)\" is how cross-references appear and is
passed to man as \"1 cat\".

    cat(1)
    1 cat

To see manpages from all sections related to a subject, use an
\"all pages\" option (which might be \"-a\" if it's not the
default), then step through with `Man-next-manpage' (\\<Man-mode-map>\\[Man-next-manpage]) etc.
Add to `Man-switches' to make this option permanent.

    -a chmod

An explicit filename can be given too.  Use -l if it might
otherwise look like a page name.

    /my/file/name.1.gz
    -l somefile.1

An \"apropos\" query with -k gives a buffer of matching page
names or descriptions.  The pattern argument is usually an
\"grep -E\" style regexp.

    -k pattern

Note that in some cases you will need to use \\[quoted-insert] to quote the
SPC character in the above examples, because this command attempts
to auto-complete your input based on the installed manual pages.

If `default-directory' is remote, and `Man-support-remote-systems'
is non-nil, this command formats the man page on the remote system.
A prefix argument reverses the value of `Man-support-remote-systems'
for the current invocation.

(fn MAN-ARGS)" t)
(autoload 'man-follow "man" "\
Get a Un*x manual page of the item under point and put it in a buffer.

(fn MAN-ARGS)" '(man-common))
(autoload 'Man-bookmark-jump "man" "\
Default bookmark handler for Man buffers.

(fn BOOKMARK)")
(autoload 'Man-context-menu "man" "\
Populate MENU with commands that open a man page at point.

(fn MENU CLICK)")
(register-definition-prefixes "man" '("Man-" "man"))


;;; Generated autoloads from emacs-lisp/map.el

(push (purecopy '(map 3 3 1)) package--builtin-versions)
(register-definition-prefixes "map" '("map-"))


;;; Generated autoloads from cedet/srecode/map.el

(register-definition-prefixes "srecode/map" '("srecode-"))


;;; Generated autoloads from master.el

(autoload 'master-mode "master" "\
Toggle Master mode.

When Master mode is enabled, you can scroll the slave buffer
using the following commands:

\\{master-mode-map}

The slave buffer is stored in the buffer-local variable `master-of'.
You can set this variable using `master-set-slave'.  You can show
yourself the value of `master-of' by calling `master-show-slave'.

This is a minor mode.  If called interactively, toggle the `Master mode'
mode.  If the prefix argument is positive, enable the mode, and if it is
zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `master-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "master" '("master-"))


;;; Generated autoloads from mb-depth.el

(defvar minibuffer-depth-indicate-mode nil "\
Non-nil if Minibuffer-Depth-Indicate mode is enabled.
See the `minibuffer-depth-indicate-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `minibuffer-depth-indicate-mode'.")
(custom-autoload 'minibuffer-depth-indicate-mode "mb-depth" nil)
(autoload 'minibuffer-depth-indicate-mode "mb-depth" "\
Toggle Minibuffer Depth Indication mode.

Minibuffer Depth Indication mode is a global minor mode.  When
enabled, any recursive use of the minibuffer will show the
recursion depth in the minibuffer prompt.  This is only useful if
`enable-recursive-minibuffers' is non-nil.

This is a global minor mode.  If called interactively, toggle the
`Minibuffer-Depth-Indicate mode' mode.  If the prefix argument is
positive, enable the mode, and if it is zero or negative, disable the
mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='minibuffer-depth-indicate-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "mb-depth" '("minibuffer-depth-"))


;;; Generated autoloads from md4.el

(register-definition-prefixes "md4" '("md4"))


;;; Generated autoloads from emacs-lisp/memory-report.el

(autoload 'memory-report "memory-report" "\
Generate a report of how Emacs is using memory.

This report is approximate, and will commonly over-count memory
usage by variables, because shared data structures will usually
by counted more than once." t)
(register-definition-prefixes "memory-report" '("memory-report-"))


;;; Generated autoloads from gnus/message.el

(define-mail-user-agent 'message-user-agent 'message-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)
(autoload 'message-mode "message" "\
Major mode for editing mail and news to be sent.
Like `text-mode', but with these additional commands:

\\{message-mode-map}

(fn)" t)
(autoload 'message-mail "message" "\
Start editing a mail message to be sent.
OTHER-HEADERS is an alist of header/value pairs.  CONTINUE says whether
to continue editing a message already being composed.  SWITCH-FUNCTION
is a function used to switch to and display the mail buffer.

(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-FUNCTION YANK-ACTION SEND-ACTIONS RETURN-ACTION &rest _)" t)
(autoload 'message-news "message" "\
Start editing a news article to be sent.

(fn &optional NEWSGROUPS SUBJECT)" t)
(autoload 'message-reply "message" "\
Start editing a reply to the article in the current buffer.

(fn &optional TO-ADDRESS WIDE SWITCH-FUNCTION)" t)
(autoload 'message-wide-reply "message" "\
Make a \"wide\" reply to the message in the current buffer.

(fn &optional TO-ADDRESS)" t)
(autoload 'message-followup "message" "\
Follow up to the message in the current buffer.
If TO-NEWSGROUPS, use that as the new Newsgroups line.

(fn &optional TO-NEWSGROUPS)" t)
(autoload 'message-cancel-news "message" "\
Cancel an article you posted.
If ARG, allow editing of the cancellation message.

(fn &optional ARG)" t)
(autoload 'message-supersede "message" "\
Start composing a message to supersede the current message.
This is done simply by taking the old article and adding a Supersedes
header line with the old Message-ID." t)
(autoload 'message-recover "message" "\
Reread contents of current buffer from its last auto-save file." t)
(autoload 'message-forward "message" "\
Forward the current message via mail.
Optional NEWS will use news to forward instead of mail.
Optional DIGEST will use digest to forward.

(fn &optional NEWS DIGEST)" t)
(autoload 'message-forward-make-body "message" "\


(fn FORWARD-BUFFER &optional DIGEST)")
(autoload 'message-forward-rmail-make-body "message" "\


(fn FORWARD-BUFFER)")
(autoload 'message-insinuate-rmail "message" "\
Let RMAIL use message to forward." t)
(autoload 'message-resend "message" "\
Resend the current article to ADDRESS.

(fn ADDRESS)" t)
(autoload 'message-bounce "message" "\
Re-mail the current message.
This only makes sense if the current message is a bounce message that
contains some mail you have written which has been bounced back to
you." t)
(autoload 'message-mail-other-window "message" "\
Like `message-mail' command, but display mail buffer in another window.

(fn &optional TO SUBJECT)" t)
(autoload 'message-mail-other-frame "message" "\
Like `message-mail' command, but display mail buffer in another frame.

(fn &optional TO SUBJECT)" t)
(autoload 'message-news-other-window "message" "\
Start editing a news article to be sent.

(fn &optional NEWSGROUPS SUBJECT)" t)
(autoload 'message-news-other-frame "message" "\
Start editing a news article to be sent.

(fn &optional NEWSGROUPS SUBJECT)" t)
(autoload 'message-bold-region "message" "\
Bold all nonblank characters in the region.
Works by overstriking characters.
Called from program, takes two arguments START and END
which specify the range to operate on.

(fn START END)" t)
(autoload 'message-unbold-region "message" "\
Remove all boldness (overstruck characters) in the region.
Called from program, takes two arguments START and END
which specify the range to operate on.

(fn START END)" t)
(autoload 'message-mailto "message" "\
Command to parse command line mailto: links.
This is meant to be used for MIME handlers: Setting the handler
for \"x-scheme-handler/mailto;\" to \"emacs -f message-mailto %u\"
will then start up Emacs ready to compose mail.  For emacsclient use
  emacsclient -e \\='(message-mailto \"%u\")'

To facilitate the use of this function within window systems that
provide message subject, body and attachments independent of URL
itself, the arguments SUBJECT, BODY and FILE-ATTACHMENTS may also
provide alternative message subject and body text, which is
inserted in lieu of nothing if URL does not incorporate such
information itself, and a list of files to insert as attachments
to the E-mail.

(fn &optional URL SUBJECT BODY FILE-ATTACHMENTS)" t)
(register-definition-prefixes "message" '("message-"))


;;; Generated autoloads from progmodes/meta-mode.el

(push (purecopy '(meta-mode 1 0)) package--builtin-versions)
(autoload 'metafont-mode "meta-mode" "\
Major mode for editing Metafont sources.

(fn)" t)
(autoload 'metapost-mode "meta-mode" "\
Major mode for editing MetaPost sources.

(fn)" t)
(register-definition-prefixes "meta-mode" '("meta"))


;;; Generated autoloads from mh-e/mh-acros.el

(register-definition-prefixes "mh-acros" '("mh-" "with-mh-folder-updating"))


;;; Generated autoloads from mh-e/mh-alias.el

(register-definition-prefixes "mh-alias" '("mh-"))


;;; Generated autoloads from mh-e/mh-buffers.el

(register-definition-prefixes "mh-buffers" '("mh-"))


;;; Generated autoloads from mh-e/mh-comp.el

(autoload 'mh-smail "mh-comp" "\
Compose a message with the MH mail system.
See `mh-send' for more details on composing mail." t)
(autoload 'mh-smail-other-window "mh-comp" "\
Compose a message with the MH mail system in other window.
See `mh-send' for more details on composing mail." t)
(autoload 'mh-smail-batch "mh-comp" "\
Compose a message with the MH mail system.

This function does not prompt the user for any header fields, and
thus is suitable for use by programs that want to create a mail
buffer. Users should use \\[mh-smail] to compose mail.

Optional arguments for setting certain fields include TO,
SUBJECT, and OTHER-HEADERS. Additional arguments are IGNORED.

This function remains for Emacs 21 compatibility. New
applications should use `mh-user-agent-compose'.

(fn &optional TO SUBJECT OTHER-HEADERS &rest IGNORED)")
(define-mail-user-agent 'mh-e-user-agent 'mh-user-agent-compose 'mh-send-letter 'mh-fully-kill-draft 'mh-before-send-letter-hook)
(autoload 'mh-user-agent-compose "mh-comp" "\
Set up mail composition draft with the MH mail system.
This is the `mail-user-agent' entry point to MH-E. This function
conforms to the contract specified by `define-mail-user-agent'
which means that this function should accept the same arguments
as `compose-mail'.

The optional arguments TO and SUBJECT specify recipients and the
initial Subject field, respectively.

OTHER-HEADERS is an alist specifying additional header fields.
Elements look like (HEADER . VALUE) where both HEADER and VALUE
are strings.

Any additional arguments are IGNORED.

(fn &optional TO SUBJECT OTHER-HEADERS &rest IGNORED)")
(autoload 'mh-send-letter "mh-comp" "\
Save draft and send message.

When you are all through editing a message, you send it with this
command. You can give a prefix argument ARG to monitor the first stage
of the delivery; this output can be found in a buffer called \"*MH-E
Mail Delivery*\".

The hook `mh-before-send-letter-hook' is run at the beginning of
this command. For example, if you want to check your spelling in
your message before sending, add the function `ispell-message'.

Unless `mh-insert-auto-fields' had previously been called
manually, the function `mh-insert-auto-fields' is called to
insert fields based upon the recipients. If fields are added, you
are given a chance to see and to confirm these fields before the
message is actually sent. You can do away with this confirmation
by turning off the option `mh-auto-fields-prompt-flag'.

In case the MH \"send\" program is installed under a different name,
use `mh-send-prog' to tell MH-E the name.

The hook `mh-annotate-msg-hook' is run after annotating the
message and scan line.

(fn &optional ARG)" t)
(autoload 'mh-fully-kill-draft "mh-comp" "\
Quit editing and delete draft message.

If for some reason you are not happy with the draft, you can use
this command to kill the draft buffer and delete the draft
message. Use the command \\[kill-buffer] if you don't want to
delete the draft message." t)
(register-definition-prefixes "mh-comp" '("mh-"))


;;; Generated autoloads from mh-e/mh-e.el

(push (purecopy '(mh-e 8 6 -4)) package--builtin-versions)
(put 'mh-progs 'risky-local-variable t)
(put 'mh-lib 'risky-local-variable t)
(put 'mh-lib-progs 'risky-local-variable t)
(autoload 'mh-version "mh-e" "\
Display version information about MH-E and the MH mail handling system." t)
(register-definition-prefixes "mh-e" '("defcustom-mh" "defface-mh" "defgroup-mh" "mh-"))


;;; Generated autoloads from mh-e/mh-folder.el

(autoload 'mh-rmail "mh-folder" "\
Incorporate new mail with MH.
Scan an MH folder if ARG is non-nil.

This function is an entry point to MH-E, the Emacs interface to
the MH mail system.

(fn &optional ARG)" t)
(autoload 'mh-nmail "mh-folder" "\
Check for new mail in inbox folder.
Scan an MH folder if ARG is non-nil.

This function is an entry point to MH-E, the Emacs interface to
the MH mail system.

(fn &optional ARG)" t)
(autoload 'mh-folder-mode "mh-folder" "\
Major MH-E mode for \"editing\" an MH folder scan listing.
\\<mh-folder-mode-map>
You can show the message the cursor is pointing to, and step through
the messages. Messages can be marked for deletion or refiling into
another folder; these commands are executed all at once with a
separate command.

Options that control this mode can be changed with
\\[customize-group]; specify the \"mh\" group. In particular, please
see the `mh-scan-format-file' option if you wish to modify scan's
format.

When a folder is visited, the hook `mh-folder-mode-hook' is run.

Ranges
======
Many commands that operate on individual messages, such as
`mh-forward' or `mh-refile-msg' take a RANGE argument. This argument
can be used in several ways.

If you provide the prefix argument (\\[universal-argument]) to
these commands, then you will be prompted for the message range.
This can be any valid MH range which can include messages,
sequences, and the abbreviations (described in the mh(1) man
page):

<num1>-<num2>
    Indicates all messages in the range <num1> to <num2>, inclusive.
    The range must be nonempty.

<num>:N
<num>:+N
<num>:-N
    Up to N messages beginning with (or ending with) message num. Num
    may be any of the predefined symbols: first, prev, cur, next or
    last.

first:N
prev:N
next:N
last:N
    The first, previous, next or last messages, if they exist.

all
    All of the messages.

For example, a range that shows all of these things is `1 2 3
5-10 last:5 unseen'.

If the option `transient-mark-mode' is set to t and you set a
region in the MH-Folder buffer, then the MH-E command will
perform the operation on all messages in that region.

\\{mh-folder-mode-map}

(fn)" t)
(register-definition-prefixes "mh-folder" '("mh-"))


;;; Generated autoloads from mh-e/mh-funcs.el

(register-definition-prefixes "mh-funcs" '("mh-"))


;;; Generated autoloads from mh-e/mh-identity.el

(register-definition-prefixes "mh-identity" '("mh-"))


;;; Generated autoloads from mh-e/mh-inc.el

(register-definition-prefixes "mh-inc" '("mh-inc-spool-"))


;;; Generated autoloads from mh-e/mh-junk.el

(register-definition-prefixes "mh-junk" '("mh-"))


;;; Generated autoloads from mh-e/mh-letter.el

(register-definition-prefixes "mh-letter" '("mh-"))


;;; Generated autoloads from mh-e/mh-limit.el

(register-definition-prefixes "mh-limit" '("mh-"))


;;; Generated autoloads from mh-e/mh-mime.el

(register-definition-prefixes "mh-mime" '("mh-"))


;;; Generated autoloads from mh-e/mh-print.el

(register-definition-prefixes "mh-print" '("mh-p"))


;;; Generated autoloads from mh-e/mh-scan.el

(register-definition-prefixes "mh-scan" '("mh-"))


;;; Generated autoloads from mh-e/mh-search.el

(register-definition-prefixes "mh-search" '("mh-"))


;;; Generated autoloads from mh-e/mh-seq.el

(register-definition-prefixes "mh-seq" '("mh-"))


;;; Generated autoloads from mh-e/mh-show.el

(register-definition-prefixes "mh-show" '("mh-"))


;;; Generated autoloads from mh-e/mh-speed.el

(register-definition-prefixes "mh-speed" '("mh-"))


;;; Generated autoloads from mh-e/mh-thread.el

(register-definition-prefixes "mh-thread" '("mh-"))


;;; Generated autoloads from mh-e/mh-tool-bar.el

(register-definition-prefixes "mh-tool-bar" '("mh-tool-bar-"))


;;; Generated autoloads from mh-e/mh-utils.el

(register-definition-prefixes "mh-utils" '("mh-"))


;;; Generated autoloads from mh-e/mh-xface.el

(register-definition-prefixes "mh-xface" '("mh-"))


;;; Generated autoloads from textmodes/mhtml-mode.el

(autoload 'mhtml-mode "mhtml-mode" "\
Major mode based on `html-mode', but works with embedded JS and CSS.

Code inside a <script> element is indented using the rules from
`js-mode'; and code inside a <style> element is indented using
the rules from `css-mode'.

(fn)" t)
(register-definition-prefixes "mhtml-mode" '("mhtml-"))


;;; Generated autoloads from midnight.el

(defvar midnight-mode nil "\
Non-nil if Midnight mode is enabled.
See the `midnight-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `midnight-mode'.")
(custom-autoload 'midnight-mode "midnight" nil)
(autoload 'midnight-mode "midnight" "\
Non-nil means run `midnight-hook' at midnight.

This is a global minor mode.  If called interactively, toggle the
`Midnight mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='midnight-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'clean-buffer-list "midnight" "\
Kill old buffers that have not been displayed recently.
The relevant variables are `clean-buffer-list-delay-general',
`clean-buffer-list-delay-special', `clean-buffer-list-kill-buffer-names',
`clean-buffer-list-kill-never-buffer-names',
`clean-buffer-list-kill-regexps' and
`clean-buffer-list-kill-never-regexps'.
While processing buffers, this procedure displays messages containing
the current date/time, buffer name, how many seconds ago it was
displayed (can be nil if the buffer was never displayed) and its
lifetime, i.e., its \"age\" when it will be purged." t)
(autoload 'midnight-delay-set "midnight" "\
Modify `midnight-timer' according to `midnight-delay'.
Sets the first argument SYMB (which must be symbol `midnight-delay')
to its second argument TM.

(fn SYMB TM)")
(register-definition-prefixes "midnight" '("clean-buffer-list-" "midnight-"))


;;; Generated autoloads from minibuf-eldef.el

(defvar minibuffer-electric-default-mode nil "\
Non-nil if Minibuffer-Electric-Default mode is enabled.
See the `minibuffer-electric-default-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `minibuffer-electric-default-mode'.")
(custom-autoload 'minibuffer-electric-default-mode "minibuf-eldef" nil)
(autoload 'minibuffer-electric-default-mode "minibuf-eldef" "\
Toggle Minibuffer Electric Default mode.

Minibuffer Electric Default mode is a global minor mode.  When
enabled, minibuffer prompts that show a default value only show
the default when it's applicable -- that is, when hitting RET
would yield the default value.  If the user modifies the input
such that hitting RET would enter a non-default value, the prompt
is modified to remove the default indication.

This is a global minor mode.  If called interactively, toggle the
`Minibuffer-Electric-Default mode' mode.  If the prefix argument is
positive, enable the mode, and if it is zero or negative, disable the
mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='minibuffer-electric-default-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "minibuf-eldef" '("minibuf"))


;;; Generated autoloads from misc.el

(autoload 'copy-from-above-command "misc" "\
Copy characters from previous nonblank line, starting just above point.
Copy ARG characters, but not past the end of that line.
If no argument given, copy the entire rest of the line.
The characters copied are inserted in the buffer before point.

Also see the `duplicate-line' command.

(fn &optional ARG)" t)
(autoload 'duplicate-line "misc" "\
Duplicate the current line N times.
Interactively, N is the prefix numeric argument, and defaults to 1.
The user option `duplicate-line-final-position' specifies where to
move point after duplicating the line.
Also see the `copy-from-above-command' command.

(fn &optional N)" t)
(autoload 'duplicate-dwim "misc" "\
Duplicate the current line or region N times.
If the region is inactive, duplicate the current line (like `duplicate-line').
Otherwise, duplicate the region, which remains active afterwards.
If the region is rectangular, duplicate on its right-hand side.
Interactively, N is the prefix numeric argument, and defaults to 1.
The variables `duplicate-line-final-position' and
`duplicate-region-final-position' control the position of point
and the region after the duplication.

(fn &optional N)" t)
(autoload 'zap-up-to-char "misc" "\
Kill up to, but not including ARGth occurrence of CHAR.
When run interactively, the argument INTERACTIVE is non-nil.
Case is ignored if `case-fold-search' is non-nil in the current buffer.
Goes backward if ARG is negative; error if CHAR not found.
Ignores CHAR at point.
If called interactively, do a case sensitive search if CHAR
is an upper-case character.

(fn ARG CHAR &optional INTERACTIVE)" t)
(autoload 'mark-beginning-of-buffer "misc" "\
Set mark at the beginning of the buffer." t)
(autoload 'mark-end-of-buffer "misc" "\
Set mark at the end of the buffer." t)
(autoload 'upcase-char "misc" "\
Uppercasify ARG chars starting from point.  Point doesn't move.

(fn ARG)" t)
(autoload 'forward-to-word "misc" "\
Move forward until encountering the beginning of the ARGth word.
ARG defaults to 1.  When called interactively, ARG is the prefix
numeric argument.

(fn &optional ARG)" t)
(autoload 'backward-to-word "misc" "\
Move backward until encountering the end of the ARGth word.
ARG defaults to 1.  When called interactively, ARG is the prefix
numeric argument.

(fn &optional ARG)" t)
(autoload 'butterfly "misc" "\
Use butterflies to flip the desired bit on the drive platter.
Open hands and let the delicate wings flap once.  The disturbance
ripples outward, changing the flow of the eddy currents in the
upper atmosphere.  These cause momentary pockets of higher-pressure
air to form, which act as lenses that deflect incoming cosmic rays,
focusing them to strike the drive platter and flip the desired bit.
You can type \\`M-x butterfly C-M-c' to run it.  This is a permuted
variation of `C-x M-c M-butterfly' from url `https://xkcd.com/378/'." t)
(autoload 'list-dynamic-libraries "misc" "\
Display a list of all dynamic libraries known to Emacs.
(These are the libraries listed in `dynamic-library-alist'.)
If optional argument LOADED-ONLY-P (interactively, prefix arg)
is non-nil, only libraries already loaded are listed.
Optional argument BUFFER specifies a buffer to use, instead of
\"*Dynamic Libraries*\".
The return value is always nil.

(fn &optional LOADED-ONLY-P BUFFER)" t)
(register-definition-prefixes "misc" '("duplicate-" "list-dynamic-libraries--"))


;;; Generated autoloads from misearch.el

 (add-hook 'isearch-mode-hook 'multi-isearch-setup)
(defvar multi-isearch-next-buffer-function nil "\
Function to call to get the next buffer to search.

When this variable is set to a function that returns a buffer, then
after typing another \\[isearch-forward] or \\[isearch-backward] at a failing search, the search goes
to the next buffer in the series and continues searching for the
next occurrence.

This function should return the next buffer (it doesn't need to switch
to it), or nil if it can't find the next buffer (when it reaches the
end of the search space).

The first argument of this function is the current buffer where the
search is currently searching.  It defines the base buffer relative to
which this function should find the next buffer.  When the isearch
direction is backward (when option `isearch-forward' is nil), this function
should return the previous buffer to search.

If the second argument of this function WRAP is non-nil, then it
should return the first buffer in the series; and for the backward
search, it should return the last buffer in the series.")
(defvar multi-isearch-next-buffer-current-function nil "\
The currently active function to get the next buffer to search.
Initialized from `multi-isearch-next-buffer-function' when
Isearch starts.")
(defvar multi-isearch-current-buffer nil "\
The buffer where the search is currently searching.
The value is nil when the search still is in the initial buffer.")
(defvar multi-isearch-buffer-list nil "\
Sequence of buffers visited by multiple buffers Isearch.
This is nil if Isearch is not currently searching more than one buffer.")
(defvar multi-isearch-file-list nil "\
Sequence of files visited by multiple file buffers Isearch.")
(autoload 'multi-isearch-setup "misearch" "\
Set up isearch to search multiple buffers.
Intended to be added to `isearch-mode-hook'.")
(autoload 'multi-isearch-switch-buffer "misearch" "\
Switch to the next buffer in multi-buffer search.")
(autoload 'multi-isearch-buffers "misearch" "\
Start multi-buffer Isearch on a list of BUFFERS.
This list can contain live buffers or their names.
Interactively read buffer names to search, one by one, ended with RET.
With a prefix argument, ask for a regexp, and search in buffers
whose names match the specified regexp.

(fn BUFFERS)" t)
(autoload 'multi-isearch-buffers-regexp "misearch" "\
Start multi-buffer regexp Isearch on a list of BUFFERS.
This list can contain live buffers or their names.
Interactively read buffer names to search, one by one, ended with RET.
With a prefix argument, ask for a regexp, and search in buffers
whose names match the specified regexp.

(fn BUFFERS)" t)
(autoload 'multi-isearch-files "misearch" "\
Start multi-buffer Isearch on a list of FILES.
Relative file names in this list are expanded to absolute
file names using the current buffer's value of `default-directory'.
Interactively read file names to search, one by one, ended with RET.
With a prefix argument, ask for a wildcard, and search in file buffers
whose file names match the specified wildcard.

(fn FILES)" t)
(autoload 'multi-isearch-files-regexp "misearch" "\
Start multi-buffer regexp Isearch on a list of FILES.
Relative file names in this list are expanded to absolute
file names using the current buffer's value of `default-directory'.
Interactively read file names to search, one by one, ended with RET.
With a prefix argument, ask for a wildcard, and search in file buffers
whose file names match the specified wildcard.

(fn FILES)" t)
(autoload 'multi-file-replace-regexp-as-diff "misearch" "\
Show as diffs replacements of REGEXP with TO-STRING in FILES.
DELIMITED has the same meaning as in `replace-regexp'.
The replacements are displayed in the buffer *replace-diff* that
you can later apply as a patch after reviewing the changes.

(fn FILES REGEXP TO-STRING &optional DELIMITED)" t)
(autoload 'replace-regexp-as-diff "misearch" "\
Show as diffs replacements of REGEXP with TO-STRING in the current buffer.
DELIMITED has the same meaning as in `replace-regexp'.
The replacements are displayed in the buffer *replace-diff* that
you can later apply as a patch after reviewing the changes.

(fn REGEXP TO-STRING &optional DELIMITED)" t)
(register-definition-prefixes "misearch" '("misearch-unload-function" "multi-"))


;;; Generated autoloads from progmodes/mixal-mode.el

(push (purecopy '(mixal-mode 0 4)) package--builtin-versions)
(autoload 'mixal-mode "mixal-mode" "\
Major mode for the mixal asm language.

(fn)" t)
(register-definition-prefixes "mixal-mode" '("mixal-"))


;;; Generated autoloads from gnus/mm-archive.el

(register-definition-prefixes "mm-archive" '("mm-"))


;;; Generated autoloads from gnus/mm-bodies.el

(register-definition-prefixes "mm-bodies" '("mm-"))


;;; Generated autoloads from gnus/mm-decode.el

(register-definition-prefixes "mm-decode" '("mm-"))


;;; Generated autoloads from gnus/mm-encode.el

(define-obsolete-function-alias 'mm-default-file-encoding #'mm-default-file-type "28.1")
(autoload 'mm-default-file-type "mm-encode" "\
Return a default content type for FILE.

(fn FILE)")
(register-definition-prefixes "mm-encode" '("mm-"))


;;; Generated autoloads from gnus/mm-extern.el

(autoload 'mm-extern-cache-contents "mm-extern" "\
Put the external-body part of HANDLE into its cache.

(fn HANDLE)")
(autoload 'mm-inline-external-body "mm-extern" "\
Show the external-body part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it.  Otherwise, do nothing after replacing.

(fn HANDLE &optional NO-DISPLAY)")
(register-definition-prefixes "mm-extern" '("mm-extern-"))


;;; Generated autoloads from gnus/mm-partial.el

(autoload 'mm-inline-partial "mm-partial" "\
Show the partial part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it.  Otherwise, do nothing after replacing.

(fn HANDLE &optional NO-DISPLAY)")
(register-definition-prefixes "mm-partial" '("mm-partial-find-parts"))


;;; Generated autoloads from gnus/mm-url.el

(autoload 'mm-url-insert-file-contents "mm-url" "\
Insert file contents of URL.
If `mm-url-use-external' is non-nil, use `mm-url-program'.

(fn URL)")
(autoload 'mm-url-insert-file-contents-external "mm-url" "\
Insert file contents of URL using `mm-url-program'.

(fn URL)")
(register-definition-prefixes "mm-url" '("mm-url-"))


;;; Generated autoloads from gnus/mm-util.el

(register-definition-prefixes "mm-util" '("mm-"))


;;; Generated autoloads from gnus/mm-uu.el

(autoload 'mm-uu-dissect "mm-uu" "\
Dissect the current buffer and return a list of uu handles.
The optional NOHEADER means there's no header in the buffer.
MIME-TYPE specifies a MIME type and parameters, which defaults to the
value of `mm-uu-text-plain-type'.

(fn &optional NOHEADER MIME-TYPE)")
(autoload 'mm-uu-dissect-text-parts "mm-uu" "\
Dissect text parts and put uu handles into HANDLE.
Assume text has been decoded if DECODED is non-nil.

(fn HANDLE &optional DECODED)")
(register-definition-prefixes "mm-uu" '("mm-"))


;;; Generated autoloads from gnus/mm-view.el

(register-definition-prefixes "mm-view" '("mm-"))


;;; Generated autoloads from gnus/mml.el

(autoload 'mml-to-mime "mml" "\
Translate the current buffer from MML to MIME.")
(autoload 'mml-attach-file "mml" "\
Attach a file to the outgoing MIME message.
The file is not inserted or encoded until you send the message with
`\\[message-send-and-exit]' or `\\[message-send]' in Message mode,
or `\\[mail-send-and-exit]' or `\\[mail-send]' in Mail mode.

FILE is the name of the file to attach.  TYPE is its
content-type, a string of the form \"type/subtype\".  DESCRIPTION
is a one-line description of the attachment.  The DISPOSITION
specifies how the attachment is intended to be displayed.  It can
be either \"inline\" (displayed automatically within the message
body) or \"attachment\" (separate from the body).

Also see the `mml-attach-file-at-the-end' variable.

If given a prefix interactively, no prompting will be done for
the TYPE, DESCRIPTION or DISPOSITION values.  Instead defaults
will be computed and used.

(fn FILE &optional TYPE DESCRIPTION DISPOSITION)" t)
(register-definition-prefixes "mml" '("mime-to-mml" "mml-"))


;;; Generated autoloads from gnus/mml-sec.el

(register-definition-prefixes "mml-sec" '("mml-"))


;;; Generated autoloads from gnus/mml-smime.el

(register-definition-prefixes "mml-smime" '("mml-smime-"))


;;; Generated autoloads from gnus/mml1991.el

(autoload 'mml1991-encrypt "mml1991" "\


(fn CONT &optional SIGN)")
(autoload 'mml1991-sign "mml1991" "\


(fn CONT)")
(register-definition-prefixes "mml1991" '("mml1991-"))


;;; Generated autoloads from gnus/mml2015.el

(autoload 'mml2015-decrypt "mml2015" "\


(fn HANDLE CTL)")
(autoload 'mml2015-decrypt-test "mml2015" "\


(fn HANDLE CTL)")
(autoload 'mml2015-verify "mml2015" "\


(fn HANDLE CTL)")
(autoload 'mml2015-verify-test "mml2015" "\


(fn HANDLE CTL)")
(autoload 'mml2015-encrypt "mml2015" "\


(fn CONT &optional SIGN)")
(autoload 'mml2015-sign "mml2015" "\


(fn CONT)")
(autoload 'mml2015-self-encrypt "mml2015")
(register-definition-prefixes "mml2015" '("mml2015-"))


;;; Generated autoloads from cedet/srecode/mode.el

(register-definition-prefixes "srecode/mode" '("srecode-"))


;;; Generated autoloads from cedet/semantic/decorate/mode.el

(register-definition-prefixes "semantic/decorate/mode" '("define-semantic-decoration-style" "semantic-"))


;;; Generated autoloads from cedet/mode-local.el

(put 'define-overloadable-function 'doc-string-elt 3)
(register-definition-prefixes "mode-local" '("def" "describe-mode-local-bindings" "fetch-overload" "get-mode-local-parent" "make-obsolete-overload" "mode-local-" "setq-mode-local" "with-mode-local" "xref-mode-local-"))


;;; Generated autoloads from progmodes/modula2.el

(defalias 'modula-2-mode 'm2-mode)
(autoload 'm2-mode "modula2" "\
This is a mode intended to support program development in Modula-2.
All control constructs of Modula-2 can be reached by typing C-c
followed by the first character of the construct.
\\<m2-mode-map>
  \\[m2-begin] begin         \\[m2-case] case
  \\[m2-definition] definition    \\[m2-else] else
  \\[m2-for] for           \\[m2-header] header
  \\[m2-if] if            \\[m2-module] module
  \\[m2-loop] loop          \\[m2-or] or
  \\[m2-procedure] procedure     Control-c Control-w with
  \\[m2-record] record        \\[m2-stdio] stdio
  \\[m2-type] type          \\[m2-until] until
  \\[m2-var] var           \\[m2-while] while
  \\[m2-export] export        \\[m2-import] import
  \\[m2-begin-comment] begin-comment \\[m2-end-comment] end-comment
  \\[suspend-emacs] suspend Emacs     \\[m2-toggle] toggle
  \\[m2-compile] compile           \\[m2-next-error] next-error
  \\[m2-link] link

   `m2-indent' controls the number of spaces for each indentation.
   `m2-compile-command' holds the command to compile a Modula-2 program.
   `m2-link-command' holds the command to link a Modula-2 program.

(fn)" t)
(register-definition-prefixes "modula2" '("m2-" "m3-font-lock-keywords"))


;;; Generated autoloads from play/morse.el

(autoload 'morse-region "morse" "\
Convert plain text in region to Morse code.
See <https://en.wikipedia.org/wiki/Morse_code>.

(fn BEG END)" t)
(autoload 'unmorse-region "morse" "\
Convert Morse coded text in region to plain text.

(fn BEG END)" t)
(autoload 'nato-region "morse" "\
Convert plain text in region to NATO spelling alphabet.

(fn BEG END)" t)
(autoload 'denato-region "morse" "\
Convert NATO spelling alphabet text in region to plain text.

(fn BEG END)" t)
(register-definition-prefixes "morse" '("morse-code" "nato-alphabet"))


;;; Generated autoloads from mouse-copy.el

(register-definition-prefixes "mouse-copy" '("mouse-"))


;;; Generated autoloads from mouse-drag.el

(autoload 'mouse-drag-throw "mouse-drag" "\
\"Throw\" the page according to a mouse drag.

A \"throw\" is scrolling the page at a speed relative to the distance
from the original mouse click to the current mouse location.  Try it;
you'll like it.  It's easier to observe than to explain.

If the mouse is clicked and released in the same place of time we
assume that the user didn't want to scroll but wanted to whatever
mouse-2 used to do, so we pass it through.

Throw scrolling was inspired (but is not identical to) the \"hand\"
option in MacPaint, or the middle button in Tk text widgets.

If `mouse-throw-with-scroll-bar' is non-nil, then this command scrolls
in the opposite direction.  (Different people have different ideas
about which direction is natural.  Perhaps it has to do with which
hemisphere you're in.)

To test this function, evaluate:
    (global-set-key [down-mouse-2] \\='mouse-drag-throw)

(fn START-EVENT)" t)
(autoload 'mouse-drag-drag "mouse-drag" "\
\"Drag\" the page according to a mouse drag.

Drag scrolling moves the page according to the movement of the mouse.
You \"grab\" the character under the mouse and move it around.

If the mouse is clicked and released in the same place of time we
assume that the user didn't want to scroll but wanted to whatever
mouse-2 used to do, so we pass it through.

Drag scrolling is identical to the \"hand\" option in MacPaint, or the
middle button in Tk text widgets.

To test this function, evaluate:
    (global-set-key [down-mouse-2] \\='mouse-drag-drag)

(fn START-EVENT)" t)
(register-definition-prefixes "mouse-drag" '("mouse-"))


;;; Generated autoloads from mpc.el

(autoload 'mpc "mpc" "\
Main entry point for MPC." t)
(register-definition-prefixes "mpc" '("mpc-"))


;;; Generated autoloads from play/mpuz.el

(autoload 'mpuz "mpuz" "\
Multiplication puzzle with GNU Emacs." t)
(register-definition-prefixes "mpuz" '("mpuz-"))


;;; Generated autoloads from cedet/semantic/mru-bookmark.el

(register-definition-prefixes "semantic/mru-bookmark" '("global-semantic-mru-bookmark-mode" "semantic-"))


;;; Generated autoloads from msb.el

(defvar msb-mode nil "\
Non-nil if Msb mode is enabled.
See the `msb-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `msb-mode'.")
(custom-autoload 'msb-mode "msb" nil)
(autoload 'msb-mode "msb" "\
Toggle Msb mode.

This mode overrides the binding(s) of `mouse-buffer-menu' to provide a
different buffer menu using the function `msb'.

This is a global minor mode.  If called interactively, toggle the `Msb
mode' mode.  If the prefix argument is positive, enable the mode, and if
it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='msb-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "msb" '("mouse-select-buffer" "msb"))


;;; Generated autoloads from mail/mspools.el

(autoload 'mspools-show "mspools" "\
Show the list of non-empty spool files in the *spools* buffer.
Buffer is not displayed if SHOW is non-nil.

(fn &optional NOSHOW)" t)
(register-definition-prefixes "mspools" '("mspools-"))


;;; Generated autoloads from international/mule-diag.el

(autoload 'list-character-sets "mule-diag" "\
Display a list of all character sets.

The D column contains the dimension of this character set.  The CH
column contains the number of characters in a block of this character
set.  The FINAL-BYTE column contains an ISO-2022 <final-byte> to use
in the designation escape sequence for this character set in
ISO-2022-based coding systems.

With prefix ARG, the output format gets more cryptic,
but still shows the full information.

(fn ARG)" t)
(autoload 'read-charset "mule-diag" "\
Read a character set from the minibuffer, prompting with string PROMPT.
It must be an Emacs character set listed in the variable `charset-list'.

Optional arguments are DEFAULT-VALUE and INITIAL-INPUT.
DEFAULT-VALUE, if non-nil, is the default value.
INITIAL-INPUT, if non-nil, is a string inserted in the minibuffer initially.
See the documentation of the function `completing-read' for the detailed
meanings of these arguments.

(fn PROMPT &optional DEFAULT-VALUE INITIAL-INPUT)")
(autoload 'list-charset-chars "mule-diag" "\
Display a list of characters in character set CHARSET.

(fn CHARSET)" t)
(autoload 'describe-character-set "mule-diag" "\
Display information about built-in character set CHARSET.

(fn CHARSET)" t)
(autoload 'describe-coding-system "mule-diag" "\
Display information about CODING-SYSTEM.

(fn CODING-SYSTEM)" t)
(autoload 'describe-current-coding-system-briefly "mule-diag" "\
Display coding systems currently used in a brief format in echo area.

The format is \"F[..],K[..],T[..],P>[..],P<[..], default F[..],P<[..],P<[..]\",
where mnemonics of the following coding systems come in this order
in place of `..':
  `buffer-file-coding-system' (of the current buffer)
  eol-type of `buffer-file-coding-system' (of the current buffer)
  Value returned by `keyboard-coding-system'
  eol-type of `keyboard-coding-system'
  Value returned by `terminal-coding-system'.
  eol-type of `terminal-coding-system'
  `process-coding-system' for read (of the current buffer, if any)
  eol-type of `process-coding-system' for read (of the current buffer, if any)
  `process-coding-system' for write (of the current buffer, if any)
  eol-type of `process-coding-system' for write (of the current buffer, if any)
  default `buffer-file-coding-system'
  eol-type of default `buffer-file-coding-system'
  `default-process-coding-system' for read
  eol-type of `default-process-coding-system' for read
  `default-process-coding-system' for write
  eol-type of `default-process-coding-system'" t)
(autoload 'describe-current-coding-system "mule-diag" "\
Display coding systems currently used, in detail." t)
(autoload 'list-coding-systems "mule-diag" "\
Display a list of all coding systems.
This shows the mnemonic letter, name, and description of each coding system.

With prefix ARG, the output format gets more cryptic,
but still contains full information about each coding system.

(fn &optional ARG)" t)
(autoload 'list-coding-categories "mule-diag" "\
Display a list of all coding categories.")
(autoload 'describe-font "mule-diag" "\
Display information about a font whose name is FONTNAME.

(fn FONTNAME)" t)
(autoload 'describe-fontset "mule-diag" "\
Display information about FONTSET.
This shows which font is used for which character(s).

(fn FONTSET)" t)
(autoload 'list-fontsets "mule-diag" "\
Display a list of all fontsets.
This shows the name, size, and style of each fontset.
With prefix arg, also list the fonts contained in each fontset;
see the function `describe-fontset' for the format of the list.

(fn ARG)" t)
(autoload 'list-input-methods "mule-diag" "\
Display information about all input methods." t)
(autoload 'mule-diag "mule-diag" "\
Display diagnosis of the multilingual environment (Mule).

This shows various information related to the current multilingual
environment, including lists of input methods, coding systems,
character sets, and fontsets (if Emacs is running under a window
system which uses fontsets)." t)
(autoload 'font-show-log "mule-diag" "\
Show log of font listing and opening.
Prefix arg LIMIT says how many fonts to show for each listing.
The default is 20.  If LIMIT is negative, do not limit the listing.

(fn &optional LIMIT)" t)
(register-definition-prefixes "mule-diag" '("charset-history" "describe-font-internal" "insert-section" "list-" "mule--kbd-at" "print-" "sort-listed-character-sets"))


;;; Generated autoloads from international/mule-util.el

(autoload 'store-substring "mule-util" "\
Embed OBJ (string or character) at index IDX of STRING.

(fn STRING IDX OBJ)")
(autoload 'truncate-string-to-width "mule-util" "\
Truncate string STR to end at column END-COLUMN.
The optional 3rd arg START-COLUMN, if non-nil, specifies the starting
column (default: zero); that means to return the characters occupying
columns START-COLUMN ... END-COLUMN of STR.  Both END-COLUMN and
START-COLUMN are specified in terms of character display width in the
current buffer; see `char-width'.

Since character composition on display can produce glyphs whose
width is smaller than the sum of `char-width' values of the
composed characters, this function can produce inaccurate results
when used in such cases.

The optional 4th arg PADDING, if non-nil, specifies a padding
character (which should have a display width of 1) to add at the end
of the result if STR doesn't reach column END-COLUMN, or if END-COLUMN
comes in the middle of a character in STR.  PADDING is also added at
the beginning of the result if column START-COLUMN appears in the
middle of a character in STR.

If PADDING is nil, no padding is added in these cases, so
the resulting string may be narrower than END-COLUMN.

If ELLIPSIS is non-nil, it should be a string which will replace the
end of STR (including any padding) if it extends beyond END-COLUMN,
unless the display width of STR is equal to or less than the display
width of ELLIPSIS.  If it is non-nil and not a string, then ELLIPSIS
defaults to `truncate-string-ellipsis', or to three dots when it's nil.

If ELLIPSIS-TEXT-PROPERTY is non-nil, a too-long string will not
be truncated, but instead the elided parts will be covered by a
`display' text property showing the ellipsis.

(fn STR END-COLUMN &optional START-COLUMN PADDING ELLIPSIS ELLIPSIS-TEXT-PROPERTY)")
(defsubst nested-alist-p (obj) "\
Return t if OBJ is a nested alist.

Nested alist is a list of the form (ENTRY . BRANCHES), where ENTRY is
any Lisp object, and BRANCHES is a list of cons cells of the form
(KEY-ELEMENT . NESTED-ALIST).

You can use a nested alist to store any Lisp object (ENTRY) for a key
sequence KEYSEQ, where KEYSEQ is a sequence of KEY-ELEMENT.  KEYSEQ
can be a string, a vector, or a list." (and obj (listp obj) (listp (cdr obj))))
(autoload 'set-nested-alist "mule-util" "\
Set ENTRY for KEYSEQ in a nested alist ALIST.
Optional 4th arg LEN non-nil means the first LEN elements in KEYSEQ
 are considered.
Optional 5th argument BRANCHES if non-nil is branches for a keyseq
longer than KEYSEQ.
See the documentation of `nested-alist-p' for more detail.

(fn KEYSEQ ENTRY ALIST &optional LEN BRANCHES)")
(autoload 'lookup-nested-alist "mule-util" "\
Look up key sequence KEYSEQ in nested alist ALIST.  Return the definition.
Optional 3rd argument LEN specifies the length of KEYSEQ.
Optional 4th argument START specifies index of the starting key.
The returned value is normally a nested alist of which
car part is the entry for KEYSEQ.
If ALIST is not deep enough for KEYSEQ, return number which is
 how many key elements at the front of KEYSEQ it takes
 to reach a leaf in ALIST.
Optional 5th argument NIL-FOR-TOO-LONG non-nil means return nil
 even if ALIST is not deep enough.

(fn KEYSEQ ALIST &optional LEN START NIL-FOR-TOO-LONG)")
(autoload 'coding-system-post-read-conversion "mule-util" "\
Return the value of CODING-SYSTEM's `post-read-conversion' property.

(fn CODING-SYSTEM)")
(autoload 'coding-system-pre-write-conversion "mule-util" "\
Return the value of CODING-SYSTEM's `pre-write-conversion' property.

(fn CODING-SYSTEM)")
(autoload 'coding-system-translation-table-for-decode "mule-util" "\
Return the value of CODING-SYSTEM's `decode-translation-table' property.

(fn CODING-SYSTEM)")
(autoload 'coding-system-translation-table-for-encode "mule-util" "\
Return the value of CODING-SYSTEM's `encode-translation-table' property.

(fn CODING-SYSTEM)")
(autoload 'with-coding-priority "mule-util" "\
Execute BODY like `progn' with CODING-SYSTEMS at the front of priority list.
CODING-SYSTEMS is a list of coding systems.  See `set-coding-system-priority'.
This affects the implicit sorting of lists of coding systems returned by
operations such as `find-coding-systems-region'.

(fn CODING-SYSTEMS &rest BODY)" nil t)
(function-put 'with-coding-priority 'lisp-indent-function 1)
(autoload 'detect-coding-with-language-environment "mule-util" "\
Detect a coding system for the text between FROM and TO with LANG-ENV.
The detection takes into account the coding system priorities for the
language environment LANG-ENV.

(fn FROM TO LANG-ENV)")
(autoload 'filepos-to-bufferpos "mule-util" "\
Try to return the buffer position corresponding to a particular file position.
The file position is given as a (0-based) BYTE count.
The function presumes the file is encoded with CODING-SYSTEM, which defaults
to `buffer-file-coding-system'.
QUALITY can be:
  `approximate', in which case we may cut some corners to avoid
    excessive work.
  `exact', in which case we may end up re-(en/de)coding a large
    part of the file/buffer, this can be expensive and slow.  (It
    is an error to request the `exact' method when the buffer's
    EOL format is not yet decided.)
  nil, in which case we may return nil rather than an approximation.

(fn BYTE &optional QUALITY CODING-SYSTEM)")
(autoload 'bufferpos-to-filepos "mule-util" "\
Try to return the file byte corresponding to a particular buffer POSITION.
Value is the file position given as a (0-based) byte count.
The function presumes the file is encoded with CODING-SYSTEM, which defaults
to `buffer-file-coding-system'.
QUALITY can be:
  `approximate', in which case we may cut some corners to avoid
    excessive work.
  `exact', in which case we may end up re-(en/de)coding a large
    part of the file/buffer, this can be expensive and slow.  (It
    is an error to request the `exact' method when the buffer's
    EOL format is not yet decided.)
  nil, in which case we may return nil rather than an approximation.

(fn POSITION &optional QUALITY CODING-SYSTEM)")
(register-definition-prefixes "mule-util" '("filepos-to-bufferpos--dos" "truncate-string-ellipsis"))


;;; Generated autoloads from emacs-lisp/multisession.el

(autoload 'define-multisession-variable "multisession" "\
Make NAME into a multisession variable initialized from INITIAL-VALUE.
DOC should be a doc string, and ARGS are keywords as applicable to
`make-multisession'.

(fn NAME INITIAL-VALUE &optional DOC &rest ARGS)" nil t)
(function-put 'define-multisession-variable 'lisp-indent-function 'defun)
(autoload 'list-multisession-values "multisession" "\
List all values in the \"multisession\" database.
If CHOOSE-STORAGE (interactively, the prefix), query for the
storage method to list.

(fn &optional CHOOSE-STORAGE)" t)
(register-definition-prefixes "multisession" '("multisession-"))


;;; Generated autoloads from mwheel.el

(defvar mouse-wheel-mode t "\
Non-nil if Mouse-Wheel mode is enabled.
See the `mouse-wheel-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `mouse-wheel-mode'.")
(custom-autoload 'mouse-wheel-mode "mwheel" nil)
(autoload 'mouse-wheel-mode "mwheel" "\
Toggle mouse wheel support (Mouse Wheel mode).

This is a global minor mode.  If called interactively, toggle the
`Mouse-Wheel mode' mode.  If the prefix argument is positive, enable the
mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='mouse-wheel-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "mwheel" '("mouse-wheel-" "mwheel-"))


;;; Generated autoloads from emacs-lisp/nadvice.el

(push (purecopy '(nadvice 1 0)) package--builtin-versions)


;;; Generated autoloads from net/net-utils.el

(autoload 'ifconfig "net-utils" "\
Run `ifconfig-program' and display diagnostic output." t)
(autoload 'iwconfig "net-utils" "\
Run `iwconfig-program' and display diagnostic output." t)
(autoload 'netstat "net-utils" "\
Run `netstat-program' and display diagnostic output." t)
(autoload 'arp "net-utils" "\
Run `arp-program' and display diagnostic output." t)
(autoload 'route "net-utils" "\
Run `route-program' and display diagnostic output." t)
(autoload 'traceroute "net-utils" "\
Run `traceroute-program' for TARGET.

(fn TARGET)" t)
(autoload 'ping "net-utils" "\
Ping HOST using `ping-program'.

The user option `ping-program-options' is passed as flags to
`ping-program'.  With a \\[universal-argument] prefix arg, prompt the
user for the flags to pass.

When called from Lisp, the optional argument FLAGS, if non-nil, is a
list of strings that will be passed as flags for the `ping-program'.  If
FLAGS is nil, `ping-program-options' will be used.

If your system's ping continues until interrupted, you can try using a
prefix argument or setting `ping-program-options'.

(fn HOST &optional FLAGS)" t)
(autoload 'nslookup-host "net-utils" "\
Look up the DNS information for HOST (name or IP address).
Optional argument NAME-SERVER says which server to use for
DNS resolution.
Interactively, prompt for NAME-SERVER if invoked with prefix argument.

This command uses `nslookup-program' for looking up the DNS information.

See also: `nslookup-host-ipv4', `nslookup-host-ipv6' for
non-interactive versions of this function more suitable for use
in Lisp code.

(fn HOST &optional NAME-SERVER)" t)
(autoload 'nslookup-host-ipv4 "net-utils" "\
Return the IPv4 address for HOST (name or IP address).
Optional argument NAME-SERVER says which server to use for DNS
resolution.

If FORMAT is `string', returns the IP address as a
string (default).  If FORMAT is `vector', returns a 4-integer
vector of octets.

This command uses `nslookup-program' to look up DNS records.

(fn HOST &optional NAME-SERVER FORMAT)")
(autoload 'nslookup-host-ipv6 "net-utils" "\
Return the IPv6 address for HOST (name or IP address).
Optional argument NAME-SERVER says which server to use for DNS
resolution.

If FORMAT is `string', returns the IP address as a
string (default).  If FORMAT is `vector', returns a 8-integer
vector of hextets.

This command uses `nslookup-program' to look up DNS records.

(fn HOST &optional NAME-SERVER FORMAT)")
(autoload 'nslookup "net-utils" "\
Run `nslookup-program'." t)
(autoload 'dns-lookup-host "net-utils" "\
Look up the DNS information for HOST (name or IP address).
Optional argument NAME-SERVER says which server to use for
DNS resolution.
Interactively, prompt for NAME-SERVER if invoked with prefix argument.

This command uses `dns-lookup-program' for looking up the DNS information.

(fn HOST &optional NAME-SERVER)" t)
(autoload 'run-dig "net-utils" "\
Look up DNS information for HOST (name or IP address).
Optional argument NAME-SERVER says which server to use for
DNS resolution.
Interactively, prompt for NAME-SERVER if invoked with prefix argument.

This command uses `dig-program' for looking up the DNS information.

(fn HOST &optional NAME-SERVER)" t)
(make-obsolete 'run-dig 'dig "29.1")
(autoload 'ftp "net-utils" "\
Run `ftp-program' to connect to HOST.

(fn HOST)" t)
(autoload 'finger "net-utils" "\
Finger USER on HOST.
This command uses `finger-X.500-host-regexps'
and `network-connection-service-alist', which see.

(fn USER HOST)" t)
(autoload 'whois "net-utils" "\
Send SEARCH-STRING to server defined by the `whois-server-name' variable.
If `whois-guess-server' is non-nil, then try to deduce the correct server
from SEARCH-STRING.  With argument, prompt for whois server.
The port is deduced from `network-connection-service-alist'.

(fn ARG SEARCH-STRING)" t)
(autoload 'whois-reverse-lookup "net-utils" nil t)
(autoload 'network-connection-to-service "net-utils" "\
Open a network connection to SERVICE on HOST.
This command uses `network-connection-service-alist', which see.

(fn HOST SERVICE)" t)
(autoload 'network-connection "net-utils" "\
Open a network connection to HOST on PORT.

(fn HOST PORT)" t)
(register-definition-prefixes "net-utils" '("arp-program" "dns-lookup-program" "finger-X.500-host-regexps" "ftp-" "ifconfig-program" "ipconfig" "iwconfig-program" "net" "nslookup-" "ping-program" "route-program" "run-network-program" "smbclient" "traceroute-program" "whois-"))


;;; Generated autoloads from net/network-stream.el

(autoload 'open-network-stream "network-stream" "\
Open a TCP connection to HOST, optionally with encryption.
Normally, return a network process object; with a non-nil
:return-list parameter, return a list instead (see below).
Input and output work as for subprocesses; `delete-process'
closes it.

NAME is the name for the process.  It is modified if necessary to
 make it unique.
BUFFER is a buffer or buffer name to associate with the process.
 Process output goes at end of that buffer.  BUFFER may be nil,
 meaning that the process is not associated with any buffer.
HOST is the name or IP address of the host to connect to.
SERVICE is the name of the service desired, or an integer or
 integer string specifying a port number to connect to.

The remaining PARAMETERS should be a sequence of keywords and
values:

:type specifies the connection type, one of the following:
  nil or `network'
             -- Begin with an ordinary network connection, and if
                the parameters :success and :capability-command
                are also supplied, try to upgrade to an encrypted
                connection via STARTTLS.  Even if that
                fails (e.g. if HOST does not support TLS), retain
                an unencrypted connection.
  `plain'    -- An ordinary, unencrypted network connection.
  `starttls' -- Begin with an ordinary connection, and try
                upgrading via STARTTLS.  If that fails for any
                reason, drop the connection; in that case the
                returned object is a killed process.
  `tls'      -- A TLS connection.
  `ssl'      -- Equivalent to `tls'.
  `shell'    -- A shell connection.

:coding is a symbol or a cons used to specify the coding systems
used to decode and encode the data which the process reads and
writes.  See `make-network-process' for details.

:return-list specifies this function's return value.
  If omitted or nil, return a process object.  A non-nil means to
  return (PROC . PROPS), where PROC is a process object and PROPS
  is a plist of connection properties, with these keywords:
   :greeting -- the greeting returned by HOST (a string), or nil.
   :capabilities -- a string representing HOST's capabilities,
                    or nil if none could be found.
   :type -- the resulting connection type; `plain' (unencrypted)
            or `tls' (TLS-encrypted).

:end-of-command specifies a regexp matching the end of a command.

:end-of-capability specifies a regexp matching the end of the
  response to the command specified for :capability-command.
  It defaults to the regexp specified for :end-of-command.

:success specifies a regexp matching a message indicating a
  successful STARTTLS negotiation.  For instance, the default
  should be \"^3\" for an NNTP connection.

:capability-command specifies a command used to query the HOST
  for its capabilities.  For instance, for IMAP this should be
  \"1 CAPABILITY\\r\\n\".  This can either be a string (which will
  then be sent verbatim to the server), or a function (called with
  a single parameter; the \"greeting\" from the server when connecting),
  and should return a string to send to the server.

:starttls-function specifies a function for handling STARTTLS.
  This function should take one parameter, the response to the
  capability command, and should return the command to switch on
  STARTTLS if the server supports STARTTLS, and nil otherwise.

:always-query-capabilities says whether to query the server for
  capabilities, even if we're doing a `plain' network connection.

:client-certificate should either be a list where the first
  element is the certificate key file name, and the second
  element is the certificate file name itself, or t, which means
  that `auth-source' will be queried for the key and the
  certificate.  This parameter will only be used when doing TLS
  or STARTTLS connections.  To enable automatic queries of
  `auth-source' when `:client-certificate' is not specified
  customize `network-stream-use-client-certificates' to t.

:use-starttls-if-possible is a boolean that says to do opportunistic
STARTTLS upgrades even if Emacs doesn't have built-in TLS functionality.

:warn-unless-encrypted is a boolean which, if :return-list is
non-nil, is used warn the user if the connection isn't encrypted.

:nogreeting is a boolean that can be used to inhibit waiting for
a greeting from the server.

:nowait, if non-nil, says the connection should be made
asynchronously, if possible.

:noquery - when exiting Emacs and the network process is running,
don't query the user if it's non-nil.

:shell-command is a `format-spec' string that can be used if
:type is `shell'.  It has two specs, %s for host and %p for port
number.  Example: \"ssh gateway nc %s %p\".

:tls-parameters is a list that should be supplied if you're
opening a TLS connection.  The first element is the TLS
type (either `gnutls-x509pki' or `gnutls-anon'), and the
remaining elements should be a keyword list accepted by
gnutls-boot (as returned by `gnutls-boot-parameters').

(fn NAME BUFFER HOST SERVICE &rest PARAMETERS)")
(define-obsolete-function-alias 'open-protocol-stream #'open-network-stream "26.1")
(register-definition-prefixes "network-stream" '("network-stream-"))


;;; Generated autoloads from net/newst-backend.el

(autoload 'newsticker-running-p "newst-backend" "\
Check whether newsticker is running.
Return t if newsticker is running, nil otherwise.  Newsticker is
considered to be running if the newsticker timer list is not empty.")
(autoload 'newsticker-start "newst-backend" "\
Start the newsticker.
Start the timers for display and retrieval.  If the newsticker, i.e. the
timers, are running already a warning message is printed unless
DO-NOT-COMPLAIN-IF-RUNNING is not nil.
Run `newsticker-start-hook' if newsticker was not running already.

(fn &optional DO-NOT-COMPLAIN-IF-RUNNING)" t)
(register-definition-prefixes "newst-backend" '("newsticker-"))


;;; Generated autoloads from net/newst-plainview.el

(autoload 'newsticker-plainview "newst-plainview" "\
Start newsticker plainview." t)
(register-definition-prefixes "newst-plainview" '("newsticker-"))


;;; Generated autoloads from net/newst-reader.el

(autoload 'newsticker-show-news "newst-reader" "\
Start reading news.  You may want to bind this to a key." t)
(register-definition-prefixes "newst-reader" '("newsticker-"))


;;; Generated autoloads from net/newst-ticker.el

(autoload 'newsticker-ticker-running-p "newst-ticker" "\
Check whether newsticker's actual ticker is running.
Return t if ticker is running, nil otherwise.  Newsticker is
considered to be running if the newsticker timer list is not
empty.")
(autoload 'newsticker-start-ticker "newst-ticker" "\
Start newsticker's ticker (but not the news retrieval).
Start display timer for the actual ticker if wanted and not
running already." t)
(register-definition-prefixes "newst-ticker" '("newsticker-"))


;;; Generated autoloads from net/newst-treeview.el

(autoload 'newsticker-treeview "newst-treeview" "\
Start newsticker treeview." t)
(register-definition-prefixes "newst-treeview" '("newsticker-"))


;;; Generated autoloads from net/newsticker.el

(register-definition-prefixes "newsticker" '("newsticker-version"))


;;; Generated autoloads from gnus/nnagent.el

(register-definition-prefixes "nnagent" '("nnagent-"))


;;; Generated autoloads from gnus/nnatom.el

(register-definition-prefixes "nnatom" '("nnatom-"))


;;; Generated autoloads from gnus/nnbabyl.el

(register-definition-prefixes "nnbabyl" '("nnbabyl-"))


;;; Generated autoloads from gnus/nndiary.el

(autoload 'nndiary-generate-nov-databases "nndiary" "\
Generate NOV databases in all nndiary directories.

(fn &optional SERVER)" t)
(register-definition-prefixes "nndiary" '("nndiary-"))


;;; Generated autoloads from gnus/nndir.el

(register-definition-prefixes "nndir" '("nndir-"))


;;; Generated autoloads from gnus/nndoc.el

(autoload 'nndoc-add-type "nndoc" "\
Add document DEFINITION to the list of nndoc document definitions.
If POSITION is nil or `last', the definition will be added
as the last checked definition, if t or `first', add as the
first definition, and if any other symbol, add after that
symbol in the alist.

(fn DEFINITION &optional POSITION)")
(register-definition-prefixes "nndoc" '("nndoc-"))


;;; Generated autoloads from gnus/nndraft.el

(register-definition-prefixes "nndraft" '("nndraft-"))


;;; Generated autoloads from gnus/nneething.el

(register-definition-prefixes "nneething" '("nneething-"))


;;; Generated autoloads from gnus/nnfeed.el

(register-definition-prefixes "nnfeed" '("nnfeed-"))


;;; Generated autoloads from gnus/nnfolder.el

(autoload 'nnfolder-generate-active-file "nnfolder" "\
Look for mbox folders in the nnfolder directory and make them into groups.
This command does not work if you use short group names." t)
(register-definition-prefixes "nnfolder" '("nnfolder-"))


;;; Generated autoloads from gnus/nngateway.el

(register-definition-prefixes "nngateway" '("nngateway-"))


;;; Generated autoloads from gnus/nnheader.el

(register-definition-prefixes "nnheader" '("gnus-" "mail-header-" "make-mail-header" "nnheader-" "nntp-"))


;;; Generated autoloads from gnus/nnimap.el

(register-definition-prefixes "nnimap" '("nnimap-"))


;;; Generated autoloads from gnus/nnmail.el

(register-definition-prefixes "nnmail" '("nnmail-"))


;;; Generated autoloads from gnus/nnmaildir.el

(register-definition-prefixes "nnmaildir" '("nnmaildir-"))


;;; Generated autoloads from gnus/nnmairix.el

(register-definition-prefixes "nnmairix" '("nnmairix-"))


;;; Generated autoloads from gnus/nnmbox.el

(register-definition-prefixes "nnmbox" '("nnmbox-"))


;;; Generated autoloads from gnus/nnmh.el

(register-definition-prefixes "nnmh" '("nnmh-"))


;;; Generated autoloads from gnus/nnml.el

(autoload 'nnml-generate-nov-databases "nnml" "\
Generate NOV databases in all nnml directories.

(fn &optional SERVER)" t)
(register-definition-prefixes "nnml" '("nnml-"))


;;; Generated autoloads from gnus/nnnil.el

(register-definition-prefixes "nnnil" '("nnnil-"))


;;; Generated autoloads from gnus/nnoo.el

(register-definition-prefixes "nnoo" '("deffoo" "defvoo" "nnoo-" "noo--defalias"))


;;; Generated autoloads from gnus/nnregistry.el

(register-definition-prefixes "nnregistry" '("nnregistry-"))


;;; Generated autoloads from gnus/nnrss.el

(register-definition-prefixes "nnrss" '("nnrss-"))


;;; Generated autoloads from gnus/nnselect.el

(register-definition-prefixes "nnselect" '("gnus-" "ids-by-group" "nnselect-" "numbers-by-group"))


;;; Generated autoloads from gnus/nnspool.el

(register-definition-prefixes "nnspool" '("news-inews-program" "nnspool-"))


;;; Generated autoloads from gnus/nntp.el

(register-definition-prefixes "nntp" '("nntp-"))


;;; Generated autoloads from gnus/nnvirtual.el

(register-definition-prefixes "nnvirtual" '("nnvirtual-"))


;;; Generated autoloads from gnus/nnweb.el

(register-definition-prefixes "nnweb" '("nnweb-"))


;;; Generated autoloads from notifications.el

(register-definition-prefixes "notifications" '("notifications-"))


;;; Generated autoloads from novice.el

(defvar disabled-command-function 'disabled-command-function "\
Function to call to handle disabled commands.
If nil, the feature is disabled, i.e., all commands work normally.")
(autoload 'disabled-command-function "novice" "\


(fn &optional CMD KEYS)")
(autoload 'enable-command "novice" "\
Allow COMMAND to be executed without special confirmation from now on.
COMMAND must be a symbol.
This command alters the user's .emacs file so that this will apply
to future sessions.

(fn COMMAND)" t)
(autoload 'disable-command "novice" "\
Require special confirmation to execute COMMAND from now on.
COMMAND must be a symbol.
This command alters your init file so that this choice applies to
future sessions.

(fn COMMAND)" t)
(register-definition-prefixes "novice" '("en/disable-command"))


;;; Generated autoloads from textmodes/nroff-mode.el

(autoload 'nroff-mode "nroff-mode" "\
Major mode for editing text intended for nroff to format.
\\{nroff-mode-map}
Turning on Nroff mode runs `text-mode-hook', then `nroff-mode-hook'.
Also, try `nroff-electric-mode', for automatically inserting
closing requests for requests that are used in matched pairs.

(fn)" t)
(register-definition-prefixes "nroff-mode" '("nroff-"))


;;; Generated autoloads from net/nsm.el

(register-definition-prefixes "nsm" '("network-security-" "nsm-"))


;;; Generated autoloads from net/ntlm.el

(push (purecopy '(ntlm 2 1 0)) package--builtin-versions)
(register-definition-prefixes "ntlm" '("ntlm-"))


;;; Generated autoloads from nxml/nxml-enc.el

(register-definition-prefixes "nxml-enc" '("nxml-"))


;;; Generated autoloads from nxml/nxml-maint.el

(register-definition-prefixes "nxml-maint" '("nxml-insert-target-repertoire-glyph-set"))


;;; Generated autoloads from nxml/nxml-mode.el

(autoload 'nxml-mode "nxml-mode" "\
Major mode for editing XML.
\\<nxml-mode-map>
\\[nxml-finish-element] finishes the current element by inserting an end-tag.

C-c C-i closes a start-tag with `>' and then inserts a balancing end-tag
leaving point between the start-tag and end-tag.
\\[nxml-balanced-close-start-tag-block] is similar but for block rather than inline elements:
the start-tag, point, and end-tag are all left on separate lines.
If `nxml-slash-auto-complete-flag' is non-nil, then inserting a `</'
automatically inserts the rest of the end-tag.

\\[completion-at-point] performs completion on the symbol preceding point.

\\[nxml-dynamic-markup-word] uses the contents of the current buffer
to choose a tag to put around the word preceding point.

Sections of the document can be displayed in outline form.  The
variable `nxml-section-element-name-regexp' controls when an element
is recognized as a section.  The same key sequences that change
visibility in outline mode are used except that they start with C-c C-o
instead of C-c.

Validation is provided by the related minor-mode `rng-validate-mode'.
This also makes completion schema- and context- sensitive.  Element
names, attribute names, attribute values and namespace URIs can all be
completed. By default, `rng-validate-mode' is automatically enabled.
You can toggle it using \\[rng-validate-mode] or change the default by
customizing `rng-nxml-auto-validate-flag'.

\\[indent-for-tab-command] indents the current line appropriately.
This can be customized using the variable `nxml-child-indent'
and the variable `nxml-attribute-indent'.

\\[nxml-insert-named-char] inserts a character reference using
the character's name (by default, the Unicode name).
\\[universal-argument] \\[nxml-insert-named-char] inserts the character directly.

The Emacs commands that normally operate on balanced expressions will
operate on XML markup items.  Thus \\[forward-sexp] will move forward
across one markup item; \\[backward-sexp] will move backward across
one markup item; \\[kill-sexp] will kill the following markup item;
\\[mark-sexp] will mark the following markup item.  By default, the
complete element is treated as a single markup item; to make each tag be
treated as a separate markup item, set the variable `nxml-sexp-element-flag'
to nil.  For more details, see the function `nxml-forward-balanced-item'.

\\[nxml-backward-up-element] and \\[nxml-down-element] move up and down the element structure.

Many aspects this mode can be customized using
\\[customize-group] nxml RET.

(fn)" t)
(defalias 'xml-mode 'nxml-mode)
(register-definition-prefixes "nxml-mode" '("nxml-"))


;;; Generated autoloads from nxml/nxml-ns.el

(register-definition-prefixes "nxml-ns" '("nxml-ns-"))


;;; Generated autoloads from nxml/nxml-outln.el

(register-definition-prefixes "nxml-outln" '("nxml-"))


;;; Generated autoloads from nxml/nxml-parse.el

(register-definition-prefixes "nxml-parse" '("nxml-"))


;;; Generated autoloads from nxml/nxml-rap.el

(register-definition-prefixes "nxml-rap" '("nxml-"))


;;; Generated autoloads from nxml/nxml-util.el

(register-definition-prefixes "nxml-util" '("nxml-"))


;;; Generated autoloads from org/ob-C.el

(register-definition-prefixes "ob-C" '("org-babel-"))


;;; Generated autoloads from org/ob-R.el

(register-definition-prefixes "ob-R" '("ob-" "org-babel-"))


;;; Generated autoloads from org/ob-awk.el

(register-definition-prefixes "ob-awk" '("org-babel-"))


;;; Generated autoloads from org/ob-calc.el

(register-definition-prefixes "ob-calc" '("org-babel-"))


;;; Generated autoloads from org/ob-clojure.el

(register-definition-prefixes "ob-clojure" '("ob-clojure-" "org-babel-"))


;;; Generated autoloads from org/ob-comint.el

(register-definition-prefixes "ob-comint" '("org-babel-comint-"))


;;; Generated autoloads from org/ob-core.el

(register-definition-prefixes "ob-core" '("org-"))


;;; Generated autoloads from org/ob-css.el

(register-definition-prefixes "ob-css" '("org-babel-"))


;;; Generated autoloads from org/ob-ditaa.el

(register-definition-prefixes "ob-ditaa" '("org-"))


;;; Generated autoloads from org/ob-dot.el

(register-definition-prefixes "ob-dot" '("org-babel-"))


;;; Generated autoloads from org/ob-emacs-lisp.el

(register-definition-prefixes "ob-emacs-lisp" '("org-babel-"))


;;; Generated autoloads from org/ob-eshell.el

(register-definition-prefixes "ob-eshell" '("ob-eshell-session-live-p" "org-babel-"))


;;; Generated autoloads from org/ob-eval.el

(register-definition-prefixes "ob-eval" '("org-babel-"))


;;; Generated autoloads from org/ob-exp.el

(register-definition-prefixes "ob-exp" '("org-"))


;;; Generated autoloads from org/ob-forth.el

(register-definition-prefixes "ob-forth" '("org-babel-"))


;;; Generated autoloads from org/ob-fortran.el

(register-definition-prefixes "ob-fortran" '("org-babel-"))


;;; Generated autoloads from org/ob-gnuplot.el

(register-definition-prefixes "ob-gnuplot" '("*org-babel-gnuplot-" "org-babel-"))


;;; Generated autoloads from org/ob-groovy.el

(register-definition-prefixes "ob-groovy" '("org-babel-"))


;;; Generated autoloads from org/ob-haskell.el

(register-definition-prefixes "ob-haskell" '("org-babel-"))


;;; Generated autoloads from org/ob-java.el

(register-definition-prefixes "ob-java" '("org-babel-"))


;;; Generated autoloads from org/ob-js.el

(register-definition-prefixes "ob-js" '("org-babel-"))


;;; Generated autoloads from org/ob-julia.el

(register-definition-prefixes "ob-julia" '("org-babel-"))


;;; Generated autoloads from org/ob-latex.el

(register-definition-prefixes "ob-latex" '("org-babel-"))


;;; Generated autoloads from org/ob-lilypond.el

(register-definition-prefixes "ob-lilypond" '("ob-lilypond-header-args" "org-babel-"))


;;; Generated autoloads from org/ob-lisp.el

(register-definition-prefixes "ob-lisp" '("org-babel-"))


;;; Generated autoloads from org/ob-lob.el

(register-definition-prefixes "ob-lob" '("org-babel-"))


;;; Generated autoloads from org/ob-lua.el

(register-definition-prefixes "ob-lua" '("org-babel-"))


;;; Generated autoloads from org/ob-makefile.el

(register-definition-prefixes "ob-makefile" '("org-babel-"))


;;; Generated autoloads from org/ob-maxima.el

(register-definition-prefixes "ob-maxima" '("org-babel-"))


;;; Generated autoloads from org/ob-ocaml.el

(register-definition-prefixes "ob-ocaml" '("org-babel-"))


;;; Generated autoloads from org/ob-octave.el

(register-definition-prefixes "ob-octave" '("org-babel-"))


;;; Generated autoloads from org/ob-org.el

(register-definition-prefixes "ob-org" '("org-babel-"))


;;; Generated autoloads from org/ob-perl.el

(register-definition-prefixes "ob-perl" '("org-babel-"))


;;; Generated autoloads from org/ob-plantuml.el

(register-definition-prefixes "ob-plantuml" '("org-"))


;;; Generated autoloads from org/ob-processing.el

(register-definition-prefixes "ob-processing" '("org-babel-"))


;;; Generated autoloads from org/ob-python.el

(register-definition-prefixes "ob-python" '("org-babel-"))


;;; Generated autoloads from org/ob-ref.el

(register-definition-prefixes "ob-ref" '("org-babel-"))


;;; Generated autoloads from org/ob-ruby.el

(register-definition-prefixes "ob-ruby" '("org-babel-"))


;;; Generated autoloads from org/ob-sass.el

(register-definition-prefixes "ob-sass" '("org-babel-"))


;;; Generated autoloads from org/ob-scheme.el

(register-definition-prefixes "ob-scheme" '("org-babel-"))


;;; Generated autoloads from org/ob-screen.el

(register-definition-prefixes "ob-screen" '("org-babel-"))


;;; Generated autoloads from org/ob-sed.el

(register-definition-prefixes "ob-sed" '("org-babel-"))


;;; Generated autoloads from org/ob-shell.el

(register-definition-prefixes "ob-shell" '("ob-shell-async-" "org-babel-"))


;;; Generated autoloads from org/ob-sql.el

(register-definition-prefixes "ob-sql" '("org-babel-"))


;;; Generated autoloads from org/ob-sqlite.el

(register-definition-prefixes "ob-sqlite" '("org-babel-"))


;;; Generated autoloads from org/ob-table.el

(register-definition-prefixes "ob-table" '("org-"))


;;; Generated autoloads from org/ob-tangle.el

(register-definition-prefixes "ob-tangle" '("org-babel-"))


;;; Generated autoloads from org/oc.el

(autoload 'org-cite-insert "oc" "\
Insert a citation at point.
Insertion is done according to the processor set in `org-cite-insert-processor'.
ARG is the prefix argument received when calling interactively the function.

(fn ARG)" t)
(register-definition-prefixes "oc" '("org-cite-"))


;;; Generated autoloads from org/oc-basic.el

(register-definition-prefixes "oc-basic" '("org-cite-basic-"))


;;; Generated autoloads from org/oc-biblatex.el

(register-definition-prefixes "oc-biblatex" '("org-cite-biblatex-"))


;;; Generated autoloads from org/oc-bibtex.el

(register-definition-prefixes "oc-bibtex" '("org-cite-bibtex-export-"))


;;; Generated autoloads from org/oc-csl.el

(register-definition-prefixes "oc-csl" '("org-cite-csl-"))


;;; Generated autoloads from org/oc-natbib.el

(register-definition-prefixes "oc-natbib" '("org-cite-natbib-"))


;;; Generated autoloads from progmodes/octave.el

 (add-to-list 'auto-mode-alist '("\\.m\\'" . octave-maybe-mode))
(autoload 'octave-maybe-mode "octave" "\
Select `octave-mode' if the current buffer seems to hold Octave code.")
(autoload 'octave-mode "octave" "\
Major mode for editing Octave code.

Octave is a high-level language, primarily intended for numerical
computations.  It provides a convenient command line interface
for solving linear and nonlinear problems numerically.  Function
definitions can also be stored in files and used in batch mode.

See Info node `(octave-mode) Using Octave Mode' for more details.

Key bindings:
\\{octave-mode-map}

(fn)" t)
(autoload 'inferior-octave "octave" "\
Run an inferior Octave process, I/O via `inferior-octave-buffer'.
This buffer is put in Inferior Octave mode.  See `inferior-octave-mode'.

Unless ARG is non-nil, switches to this buffer.

The elements of the list `inferior-octave-startup-args' are sent as
command line arguments to the inferior Octave process on startup.

Additional commands to be executed on startup can be provided either in
the file specified by `inferior-octave-startup-file' or by the default
startup file, `~/.emacs-octave'.

(fn &optional ARG)" t)
(defalias 'run-octave 'inferior-octave)
(register-definition-prefixes "octave" '("inferior-octave-" "octave-"))


;;; Generated autoloads from international/ogonek.el

(register-definition-prefixes "ogonek" '("ogonek-"))


;;; Generated autoloads from org/ol.el

(register-definition-prefixes "ol" '("org-"))


;;; Generated autoloads from org/ol-bbdb.el

(register-definition-prefixes "ol-bbdb" '("org-bbdb-"))


;;; Generated autoloads from org/ol-bibtex.el

(register-definition-prefixes "ol-bibtex" '("org-"))


;;; Generated autoloads from org/ol-docview.el

(register-definition-prefixes "ol-docview" '("org-docview-"))


;;; Generated autoloads from org/ol-doi.el

(register-definition-prefixes "ol-doi" '("org-link-doi-"))


;;; Generated autoloads from org/ol-eshell.el

(register-definition-prefixes "ol-eshell" '("org-eshell-"))


;;; Generated autoloads from org/ol-eww.el

(register-definition-prefixes "ol-eww" '("org-eww-"))


;;; Generated autoloads from org/ol-gnus.el

(register-definition-prefixes "ol-gnus" '("org-gnus-"))


;;; Generated autoloads from org/ol-info.el

(register-definition-prefixes "ol-info" '("org-info-"))


;;; Generated autoloads from org/ol-irc.el

(register-definition-prefixes "ol-irc" '("org-irc-"))


;;; Generated autoloads from org/ol-man.el

(register-definition-prefixes "ol-man" '("org-man-"))


;;; Generated autoloads from org/ol-mhe.el

(register-definition-prefixes "ol-mhe" '("org-mhe-"))


;;; Generated autoloads from org/ol-rmail.el

(register-definition-prefixes "ol-rmail" '("org-rmail-"))


;;; Generated autoloads from org/ol-w3m.el

(register-definition-prefixes "ol-w3m" '("org-w3m-"))


;;; Generated autoloads from progmodes/opascal.el

(define-obsolete-function-alias 'delphi-mode #'opascal-mode "24.4")
(autoload 'opascal-mode "opascal" "\
Major mode for editing OPascal code.
\\<opascal-mode-map>
\\[opascal-find-unit]	- Search for a OPascal source file.
\\[opascal-fill-comment]	- Fill the current comment.
\\[opascal-new-comment-line]	- If in a // comment, do a new comment line.

\\[indent-region] also works for indenting a whole region.

Customization:

 `opascal-indent-level'                (default 3)
    Indentation of OPascal statements with respect to containing block.
 `opascal-compound-block-indent'       (default 0)
    Extra indentation for blocks in compound statements.
 `opascal-case-label-indent'           (default 0)
    Extra indentation for case statement labels.
 `opascal-search-path'                 (default .)
    Directories to search when finding external units.
 `opascal-verbose'                     (default nil)
    If true then OPascal token processing progress is reported to the user.

Coloring:

 `opascal-keyword-face'                (default `font-lock-keyword-face')
    Face used to color OPascal keywords.

(fn)" t)
(register-definition-prefixes "opascal" '("opascal-"))


;;; Generated autoloads from org/org.el

(push (purecopy '(org 9 7 11)) package--builtin-versions)
(autoload 'org-babel-do-load-languages "org" "\
Load the languages defined in `org-babel-load-languages'.

(fn SYM VALUE)")
(autoload 'org-babel-load-file "org" "\
Load Emacs Lisp source code blocks in the Org FILE.
This function exports the source code using `org-babel-tangle'
and then loads the resulting file using `load-file'.  With
optional prefix argument COMPILE, the tangled Emacs Lisp file is
byte-compiled before it is loaded.

(fn FILE &optional COMPILE)" t)
(autoload 'org-version "org" "\
Show the Org version.
Interactively, or when MESSAGE is non-nil, show it in echo area.
With prefix argument, or when HERE is non-nil, insert it at point.
In non-interactive uses, a reduced version string is output unless
FULL is given.

(fn &optional HERE FULL MESSAGE)" t)
(autoload 'org-load-modules-maybe "org" "\
Load all extensions listed in `org-modules'.

(fn &optional FORCE)")
(autoload 'org-clock-persistence-insinuate "org" "\
Set up hooks for clock persistence.")
(autoload 'org-mode "org" "\
Outline-based notes management and organizer, alias
\"Carsten's outline-mode for keeping track of everything.\"

Org mode develops organizational tasks around a NOTES file which
contains information about projects as plain text.  Org mode is
implemented on top of Outline mode, which is ideal to keep the content
of large files well structured.  It supports ToDo items, deadlines and
time stamps, which magically appear in the diary listing of the Emacs
calendar.  Tables are easily created with a built-in table editor.
Plain text URL-like links connect to websites, emails (VM), Usenet
messages (Gnus), BBDB entries, and any files related to the project.
For printing and sharing of notes, an Org file (or a part of it)
can be exported as a structured ASCII or HTML file.

The following commands are available:

\\{org-mode-map}

(fn)" t)
(autoload 'org-run-like-in-org-mode "org" "\
Run a command, pretending that the current buffer is in Org mode.
This will temporarily bind local variables that are typically bound in
Org mode to the values they have in Org mode, and then interactively
call CMD.

(fn CMD)")
(autoload 'org-open-file "org" "\
Open the file at PATH.
First, this expands any special file name abbreviations.  Then the
configuration variable `org-file-apps' is checked if it contains an
entry for this file type, and if yes, the corresponding command is launched.

If no application is found, Emacs simply visits the file.

With optional prefix argument IN-EMACS, Emacs will visit the file.
With a double \\[universal-argument] \\[universal-argument] prefix arg, Org tries to avoid opening in Emacs
and to use an external application to visit the file.

Optional LINE specifies a line to go to, optional SEARCH a string
to search for.  If LINE or SEARCH is given, the file will be
opened in Emacs, unless an entry from `org-file-apps' that makes
use of groups in a regexp matches.

If you want to change the way frames are used when following a
link, please customize `org-link-frame-setup'.

If the file does not exist, throw an error.

(fn PATH &optional IN-EMACS LINE SEARCH)")
(autoload 'org-open-at-point-global "org" "\
Follow a link or a timestamp like Org mode does.
Also follow links and emails as seen by `thing-at-point'.
This command can be called in any mode to follow an external
link or a timestamp that has Org mode syntax.  Its behavior
is undefined when called on internal links like fuzzy links.
Raise a user error when there is nothing to follow." t)
(autoload 'org-offer-links-in-entry "org" "\
Offer links in the current entry and return the selected link.
If there is only one link, return it.
If NTH is an integer, return the NTH link found.
If ZERO is a string, check also this string for a link, and if
there is one, return it.

(fn BUFFER MARKER &optional NTH ZERO)")
(autoload 'org-switchb "org" "\
Switch between Org buffers.

With `\\[universal-argument]' prefix, restrict available buffers to files.

With `\\[universal-argument] \\[universal-argument]' prefix, restrict available buffers to agenda files.

(fn &optional ARG)" t)
(autoload 'org-cycle-agenda-files "org" "\
Cycle through the files in `org-agenda-files'.
If the current buffer visits an agenda file, find the next one in the list.
If the current buffer does not, find the first agenda file." t)
(autoload 'org-submit-bug-report "org" "\
Submit a bug report on Org via mail.

Don't hesitate to report any problems or inaccurate documentation.

If you don't have setup sending mail from (X)Emacs, please copy the
output buffer into your mail program, as it gives us important
information about your Org version and configuration." t)
(autoload 'org-reload "org" "\
Reload all Org Lisp files.
With prefix arg UNCOMPILED, load the uncompiled versions.

(fn &optional UNCOMPILED)" t)
(autoload 'org-customize "org" "\
Call the customize function with org as argument." t)
(register-definition-prefixes "org" '("org-" "turn-on-org-cdlatex"))


;;; Generated autoloads from org/org-agenda.el

(autoload 'org-toggle-sticky-agenda "org-agenda" "\
Toggle `org-agenda-sticky'.

(fn &optional ARG)" t)
(autoload 'org-agenda "org-agenda" "\
Dispatch agenda commands to collect entries to the agenda buffer.
Prompts for a command to execute.  Any prefix arg will be passed
on to the selected command.  The default selections are:

a     Call `org-agenda-list' to display the agenda for current day or week.
t     Call `org-todo-list' to display the global todo list.
T     Call `org-todo-list' to display the global todo list, select only
      entries with a specific TODO keyword (the user gets a prompt).
m     Call `org-tags-view' to display headlines with tags matching
      a condition  (the user is prompted for the condition).
M     Like `m', but select only TODO entries, no ordinary headlines.
e     Export views to associated files.
s     Search entries for keywords.
S     Search entries for keywords, only with TODO keywords.
/     Multi occur across all agenda files and also files listed
      in `org-agenda-text-search-extra-files'.
<     Restrict agenda commands to buffer, subtree, or region.
      Press several times to get the desired effect.
>     Remove a previous restriction.
#     List \"stuck\" projects.
!     Configure what \"stuck\" means.
C     Configure custom agenda commands.

More commands can be added by configuring the variable
`org-agenda-custom-commands'.  In particular, specific tags and TODO keyword
searches can be pre-defined in this way.

If the current buffer is in Org mode and visiting a file, you can also
first press `<' once to indicate that the agenda should be temporarily
(until the next use of `\\[org-agenda]') restricted to the current file.
Pressing `<' twice means to restrict to the current subtree or region
(if active).

(fn &optional ARG KEYS RESTRICTION)" t)
(autoload 'org-batch-agenda "org-agenda" "\
Run an agenda command in batch mode and send the result to STDOUT.
If CMD-KEY is a string of length 1, it is used as a key in
`org-agenda-custom-commands' and triggers this command.  If it is a
longer string it is used as a tags/todo match string.
Parameters are alternating variable names and values that will be bound
before running the agenda command.

(fn CMD-KEY &rest PARAMETERS)" nil t)
(autoload 'org-batch-agenda-csv "org-agenda" "\
Run an agenda command in batch mode and send the result to STDOUT.
If CMD-KEY is a string of length 1, it is used as a key in
`org-agenda-custom-commands' and triggers this command.  If it is a
longer string it is used as a tags/todo match string.
Parameters are alternating variable names and values that will be bound
before running the agenda command.

The output gives a line for each selected agenda item.  Each
item is a list of comma-separated values, like this:

category,head,type,todo,tags,date,time,extra,priority-l,priority-n

category     The category of the item
head         The headline, without TODO kwd, TAGS and PRIORITY
type         The type of the agenda entry, can be
                todo               selected in TODO match
                tagsmatch          selected in tags match
                diary              imported from diary
                deadline           a deadline on given date
                scheduled          scheduled on given date
                timestamp          entry has timestamp on given date
                closed             entry was closed on given date
                upcoming-deadline  warning about deadline
                past-scheduled     forwarded scheduled item
                block              entry has date block including g. date
todo         The todo keyword, if any
tags         All tags including inherited ones, separated by colons
date         The relevant date, like 2007-2-14
time         The time, like 15:00-16:50
extra        String with extra planning info
priority-l   The priority letter if any was given
priority-n   The computed numerical priority
agenda-day   The day in the agenda where this is listed

(fn CMD-KEY &rest PARAMETERS)" nil t)
(autoload 'org-store-agenda-views "org-agenda" "\
Store agenda views.

(fn &rest PARAMETERS)" t)
(autoload 'org-batch-store-agenda-views "org-agenda" "\
Run all custom agenda commands that have a file argument.

(fn &rest PARAMETERS)" nil t)
(autoload 'org-agenda-list "org-agenda" "\
Produce a daily/weekly view from all files in variable `org-agenda-files'.
The view will be for the current day or week, but from the overview buffer
you will be able to go to other days/weeks.

With a numeric prefix argument in an interactive call, the agenda will
span ARG days.  Lisp programs should instead specify SPAN to change
the number of days.  SPAN defaults to `org-agenda-span'.

START-DAY defaults to TODAY, or to the most recent match for the weekday
given in `org-agenda-start-on-weekday'.

When WITH-HOUR is non-nil, only include scheduled and deadline
items if they have an hour specification like [h]h:mm.

(fn &optional ARG START-DAY SPAN WITH-HOUR)" t)
(autoload 'org-search-view "org-agenda" "\
Show all entries that contain a phrase or words or regular expressions.

With optional prefix argument TODO-ONLY, only consider entries that are
TODO entries.  The argument STRING can be used to pass a default search
string into this function.  If EDIT-AT is non-nil, it means that the
user should get a chance to edit this string, with cursor at position
EDIT-AT.

The search string can be viewed either as a phrase that should be found as
is, or it can be broken into a number of snippets, each of which must match
in a Boolean way to select an entry.  The default depends on the variable
`org-agenda-search-view-always-boolean'.
Even if this is turned off (the default) you can always switch to
Boolean search dynamically by preceding the first word with  \"+\" or \"-\".

The default is a direct search of the whole phrase, where each space in
the search string can expand to an arbitrary amount of whitespace,
including newlines.

If using a Boolean search, the search string is split on whitespace and
each snippet is searched separately, with logical AND to select an entry.
Words prefixed with a minus must *not* occur in the entry.  Words without
a prefix or prefixed with a plus must occur in the entry.  Matching is
case-insensitive.  Words are enclosed by word delimiters (i.e. they must
match whole words, not parts of a word) if
`org-agenda-search-view-force-full-words' is set (default is nil).

Boolean search snippets enclosed by curly braces are interpreted as
regular expressions that must or (when preceded with \"-\") must not
match in the entry.  Snippets enclosed into double quotes will be taken
as a whole, to include whitespace.

- If the search string starts with an asterisk, search only in headlines.
- If (possibly after the leading star) the search string starts with an
  exclamation mark, this also means to look at TODO entries only, an effect
  that can also be achieved with a prefix argument.
- If (possibly after star and exclamation mark) the search string starts
  with a colon, this will mean that the (non-regexp) snippets of the
  Boolean search must match as full words.

This command searches the agenda files, and in addition the files
listed in `org-agenda-text-search-extra-files' unless a restriction lock
is active.

(fn &optional TODO-ONLY STRING EDIT-AT)" t)
(autoload 'org-todo-list "org-agenda" "\
Show all (not done) TODO entries from all agenda files in a single list.
The prefix arg can be used to select a specific TODO keyword and limit
the list to these.  When using `\\[universal-argument]', you will be prompted
for a keyword.  A numeric prefix directly selects the Nth keyword in
`org-todo-keywords-1'.

(fn &optional ARG)" t)
(autoload 'org-tags-view "org-agenda" "\
Show all headlines for all `org-agenda-files' matching a TAGS criterion.
The prefix arg TODO-ONLY limits the search to TODO entries.

(fn &optional TODO-ONLY MATCH)" t)
(autoload 'org-agenda-list-stuck-projects "org-agenda" "\
Create agenda view for projects that are stuck.
Stuck projects are project that have no next actions.  For the definitions
of what a project is and how to check if it stuck, customize the variable
`org-stuck-projects'.

(fn &rest IGNORE)" t)
(autoload 'org-diary "org-agenda" "\
Return diary information from org files.
This function can be used in a \"sexp\" diary entry in the Emacs calendar.
It accesses org files and extracts information from those files to be
listed in the diary.  The function accepts arguments specifying what
items should be listed.  For a list of arguments allowed here, see the
variable `org-agenda-entry-types'.

The call in the diary file should look like this:

   &%%(org-diary) ~/path/to/some/orgfile.org

Use a separate line for each org file to check.  Or, if you omit the file name,
all files listed in `org-agenda-files' will be checked automatically:

   &%%(org-diary)

If you don't give any arguments (as in the example above), the default value
of `org-agenda-entry-types' is used: (:deadline :scheduled :timestamp :sexp).
So the example above may also be written as

   &%%(org-diary :deadline :timestamp :sexp :scheduled)

The function expects the lisp variables `entry' and `date' to be provided
by the caller, because this is how the calendar works.  Don't use this
function from a program - use `org-agenda-get-day-entries' instead.

(fn &rest ARGS)")
(autoload 'org-agenda-check-for-timestamp-as-reason-to-ignore-todo-item "org-agenda" "\
Do we have a reason to ignore this TODO entry because it has a time stamp?

(fn &optional END)")
(autoload 'org-agenda-set-restriction-lock "org-agenda" "\
Set restriction lock for agenda to current subtree or file.
When in a restricted subtree, remove it.

The restriction will span over the entire file if TYPE is `file',
or if TYPE is (4), or if the cursor is before the first headline
in the file.  Otherwise, only apply the restriction to the current
subtree.

(fn &optional TYPE)" t)
(autoload 'org-calendar-goto-agenda "org-agenda" "\
Compute the Org agenda for the calendar date displayed at the cursor.
This is a command that has to be installed in `calendar-mode-map'." t)
(autoload 'org-agenda-to-appt "org-agenda" "\
Activate appointments found in `org-agenda-files'.

With a `\\[universal-argument]' prefix, refresh the list of appointments.

If FILTER is t, interactively prompt the user for a regular
expression, and filter out entries that don't match it.

If FILTER is a string, use this string as a regular expression
for filtering entries out.

If FILTER is a function, filter out entries against which
calling the function returns nil.  This function takes one
argument: an entry from `org-agenda-get-day-entries'.

FILTER can also be an alist with the car of each cell being
either `headline' or `category'.  For example:

   ((headline \"IMPORTANT\")
    (category \"Work\"))

will only add headlines containing IMPORTANT or headlines
belonging to the \"Work\" category.

ARGS are symbols indicating what kind of entries to consider.
By default `org-agenda-to-appt' will use :deadline*, :scheduled*
(i.e., deadlines and scheduled items with a hh:mm specification)
and :timestamp entries.  See the docstring of `org-diary' for
details and examples.

If an entry has a APPT_WARNTIME property, its value will be used
to override `appt-message-warning-time'.

(fn &optional REFRESH FILTER &rest ARGS)" t)
(register-definition-prefixes "org-agenda" '("org-"))


;;; Generated autoloads from org/org-archive.el

(register-definition-prefixes "org-archive" '("org-a"))


;;; Generated autoloads from org/org-attach.el

(register-definition-prefixes "org-attach" '("org-attach-"))


;;; Generated autoloads from org/org-attach-git.el

(register-definition-prefixes "org-attach-git" '("org-attach-git-"))


;;; Generated autoloads from org/org-capture.el

(autoload 'org-capture-string "org-capture" "\
Capture STRING with the template selected by KEYS.

(fn STRING &optional KEYS)" t)
(autoload 'org-capture "org-capture" "\
Capture something.
\\<org-capture-mode-map>
This will let you select a template from `org-capture-templates', and
then file the newly captured information.  The text is immediately
inserted at the target location, and an indirect buffer is shown where
you can edit it.  Pressing `\\[org-capture-finalize]' brings you back to the previous
state of Emacs, so that you can continue your work.

When called interactively with a `\\[universal-argument]' prefix argument GOTO, don't
capture anything, just go to the file/headline where the selected
template stores its notes.

With a `\\[universal-argument] \\[universal-argument]' prefix argument, go to the last note stored.

When called with a `C-0' (zero) prefix, insert a template at point.

When called with a `C-1' (one) prefix, force prompting for a date when
a datetree entry is made.

ELisp programs can set KEYS to a string associated with a template
in `org-capture-templates'.  In this case, interactive selection
will be bypassed.

If `org-capture-use-agenda-date' is non-nil, capturing from the
agenda will use the date at point as the default date.  Then, a
`C-1' prefix will tell the capture process to use the HH:MM time
of the day at point (if any) or the current HH:MM time.

(fn &optional GOTO KEYS)" t)
(autoload 'org-capture-import-remember-templates "org-capture" "\
Set `org-capture-templates' to be similar to `org-remember-templates'." t)
(register-definition-prefixes "org-capture" '("org-capture-"))


;;; Generated autoloads from org/org-clock.el

(register-definition-prefixes "org-clock" '("org-"))


;;; Generated autoloads from org/org-colview.el

(register-definition-prefixes "org-colview" '("org-"))


;;; Generated autoloads from org/org-compat.el

(register-definition-prefixes "org-compat" '("org-" "outline-"))


;;; Generated autoloads from org/org-crypt.el

(autoload 'org-encrypt-entry "org-crypt" "\
Encrypt the content of the current headline." t)
(autoload 'org-decrypt-entry "org-crypt" "\
Decrypt the content of the current headline." t)
(autoload 'org-encrypt-entries "org-crypt" "\
Encrypt all top-level entries in the current buffer." t)
(autoload 'org-decrypt-entries "org-crypt" "\
Decrypt all entries in the current buffer." t)
(autoload 'org-crypt-use-before-save-magic "org-crypt" "\
Add a hook to automatically encrypt entries before a file is saved to disk.")
(register-definition-prefixes "org-crypt" '("org-"))


;;; Generated autoloads from org/org-ctags.el

(register-definition-prefixes "org-ctags" '("org-"))


;;; Generated autoloads from org/org-cycle.el

(autoload 'org-cycle "org-cycle" "\
TAB-action and visibility cycling for Org mode.

This is the command invoked in Org mode by the `TAB' key.  Its main
purpose is outline visibility cycling, but it also invokes other actions
in special contexts.

When this function is called with a `\\[universal-argument]' prefix, rotate the entire
buffer through 3 states (global cycling)
  1. OVERVIEW: Show only top-level headlines.
  2. CONTENTS: Show all headlines of all levels, but no body text.
  3. SHOW ALL: Show everything.

With a `\\[universal-argument] \\[universal-argument]' prefix argument, switch to the startup visibility,
determined by the variable `org-startup-folded', and by any VISIBILITY
properties in the buffer.

With a `\\[universal-argument] \\[universal-argument] \\[universal-argument]' prefix argument, show the entire buffer, including
any drawers.

When inside a table, re-align the table and move to the next field.

When point is at the beginning of a headline, rotate the subtree started
by this line through 3 different states (local cycling)
  1. FOLDED:   Only the main headline is shown.
  2. CHILDREN: The main headline and the direct children are shown.
               From this state, you can move to one of the children
               and zoom in further.
  3. SUBTREE:  Show the entire subtree, including body text.
If there is no subtree, switch directly from CHILDREN to FOLDED.

When point is at the beginning of an empty headline and the variable
`org-cycle-level-after-item/entry-creation' is set, cycle the level
of the headline by demoting and promoting it to likely levels.  This
speeds up creation document structure by pressing `TAB' once or several
times right after creating a new headline.

When there is a numeric prefix, go up to a heading with level ARG, do
a `show-subtree' and return to the previous cursor position.  If ARG
is negative, go up that many levels.

When point is not at the beginning of a headline, execute the global
binding for `TAB', which is re-indenting the line.  See the option
`org-cycle-emulate-tab' for details.

As a special case, if point is at the very beginning of the buffer, if
there is no headline there, and if the variable `org-cycle-global-at-bob'
is non-nil, this function acts as if called with prefix argument (`\\[universal-argument] TAB',
same as `S-TAB') also when called without prefix argument.

(fn &optional ARG)" t)
(autoload 'org-cycle-global "org-cycle" "\
Cycle the global visibility.  For details see `org-cycle'.
With `\\[universal-argument]' prefix ARG, switch to startup visibility.
With a numeric prefix, show all headlines up to that level.

(fn &optional ARG)" t)
(register-definition-prefixes "org-cycle" '("org-"))


;;; Generated autoloads from org/org-datetree.el

(register-definition-prefixes "org-datetree" '("org-datetree-"))


;;; Generated autoloads from org/org-duration.el

(register-definition-prefixes "org-duration" '("org-duration-"))


;;; Generated autoloads from org/org-element.el

(register-definition-prefixes "org-element" '("org-element-"))


;;; Generated autoloads from org/org-element-ast.el

(register-definition-prefixes "org-element-ast" '("org-element-"))


;;; Generated autoloads from org/org-entities.el

(register-definition-prefixes "org-entities" '("org-entit"))


;;; Generated autoloads from org/org-faces.el

(register-definition-prefixes "org-faces" '("org-"))


;;; Generated autoloads from org/org-feed.el

(register-definition-prefixes "org-feed" '("org-feed-"))


;;; Generated autoloads from org/org-fold.el

(register-definition-prefixes "org-fold" '("org-fold-"))


;;; Generated autoloads from org/org-fold-core.el

(register-definition-prefixes "org-fold-core" '("org-fold-core-"))


;;; Generated autoloads from org/org-footnote.el

(register-definition-prefixes "org-footnote" '("org-footnote-"))


;;; Generated autoloads from org/org-goto.el

(register-definition-prefixes "org-goto" '("org-goto-"))


;;; Generated autoloads from org/org-habit.el

(register-definition-prefixes "org-habit" '("org-"))


;;; Generated autoloads from org/org-id.el

(register-definition-prefixes "org-id" '("org-id-"))


;;; Generated autoloads from org/org-indent.el

(register-definition-prefixes "org-indent" '("org-indent-"))


;;; Generated autoloads from org/org-inlinetask.el

(register-definition-prefixes "org-inlinetask" '("org-inlinetask-"))


;;; Generated autoloads from org/org-keys.el

(register-definition-prefixes "org-keys" '("org-"))


;;; Generated autoloads from org/org-lint.el

(register-definition-prefixes "org-lint" '("org-lint-"))


;;; Generated autoloads from org/org-list.el

(register-definition-prefixes "org-list" '("org-"))


;;; Generated autoloads from org/org-macro.el

(register-definition-prefixes "org-macro" '("org-macro-"))


;;; Generated autoloads from org/org-macs.el

(register-definition-prefixes "org-macs" '("org-"))


;;; Generated autoloads from org/org-mobile.el

(register-definition-prefixes "org-mobile" '("org-mobile-"))


;;; Generated autoloads from org/org-mouse.el

(register-definition-prefixes "org-mouse" '("org-"))


;;; Generated autoloads from org/org-num.el

(register-definition-prefixes "org-num" '("org-num-"))


;;; Generated autoloads from org/org-pcomplete.el

(register-definition-prefixes "org-pcomplete" '("org-" "pcomplete/org-mode/"))


;;; Generated autoloads from org/org-persist.el

(register-definition-prefixes "org-persist" '("org-persist-"))


;;; Generated autoloads from org/org-plot.el

(register-definition-prefixes "org-plot" '("org-"))


;;; Generated autoloads from org/org-protocol.el

(register-definition-prefixes "org-protocol" '("org-"))


;;; Generated autoloads from org/org-refile.el

(register-definition-prefixes "org-refile" '("org-"))


;;; Generated autoloads from org/org-src.el

(register-definition-prefixes "org-src" '("org-"))


;;; Generated autoloads from org/org-table.el

(register-definition-prefixes "org-table" '("org"))


;;; Generated autoloads from org/org-tempo.el

(register-definition-prefixes "org-tempo" '("org-tempo-"))


;;; Generated autoloads from org/org-timer.el

(register-definition-prefixes "org-timer" '("org-timer-"))


;;; Generated autoloads from org/org-version.el

(autoload 'org-release "org-version" "\
The release version of Org.
Inserted by installing Org mode or when a release is made.")
(autoload 'org-git-version "org-version" "\
The Git version of Org mode.
Inserted by installing Org or when a release is made.")


;;; Generated autoloads from outline.el

(put 'outline-regexp 'safe-local-variable 'stringp)
(put 'outline-heading-end-regexp 'safe-local-variable 'stringp)
(put 'outline-level 'risky-local-variable t)
(autoload 'outline-mode "outline" "\
Set major mode for editing outlines with selective display.
Headings are lines which start with asterisks: one for major headings,
two for subheadings, etc.  Lines not starting with asterisks are body lines.

Body text or subheadings under a heading can be made temporarily
invisible, or visible again.  Invisible lines are attached to the end
of the heading, so they move with it, if the line is killed and yanked
back.  A heading with text hidden under it is marked with an ellipsis (...).

\\{outline-mode-map}
The commands `outline-hide-subtree', `outline-show-subtree',
`outline-show-children', `outline-hide-entry',
`outline-show-entry', `outline-hide-leaves', and `outline-show-branches'
are used when point is on a heading line.

The variable `outline-regexp' can be changed to control what is a heading.
A line is a heading if `outline-regexp' matches something at the
beginning of the line.  The longer the match, the deeper the level.

Turning on outline mode calls the value of `text-mode-hook' and then of
`outline-mode-hook', if they are non-nil.

(fn)" t)
(autoload 'outline-minor-mode "outline" "\
Toggle Outline minor mode.

See the command `outline-mode' for more information on this mode.

This is a minor mode.  If called interactively, toggle the `Outline
minor mode' mode.  If the prefix argument is positive, enable the mode,
and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate the variable `outline-minor-mode'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'outline-search-level "outline" "\
Search for the next text property `outline-level'.
The arguments are the same as in `outline-search-text-property',
except the hard-coded property name `outline-level'.
This function is intended to be used in `outline-search-function'.

(fn &optional BOUND MOVE BACKWARD LOOKING-AT)")
(register-definition-prefixes "outline" '("outline-"))


;;; Generated autoloads from org/ox.el

(register-definition-prefixes "ox" '("org-"))


;;; Generated autoloads from org/ox-ascii.el

(register-definition-prefixes "ox-ascii" '("org-"))


;;; Generated autoloads from org/ox-beamer.el

(register-definition-prefixes "ox-beamer" '("org-beamer-"))


;;; Generated autoloads from org/ox-html.el

(register-definition-prefixes "ox-html" '("org-"))


;;; Generated autoloads from org/ox-icalendar.el

(register-definition-prefixes "ox-icalendar" '("org-icalendar-"))


;;; Generated autoloads from org/ox-koma-letter.el

(autoload 'org-koma-letter-export-as-latex "ox-koma-letter" "\
Export current buffer as a KOMA Scrlttr2 letter.

If narrowing is active in the current buffer, only export its
narrowed part.

If a region is active, export that region.

A non-nil optional argument ASYNC means the process should happen
asynchronously.  The resulting buffer should be accessible
through the `org-export-stack' interface.

When optional argument SUBTREEP is non-nil, export the sub-tree
at point, extracting information from the headline properties
first.

When optional argument VISIBLE-ONLY is non-nil, don't export
contents of hidden elements.

When optional argument BODY-ONLY is non-nil, only write code
between \"\\begin{letter}\" and \"\\end{letter}\".

EXT-PLIST, when provided, is a property list with external
parameters overriding Org default settings, but still inferior to
file-local settings.

Export is done in a buffer named \"*Org KOMA-LETTER Export*\".  It
will be displayed if `org-export-show-temporary-export-buffer' is
non-nil.

(fn &optional ASYNC SUBTREEP VISIBLE-ONLY BODY-ONLY EXT-PLIST)" t)
(autoload 'org-koma-letter-export-to-latex "ox-koma-letter" "\
Export current buffer as a KOMA Scrlttr2 letter (tex).

If narrowing is active in the current buffer, only export its
narrowed part.

If a region is active, export that region.

A non-nil optional argument ASYNC means the process should happen
asynchronously.  The resulting file should be accessible through
the `org-export-stack' interface.

When optional argument SUBTREEP is non-nil, export the sub-tree
at point, extracting information from the headline properties
first.

When optional argument VISIBLE-ONLY is non-nil, don't export
contents of hidden elements.

When optional argument BODY-ONLY is non-nil, only write code
between \"\\begin{letter}\" and \"\\end{letter}\".

EXT-PLIST, when provided, is a property list with external
parameters overriding Org default settings, but still inferior to
file-local settings.

When optional argument PUB-DIR is set, use it as the publishing
directory.

Return output file's name.

(fn &optional ASYNC SUBTREEP VISIBLE-ONLY BODY-ONLY EXT-PLIST)" t)
(autoload 'org-koma-letter-export-to-pdf "ox-koma-letter" "\
Export current buffer as a KOMA Scrlttr2 letter (pdf).

If narrowing is active in the current buffer, only export its
narrowed part.

If a region is active, export that region.

A non-nil optional argument ASYNC means the process should happen
asynchronously.  The resulting file should be accessible through
the `org-export-stack' interface.

When optional argument SUBTREEP is non-nil, export the sub-tree
at point, extracting information from the headline properties
first.

When optional argument VISIBLE-ONLY is non-nil, don't export
contents of hidden elements.

When optional argument BODY-ONLY is non-nil, only write code
between \"\\begin{letter}\" and \"\\end{letter}\".

EXT-PLIST, when provided, is a property list with external
parameters overriding Org default settings, but still inferior to
file-local settings.

Return PDF file's name.

(fn &optional ASYNC SUBTREEP VISIBLE-ONLY BODY-ONLY EXT-PLIST)" t)
(register-definition-prefixes "ox-koma-letter" '("org-koma-letter-"))


;;; Generated autoloads from org/ox-latex.el

(register-definition-prefixes "ox-latex" '("org-"))


;;; Generated autoloads from org/ox-man.el

(register-definition-prefixes "ox-man" '("org-man-"))


;;; Generated autoloads from org/ox-md.el

(register-definition-prefixes "ox-md" '("org-"))


;;; Generated autoloads from org/ox-odt.el

(register-definition-prefixes "ox-odt" '("org-odt-"))


;;; Generated autoloads from org/ox-org.el

(register-definition-prefixes "ox-org" '("org-org-"))


;;; Generated autoloads from org/ox-publish.el

(register-definition-prefixes "ox-publish" '("org-publish-"))


;;; Generated autoloads from org/ox-texinfo.el

(register-definition-prefixes "ox-texinfo" '("org-"))


;;; Generated autoloads from emacs-lisp/package.el

(push (purecopy '(package 1 1 0)) package--builtin-versions)
(defvar package-enable-at-startup t "\
Whether to make installed packages available when Emacs starts.
If non-nil, packages are made available before reading the init
file (but after reading the early init file).  This means that if
you wish to set this variable, you must do so in the early init
file.  Regardless of the value of this variable, packages are not
made available if `user-init-file' is nil (e.g. Emacs was started
with \"-q\").

Even if the value is nil, you can type \\[package-initialize] to
make installed packages available at any time, or you can
call (package-activate-all) in your init-file.

Note that this variable must be set to a non-default value in
your early-init file, as the variable's value is used before
loading the regular init file.  Therefore, if you customize it
via Customize, you should save your customized setting into
your `early-init-file'.")
(custom-autoload 'package-enable-at-startup "package" t)
(defcustom package-user-dir (locate-user-emacs-file "elpa") "\
Directory containing the user's Emacs Lisp packages.
The directory name should be absolute.
Apart from this directory, Emacs also looks for system-wide
packages in `package-directory-list'." :type 'directory :initialize #'custom-initialize-delay :risky t :group 'applications :version "24.1")
(custom-autoload 'package-user-dir "package" t)
(defcustom package-directory-list (let (result) (dolist (f load-path) (and (stringp f) (equal (file-name-nondirectory f) "site-lisp") (push (expand-file-name "elpa" f) result))) (nreverse result)) "\
List of additional directories containing Emacs Lisp packages.
Each directory name should be absolute.

These directories contain packages intended for system-wide; in
contrast, `package-user-dir' contains packages for personal use." :type '(repeat directory) :initialize #'custom-initialize-delay :group 'applications :risky t :version "24.1")
(custom-autoload 'package-directory-list "package" t)
(defvar package-activated-list nil "\
List of the names of currently activated packages.")
(defvar package--activated nil "\
Non-nil if `package-activate-all' has been run.")
(autoload 'package-initialize "package" "\
Load Emacs Lisp packages, and activate them.
The variable `package-load-list' controls which packages to load.
If optional arg NO-ACTIVATE is non-nil, don't activate packages.

It is not necessary to adjust `load-path' or `require' the
individual packages after calling `package-initialize' -- this is
taken care of by `package-initialize'.

If `package-initialize' is called twice during Emacs startup,
signal a warning, since this is a bad idea except in highly
advanced use cases.  To suppress the warning, remove the
superfluous call to `package-initialize' from your init-file.  If
you have code which must run before `package-initialize', put
that code in the early init-file.

(fn &optional NO-ACTIVATE)" t)
(defun package-activate-all nil "\
Activate all installed packages.
The variable `package-load-list' controls which packages to load." (setq package--activated t) (let* ((elc (concat package-quickstart-file "c")) (qs (if (file-readable-p elc) elc (if (file-readable-p package-quickstart-file) package-quickstart-file)))) (or (and qs (not (bound-and-true-p package-activated-list)) (with-demoted-errors "Error during quickstart: %S" (let ((load-source-file-function nil)) (unless (boundp 'package-activated-list) (setq package-activated-list nil)) (load qs nil 'nomessage) t))) (progn (require 'package) (with-no-warnings (package--activate-all))))))
(autoload 'package-import-keyring "package" "\
Import keys from FILE.

(fn &optional FILE)" t)
(autoload 'package-refresh-contents "package" "\
Download descriptions of all configured ELPA packages.
For each archive configured in the variable `package-archives',
inform Emacs about the latest versions of all packages it offers,
and make them available for download.
Optional argument ASYNC specifies whether to perform the
downloads in the background.

(fn &optional ASYNC)" t)
(autoload 'package-installed-p "package" "\
Return non-nil if PACKAGE, of MIN-VERSION or newer, is installed.
If PACKAGE is a symbol, it is the package name and MIN-VERSION
should be a version list.

If PACKAGE is a `package-desc' object, MIN-VERSION is ignored.

(fn PACKAGE &optional MIN-VERSION)")
(autoload 'package-install "package" "\
Install the package PKG.
PKG can be a `package-desc' or a symbol naming one of the
available packages in an archive in `package-archives'.

Mark the installed package as selected by adding it to
`package-selected-packages'.

When called from Lisp and optional argument DONT-SELECT is
non-nil, install the package but do not add it to
`package-selected-packages'.

If PKG is a `package-desc' and it is already installed, don't try
to install it but still mark it as selected.

If the command is invoked with a prefix argument, it will allow
upgrading of built-in packages, as if `package-install-upgrade-built-in'
had been enabled.

(fn PKG &optional DONT-SELECT)" t)
(autoload 'package-upgrade "package" "\
Upgrade package NAME if a newer version exists.

(fn NAME)" t)
(autoload 'package-upgrade-all "package" "\
Refresh package list and upgrade all packages.
If QUERY, ask the user before upgrading packages.  When called
interactively, QUERY is always true.

Currently, packages which are part of the Emacs distribution are
not upgraded by this command.  To enable upgrading such a package
using this command, first upgrade the package to a newer version
from ELPA by either using `\\[package-upgrade]' or
`\\<package-menu-mode-map>\\[package-menu-mark-install]' after `\\[list-packages]'.

(fn &optional QUERY)" t)
(autoload 'package-install-from-buffer "package" "\
Install a package from the current buffer.
The current buffer is assumed to be a single .el or .tar file or
a directory.  These must follow the packaging guidelines (see
info node `(elisp)Packaging').

Specially, if current buffer is a directory, the -pkg.el
description file is not mandatory, in which case the information
is derived from the main .el file in the directory.

Downloads and installs required packages as needed." t)
(autoload 'package-install-file "package" "\
Install a package from FILE.
The file can either be a tar file, an Emacs Lisp file, or a
directory.

(fn FILE)" t)
(autoload 'package-install-selected-packages "package" "\
Ensure packages in `package-selected-packages' are installed.
If some packages are not installed, propose to install them.
If optional argument NOCONFIRM is non-nil, don't ask for
confirmation to install packages.

(fn &optional NOCONFIRM)" t)
(autoload 'package-reinstall "package" "\
Reinstall package PKG.
PKG should be either a symbol, the package name, or a `package-desc'
object.

(fn PKG)" t)
(autoload 'package-recompile "package" "\
Byte-compile package PKG again.
PKG should be either a symbol, the package name, or a `package-desc'
object.

(fn PKG)" t)
(autoload 'package-recompile-all "package" "\
Byte-compile all installed packages.
This is meant to be used only in the case the byte-compiled files
are invalid due to changed byte-code, macros or the like." t)
(autoload 'package-autoremove "package" "\
Remove packages that are no longer needed.

Packages that are no more needed by other packages in
`package-selected-packages' and their dependencies
will be deleted." t)
(autoload 'describe-package "package" "\
Display the full documentation of PACKAGE (a symbol).

(fn PACKAGE)" t)
(autoload 'list-packages "package" "\
Display a list of packages.
This first fetches the updated list of packages before
displaying, unless a prefix argument NO-FETCH is specified.
The list is displayed in a buffer named `*Packages*', and
includes the package's version, availability status, and a
short description.

(fn &optional NO-FETCH)" t)
(defalias 'package-list-packages 'list-packages)
(autoload 'package-get-version "package" "\
Return the version number of the package in which this is used.
Assumes it is used from an Elisp file placed inside the top-level directory
of an installed ELPA package.
The return value is a string (or nil in case we can't find it).
It works in more cases if the call is in the file which contains
the `Version:' header.")
(function-put 'package-get-version 'pure 't)
(defcustom package-quickstart-file (locate-user-emacs-file "package-quickstart.el") "\
Location of the file used to speed up activation of packages at startup." :type 'file :group 'applications :initialize #'custom-initialize-delay :version "27.1")
(custom-autoload 'package-quickstart-file "package" t)
(autoload 'package-report-bug "package" "\
Prepare a message to send to the maintainers of a package.
DESC must be a `package-desc' object.

(fn DESC)" '(package-menu-mode))
(register-definition-prefixes "package" '("bad-signature" "define-package" "describe-package-1" "package-"))


;;; Generated autoloads from emacs-lisp/package-vc.el

(autoload 'package-vc-install-selected-packages "package-vc" "\
Ensure packages specified in `package-vc-selected-packages' are installed." t)
(autoload 'package-vc-upgrade-all "package-vc" "\
Upgrade all installed VC packages.

This may fail if the local VCS state of one of the packages
conflicts with its remote repository state." t)
(autoload 'package-vc-upgrade "package-vc" "\
Upgrade the package described by PKG-DESC from package's VC repository.

This may fail if the local VCS state of the package conflicts
with the remote repository state.

(fn PKG-DESC)" t)
(autoload 'package-vc-install "package-vc" "\
Fetch a package described by PACKAGE and set it up for use with Emacs.

PACKAGE specifies which package to install, where to find its
source repository and how to build it.

If PACKAGE is a symbol, install the package with that name
according to metadata that package archives provide for it.  This
is the simplest way to call this function, but it only works if
the package you want to install is listed in a package archive
you have configured.

If PACKAGE is a string, it specifies the URL of the package
repository.  In this case, optional argument BACKEND specifies
the VC backend to use for cloning the repository; if it's nil,
this function tries to infer which backend to use according to
the value of `package-vc-heuristic-alist' and if that fails it
uses `package-vc-default-backend'.  Optional argument NAME
specifies the package name in this case; if it's nil, this
package uses `file-name-base' on the URL to obtain the package
name, otherwise NAME is the package name as a symbol.

PACKAGE can also be a cons cell (PNAME . SPEC) where PNAME is the
package name as a symbol, and SPEC is a plist that specifies how
to fetch and build the package.  For possible values, see the
subsection \"Specifying Package Sources\" in the Info
node `(emacs)Fetching Package Sources'.

By default, this function installs the last revision of the
package available from its repository.  If REV is a string, it
describes the revision to install, as interpreted by the relevant
VC backend.  The special value `:last-release' (interactively,
the prefix argument), says to use the commit of the latest
release, if it exists.  The last release is the latest revision
which changed the \"Version:\" header of the package's main Lisp
file.

If you use this function to install a package that you also have
installed from a package archive, the version this function
installs takes precedence.

(fn PACKAGE &optional REV BACKEND NAME)" t)
(autoload 'package-vc-checkout "package-vc" "\
Clone the sources for PKG-DESC into DIRECTORY and visit that directory.
Unlike `package-vc-install', this does not yet set up the package
for use with Emacs; use `package-vc-install-from-checkout' for
setting the package up after this function finishes.  Optional
argument REV means to clone a specific version of the package; it
defaults to the last version available from the package's
repository.  If REV has the special value
`:last-release' (interactively, the prefix argument), that stands
for the last released version of the package.

(fn PKG-DESC DIRECTORY &optional REV)" t)
(autoload 'package-vc-install-from-checkout "package-vc" "\
Install the package NAME from its source directory DIR.
NAME defaults to the base name of DIR.
Interactively, prompt the user for DIR, which should be a directory
under version control, typically one created by `package-vc-checkout'.
If invoked interactively with a prefix argument, prompt the user
for the NAME of the package to set up.

(fn DIR &optional NAME)" t)
(autoload 'package-vc-rebuild "package-vc" "\
Rebuild the installation for package given by PKG-DESC.
Rebuilding an installation means scraping for new autoload
cookies, re-compiling Emacs Lisp files, building and installing
any documentation, downloading any missing dependencies.  This
command does not fetch new revisions from a remote server.  That
is the responsibility of `package-vc-upgrade'.  Interactively,
prompt for the name of the package to rebuild.

(fn PKG-DESC)" t)
(autoload 'package-vc-prepare-patch "package-vc" "\
Email patches for REVISIONS to maintainer of package PKG-DESC using SUBJECT.

PKG-DESC is a package descriptor and SUBJECT is the subject of
the message.

Interactively, prompt for PKG-DESC, SUBJECT, and REVISIONS.  When
invoked with a numerical prefix argument, use the last N
revisions.  When invoked interactively in a Log View buffer with
marked revisions, use those.

See also `vc-prepare-patch'.

(fn PKG-DESC SUBJECT REVISIONS)" t)
(register-definition-prefixes "package-vc" '("package-vc-"))


;;; Generated autoloads from emacs-lisp/package-x.el

(autoload 'package-upload-file "package-x" "\
Upload the Emacs Lisp package FILE to the package archive.
Interactively, prompt for FILE.  The package is considered a
single-file package if FILE ends in \".el\", and a multi-file
package if FILE ends in \".tar\".
Automatically extract package attributes and update the archive's
contents list with this information.
If `package-archive-upload-base' does not specify a valid upload
destination, prompt for one.  If the directory does not exist, it
is created.  The directory need not have any initial contents
(i.e., you can use this command to populate an initially empty
archive).

(fn FILE)" t)
(register-definition-prefixes "package-x" '("package-"))


;;; Generated autoloads from textmodes/page-ext.el

(register-definition-prefixes "page-ext" '("pages-"))


;;; Generated autoloads from leim/quail/pakistan.el

(register-definition-prefixes "quail/pakistan" '("pakistan-"))


;;; Generated autoloads from calendar/parse-time.el

(put 'parse-time-rules 'risky-local-variable t)
(autoload 'parse-time-string "parse-time" "\
Parse the time in STRING into (SEC MIN HOUR DAY MON YEAR DOW DST TZ).
STRING should be an ISO 8601 time string, e.g., \"2020-01-15T16:12:21-08:00\",
or something resembling an RFC 822 (or later) date-time, e.g.,
\"Wed, 15 Jan 2020 16:12:21 -0800\".  This function is
somewhat liberal in what format it accepts, and will attempt to
return a \"likely\" value even for somewhat malformed strings.
The values returned are identical to those of `decode-time', but
any unknown values other than DST are returned as nil, and an
unknown DST value is returned as -1.
Note that, unlike `decode-time', this function does not interpret
the time string, and in particular the values of DST and TZ do not
affect the returned value of date and time, they only affect the
last two members of the returned value.  This function simply
parses the textual representation of date and time into separate
numerical values, and doesn't care whether the time is local or UTC.

See `decode-time' for the meaning of FORM.

(fn STRING &optional FORM)")
(register-definition-prefixes "parse-time" '("parse-"))


;;; Generated autoloads from progmodes/pascal.el

(autoload 'pascal-mode "pascal" "\
Major mode for editing Pascal code.
\\<pascal-mode-map>
TAB indents for Pascal code.  Delete converts tabs to spaces as it moves back.

\\[completion-at-point] completes the word around current point with respect to position in code
\\[completion-help-at-point] shows all possible completions at this point.

Other useful functions are:

\\[pascal-mark-defun]	- Mark function.
\\[pascal-insert-block]	- insert begin ... end;
\\[pascal-star-comment]	- insert (* ... *)
\\[pascal-comment-area]	- Put marked area in a comment, fixing nested comments.
\\[pascal-uncomment-area]	- Uncomment an area commented with \\[pascal-comment-area].
\\[pascal-beg-of-defun]	- Move to beginning of current function.
\\[pascal-end-of-defun]	- Move to end of current function.
\\[pascal-goto-defun]	- Goto function prompted for in the minibuffer.
\\[pascal-outline-mode]	- Enter `pascal-outline-mode'.

Variables controlling indentation/edit style:

 `pascal-indent-level' (default 3)
    Indentation of Pascal statements with respect to containing block.
 `pascal-case-indent' (default 2)
    Indentation for case statements.
 `pascal-auto-newline' (default nil)
    Non-nil means automatically newline after semicolons and the punctuation
    mark after an end.
 `pascal-indent-nested-functions' (default t)
    Non-nil means nested functions are indented.
 `pascal-tab-always-indent' (default t)
    Non-nil means TAB in Pascal mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 `pascal-auto-endcomments' (default t)
    Non-nil means a comment { ... } is set after the ends which ends cases and
    functions.  The name of the function or case will be set between the braces.
 `pascal-auto-lineup' (default t)
    List of contexts where auto lineup of :'s or ='s should be done.

See also the user variables `pascal-type-keywords', `pascal-start-keywords' and
`pascal-separator-keywords'.

(fn)" t)
(register-definition-prefixes "pascal" '("electric-pascal-" "pascal-"))


;;; Generated autoloads from password-cache.el

(defvar password-cache t "\
Whether to cache passwords.")
(custom-autoload 'password-cache "password-cache" t)
(defvar password-cache-expiry 16 "\
How many seconds passwords are cached, or nil to disable expiring.
Whether passwords are cached at all is controlled by `password-cache'.")
(custom-autoload 'password-cache-expiry "password-cache" t)
(autoload 'password-in-cache-p "password-cache" "\
Check if KEY is in the cache.

(fn KEY)")
(register-definition-prefixes "password-cache" '("password-"))


;;; Generated autoloads from emacs-lisp/pcase.el

(autoload 'pcase "pcase" "\
Evaluate EXP to get EXPVAL; try passing control to one of CASES.
CASES is a list of elements of the form (PATTERN CODE...).
For the first CASE whose PATTERN \"matches\" EXPVAL,
evaluate its CODE..., and return the value of the last form.
If no CASE has a PATTERN that matches, return nil.

Each PATTERN expands, in essence, to a predicate to call
on EXPVAL.  When the return value of that call is non-nil,
PATTERN matches.  PATTERN can take one of the forms:

  _                matches anything.
  \\='VAL             matches if EXPVAL is `equal' to VAL.
  KEYWORD          shorthand for \\='KEYWORD
  INTEGER          shorthand for \\='INTEGER
  STRING           shorthand for \\='STRING
  SYMBOL           matches anything and binds it to SYMBOL.
                   If a SYMBOL is used twice in the same pattern
                   the second occurrence becomes an `eq'uality test.
  (pred FUN)       matches if FUN called on EXPVAL returns non-nil.
  (pred (not FUN)) matches if FUN called on EXPVAL returns nil.
  (app FUN PAT)    matches if FUN called on EXPVAL matches PAT.
  (guard BOOLEXP)  matches if BOOLEXP evaluates to non-nil.
  (and PAT...)     matches if all the patterns match.
  (or PAT...)      matches if any of the patterns matches.

FUN in `pred' and `app' can take one of the forms:
  SYMBOL  or  (lambda ARGS BODY)
     call it with one argument
  (F ARG1 .. ARGn)
     call F with ARG1..ARGn and EXPVAL as n+1'th argument
  (F ARG1 .. _ .. ARGn)
     call F, passing EXPVAL at the _ position.

FUN, BOOLEXP, and subsequent PAT can refer to variables
bound earlier in the pattern by a SYMBOL pattern.

Additional patterns can be defined using `pcase-defmacro'.

See Info node `(elisp) Pattern-Matching Conditional' in the
Emacs Lisp manual for more information and examples.

(fn EXP &rest CASES)" nil t)
(function-put 'pcase 'lisp-indent-function 1)
(put 'pcase 'function-documentation '(pcase--make-docstring))
(autoload 'pcase--make-docstring "pcase")
(autoload 'pcase-exhaustive "pcase" "\
The exhaustive version of `pcase' (which see).
If EXP fails to match any of the patterns in CASES, an error is
signaled.

In contrast, `pcase' will return nil if there is no match, but
not signal an error.

(fn EXP &rest CASES)" nil t)
(function-put 'pcase-exhaustive 'lisp-indent-function 1)
(autoload 'pcase-lambda "pcase" "\
Like `lambda' but allow each argument to be a pattern.
I.e. accepts the usual &optional and &rest keywords, but every
formal argument can be any pattern accepted by `pcase' (a mere
variable name being but a special case of it).

(fn LAMBDA-LIST &rest BODY)" nil t)
(function-put 'pcase-lambda 'doc-string-elt 2)
(function-put 'pcase-lambda 'lisp-indent-function 'defun)
(autoload 'pcase-let* "pcase" "\
Like `let*', but supports destructuring BINDINGS using `pcase' patterns.
As with `pcase-let', BINDINGS are of the form (PATTERN EXP), but the
EXP in each binding in BINDINGS can use the results of the destructuring
bindings that precede it in BINDINGS' order.

Each EXP should match its respective PATTERN (i.e. be of structure
compatible to PATTERN); a mismatch may signal an error or may go
undetected, binding variables to arbitrary values, such as nil.

(fn BINDINGS &rest BODY)" nil t)
(function-put 'pcase-let* 'lisp-indent-function 1)
(autoload 'pcase-let "pcase" "\
Like `let', but supports destructuring BINDINGS using `pcase' patterns.
BODY should be a list of expressions, and BINDINGS should be a list of
bindings of the form (PATTERN EXP).
All EXPs are evaluated first, and then used to perform destructuring
bindings by matching each EXP against its respective PATTERN.  Then
BODY is evaluated with those bindings in effect.

Each EXP should match its respective PATTERN (i.e. be of structure
compatible to PATTERN); a mismatch may signal an error or may go
undetected, binding variables to arbitrary values, such as nil.

(fn BINDINGS &rest BODY)" nil t)
(function-put 'pcase-let 'lisp-indent-function 1)
(autoload 'pcase-dolist "pcase" "\
Eval BODY once for each set of bindings defined by PATTERN and LIST elements.
PATTERN should be a `pcase' pattern describing the structure of
LIST elements, and LIST is a list of objects that match PATTERN,
i.e. have a structure that is compatible with PATTERN.
For each element of LIST, this macro binds the variables in
PATTERN to the corresponding subfields of the LIST element, and
then evaluates BODY with these bindings in effect.  The
destructuring bindings of variables in PATTERN to the subfields
of the elements of LIST is performed as if by `pcase-let'.

(fn (PATTERN LIST) BODY...)" nil t)
(function-put 'pcase-dolist 'lisp-indent-function 1)
(autoload 'pcase-setq "pcase" "\
Assign values to variables by destructuring with `pcase'.
PATTERNS are normal `pcase' patterns, and VALUES are expression.

Evaluation happens sequentially as in `setq' (not in parallel).

An example: (pcase-setq \\=`((,a) [(,b)]) \\='((1) [(2)]))

VAL is presumed to match PAT.  Failure to match may signal an error or go
undetected, binding variables to arbitrary values, such as nil.

(fn PATTERNS VALUE PATTERN VALUES ...)" nil t)
(autoload 'pcase-defmacro "pcase" "\
Define a new kind of pcase PATTERN, by macro expansion.
Patterns of the form (NAME ...) will be expanded according
to this macro.

By convention, DOC should use \"EXPVAL\" to stand
for the result of evaluating EXP (first arg to `pcase').

(fn NAME ARGS [DOC] &rest BODY...)" nil t)
(function-put 'pcase-defmacro 'lisp-indent-function 2)
(function-put 'pcase-defmacro 'doc-string-elt 3)
(register-definition-prefixes "pcase" '("pcase-"))


;;; Generated autoloads from pcmpl-cvs.el

(autoload 'pcomplete/cvs "pcmpl-cvs" "\
Completion rules for the `cvs' command.")
(register-definition-prefixes "pcmpl-cvs" '("pcmpl-cvs-"))


;;; Generated autoloads from pcmpl-git.el

(autoload 'pcomplete/git "pcmpl-git" "\
Completion for the `git' command.")
(register-definition-prefixes "pcmpl-git" '("pcmpl-git--"))


;;; Generated autoloads from pcmpl-gnu.el

(autoload 'pcomplete/gzip "pcmpl-gnu" "\
Completion for `gzip'.")
(autoload 'pcomplete/bzip2 "pcmpl-gnu" "\
Completion for `bzip2'.")
(autoload 'pcomplete/make "pcmpl-gnu" "\
Completion for GNU `make'.")
(autoload 'pcomplete/tar "pcmpl-gnu" "\
Completion for the GNU tar utility.")
(autoload 'pcomplete/find "pcmpl-gnu" "\
Completion for the GNU find utility.")
(autoload 'pcomplete/awk "pcmpl-gnu" "\
Completion for the `awk' command.")
(autoload 'pcomplete/gpg "pcmpl-gnu" "\
Completion for the `gpg` command.")
(autoload 'pcomplete/gdb "pcmpl-gnu" "\
Completion for the `gdb' command.")
(autoload 'pcomplete/emacs "pcmpl-gnu" "\
Completion for the `emacs' command.")
(autoload 'pcomplete/emacsclient "pcmpl-gnu" "\
Completion for the `emacsclient' command.")
(register-definition-prefixes "pcmpl-gnu" '("pcmpl-gnu-" "pcomplete/find"))


;;; Generated autoloads from pcmpl-linux.el

(autoload 'pcomplete/kill "pcmpl-linux" "\
Completion for GNU/Linux `kill', using /proc filesystem.")
(autoload 'pcomplete/umount "pcmpl-linux" "\
Completion for GNU/Linux `umount'.")
(autoload 'pcomplete/mount "pcmpl-linux" "\
Completion for GNU/Linux `mount'.")
(autoload 'pcomplete/systemctl "pcmpl-linux" "\
Completion for the `systemctl' command.")
(autoload 'pcomplete/journalctl "pcmpl-linux" "\
Completion for the `journalctl' command.")
(register-definition-prefixes "pcmpl-linux" '("pcmpl-linux-" "pcomplete-pare-list"))


;;; Generated autoloads from pcmpl-rpm.el

(autoload 'pcomplete/rpm "pcmpl-rpm" "\
Completion for the `rpm' command.")
(autoload 'pcomplete/dnf "pcmpl-rpm" "\
Completion for the `dnf' command.")
(register-definition-prefixes "pcmpl-rpm" '("pcmpl-rpm-"))


;;; Generated autoloads from pcmpl-unix.el

(autoload 'pcomplete/cd "pcmpl-unix" "\
Completion for `cd'.")
(defalias 'pcomplete/pushd 'pcomplete/cd)
(autoload 'pcomplete/rmdir "pcmpl-unix" "\
Completion for `rmdir'.")
(autoload 'pcomplete/rm "pcmpl-unix" "\
Completion for the `rm' command.")
(autoload 'pcomplete/xargs "pcmpl-unix" "\
Completion for `xargs'.")
(autoload 'pcomplete/time "pcmpl-unix" "\
Completion for the `time' command.")
(autoload 'pcomplete/which "pcmpl-unix" "\
Completion for `which'.")
(autoload 'pcomplete/cat "pcmpl-unix" "\
Completion for the `cat' command.")
(autoload 'pcomplete/tac "pcmpl-unix" "\
Completion for the `tac' command.")
(autoload 'pcomplete/nl "pcmpl-unix" "\
Completion for the `nl' command.")
(autoload 'pcomplete/od "pcmpl-unix" "\
Completion for the `od' command.")
(autoload 'pcomplete/base32 "pcmpl-unix" "\
Completion for the `base32' and `base64' commands.")
(defalias 'pcomplete/base64 'pcomplete/base32)
(autoload 'pcomplete/basenc "pcmpl-unix" "\
Completion for the `basenc' command.")
(autoload 'pcomplete/fmt "pcmpl-unix" "\
Completion for the `fmt' command.")
(autoload 'pcomplete/pr "pcmpl-unix" "\
Completion for the `pr' command.")
(autoload 'pcomplete/fold "pcmpl-unix" "\
Completion for the `fold' command.")
(autoload 'pcomplete/head "pcmpl-unix" "\
Completion for the `head' command.")
(autoload 'pcomplete/tail "pcmpl-unix" "\
Completion for the `tail' command.")
(autoload 'pcomplete/split "pcmpl-unix" "\
Completion for the `split' command.")
(autoload 'pcomplete/csplit "pcmpl-unix" "\
Completion for the `csplit' command.")
(autoload 'pcomplete/wc "pcmpl-unix" "\
Completion for the `wc' command.")
(autoload 'pcomplete/sum "pcmpl-unix" "\
Completion for the `sum' command.")
(autoload 'pcomplete/cksum "pcmpl-unix" "\
Completion for the `cksum' command.")
(autoload 'pcomplete/b2sum "pcmpl-unix" "\
Completion for the `b2sum' command.")
(autoload 'pcomplete/md5sum "pcmpl-unix" "\
Completion for checksum commands.")
(defalias 'pcomplete/sha1sum 'pcomplete/md5sum)
(defalias 'pcomplete/sha224sum 'pcomplete/md5sum)
(defalias 'pcomplete/sha256sum 'pcomplete/md5sum)
(defalias 'pcomplete/sha384sum 'pcomplete/md5sum)
(defalias 'pcomplete/sha512sum 'pcomplete/md5sum)
(autoload 'pcomplete/sort "pcmpl-unix" "\
Completion for the `sort' command.")
(autoload 'pcomplete/shuf "pcmpl-unix" "\
Completion for the `shuf' command.")
(autoload 'pcomplete/uniq "pcmpl-unix" "\
Completion for the `uniq' command.")
(autoload 'pcomplete/comm "pcmpl-unix" "\
Completion for the `comm' command.")
(autoload 'pcomplete/ptx "pcmpl-unix" "\
Completion for the `ptx' command.")
(autoload 'pcomplete/tsort "pcmpl-unix" "\
Completion for the `tsort' command.")
(autoload 'pcomplete/cut "pcmpl-unix" "\
Completion for the `cut' command.")
(autoload 'pcomplete/paste "pcmpl-unix" "\
Completion for the `paste' command.")
(autoload 'pcomplete/join "pcmpl-unix" "\
Completion for the `join' command.")
(autoload 'pcomplete/tr "pcmpl-unix" "\
Completion for the `tr' command.")
(autoload 'pcomplete/expand "pcmpl-unix" "\
Completion for the `expand' command.")
(autoload 'pcomplete/unexpand "pcmpl-unix" "\
Completion for the `unexpand' command.")
(autoload 'pcomplete/ls "pcmpl-unix" "\
Completion for the `ls' command.")
(defalias 'pcomplete/dir 'pcomplete/ls)
(defalias 'pcomplete/vdir 'pcomplete/ls)
(autoload 'pcomplete/cp "pcmpl-unix" "\
Completion for the `cp' command.")
(autoload 'pcomplete/dd "pcmpl-unix" "\
Completion for the `dd' command.")
(autoload 'pcomplete/install "pcmpl-unix" "\
Completion for the `install' command.")
(autoload 'pcomplete/mv "pcmpl-unix" "\
Completion for the `mv' command.")
(autoload 'pcomplete/shred "pcmpl-unix" "\
Completion for the `shred' command.")
(autoload 'pcomplete/ln "pcmpl-unix" "\
Completion for the `ln' command.")
(autoload 'pcomplete/mkdir "pcmpl-unix" "\
Completion for the `mkdir' command.")
(autoload 'pcomplete/mkfifo "pcmpl-unix" "\
Completion for the `mkfifo' command.")
(autoload 'pcomplete/mknod "pcmpl-unix" "\
Completion for the `mknod' command.")
(autoload 'pcomplete/readlink "pcmpl-unix" "\
Completion for the `readlink' command.")
(autoload 'pcomplete/chown "pcmpl-unix" "\
Completion for the `chown' command.")
(autoload 'pcomplete/chgrp "pcmpl-unix" "\
Completion for the `chgrp' command.")
(autoload 'pcomplete/chmod "pcmpl-unix" "\
Completion for the `chmod' command.")
(autoload 'pcomplete/touch "pcmpl-unix" "\
Completion for the `touch' command.")
(autoload 'pcomplete/df "pcmpl-unix" "\
Completion for the `df' command.")
(autoload 'pcomplete/du "pcmpl-unix" "\
Completion for the `du' command.")
(autoload 'pcomplete/stat "pcmpl-unix" "\
Completion for the `stat' command.")
(autoload 'pcomplete/sync "pcmpl-unix" "\
Completion for the `sync' command.")
(autoload 'pcomplete/truncate "pcmpl-unix" "\
Completion for the `truncate' command.")
(autoload 'pcomplete/echo "pcmpl-unix" "\
Completion for the `echo' command.")
(autoload 'pcomplete/test "pcmpl-unix" "\
Completion for the `test' command.")
(defalias (intern "pcomplete/[") 'pcomplete/test)
(autoload 'pcomplete/tee "pcmpl-unix" "\
Completion for the `tee' command.")
(autoload 'pcomplete/basename "pcmpl-unix" "\
Completion for the `basename' command.")
(autoload 'pcomplete/dirname "pcmpl-unix" "\
Completion for the `dirname' command.")
(autoload 'pcomplete/pathchk "pcmpl-unix" "\
Completion for the `pathchk' command.")
(autoload 'pcomplete/mktemp "pcmpl-unix" "\
Completion for the `mktemp' command.")
(autoload 'pcomplete/realpath "pcmpl-unix" "\
Completion for the `realpath' command.")
(autoload 'pcomplete/id "pcmpl-unix" "\
Completion for the `id' command.")
(autoload 'pcomplete/groups "pcmpl-unix" "\
Completion for the `groups' command.")
(autoload 'pcomplete/who "pcmpl-unix" "\
Completion for the `who' command.")
(autoload 'pcomplete/date "pcmpl-unix" "\
Completion for the `date' command.")
(autoload 'pcomplete/nproc "pcmpl-unix" "\
Completion for the `nproc' command.")
(autoload 'pcomplete/uname "pcmpl-unix" "\
Completion for the `uname' command.")
(autoload 'pcomplete/hostname "pcmpl-unix" "\
Completion for the `hostname' command.")
(autoload 'pcomplete/uptime "pcmpl-unix" "\
Completion for the `uptime' command.")
(autoload 'pcomplete/chcon "pcmpl-unix" "\
Completion for the `chcon' command.")
(autoload 'pcomplete/runcon "pcmpl-unix" "\
Completion for the `runcon' command.")
(autoload 'pcomplete/chroot "pcmpl-unix" "\
Completion for the `chroot' command.")
(autoload 'pcomplete/env "pcmpl-unix" "\
Completion for the `env' command.")
(autoload 'pcomplete/nice "pcmpl-unix" "\
Completion for the `nice' command.")
(autoload 'pcomplete/nohup "pcmpl-unix" "\
Completion for the `nohup' command.")
(autoload 'pcomplete/stdbuf "pcmpl-unix" "\
Completion for the `stdbuf' command.")
(autoload 'pcomplete/timeout "pcmpl-unix" "\
Completion for the `timeout' command.")
(autoload 'pcomplete/numfmt "pcmpl-unix" "\
Completion for the `numfmt' command.")
(autoload 'pcomplete/seq "pcmpl-unix" "\
Completion for the `seq' command.")
(autoload 'pcomplete/ssh "pcmpl-unix" "\
Completion rules for the `ssh' command.")
(defalias 'pcomplete/rsh #'pcomplete/ssh)
(autoload 'pcomplete/scp "pcmpl-unix" "\
Completion rules for the `scp' command.
Includes files as well as host names followed by a colon.")
(autoload 'pcomplete/telnet "pcmpl-unix")
(autoload 'pcomplete/sudo "pcmpl-unix" "\
Completion for the `sudo' command.")
(autoload 'pcomplete/doas "pcmpl-unix" "\
Completion for the `doas' command.")
(register-definition-prefixes "pcmpl-unix" '("pcmpl-" "pcomplete/"))


;;; Generated autoloads from pcmpl-x.el

(autoload 'pcomplete/tex "pcmpl-x" "\
Completion for the `tex' command.")
(defalias 'pcomplete/pdftex 'pcomplete/tex)
(defalias 'pcomplete/latex 'pcomplete/tex)
(defalias 'pcomplete/pdflatex 'pcomplete/tex)
(autoload 'pcomplete/luatex "pcmpl-x" "\
Completion for the `luatex' command.")
(defalias 'pcomplete/lualatex 'pcomplete/luatex)
(autoload 'pcomplete/tlmgr "pcmpl-x" "\
Completion for the `tlmgr' command.")
(autoload 'pcomplete/rg "pcmpl-x" "\
Completion for the `rg' command.")
(autoload 'pcomplete/ack "pcmpl-x" "\
Completion for the `ack' command.
Start an argument with `-' to complete short options and `--' for
long options.")
(defalias 'pcomplete/ack-grep 'pcomplete/ack)
(autoload 'pcomplete/ag "pcmpl-x" "\
Completion for the `ag' command.")
(autoload 'pcomplete/bcc32 "pcmpl-x" "\
Completion function for Borland's C++ compiler.")
(defalias 'pcomplete/bcc 'pcomplete/bcc32)
(autoload 'pcomplete/rclone "pcmpl-x" "\
Completion for the `rclone' command.")
(register-definition-prefixes "pcmpl-x" '("pcmpl-x-"))


;;; Generated autoloads from pcomplete.el

(autoload 'pcomplete "pcomplete" "\
Support extensible programmable completion.
To use this function, just bind the TAB key to it, or add it to your
completion functions list (it should occur fairly early in the list).

(fn &optional INTERACTIVELY)" t)
(make-obsolete 'pcomplete '"use completion-at-point and pcomplete-completions-at-point" "27.1")
(autoload 'pcomplete-reverse "pcomplete" "\
If cycling completion is in use, cycle backwards." t)
(autoload 'pcomplete-expand-and-complete "pcomplete" "\
Expand the textual value of the current argument.
This will modify the current buffer." t)
(autoload 'pcomplete-continue "pcomplete" "\
Complete without reference to any cycling completions." t)
(autoload 'pcomplete-expand "pcomplete" "\
Expand the textual value of the current argument.
This will modify the current buffer." t)
(autoload 'pcomplete-help "pcomplete" "\
Display any help information relative to the current argument." t)
(make-obsolete 'pcomplete-help '"use completion-help-at-point and pcomplete-completions-at-point" "27.1")
(autoload 'pcomplete-list "pcomplete" "\
Show the list of possible completions for the current argument." t)
(autoload 'pcomplete-comint-setup "pcomplete" "\
Setup a comint buffer to use pcomplete.
COMPLETEF-SYM should be the symbol where the
dynamic-complete-functions are kept.  For comint mode itself,
this is `comint-dynamic-complete-functions'.

(fn COMPLETEF-SYM)")
(autoload 'pcomplete-shell-setup "pcomplete" "\
Setup `shell-mode' to use pcomplete.")
(register-definition-prefixes "pcomplete" '("pcomplete-"))


;;; Generated autoloads from cedet/ede/pconf.el

(register-definition-prefixes "ede/pconf" '("ede-pconf-create-file-query"))


;;; Generated autoloads from vc/pcvs.el

(autoload 'cvs-checkout "pcvs" "\
Run a `cvs checkout MODULES' in DIR.
Feed the output to a *cvs* buffer, display it in the current window,
and run `cvs-mode' on it.

With a prefix argument, prompt for cvs FLAGS to use.

(fn MODULES DIR FLAGS &optional ROOT)" t)
(autoload 'cvs-quickdir "pcvs" "\
Open a *cvs* buffer on DIR without running cvs.
With a prefix argument, prompt for a directory to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.
FLAGS is ignored.

(fn DIR &optional FLAGS NOSHOW)" t)
(autoload 'cvs-examine "pcvs" "\
Run a `cvs -n update' in the specified DIRECTORY.
That is, check what needs to be done, but don't change the disc.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a prefix argument, prompt for a directory and cvs FLAGS to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.

(fn DIRECTORY FLAGS &optional NOSHOW)" t)
(autoload 'cvs-update "pcvs" "\
Run a `cvs update' in the current working DIRECTORY.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a \\[universal-argument] prefix argument, prompt for a directory to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
The prefix is also passed to `cvs-flags-query' to select the FLAGS
  passed to cvs.

(fn DIRECTORY FLAGS)" t)
(autoload 'cvs-status "pcvs" "\
Run a `cvs status' in the current working DIRECTORY.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a prefix argument, prompt for a directory and cvs FLAGS to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.

(fn DIRECTORY FLAGS &optional NOSHOW)" t)
(defvar cvs-dired-action 'cvs-quickdir "\
The action to be performed when opening a CVS directory.
Sensible values are `cvs-examine', `cvs-status' and `cvs-quickdir'.")
(custom-autoload 'cvs-dired-action "pcvs" t)
(defvar cvs-dired-use-hook '(4) "\
Whether or not opening a CVS directory should run PCL-CVS.
A value of nil means never do it.
`always' means to always do it unless a prefix argument is given to the
  command that prompted the opening of the directory.
Anything else means to do it only if the prefix arg is equal to this value.")
(custom-autoload 'cvs-dired-use-hook "pcvs" t)
(defun cvs-dired-noselect (dir) "\
Run `cvs-examine' if DIR is a CVS administrative directory.
The exact behavior is determined also by `cvs-dired-use-hook'." (when (stringp dir) (setq dir (directory-file-name dir)) (when (and (string= "CVS" (file-name-nondirectory dir)) (file-readable-p (expand-file-name "Entries" dir)) cvs-dired-use-hook (if (eq cvs-dired-use-hook 'always) (not current-prefix-arg) (equal current-prefix-arg cvs-dired-use-hook))) (save-excursion (funcall cvs-dired-action (file-name-directory dir) t t)))))
(register-definition-prefixes "pcvs" '("cvs-" "defun-cvs-mode"))


;;; Generated autoloads from vc/pcvs-defs.el

(defvar cvs-global-menu (let ((m (make-sparse-keymap "PCL-CVS"))) (define-key m [status] `(menu-item ,(purecopy "Directory Status") cvs-status :help ,(purecopy "A more verbose status of a workarea"))) (define-key m [checkout] `(menu-item ,(purecopy "Checkout Module") cvs-checkout :help ,(purecopy "Check out a module from the repository"))) (define-key m [update] `(menu-item ,(purecopy "Update Directory") cvs-update :help ,(purecopy "Fetch updates from the repository"))) (define-key m [examine] `(menu-item ,(purecopy "Examine Directory") cvs-examine :help ,(purecopy "Examine the current state of a workarea"))) (fset 'cvs-global-menu m)) "\
Global menu used by PCL-CVS.")
(register-definition-prefixes "pcvs-defs" '("cvs-"))


;;; Generated autoloads from vc/pcvs-info.el

(register-definition-prefixes "pcvs-info" '("cvs-"))


;;; Generated autoloads from vc/pcvs-parse.el

(register-definition-prefixes "pcvs-parse" '("cvs-"))


;;; Generated autoloads from vc/pcvs-util.el

(register-definition-prefixes "pcvs-util" '("cvs-"))


;;; Generated autoloads from progmodes/peg.el

(push (purecopy '(peg 1 0 1)) package--builtin-versions)
(register-definition-prefixes "peg" '("bob" "bol" "bos" "bow" "define-peg-rule" "eob" "eol" "eos" "eow" "fail" "null" "peg" "with-peg-rules"))


;;; Generated autoloads from progmodes/perl-mode.el

(put 'perl-indent-level 'safe-local-variable 'integerp)
(put 'perl-continued-statement-offset 'safe-local-variable 'integerp)
(put 'perl-continued-brace-offset 'safe-local-variable 'integerp)
(put 'perl-brace-offset 'safe-local-variable 'integerp)
(put 'perl-brace-imaginary-offset 'safe-local-variable 'integerp)
(put 'perl-label-offset 'safe-local-variable 'integerp)
(autoload 'perl-flymake "perl-mode" "\
Perl backend for Flymake.
Launch `perl-flymake-command' (which see) and pass to its
standard input the contents of the current buffer.  The output of
this command is analyzed for error and warning messages.

(fn REPORT-FN &rest ARGS)")
(autoload 'perl-mode "perl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all Perl brackets.
Tab indents for Perl code.
Comments are delimited with # ... \\n.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{perl-mode-map}
Variables controlling indentation style:
 `perl-tab-always-indent'
    Non-nil means TAB in Perl mode should always indent the current line,
    regardless of where in the line point is when the TAB command is used.
 `perl-tab-to-comment'
    Non-nil means that for lines which don't need indenting, TAB will
    either delete an empty comment, indent an existing comment, move
    to end-of-line, or if at end-of-line already, create a new comment.
 `perl-nochange'
    Lines starting with this regular expression are not auto-indented.
 `perl-indent-level'
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 `perl-continued-statement-offset'
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 `perl-continued-brace-offset'
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `perl-continued-statement-offset'.
 `perl-brace-offset'
    Extra indentation for line if it starts with an open brace.
 `perl-brace-imaginary-offset'
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 `perl-label-offset'
    Extra indentation for line that is a label.
 `perl-indent-continued-arguments'
    Offset of argument lines relative to usual indentation.

Various indentation styles:       K&R  BSD  BLK  GNU  LW
  perl-indent-level                5    8    0    2    4
  perl-continued-statement-offset  5    8    4    2    4
  perl-continued-brace-offset      0    0    0    0   -4
  perl-brace-offset               -5   -8    0    0    0
  perl-brace-imaginary-offset      0    0    4    0    0
  perl-label-offset               -5   -8   -2   -2   -2

Turning on Perl mode runs the normal hook `perl-mode-hook'.

(fn)" t)
(register-definition-prefixes "perl-mode" '("perl-"))


;;; Generated autoloads from pgtk-dnd.el

(register-definition-prefixes "pgtk-dnd" '("pgtk-dnd-"))


;;; Generated autoloads from progmodes/php-ts-mode.el

(autoload 'php-ts-mode "php-ts-mode" "\
Major mode for editing PHP, powered by tree-sitter.

(fn)" t)
(autoload 'php-ts-mode-run-php-webserver "php-ts-mode" "\
Run PHP built-in web server.

PORT: Port number of built-in web server, default `php-ts-mode-ws-port'.
Prompt for the port if the default value is nil.
HOSTNAME: Hostname or IP address of Built-in web server,
default `php-ts-mode-ws-hostname'.  Prompt for the hostname if the
default value is nil.
DOCUMENT-ROOT: Path to Document root, default `php-ts-mode-ws-document-root'.
Prompt for the document-root if the default value is nil.
ROUTER-SCRIPT: Path of the router PHP script,
see `https://www.php.net/manual/en/features.commandline.webserver.php'
NUM-OF-WORKERS: Before run the web server set the
PHP_CLI_SERVER_WORKERS env variable useful for testing code against
multiple simultaneous requests.

Interactively, when invoked with prefix argument, always prompt
for PORT, HOSTNAME, DOCUMENT-ROOT and ROUTER-SCRIPT.

(fn &optional PORT HOSTNAME DOCUMENT-ROOT ROUTER-SCRIPT NUM-OF-WORKERS)" t)
(autoload 'run-php "php-ts-mode" "\
Run an PHP interpreter as a inferior process.

Arguments CMD and CONFIG, default to `php-ts-mode-php-executable'
and `php-ts-mode-php-config' respectively, control which PHP interpreter is run.
Prompt for CMD if `php-ts-mode-php-executable' is nil.
Optional CONFIG, if supplied, is the php.ini file to use.

(fn &optional CMD CONFIG)" t)
(register-definition-prefixes "php-ts-mode" '("inferior-php-ts-mode" "php-ts-"))


;;; Generated autoloads from textmodes/picture.el

(autoload 'picture-mode "picture" "\
Switch to Picture mode, in which a quarter-plane screen model is used.
\\<picture-mode-map>
Printing characters replace instead of inserting themselves with motion
afterwards settable by these commands:

 Move left after insertion:            \\[picture-movement-left]
 Move right after insertion:           \\[picture-movement-right]
 Move up after insertion:              \\[picture-movement-up]
 Move down after insertion:            \\[picture-movement-down]

 Move northwest (nw) after insertion:  \\[picture-movement-nw]
 Move northeast (ne) after insertion:  \\[picture-movement-ne]
 Move southwest (sw) after insertion:  \\[picture-movement-sw]
 Move southeast (se) after insertion:  \\[picture-movement-se]

 Move westnorthwest (wnw) after insertion:  \\[universal-argument] \\[picture-movement-nw]
 Move eastnortheast (ene) after insertion:  \\[universal-argument] \\[picture-movement-ne]
 Move westsouthwest (wsw) after insertion:  \\[universal-argument] \\[picture-movement-sw]
 Move eastsoutheast (ese) after insertion:  \\[universal-argument] \\[picture-movement-se]

The current direction is displayed in the mode line.  The initial
direction is right.  Whitespace is inserted and tabs are changed to
spaces when required by movement.  You can move around in the buffer
with these commands:

 Move vertically to SAME column in previous line: \\[picture-move-down]
 Move vertically to SAME column in next line:     \\[picture-move-up]
 Move to column following last
  non-whitespace character:                       \\[picture-end-of-line]
 Move right, inserting spaces if required:        \\[picture-forward-column]
 Move left changing tabs to spaces if required:   \\[picture-backward-column]
 Move in direction of current picture motion:     \\[picture-motion]
 Move opposite to current picture motion:         \\[picture-motion-reverse]
 Move to beginning of next line:                  \\[next-line]

You can edit tabular text with these commands:

 Move to column beneath (or at) next interesting
  character (see variable `picture-tab-chars'):   \\[picture-tab-search]
 Move to next stop in tab stop list:              \\[picture-tab]
 Set tab stops according to context of this line: \\[picture-set-tab-stops]
   (With ARG, resets tab stops to default value.)
 Change the tab stop list:                        \\[edit-tab-stops]

You can manipulate text with these commands:
 Clear ARG columns after point without moving:    \\[picture-clear-column]
 Delete char at point:                            \\[picture-delete-char]
 Clear ARG columns backward:                      \\[picture-backward-clear-column]
 Clear ARG lines, advancing over them:            \\[picture-clear-line]
  (the cleared text is saved in the kill ring)
 Open blank line(s) beneath current line:         \\[picture-open-line]

You can manipulate rectangles with these commands:
  Clear a rectangle and save it:                  \\[picture-clear-rectangle]
  Clear a rectangle, saving in a named register:  \\[picture-clear-rectangle-to-register]
  Insert currently saved rectangle at point:      \\[picture-yank-rectangle]
  Insert rectangle from named register:           \\[picture-yank-rectangle-from-register]
  Draw a rectangular box around mark and point:   \\[picture-draw-rectangle]
  Copies a rectangle to a register:               \\[copy-rectangle-to-register]
  Undo effects of rectangle overlay commands:     \\[undo]

You can return to the previous mode with \\[picture-mode-exit], which
also strips trailing whitespace from every line.  Stripping is suppressed
by supplying an argument.

Entry to this mode calls the value of `picture-mode-hook' if non-nil.

Note that Picture mode commands will work outside of Picture mode, but
they are not by default assigned to keys." t)
(defalias 'edit-picture 'picture-mode)
(register-definition-prefixes "picture" '("picture-"))


;;; Generated autoloads from textmodes/pixel-fill.el

(register-definition-prefixes "pixel-fill" '("pixel-fill-"))


;;; Generated autoloads from pixel-scroll.el

(defvar pixel-scroll-mode nil "\
Non-nil if Pixel-Scroll mode is enabled.
See the `pixel-scroll-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `pixel-scroll-mode'.")
(custom-autoload 'pixel-scroll-mode "pixel-scroll" nil)
(autoload 'pixel-scroll-mode "pixel-scroll" "\
A minor mode to scroll text pixel-by-pixel.

This is a global minor mode.  If called interactively, toggle the
`Pixel-Scroll mode' mode.  If the prefix argument is positive, enable
the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='pixel-scroll-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(autoload 'pixel-scroll-precision-scroll-down-page "pixel-scroll" "\
Scroll the current window down by DELTA pixels.
Note that this function doesn't work if DELTA is larger than or
equal to the text height of the current window in pixels.

(fn DELTA)")
(autoload 'pixel-scroll-precision-scroll-up-page "pixel-scroll" "\
Scroll the current window up by DELTA pixels.
Note that this function doesn't work if DELTA is larger than
the height of the current window.

(fn DELTA)")
(defvar pixel-scroll-precision-mode nil "\
Non-nil if Pixel-Scroll-Precision mode is enabled.
See the `pixel-scroll-precision-mode' command
for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `pixel-scroll-precision-mode'.")
(custom-autoload 'pixel-scroll-precision-mode "pixel-scroll" nil)
(autoload 'pixel-scroll-precision-mode "pixel-scroll" "\
Toggle pixel scrolling.

When enabled, this minor mode allows you to scroll the display
precisely, according to the turning of the mouse wheel.

This is a global minor mode.  If called interactively, toggle the
`Pixel-Scroll-Precision mode' mode.  If the prefix argument is positive,
enable the mode, and if it is zero or negative, disable the mode.

If called from Lisp, toggle the mode if ARG is `toggle'.  Enable the
mode if ARG is nil, omitted, or is a positive number.  Disable the mode
if ARG is a negative number.

To check whether the minor mode is enabled in the current buffer,
evaluate `(default-value \\='pixel-scroll-precision-mode)'.

The mode's hook is called both when the mode is enabled and when it is
disabled.

(fn &optional ARG)" t)
(register-definition-prefixes "pixel-scroll" '("pixel-"))


;;; Generated autoloads from plstore.el

(put 'plstore-encrypt-to 'safe-local-variable (lambda (val) (or (stringp val) (and (listp val) (catch 'safe (mapc (lambda (elt) (unless (stringp elt) (throw 'safe nil))) val) t)))))
(autoload 'plstore-open "plstore" "\
Create a plstore instance associated with FILE.

(fn FILE)")
(autoload 'plstore-mode "plstore" "\
Major mode for editing plstore files.

(fn)" t)
(register-definition-prefixes "plstore" '("plstore-"))


;;; Generated autoloads from cedet/ede/pmake.el

(register-definition-prefixes "ede/pmake" '("ede-pmake-"))


;;; Generated autoloads from textmodes/po.el

(autoload 'po-find-file-coding-system "po" "\
Return a (DECODING . ENCODING) pair, according to PO file's charset.
Called through `file-coding-system-alist', before the file is visited for real.

(fn ARG-LIST)")
(register-definition-prefixes "po" '("po-"))


;;; Generated autoloads from play/pong.el

(autoload 'pong "pong" "\
Play pong and waste time.
This is an implementation of the classical game pong.
Move left and right bats and try to bounce the ball to your opponent.

pong-mode keybindings:\\<pong-mode-map>

\\{pong-mode-map}" t)
(register-definition-prefixes "pong" '("pong-"))


;;; Generated autoloads from net/pop3.el

(autoload 'pop3-movemail "pop3" "\
Transfer contents of a maildrop to the specified FILE.
Use streaming commands.

(fn FILE)")
(register-definition-prefixes "pop3" '("pop3-"))


;;; Generated autoloads from emacs-lisp/pp.el

(autoload 'pp-to-string "pp" "\
Return a string containing the pretty-printed representation of OBJECT.
OBJECT can be any Lisp object.  Quoting characters are used as needed
to make output that `read' can handle, whenever this is possible.
Optional argument PP-FUNCTION overrides `pp-default-function'.

(fn OBJECT &optional PP-FUNCTION)")
(autoload 'pp-buffer "pp" "\
Prettify the current buffer with printed representation of a Lisp object." t)
(autoload 'pp "pp" "\
Output the pretty-printed representation of OBJECT, any Lisp object.
Quoting characters are printed as needed to make output that `read'
can handle, whenever this is possible.

Uses the pretty-printing code specified in `pp-default-function'.

Output stream is STREAM, or value of `standard-output' (which see).

(fn OBJECT &optional STREAM)")
(autoload 'pp-display-expression "pp" "\
Prettify and display EXPRESSION in an appropriate way, depending on length.
If LISP, format with `pp-emacs-lisp-code'; use `pp' otherwise.

If a temporary buffer is needed for representation, it will be named
after OUT-BUFFER-NAME.

(fn EXPRESSION OUT-BUFFER-NAME &optional LISP)")
(autoload 'pp-eval-expression "pp" "\
Evaluate EXPRESSION and pretty-print its value.
Also add the value to the front of the list in the variable `values'.

(fn EXPRESSION)" t)
(autoload 'pp-macroexpand-expression "pp" "\
Macroexpand EXPRESSION and pretty-print its value.

(fn EXPRESSION)" t)
(autoload 'pp-eval-last-sexp "pp" "\
Run `pp-eval-expression' on sexp before point.
With ARG, pretty-print output into current buffer.
Ignores leading comment characters.

(fn ARG)" t)
(autoload 'pp-macroexpand-last-sexp "pp" "\
Run `pp-macroexpand-expression' on sexp before point.
With ARG, pretty-print output into current buffer.
Ignores leading comment characters.

(fn ARG)" t)
(autoload 'pp-emacs-lisp-code "pp" "\
Insert SEXP into the current buffer, formatted as Emacs Lisp code.
Use the `pp-max-width' variable to control the desired line length.
Note that this could be slow for large SEXPs.
Can also be called with two arguments, in which case they're taken to be
the bounds of a region containing Lisp code to pretty-print.

(fn SEXP &optional END)")
(register-definition-prefixes "pp" '("pp-"))


;;; Generated autoloads from printing.el

(autoload 'pr-interface "printing" "\
Activate the printing interface buffer.

If BUFFER is nil, the current buffer is used for printing.

For more information, type \\[pr-interface-help].

(fn &optional BUFFER)" t)
(autoload 'pr-ps-directory-preview "printing" "\
Preview directory using ghostview.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (\\[universal-argument]), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t)
(autoload 'pr-ps-directory-using-ghostscript "printing" "\
Print directory using PostScript through ghostscript.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (\\[universal-argument]), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t)
(autoload 'pr-ps-directory-print "printing" "\
Print directory using PostScript printer.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (\\[universal-argument]), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t)
(autoload 'pr-ps-directory-ps-print "printing" "\
Print directory using PostScript printer or through ghostscript.

It depends on `pr-print-using-ghostscript'.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (\\[universal-argument]), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t)
(autoload 'pr-ps-buffer-preview "printing" "\
Preview buffer using ghostview.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (\\[universal-argument]), the command prompts the user for a file name, and saves
the PostScript image in that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, save the image in a
temporary file.  If FILENAME is a string, save the PostScript image in a file
with that name.  If FILENAME is t, prompts for a file name.

(fn N-UP &optional FILENAME)" t)
(autoload 'pr-ps-buffer-using-ghostscript "printing" "\
Print buffer using PostScript through ghostscript.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (\\[universal-argument]), the command prompts the user for a file name, and saves
the PostScript image in that file instead of sending it to the printer.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, send the image to the
printer.  If FILENAME is a string, save the PostScri