/* Machine-dependent ELF runtime symbol resolution, OpenRISC version.
   Copyright (C) 2022 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdep.h>

/* This code is plugged into the PLT and used by the dynamic linker to
   call _dl_fixup (dl-runtime.c).

   We assume that R11 contains the relocation offset and R12 contains
   link_map (_DYNAMIC).  This must be consistent with the JUMP_SLOT
   layout generated by binutils.  */

ENTRY (_dl_runtime_resolve)
	l.sw	-4(r1), r9
	l.sw	-8(r1), r1

	/* save function arguments.  */
	l.sw	-12(r1), r3
	l.sw	-16(r1), r4
	l.sw	-20(r1), r5
	l.sw	-24(r1), r6
	l.sw	-28(r1), r7
	l.sw	-32(r1), r8

	.cfi_offset 9, -4
	.cfi_offset 1, -8
	.cfi_offset 3, -12
	.cfi_offset 4, -16
	.cfi_offset 5, -20
	.cfi_offset 6, -24
	.cfi_offset 7, -28
	.cfi_offset 8, -32

	l.addi	r1,r1, -32
	.cfi_def_cfa_offset 32

	l.ori	r3, r12, 0
	l.ori	r4, r11, 0

	l.jal	_dl_fixup
	 l.nop

	/* Restore function arguments.  */
	l.addi	r1,r1, 32
	l.lwz	r8, -32(r1)
	l.lwz	r7, -28(r1)
	l.lwz	r6, -24(r1)
	l.lwz	r5, -20(r1)
	l.lwz	r4, -16(r1)
	l.lwz	r3, -12(r1)

	/* restore return address.  */
	l.lwz	r9, -4(r1)

	l.jr	r11
	 l.nop
END (_dl_runtime_resolve)
