;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2014 Alex Kost <alezost@gmail.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This is an auxiliary file for the Emacs UI.  It is used to add Guix
;; directories to path variables and to load the main code.

;;; Code:

(use-modules (ice-9 regex)
             (srfi srfi-26))

(define %guix-dir)

;; The code is taken from ‘guix’ executable script
(define (set-paths!)
  (define-syntax-rule (push! elt v) (set! v (cons elt v)))

  (define config-lookup
    (let ((config '(("prefix"         . "/gnu/store/9nw4zglfl1dc8zc00rikkvln4kgjify9-guix-0.11.0")
                    ("guilemoduledir" . "${prefix}/share/guile/site/2.0")))
          (var-ref-regexp (make-regexp "\\$\\{([a-z]+)\\}")))
      (define (expand-var-ref match)
        (lookup (match:substring match 1)))
      (define (expand str)
        (regexp-substitute/global #f var-ref-regexp str
                                  'pre expand-var-ref 'post))
      (define (lookup name)
        (expand (assoc-ref config name)))
      lookup))

  (let ((module-dir (config-lookup "guilemoduledir"))
        (updates-dir (and=> (or (getenv "XDG_CONFIG_HOME")
                                (and=> (getenv "HOME")
                                       (cut string-append <> "/.config")))
                            (cut string-append <> "/guix/latest"))))
    (push! module-dir %load-path)
    (push! module-dir %load-compiled-path)
    (if (and updates-dir (file-exists? updates-dir))
        (begin
          (set! %guix-dir updates-dir)
          (push! updates-dir %load-path)
          (push! updates-dir %load-compiled-path))
        (set! %guix-dir module-dir))))

(set-paths!)

(load-from-path "guix-main")

