;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %storedir
            %localstatedir
            %sysconfdir
            %sbindir

            %store-directory
            %state-directory
            %config-directory
            %guix-register-program

            %system
            %libgcrypt
            %libz
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.14.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "https://www.gnu.org/software/guix/")

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %sbindir
  "/gnu/store/x2b9qa0r2akkkmfwrybaligg32q2yb7l-guix-0.14.0/sbin")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "NIX_STATE_DIR")
      (string-append %localstatedir "/guix")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER")
      (string-append %sbindir "/guix-register")))

(define %system
  "i686-linux")

(define %libgcrypt
  "/gnu/store/sm9b3gkaj6yfrs0iiygy8sry17kig5v5-libgcrypt-1.8.1/lib/libgcrypt")

(define %libz
  "/gnu/store/6b1i2zdj7rnym3yg71zz6grbl2p7l4p6-zlib-1.2.11/lib/libz")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/18nmydb6b6dlb29kkfax9vk8bwqaxvz2-gzip-1.8/bin/gzip")

(define %bzip2
  "/gnu/store/x2nsf0h047k2gyw4jdkc6h26krs9sy64-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/7m17yiq1f85m0hak0ipkhqdl5n1r5xmc-xz-5.2.2/bin/xz")

;;; config.scm ends here
