;;; guix-config.el --- Compile-time configuration of Guix.

;; Copyright © 2015 Mathieu Lirzin <mthl@openmailbox.org>
;; Copyright © 2015 Alex Kost <alezost@gmail.com>

;; This file is part of GNU Guix.

;; GNU Guix is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Guix is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Code:

(defconst guix-config-emacs-interface-directory
  (replace-regexp-in-string "${prefix}" "/gnu/store/x4nfycabdkhvbcjdckva1fd1w8r5qqpm-guix-0.9.0" "${prefix}/share/guile/site/2.0/guix/emacs"))

(defconst guix-config-state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `daemon.am'.
  (or (getenv "NIX_STATE_DIR") "/var/guix"))

(defconst guix-config-guile-program "/gnu/store/b1r134j6gprkiq4wnqbfnc7jdm4wlir6-guile-2.0.11/bin/guile"
  "Name of the 'guile' executable defined at configure time.")

(defconst guix-config-dot-program "dot"
  "Name of the 'dot' executable defined at configure time.")

(provide 'guix-config)

;;; guix-config.el ends here
