#ifndef OSCONFIG_H
#define OSCONFIG_H

/*
** Define enclosures for include files with C linkage (mostly system headers)
*/
#ifdef __cplusplus
#define BEGIN_EXTERN_C extern "C" {
#define END_EXTERN_C }
#else
#define BEGIN_EXTERN_C
#define END_EXTERN_C
#endif


/*
** This head includes an OS/Compiler specific configuration header.
** Add entries for specific non-Unix OS/Compiler environments.
** Under Unix the default "dcmtk/config/cfunix.h" should be used.
** Since June 23rd 2010, it is also possible to configure windows and
** unix builds of DCMTK with CMake. In that case, all includes in this
** directory are _not_ used (cfunix.h, cfwin32.h, osconfig.h), since CMake
** builds osconfig.h directly and stores it in another directory.
** 
** Thus, this file is only included if DCMTK is configured traditionally
*  with configure.
*/

#ifdef HAVE_CONFIG_H
/*
** Some sort of Unix platform supported by the GNU Configure utility.
** Just include the automatically generated header file. If CMake is used
*  for configuring a unix build instead of the traditional configure method,
*  cfunix.h is not used.
*/
#include "dcmtk/config/cfunix.h"
/*
** Earlier, on windows sytems, cfwin32.h was included if DCMTK was built under
*  windows. However, now osconfig.h is now automatically generated by CMake
*  which makes this inclusion (and cfwin32.h in general) obsolete.
*  
*/
#endif

#endif /* !OSCONFIG_H*/
