/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with uyy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum uyytokentype {
     EQ = 258,
     LT = 259,
     GT = 260,
     NE = 261,
     LE = 262,
     GE = 263,
     NUL = 264,
     BOGUS = 265,
     STRING = 266,
     QUOTE = 267
   };
#endif
#define EQ 258
#define LT 259
#define GT 260
#define NE 261
#define LE 262
#define GE 263
#define NUL 264
#define BOGUS 265
#define STRING 266
#define QUOTE 267




/* Copy the first part of user declarations.  */
#line 1 "users.y"

/* This file is part of GNU Radius.
   Copyright (C) 2000,2001,2002,2003,2004 Free Software Foundation, Inc.

   Written by Sergey Poznyakoff
  
   GNU Radius is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   GNU Radius is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public
   License along with GNU Radius; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301 USA. */

#if defined(HAVE_CONFIG_H)
# include <config.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <netinet/in.h>
         
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>

#include <common.h>

#define YYMAXDEPTH 10

static grad_locus_t start_loc;

static void *closure;
static register_rule_fp add_entry;
static grad_avp_t *grad_create_pair0(char *name, int op, char *valstr);

int uyyerror(char *s);
extern int uyylex();
 


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 68 "users.y"
typedef union YYSTYPE {
        char *string;
        grad_matching_rule_t *rule;
        struct {
                grad_avp_t *lhs, *rhs;
        } descr;
        grad_avp_t *pair;
        enum grad_operator op;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 165 "users_gram.c"
# define uyystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 177 "users_gram.c"

#if ! defined (uyyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (uyyoverflow) || YYERROR_VERBOSE */


#if (! defined (uyyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union uyyalloc
{
  short uyyss;
  YYSTYPE uyyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union uyyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T uyyi;		\
	  for (uyyi = 0; uyyi < (Count); uyyi++)	\
	    (To)[uyyi] = (From)[uyyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T uyynewbytes;						\
	YYCOPY (&uyyptr->Stack, Stack, uyysize);				\
	Stack = &uyyptr->Stack;						\
	uyynewbytes = uyystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	uyyptr += uyynewbytes / sizeof (*uyyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char uyysigned_char;
#else
   typedef short uyysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  8
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   26

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  14
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  11
/* YYNRULES -- Number of rules. */
#define YYNRULES  24
/* YYNRULES -- Number of states. */
#define YYNSTATES  30

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   267

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? uyytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char uyytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    13,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char uyyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    14,    17,    20,
      22,    25,    27,    29,    31,    35,    39,    43,    45,    47,
      49,    51,    53,    55,    57
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const uyysigned_char uyyrhs[] =
{
      15,     0,    -1,    -1,    16,    -1,    17,    -1,    16,    17,
      -1,    16,     1,    -1,    18,    19,    -1,    18,     1,    -1,
      24,    -1,    20,    20,    -1,     9,    -1,    21,    -1,    22,
      -1,    21,    13,    22,    -1,    11,    23,    24,    -1,    11,
      23,    10,    -1,     3,    -1,     4,    -1,     5,    -1,     6,
      -1,     7,    -1,     8,    -1,    11,    -1,    12,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned char uyyrline[] =
{
       0,    80,    80,    81,    84,    87,    88,    94,    98,   110,
     116,   123,   127,   130,   131,   142,   146,   152,   156,   160,
     164,   168,   172,   178,   179
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const uyytname[] =
{
  "$end", "error", "$undefined", "EQ", "LT", "GT", "NE", "LE", "GE", "NUL", 
  "BOGUS", "STRING", "QUOTE", "','", "$accept", "input", "list", "entry", 
  "user", "descr", "npairlist", "pairlist", "pair", "op", "value", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short uyytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char uyyr1[] =
{
       0,    14,    15,    15,    16,    16,    16,    17,    17,    18,
      19,    20,    20,    21,    21,    22,    22,    23,    23,    23,
      23,    23,    23,    24,    24
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char uyyr2[] =
{
       0,     2,     0,     1,     1,     2,     2,     2,     2,     1,
       2,     1,     1,     1,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char uyydefact[] =
{
       2,    23,    24,     0,     0,     4,     0,     9,     1,     6,
       5,     8,    11,     0,     7,     0,    12,    13,    17,    18,
      19,    20,    21,    22,     0,    10,     0,    16,    15,    14
};

/* YYDEFGOTO[NTERM-NUM]. */
static const uyysigned_char uyydefgoto[] =
{
      -1,     3,     4,     5,     6,    14,    15,    16,    17,    24,
       7
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -9
static const uyysigned_char uyypact[] =
{
      -2,    -9,    -9,     7,     0,    -9,     4,    -9,    -9,    -9,
      -9,    -9,    -9,    13,    -9,    -3,     1,    -9,    -9,    -9,
      -9,    -9,    -9,    -9,    -8,    -9,    11,    -9,    -9,    -9
};

/* YYPGOTO[NTERM-NUM].  */
static const uyysigned_char uyypgoto[] =
{
      -9,    -9,    -9,    19,    -9,    -9,     9,    -9,    -1,    -9,
       2
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -4
static const uyysigned_char uyytable[] =
{
      -3,     9,    27,     1,     2,    11,    12,     8,    13,     1,
       2,     1,     2,    12,    26,    13,    18,    19,    20,    21,
      22,    23,    13,    10,    25,    29,    28
};

static const unsigned char uyycheck[] =
{
       0,     1,    10,    11,    12,     1,     9,     0,    11,    11,
      12,    11,    12,     9,    13,    11,     3,     4,     5,     6,
       7,     8,    11,     4,    15,    26,    24
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char uyystos[] =
{
       0,    11,    12,    15,    16,    17,    18,    24,     0,     1,
      17,     1,     9,    11,    19,    20,    21,    22,     3,     4,
       5,     6,     7,     8,    23,    20,    13,    10,    24,    22
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define uyyerrok		(uyyerrstatus = 0)
#define uyyclearin	(uyychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto uyyacceptlab
#define YYABORT		goto uyyabortlab
#define YYERROR		goto uyyerrlab1

/* Like YYERROR except do call uyyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto uyyerrlab

#define YYRECOVERING()  (!!uyyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (uyychar == YYEMPTY && uyylen == 1)				\
    {								\
      uyychar = (Token);						\
      uyylval = (Value);						\
      uyytoken = YYTRANSLATE (uyychar);				\
      YYPOPSTACK;						\
      goto uyybackup;						\
    }								\
  else								\
    { 								\
      uyyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `uyylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX uyylex (YYLEX_PARAM)
#else
# define YYLEX uyylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (uyydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (uyydebug)					\
    uyysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (uyydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      uyysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| uyy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
uyy_stack_print (short *bottom, short *top)
#else
static void
uyy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (uyydebug)							\
    uyy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
uyy_reduce_print (int uyyrule)
#else
static void
uyy_reduce_print (uyyrule)
    int uyyrule;
#endif
{
  int uyyi;
  unsigned int uyylineno = uyyrline[uyyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             uyyrule - 1, uyylineno);
  /* Print the symbols being reduced, and their result.  */
  for (uyyi = uyyprhs[uyyrule]; 0 <= uyyrhs[uyyi]; uyyi++)
    YYFPRINTF (stderr, "%s ", uyytname [uyyrhs[uyyi]]);
  YYFPRINTF (stderr, "-> %s\n", uyytname [uyyr1[uyyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (uyydebug)				\
    uyy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int uyydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef uyystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define uyystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
uyystrlen (const char *uyystr)
#   else
uyystrlen (uyystr)
     const char *uyystr;
#   endif
{
  register const char *uyys = uyystr;

  while (*uyys++ != '\0')
    continue;

  return uyys - uyystr - 1;
}
#  endif
# endif

# ifndef uyystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define uyystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
uyystpcpy (char *uyydest, const char *uyysrc)
#   else
uyystpcpy (uyydest, uyysrc)
     char *uyydest;
     const char *uyysrc;
#   endif
{
  register char *uyyd = uyydest;
  register const char *uyys = uyysrc;

  while ((*uyyd++ = *uyys++) != '\0')
    continue;

  return uyyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
uyysymprint (FILE *uyyoutput, int uyytype, YYSTYPE *uyyvaluep)
#else
static void
uyysymprint (uyyoutput, uyytype, uyyvaluep)
    FILE *uyyoutput;
    int uyytype;
    YYSTYPE *uyyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) uyyvaluep;

  if (uyytype < YYNTOKENS)
    {
      YYFPRINTF (uyyoutput, "token %s (", uyytname[uyytype]);
# ifdef YYPRINT
      YYPRINT (uyyoutput, uyytoknum[uyytype], *uyyvaluep);
# endif
    }
  else
    YYFPRINTF (uyyoutput, "nterm %s (", uyytname[uyytype]);

  switch (uyytype)
    {
      default:
        break;
    }
  YYFPRINTF (uyyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
uyydestruct (int uyytype, YYSTYPE *uyyvaluep)
#else
static void
uyydestruct (uyytype, uyyvaluep)
    int uyytype;
    YYSTYPE *uyyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) uyyvaluep;

  switch (uyytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int uyyparse (void *YYPARSE_PARAM);
# else
int uyyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int uyyparse (void);
#else
int uyyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int uyychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE uyylval;

/* Number of syntax errors so far.  */
int uyynerrs;



/*----------.
| uyyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int uyyparse (void *YYPARSE_PARAM)
# else
int uyyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
uyyparse (void)
#else
int
uyyparse ()

#endif
#endif
{
  
  register int uyystate;
  register int uyyn;
  int uyyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int uyyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int uyytoken = 0;

  /* Three stacks and their tools:
     `uyyss': related to states,
     `uyyvs': related to semantic values,
     `uyyls': related to locations.

     Refer to the stacks thru separate pointers, to allow uyyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	uyyssa[YYINITDEPTH];
  short *uyyss = uyyssa;
  register short *uyyssp;

  /* The semantic value stack.  */
  YYSTYPE uyyvsa[YYINITDEPTH];
  YYSTYPE *uyyvs = uyyvsa;
  register YYSTYPE *uyyvsp;



#define YYPOPSTACK   (uyyvsp--, uyyssp--)

  YYSIZE_T uyystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE uyyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int uyylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  uyystate = 0;
  uyyerrstatus = 0;
  uyynerrs = 0;
  uyychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  uyyssp = uyyss;
  uyyvsp = uyyvs;

  goto uyysetstate;

/*------------------------------------------------------------.
| uyynewstate -- Push a new state, which is found in uyystate.  |
`------------------------------------------------------------*/
 uyynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  uyyssp++;

 uyysetstate:
  *uyyssp = uyystate;

  if (uyyss + uyystacksize - 1 <= uyyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T uyysize = uyyssp - uyyss + 1;

#ifdef uyyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *uyyvs1 = uyyvs;
	short *uyyss1 = uyyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if uyyoverflow is a macro.  */
	uyyoverflow ("parser stack overflow",
		    &uyyss1, uyysize * sizeof (*uyyssp),
		    &uyyvs1, uyysize * sizeof (*uyyvsp),

		    &uyystacksize);

	uyyss = uyyss1;
	uyyvs = uyyvs1;
      }
#else /* no uyyoverflow */
# ifndef YYSTACK_RELOCATE
      goto uyyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= uyystacksize)
	goto uyyoverflowlab;
      uyystacksize *= 2;
      if (YYMAXDEPTH < uyystacksize)
	uyystacksize = YYMAXDEPTH;

      {
	short *uyyss1 = uyyss;
	union uyyalloc *uyyptr =
	  (union uyyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (uyystacksize));
	if (! uyyptr)
	  goto uyyoverflowlab;
	YYSTACK_RELOCATE (uyyss);
	YYSTACK_RELOCATE (uyyvs);

#  undef YYSTACK_RELOCATE
	if (uyyss1 != uyyssa)
	  YYSTACK_FREE (uyyss1);
      }
# endif
#endif /* no uyyoverflow */

      uyyssp = uyyss + uyysize - 1;
      uyyvsp = uyyvs + uyysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) uyystacksize));

      if (uyyss + uyystacksize - 1 <= uyyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", uyystate));

  goto uyybackup;

/*-----------.
| uyybackup.  |
`-----------*/
uyybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* uyyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  uyyn = uyypact[uyystate];
  if (uyyn == YYPACT_NINF)
    goto uyydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (uyychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      uyychar = YYLEX;
    }

  if (uyychar <= YYEOF)
    {
      uyychar = uyytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      uyytoken = YYTRANSLATE (uyychar);
      YYDSYMPRINTF ("Next token is", uyytoken, &uyylval, &uyylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  uyyn += uyytoken;
  if (uyyn < 0 || YYLAST < uyyn || uyycheck[uyyn] != uyytoken)
    goto uyydefault;
  uyyn = uyytable[uyyn];
  if (uyyn <= 0)
    {
      if (uyyn == 0 || uyyn == YYTABLE_NINF)
	goto uyyerrlab;
      uyyn = -uyyn;
      goto uyyreduce;
    }

  if (uyyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", uyytname[uyytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (uyychar != YYEOF)
    uyychar = YYEMPTY;

  *++uyyvsp = uyylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (uyyerrstatus)
    uyyerrstatus--;

  uyystate = uyyn;
  goto uyynewstate;


/*-----------------------------------------------------------.
| uyydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
uyydefault:
  uyyn = uyydefact[uyystate];
  if (uyyn == 0)
    goto uyyerrlab;
  goto uyyreduce;


/*-----------------------------.
| uyyreduce -- Do a reduction.  |
`-----------------------------*/
uyyreduce:
  /* uyyn is the number of a rule to reduce with.  */
  uyylen = uyyr2[uyyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  uyyval = uyyvsp[1-uyylen];


  YY_REDUCE_PRINT (uyyn);
  switch (uyyn)
    {
        case 4:
#line 85 "users.y"
    {
           }
    break;

  case 6:
#line 89 "users.y"
    {
                   grad_parser_lex_sync(); uyyerrok; uyyclearin;
           }
    break;

  case 7:
#line 95 "users.y"
    {
                   add_entry(closure, &start_loc, uyyvsp[-1].string, uyyvsp[0].descr.lhs, uyyvsp[0].descr.rhs);
           }
    break;

  case 8:
#line 99 "users.y"
    {
                   grad_log(L_ERR, _("discarding user `%s'"), uyyvsp[-1].string);
                   if (grad_parser_lex_sync() <= 0)
			   uyychar = 0; /* force end-of-file */
		   else {
			   uyyerrok;
			   uyyclearin;
		   }
           }
    break;

  case 9:
#line 111 "users.y"
    {
		   start_loc = grad_parser_source_locus;
           }
    break;

  case 10:
#line 117 "users.y"
    {
                   uyyval.descr.lhs = uyyvsp[-1].pair;
                   uyyval.descr.rhs = uyyvsp[0].pair;
           }
    break;

  case 11:
#line 124 "users.y"
    {
                   uyyval.pair = NULL;
           }
    break;

  case 14:
#line 132 "users.y"
    {
                   if (uyyvsp[-2].pair) {
                           if (uyyvsp[0].pair) 
                                   grad_avl_add_list(&uyyvsp[-2].pair, uyyvsp[0].pair);
                           uyyval.pair = uyyvsp[-2].pair;
                   } else
                           uyyval.pair = uyyvsp[0].pair;
           }
    break;

  case 15:
#line 143 "users.y"
    {
                   uyyval.pair = grad_create_pair0(uyyvsp[-2].string, uyyvsp[-1].op, uyyvsp[0].string);   
           }
    break;

  case 16:
#line 147 "users.y"
    {
                   YYERROR;
           }
    break;

  case 17:
#line 153 "users.y"
    {
                   uyyval.op = grad_operator_equal;
           }
    break;

  case 18:
#line 157 "users.y"
    {
                   uyyval.op = grad_operator_less_than;
           }
    break;

  case 19:
#line 161 "users.y"
    { 
                   uyyval.op = grad_operator_greater_than;
           }
    break;

  case 20:
#line 165 "users.y"
    {
                   uyyval.op = grad_operator_not_equal;
           }
    break;

  case 21:
#line 169 "users.y"
    {
                   uyyval.op = grad_operator_less_equal;
           }
    break;

  case 22:
#line 173 "users.y"
    {
                   uyyval.op = grad_operator_greater_equal;
           }
    break;


    }

/* Line 991 of yacc.c.  */
#line 1188 "users_gram.c"

  uyyvsp -= uyylen;
  uyyssp -= uyylen;


  YY_STACK_PRINT (uyyss, uyyssp);

  *++uyyvsp = uyyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  uyyn = uyyr1[uyyn];

  uyystate = uyypgoto[uyyn - YYNTOKENS] + *uyyssp;
  if (0 <= uyystate && uyystate <= YYLAST && uyycheck[uyystate] == *uyyssp)
    uyystate = uyytable[uyystate];
  else
    uyystate = uyydefgoto[uyyn - YYNTOKENS];

  goto uyynewstate;


/*------------------------------------.
| uyyerrlab -- here on detecting error |
`------------------------------------*/
uyyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!uyyerrstatus)
    {
      ++uyynerrs;
#if YYERROR_VERBOSE
      uyyn = uyypact[uyystate];

      if (YYPACT_NINF < uyyn && uyyn < YYLAST)
	{
	  YYSIZE_T uyysize = 0;
	  int uyytype = YYTRANSLATE (uyychar);
	  char *uyymsg;
	  int uyyx, uyycount;

	  uyycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (uyyx = uyyn < 0 ? -uyyn : 0;
	       uyyx < (int) (sizeof (uyytname) / sizeof (char *)); uyyx++)
	    if (uyycheck[uyyx + uyyn] == uyyx && uyyx != YYTERROR)
	      uyysize += uyystrlen (uyytname[uyyx]) + 15, uyycount++;
	  uyysize += uyystrlen ("syntax error, unexpected ") + 1;
	  uyysize += uyystrlen (uyytname[uyytype]);
	  uyymsg = (char *) YYSTACK_ALLOC (uyysize);
	  if (uyymsg != 0)
	    {
	      char *uyyp = uyystpcpy (uyymsg, "syntax error, unexpected ");
	      uyyp = uyystpcpy (uyyp, uyytname[uyytype]);

	      if (uyycount < 5)
		{
		  uyycount = 0;
		  for (uyyx = uyyn < 0 ? -uyyn : 0;
		       uyyx < (int) (sizeof (uyytname) / sizeof (char *));
		       uyyx++)
		    if (uyycheck[uyyx + uyyn] == uyyx && uyyx != YYTERROR)
		      {
			const char *uyyq = ! uyycount ? ", expecting " : " or ";
			uyyp = uyystpcpy (uyyp, uyyq);
			uyyp = uyystpcpy (uyyp, uyytname[uyyx]);
			uyycount++;
		      }
		}
	      uyyerror (uyymsg);
	      YYSTACK_FREE (uyymsg);
	    }
	  else
	    uyyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	uyyerror ("syntax error");
    }



  if (uyyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (uyychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (uyyss < uyyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", uyystos[*uyyssp], uyyvsp, uyylsp);
	      uyydestruct (uyystos[*uyyssp], uyyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", uyytoken, &uyylval, &uyylloc);
      uyydestruct (uyytoken, &uyylval);
      uyychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto uyyerrlab2;


/*----------------------------------------------------.
| uyyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
uyyerrlab1:

  /* Suppress GCC warning that uyyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__))
#endif


  goto uyyerrlab2;


/*---------------------------------------------------------------.
| uyyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
uyyerrlab2:
  uyyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      uyyn = uyypact[uyystate];
      if (uyyn != YYPACT_NINF)
	{
	  uyyn += YYTERROR;
	  if (0 <= uyyn && uyyn <= YYLAST && uyycheck[uyyn] == YYTERROR)
	    {
	      uyyn = uyytable[uyyn];
	      if (0 < uyyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (uyyssp == uyyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", uyystos[*uyyssp], uyyvsp, uyylsp);
      uyydestruct (uyystos[uyystate], uyyvsp);
      uyyvsp--;
      uyystate = *--uyyssp;

      YY_STACK_PRINT (uyyss, uyyssp);
    }

  if (uyyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++uyyvsp = uyylval;


  uyystate = uyyn;
  goto uyynewstate;


/*-------------------------------------.
| uyyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
uyyacceptlab:
  uyyresult = 0;
  goto uyyreturn;

/*-----------------------------------.
| uyyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
uyyabortlab:
  uyyresult = 1;
  goto uyyreturn;

#ifndef uyyoverflow
/*----------------------------------------------.
| uyyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
uyyoverflowlab:
  uyyerror ("parser stack overflow");
  uyyresult = 2;
  /* Fall through.  */
#endif

uyyreturn:
#ifndef uyyoverflow
  if (uyyss != uyyssa)
    YYSTACK_FREE (uyyss);
#endif
  return uyyresult;
}


#line 182 "users.y"


int
uyyerror(char *s)
{
	grad_log_loc(L_ERR, &grad_parser_source_locus, "%s", s);
	return 0;
}

grad_avp_t *
grad_create_pair0(char *name, int op, char *valstr)
{
	return grad_create_pair(&grad_parser_source_locus, name, op, valstr);
}

grad_avp_t *
grad_create_pair(grad_locus_t *loc, char *name, 
                 enum grad_operator op, char *valstr)
{
        grad_dict_attr_t *attr = NULL;
        grad_dict_value_t *dval;
        grad_avp_t *pair, *pair2;
        char *s;
        int x;
        time_t timeval;
        struct tm *tm, tms;
        
        if ((attr = grad_attr_name_to_dict(name)) == NULL) {
                grad_log_loc(L_ERR, loc, _("unknown attribute `%s'"),
			     name);
                return NULL;
        }

        pair = grad_avp_alloc();
        
        pair->next = NULL;
        pair->name = attr->name;
        pair->attribute = attr->value;
        pair->type = attr->type;
        pair->prop = attr->prop;
        pair->operator = op;

        if (valstr[0] == '=') {
                pair->eval_type = grad_eval_interpret;
                pair->avp_strvalue = grad_estrdup(valstr+1);
                pair->avp_strlength = strlen(pair->avp_strvalue);
                return pair;
        }

        pair->eval_type = grad_eval_const;
        
        switch (pair->type) {
        case GRAD_TYPE_STRING:
                if (pair->attribute == DA_EXEC_PROGRAM ||
                    pair->attribute == DA_EXEC_PROGRAM_WAIT) {
                        if (valstr[0] != '/' && valstr[0] != '|') {
                                grad_log_loc(L_ERR, loc,
					     _("%s: not an absolute pathname"),
					     name);
                                grad_avp_free(pair);
                                return NULL;
                        }
                }

		pair->avp_strvalue = grad_estrdup(valstr);
                pair->avp_strlength = strlen(pair->avp_strvalue);
		
		if (attr->parser && attr->parser(pair, &s)) {
			grad_log_loc(L_ERR, loc,
				     "%s %s: %s",
				     _("attribute"),
				     pair->name, s);
			free(s);
			grad_avp_free(pair);
			return NULL;
		}

                break;

        case GRAD_TYPE_INTEGER:
                /*
                 *      For DA_NAS_PORT_ID, allow a
                 *      port range instead of just a port.
                 */
                if (attr->value == DA_NAS_PORT_ID) {
                        for (s = valstr; *s; s++)
                                if (!isdigit(*s))
                                        break;
                        if (*s) {
                                pair->type = GRAD_TYPE_STRING;
                                pair->avp_strvalue = grad_estrdup(valstr);
                                pair->avp_strlength = strlen(pair->avp_strvalue);
                                break;
                        }
                }
                if (isdigit(*valstr)) {
                        pair->avp_lvalue = atoi(valstr);
                } else if ((dval = grad_value_name_to_value(valstr,
							    pair->attribute))
			         == NULL) {
                        grad_avp_free(pair);
                        grad_log_loc(L_ERR, loc,
				_("value %s is not declared for attribute %s"),
				     valstr, name);
                        return NULL;
                } else {
                        pair->avp_lvalue = dval->value;
                }
                break;

        case GRAD_TYPE_IPADDR:
                if (pair->attribute != DA_FRAMED_IP_ADDRESS) {
                        pair->avp_lvalue = grad_ip_gethostaddr(valstr);
                } else {
                        /*
                         *      We allow a "+" at the end to
                         *      indicate that we should add the
                         *      portno. to the IP address.
                         */
                        x = 0;
                        if (valstr[0]) {
                                for(s = valstr; s[1]; s++)
                                        ;
                                if (*s == '+') {
                                        *s = 0;
                                        x = 1;
                                }
                        }
                        pair->avp_lvalue = grad_ip_gethostaddr(valstr);

			if (x) {
				char *s;
				asprintf(&s, "%lu+%%{NAS-Port-Id}",
					 pair->avp_lvalue);
				pair->avp_strvalue = grad_estrdup(s);
				pair->avp_strlength = strlen(pair->avp_strvalue);
				pair->eval_type = grad_eval_interpret;
				free(s);
			}
                }
                break;
                
        case GRAD_TYPE_DATE:
                timeval = time(0);
                tm = localtime_r(&timeval, &tms);
                if (grad_parse_time_string(valstr, tm)) {
                        grad_log_loc(L_ERR, loc, _("%s: can't parse date"),
				     name);
                        grad_avp_free(pair);
                        return NULL;
                }
#ifdef TIMELOCAL
                pair->avp_lvalue = (grad_uint32_t)timelocal(tm);
#else /* TIMELOCAL */
                pair->avp_lvalue = (grad_uint32_t)mktime(tm);
#endif /* TIMELOCAL */
                break;

        default:
                grad_log_loc(L_ERR, loc,
			     _("%s: unknown attribute type %d"),
			     name, pair->type);
                grad_avp_free(pair);
                return NULL;
        }

        return pair;
}

extern int uyydebug;

int
grad_parse_rule_file(char *file, void *c, register_rule_fp f)
{
        int rc;
        
        if (grad_parser_lex_init(file))
                return -1;
        closure = c;
        add_entry = f;

        uyydebug = 0;
        rc = uyyparse();
        grad_parser_lex_finish();
        return rc;
}

void
grad_enable_rule_debug(int val)
{
        uyydebug = val;
	grad_log_loc(L_NOTICE, &grad_parser_source_locus,
		     uyydebug ? _("enabled userfile parser debugging") :
             	 	       _("disabled userfile parser debugging"));
}

