;; Quail package `chinese-ecdict
;;   Generated by the command ‘titdic-convert’
;;	Original TIT dictionary file: ECDICT.tit

;; # -*- coding: cn-big5 -*-
;; AUTORELOAD:	YES
;; AUTOSTUDY:	NO
;; FULLCODE:	YES
;; LXDIC:	NO
;; # HANZI input table for cxterm
;; # Generated from ECDICT.cit by cit2tit
;; # To be used by cxterm, convert me to .cit format first
;; # .cit version 1
;; ENCODE:	BIG5
;; MULTICHOICE:	YES
;; PROMPT: 中文輸入【英漢辭典】
;; #
;; COMMENT Copyright 1993 Oct 18 by Nelson Chin. (cyl@ifcss.org)
;; COMMENT Last Modified:  1994 Feb 26
;; COMMENT Permission to use/modify/copy for any purpose is hereby granted.
;; COMMENT Absolutely no fee and no warranties.
;; COMMENT
;; COMMENT use <CTRL-f> to move to the right
;; COMMENT use <CTRL-b> to move to the left
;; COMMENT cizu taken from crl.nmsu.edu:pub/chinese/eng-chi.b5
;; COMMENT built on top of usercz-b5 from cxterm-nf package
;; # define keys
;; VALIDINPUTKEY:	!"\043\040$%&'()*+,-./0123456789:;<=>?@[\134]^_`abcdefghijkl
;; VALIDINPUTKEY:	mnopqrstuvwxyz{|}~
;; SELECTKEY:	_\040
;; SELECTKEY:	1
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	\006
;; MOVELEFT:	\002
;; REPEATKEY:	\020\022
;; # the following line must not be removed
;; # BEGINDICTIONARY
;; BEGINPHRASE

;;; End of the header of original TIT dictionary.

;;; Code:

(require 'quail)

(quail-define-package "chinese-ecdict" "Chinese-BIG5" "英漢"
 t
"中文輸入【英漢辭典】

 Copyright 1993 Oct 18 by Nelson Chin. (cyl@ifcss.org)
 Last Modified:  1994 Feb 26
 Permission to use/modify/copy for any purpose is hereby granted.
 Absolutely no fee and no warranties.

 use <CTRL-f> to move to the right
 use <CTRL-b> to move to the left
 cizu taken from crl.nmsu.edu:pub/chinese/eng-chi.b5
 built on top of usercz-b5 from cxterm-nf package

In this input method, you enter a Chinese (Big5) character or word
by typing the corresponding English word.  For example, if you type
\"computer\", \"電腦\" is input.

\\<quail-translation-docstring>
"
 '(("\C-?" . quail-delete-last-char)
   
   
   )
 nil nil nil nil)

(quail-define-rules
("!" ["！" "﹗"])
("\"" ["“" "”" "〝" "〞" "〃"])
("#" ["＃" "﹟"])
("$" ["﹩" "￥" "￠" "￡"])
("%" ["％"])
("&" ["＆" "﹠"])
("'" ["’" "‘" "‵" "′"])
("(" ["（" "〔" "﹙" "︵" "︹" "「" "『" "﹂" "﹄"])
(")" ["）" "〕" "﹚" "︶" "︺" "」" "』" "﹁" "﹃"])
("*" ["﹡" "×" "Π" "Λ" "∩"])
("+" ["＋" "﹢" "±" "Σ" "﹀" "∪"])
("," ["，" "﹐" "、" "﹑"])
("-" ["－" "﹣" "–" "¯" "─" "～"])
("." ["．" "。" "‧" "﹒" "·" "…" "‥" "∵" "∴" "°" "⊙"])
("/" ["／" "∕" "÷" "√" "＼" "﹨"])
("0" ["０" "Ⅹ" ""])
("1" ["１" "Ⅰ" "〡" "卄"])
("2" ["２" "Ⅱ" "〢" ""])
("3" ["３" "Ⅲ" "〣"])
("4" ["４" "Ⅳ" "〤"])
("5" ["５" "Ⅴ" "〥"])
("6" ["６" "Ⅵ" "〦"])
("7" ["７" "Ⅶ" "〧"])
("8" ["８" "Ⅷ" "〨"])
("9" ["９" "Ⅸ" "〩"])
(":" ["：" "︰" "﹕"])
(";" ["；" "﹔"])
("<" ["〈" "﹤" "《" "︽" "︿" "≦"])
("=" ["＝" "﹦" "≠" "≒" "≡"])
(">" ["〉" "﹥" "》" "︾" "﹀" "≧"])
("?" ["？" "﹖"])
("@" ["＠" "⊙"])
("[" ["【" "﹝" "︻"])
("\\" ["＼" "﹨" "／" "∕"])
("]" ["】" "﹞" "︼"])
("^" ["︿"])
("_" ["╴" "﹏"])
("`" ["‘" "’" "‵" "′"])
("graph" ["▁" "▂" "▃" "▄" "▅" "▆" "▇" "█" "▏" "▎" "▍" "▌" "▋" "▊" "▉" "┼" "┴" "┬" "┤" "├" "▔" "─" "│" "▕" "┌" "┐" "└" "┘" "╭" "╮" "╰" "╯" "═" "╞" "╪" "╡" "◢" "◣" "◥" "◤" "╱" "╲" "╳"])
("logo" ["＊" "※" "§" "〃" "○" "●" "△" "▲" "◎" "☆" "★" "◇" "◆" "□" "■" "▽" "▼" "㊣" "℅" "¯" "￣" "＿" "ˍ" "﹉" "﹊" "﹍" "﹎" "﹋" "﹌"])
("math" ["＋" "－" "×" "÷" "±" "√" "＜" "＞" "＝" "≦" "≧" "≠" "∞" "≒" "≡" "﹢" "﹣" "﹤" "﹥" "﹦" "～" "∩" "∪" "⊥" "∠" "∟" "⊿" "㏒" "㏑" "∫" "∮" "∵" "∴"])
("symbol" ["♂" "♀" "⊕" "⊙" "↑" "↓" "←" "→" "↖" "↗" "↙" "↘" "∥" "∣" "／" "＼" "∕" "﹨"])
("unit" ["＄" "￥" "〒" "￠" "￡" "％" "＠" "㎜" "㎝" "㎞" "㏎" "㎡" "㎎" "㎏" "㏄" "°" "兙" "兛" "兞" "兝" "兡" "兣" "嗧" "瓩" "糎"])
("{" ["｛" "﹛" "︷"])
("|" ["｜" "∣" "︳" "│" "∥"])
("}" ["｝" "﹜" "︸"])
("~" ["～" "﹏" "∞"])
(" " ["　"])
("a" ["ａ" "Ａ"])
("b" ["ｂ" "Ｂ"])
("c" ["ｃ" "Ｃ"])
("d" ["ｄ" "Ｄ"])
("e" ["ｅ" "Ｅ"])
("f" ["ｆ" "Ｆ"])
("g" ["ｇ" "Ｇ"])
("h" ["ｈ" "Ｈ"])
("i" ["ｉ" "Ｉ"])
("j" ["ｊ" "Ｊ"])
("k" ["ｋ" "Ｋ"])
("l" ["ｌ" "Ｌ"])
("m" ["ｍ" "Ｍ"])
("n" ["ｎ" "Ｎ"])
("o" ["ｏ" "Ｏ"])
("p" ["ｐ" "Ｐ"])
("q" ["ｑ" "Ｑ"])
("r" ["ｒ" "Ｒ"])
("s" ["ｓ" "Ｓ"])
("t" ["ｔ" "Ｔ"])
("u" ["ｕ" "Ｕ"])
("v" ["ｖ" "Ｖ"])
("w" ["ｗ" "Ｗ"])
("x" ["ｘ" "Ｘ"])
("y" ["ｙ" "Ｙ"])
("z" ["ｚ" "Ｚ"])
("a" ["一個"])
("abacus" ["算盤"])
("abalone" ["鮑魚"])
("abandon" ["放棄"])
("abase" ["貶"])
("abash" ["使羞愧"])
("abbey" ["僧院"])
("abbot" ["男修道院長"])
("abbreviate" ["縮寫"])
("abdicate" ["退位" "放棄"])
("abdomen" ["腹部"])
("abduct" ["誘拐"])
("abductor" ["誘拐者"])
("abhor" ["嫌惡" "痛恨"])
("abide" ["守候"])
("ability" ["能力"])
("able" ["有能力的"])
("abnormal" ["不正常的"])
("aboard" ["在車﹐船上"])
("abolish" ["取消"])
("about" ["大約"])
("above" ["在﹍之上"])
("abrasive" ["粗厲的"])
("abridge" ["減少"])
("abroad" ["在國外"])
("abrupt" ["突然的"])
("absence" ["缺席" "缺乏"])
("absent" ["缺席的"])
("absolute" ["絕對的"])
("absorb" ["吸收"])
("absorption" ["吸收" "專心"])
("abstract" ["抽象" "大要"])
("absurd" ["可笑的"])
("abundance" ["豐富"])
("abundant" ["豐富的"])
("abuse" ["虐待" "濫用"])
("academic" ["學術的"])
("academy" ["專科院校"])
("accent" ["重音" "腔調"])
("accept" ["接受"])
("acceptable" ["合意的"])
("access" ["通路"])
("accessible" ["易接近的"])
("accident" ["意外"])
("accidental" ["意外的"])
("acclaim" ["歡呼" "喝采"])
("accommodate" ["適應"])
("accompany" ["陪同" "伴奏"])
("accomplish" ["實行" "完成"])
("accord" ["和諧" "一致"])
("accumulate" ["堆積" "增加"])
("accuracy" ["正確" "精密"])
("accurate" ["正確的"])
("accusation" ["罪狀" "罪名"])
("accuse" ["控告" "指責"])
("accustom" ["使習慣"])
("ace" ["么點"])
("ache" ["疼痛"])
("achieve" ["完成"])
("achievement" ["成就"])
("acid" ["酸性"])
("acknowledge" ["認知" "承認"])
("acknowledgment" ["答謝"])
("acquaint" ["通知"])
("acquaintance" ["熟知" "相識"])
("acquire" ["獲得"])
("acquisition" ["收穫"])
("acre" ["英畝"])
("add" ["加"])
("addict" ["有藥癮者"])
("additional" ["附加的"])
("address" ["地址" "演說"])
("adequate" ["足夠的"])
("adhere" ["附著" "固守"])
("adieu" ["再會"])
("adjacent" ["接近的"])
("adjective" ["形容辭"])
("adjoin" ["連接" "毗連"])
("adjourn" ["休會"])
("adjust" ["調整"])
("administer" ["管理"])
("admirable" ["令人欽佩的"])
("admiral" ["海軍總司令"])
("admiration" ["讚賞"])
("admire" ["敬服" "讚美"])
("admission" ["承認" "許可"])
("admit" ["容許" "招收"])
("adopt" ["收養" "採用"])
("adoption" ["收養" "採用"])
("adore" ["崇拜"])
("adult" ["成人"])
("advance" ["提高" "預付"])
("advanced" ["高級的"])
("advantage" ["優勢" "利益"])
("adventure" ["冒險"])
("adverb" ["副詞"])
("adversary" ["對抗者"])
("adversity" ["逆境"])
("advertise" ["登廣告"])
("advertisement" ["廣告"])
("advice" ["忠告"])
("advise" ["忠告"])
("adviser" ["指導教授"])
("advocate" ["鼓吹者"])
("aeroplane" ["飛機"])
("affair" ["事件"])
("affect" ["影響"])
("affection" ["愛情"])
("affectionate" ["深愛的"])
("affinity" ["姻親"])
("affirm" ["斷言"])
("afflict" ["折磨"])
("afford" ["力足以做"])
("afloat" ["浮著"])
("afraid" ["害怕"])
("after" ["後來"])
("afternoon" ["下午"])
("afterwards" ["之後"])
("again" ["再一次"])
("age" ["年齡"])
("aged" ["年老的"])
("agency" ["代理"])
("agent" ["代理人"])
("aggravate" ["激怒"])
("aggregate" ["聚集"])
("aggressive" ["氣勢洶洶的"])
("agitate" ["攪動"])
("agitation" ["攪動"])
("ago" ["以前"])
("agonize" ["煩惱"])
("agony" ["煩惱"])
("agree" ["同意"])
("agreeable" ["適意的"])
("agreement" ["契約"])
("agricultural" ["農業的"])
("agriculture" ["農業"])
("ahead" ["領先"])
("aid" ["援助"])
("ail" ["苦惱"])
("ailment" ["病"])
("aim" ["對準" "目的"])
("air" ["空氣"])
("airline" ["航空公司"])
("airmail" ["航空郵件"])
("airplane" ["飛機"])
("airport" ["飛機場"])
("airship" ["飛船"])
("airy" ["通風的"])
("aisle" ["過道"])
("alarm" ["警報"])
("album" ["像片簿"])
("alcohol" ["酒精"])
("ale" ["麥酒"])
("alert" ["警惕的"])
("algebra" ["代數"])
("alien" ["外國的"])
("alike" ["相同"])
("alive" ["活著"])
("alkali" ["鹼"])
("all" ["所有的"])
("alley" ["巷" "小徑"])
("alliance" ["同盟"])
("allied" ["同盟的"])
("alligator" ["鱷魚"])
("allow" ["允許"])
("allowance" ["津貼"])
("ally" ["同盟"])
("almanac" ["年鑑"])
("almighty" ["大能的"])
("almond" ["杏仁"])
("almost" ["幾乎"])
("aloft" ["在高處"])
("alone" ["獨自的"])
("along" ["沿著" "一同"])
("alongside" ["在﹍旁邊"])
("aloud" ["高聲"])
("alphabet" ["字母"])
("alpine" ["高山的"])
("already" ["已經"])
("also" ["也" "還"])
("altar" ["祭壇"])
("alter" ["更改"])
("alteration" ["改變"])
("alternate" ["輪流" "交替"])
("alternative" ["交替的"])
("although" ["雖然"])
("altitude" ["高度"])
("altogether" ["總共"])
("aluminum" ["鋁"])
("always" ["永遠"])
("am" ["是"])
("amateur" ["業餘者"])
("amaze" ["驚奇"])
("amazement" ["驚異"])
("amazing" ["驚人的"])
("ambassador" ["大使"])
("amber" ["琥珀"])
("ambition" ["野心"])
("ambitious" ["有雄心的"])
("ambulance" ["救護車"])
("ambush" ["埋伏"])
("amen" ["阿們"])
("amend" ["修正"])
("amendment" ["修正"])
("america" ["美洲"])
("amiable" ["可愛" "親切"])
("amid" ["在﹍之中"])
("amiss" ["錯誤的"])
("ammonia" ["氨"])
("ammunition" ["彈藥" "軍火"])
("among" ["在﹍之中"])
("amount" ["數量"])
("ample" ["豐富的"])
("amuse" ["使娛樂"])
("amusement" ["娛樂" "消遣"])
("amusing" ["有趣的"])
("an" ["一個"])
("analysis" ["分析"])
("analyze" ["解析"])
("anatomy" ["解剖學"])
("ancestor" ["祖先"])
("ancestral" ["祖先的"])
("anchor" ["錨"])
("ancient" ["古老的"])
("and" ["和"])
("anecdote" ["軼事" "奇聞"])
("anew" ["重新"])
("angel" ["天使"])
("anger" ["憤怒"])
("angle" ["角" "角度"])
("angrily" ["憤怒地"])
("angry" ["憤怒的"])
("anguish" ["痛苦" "煩悶"])
("animal" ["動物"])
("ankle" ["腳踝"])
("annals" ["編年史"])
("annex" ["附加" "合併"])
("annihilate" ["滅絕"])
("anniversary" ["周年紀念"])
("announce" ["宣佈"])
("announcement" ["通告" "告示"])
("annoy" ["苦惱"])
("annoyance" ["煩惱"])
("annual" ["周年的"])
("anoint" ["塗油於﹍"])
("another" ["另一"])
("anoxia" ["缺氧症"])
("answer" ["回答" "答案"])
("ant" ["蟻"])
("antagonist" ["對手" "敵手"])
("antarctic" ["南極的"])
("antecedent" ["先例"])
("antelope" ["羚羊"])
("antenna" ["觸角" "天線"])
("anthracite" ["無煙煤"])
("anticipate" ["預知" "預料"])
("anticipation" ["期望"])
("antique" ["古物"])
("antiquity" ["古風" "古代"])
("anvil" ["鐵砧"])
("anxiety" ["焦急"])
("anxious" ["焦急的"])
("any" ["任何"])
("anybody" ["任何人"])
("anyhow" ["無論如何"])
("anyone" ["任何人"])
("anything" ["無論何事"])
("anyway" ["無論如何"])
("anywhere" ["無論何處"])
("apart" ["分開"])
("apartment" ["公寓"])
("ape" ["無尾猿"])
("aperture" ["孔穴" "隙縫"])
("apiece" ["各自地"])
("apologize" ["道歉"])
("apology" ["道歉"])
("apostle" ["使徒"])
("apostrophe" ["省略符號"])
("appall" ["驚恐"])
("appalling" ["驚人的"])
("apparatus" ["儀器"])
("apparel" ["衣服"])
("apparent" ["明顯的"])
("appeal" ["上訴"])
("appear" ["出現"])
("appearance" ["出現" "外表"])
("appendix" ["附錄" "盲腸"])
("appetite" ["食慾"])
("applaud" ["鼓掌" "讚揚"])
("applause" ["采聲" "讚美"])
("apple" ["蘋果"])
("appliance" ["用具"])
("applicant" ["申請人"])
("application" ["申請書"])
("apply" ["申請" "應用"])
("appoint" ["任命" "指定"])
("appointment" ["職位" "約會"])
("appreciate" ["感激" "漲價"])
("appreciation" ["增值" "賞識"])
("apprehend" ["了解"])
("apprehension" ["理解"])
("apprentice" ["學徒"])
("approach" ["接近"])
("appropriate" ["適當的"])
("appropriation" ["撥用"])
("approval" ["贊成" "許可"])
("approve" ["批准"])
("approximate" ["大約"])
("apricot" ["杏仁"])
("april" ["四月"])
("apron" ["圍裙"])
("apt" ["適當的"])
("arbitrary" ["隨意的"])
("arbitration" ["仲裁"])
("arbor" ["喬木" "機軸"])
("arc" ["弧" "拱"])
("arch" ["拱形" "弧形"])
("archbishop" ["大主教"])
("archer" ["弓箭手"])
("architect" ["建築師"])
("architectural" ["建築學的"])
("architecture" ["建築學"])
("arctic" ["北極"])
("ardent" ["熱烈的"])
("ardor" ["熱忱"])
("arduous" ["險峻" "困難"])
("are" ["是"])
("area" ["面積" "範圍"])
("arena" ["競技場"])
("argue" ["爭論"])
("argument" ["辯論"])
("arise" ["起來" "出現"])
("aristocracy" ["貴族社會"])
("aristocrat" ["貴族論者"])
("aristocratic" ["貴族化"])
("arithmetic" ["算術"])
("ark" ["方舟"])
("arm" ["手臂"])
("armament" ["軍備"])
("armchair" ["靠背椅"])
("armistice" ["休戰"])
("armor" ["盔甲"])
("arms" ["武器"])
("army" ["陸軍" "軍隊"])
("around" ["大約" "附近"])
("arouse" ["喚醒" "激起"])
("arrange" ["安排"])
("arrangement" ["整理"])
("array" ["排列"])
("arrest" ["逮捕"])
("arrival" ["抵達"])
("arrive" ["到達"])
("arrow" ["箭頭"])
("art" ["藝術"])
("artery" ["動脈"])
("article" ["文章"])
("artificial" ["人造的"])
("artillery" ["大砲"])
("artisan" ["工匠"])
("artist" ["藝術家"])
("artistic" ["藝術的"])
("as" ["如"])
("ascend" ["上昇"])
("ascent" ["上昇"])
("ascertain" ["確定"])
("ash" ["灰"])
("ashamed" ["羞愧的"])
("ashore" ["岸上"])
("asia" ["亞洲"])
("aside" ["在旁邊"])
("ask" ["問"])
("asleep" ["睡著的"])
("aspect" ["樣子"])
("asphalt" ["瀝青"])
("aspiration" ["抱負"])
("aspire" ["熱望"])
("ass" ["驢子"])
("assail" ["攻擊"])
("assault" ["襲擊"])
("assay" ["試金"])
("assemble" ["組合"])
("assembly" ["集會"])
("assent" ["贊同"])
("assert" ["聲明"])
("assertion" ["斷言"])
("asset" ["資產"])
("assign" ["分派"])
("assignment" ["任務" "宿題"])
("assist" ["幫助"])
("assistance" ["援助"])
("assistant" ["助手"])
("associate" ["聯想"])
("association" ["協會"])
("assume" ["假定"])
("assumption" ["臆測"])
("assurance" ["保證"])
("assure" ["保證"])
("astonish" ["使吃驚"])
("astonishing" ["可驚的"])
("astonishment" ["驚愕"])
("astound" ["驚愕"])
("astray" ["走錯"])
("astronomer" ["天文學家"])
("astronomy" ["天文學"])
("asylum" ["庇護"])
("at" ["在"])
("athlete" ["運動家"])
("athletic" ["運動的"])
("atlantic" ["大西洋"])
("atlas" ["大地圖"])
("atmosphere" ["大氣" "氣氛"])
("atom" ["原子"])
("atomic" ["原子的"])
("attach" ["附上"])
("attachment" ["附著"])
("attack" ["攻擊"])
("attain" ["獲得"])
("attempt" ["嘗試"])
("attend" ["出席"])
("attendance" ["出席者"])
("attendant" ["隨員"])
("attention" ["注意"])
("attic" ["閣樓"])
("attire" ["服裝"])
("attitude" ["態度"])
("attorney" ["律師"])
("attract" ["吸引"])
("attraction" ["吸引"])
("attractive" ["引人注意的"])
("attribute" ["屬性"])
("auction" ["拍賣"])
("audible" ["聽得見的"])
("audience" ["聽眾" "觀眾"])
("august" ["八月"])
("aunt" ["姑媽" "姨媽"])
("austere" ["嚴厲的"])
("australia" ["澳洲"])
("authentic" ["真正的"])
("author" ["作家"])
("authoritative" ["有權威的"])
("authority" ["權威"])
("authorize" ["授權"])
("auto" ["汽車"])
("automatic" ["自動的"])
("automobile" ["汽車"])
("autumn" ["秋季"])
("available" ["可得到的"])
("avenge" ["復仇"])
("avenue" ["大路"])
("average" ["平均" "一般"])
("aviation" ["飛行"])
("avoid" ["避免"])
("awake" ["喚醒"])
("awaken" ["叫醒"])
("award" ["獎品"])
("aware" ["注意到"])
("away" ["不在"])
("awful" ["可怕的"])
("awkward" ["笨拙的"])
("ax" ["斧頭"])
("axis" ["軸"])
("axle" ["輪軸"])
("azure" ["天藍色的"])
("baby" ["嬰兒"])
("bachelor" ["學士"])
("back" ["背"])
("backbone" ["脊骨"])
("background" ["背景"])
("backward" ["向後"])
("bacon" ["燻肉"])
("bacteria" ["細菌"])
("bad" ["壞"])
("badge" ["徽章"])
("badly" ["非常的"])
("badminton" ["羽毛球"])
("baffle" ["羞辱" "破壞"])
("bag" ["袋子"])
("baggage" ["行李"])
("bait" ["餌"])
("bake" ["烘"])
("baker" ["麵包師傅"])
("baking" ["烘"])
("balance" ["平衡" "差額"])
("balcony" ["陽臺" "包廂"])
("bald" ["光禿禿"])
("ball" ["球"])
("ballad" ["短歌" "民謠"])
("balloon" ["氣球"])
("ballot" ["選票"])
("balm" ["油膏"])
("balmy" ["芳香的"])
("banana" ["香蕉"])
("band" ["帶子" "樂隊"])
("bandage" ["繃帶"])
("bandit" ["強盜" "土匪"])
("bane" ["毒害"])
("bang" ["重擊"])
("banish" ["放逐" "排斥"])
("banishment" ["驅逐" "流放"])
("bank" ["銀行" "堤岸"])
("banker" ["銀行家"])
("banking" ["銀行業"])
("bankruptcy" ["破產"])
("banner" ["旗"])
("banquet" ["宴會"])
("baptism" ["洗禮"])
("bar" ["酒廊" "障礙"])
("barbarian" ["野蠻人"])
("barbarous" ["野蠻的"])
("barber" ["理髮師"])
("bard" ["詩人"])
("bare" ["赤裸裸的"])
("barefoot" ["赤足"])
("barefooted" ["赤足的"])
("barely" ["幾乎" "僅僅"])
("bargain" ["買賣" "議價"])
("barge" ["駁船" "遊艇"])
("bark" ["樹皮"])
("barley" ["大麥"])
("barn" ["穀倉" "馬廄"])
("barometer" ["氣壓計"])
("baron" ["男爵"])
("barrack" ["收留所"])
("barrel" ["大桶" "鎗管"])
("barren" ["不毛的"])
("barrier" ["欄柵" "障礙"])
("base" ["基礎"])
("baseball" ["棒球"])
("basement" ["地下室"])
("bashful" ["怕羞的"])
("basic" ["基本的"])
("basin" ["水盆" "盆地"])
("basis" ["根本"])
("basket" ["籃子"])
("basketball" ["籃球"])
("bass" ["低音"])
("bat" ["球棒" "蝙蝠"])
("bath" ["沐浴" "浴室"])
("bathe" ["洗澡"])
("bathroom" ["浴室"])
("battalion" ["軍隊"])
("batter" ["連擊"])
("battery" ["電池" "砲臺"])
("battle" ["戰爭"])
("battleship" ["主力艦"])
("bawl" ["呼喊"])
("bay" ["海灣"])
("bayonet" ["刺刀"])
("bazaar" ["市場"])
("be" ["是"])
("beach" ["海灘"])
("bead" ["珠子"])
("beak" ["鳥嘴"])
("beam" ["橫樑" "光束"])
("bean" ["豆子"])
("bear" ["熊" "忍受"])
("beard" ["鬍鬚"])
("bearer" ["負擔者"])
("bearing" ["態度" "位置"])
("beast" ["野獸"])
("beat" ["敲打" "跳動"])
("beaten" ["疲憊" "破敗"])
("beating" ["鞭打" "脈欂"])
("beau" ["美好的"])
("beautiful" ["美麗的"])
("beauty" ["美人"])
("beaver" ["海狸"])
("because" ["因為"])
("beckon" ["點頭招呼"])
("become" ["變成"])
("bed" ["床"])
("bedroom" ["臥室"])
("bedside" ["床側"])
("bedtime" ["就寢時間"])
("bee" ["蜂"])
("beech" ["櫸木"])
("beef" ["牛肉"])
("beer" ["啤酒"])
("beet" ["甜菜"])
("beetle" ["甲蟲"])
("befall" ["遭遇" "降臨"])
("before" ["以前"])
("beforehand" ["預先"])
("befriend" ["援助"])
("beg" ["懇求"])
("beggar" ["乞丐"])
("begin" ["開始"])
("beginner" ["初學者"])
("beginning" ["開頭"])
("behalf" ["利益"])
("behave" ["舉動"])
("behavior" ["行為"])
("behead" ["斬首"])
("behind" ["在後"])
("behold" ["注視"])
("being" ["生命" "存在"])
("belief" ["信任"])
("believe" ["相信"])
("believer" ["信徒"])
("bell" ["鐘"])
("belle" ["美人"])
("bellow" ["怒吼"])
("bellows" ["風箱"])
("belly" ["腹部"])
("belong" ["屬於"])
("belongings" ["所有物"])
("beloved" ["心愛的"])
("below" ["在﹍之下"])
("belt" ["帶子"])
("bench" ["長椅"])
("bend" ["彎曲"])
("beneath" ["在下方"])
("beneficial" ["有利的"])
("benefit" ["利益"])
("benevolent" ["仁慈的"])
("bent" ["彎曲"])
("bequeath" ["遺贈"])
("berry" ["漿果"])
("berth" ["臥位"])
("beseech" ["請願"])
("beset" ["包圍"])
("beside" ["在﹍之旁"])
("besides" ["此外"])
("besiege" ["圍攻"])
("best" ["最好的"])
("bestow" ["授與"])
("bet" ["打賭"])
("betray" ["出賣" "背叛"])
("better" ["較好的"])
("between" ["在﹍之間"])
("betwixt" ["中間"])
("beverage" ["飲料"])
("bewail" ["悲歎"])
("beware" ["小心"])
("bewilder" ["困惑"])
("bewitch" ["迷惑"])
("beyond" ["超過"])
("bias" ["偏差"])
("bib" ["圍兜"])
("bible" ["聖經"])
("bicycle" ["自行車"])
("bid" ["出價"])
("big" ["大的"])
("bill" ["帳單" "鈔票"])
("billiards" ["計數者"])
("billion" ["十億"])
("billow" ["大浪"])
("bin" ["箱子"])
("bind" ["包紮"])
("binding" ["約束"])
("biography" ["傳記"])
("biology" ["生物學"])
("birch" ["樺木"])
("bird" ["鳥"])
("birth" ["出生"])
("birthday" ["生日"])
("birthplace" ["出生地"])
("birthright" ["生有權"])
("biscuit" ["餅乾"])
("bishop" ["主教"])
("bit" ["一點"])
("bite" ["咬"])
("bitter" ["苦的"])
("bituminous" ["瀝青的"])
("black" ["黑色"])
("blackberry" ["黑莓子"])
("blackboard" ["黑板"])
("blacksmith" ["鐵匠"])
("blade" ["刀葉"])
("blame" ["責備"])
("blank" ["空白的"])
("blanket" ["毛毯"])
("blast" ["疾風" "爆炸"])
("blaze" ["火焰"])
("bleach" ["漂白"])
("bleed" ["流血"])
("blend" ["混合"])
("bless" ["保佑"])
("blessed" ["幸福的"])
("blessing" ["祝福"])
("blind" ["瞎的"])
("blink" ["霎眼"])
("blister" ["水泡"])
("block" ["木塊" "街段"])
("blockade" ["封鎖"])
("blond" ["金髮的"])
("blood" ["血"])
("bloody" ["殘忍的"])
("bloom" ["花開"])
("blossom" ["群花"])
("blot" ["污痕"])
("blouse" ["上衫"])
("blow" ["吹"])
("blue" ["藍色"])
("bluff" ["虛張聲勢"])
("blunder" ["大錯"])
("blunt" ["鈍的"])
("blur" ["朦朧"])
("blush" ["害羞"])
("boar" ["公豬"])
("board" ["板"])
("boarder" ["寄宿生"])
("boast" ["自誇"])
("boat" ["小船"])
("body" ["身體"])
("boil" ["煮熟" "燒開"])
("bold" ["大膽的"])
("bolt" ["門栓"])
("bomb" ["炸彈"])
("bond" ["證券"])
("bone" ["骨"])
("bonnet" ["蘇格蘭帽"])
("bonus" ["紅利"])
("book" ["書"])
("bookcase" ["書架"])
("bookkeeper" ["記帳員"])
("booklet" ["小冊子"])
("bookseller" ["書店"])
("boot" ["長靴"])
("booth" ["攤子"])
("border" ["邊界"])
("bore" ["鑽孔"])
("born" ["天性的"])
("borough" ["區"])
("borrow" ["借"])
("bosom" ["胸"])
("boss" ["上司"])
("botanical" ["植物的"])
("botany" ["植物學"])
("both" ["兩者的"])
("bother" ["煩擾"])
("bottle" ["瓶子"])
("bottom" ["底"])
("boulder" ["圓石頭"])
("bounce" ["亂跳,退票"])
("boundary" ["界限"])
("bouquet" ["花束"])
("bow" ["弓"])
("bowel" ["腸"])
("bowl" ["一碗"])
("box" ["箱"])
("boxing" ["拳擊"])
("boy" ["男孩子"])
("boyish" ["孩子氣"])
("brace" ["支柱"])
("bracelet" ["手鐲"])
("bracket" ["托架"])
("brag" ["吹牛"])
("braid" ["髮辮"])
("brain" ["腦"])
("branch" ["分枝" "支店"])
("brand" ["商標"])
("brass" ["黃銅"])
("brave" ["勇敢"])
("bravery" ["英勇"])
("bread" ["麵包"])
("breadth" ["闊度"])
("break" ["打破"])
("breakfast" ["早餐"])
("breast" ["胸"])
("breath" ["氣息"])
("breathe" ["呼吸"])
("breathless" ["氣喘喘的"])
("breed" ["品種"])
("breeding" ["孵化"])
("breeze" ["和風"])
("brew" ["釀造"])
("bribe" ["賄絡"])
("brick" ["磚"])
("bride" ["新娘"])
("bridegroom" ["新郎"])
("bridge" ["橋"])
("brief" ["短簡的"])
("briefly" ["簡單地"])
("brigade" ["隊"])
("bright" ["光亮的"])
("brightness" ["明亮"])
("brilliant" ["閃亮,才氣"])
("bring" ["攜帶"])
("brisk" ["活潑的"])
("bristle" ["剛毛"])
("brittle" ["易碎的"])
("broad" ["闊的"])
("broadcast" ["廣播"])
("broil" ["烤"])
("broken" ["破的"])
("broker" ["經紀人"])
("bronze" ["青銅"])
("brooch" ["胸針"])
("brook" ["小河"])
("broom" ["掃帚"])
("broth" ["清湯"])
("brother" ["兄弟"])
("brow" ["眉"])
("brown" ["褐色"])
("bruise" ["打傷"])
("brush" ["毛刷"])
("brutal" ["獸性的"])
("brute" ["無理性的"])
("bubble" ["氣泡"])
("buck" ["雄鹿"])
("bucket" ["水桶"])
("buckle" ["帶釦"])
("bud" ["芽"])
("budget" ["預算"])
("buff" ["淺黃色"])
("buffalo" ["水牛"])
("bug" ["飛蟲"])
("build" ["建築"])
("building" ["建築物"])
("bulb" ["電燈泡"])
("bulge" ["脹起"])
("bulk" ["大部份"])
("bull" ["公牛"])
("bulldog" ["牛頭犬"])
("bullet" ["子彈"])
("bulletin" ["公報"])
("bullion" ["金銀塊"])
("bump" ["碰撞"])
("bun" ["圓形麵包"])
("bunch" ["串"])
("bundle" ["捆" "束"])
("bungalow" ["平房"])
("bunk" ["床鋪"])
("bunny" ["栗鼠"])
("buoy" ["浮標"])
("burden" ["負重擔"])
("bureau" ["局" "部" "處"])
("burglar" ["竊盜"])
("burial" ["葬禮"])
("burn" ["燒"])
("burst" ["破裂"])
("bury" ["埋葬"])
("bus" ["公共汽車"])
("bush" ["灌木"])
("business" ["商業"])
("busy" ["忙"])
("but" ["但是"])
("butcher" ["屠夫"])
("butler" ["傭人領班"])
("butter" ["牛油"])
("butterfly" ["蝴蝶"])
("button" ["釦子"])
("buy" ["買"])
("buzz" ["電話鈴聲"])
("by" ["經" "在旁"])
("cab" ["計乘車"])
("cabbage" ["甘藍菜"])
("cabin" ["小屋"])
("cabinet" ["小型櫃櫥"])
("cable" ["電報"])
("cafe" ["咖啡店"])
("cage" ["鳥籠"])
("cake" ["西薄"])
("calcium" ["鈣"])
("calculate" ["計算"])
("calculation" ["計算"])
("calendar" ["日曆"])
("calf" ["小牛"])
("call" ["喊,叫"])
("calm" ["冷靜"])
("calorie" ["卡"])
("camel" ["駱駝"])
("camera" ["照相機"])
("camp" ["露營"])
("campaign" ["競選活動"])
("campus" ["校園"])
("can" ["能"])
("canada" ["加拿大"])
("canal" ["運河"])
("canary" ["金絲雀"])
("cancel" ["取消"])
("cancer" ["癌"])
("candidate" ["候選人"])
("candle" ["蠟燭"])
("candor" ["美洲兀鷹"])
("candy" ["糖果"])
("cane" ["甘蔗" "手杖"])
("cannon" ["大炮"])
("cannot" ["不能"])
("canoe" ["獨木舟"])
("canopy" ["天篷" "垂幕"])
("canto" ["篇章"])
("canton" ["區" "郡"])
("canvas" ["帆布"])
("canyon" ["峽谷"])
("cap" ["便帽" "套子"])
("capable" ["有才幹的"])
("capacity" ["容量" "能力"])
("cape" ["海角"])
("caper" ["戲弄"])
("capital" ["首都" "資本"])
("capitalist" ["資本家"])
("captain" ["領隊"])
("captive" ["俘虜"])
("captivity" ["囚禁"])
("capture" ["虜獲"])
("car" ["汽車"])
("caramel" ["焦糖"])
("caravan" ["商隊"])
("carbon" ["複寫紙"])
("carbonic" ["含碳的"])
("carcass" ["殘骸"])
("card" ["卡片" "紙牌"])
("cardinal" ["主要的"])
("care" ["照顧" "操心"])
("career" ["職業" "經歷"])
("careful" ["小心的"])
("careless" ["粗心的"])
("caress" ["撫抱"])
("cargo" ["船貨"])
("carnival" ["嘉年華會"])
("carol" ["頌歌"])
("carp" ["鯉魚"])
("carpenter" ["木匠"])
("carpet" ["地毯"])
("carriage" ["馬車" "車廂"])
("carrier" ["航空母艦"])
("carrot" ["紅蘿蔔"])
("carry" ["搬運"])
("cart" ["手拉車"])
("carve" ["雕刻"])
("cascade" ["小瀑布"])
("case" ["盒子" "案子"])
("casement" ["窗子"])
("cash" ["現款"])
("cashier" ["出納員"])
("cask" ["木桶"])
("casket" ["小木盒"])
("cast" ["拋" "投"])
("castle" ["城堡"])
("casual" ["非正式的"])
("cat" ["貓"])
("catalog" ["目錄"])
("cataract" ["洪流" "翳眼"])
("catastrophe" ["災難" "悲劇"])
("catch" ["捕捉"])
("catcher" ["捕手"])
("category" ["分類"])
("caterpillar" ["毛蟲"])
("cathedral" ["大教堂"])
("catholic" ["天主教"])
("cattle" ["牛" "家畜"])
("cause" ["理由" "目標"])
("caution" ["小心" "警告"])
("cautious" ["小心的"])
("cavalier" ["騎士" "豪俠"])
("cavalry" ["騎兵"])
("cave" ["洞穴"])
("cavern" ["大地洞"])
("cavity" ["凹洞"])
("cease" ["停止"])
("cedar" ["西洋杉"])
("ceiling" ["天花板"])
("celebrate" ["慶祝"])
("celebrated" ["著名的"])
("celebration" ["典禮"])
("celery" ["芹菜"])
("celestial" ["天上的"])
("cell" ["細胞" "密室"])
("cellar" ["地下室"])
("celluloid" ["假象牙"])
("cement" ["水泥"])
("cemetery" ["墓地"])
("censure" ["責難"])
("census" ["人口調查"])
("cent" ["一分錢"])
("center" ["中心"])
("centigram" ["厘克"])
("centiliter" ["厘升"])
("centimeter" ["厘米"])
("central" ["中心的"])
("century" ["世紀"])
("cereal" ["穀類"])
("ceremony" ["典禮"])
("certain" ["確實"])
("certainly" ["必然地"])
("certainty" ["毫無疑問"])
("certificate" ["証書"])
("chain" ["鏈子"])
("chair" ["椅子"])
("chairman" ["主席" "會長"])
("chalk" ["粉筆"])
("challenge" ["挑戰"])
("chamber" ["房間" "議會"])
("chamberlain" ["內臣"])
("champion" ["冠軍"])
("chance" ["機會"])
("chancellor" ["大臣"])
("chandelier" ["吊燈"])
("change" ["改變"])
("channel" ["海峽" "途徑"])
("chant" ["歌謠"])
("chaos" ["凌亂"])
("chap" ["家伙" "皴裂"])
("chapel" ["小禮拜堂"])
("chaplain" ["牧師"])
("chapter" ["篇章" "分會"])
("character" ["性格"])
("characteristic" ["特徵"])
("charcoal" ["木炭"])
("charge" ["控告" "記帳"])
("charger" ["充電器"])
("chariot" ["四輪馬車"])
("charitable" ["仁慈的"])
("charity" ["慈善機構"])
("charm" ["魅力"])
("charming" ["迷人的"])
("chart" ["地圖" "圖表"])
("charter" ["特許狀"])
("chase" ["追逐"])
("chasm" ["裂痕"])
("chaste" ["有道德的"])
("chat" ["閒談"])
("chatter" ["喋喋不休"])
("chauffeur" ["司機"])
("cheap" ["便宜的"])
("cheat" ["欺騙"])
("check" ["帳單" "檢查"])
("cheek" ["臉頰"])
("cheer" ["歡呼" "喝采"])
("cheerful" ["愉快的"])
("cheerily" ["愉快地"])
("cheery" ["快樂的"])
("cheese" ["乾酪"])
("chemical" ["化學的"])
("chemise" ["女用內衣"])
("chemist" ["化學家"])
("chemistry" ["化學"])
("cherish" ["珍愛"])
("cherry" ["櫻桃"])
("chess" ["西洋棋"])
("chest" ["胸部"])
("chestnut" ["栗子"])
("chew" ["咀嚼"])
("chick" ["小雞"])
("chicken" ["雞"])
("chide" ["喝叱"])
("chief" ["領袖"])
("chiefly" ["多半地"])
("child" ["小孩"])
("childhood" ["童年"])
("childish" ["孩子氣的"])
("chill" ["寒冷"])
("chilly" ["寒冷的"])
("chime" ["套鐘"])
("chimney" ["煙囪"])
("chin" ["下巴"])
("china" ["中國" "瓷器"])
("chinese" ["中國人"])
("chink" ["裂縫"])
("chip" ["碎片"])
("chirp" ["蟲鳥叫聲"])
("chisel" ["鑿子"])
("chivalry" ["騎士氣概"])
("chocolate" ["巧克力"])
("choice" ["選擇"])
("choir" ["唱詩班"])
("choke" ["窒息"])
("cholera" ["霍亂"])
("choose" ["選擇"])
("chop" ["砍" "剁"])
("chord" ["琴弦"])
("chorus" ["合唱團"])
("chosen" ["精選的"])
("christ" ["基督"])
("christian" ["基督教徒"])
("christmas" ["聖誕節"])
("chronicle" ["編年史"])
("chuckle" ["咯咯笑"])
("church" ["教堂"])
("churchman" ["教士" "牧師"])
("churchyard" ["教堂墓地"])
("cider" ["果汁" "果酒"])
("cigar" ["雪茄煙"])
("cigaret" ["紙煙"])
("cinder" ["煤屑"])
("cinema" ["電影院"])
("cinnamon" ["肉桂"])
("circle" ["圓"])
("circuit" ["電路"])
("circular" ["圓的"])
("circulate" ["循環"])
("circulation" ["發行額"])
("circumference" ["圓周"])
("circumstance" ["境遇"])
("circus" ["馬戲團"])
("cite" ["引證"])
("citizen" ["公民"])
("city" ["市"])
("civic" ["市民的"])
("civil" ["民事的"])
("civilian" ["平民"])
("civilization" ["文明"])
("civilize" ["文明化"])
("claim" ["索賠"])
("clam" ["蚶"])
("clan" ["氏族"])
("clap" ["拍手"])
("class" ["種類" "學級"])
("classic" ["古典派的"])
("classical" ["古典的"])
("classification" ["分類"])
("classify" ["分類"])
("classmate" ["同班同學"])
("classroom" ["教室"])
("clause" ["短句"])
("claw" ["爪"])
("clay" ["泥土"])
("clean" ["清潔"])
("cleaner" ["清潔器"])
("clear" ["清楚"])
("clearly" ["明顯地"])
("cleave" ["劈開"])
("clergy" ["教士"])
("clergyman" ["牧師"])
("clerk" ["書記"])
("clever" ["聰明"])
("client" ["顧客"])
("cliff" ["懸岩"])
("climate" ["氣候"])
("climax" ["頂點"])
("climb" ["爬"])
("cling" ["黏住"])
("clinic" ["診所"])
("clip" ["紙夾"])
("cloak" ["斗篷"])
("cloakroom" ["衣帽間"])
("clock" ["鐘"])
("cloister" ["寺院"])
("close" ["關閉"])
("closet" ["壁櫥"])
("cloth" ["布"])
("clothes" ["衣服"])
("clothing" ["衣服"])
("cloud" ["雲"])
("cloudy" ["陰天的"])
("clown" ["小丑"])
("club" ["棍棒"])
("clumsy" ["笨拙的"])
("cluster" ["串"])
("coach" ["客車"])
("coal" ["煤"])
("coarse" ["粗劣的"])
("coast" ["海岸"])
("coat" ["外套"])
("cobweb" ["蜘蛛網"])
("cock" ["公雞"])
("cocktail" ["雞尾酒"])
("cocoa" ["可可"])
("coconut" ["椰子"])
("code" ["略碼"])
("coffee" ["咖啡"])
("coffin" ["棺材"])
("coil" ["捲"])
("coin" ["硬幣"])
("coincidence" ["巧合"])
("cold" ["冷" "傷風"])
("collapse" ["塌下" "崩潰"])
("collar" ["硬領"])
("colleague" ["同事"])
("collect" ["收集"])
("collection" ["珍藏"])
("college" ["學院"])
("colonel" ["陸軍上校"])
("colonial" ["殖民的"])
("colony" ["殖民地"])
("color" ["顏色"])
("colorful" ["富色彩的"])
("colt" ["小馬"])
("column" ["圓柱"])
("comb" ["梳"])
("combat" ["戰鬥"])
("combination" ["結合"])
("combine" ["結合"])
("combustion" ["燃燒"])
("come" ["來"])
("comedy" ["喜劇"])
("comet" ["彗星"])
("comfort" ["安慰"])
("comfortable" ["舒服的"])
("comforter" ["棉被"])
("comic" ["連環圖"])
("comical" ["滑稽的"])
("coming" ["來臨"])
("comma" ["逗點"])
("command" ["命令"])
("commander" ["指揮官"])
("commandment" ["戒律"])
("commence" ["開始" "著手"])
("commencement" ["開始"])
("commend" ["推薦"])
("comment" ["註解"])
("commentary" ["評註"])
("commerce" ["貿易"])
("commercial" ["商務的"])
("commission" ["佣金"])
("commissioner" ["委員"])
("commit" ["委任" "監禁"])
("committee" ["委員會"])
("commodity" ["商品"])
("common" ["共同的"])
("commonplace" ["平凡的"])
("commonwealth" ["聯邦"])
("commotion" ["暴亂" "動盪"])
("commune" ["密談"])
("communicate" ["溝通"])
("communication" ["聯絡"])
("communion" ["交誼"])
("communism" ["共產主義"])
("communist" ["共產黨員"])
("community" ["社區" "體團"])
("compact" ["緊密" "小型"])
("companion" ["同伴"])
("companionship" ["友誼"])
("company" ["公司" "陪伴"])
("comparable" ["可比的"])
("comparative" ["比較的"])
("comparatively" ["比較地"])
("compare" ["比較"])
("comparison" ["比擬"])
("compartment" ["間隔"])
("compass" ["羅盤" "周圍"])
("compassion" ["同情"])
("compel" ["強迫"])
("compensate" ["賠償"])
("compensation" ["賠償金"])
("compete" ["競爭"])
("competent" ["能幹的"])
("competition" ["比賽"])
("competitive" ["競爭的"])
("competitor" ["對手"])
("compile" ["編輯"])
("complain" ["抱怨"])
("complaint" ["原告"])
("complement" ["附加物"])
("complete" ["完全的"])
("completion" ["完成"])
("complex" ["複合的"])
("complexion" ["氣色" "形勢"])
("complicate" ["惡化"])
("complicated" ["複雜地"])
("complication" ["糾紛"])
("compliment" ["稱讚" "道賀"])
("comply" ["同意"])
("compose" ["組成"])
("composed" ["安然的"])
("composer" ["作家"])
("composition" ["作文"])
("composure" ["鎮靜"])
("compound" ["複合"])
("comprehend" ["了解"])
("comprehensive" ["廣泛的"])
("compress" ["壓緊"])
("comprise" ["包含"])
("compromise" ["妥協"])
("compulsory" ["強迫的"])
("compute" ["計算"])
("computer" ["電腦"])
("comrade" ["同伴"])
("conceal" ["隱藏"])
("concede" ["承認" "讓步"])
("conceit" ["自負" "意念"])
("conceivable" ["可想像的"])
("conceive" ["構想" "表達"])
("concentrate" ["專心" "濃縮" "集中" "專心"])
("concentration" ["專心" "濃縮"])
("conception" ["想像力"])
("concern" ["關注"])
("concerned" ["掛念的"])
("concerning" ["關於"])
("concert" ["音樂會"])
("concession" ["讓步"])
("concise" ["簡明的"])
("conclude" ["結束"])
("conclusion" ["結論" "結局"])
("concord" ["和諧"])
("concrete" ["實在的"])
("condemn" ["反對"])
("condense" ["緊縮"])
("condition" ["條件" "狀況"])
("conduct" ["處理" "引導"])
("conductor" ["指揮者"])
("cone" ["圓錐體"])
("confederacy" ["同盟"])
("confederate" ["同盟的"])
("confederation" ["同盟國"])
("confer" ["頒給"])
("conference" ["研討會"])
("confess" ["承認" "懺悔"])
("confession" ["自白書"])
("confide" ["信賴"])
("confidence" ["自信" "秘密"])
("confident" ["確信的"])
("confidential" ["機密的"])
("confine" ["限制"])
("confirm" ["證實"])
("confirmation" ["證明"])
("confiscate" ["沒收"])
("conflict" ["衝突"])
("conform" ["符合"])
("confound" ["驚訝"])
("confront" ["面對"])
("confuse" ["混亂"])
("confusion" ["迷亂"])
("congenial" ["意氣相投的"])
("congratulate" ["祝賀" "慶賀"])
("congratulation" ["祝賀"])
("congregation" ["集合"])
("congress" ["國會"])
("congressman" ["國會議員"])
("conjecture" ["推測"])
("conjugation" ["連合"])
("conjunction" ["連接詞"])
("conjure" ["使魔法"])
("connect" ["連接"])
("connection" ["聯繫"])
("conquer" ["征服"])
("conqueror" ["征服者"])
("conquest" ["勝利"])
("conscience" ["良心"])
("conscientious" ["有良心的"])
("conscious" ["有意識的"])
("consciousness" ["意識"])
("consecrate" ["奉獻"])
("consent" ["同意"])
("consequence" ["結果"])
("consequent" ["來自"])
("consequently" ["因此"])
("conservation" ["保護區"])
("conservative" ["保守的"])
("conserve" ["保存"])
("consider" ["考慮"])
("considerable" ["值得考慮的"])
("considerably" ["非常地"])
("considerate" ["體貼的"])
("consideration" ["顧慮"])
("considering" ["就﹍而言"])
("consign" ["移交"])
("consist" ["包含"])
("consistent" ["一致的"])
("consolation" ["慰藉"])
("console" ["安慰"])
("consolidate" ["鞏固"])
("consonant" ["子音"])
("consort" ["配偶"])
("conspicuous" ["明顯的"])
("conspiracy" ["陰謀"])
("conspire" ["圖謀"])
("constable" ["警官"])
("constancy" ["持久性"])
("constant" ["不變的"])
("constantly" ["持續地"])
("constellation" ["星座"])
("constituent" ["有選舉權的"])
("constitute" ["組成"])
("constitution" ["構造" "憲法"])
("constraint" ["拘禁"])
("construct" ["構成"])
("construction" ["建築"])
("constructive" ["建設性的"])
("consul" ["領事"])
("consult" ["請教" "商量"])
("consultation" ["會議"])
("consume" ["消耗"])
("consumer" ["消費者"])
("consummate" ["完成"])
("consumption" ["消耗量"])
("contact" ["接觸"])
("contagious" ["會傳染的"])
("contain" ["容納"])
("contemplate" ["注視" "沈思"])
("contemplation" ["沈思" "期望"])
("contemporary" ["同時代的"])
("contempt" ["輕視"])
("contemptuous" ["輕視的"])
("contend" ["競爭" "爭論"])
("content" ["使滿意"])
("contented" ["滿足的"])
("contention" ["爭論點"])
("contentment" ["滿足"])
("contest" ["競爭"])
("continent" ["大陸"])
("continental" ["大陸的"])
("continual" ["不斷的"])
("continuation" ["繼續"])
("continue" ["繼續"])
("continuous" ["連續的"])
("contract" ["契約"])
("contraction" ["縮短"])
("contractor" ["承包人"])
("contradict" ["牴觸"])
("contrary" ["相反"])
("contrast" ["對照"])
("contribute" ["投稿" "貢獻"])
("contribution" ["捐贈"])
("control" ["控制"])
("controversy" ["論爭"])
("convenience" ["便利"])
("convenient" ["便利的"])
("convent" ["女修道"])
("convention" ["會議"])
("conventional" ["慣例的"])
("conversation" ["談話"])
("conversion" ["變換"])
("convert" ["轉換"])
("convey" ["傳達"])
("convict" ["定罪" "囚犯"])
("conviction" ["悔罪"])
("convince" ["使信服"])
("convincing" ["使人信服的"])
("cook" ["煮" "廚司"])
("cookery" ["烹調術"])
("cookie" ["餅乾"])
("cool" ["涼快"])
("cooperate" ["合力"])
("cooperation" ["合作"])
("cooperative" ["合作的"])
("coordinate" ["座標"])
("cope" ["應付"])
("copper" ["銅"])
("copy" ["複本" "拷貝"])
("copyright" ["版權"])
("coral" ["珊瑚"])
("cord" ["繩子"])
("core" ["核心"])
("cork" ["軟木塞"])
("corn" ["玉蜀黍"])
("corner" ["角落"])
("corporal" ["肉體的"])
("corporation" ["有限公司"])
("corps" ["軍團"])
("corpse" ["屍體"])
("correct" ["對的"])
("correction" ["改正"])
("correctly" ["正確地"])
("correspond" ["相應" "通信"])
("correspondent" ["通信" "一致"])
("corridor" ["走廊"])
("corrupt" ["敗壞的"])
("corruption" ["腐敗"])
("cost" ["成本"])
("costly" ["昂貴的"])
("costume" ["服裝"])
("cot" ["茅屋"])
("cottage" ["茅舍"])
("cotton" ["棉"])
("couch" ["睡椅"])
("cough" ["咳嗽"])
("council" ["評議會"])
("counselor" ["顧問"])
("count" ["計算"])
("countenance" ["容貌"])
("counter" ["櫃臺"])
("counterfeit" ["仿造的"])
("countless" ["數不盡的"])
("country" ["國"])
("county" ["郡"])
("couple" ["一對"])
("courage" ["勇氣"])
("courageous" ["有膽量的"])
("course" ["路程"])
("court" ["法院"])
("courteous" ["有禮貌的"])
("courtesy" ["禮貌"])
("courtyard" ["中庭"])
("cousin" ["堂" "表親"])
("covenant" ["聖約"])
("cover" ["覆蓋"])
("cow" ["母牛"])
("coward" ["懦夫"])
("cowardice" ["膽小"])
("cowboy" ["牛仔"])
("cozy" ["舒適的"])
("crab" ["蟹"])
("crack" ["爆裂"])
("cracker" ["爆竹"])
("crackle" ["裂紋"])
("cradle" ["搖籃"])
("craft" ["手藝"])
("crafty" ["狡猾的"])
("cram" ["填滿" "死記"])
("cramp" ["夾子"])
("crane" ["起重機"])
("crash" ["粉碎"])
("crate" ["條板箱"])
("crave" ["切望"])
("crawl" ["爬"])
("crayon" ["蠟筆"])
("craze" ["狂熱"])
("crazy" ["發狂的"])
("cream" ["奶油"])
("create" ["創造"])
("creation" ["創作"])
("creature" ["動物"])
("credit" ["信用"])
("creditor" ["債權人"])
("creed" ["教義"])
("creep" ["爬"])
("crescent" ["新月"])
("crest" ["雞冠"])
("crew" ["全體人員"])
("cricket" ["蟋蟀"])
("crime" ["犯罪"])
("criminal" ["罪犯"])
("crimson" ["艷紅色"])
("cripple" ["身體障害的"])
("crisis" ["危機"])
("crisp" ["脆的"])
("critic" ["批評家"])
("critical" ["危急的"])
("criticism" ["評論"])
("criticize" ["非議"])
("crocodile" ["鱷魚"])
("crook" ["屈曲,騙子"])
("crop" ["農作物"])
("cross" ["交叉"])
("crow" ["烏鴉"])
("crowd" ["群眾"])
("crowded" ["擁擠的"])
("crown" ["王冠"])
("crude" ["粗糙的"])
("cruel" ["殘酷的"])
("cruelty" ["殘酷"])
("cruise" ["巡弋"])
("crumb" ["屑"])
("crumble" ["弄碎"])
("crumple" ["弄皺"])
("crusade" ["十字軍"])
("crush" ["壓碎"])
("crust" ["麵包皮"])
("cry" ["哭" "喊"])
("crystal" ["水晶"])
("cub" ["幼獸"])
("cube" ["立方體"])
("cubic" ["立方體的"])
("cuckoo" ["杜鵑鳥"])
("cucumber" ["黃瓜"])
("cuff" ["袖口"])
("cultivate" ["養殖"])
("cultivation" ["養殖"])
("culture" ["文化"])
("cunning" ["狡猾的"])
("cup" ["茶杯"])
("cupboard" ["碗櫃"])
("curb" ["路邊"])
("cure" ["治癒"])
("curiosity" ["好奇心"])
("curious" ["有好奇心的"])
("curl" ["捲曲"])
("curly" ["捲曲的"])
("currency" ["貨幣"])
("current" ["現時的"])
("curse" ["詛咒"])
("curtail" ["剝奪"])
("curtain" ["窗帘"])
("curve" ["彎曲"])
("cushion" ["墊子"])
("custody" ["保管"])
("custom" ["習慣" "風俗"])
("customary" ["習慣性的"])
("customer" ["顧客"])
("cut" ["切"])
("cute" ["可愛的"])
("cycle" ["週期" "騎車"])
("cylinder" ["圓柱"])
("cynical" ["譏誚的"])
("cypress" ["絲柏"])
("dad" ["爸爸"])
("daffodil" ["喇叭水仙"])
("dagger" ["短劍"])
("dahlia" ["天竺牡丹"])
("daily" ["每日的"])
("dainty" ["高雅的"])
("dairy" ["酪農業"])
("daisy" ["雛菊"])
("dam" ["壩"])
("damage" ["損害"])
("dame" ["貴婦人"])
("damn" ["咒罵"])
("damp" ["潮濕"])
("dance" ["跳舞"])
("dancer" ["舞蹈家"])
("dancing" ["舞蹈"])
("danger" ["危險"])
("dangerous" ["危險的"])
("dangle" ["吊著"])
("dare" ["敢"])
("daring" ["膽大的"])
("dark" ["黑暗的"])
("darken" ["變暗" "變黑"])
("darkly" ["黑暗地"])
("darkness" ["黑暗"])
("darling" ["心愛的人"])
("darn" ["縫補"])
("dart" ["鏢" "投射"])
("dash" ["衝撞"])
("data" ["資料" "數據"])
("date" ["日期" "約會"])
("daughter" ["女兒"])
("dawn" ["黎明"])
("day" ["日" "白天"])
("daybreak" ["黎明" "破曉"])
("daylight" ["白晝"])
("daytime" ["日間"])
("daze" ["暈眩"])
("dazzle" ["耀眼"])
("dead" ["死的"])
("deadly" ["致死的"])
("deaf" ["聾的"])
("deafen" ["使耳聾"])
("deal" ["交易" "涉及"])
("dealer" ["交易者"])
("dealing" ["應對" "交往"])
("dean" ["院長"])
("dear" ["親愛的"])
("dearly" ["親愛地"])
("death" ["死亡"])
("debate" ["辯論"])
("debt" ["債務"])
("debtor" ["債務人"])
("decade" ["十年"])
("decagram" ["十克"])
("decaliter" ["公斗"])
("decameter" ["公丈"])
("decay" ["衰敗"])
("decease" ["死亡"])
("deceased" ["死亡的"])
("deceit" ["詭計"])
("deceive" ["欺騙"])
("december" ["十二月"])
("decency" ["正當行為"])
("decent" ["合適的"])
("decide" ["決定"])
("decided" ["確定的"])
("decigram" ["公釐"])
("decimeter" ["公寸"])
("decision" ["決定"])
("decisive" ["決定性的"])
("deck" ["甲板"])
("declaration" ["聲明"])
("declare" ["宣佈"])
("decline" ["下降"])
("decompose" ["衰落"])
("decorate" ["裝飾"])
("decorative" ["裝飾的"])
("decrease" ["減少"])
("decree" ["法令"])
("dedicate" ["奉獻"])
("deed" ["契據"])
("deem" ["以為"])
("deep" ["深的"])
("deepen" ["加深"])
("deeply" ["在深處"])
("deer" ["鹿"])
("defeat" ["打敗"])
("defect" ["過失"])
("defective" ["不完美的"])
("defence" ["防禦"])
("defend" ["防守"])
("defendant" ["被告"])
("defender" ["防守者"])
("defense" ["防禦"])
("defensive" ["自衛的"])
("defer" ["延緩"])
("deferent" ["恭順的"])
("defiance" ["挑戰"])
("deficiency" ["缺乏"])
("deficient" ["缺乏的"])
("defile" ["弄髒"])
("define" ["下定義"])
("definite" ["肯定的"])
("definition" ["定義"])
("deformity" ["殘廢"])
("defy" ["不服"])
("degenerate" ["退步"])
("degradation" ["免職"])
("degrade" ["降級"])
("degree" ["度數" "等級"])
("deity" ["神"])
("delay" ["延期"])
("delegate" ["代表"])
("delegation" ["代表團"])
("deliberate" ["謹慎的"])
("deliberation" ["熟思"])
("delicacy" ["精致"])
("delicate" ["精美的"])
("delicious" ["美味的"])
("delight" ["樂趣"])
("delightful" ["愉快的"])
("deliver" ["傳送" "接生"])
("deliverance" ["釋放"])
("delivery" ["傳送" "分娩"])
("dell" ["幽谷"])
("delta" ["三角洲"])
("deluge" ["洪水"])
("delusion" ["幻想"])
("demand" ["要求"])
("demeanor" ["態度"])
("democracy" ["民主政治"])
("democrat" ["民主主義者"])
("democratic" ["民主政治的"])
("demon" ["惡魔"])
("demonstrate" ["示範" "示威"])
("demonstration" ["示範" "示威"])
("den" ["獸穴"])
("denial" ["否認"])
("denomination" ["名稱" "派別"])
("denote" ["指示" "表示"])
("denounce" ["公開指責"])
("dense" ["稠密的"])
("density" ["密度"])
("dental" ["牙齒的"])
("dentist" ["牙科醫生"])
("deny" ["否認"])
("depart" ["離開"])
("department" ["部門" "科系"])
("departure" ["啟程"])
("depend" ["依靠"])
("dependence" ["依屬"])
("dependent" ["依賴的"])
("depict" ["描述"])
("deplore" ["悲痛"])
("depose" ["免職"])
("deposit" ["存放"])
("depot" ["倉庫"])
("depress" ["降低" "貶值"])
("depression" ["不景氣"])
("deprive" ["剝奪"])
("depth" ["深度"])
("deputy" ["副的"])
("derision" ["愚弄"])
("derive" ["獲得" "起源"])
("descend" ["下降"])
("descendant" ["後裔"])
("descent" ["降落" "血統"])
("describe" ["描述" "摹畫"])
("description" ["敘述"])
("desert" ["沙漠"])
("deserve" ["應得"])
("design" ["設計" "圖案"])
("designate" ["指定"])
("desirability" ["可取之處"])
("desirable" ["合意的"])
("desire" ["期望"])
("desirous" ["渴望的"])
("desk" ["書桌"])
("desolate" ["荒涼的"])
("desolation" ["荒蕪"])
("despair" ["失望"])
("despairing" ["失望的"])
("despatch" ["發送" "解決"])
("desperate" ["非常的"])
("desperation" ["絕望"])
("despise" ["輕視"])
("despite" ["不管"])
("dessert" ["甜點"])
("destination" ["目的地"])
("destine" ["預定" "註定"])
("destiny" ["命運"])
("destitute" ["缺乏"])
("destroy" ["破壞"])
("destruction" ["毀壞"])
("destructive" ["破壞的"])
("detach" ["分開"])
("detachment" ["分開"])
("detail" ["細節"])
("detain" ["拘留"])
("detect" ["偵查"])
("detective" ["偵探"])
("determination" ["決心"])
("determine" ["下決心"])
("determined" ["有決心的"])
("detest" ["憎恨"])
("devastate" ["毀壞"])
("develop" ["發展"])
("development" ["發展"])
("device" ["裝置" "設備"])
("devil" ["魔鬼"])
("devise" ["設計"])
("devote" ["奉獻"])
("devoted" ["忠誠的"])
("devotion" ["熱誠"])
("devour" ["吞食"])
("dew" ["露水"])
("dewy" ["帶露的"])
("dexterity" ["靈活的"])
("diagram" ["圖表"])
("dial" ["撥號"])
("dialect" ["方言"])
("dialogue" ["對話"])
("diameter" ["直徑"])
("diamond" ["鑽石"])
("diary" ["日記"])
("dice" ["骰子"])
("dictate" ["聽寫"])
("dictation" ["聽寫"])
("dictator" ["獨裁者"])
("diction" ["用字"])
("dictionary" ["字典"])
("die" ["死"])
("diet" ["飲食療養"])
("difference" ["差別"])
("difficult" ["困難的"])
("diffuse" ["擴散"])
("dig" ["挖"])
("digest" ["消化"])
("digestion" ["消化"])
("digestive" ["消化的"])
("dignify" ["使高貴"])
("dignity" ["尊嚴"])
("dilate" ["使膨脹"])
("dilemma" ["進退兩難"])
("diligence" ["勤勉"])
("diligent" ["勤勉的"])
("dim" ["陰暗的"])
("dime" ["一角銀幣"])
("dimension" ["大小"])
("diminish" ["縮小"])
("diminutive" ["小型的"])
("dimple" ["酒窩"])
("dine" ["用膳"])
("dinner" ["晚餐"])
("dip" ["浸一下"])
("diplomacy" ["外交"])
("diplomatic" ["外交手腕的"])
("direct" ["指揮" "直接"])
("direction" ["指示"])
("directly" ["直接地"])
("director" ["指揮" "董事" "指揮者"])
("dirt" ["髒東西"])
("dirty" ["髒"])
("disable" ["使無能"])
("disadvantage" ["不利"])
("disagree" ["不同意"])
("disagreeable" ["不愉快的"])
("disappear" ["失縱,消失"])
("disappoint" ["使失望"])
("disappointment" ["失望"])
("disapproval" ["不贊成"])
("disapprove" ["不贊成"])
("disarm" ["廢除軍備"])
("disarmament" ["裁軍"])
("disaster" ["慘事"])
("disastrous" ["不幸的"])
("discard" ["拋棄"])
("discern" ["識別"])
("discharge" ["排出"])
("disciple" ["門徒"])
("discipline" ["規律"])
("disclose" ["揭發"])
("discomfort" ["不安"])
("discontent" ["不滿"])
("discord" ["不調和"])
("discount" ["折扣"])
("discourage" ["阻止"])
("discover" ["發現"])
("discovery" ["新發現"])
("discreet" ["謹慎"])
("discretion" ["慎重"])
("discuss" ["商談"])
("discussion" ["討論"])
("disdain" ["輕蔑"])
("disease" ["病"])
("disfigure" ["變醜"])
("disgrace" ["恥辱"])
("disguise" ["偽裝"])
("disgust" ["使厭煩"])
("dish" ["盤" "碟"])
("dishonest" ["不誠實的"])
("dishonor" ["不名譽事物"])
("disk" ["圓盤"])
("dislike" ["嫌惡"])
("dismiss" ["解散"])
("dismount" ["下馬"])
("disobey" ["不聽命"])
("disorder" ["混亂"])
("dispatch" ["特派"])
("dispense" ["分配" "配藥"])
("disperse" ["驅散"])
("displace" ["換置"])
("display" ["陳列"])
("displease" ["使生氣"])
("displeasure" ["不快"])
("disposal" ["處分"])
("dispose" ["配置"])
("disposition" ["意向"])
("dispute" ["爭吵"])
("disregard" ["置之度外"])
("dissect" ["解剖"])
("dissension" ["意見不合"])
("dissolution" ["解除"])
("dissolve" ["溶解" "取消"])
("distance" ["距離"])
("distant" ["遠的"])
("distill" ["蒸餾"])
("distinct" ["不同的"])
("distinction" ["卓越"])
("distinctive" ["獨特的"])
("distinctly" ["明顯地"])
("distinguish" ["區別"])
("distort" ["弄歪"])
("distract" ["分散注意"])
("distress" ["苦惱"])
("distribute" ["分發"])
("distribution" ["分發"])
("district" ["地區"])
("distrust" ["不信用"])
("disturb" ["攪亂"])
("disturbance" ["騷動"])
("ditch" ["溝"])
("dive" ["潛水"])
("diverse" ["各色各樣"])
("diversity" ["多樣"])
("divert" ["使轉向"])
("divide" ["分給,除"])
("dividend" ["紅利"])
("divine" ["神聖的"])
("divinity" ["神性"])
("division" ["部門" "除"])
("divorce" ["離婚"])
("dizzy" ["頭暈的"])
("do" ["做"])
("dock" ["碼頭"])
("doctor" ["醫師" "博士"])
("doctrine" ["教義"])
("document" ["公文"])
("dog" ["狗"])
("doll" ["玩偶"])
("dollar" ["元"])
("dolly" ["洋娃娃"])
("domain" ["領域"])
("dome" ["圓屋頂"])
("domestic" ["內部的"])
("dominant" ["優勢的"])
("dominate" ["支配"])
("dominion" ["主權"])
("donate" ["捐贈"])
("donation" ["捐款"])
("done" ["完成了"])
("donkey" ["驢子"])
("doom" ["不幸"])
("door" ["門"])
("doorway" ["門口"])
("dormitory" ["宿舍"])
("dose" ["一服"])
("dot" ["點"])
("double" ["雙重的"])
("doubt" ["懷疑"])
("doubtful" ["可疑的"])
("doubtless" ["無疑地"])
("dough" ["生麵糰"])
("doughnut" ["油炸圈餅"])
("dove" ["鴿"])
("down" ["向下"])
("downfall" ["沒落"])
("downstairs" ["樓下"])
("downtown" ["鬧區"])
("downward" ["向下的"])
("dozen" ["一打"])
("draft" ["草案"])
("drag" ["拉,拖"])
("dragonfly" ["蜻蜓"])
("drain" ["排水"])
("drainage" ["排水渠"])
("dramatic" ["戲劇性的"])
("drapery" ["帳帘"])
("drastic" ["激烈的"])
("draw" ["拉" "簽寫"])
("drawer" ["抽屜"])
("drawing" ["圖畫"])
("dread" ["非常害怕"])
("dreadful" ["可怕的"])
("dream" ["夢"])
("dreary" ["厭倦的"])
("drench" ["使濕透"])
("dress" ["打扮"])
("dressing" ["調味汁"])
("dressmaker" ["女裝裁縫師"])
("drift" ["漂游"])
("drill" ["訓練"])
("drink" ["飲,喝"])
("drip" ["滴下"])
("drive" ["駕車"])
("driver" ["司機"])
("droop" ["垂下"])
("drop" ["水滴"])
("drought" ["乾旱"])
("drown" ["使溺死"])
("drowsy" ["想睡的"])
("drug" ["藥品"])
("druggist" ["藥商"])
("drum" ["鼓"])
("drunkard" ["酒鬼"])
("dry" ["乾"])
("duchess" ["公爵夫人"])
("duck" ["鴨"])
("due" ["會費"])
("duel" ["決鬥"])
("duke" ["公爵"])
("dull" ["遲鈍的"])
("duly" ["當然地"])
("dumb" ["啞的"])
("dump" ["拋棄"])
("duplicate" ["副本的"])
("durable" ["有耐久力的"])
("duration" ["持久"])
("during" ["在﹍期間"])
("dusk" ["黃昏"])
("dusky" ["昏暗的"])
("dust" ["灰塵"])
("dusty" ["滿身塵埃的"])
("duty" ["責任"])
("dwarf" ["矮子"])
("dwell" ["居住"])
("dwelling" ["寓所"])
("dye" ["染料"])
("dying" ["垂死的"])
("dynamite" ["炸藥"])
("dynamo" ["發電機"])
("dynasty" ["王朝"])
("each" ["每"])
("eager" ["切望的"])
("eagle" ["鷹"])
("ear" ["耳"])
("earl" ["伯爵"])
("early" ["早"])
("earn" ["賺得"])
("earnest" ["認真的"])
("earning" ["收入"])
("earth" ["地球" "土壤"])
("earthquake" ["地震"])
("earthworm" ["蚯蚓"])
("ease" ["悠閒"])
("easily" ["容易地"])
("east" ["東" "東方"])
("eastern" ["東方的"])
("eastward" ["向東的"])
("easy" ["容易的"])
("eat" ["吃"])
("eaves" ["屋簷"])
("ebb" ["退潮"])
("ebony" ["烏木"])
("eccentric" ["古怪的"])
("echo" ["回聲"])
("eclipse" ["日蝕" "月蝕"])
("economic" ["經濟學的"])
("economical" ["節儉的"])
("economics" ["經濟學"])
("economist" ["經濟學家"])
("economy" ["經濟制度"])
("ecstasy" ["狂喜"])
("eddy" ["漩渦"])
("edge" ["邊緣"])
("edifice" ["大廈"])
("edit" ["編輯"])
("edition" ["版本"])
("editor" ["主編"])
("editorial" ["社論"])
("educate" ["培育"])
("education" ["教育"])
("educational" ["教育的"])
("eel" ["鰻魚"])
("effect" ["效果"])
("effective" ["有效的"])
("efficiency" ["效率"])
("efficient" ["有效的"])
("effort" ["努力"])
("egg" ["蛋"])
("eight" ["八"])
("eighteen" ["十八"])
("eighteenth" ["第十八"])
("eighth" ["第八"])
("eightieth" ["第八十"])
("eighty" ["八十"])
("either" ["二者之一"])
("elaborate" ["精巧的"])
("elapse" ["逝去"])
("elastic" ["鬆緊帶"])
("elbow" ["手肘"])
("elder" ["前輩"])
("elderly" ["老年的"])
("eldest" ["最年長的"])
("elect" ["推選"])
("election" ["選舉"])
("elector" ["有選舉權者"])
("electric" ["電力的"])
("electrical" ["電的"])
("electricity" ["電"])
("electron" ["電子"])
("elegance" ["高雅" "優美"])
("elegant" ["高雅的"])
("element" ["元素"])
("elementary" ["基本的"])
("elephant" ["象"])
("elevate" ["提高"])
("elevation" ["高度"])
("elevator" ["電梯"])
("eleven" ["十一"])
("eleventh" ["第十一"])
("elf" ["小精靈"])
("eliminate" ["淘汰" "消去"])
("elk" ["麋鹿"])
("elm" ["榆樹"])
("eloquence" ["口才"])
("eloquent" ["雄辯的"])
("else" ["別的"])
("elsewhere" ["別處"])
("embark" ["搭乘"])
("embarrass" ["使困窘"])
("embarrassment" ["困窘"])
("embassy" ["大使館"])
("ember" ["餘燼"])
("emblem" ["象徵"])
("embody" ["使具體化"])
("embrace" ["擁抱"])
("embroider" ["刺繡"])
("embroidery" ["刺繡品"])
("emerald" ["翡翠"])
("emerge" ["出現"])
("emergency" ["緊急事件"])
("emigrant" ["移民"])
("eminence" ["知名人士"])
("eminent" ["聞名的"])
("emit" ["發出"])
("emotion" ["情緒"])
("emotional" ["情緒化的"])
("emperor" ["皇帝"])
("emphasis" ["強調"])
("emphasize" ["強調"])
("empire" ["帝國"])
("employee" ["雇員"])
("employer" ["雇主"])
("employment" ["職業"])
("empress" ["女皇"])
("empty" ["空的"])
("emulator" ["競爭者"])
("enable" ["使﹍能夠"])
("enact" ["制定" "扮演"])
("enamel" ["搪瓷" "光漆"])
("encamp" ["紮營"])
("enchant" ["蠱惑"])
("enchantment" ["魔法"])
("encircle" ["環繞"])
("enclose" ["圍繞" "附寄"])
("enclosure" ["圍牆" "附件"])
("encounter" ["遭遇"])
("encourage" ["鼓勵"])
("encyclopedia" ["百科全書"])
("end" ["終點"])
("endeavor" ["努力"])
("ending" ["結局"])
("endless" ["無窮的"])
("endow" ["捐助"])
("endurance" ["耐力"])
("endure" ["持久"])
("enemy" ["敵人"])
("energetic" ["有活力的"])
("energy" ["精力"])
("enforce" ["強制"])
("enforcement" ["強制"])
("engage" ["約定"])
("engagement" ["訂婚"])
("engine" ["引擎"])
("engineer" ["工程師"])
("engineering" ["工程學"])
("england" ["英國"])
("english" ["英文" "英國人"])
("engrave" ["彫刻"])
("enhance" ["提高"])
("enjoy" ["享受"])
("enjoyment" ["樂趣"])
("enlarge" ["擴充"])
("enlighten" ["啟發"])
("enlist" ["徵召"])
("enmity" ["敵意"])
("enormous" ["極大的"])
("enough" ["足夠的"])
("enrage" ["激怒"])
("enrich" ["使﹍豐富"])
("enroll" ["登記"])
("ensign" ["旗幟"])
("ensue" ["緣起"])
("entail" ["導致"])
("enter" ["進入"])
("enterprise" ["企業"])
("entertain" ["款待"])
("entertainment" ["娛樂"])
("enthusiasm" ["熱心"])
("enthusiastic" ["熱忱的"])
("entice" ["誘惑"])
("entire" ["全部的"])
("entirely" ["全部地"])
("entitle" ["有資格"])
("entrance" ["入口"])
("entreat" ["懇求"])
("entreaty" ["懇求"])
("entrust" ["托付"])
("entry" ["進口"])
("enumerate" ["列舉"])
("envelope" ["信封"])
("envious" ["羨慕"])
("environment" ["環境"])
("envy" ["羨慕"])
("epic" ["史詩"])
("epidemic" ["流行病"])
("episcopal" ["主教的"])
("episode" ["插曲"])
("epistle" ["書信"])
("epitaph" ["墓誌銘"])
("epoch" ["時代"])
("equal" ["相等"])
("equality" ["平等"])
("equally" ["相等地"])
("equation" ["方程式"])
("equator" ["赤道"])
("equip" ["裝置"])
("equipment" ["裝備"])
("equity" ["公平"])
("equivalent" ["相等的"])
("era" ["紀元"])
("eraser" ["橡皮搽"])
("ere" ["不久"])
("erect" ["直立的"])
("err" ["犯錯"])
("errand" ["出差"])
("error" ["錯誤"])
("eruption" ["爆發"])
("escalator" ["自動樓梯"])
("escape" ["逃走"])
("escort" ["護送者"])
("especial" ["特別的"])
("esquire" ["男性尊稱"])
("essay" ["論文"])
("essence" ["本質"])
("essential" ["要素"])
("essentially" ["本質上"])
("establish" ["設立" "制定"])
("establishment" ["制定" "設施"])
("estate" ["地產"])
("esteem" ["尊重" "認為"])
("estimate" ["估計"])
("estimation" ["估計"])
("eternal" ["永遠的"])
("eternity" ["永恆"])
("ether" ["以太"])
("ethics" ["倫理"])
("etiquette" ["禮儀" "禮節"])
("etymology" ["語源"])
("europe" ["歐洲"])
("european" ["歐洲的"])
("evade" ["規避"])
("evaporate" ["蒸發"])
("evaporation" ["蒸發"])
("eve" ["前夕"])
("even" ["平的"])
("evening" ["傍晚,黃昏"])
("evenly" ["平衡地"])
("event" ["事件"])
("eventual" ["最後的"])
("eventually" ["終於"])
("ever" ["曾經"])
("evergreen" ["常綠的"])
("everlasting" ["永久的"])
("evermore" ["經常地"])
("every" ["每,每一"])
("everybody" ["每個人"])
("everyday" ["每天的"])
("everyone" ["每個人"])
("everything" ["一切事物"])
("everywhere" ["到處"])
("evidence" ["證據"])
("evident" ["明顯的"])
("evil" ["邪惡地"])
("evolution" ["進化"])
("evolve" ["放出熱﹐光"])
("ewe" ["母羊"])
("exact" ["精密的"])
("exactly" ["剛好"])
("exaggerate" ["誇大"])
("exaggeration" ["誇張"])
("exalt" ["擢陞"])
("examination" ["檢查" "考試"])
("examine" ["檢查"])
("example" ["範例"])
("exasperate" ["使怒"])
("excavation" ["挖掘"])
("exceed" ["超過限度"])
("exceeding" ["過度的"])
("excel" ["勝過"])
("excellence" ["卓越"])
("excellent" ["優秀的"])
("except" ["除了之外"])
("exception" ["例外"])
("exceptional" ["異常的"])
("excess" ["過量"])
("excessive" ["過度的"])
("exchange" ["替換"])
("excite" ["激起"])
("excitement" ["興奮"])
("exciting" ["使興奮的"])
("exclaim" ["呼喊"])
("exclamation" ["叫喊"])
("exclude" ["排除"])
("exclusive" ["唯一的"])
("excursion" ["遠足"])
("excuse" ["原諒"])
("execute" ["履行"])
("execution" ["實行"])
("executive" ["主管人員"])
("exempt" ["免除"])
("exercise" ["運動,訓練"])
("exert" ["使運用"])
("exertion" ["盡力"])
("exhaust" ["用盡"])
("exhaustion" ["竭盡"])
("exhibit" ["發揮" "陳列"])
("exhibition" ["展示"])
("exile" ["流放"])
("exist" ["存在"])
("existence" ["存在"])
("exit" ["出口"])
("expand" ["使膨脹"])
("expanse" ["寬闊"])
("expansion" ["膨脹"])
("expect" ["預期"])
("expectation" ["期望"])
("expedient" ["得當的"])
("expedition" ["遠征"])
("expel" ["逐出"])
("expend" ["花費"])
("expenditure" ["開支"])
("expense" ["費用"])
("expensive" ["高價的"])
("experience" ["經驗"])
("experienced" ["有經驗的"])
("experiment" ["實驗"])
("experimental" ["試驗性的"])
("expert" ["專家"])
("expire" ["滿期" "絕氣"])
("explain" ["說明"])
("explanation" ["說明"])
("explode" ["爆炸"])
("exploit" ["勳績"])
("exploration" ["探險"])
("explore" ["探險"])
("explorer" ["探險者"])
("explosion" ["爆發"])
("explosive" ["爆發的"])
("export" ["輸出" "出口"])
("expose" ["曝露" "露出"])
("exposition" ["展覽會"])
("exposure" ["曝露"])
("express" ["表達"])
("expression" ["表情"])
("exquisite" ["絕妙的"])
("extend" ["伸出" "延長"])
("extension" ["伸展" "延期"])
("extensive" ["廣博的"])
("extent" ["程度" "限度"])
("exterior" ["外的"])
("external" ["外用的"])
("extinct" ["已滅的"])
("extinguish" ["熄滅"])
("extra" ["額外的"])
("extract" ["引出" "抽出"])
("extraordinary" ["非常的"])
("extravagance" ["揮霍無度"])
("extravagant" ["揮霍無度的"])
("extreme" ["極端的"])
("extremely" ["極端地"])
("extremity" ["末端"])
("exultation" ["大喜"])
("eye" ["眼"])
("eyebrow" ["眉毛"])
("eyelid" ["眼皮"])
("fable" ["寓言"])
("fabric" ["紡織品"])
("fabulous" ["極好的"])
("face" ["臉"])
("facilitate" ["使容易"])
("facility" ["設備"])
("fact" ["事實"])
("faction" ["派系"])
("factor" ["要素" "因子"])
("factory" ["工廠"])
("faculty" ["才能,教授"])
("fade" ["褪色"])
("fail" ["不及格"])
("failure" ["失敗"])
("faint" ["模糊的"])
("fair" ["清澈的"])
("fairy" ["仙女"])
("fairyland" ["仙境"])
("faith" ["信心"])
("faithful" ["忠實的"])
("falcon" ["鷹"])
("fall" ["落下"])
("false" ["錯誤的"])
("falsehood" ["虛偽"])
("falter" ["搖晃"])
("fame" ["聲譽"])
("familiar" ["熟悉的"])
("familiarity" ["熟悉"])
("family" ["家庭"])
("famine" ["飢荒"])
("famous" ["出名的"])
("fan" ["扇子"])
("fancy" ["花俏的"])
("fantastic" ["奇妙的"])
("far" ["遠"])
("fare" ["運費"])
("farewell" ["送別"])
("farm" ["農場" "牧場"])
("farmer" ["農人"])
("farmhouse" ["農舍"])
("farmyard" ["農家庭院"])
("faroff" ["遙遠的"])
("farther" ["更遠的"])
("farthest" ["最遠的"])
("fascinate" ["迷住"])
("fascination" ["魅力"])
("fashion" ["流行" "時尚"])
("fashionable" ["流行的"])
("fast" ["快速的"])
("fasten" ["綁住"])
("fat" ["肥胖"])
("fatal" ["不幸的"])
("fate" ["命運"])
("father" ["父親"])
("fathom" ["噚"])
("fatigue" ["疲勞"])
("fault" ["過失" "缺點"])
("favor" ["偏愛"])
("favorable" ["嘉許的"])
("favorite" ["最喜愛的"])
("fawn" ["奉承"])
("fear" ["害怕"])
("fearful" ["可怕的"])
("fearless" ["不怕的"])
("feast" ["盛宴" "節日"])
("feat" ["功績"])
("feather" ["羽毛"])
("feature" ["特徵" "特寫"])
("february" ["二月"])
("federal" ["聯邦的"])
("federation" ["聯邦"])
("fee" ["費用"])
("feeble" ["衰弱的"])
("feebly" ["衰弱地"])
("feed" ["飼養"])
("feeder" ["飼養者"])
("feel" ["感覺到"])
("feeling" ["感覺" "心情"])
("feign" ["假裝"])
("fellow" ["同伴"])
("fellowship" ["友誼"])
("felt" ["感覺" "毛氈"])
("female" ["雌性"])
("feminine" ["陰性的"])
("fence" ["籬笆"])
("fencing" ["劍術"])
("ferment" ["發酵" "醞釀"])
("fern" ["蕨類"])
("ferry" ["渡口"])
("fertile" ["肥沃的"])
("fertility" ["生殖力"])
("fertilize" ["施肥"])
("fertilizer" ["肥料"])
("fervor" ["熱誠"])
("festival" ["節慶"])
("fetch" ["拿" "取"])
("fetter" ["腳鐐"])
("feud" ["世仇"])
("feudal" ["封建的"])
("fever" ["發燒"])
("feverish" ["發燒的"])
("few" ["少數的"])
("fickle" ["多變的"])
("fiction" ["虛構小說"])
("fiddle" ["小提琴"])
("fidelity" ["忠誠"])
("field" ["田野" "戰場"])
("fiend" ["惡魔"])
("fierce" ["兇猛的"])
("fiery" ["如火的"])
("fifteen" ["十五"])
("fifteenth" ["第十五"])
("fifth" ["第五"])
("fiftieth" ["第五十"])
("fifty" ["五十"])
("fig" ["無花果"])
("fight" ["爭執" "打仗"])
("fighter" ["戰鬥者"])
("fighting" ["戰事"])
("figure" ["外形" "數字"])
("filament" ["絲狀物"])
("file" ["檔案"])
("fill" ["充滿"])
("film" ["膠卷"])
("filter" ["過"])
("filthy" ["骯髒的"])
("fin" ["魚鰭"])
("final" ["最後的"])
("finally" ["最後地"])
("finance" ["財政"])
("financial" ["財政的"])
("find" ["找到" "發現"])
("finding" ["發現物"])
("fine" ["精美的"])
("finger" ["手指"])
("finish" ["完成"])
("fir" ["樅樹"])
("fire" ["火"])
("firefly" ["螢火蟲"])
("fireman" ["消防隊員"])
("fireplace" ["壁爐"])
("fireside" ["爐邊"])
("firework" ["煙火"])
("firm" ["公司" "堅固"])
("firmament" ["蒼天"])
("firmly" ["堅固"])
("firmness" ["堅固性"])
("first" ["第一的"])
("first-class" ["第一流的"])
("fiscal" ["財政的"])
("fish" ["魚"])
("fisher" ["魚夫"])
("fisherman" ["魚夫"])
("fist" ["拳頭"])
("fit" ["合適"])
("fitness" ["適合"])
("five" ["五"])
("fix" ["安裝" "修理"])
("fixed" ["固定的"])
("fixture" ["裝置物"])
("flag" ["旗幟"])
("flake" ["薄片"])
("flame" ["火焰"])
("flaming" ["燃燒的"])
("flank" ["腹部"])
("flannel" ["絨布"])
("flap" ["拍打"])
("flare" ["閃亮"])
("flash" ["閃光"])
("flask" ["長頸瓶"])
("flat" ["平坦的"])
("flatten" ["弄平" "打倒"])
("flatter" ["奉承"])
("flatterer" ["奉承者"])
("flattery" ["媚詞"])
("flavor" ["味道"])
("flaw" ["裂紋"])
("flax" ["亞麻"])
("flea" ["跳蚤"])
("flee" ["逃走"])
("fleece" ["羊毛"])
("fleet" ["艦隊"])
("flesh" ["血肉"])
("flexible" ["有彈性的"])
("flicker" ["閃爍"])
("flight" ["航程"])
("fling" ["拋" "投"])
("flirt" ["調情"])
("flit" ["掠過"])
("float" ["漂浮"])
("flock" ["群"])
("flood" ["洪水"])
("floor" ["地板"])
("flop" ["失敗" "掉落"])
("flora" ["植物群"])
("flounder" ["比目魚"])
("flour" ["麵粉"])
("flourish" ["興盛"])
("flow" ["流動"])
("flower" ["花"])
("flowery" ["如花的"])
("fluffy" ["蓬鬆的"])
("fluid" ["流體的"])
("flush" ["發紅" "淹沒"])
("flute" ["長笛"])
("flutter" ["擺動"])
("fly" ["飛翔"])
("flying" ["飛行的"])
("foam" ["泡沫"])
("focus" ["焦點"])
("fodder" ["草料"])
("foe" ["敵人"])
("fog" ["霧"])
("foggy" ["糢糊"])
("foil" ["金屬薄片"])
("fold" ["摺疊"])
("foliage" ["葉子"])
("folk" ["家人"])
("follow" ["跟從"])
("follower" ["信徒"])
("following" ["下列的"])
("folly" ["蠢事"])
("fond" ["喜愛的"])
("fondness" ["嗜好"])
("food" ["食物"])
("fool" ["呆子"])
("foolish" ["可笑的"])
("foot" ["腳"])
("football" ["橄欖球"])
("footing" ["總帳"])
("footstep" ["腳步"])
("for" ["為了"])
("forage" ["飼料"])
("forbear" ["容忍"])
("forbid" ["禁止"])
("forbidden" ["被禁止的"])
("force" ["力"])
("forcibly" ["強制地"])
("ford" ["涉過"])
("fore" ["前面的"])
("forecast" ["預測"])
("forefather" ["祖先"])
("forefinger" ["食指"])
("forehead" ["前額"])
("foreign" ["外國的"])
("foreigner" ["外國人"])
("foreman" ["工頭"])
("foremost" ["最初的"])
("foresee" ["預知"])
("foresight" ["先見之明"])
("forest" ["森林"])
("foretell" ["預言"])
("forever" ["永遠地"])
("forfeit" ["被沒收"])
("forge" ["打製"])
("forget" ["忘記"])
("forgive" ["原諒"])
("forgiveness" ["饒恕"])
("fork" ["叉"])
("forlorn" ["絕望的"])
("form" ["形狀" "表格"])
("formal" ["正式的"])
("formality" ["正式的手續"])
("formally" ["正式地"])
("formation" ["形成"])
("former" ["以前的"])
("formerly" ["從前"])
("formidable" ["可怕"])
("formula" ["公式"])
("formulate" ["用形式表示"])
("forsake" ["丟棄"])
("fort" ["堡壘"])
("forth" ["向前"])
("forthwith" ["立刻"])
("fortification" ["築城"])
("fortify" ["加強"])
("fortitude" ["堅忍不拔"])
("fortnight" ["兩星期"])
("fortress" ["城堡"])
("fortunate" ["幸運的"])
("fortune" ["命運"])
("forty" ["四十"])
("forum" ["公開討論會"])
("forward" ["在前"])
("fossil" ["化石"])
("foster" ["養育"])
("foul" ["犯規的"])
("found" ["創立"])
("foundation" ["基礎"])
("founder" ["創立者"])
("fountain" ["噴泉"])
("four" ["四"])
("fourteen" ["十四"])
("fourth" ["第四"])
("fowl" ["野禽"])
("fox" ["狐"])
("fraction" ["分數"])
("fracture" ["破裂"])
("fragile" ["易碎的"])
("fragment" ["碎片"])
("fragrance" ["芬香"])
("fragrant" ["芬香的"])
("frail" ["脆弱的"])
("frailty" ["脆弱"])
("frame" ["相架"])
("framework" ["骨架"])
("franc" ["法郎"])
("france" ["法國"])
("frank" ["率直的"])
("frankness" ["坦白"])
("frantic" ["狂暴的"])
("fraternity" ["兄弟會"])
("fraud" ["欺騙"])
("freak" ["怪誕的"])
("freckle" ["雀斑"])
("free" ["自由"])
("freedom" ["自由"])
("freely" ["隨便地"])
("freeze" ["凍結"])
("freight" ["貨物運輸"])
("frequent" ["經常的"])
("fresh" ["新鮮的"])
("freshness" ["新鮮"])
("friction" ["摩擦"])
("friday" ["星期五"])
("friend" ["朋友"])
("friendliness" ["親切"])
("friendly" ["友好的"])
("friendship" ["友誼"])
("fright" ["驚駭"])
("frighten" ["使駭怕"])
("frightful" ["可怕的"])
("fringe" ["緣飾"])
("frog" ["青蛙"])
("from" ["從"])
("front" ["前面"])
("frontier" ["邊境"])
("frost" ["霜"])
("frosty" ["霜白的"])
("frown" ["愁眉苦臉"])
("frozen" ["凍結的"])
("frugal" ["節約的"])
("fruit" ["水果"])
("fruitful" ["產量多的"])
("fruitless" ["不結果的"])
("frustrate" ["挫敗"])
("fry" ["用油炸"])
("fuel" ["燃料"])
("fugitive" ["逃亡的"])
("fulfil" ["實踐"])
("full" ["滿"])
("fullness" ["充滿"])
("fully" ["完全地"])
("fume" ["臭味"])
("fun" ["戲耍"])
("function" ["機能"])
("fund" ["資金"])
("fundamental" ["基本的"])
("funeral" ["葬禮"])
("fungus" ["菌類"])
("funnel" ["漏斗"])
("funny" ["有趣的"])
("fur" ["軟毛"])
("furious" ["狂怒的"])
("furnace" ["熔礦爐"])
("furnish" ["供給"])
("furniture" ["家俱"])
("furrow" ["畦"])
("further" ["更遠"])
("furthermore" ["而且"])
("furthest" ["最遠的"])
("fury" ["激怒"])
("fuse" ["保險絲"])
("fusion" ["熔解"])
("fuss" ["大驚小怪"])
("futile" ["徒勞的"])
("future" ["未來"])
("gaiety" ["歡樂"])
("gain" ["得到"])
("gait" ["步伐"])
("gale" ["強風"])
("gall" ["膽汁"])
("gallant" ["英勇的"])
("gallery" ["畫廊"])
("gallon" ["加崙"])
("gallop" ["疾馳"])
("gamble" ["賭博"])
("game" ["遊戲"])
("gang" ["一群"])
("gangster" ["匪徒集團"])
("gap" ["間隔"])
("garage" ["車庫"])
("garden" ["花園"])
("gardener" ["園丁"])
("gardening" ["園藝"])
("garland" ["花環"])
("garment" ["衣裝"])
("garter" ["襪帶"])
("gas" ["瓦斯,汽油"])
("gaseous" ["氣體的"])
("gasoline" ["汽油"])
("gasp" ["喘息"])
("gate" ["閘"])
("gateway" ["出入口"])
("gather" ["集合"])
("gathering" ["聚集"])
("gauge" ["標準尺寸"])
("gauze" ["紗布"])
("gay" ["快活的"])
("gaze" ["凝視"])
("gear" ["齒輪"])
("gem" ["寶石"])
("gender" ["性別"])
("general" ["將軍" "通常的"])
("generate" ["產生"])
("generation" ["一代"])
("generosity" ["慷慨"])
("generous" ["雍容大度"])
("genial" ["和藹的"])
("genius" ["天才"])
("gentle" ["文雅的"])
("gentleman" ["紳士"])
("gentleness" ["溫和的品質"])
("gently" ["輕輕地"])
("gentry" ["名流"])
("genuine" ["純正的"])
("geographical" ["地理的"])
("geography" ["地理"])
("geology" ["地質學"])
("geometry" ["幾何學"])
("germ" ["細菌"])
("germany" ["德國"])
("germinate" ["發芽"])
("gerund" ["動名詞"])
("gesture" ["姿勢"])
("get" ["得到"])
("ghastly" ["恐怖的"])
("ghost" ["鬼魂"])
("giant" ["巨人"])
("giddy" ["暈眩的"])
("gift" ["禮物" "天賦"])
("gifted" ["天才的"])
("gigantic" ["龐大的"])
("giggle" ["格格笑"])
("gild" ["鍍金"])
("gill" ["腮" "峽谷"])
("gilt" ["鍍金"])
("gin" ["杜松子酒"])
("ginger" ["薑"])
("gingerbread" ["薑餅"])
("gingham" ["格子棉布"])
("giraffe" ["長頸鹿"])
("gird" ["束緊" "圍住"])
("girdle" ["束腰"])
("girl" ["女孩"])
("give" ["給" "讓"])
("giver" ["贈與者"])
("glacier" ["冰河"])
("glad" ["高興的"])
("glade" ["沼澤"])
("gladness" ["歡樂"])
("glamour" ["魅力"])
("glance" ["一瞥"])
("gland" ["腺"])
("glare" ["強光"])
("glass" ["玻璃"])
("glaze" ["裝玻璃"])
("gleam" ["一線微光"])
("glean" ["收集"])
("glee" ["歡樂"])
("glen" ["狹谷"])
("glide" ["滑翔"])
("glider" ["滑翔機"])
("glimmer" ["微光"])
("glimpse" ["一瞥"])
("glint" ["閃耀"])
("glisten" ["閃亮"])
("glitter" ["燦爛"])
("globe" ["球狀物"])
("gloom" ["幽暗"])
("gloomy" ["陰鬱的"])
("glorify" ["加榮耀於"])
("glorious" ["光榮的"])
("glory" ["光榮"])
("glossy" ["光滑的"])
("glove" ["手套"])
("glow" ["熾熱"])
("glue" ["膠"])
("gnat" ["蚋"])
("gnaw" ["齧咬"])
("go" ["去"])
("goal" ["目標"])
("goat" ["山羊"])
("gobble" ["大吃"])
("goblet" ["高腳杯"])
("goblin" ["小妖精"])
("goddess" ["女神"])
("godfather" ["教父"])
("godmother" ["教母"])
("going" ["離開"])
("gold" ["黃金"])
("golden" ["金色的"])
("goldfish" ["金魚"])
("goldsmith" ["金匠"])
("golf" ["高爾夫球"])
("gone" ["過去的"])
("good" ["良好的"])
("goodbye" ["再見"])
("goodlooking" ["美貌的"])
("goodly" ["美好的"])
("goodnatured" ["和善的"])
("goodness" ["美德"])
("goods" ["貨物"])
("goodwill" ["親善"])
("goose" ["鵝"])
("gore" ["血塊"])
("gorge" ["狹路"])
("gorgeous" ["華麗的"])
("gospel" ["福音"])
("gossip" ["閒話"])
("govern" ["治理"])
("government" ["政府"])
("governor" ["州長"])
("gown" ["長袍"])
("grab" ["抓住"])
("grace" ["優雅"])
("graceful" ["優雅的"])
("gracious" ["親切的"])
("grade" ["年級"])
("gradual" ["逐漸的"])
("graduate" ["畢業"])
("graduation" ["畢業典禮"])
("graft" ["接枝"])
("grain" ["穀類"])
("gram" ["克" "公分"])
("grammar" ["文法"])
("gramophone" ["留聲機"])
("grand" ["雄偉的"])
("grandeur" ["高貴"])
("grandfather" ["祖父"])
("grandma" ["奶奶"])
("grandmother" ["祖母"])
("grandpa" ["爺爺"])
("grandson" ["孫子"])
("granite" ["花崗石"])
("granny" ["奶奶"])
("grant" ["准許"])
("grape" ["葡萄"])
("grasp" ["抓緊"])
("grass" ["青草"])
("grasshopper" ["蚱蜢"])
("grassy" ["如草的"])
("grate" ["爐架"])
("grateful" ["感謝的"])
("gratify" ["使﹍高興"])
("gratitude" ["感謝"])
("grave" ["雕刻"])
("gravel" ["碎石"])
("gravely" ["碎石的"])
("gravitation" ["地心吸力"])
("gravity" ["萬有引力"])
("gravy" ["調味肉汁"])
("gray" ["灰色"])
("graze" ["放牧"])
("grease" ["油脂"])
("great" ["巨大的"])
("greatness" ["偉大"])
("greedy" ["貪心的"])
("green" ["綠色的"])
("greet" ["致敬" "迎接"])
("greeting" ["問候"])
("greyhound" ["灰獵犬"])
("grief" ["悲痛"])
("grievance" ["苦境"])
("grieve" ["傷心"])
("grievous" ["悲傷的"])
("grim" ["冷酷的"])
("grin" ["露齒而笑"])
("grind" ["磨碎"])
("grip" ["握住"])
("grit" ["粗砂"])
("grizzly" ["灰色的"])
("groan" ["呻吟"])
("grocer" ["雜貨商"])
("grocery" ["雜貨"])
("groom" ["馬伕"])
("groove" ["槽" "溝道"])
("grope" ["摸索"])
("gross" ["總數"])
("grotesque" ["古怪的"])
("ground" ["地"])
("group" ["團體"])
("grouse" ["松雞"])
("grove" ["小樹林"])
("grow" ["生長"])
("growl" ["咆哮"])
("growth" ["成長"])
("grub" ["蛆"])
("grudge" ["遺恨"])
("gruff" ["粗糙的"])
("grumble" ["訴苦"])
("grunt" ["咕嚕"])
("guarantee" ["保証人"])
("guaranty" ["保証"])
("guard" ["警衛"])
("guardian" ["監護人"])
("guess" ["猜測"])
("guest" ["客人"])
("guidance" ["指導"])
("guide" ["引導"])
("guild" ["公會"])
("guilt" ["罪"])
("guilty" ["有罪的"])
("guitar" ["吉他"])
("gulf" ["灣"])
("gulp" ["牛飲"])
("gum" ["膠"])
("gun" ["槍"])
("gunner" ["砲手"])
("gunpowder" ["火藥"])
("gust" ["陣風"])
("gutter" ["排水溝"])
("guy" ["傢伙"])
("gym" ["體育館"])
("gymnasium" ["體育館"])
("gymnastic" ["體操的"])
("gymnastics" ["體操"])
("gypsy" ["吉普賽人"])
("habit" ["習慣"])
("habitation" ["住所"])
("habitual" ["習慣的"])
("hack" ["劈"])
("hail" ["歡呼"])
("hair" ["毛" "頭髮"])
("hairy" ["毛茸茸的"])
("half" ["一半"])
("halfway" ["半途"])
("hall" ["大廳"])
("hallow" ["神聖"])
("halt" ["停止"])
("ham" ["火腿"])
("hammer" ["鎚"])
("hammock" ["吊床"])
("hamper" ["妨礙"])
("hand" ["手"])
("handful" ["滿手"])
("handkerchief" ["手帕"])
("handle" ["把手"])
("handsome" ["英俊"])
("handy" ["靈巧的"])
("hang" ["懸"])
("happen" ["發生"])
("happening" ["事件"])
("happily" ["快樂地"])
("happiness" ["幸福"])
("happy" ["快樂"])
("harass" ["使困擾"])
("harbor" ["港彎"])
("hard" ["堅固" "硬"])
("harden" ["使硬化"])
("hardly" ["幾乎不"])
("hardness" ["硬度"])
("hardship" ["困境"])
("hardware" ["鐵器"])
("hare" ["野兔"])
("hark" ["傾聽"])
("harm" ["傷害"])
("harmful" ["有害的"])
("harmless" ["無害的"])
("harmonious" ["調和的"])
("harmony" ["調和"])
("harness" ["馬具"])
("harp" ["豎琴"])
("harrow" ["耙"])
("harry" ["掠奪"])
("harsh" ["苛刻"])
("hart" ["牡鹿"])
("harvest" ["收成"])
("has" ["有"])
("hasn't" ["沒有"])
("haste" ["匆忙"])
("hasten" ["促進"])
("hastily" ["匆忙地"])
("hasty" ["急忙的"])
("hat" ["帽子"])
("hatch" ["孵"])
("hatchet" ["斧頭"])
("hate" ["厭恨"])
("hateful" ["可恨的"])
("hatred" ["憎恨"])
("haughty" ["驕傲的"])
("haul" ["拖拉"])
("haunt" ["出沒"])
("have" ["有"])
("havoc" ["破壞"])
("hawk" ["鷹"])
("hay" ["乾草"])
("hazard" ["冒險"])
("haze" ["薄霧"])
("hazel" ["榛"])
("he" ["他"])
("head" ["頭部"])
("headache" ["頭痛"])
("headlight" ["車前燈"])
("headline" ["標題"])
("headlong" ["頭向前的"])
("headquarters" ["總部"])
("heal" ["復原"])
("health" ["健康"])
("healthful" ["衛生的"])
("healthy" ["健康的"])
("heap" ["堆" "大量"])
("hear" ["聽見"])
("hearer" ["聽眾"])
("hearing" ["聽力"])
("heart" ["心"])
("hearth" ["爐床"])
("hearty" ["誠懇的"])
("heat" ["熱力"])
("heater" ["暖氣"])
("heath" ["石南樹"])
("heathen" ["異教徒"])
("heather" ["石南屬"])
("heave" ["舉起"])
("heaven" ["天堂"])
("heavenly" ["天堂的"])
("heavy" ["沈重的"])
("hebrew" ["猶太人"])
("hectogram" ["公兩"])
("hectoliter" ["公石"])
("hectometer" ["公引"])
("hedge" ["樹籬"])
("heed" ["注意"])
("heedless" ["不小心的"])
("heel" ["腳跟"])
("heifer" ["小牝牛"])
("height" ["高度"])
("heighten" ["增高"])
("heir" ["繼乘人"])
("hell" ["地獄"])
("hello" ["哈囉"])
("helm" ["舵"])
("helmet" ["盔"])
("help" ["幫忙"])
("helper" ["助手"])
("helpful" ["有幫助的"])
("helpless" ["無助的"])
("hem" ["衣服縫邊"])
("hemisphere" ["半球"])
("hemlock" ["毒草名"])
("hemp" ["大麻"])
("hen" ["母雞"])
("hence" ["因此"])
("henceforth" ["從今以後"])
("her" ["她"])
("herald" ["先鋒"])
("herb" ["香草"])
("herd" ["群"])
("here" ["這裡"])
("hereafter" ["今後"])
("hereby" ["特此"])
("hereditary" ["遺傳的"])
("herein" ["在此處"])
("heresy" ["異教"])
("heretic" ["異教徒"])
("heretofore" ["此時以前"])
("heritage" ["遺產"])
("hermit" ["隱士"])
("hero" ["英雄"])
("heroic" ["英雄式的"])
("heroine" ["女英雄"])
("heroism" ["英勇的行為"])
("heron" ["蒼鷺"])
("herring" ["青魚"])
("hers" ["她的"])
("herself" ["她自己"])
("hesitate" ["遲疑"])
("hesitation" ["疑慮"])
("hew" ["砍伐"])
("hey" ["喂"])
("hickory" ["山胡桃木"])
("hide" ["躲藏"])
("hideous" ["可怕的"])
("high" ["高的"])
("highland" ["高地"])
("highly" ["高度地"])
("highness" ["高度地"])
("highway" ["高速公路"])
("hike" ["遠足"])
("hiking" ["徒步旅行"])
("hill" ["小丘"])
("hillside" ["山坡"])
("hilltop" ["山頂"])
("him" ["他"])
("himself" ["他自己"])
("hind" ["後邊的"])
("hinder" ["阻止"])
("hinge" ["關鍵"])
("hint" ["暗示"])
("hip" ["臀部"])
("hire" ["僱用"])
("his" ["他的"])
("hiss" ["嘶嘶聲"])
("historian" ["歷史學家"])
("historic" ["歷史性的"])
("historical" ["歷史上的"])
("history" ["歷史的"])
("hit" ["打"])
("hitch" ["拴住"])
("hither" ["到此處"])
("hitherto" ["至今"])
("hive" ["蜂房"])
("ho" ["嚇聲"])
("hoard" ["囤積"])
("hoarse" ["嘶啞聲"])
("hobby" ["嗜好"])
("hockey" ["曲棍球"])
("hoe" ["鋤頭"])
("hog" ["豬"])
("hoist" ["升起"])
("hold" ["握住"])
("holder" ["持有人"])
("hole" ["洞穴"])
("holiday" ["假日"])
("hollow" ["空的"])
("holly" ["冬青樹"])
("holy" ["神聖的"])
("homage" ["效忠"])
("home" ["家園"])
("homely" ["家常的"])
("homemade" ["自製的"])
("homesick" ["想家"])
("homestead" ["家園"])
("homeward" ["回家"])
("homework" ["家庭作業"])
("honest" ["誠實的"])
("honestly" ["坦白的"])
("honesty" ["誠實"])
("honey" ["蜂蜜" "愛人"])
("honeycomb" ["蜂房"])
("honeymoon" ["蜜月假期"])
("honeysuckle" ["金銀花"])
("honor" ["榮譽"])
("honourable" ["誠實的"])
("hood" ["兜帽"])
("hoof" ["蹄"])
("hook" ["鉤子"])
("hoop" ["圈狀物"])
("hoot" ["叫囂" "鳴叫"])
("hop" ["跳躍"])
("hope" ["希望"])
("hopeful" ["有希望的"])
("hopeless" ["絕望的"])
("hopely" ["有希望地"])
("horde" ["群眾"])
("horizon" ["地平線"])
("horizontal" ["水平的"])
("horn" ["犄角"])
("horrible" ["可怕的"])
("horribly" ["可怕地"])
("horrid" ["討厭地"])
("horrify" ["驚嚇"])
("horror" ["恐怖"])
("horse" ["馬"])
("horseback" ["馬背"])
("horseman" ["騎師"])
("horsepower" ["馬力"])
("horseshoe" ["馬蹄鐵"])
("hose" ["長襪"])
("hospital" ["醫院"])
("hospitality" ["親切"])
("hostess" ["女主人"])
("hostile" ["懷敵意的"])
("hostility" ["敵意"])
("hot" ["熱"])
("hotel" ["旅館"])
("hound" ["獵犬"])
("hour" ["一小時"])
("house" ["屋子"])
("household" ["家族"])
("housekeeper" ["女管家"])
("housekeeping" ["家政"])
("housewife" ["主婦"])
("housework" ["家事"])
("hover" ["徘徊"])
("how" ["怎樣"])
("however" ["然而"])
("howl" ["狂吠"])
("hue" ["色調"])
("hug" ["緊抱"])
("huge" ["巨大的"])
("hum" ["哼聲"])
("human" ["人性" "人的"])
("humane" ["有人情的"])
("humanism" ["人道主義"])
("humanity" ["人道"])
("humble" ["謙遜"])
("humiliate" ["羞辱"])
("humiliation" ["丟臉"])
("humility" ["謙遜"])
("humor" ["幽默"])
("humorous" ["幽默的"])
("hundred" ["一百"])
("hunger" ["飢餓"])
("hungry" ["飢餓的"])
("hunt" ["打獵"])
("hunter" ["獵人"])
("hurricane" ["颱風"])
("hurried" ["倉促的"])
("hurry" ["急忙"])
("hurt" ["使受傷"])
("husband" ["丈夫"])
("hut" ["茅舍"])
("hybrid" ["混血"])
("hydrogen" ["氫氣"])
("hygiene" ["衛生"])
("hymn" ["聖歌"])
("hyphen" ["連字符號"])
("hypocrisy" ["偽善"])
("hypocrite" ["偽善者"])
("hysterical" ["狂亂的"])
("ice" ["冰" "cream" "冰淇淋"])
("iceberg" ["冰山"])
("icy" ["冰的"])
("idea" ["主意"])
("identical" ["全同的"])
("identify" ["確認"])
("idiom" ["成語"])
("idiot" ["白癡"])
("idle" ["懶惰的"])
("idleness" ["怠惰"])
("idol" ["偶像"])
("if" ["如果"])
("ignorance" ["無知"])
("ignorant" ["愚昧的"])
("ignore" ["忽視"])
("ill" ["生病的"])
("illegal" ["不合法的"])
("illness" ["疾病"])
("illuminate" ["說明"])
("illumination" ["亮度"])
("illusion" ["幻象"])
("illustrate" ["圖解說明"])
("illustration" ["插圖"])
("illustrator" ["畫插圖者"])
("illustrious" ["傑出的"])
("image" ["形像"])
("imaginary" ["虛構的"])
("imagination" ["想像"])
("imaginative" ["富於想像的"])
("imagine" ["想像"])
("imitate" ["模倣"])
("imitation" ["模擬"])
("immediate" ["立刻的"])
("immediately" ["即刻地"])
("immemorial" ["太古的"])
("immense" ["無限的"])
("immigrant" ["移民"])
("immigration" ["遷居移民"])
("imminent" ["即將來臨的"])
("immortal" ["不朽的"])
("immortality" ["不朽"])
("impair" ["損害"])
("impart" ["傳授"])
("impartial" ["公平的"])
("impatience" ["不耐煩"])
("impatient" ["不耐煩的"])
("impel" ["推進"])
("imperative" ["必要的"])
("imperfect" ["不完善的"])
("imperial" ["帝國的"])
("imperious" ["傲慢的"])
("impetuous" ["奔騰的"])
("implement" ["器具"])
("implore" ["哀求"])
("imply" ["暗示"])
("import" ["進口"])
("importance" ["重要性"])
("important" ["重要的"])
("impose" ["加﹍於"])
("imposing" ["堂皇的"])
("impossibility" ["不可能的事"])
("impossible" ["不可能的"])
("impress" ["印像深刻"])
("impression" ["印像"])
("impressive" ["難忘的"])
("imprison" ["下獄"])
("imprisonment" ["坐牢"])
("improper" ["不合適的"])
("improve" ["改良"])
("improvement" ["改善"])
("impulse" ["衝力"])
("in" ["在﹍之內"])
("inability" ["無能"])
("inactive" ["遲頓的"])
("inadequate" ["不適當的"])
("inasmuch" ["因﹍之故"])
("inaugurate" ["就任"])
("incapable" ["無能的"])
("incense" ["香氣"])
("incentive" ["動機"])
("incessant" ["不停的"])
("inch" ["吋"])
("incident" ["事件"])
("incidentally" ["偶然地"])
("inclination" ["傾向"])
("incline" ["傾斜"])
("inclose" ["封入"])
("include" ["包含"])
("income" ["收入"])
("inconvenience" ["不方便"])
("inconvenient" ["不方便的"])
("incorporate" ["組成公司"])
("increase" ["增加"])
("increasingly" ["逐漸地"])
("incredible" ["難以置信的"])
("incur" ["引起"])
("indebted" ["負債"])
("indeed" ["的確"])
("indefinite" ["不明確的"])
("independence" ["獨立"])
("independent" ["獨立的"])
("index" ["索引"])
("indicate" ["指示"])
("indication" ["指示"])
("indicative" ["指示的"])
("indictment" ["起訴"])
("indifference" ["不重視"])
("indifferent" ["無關緊要的"])
("indignant" ["憤憤不平"])
("indignation" ["憤怒"])
("indigo" ["靛青"])
("indirect" ["間接的"])
("indispensable" ["不可缺少的"])
("individual" ["個別的"])
("individuality" ["個性"])
("indoor" ["室內的"])
("indoors" ["在室內"])
("induce" ["引起"])
("indulge" ["放任"])
("indulgence" ["嗜好"])
("industrial" ["工業的"])
("industrious" ["勤勉的"])
("industry" ["工業"])
("inert" ["無生命的"])
("inevitable" ["必然的"])
("inexpensive" ["廉價的"])
("inexperience" ["沒經驗"])
("infancy" ["嬰兒期"])
("infant" ["嬰兒"])
("infantry" ["步兵"])
("infect" ["傳染"])
("infection" ["傳染"])
("infer" ["推論"])
("inference" ["論斷"])
("inferior" ["低等的"])
("infernal" ["地獄的"])
("infest" ["擾亂"])
("infinite" ["無限的"])
("infinitive" ["不定詞"])
("inflame" ["激起"])
("inflation" ["通貨膨脹"])
("inflict" ["加以"])
("influence" ["影響"])
("influential" ["有影響的"])
("influenza" ["流行性感冒"])
("inform" ["通知"])
("informal" ["非正式的"])
("information" ["消息" "資料"])
("ingenious" ["有創造力的"])
("ingenuity" ["創造力"])
("ingredient" ["成分"])
("inhabit" ["居住於"])
("inhabitant" ["居住者"])
("inherit" ["繼承"])
("inheritance" ["繼承權"])
("inheritress" ["女繼承人"])
("initial" ["最初的"])
("initiative" ["初步"])
("injunction" ["命令"])
("injure" ["受傷害"])
("injurious" ["有害的"])
("injury" ["受傷"])
("injustice" ["不公正"])
("ink" ["墨水"])
("inkstand" ["墨水瓶架"])
("inland" ["內地的"])
("inlet" ["入口"])
("inmate" ["室友"])
("inn" ["旅館"])
("inner" ["內在的"])
("inning" ["一局"])
("innocence" ["無辜"])
("innocent" ["無辜的"])
("innumerable" ["無數的"])
("inquire" ["詢問" "調查"])
("inquiry" ["詢問" "查調"])
("inquisitive" ["好奇的"])
("insane" ["有精神病的"])
("insanity" ["精神錯亂"])
("inscribe" ["刻寫"])
("inscription" ["題字"])
("insect" ["昆蟲"])
("insensible" ["沒有知覺的"])
("inseparable" ["不可分離的"])
("insert" ["插入"])
("inside" ["內部"])
("insight" ["眼光"])
("insignificant" ["無關緊要的"])
("insist" ["堅持"])
("insolent" ["粗野的"])
("inspect" ["檢查"])
("inspection" ["調查"])
("inspector" ["檢查員"])
("inspiration" ["靈感"])
("inspire" ["激發"])
("install" ["安裝"])
("installation" ["裝置物"])
("installment" ["分期付款"])
("instance" ["例證"])
("instant" ["即刻"])
("instantly" ["即刻地"])
("instead" ["代替"])
("instinct" ["本能"])
("instinctive" ["直覺的"])
("institute" ["研究所"])
("institution" ["團體"])
("instruct" ["教導"])
("instruction" ["指示"])
("instructive" ["教育性"])
("instructor" ["講師"])
("instrument" ["儀器"])
("insufficient" ["不足的"])
("insult" ["侮辱"])
("insurance" ["保險"])
("insure" ["保險"])
("intellect" ["知識份子"])
("intellectual" ["智力的"])
("intelligence" ["智能"])
("intelligent" ["智能高的"])
("intend" ["打算"])
("intense" ["緊張的"])
("intensity" ["強度"])
("intent" ["意圖"])
("intention" ["意圖"])
("intently" ["一心一意"])
("intercept" ["截奪"])
("interchange" ["互換"])
("intercourse" ["交接"])
("interest" ["興致"])
("interested" ["有興趣的"])
("interesting" ["有興趣的"])
("interfere" ["妨礙"])
("interference" ["干擾"])
("interior" ["在內的"])
("interjection" ["感嘆詞"])
("intermediate" ["中間的"])
("internal" ["內在的"])
("international" ["國際的"])
("interpret" ["翻譯"])
("interpretation" ["解釋"])
("interpreter" ["翻譯者"])
("interrogation" ["疑問"])
("interrogative" ["疑問的"])
("interrupt" ["中斷"])
("interruption" ["干擾"])
("interval" ["間隔"])
("intervene" ["干涉"])
("intervention" ["介入"])
("interview" ["晤面"])
("intimacy" ["親近"])
("intimate" ["親切的"])
("into" ["到"])
("intolerable" ["無法忍受的"])
("intonation" ["發聲法"])
("intoxicate" ["使醉"])
("intricate" ["糾纏的"])
("intrigue" ["陰謀"])
("introduce" ["介紹"])
("introduction" ["引導"])
("intrude" ["擠入"])
("intruder" ["侵入者"])
("intrusion" ["侵入"])
("invade" ["侵擾"])
("invader" ["侵入者"])
("invalid" ["病人"])
("invaluable" ["無價的"])
("invariably" ["不變化地"])
("invasion" ["侵入"])
("invent" ["發明"])
("invention" ["發明"])
("inventor" ["發明家"])
("invert" ["顛倒過來"])
("invest" ["投資"])
("investigate" ["調查"])
("investigation" ["調查"])
("investigator" ["研究者"])
("investment" ["投資"])
("investor" ["投資者"])
("invisible" ["眼看不見的"])
("invitation" ["邀請"])
("invite" ["邀請"])
("involuntary" ["自然而然的"])
("involve" ["捲入"])
("inward" ["中心的"])
("iris" ["鳶尾花"])
("iron" ["鐵"])
("irony" ["諷刺"])
("irregular" ["不規則的"])
("irresistible" ["不能抵抗的"])
("irrigation" ["灌溉"])
("irritate" ["激怒"])
("irritation" ["刺激"])
("is" ["是"])
("island" ["島"])
("isle" ["小島"])
("isolate" ["使孤立"])
("it" ["它"])
("itch" ["癢"])
("item" ["項目"])
("its" ["它的"])
("itself" ["它本身"])
("ivory" ["象牙"])
("ivy" ["常春藤"])
("jack" ["小起重機"])
("jacket" ["夾克"])
("jail" ["監獄"])
("jam" ["果醬" "阻塞"])
("january" ["一月"])
("japan" ["日本"])
("jar" ["缸"])
("jaw" ["顎"])
("jazz" ["爵士舞"])
("jealous" ["妒忌的"])
("jealousy" ["妒忌"])
("jeer" ["嘲笑"])
("jelly" ["果子凍"])
("jerk" ["愚笨之人"])
("jersey" ["毛織運動衫"])
("jest" ["戲弄"])
("jet" ["噴射"])
("jewel" ["寶石"])
("jewelry" ["首飾"])
("jingle" ["叮鈴"])
("job" ["職業"])
("join" ["接合"])
("joint" ["關節"])
("joke" ["笑話"])
("jolly" ["痛快的"])
("journal" ["日誌"])
("journalism" ["新聞學"])
("journalist" ["新聞記者"])
("journey" ["旅程"])
("joy" ["喜悅"])
("joyful" ["歡喜的"])
("joyous" ["快樂的"])
("judge" ["法官" "裁判"])
("judgment" ["判斷"])
("judicial" ["司法的"])
("jug" ["細頸瓶"])
("juice" ["汁液"])
("juicy" ["多水分的"])
("july" ["七月"])
("jump" ["跳躍"])
("jumpy" ["神經過敏的"])
("junction" ["會合"])
("june" ["六月"])
("jungle" ["叢林"])
("junior" ["初級的"])
("jurisdiction" ["司法權"])
("jury" ["陪審團"])
("just" ["正好"])
("justice" ["正義"])
("justification" ["辯護"])
("justify" ["辯護"])
("justly" ["公正地"])
("jut" ["突出"])
("juvenile" ["少年的"])
("kangaroo" ["袋鼠"])
("keel" ["龍骨"])
("keen" ["敏銳的"])
("keep" ["保持" "收藏"])
("keeper" ["管理人"])
("keeping" ["保管"])
("ken" ["眼界"])
("kennel" ["狗屋"])
("kernel" ["顆粒"])
("kerosene" ["煤油"])
("kettle" ["水壺"])
("key" ["鑰匙"])
("kick" ["踢"])
("kid" ["小孩"])
("kidnap" ["綁架"])
("kidney" ["腎"])
("kill" ["殺"])
("kiloliter" ["公秉"])
("kilometer" ["公里"])
("kin" ["親屬"])
("kind" ["仁慈" "種類"])
("kindle" ["燃燒"])
("kindly" ["仁慈地"])
("kindness" ["仁慈"])
("kindred" ["親屬"])
("king" ["國王"])
("kingdom" ["王國"])
("kingly" ["國王的"])
("kinsman" ["男性親屬"])
("kiss" ["接吻"])
("kitchen" ["廚房"])
("kite" ["風箏"])
("kitten" ["小貓"])
("kitty" ["貓咪"])
("knave" ["騙子"])
("knead" ["搓揉"])
("knee" ["膝蓋"])
("kneel" ["下跪"])
("knell" ["喪鐘"])
("knife" ["刀子"])
("knight" ["騎士"])
("knighthood" ["騎士風格"])
("knightly" ["騎士的"])
("knit" ["編織"])
("knob" ["把手"])
("knock" ["敲" "撞"])
("knoll" ["小丘"])
("knot" ["打結"])
("know" ["知到"])
("knowing" ["博學的"])
("knowledge" ["知識"])
("known" ["知名的"])
("knuckle" ["指關節"])
("label" ["標籤"])
("labor" ["勞工" "分娩"])
("laboratory" ["實驗室"])
("laborer" ["勞動者"])
("laborious" ["辛勞的"])
("lace" ["花邊"])
("lack" ["缺乏"])
("lad" ["小伙子"])
("ladder" ["階梯"])
("laden" ["充滿的"])
("lady" ["女士"])
("lag" ["落後"])
("lair" ["巢穴"])
("lake" ["湖"])
("lamb" ["小羊"])
("lame" ["跛足"])
("lament" ["哀悼"])
("lamentable" ["可悲的"])
("lamentation" ["哀傷"])
("lamp" ["燈"])
("lance" ["長矛"])
("land" ["土地"])
("landing" ["著陸"])
("landlady" ["女房東"])
("landlord" ["房東"])
("landmark" ["界標"])
("landscape" ["風景"])
("lane" ["小路"])
("language" ["語言"])
("languish" ["凋謝" "憔悴"])
("lantern" ["燈籠"])
("lap" ["大腿" "重疊"])
("lapse" ["失誤"])
("lard" ["豬油"])
("large" ["大的"])
("lark" ["雲雀"])
("larva" ["幼蟲"])
("lash" ["睫毛" "皮鞭"])
("lass" ["女孩"])
("last" ["最後的"])
("lasting" ["持久的"])
("latch" ["門閂"])
("late" ["遲了"])
("lately" ["最近"])
("latent" ["潛在的"])
("later" ["更遲的"])
("lateral" ["旁邊的"])
("latest" ["最遲的"])
("latitude" ["緯線"])
("latter" ["後者"])
("laugh" ["笑"])
("laughter" ["笑聲"])
("launch" ["發動" "創辦"])
("laundry" ["洗衣店"])
("laurel" ["月桂樹"])
("lava" ["岩漿"])
("lavender" ["薰衣草"])
("lavish" ["浪費的"])
("lavishly" ["過度地"])
("law" ["法律"])
("lawful" ["合法的"])
("lawless" ["非法的"])
("lawn" ["草地"])
("lawyer" ["律師"])
("lay" ["安置" "產卵"])
("layer" ["一層"])
("layman" ["外行人"])
("lazily" ["懶洋洋地"])
("lazy" ["懶惰的"])
("lead" ["鉛" "引導"])
("leader" ["領導者"])
("leadership" ["領導能力"])
("leading" ["領導的"])
("leaf" ["樹葉"])
("leafy" ["多葉的"])
("league" ["聯盟"])
("leak" ["會漏的"])
("lean" ["傾斜" "瘦的"])
("leap" ["跳" "躍"])
("learn" ["學習"])
("learned" ["有學問的"])
("learning" ["學問"])
("lease" ["租約"])
("least" ["最少的"])
("leather" ["皮革"])
("leave" ["留下" "離開"])
("leaven" ["酵母"])
("lecture" ["演講"])
("lecturer" ["講師"])
("ledge" ["壁架" "暗礁"])
("lee" ["避風處"])
("leech" ["水蛭"])
("left" ["左邊"])
("leg" ["腿"])
("legal" ["法律的"])
("legally" ["合法地"])
("legend" ["傳說"])
("legion" ["軍團"])
("legislation" ["法規"])
("legislative" ["立法的"])
("legislature" ["立法機關"])
("legitimate" ["合法的"])
("leisure" ["閒暇"])
("leisurely" ["悠閒的"])
("lemon" ["檸檬"])
("lemonade" ["檸檬水"])
("lend" ["借出"])
("length" ["長度"])
("lengthen" ["加長"])
("lens" ["鏡頭"])
("leopard" ["豹子"])
("less" ["較少的"])
("lessen" ["減少"])
("lesser" ["比較少"])
("lesson" ["課程"])
("lest" ["以免"])
("let" ["讓" "假定"])
("letter" ["字母"])
("lettuce" ["生菜"])
("level" ["水準"])
("lever" ["槓桿"])
("levy" ["徵收"])
("liability" ["責任"])
("liable" ["有責任的"])
("liar" ["說謊者"])
("liberal" ["自由派的"])
("liberate" ["釋放"])
("liberty" ["自由"])
("librarian" ["圖書管理員"])
("library" ["圖書館"])
("license" ["執照"])
("lichen" ["青苔"])
("lick" ["舔"])
("lid" ["蓋子"])
("lie" ["謊話"])
("lieutenant" ["陸軍中尉"])
("life" ["生命"])
("lifeless" ["無生命的"])
("lifetime" ["一生"])
("lift" ["舉起"])
("light" ["光"])
("lighten" ["照亮"])
("lighthouse" ["燈塔"])
("lightly" ["輕輕的"])
("lightning" ["閃電"])
("like" ["喜歡"])
("likelihood" ["多半"])
("likely" ["或許" "可能"])
("likeness" ["類似"])
("likewise" ["同樣地"])
("liking" ["愛好"])
("lilac" ["紫丁香"])
("lily" ["百合花"])
("limb" ["手足"])
("lime" ["石灰"])
("limestone" ["石灰石"])
("limit" ["範圍"])
("limitation" ["限制"])
("limited" ["有限的"])
("limp" ["徐行"])
("line" ["線"])
("linen" ["亞麻布"])
("linger" ["徘徊"])
("lining" ["襯裡"])
("link" ["鏈環"])
("linoleum" ["油布"])
("lion" ["獅子"])
("lip" ["唇"])
("liquid" ["液體"])
("liquor" ["酒精飲料"])
("list" ["名單"])
("listen" ["傾聽"])
("listener" ["傾聽者"])
("liter" ["公升"])
("literal" ["文字的"])
("literally" ["按照字面"])
("literary" ["文學的"])
("literature" ["文藝" "文獻"])
("litter" ["殘餘物"])
("little" ["小"])
("live" ["居住"])
("livelihood" ["生計"])
("lively" ["生氣勃勃的"])
("liver" ["肝臟"])
("livery" ["出租車"])
("living" ["生的"])
("lizard" ["蜥蜴"])
("load" ["負載"])
("loaf" ["一塊麵"])
("loan" ["借款"])
("loath" ["厭惡的"])
("loathe" ["憎惡"])
("lobby" ["休息室"])
("lobster" ["龍蝦"])
("local" ["地方性的"])
("locality" ["位置"])
("locate" ["設置"])
("location" ["場所"])
("lock" ["鎖"])
("locomotive" ["機關車"])
("locust" ["蝗蟲"])
("lodge" ["小屋"])
("lodging" ["住宿"])
("loft" ["樓廂"])
("lofty" ["高遠的"])
("log" ["圓形木材"])
("logic" ["邏輯"])
("logical" ["邏輯的"])
("loin" ["腰肉"])
("loiter" ["閒混"])
("lone" ["孤單的"])
("loneliness" ["孤單"])
("lonely" ["寂寞的"])
("lonesome" ["寂寞的"])
("long" ["長"])
("longing" ["切望"])
("longitude" ["經度"])
("look" ["看"])
("lookout" ["眺望"])
("loom" ["織布機"])
("loop" ["圈"])
("loose" ["鬆開的"])
("loosen" ["放鬆"])
("lord" ["貴族"])
("lordly" ["有氣派的"])
("lordship" ["貴族身份"])
("lorry" ["載貨汽車"])
("lose" ["失"])
("loss" ["損失"])
("lost" ["失去的"])
("lot" ["大量,地皮"])
("loud" ["高聲的"])
("loudly" ["高聲地"])
("loudspeaker" ["喇叭"])
("lounge" ["休息室"])
("love" ["愛"])
("lovely" ["可愛的"])
("lover" ["愛人"])
("loving" ["愛的"])
("low" ["低的"])
("lower" ["降下"])
("lowland" ["低地"])
("loyal" ["忠誠的"])
("loyalty" ["忠誠"])
("luck" ["運氣"])
("luckily" ["僥倖地"])
("lucky" ["好運的"])
("luggage" ["行李"])
("lullaby" ["催眠曲"])
("lumber" ["木料"])
("luminous" ["發光的"])
("lump" ["塊狀"])
("lunatic" ["喪心病狂的"])
("lunch" ["午餐"])
("luncheon" ["午餐"])
("lung" ["肺"])
("lure" ["吸引"])
("lust" ["慾望"])
("luster" ["光澤"])
("lute" ["琵琶"])
("luxurious" ["豪華的"])
("luxury" ["奢侈"])
("lyric" ["歌詞"])
("machine" ["機器"])
("machinery" ["機械裝置"])
("mad" ["發狂" "發怒"])
("madam" ["太太"])
("madame" ["夫人"])
("made" ["製造的"])
("madly" ["發狂地"])
("madman" ["狂人"])
("madness" ["瘋狂"])
("magazine" ["雜誌"])
("magic" ["魔術"])
("magician" ["魔術師"])
("magistrate" ["行政長官"])
("magnet" ["磁鐵"])
("magnetic" ["磁性的"])
("magnificence" ["壯麗"])
("magnificent" ["壯麗的"])
("magnify" ["擴大"])
("magnitude" ["大小"])
("mahogany" ["桃花心木"])
("maid" ["侍女"])
("maiden" ["少女"])
("mail" ["郵件"])
("maim" ["傷害"])
("main" ["最主要的"])
("mainland" ["大陸"])
("mainly" ["主要地"])
("maintain" ["維護"])
("maintenance" ["維持費"])
("majestic" ["崇高的"])
("majesty" ["尊嚴"])
("major" ["主要" "主修"])
("majority" ["多數"])
("make" ["造" "得" "使"])
("maker" ["製造者"])
("makeup" ["化妝品"])
("malady" ["疾病"])
("malaria" ["瘧疾"])
("male" ["雄性的"])
("malice" ["惡意"])
("malicious" ["惡毒的"])
("mama" ["媽媽"])
("mamma" ["媽媽"])
("mammal" ["哺乳動物"])
("man" ["男人"])
("manage" ["管理"])
("management" ["管理"])
("manager" ["經理"])
("mandate" ["命令"])
("mandolin" ["洋琵琶"])
("mane" ["鬃"])
("maneuver" ["演習" "巧計"])
("manger" ["食槽"])
("mangle" ["撕裂"])
("manhood" ["成人"])
("manifest" ["明膫的"])
("manifestation" ["證明"])
("manifold" ["多樣的"])
("mankind" ["人類"])
("manly" ["男子氣的"])
("manner" ["態度" "方法"])
("manor" ["封地"])
("mansion" ["大廈"])
("mantle" ["斗篷"])
("manual" ["手冊"])
("manufacture" ["製造"])
("manufacturer" ["製造業者"])
("manure" ["肥料"])
("manuscript" ["手稿"])
("many" ["許多的"])
("map" ["地圖"])
("maple" ["楓樹"])
("mar" ["損壞"])
("marble" ["大理石"])
("march" ["三月"])
("mare" ["母馬"])
("margin" ["邊緣"])
("marginal" ["界限的"])
("marine" ["海裡的"])
("mariner" ["水手"])
("maritime" ["海上的"])
("mark" ["符號"])
("market" ["市場"])
("marquis" ["侯爵"])
("marriage" ["婚姻"])
("married" ["已婚的"])
("marrow" ["骨髓"])
("marry" ["結婚"])
("marsh" ["沼澤"])
("marshal" ["軍官"])
("mart" ["商業中心"])
("martial" ["軍事的"])
("martyr" ["烈士"])
("marvel" ["奇事" "奇景"])
("marvellous" ["不平凡的"])
("marvellously" ["不平凡地"])
("masculine" ["男子氣的"])
("mash" ["糊"])
("mask" ["面具"])
("mason" ["泥水匠"])
("masquerade" ["化妝舞會"])
("mass" ["大量"])
("massacre" ["大屠殺"])
("massive" ["大量的"])
("mast" ["天線"])
("masterpiece" ["名著"])
("mat" ["墊子"])
("match" ["火柴" "相配"])
("matchless" ["無比的"])
("mate" ["配偶"])
("material" ["材料" "物質"])
("materially" ["物質上的"])
("maternal" ["母係的"])
("mathematic" ["數學的"])
("mathematics" ["數學"])
("matron" ["女舍監"])
("matter" ["事情"])
("mattress" ["床墊"])
("mature" ["成熟"])
("maturity" ["成熟" "到期"])
("maxim" ["格言"])
("maximum" ["最多的"])
("may" ["五月" "可能"])
("maybe" ["大概"])
("mayonnaise" ["美乃滋醬"])
("mayor" ["市長"])
("maze" ["迷陣"])
("me" ["我"])
("mead" ["蜂蜜酒"])
("meadow" ["草地"])
("meager" ["清瘦的"])
("meal" ["膳食"])
("mean" ["意謂" "吝嗇"])
("meaning" ["含意"])
("means" ["方法"])
("meantime" ["同時"])
("meanwhile" ["同時"])
("measles" ["痲疹"])
("measure" ["度量"])
("measurement" ["度量衡"])
("meat" ["肉"])
("mechanic" ["技工"])
("mechanical" ["機械的"])
("mechanically" ["機械地"])
("mechanism" ["結構"])
("medal" ["獎章"])
("meddle" ["介入"])
("medicine" ["藥劑"])
("medieval" ["中世紀的"])
("meditate" ["考慮"])
("meditation" ["沈思"])
("medium" ["中等的"])
("meek" ["謙和的"])
("meekly" ["謙和地"])
("meet" ["遇見" "會合"])
("meeting" ["會議"])
("megaphone" ["擴音器"])
("melancholy" ["愁緒"])
("mellow" ["成熟的"])
("melody" ["旋律"])
("melon" ["瓜"])
("melt" ["溶化"])
("member" ["會員"])
("membership" ["會友"])
("membrane" ["薄膜"])
("memoir" ["調查報告"])
("memorable" ["難忘的"])
("memorandum" ["備忘錄"])
("memorial" ["紀念"])
("memorize" ["記住"])
("memory" ["記憶"])
("menace" ["威脅"])
("mend" ["修補"])
("mental" ["心理的"])
("mention" ["提到"])
("menu" ["菜單"])
("mercenary" ["受僱的"])
("merchandise" ["商品"])
("merchant" ["商人"])
("merciful" ["仁慈的"])
("merciless" ["殘忍的"])
("mercury" ["水銀"])
("mercy" ["慈悲"])
("mere" ["僅僅的"])
("merely" ["僅僅"])
("merge" ["合併"])
("meridian" ["子午線"])
("merit" ["優點"])
("merrily" ["快樂地"])
("merriment" ["歡樂"])
("merry" ["快樂的"])
("mesh" ["網孔"])
("mess" ["雜亂"])
("message" ["音信"])
("messenger" ["信差"])
("metal" ["金屬"])
("metallic" ["金屬的"])
("meteor" ["流星"])
("meter" ["公尺"])
("methinks" ["我認為"])
("method" ["方法"])
("metropolis" ["首府"])
("metropolitan" ["大都會"])
("mew" ["貓叫聲"])
("mexican" ["墨西哥人"])
("mexico" ["墨西哥"])
("microphone" ["擴音器"])
("microscope" ["顯微鏡"])
("mid" ["中間的"])
("midday" ["正午"])
("middle" ["中間"])
("middleaged" ["中年的"])
("midnight" ["午夜"])
("midst" ["中央"])
("midsummer" ["仲夏"])
("midway" ["中途"])
("might" ["強權"])
("mighty" ["強勢的"])
("migrate" ["遷移"])
("migration" ["遷居"])
("mild" ["溫和的"])
("mildly" ["溫和地"])
("mile" ["英里"])
("military" ["軍事的"])
("milk" ["牛奶"])
("milky" ["乳白色的"])
("mill" ["磨子"])
("miller" ["磨坊主"])
("milligram" ["毫克"])
("milliliter" ["公撮"])
("millimeter" ["公釐"])
("million" ["百萬"])
("millionaire" ["百萬富翁"])
("millstone" ["磨石"])
("mince" ["剁碎"])
("mind" ["心"])
("mine" ["我的"])
("miner" ["礦工"])
("mineral" ["礦物"])
("mingle" ["混合"])
("miniature" ["縮小模型"])
("minimum" ["最低限度"])
("mining" ["採礦"])
("minister" ["部長"])
("ministry" ["牧師之職"])
("mink" ["貂皮"])
("minor" ["未成年人"])
("minority" ["少數民族"])
("mint" ["薄荷"])
("minus" ["減去"])
("minute" ["分鐘"])
("miracle" ["奇蹟"])
("miraculous" ["奇蹟的"])
("mirror" ["鏡子"])
("miscellaneous" ["雜項的"])
("mischief" ["惡作劇"])
("mischievous" ["惡作劇的"])
("miser" ["吝嗇"])
("miserable" ["淒慘的"])
("miserably" ["可哀地"])
("misery" ["不幸"])
("misfortune" ["不幸"])
("mishap" ["不幸之事"])
("miss" ["小姐" "失誤"])
("missile" ["飛彈"])
("mission" ["任務"])
("missionary" ["傳道者的"])
("mist" ["霧"])
("mistake" ["錯"])
("mister" ["先生"])
("mistress" ["女主人"])
("mistrust" ["不信任"])
("misty" ["迷濛的"])
("misunderstanding" ["誤會"])
("misuse" ["誤用"])
("mitten" ["手套"])
("mix" ["混雜"])
("mixture" ["混合物"])
("moan" ["悲嘆"])
("moat" ["護城河"])
("mob" ["烏合之眾"])
("mock" ["愚弄"])
("mockery" ["嘲笑"])
("mode" ["樣式"])
("model" ["模式"])
("moderate" ["適當的"])
("moderately" ["適度地"])
("moderation" ["緩和"])
("modern" ["現代的"])
("modest" ["謙虛的"])
("modestly" ["謹慎地"])
("modesty" ["謙遜"])
("modification" ["修正"])
("modify" ["修正"])
("moist" ["濕的"])
("moisten" ["濡濕"])
("moisture" ["濕氣"])
("mold" ["模子"])
("mole" ["黑痣"])
("molest" ["折磨"])
("molten" ["融解"])
("moment" ["瞬間"])
("momentary" ["瞬間的"])
("monarch" ["君主"])
("monarchy" ["君主政治"])
("monastery" ["修道院"])
("monday" ["星期一"])
("money" ["錢"])
("monk" ["僧侶"])
("monkey" ["猴子"])
("monopoly" ["壟斷販賣"])
("monotonous" ["單調的"])
("monster" ["怪物"])
("monstrous" ["怪物似的"])
("month" ["月"])
("monument" ["紀念碑"])
("monumental" ["極為龐大"])
("mood" ["心情"])
("moon" ["月亮"])
("moonlight" ["月光"])
("moose" ["大鹿"])
("mop" ["拖把"])
("moral" ["道德"])
("morality" ["道德"])
("more" ["更多"])
("moreover" ["此外"])
("morning" ["早晨"])
("morrow" ["明日"])
("mortal" ["會死的"])
("mortality" ["死亡率"])
("mortgage" ["抵押"])
("mosquito" ["蚊子"])
("moss" ["苔蘚"])
("mossy" ["生苔的"])
("most" ["最多的"])
("mostly" ["大部份"])
("moth" ["蟲"])
("mother" ["母親"])
("motion" ["運行"])
("motionless" ["不動的"])
("motive" ["動機"])
("motor" ["馬達"])
("motorcar" ["汽車"])
("motorist" ["常坐汽車者"])
("motto" ["座右銘"])
("mound" ["土堆"])
("mount" ["騎"])
("mountain" ["山"])
("mountaineer" ["登山家"])
("mountainous" ["多山的"])
("mourn" ["哀悼"])
("mournful" ["悲慟的"])
("mouse" ["老鼠"])
("mouth" ["嘴巴,口"])
("mouthful" ["一口"])
("movable" ["可動的"])
("move" ["移動"])
("movement" ["進行"])
("movie" ["電影"])
("mow" ["割草"])
("much" ["非常多"])
("mud" ["泥"])
("muddy" ["骯髒的"])
("muffin" ["鬆餅"])
("mug" ["茶杯"])
("mulberry" ["桑"])
("mule" ["騾"])
("multiplication" ["乘法"])
("multiply" ["乘"])
("multitude" ["多數"])
("mummy" ["木乃伊"])
("municipal" ["市政的"])
("murder" ["謀殺"])
("murderer" ["凶手"])
("murmur" ["私語"])
("muscle" ["肌肉"])
("muscular" ["肌肉發達的"])
("muse" ["瞑想"])
("museum" ["博物館"])
("mushroom" ["蘑菰"])
("music" ["音樂"])
("musical" ["音樂的"])
("musician" ["音樂家"])
("must" ["一定要"])
("mustache" ["鬚"])
("mustard" ["芥末"])
("mute" ["啞的"])
("mutiny" ["叛亂"])
("mutter" ["低語"])
("mutton" ["羊肉"])
("mutual" ["相互的"])
("muzzle" ["鼻口部分"])
("my" ["我的"])
("myself" ["我自己"])
("mysterious" ["神祕的"])
("mystery" ["神祕"])
("myth" ["神話"])
("mythology" ["神話"])
("nail" ["指甲"])
("naked" ["裸的"])
("name" ["名字" "姓"])
("nameless" ["無名的"])
("namely" ["即"])
("napkin" ["餐巾"])
("narcotic" ["麻醉劑"])
("narration" ["敘述"])
("narrative" ["故事"])
("narrow" ["窄"])
("nasty" ["污穢的"])
("nation" ["民族"])
("national" ["全國性"])
("nationality" ["國籍"])
("native" ["土著的"])
("natural" ["自然的"])
("naturally" ["當然地"])
("nature" ["自然"])
("naught" ["無" "零"])
("naughty" ["頑皮的"])
("naval" ["海軍的"])
("navigation" ["航行"])
("navigator" ["航海者"])
("navy" ["海軍"])
("nay" ["不"])
("near" ["近"])
("nearby" ["在附近"])
("nearly" ["幾乎"])
("neat" ["乾淨的"])
("neatly" ["整潔地"])
("nebula" ["星雲"])
("necessarily" ["必然"])
("necessary" ["必要的"])
("necessitate" ["需要"])
("necessity" ["必需"])
("neck" ["頸部"])
("necklace" ["項鍊"])
("need" ["需要"])
("needle" ["縫針"])
("needless" ["不必要的"])
("needy" ["貧窮的"])
("negative" ["否定的"])
("neglect" ["疏忽"])
("negligence" ["疏忽"])
("negligent" ["大意的"])
("negotiate" ["談判"])
("negotiation" ["談判"])
("neighbor" ["鄰居"])
("neighborhood" ["街坊"])
("neighboring" ["附近的"])
("neither" ["也不"])
("nephew" ["外甥"])
("nerve" ["神經" "膽量"])
("nervous" ["緊張"])
("nervously" ["緊張地"])
("nest" ["窩巢"])
("nestle" ["依偎"])
("net" ["網" "淨值"])
("nettle" ["蕁麻"])
("network" ["廣播網"])
("neutral" ["中性的"])
("never" ["從來不"])
("nevertheless" ["然而"])
("new" ["新的"])
("newcomer" ["新來的人"])
("newly" ["新近"])
("news" ["新聞"])
("newspaper" ["報紙"])
("next" ["下一次"])
("nibble" ["輕咬"])
("nice" ["美好的"])
("nicely" ["好好地"])
("nick" ["缺口"])
("nickel" ["五分美金"])
("nickname" ["外號"])
("niece" ["姪女" "甥女"])
("nigh" ["近"])
("night" ["夜晚"])
("nightfall" ["黃昏"])
("nightingale" ["夜鶯"])
("nightly" ["每夜"])
("nightmare" ["惡夢"])
("nimble" ["敏捷的"])
("nine" ["九"])
("nineteen" ["十九"])
("nineteenth" ["第十九"])
("ninetieth" ["第九十"])
("ninety" ["九十"])
("ninth" ["第九"])
("nip" ["咬" "夾"])
("nitrogen" ["氮氣"])
("no" ["不是"])
("nobility" ["貴族"])
("noble" ["高貴的"])
("nobleman" ["貴族"])
("nobly" ["高尚地"])
("nobody" ["沒有人"])
("nod" ["點頭"])
("noise" ["吵鬧聲"])
("noiseless" ["無聲的"])
("noiselessly" ["無聲地"])
("noisy" ["吵鬧的"])
("nominate" ["提名"])
("nomination" ["提名"])
("nominative" ["主格"])
("none" ["沒有"])
("nonsense" ["無聊"])
("nook" ["角落"])
("noon" ["正午"])
("noonday" ["正午的"])
("nor" ["也不"])
("normal" ["正常的"])
("north" ["北方"])
("northeast" ["東北方"])
("northeastern" ["東北方的"])
("northern" ["北方的"])
("northward" ["向北地"])
("northwest" ["西北方"])
("northwestern" ["西北方的"])
("nose" ["鼻子"])
("nostril" ["鼻孔"])
("not" ["不" "不是"])
("notable" ["著名的"])
("notably" ["著名地"])
("notch" ["刻痕"])
("note" ["筆記"])
("notebook" ["筆記本"])
("noted" ["著名的"])
("nothing" ["沒甚麼"])
("notice" ["通知" "注意"])
("noticeable" ["值得注意的"])
("notify" ["通知"])
("notion" ["觀念"])
("notorious" ["惡名昭彰"])
("notwithstanding" ["雖然"])
("nought" ["無"])
("noun" ["名詞"])
("nourish" ["滋養"])
("nourishment" ["營養品"])
("novel" ["小說"])
("novelist" ["小說家"])
("novelty" ["新奇的事物"])
("november" ["十一月"])
("now" ["現在"])
("nowadays" ["如今"])
("nowhere" ["無處"])
("nuclear" ["核子的"])
("nucleus" ["核子"])
("nuisance" ["討厭的東西"])
("numb" ["麻木的"])
("number" ["數字"])
("numeral" ["數字"])
("numerous" ["無數的"])
("nun" ["修女" "尼姑"])
("nuptial" ["婚禮"])
("nurse" ["護士"])
("nursery" ["托兒所"])
("nut" ["堅果"])
("nutrition" ["營養"])
("nylon" ["尼龍"])
("nymph" ["女神"])
("oak" ["橡樹"])
("oaken" ["橡木的"])
("oar" ["槳"])
("oasis" ["綠洲"])
("oat" ["燕麥"])
("oath" ["誓約"])
("oatmeal" ["燕麥粥"])
("obedience" ["服從"])
("obedient" ["順從的"])
("obey" ["服從"])
("object" ["物件"])
("objection" ["反對"])
("objective" ["目標" "受格"])
("obligation" ["義務"])
("oblige" ["責成"])
("oblivion" ["埋沒"])
("obscure" ["無名的"])
("obscurity" ["隱晦" "含糊"])
("observance" ["奉行"])
("observation" ["觀察"])
("observatory" ["天文台"])
("observe" ["觀察"])
("observer" ["觀察者"])
("obstacle" ["障礙"])
("obstinacy" ["頑固"])
("obstinate" ["頑固的"])
("obstruct" ["阻隔"])
("obstruction" ["障礙"])
("obtain" ["獲得"])
("obvious" ["顯然的"])
("obviously" ["顯然地"])
("occasion" ["場合" "時機"])
("occasional" ["偶然的"])
("occasionally" ["偶然地"])
("occupant" ["佔領者"])
("occupation" ["職業"])
("occupy" ["佔領"])
("occur" ["發生"])
("occurrence" ["發生"])
("ocean" ["海洋"])
("october" ["十月"])
("odd" ["奇數" "零頭"])
("oddly" ["古怪地"])
("odds" ["可能性"])
("ode" ["頌詞"])
("odor" ["氣味"])
("of" ["屬於"])
("off" ["關閉" "離開"])
("offend" ["觸犯"])
("offender" ["冒犯者"])
("offense" ["侵犯"])
("offensive" ["有攻擊性的"])
("offer" ["提供"])
("offering" ["奉現"])
("office" ["辦公室"])
("officer" ["官員"])
("official" ["公務的"])
("officially" ["官方的"])
("offset" ["透印版印刷"])
("offspring" ["子孫"])
("often" ["常常"])
("oh" ["啊呀"])
("oil" ["油"])
("oily" ["油油的"])
("ointment" ["藥膏"])
("old" ["老的"])
("oldfashioned" ["過時的"])
("oldtime" ["古來的"])
("olive" ["橄欖樹"])
("omen" ["預兆"])
("ominous" ["不吉利的"])
("omission" ["省略"])
("omit" ["略去"])
("omnibus" ["公共汽車"])
("on" ["在..之上"])
("once" ["一次"])
("one" ["一"])
("oneself" ["自己"])
("onion" ["洋蔥"])
("only" ["只有"])
("onto" ["到﹍之上"])
("onward" ["前進"])
("ooze" ["爛泥"])
("opal" ["蛋白石"])
("open" ["開"])
("opening" ["揭幕"])
("openly" ["公開地"])
("opera" ["歌劇"])
("operate" ["操作"])
("operation" ["動作" "手術"])
("operator" ["操作者"])
("opinion" ["意見"])
("opium" ["鴉片"])
("opponent" ["對抗者"])
("opportunity" ["機會"])
("oppose" ["反對"])
("opposite" ["相反的"])
("opposition" ["反對"])
("oppress" ["壓迫"])
("oppression" ["壓迫"])
("optimism" ["樂觀"])
("or" ["或者"])
("oracle" ["神諭"])
("oral" ["口頭的"])
("orange" ["橘子"])
("oration" ["演說"])
("orator" ["演說者"])
("orbit" ["軌道"])
("orchestra" ["管弦樂團"])
("ordain" ["命運註定"])
("ordeal" ["考驗"])
("order" ["順序"])
("orderly" ["整齊"])
("ordinal" ["順序數"])
("ordinance" ["法令"])
("ordinarily" ["通常"])
("ordinary" ["普通的"])
("ore" ["礦石"])
("organ" ["風琴"])
("organic" ["器官的"])
("organism" ["有機體"])
("organization" ["組織"])
("organize" ["組織"])
("orient" ["東方"])
("oriental" ["東方的"])
("origin" ["起源"])
("original" ["最初的"])
("originality" ["創作力"])
("originally" ["本來"])
("originate" ["起始"])
("ornament" ["裝飾物"])
("ornamental" ["裝飾的"])
("orphan" ["孤兒"])
("orthodox" ["正統的"])
("ostrich" ["鴕鳥"])
("other" ["別的"])
("otherwise" ["不然的話"])
("ought" ["應當是"])
("ounce" ["盎司"])
("our" ["我們的"])
("ourself" ["我門本人"])
("ourselves" ["我們自己"])
("out" ["外"])
("outbreak" ["爆發"])
("outburst" ["突發"])
("outcome" ["結果"])
("outcry" ["叫喊"])
("outdoor" ["戶外的"])
("outdoors" ["在戶外"])
("outer" ["在外的"])
("outfit" ["旅行裝備"])
("outlaw" ["無法無天的"])
("outlet" ["出口"])
("outline" ["輪廓" "草稿"])
("outlook" ["展望"])
("output" ["出產"])
("outrage" ["使憤慨"])
("outrageous" ["憤怒的"])
("outside" ["外部"])
("outskirt" ["郊外"])
("outstanding" ["顯目的"])
("outward" ["外部的"])
("oval" ["橢圓形"])
("ovary" ["子房"])
("oven" ["窯"])
("over" ["在之上"])
("overcoat" ["大衣"])
("overcome" ["克服"])
("overflow" ["溢出"])
("overhang" ["懸垂"])
("overhead" ["高架的"])
("overhear" ["無意中聽到"])
("overland" ["經陸路的"])
("overlook" ["俯視"])
("overnight" ["通宵"])
("overpower" ["打敗"])
("overseas" ["海外的"])
("oversleep" ["睡過頭"])
("overtake" ["追上"])
("overthrow" ["打翻"])
("overturn" ["推翻"])
("overwhelm" ["壓倒"])
("overwhelming" ["壓倒性的"])
("overwork" ["工作過度"])
("owe" ["借債"])
("owing" ["基於"])
("owl" ["貓頭鷹"])
("own" ["擁有"])
("owner" ["物主"])
("ownership" ["所有權"])
("ox" ["牛"])
("oxygen" ["氧氣"])
("oyster" ["牡蠣" "蚵"])
("pace" ["步伐"])
("pacific" ["和平的"])
("pack" ["包"])
("package" ["包裝"])
("packet" ["小包"])
("pad" ["襯墊"])
("paddle" ["槳"])
("page" ["頁"])
("pageant" ["盛會"])
("pail" ["桶"])
("pain" ["痛"])
("painful" ["痛的"])
("painfully" ["痛苦地"])
("paint" ["顏料"])
("painter" ["畫家"])
("painting" ["油畫"])
("pair" ["一對"])
("pajamas" ["睡衣"])
("pal" ["夥伴"])
("palace" ["宮殿"])
("pale" ["蒼白"])
("palm" ["手掌" "棕閭"])
("pamphlet" ["小冊子"])
("pan" ["平鍋"])
("pancake" ["薄烤餅"])
("pane" ["窗玻璃"])
("panel" ["鐵板"])
("panic" ["驚慌"])
("pansy" ["三色紫羅蘭"])
("pant" ["喘氣"])
("panther" ["美洲豹"])
("pants" ["褲"])
("papa" ["爸爸"])
("paper" ["紙"])
("par" ["同位"])
("parachute" ["降落傘"])
("parade" ["遊行"])
("paradise" ["樂園"])
("paragraph" ["段落"])
("parallel" ["平行的"])
("paralyze" ["使麻痺"])
("paramount" ["至高的"])
("paraphrase" ["解釋"])
("parasite" ["寄生物"])
("parasol" ["陽傘"])
("parcel" ["包裹"])
("parch" ["烘乾"])
("parchment" ["羊皮紙"])
("pardon" ["原諒"])
("pare" ["剝掉"])
("parent" ["父母親"])
("parenthesis" ["括號"])
("parish" ["教區"])
("park" ["公園"])
("parliament" ["國會"])
("parliamentary" ["國會的"])
("parrot" ["鸚鵡"])
("parsley" ["香菜"])
("parson" ["牧師"])
("part" ["部分"])
("partake" ["分享"])
("partial" ["部分的"])
("partially" ["部分地"])
("participate" ["參加"])
("participation" ["參與"])
("participle" ["分詞"])
("particular" ["單獨的"])
("particularly" ["單獨地"])
("parting" ["分離"])
("partisan" ["伙伴"])
("partition" ["瓜分"])
("partly" ["部分地"])
("partner" ["合夥人"])
("partridge" ["鷓鴣"])
("party" ["集會" "政黨" "舞會"])
("pass" ["通過"])
("passage" ["通道"])
("passenger" ["乘客"])
("passion" ["熱情"])
("passionate" ["熱情的"])
("passionately" ["熱情地"])
("passive" ["消極的"])
("passport" ["護照"])
("past" ["過去的"])
("paste" ["糊" "膏"])
("pastime" ["消遣"])
("pastor" ["牧師" "牧人"])
("pastoral" ["牧人的"])
("patron" ["支持者"])
("patronage" ["支持"])
("patter" ["急促聲"])
("pattern" ["圖案" "模形"])
("pause" ["停頓"])
("pave" ["鋪設"])
("pavement" ["路面"])
("paw" ["爪子"])
("pay" ["付款"])
("payment" ["付款"])
("pea" ["豆子"])
("peace" ["和平"])
("peaceable" ["和平的"])
("peaceful" ["安寧的"])
("peach" ["桃子"])
("peacock" ["孔雀"])
("peak" ["山峰"])
("peal" ["響聲"])
("peanut" ["花生"])
("pear" ["梨子"])
("pearl" ["珍珠"])
("peasant" ["農夫"])
("pebble" ["鵝卵石"])
("peculiar" ["奇特的"])
("peculiarity" ["怪僻"])
("peculiarly" ["奇特地"])
("peddler" ["小販"])
("pedestal" ["台座"])
("pedestrian" ["行人"])
("peel" ["果皮"])
("peep" ["偷看"])
("peer" ["同輩" "細看"])
("peg" ["木釘" "衣夾"])
("pelt" ["毛皮"])
("pen" ["筆" "欄圈"])
("penalty" ["懲罰"])
("pencil" ["鉛筆"])
("pending" ["未決定的"])
("pendulum" ["鐘擺"])
("penetrate" ["穿透"])
("peninsula" ["半島"])
("penny" ["一分錢"])
("pension" ["養老金"])
("pensive" ["哀思的"])
("people" ["人民" "民眾"])
("pepper" ["胡椒"])
("perceive" ["感覺"])
("percent" ["百分之﹍"])
("percentage" ["百分比"])
("perceptible" ["明顯的"])
("perception" ["知覺"])
("perch" ["棲息"])
("perchance" ["或許"])
("perfect" ["完美的"])
("perfection" ["完美"])
("perfectly" ["完美地"])
("perform" ["表演" "執行"])
("performance" ["演出" "成績"])
("perfume" ["香水"])
("perhaps" ["可能"])
("peril" ["危險"])
("perilous" ["危險的"])
("period" ["時期" "句號"])
("periodical" ["期刊"])
("perish" ["毀滅"])
("permanent" ["永久的"])
("permanently" ["永久地"])
("permission" ["許可"])
("permit" ["允許"])
("perpendicular" ["垂直的"])
("perpetual" ["永久的"])
("perplex" ["迷惑"])
("perplexity" ["困惑"])
("persecute" ["迫害"])
("persecution" ["迫害"])
("perseverance" ["毅力"])
("persevere" ["堅持"])
("persimmon" ["柿子"])
("persist" ["堅持"])
("persistent" ["固執的"])
("person" ["人"])
("personage" ["名人" "容貌"])
("personal" ["私人的"])
("personality" ["個性"])
("personally" ["親自地"])
("personnel" ["人事部門"])
("perspective" ["透視"])
("persuade" ["勸說"])
("persuasion" ["勸說"])
("pertain" ["屬於"])
("pervade" ["遍布"])
("pessimism" ["悲觀"])
("pest" ["毒物"])
("pestilence" ["傳染病"])
("pet" ["寵物"])
("petal" ["花瓣"])
("petition" ["請願書"])
("petroleum" ["石油"])
("petticoat" ["襯裙"])
("petty" ["細小的"])
("pew" ["座位"])
("phantom" ["幻影"])
("phase" ["時期"])
("pheasant" ["雉雞"])
("phenomenon" ["現象"])
("philosopher" ["哲學家"])
("philosophic" ["哲學上的"])
("philosophy" ["哲學"])
("phone" ["電話"])
("phonograph" ["電唱機"])
("phosphoric" ["含燐的"])
("photo" ["照片"])
("photograph" ["照片"])
("phrase" ["片語"])
("physical" ["物理的"])
("physically" ["物理地"])
("physician" ["醫生"])
("physics" ["物理學"])
("pianist" ["鋼琴家"])
("piano" ["鋼琴"])
("piazza" ["走廊"])
("pick" ["挑選"])
("pickle" ["醃黃瓜"])
("picnic" ["野餐"])
("picture" ["圖畫"])
("picturesque" ["如畫的"])
("pie" ["餡餅"])
("piece" ["一片" "一塊"])
("pier" ["碼頭"])
("pierce" ["穿洞"])
("piety" ["孝順"])
("pig" ["豬"])
("pigeon" ["鴿子"])
("pike" ["長槍" "稅關"])
("pile" ["一堆"])
("pilgrim" ["朝聖者"])
("pilgrimage" ["朝聖者"])
("pill" ["藥丸"])
("pillar" ["柱子"])
("pillow" ["枕頭"])
("pilot" ["駕駛員"])
("pin" ["別針"])
("pinch" ["捏"])
("pine" ["松樹"])
("pineapple" ["鳳梨"])
("pingpong" ["乒乓球"])
("pinion" ["鳥羽"])
("pink" ["粉紅色"])
("pint" ["品脫"])
("pioneer" ["開拓者"])
("pious" ["虔誠的"])
("pipe" ["管"])
("piper" ["吹笛者"])
("pirate" ["海盜"])
("pistil" ["雌蕊"])
("pistol" ["手槍"])
("piston" ["活塞"])
("pit" ["凹洞"])
("pitch" ["投"])
("pitcher" ["投手"])
("pitiful" ["可憐的"])
("pitiless" ["無情的"])
("pity" ["憐憫"])
("placard" ["標語牌"])
("place" ["場所,地方"])
("placid" ["平靜的"])
("plague" ["疫病"])
("plaid" ["格子花呢"])
("plain" ["普通的"])
("plan" ["計畫"])
("plane" ["水平面"])
("planet" ["行星"])
("plank" ["板"])
("plant" ["植物"])
("plantation" ["農園"])
("planter" ["種植的人"])
("plaster" ["石膏"])
("plastic" ["塑膠"])
("plate" ["金屬板"])
("plateau" ["高原"])
("platform" ["臺"])
("platinum" ["白金,鉑"])
("platter" ["大盤子"])
("play" ["遊戲"])
("player" ["競賽者"])
("playful" ["愛遊玩的"])
("playground" ["運動場"])
("playmate" ["遊伴"])
("plaything" ["玩具"])
("plea" ["請願"])
("plead" ["辯護"])
("pleasant" ["愉快的"])
("pleasantly" ["愉快地"])
("please" ["使高興"])
("pleased" ["高興的"])
("pleasing" ["愉快的"])
("pleasure" ["歡樂"])
("pledge" ["誓約"])
("plentiful" ["許多的"])
("plenty" ["很多"])
("plot" ["策略"])
("plow" ["犁"])
("pluck" ["摘"])
("plug" ["栓"])
("plum" ["李子"])
("plumage" ["羽毛"])
("plume" ["羽毛"])
("plunder" ["掠奪"])
("plunge" ["跳進"])
("plural" ["複數"])
("plus" ["加"])
("ply" ["屢加"])
("pneumonia" ["肺炎"])
("pocket" ["口袋"])
("poem" ["詩"])
("poet" ["詩人"])
("poetic" ["詩意"])
("poetry" ["詩"])
("point" ["點"])
("pointed" ["尖"])
("poison" ["毒"])
("poisonous" ["有毒"])
("poke" ["撥開"])
("pole" ["棒" "竿"])
("police" ["警察"])
("policeman" ["警察"])
("policy" ["政策"])
("polish" ["磨光"])
("polite" ["有禮貌的"])
("politely" ["殷勤地"])
("politeness" ["有禮貌"])
("political" ["政治的"])
("politician" ["政治家"])
("politics" ["政治學"])
("poll" ["民意測驗"])
("pollen" ["花粉"])
("pond" ["池塘"])
("ponder" ["沉思"])
("ponderous" ["笨重的"])
("pony" ["小馬"])
("pool" ["池"])
("poor" ["貧窮" "差勁"])
("pop" ["爆聲"])
("pope" ["教皇"])
("poplar" ["白楊"])
("poppy" ["罌粟"])
("populace" ["民眾"])
("popular" ["受歡迎的"])
("popularity" ["流行"])
("population" ["人口"])
("populous" ["人口稠密的"])
("porcelain" ["瓷器"])
("porch" ["陽台"])
("porcupine" ["豪豬"])
("pore" ["毛"])
("pork" ["豬肉"])
("port" ["港口"])
("portable" ["手提的"])
("portal" ["正門"])
("porter" ["雜工"])
("portion" ["一部分"])
("portrait" ["半身像"])
("pose" ["姿勢"])
("position" ["位置"])
("positive" ["確定的"])
("positively" ["確定地"])
("possess" ["擁有"])
("possession" ["所有權"])
("possessive" ["所有的"])
("possibility" ["可能性"])
("possible" ["可能的"])
("possibly" ["可能地"])
("post" ["公告" "郵件"])
("postage" ["郵費"])
("postal" ["郵政的"])
("postcard" ["明信片"])
("poster" ["海報"])
("posterity" ["後代"])
("postman" ["郵差"])
("postoffice" ["郵局"])
("postpone" ["延期"])
("postscript" ["附筆"])
("posture" ["姿勢"])
("pot" ["壺" "罐"])
("potato" ["馬鈴薯"])
("potent" ["強有力的"])
("potential" ["可能性"])
("potter" ["製陶工人"])
("pottery" ["陶器"])
("pouch" ["小袋"])
("poultry" ["家禽"])
("pound" ["磅" "敲擊"])
("pour" ["傾倒"])
("poverty" ["貧困"])
("powder" ["細粉"])
("power" ["力量" "權力"])
("powerful" ["強有力的"])
("powerless" ["無力的"])
("practicable" ["可行的"])
("practical" ["實際的"])
("practicality" ["實際性"])
("practically" ["實際地"])
("practice" ["練習"])
("prairie" ["大草原"])
("praise" ["讚美"])
("pray" ["祈禱"])
("prayer" ["禱告"])
("preach" ["傳教"])
("preacher" ["傳道者"])
("precarious" ["危險的"])
("precaution" ["預防"])
("precede" ["提前"])
("precedent" ["先例"])
("preceding" ["先前的"])
("precept" ["箴言"])
("precinct" ["區域"])
("precious" ["貴重的"])
("precipice" ["懸崖"])
("precipitate" ["沈澱" "促使"])
("precise" ["精確的"])
("precisely" ["精確地"])
("precision" ["精確"])
("predecessor" ["前任" "前輩"])
("predicate" ["述語"])
("predict" ["預言"])
("prediction" ["預言"])
("preface" ["序" "緒言"])
("prefecture" ["地方官職位"])
("prefer" ["比較喜歡"])
("preference" ["偏愛" "優惠"])
("prefix" ["字首"])
("prejudice" ["偏見"])
("preliminary" ["初步的"])
("premier" ["總理" "首相"])
("premise" ["前提"])
("premium" ["獎金"])
("preparation" ["預備"])
("preparatory" ["預備的"])
("prepare" ["準備"])
("preposition" ["介系詞"])
("prerogative" ["特權"])
("prescribe" ["規定"])
("prescription" ["藥方" "規定"])
("presence" ["出席"])
("present" ["呈送" "現在"])
("presentation" ["禮物" "演出"])
("presently" ["不久地"])
("preservation" ["保護"])
("preserve" ["保護"])
("preside" ["主持"])
("presidency" ["總統任期"])
("president" ["總統" "校長"])
("presidential" ["總統的"])
("press" ["壓" "新聞界"])
("pressure" ["壓力"])
("prestige" ["威望"])
("presumably" ["假定地"])
("presume" ["假定"])
("pretend" ["假裝"])
("pretense" ["虛偽"])
("pretty" ["漂亮"])
("prevail" ["流行" "戰勝"])
("prevailing" ["流行的"])
("prevalent" ["流行的"])
("prevent" ["阻止"])
("prevention" ["防止"])
("previous" ["先前的"])
("previously" ["先前地"])
("prey" ["獵物"])
("price" ["價錢"])
("priceless" ["無價的"])
("pride" ["自尊"])
("priest" ["牧師"])
("primarily" ["主要地"])
("primary" ["初級的"])
("prime" ["主要的"])
("primitive" ["基本的"])
("primrose" ["櫻花草"])
("prince" ["太子"])
("princely" ["王家的"])
("princess" ["公主"])
("principal" ["主要的"])
("principle" ["原則"])
("print" ["印刷"])
("printer" ["印刷者"])
("prior" ["預先的"])
("prism" ["三稜鏡"])
("prison" ["監獄"])
("prisoner" ["犯人"])
("privacy" ["隱私"])
("private" ["私人的"])
("privately" ["私人地"])
("privilege" ["特權"])
("privileged" ["特權"])
("prize" ["獎品"])
("probability" ["可能性"])
("probable" ["可能" "大概"])
("probably" ["大概地"])
("problem" ["問題"])
("procedure" ["程序"])
("proceed" ["進行"])
("proceeding" ["行動"])
("process" ["過程"])
("procession" ["行列"])
("proclaim" ["聲明"])
("proclamation" ["宣言"])
("procure" ["促成"])
("prodigal" ["浪費"])
("prodigious" ["大量的"])
("produce" ["生產"])
("producer" ["製作者"])
("product" ["產品"])
("production" ["生產"])
("productive" ["生產的"])
("profane" ["世俗的"])
("profess" ["聲明"])
("profession" ["職業"])
("professional" ["專業的"])
("professor" ["教授"])
("proffer" ["提供"])
("proficient" ["專家" "精通的"])
("profile" ["外貌"])
("profit" ["利益"])
("profitable" ["有利可圖的"])
("profiteer" ["獲暴利者"])
("profound" ["深奧的"])
("profoundly" ["深奧地"])
("program" ["節目"])
("programme" ["節目"])
("progress" ["進步"])
("progressive" ["進步的"])
("prohibit" ["禁止"])
("prohibition" ["禁止"])
("project" ["方案"])
("projection" ["投射"])
("prologue" ["序幕"])
("prolong" ["延長"])
("promenade" ["遊行"])
("prominent" ["著名的"])
("promise" ["約定"])
("promising" ["有希望的"])
("promote" ["升遷"])
("promotion" ["升遷"])
("prompt" ["立刻的"])
("promptly" ["立刻地"])
("prone" ["傾向於"])
("pronoun" ["代名詞"])
("pronounce" ["發音" "聲明"])
("pronounced" ["明言的"])
("pronunciation" ["發音"])
("proof" ["証據"])
("propaganda" ["宣傳"])
("propagate" ["廣傳"])
("propeller" ["螺旋槳"])
("proper" ["適當的"])
("properly" ["適當地"])
("property" ["財產"])
("prophecy" ["預言"])
("prophesy" ["預言"])
("prophet" ["預言家"])
("prophetic" ["預言的"])
("proportion" ["比率"])
("proposal" ["提案" "求婚"])
("propose" ["提議"])
("proposition" ["主張"])
("proprietor" ["所有者"])
("prose" ["散文"])
("prosecute" ["起訴"])
("prospect" ["遠景"])
("prospective" ["有希望的"])
("prosper" ["繁榮"])
("prosperity" ["繁榮"])
("prosperous" ["繁榮的"])
("protect" ["保護"])
("protection" ["保護"])
("protective" ["保護的"])
("protector" ["保護者"])
("protein" ["蛋白質"])
("protest" ["抗議"])
("protestant" ["新教"])
("protoplasm" ["原形質"])
("proud" ["驕傲"])
("proudly" ["誇耀地"])
("prove" ["証明"])
("proverb" ["諺語"])
("provide" ["供給"])
("provided" ["倘若"])
("province" ["省"])
("provincial" ["省的"])
("provision" ["供應"])
("provocation" ["觸怒"])
("provoke" ["使憤怒"])
("prudence" ["謹慎"])
("prudent" ["謹慎的"])
("prune" ["修剪"])
("pry" ["刺探"])
("psalm" ["詩篇"])
("psychology" ["心理學"])
("public" ["公用的"])
("publication" ["出版"])
("publicity" ["公開"])
("publicly" ["公然地"])
("publish" ["發表"])
("publisher" ["出版者"])
("pudding" ["布丁"])
("puff" ["一吹"])
("pull" ["拉"])
("pulp" ["果肉"])
("pulse" ["脈搏"])
("pump" ["唧筒"])
("pumpkin" ["南瓜"])
("punch" ["打孔器"])
("punctual" ["守時"])
("punctuation" ["標點"])
("punish" ["處罰"])
("punishment" ["處罰"])
("pup" ["小狗"])
("pupil" ["學生"])
("puppet" ["木偶"])
("puppy" ["小狗"])
("purchase" ["購買"])
("purchaser" ["購買者"])
("pure" ["純的"])
("purely" ["純粹地"])
("purge" ["肅清"])
("purify" ["淨化"])
("purity" ["清潔"])
("purple" ["紫色的"])
("purpose" ["目的"])
("purse" ["錢袋"])
("pursue" ["追求"])
("pursuit" ["從事"])
("push" ["推"])
("pussy" ["貓"])
("put" ["放置"])
("puzzle" ["難題"])
("pyramid" ["金字塔"])
("quack" ["嘎嘎"])
("quail" ["鵪鶉"])
("quaint" ["離奇有趣的"])
("qualification" ["資格"])
("qualify" ["給與資格"])
("quality" ["品質"])
("quantity" ["份量"])
("quarrel" ["吵架"])
("quarrelsome" ["喜歡吵架的"])
("quarry" ["鑿石場"])
("quarter" ["四分之一"])
("quartz" ["石英"])
("queen" ["女王" "王后"])
("queer" ["古怪的"])
("quench" ["解渴"])
("query" ["疑問"])
("quest" ["探索"])
("question" ["問題"])
("quick" ["快"])
("quicken" ["加快"])
("quickly" ["很快地"])
("quicksilver" ["水銀"])
("quiet" ["寂靜的"])
("quietly" ["安靜地"])
("quill" ["羽莖"])
("quilt" ["棉被"])
("quit" ["放棄"])
("quite" ["相當"])
("quiver" ["顫抖"])
("quotation" ["引用句"])
("quote" ["引証"])
("rabbit" ["兔子"])
("race" ["競賽"])
("racial" ["種族的"])
("rack" ["網架"])
("racket" ["球拍"])
("radar" ["雷達"])
("radiance" ["光輝"])
("radiant" ["輻射的"])
("radiate" ["輻射"])
("radiator" ["暖氣機"])
("radical" ["根本的"])
("radio" ["收音機"])
("radium" ["鐳"])
("radius" ["半徑"])
("raft" ["筏"])
("rag" ["破布"])
("rage" ["憤怒"])
("ragged" ["破爛的"])
("raid" ["襲擊"])
("rail" ["欄杆"])
("railing" ["扶手"])
("railroad" ["鐵路"])
("railway" ["軌道"])
("rain" ["雨"])
("rainbow" ["虹"])
("raindrop" ["雨滴"])
("rainfall" ["雨量"])
("rainy" ["下雨的"])
("raise" ["升起"])
("rally" ["示威運動"])
("ram" ["公羊"])
("ramble" ["漫步"])
("ranch" ["大農場"])
("random" ["任意"])
("range" ["範圍"])
("rank" ["評價分類"])
("ransom" ["贖金"])
("rap" ["敲擊"])
("rapid" ["迅速的"])
("rapidity" ["迅速"])
("rapidly" ["迅速地"])
("rapt" ["狂喜的"])
("rapture" ["全神灌注"])
("rare" ["稀少的"])
("rarely" ["稀少地"])
("rascal" ["小淘氣"])
("rash" ["疹子"])
("rat" ["老鼠"])
("rate" ["比率" "等級"])
("rather" ["寧願"])
("ratify" ["批准"])
("ratio" ["比率"])
("rational" ["合理的"])
("rattle" ["發嘎嘎聲"])
("ravage" ["破壞"])
("rave" ["怒吼"])
("raven" ["烏鴉" "掠奪"])
("ravine" ["峽谷"])
("raw" ["生的"])
("ray" ["光線"])
("razor" ["剃刀"])
("reach" ["達到"])
("react" ["反應"])
("reaction" ["反應"])
("reactionary" ["反動分子"])
("read" ["閱讀"])
("reader" ["讀者"])
("readily" ["容易地"])
("readiness" ["方便"])
("ready" ["準備好的"])
("real" ["真實的"])
("reality" ["現實"])
("realization" ["體認"])
("realize" ["體認"])
("really" ["真正地"])
("realm" ["王國"])
("reap" ["收割"])
("reaper" ["收割者"])
("reappear" ["再出現"])
("rear" ["後面" "養育"])
("reason" ["理由"])
("reasonable" ["合理的"])
("reasonably" ["合理地"])
("reasoning" ["推理"])
("reassure" ["再保証"])
("rebel" ["反抗者"])
("rebellion" ["造反"])
("rebellious" ["反叛的"])
("rebuff" ["回絕"])
("rebuild" ["重建"])
("rebuke" ["指責"])
("recall" ["召回" "記起"])
("recede" ["降低"])
("receipt" ["收據"])
("receive" ["收到"])
("receiver" ["接受者"])
("recent" ["最近的"])
("recently" ["最近地"])
("receptacle" ["容器" "花托"])
("reception" ["招待"])
("recess" ["休惜"])
("reciever" ["接收器"])
("recipe" ["食譜"])
("reciprocal" ["互惠"])
("recite" ["背誦"])
("reckless" ["不顧一切"])
("reckon" ["計算"])
("reclaim" ["改造"])
("recline" ["橫臥"])
("recognition" ["認出"])
("recognize" ["認出"])
("recoil" ["後退"])
("recollect" ["回憶"])
("recollection" ["回憶"])
("recommend" ["推荐"])
("recompense" ["酬謝"])
("reconcile" ["調停"])
("reconstruct" ["重建"])
("reconstruction" ["重建"])
("record" ["記錄" "唱片"])
("recount" ["詳述"])
("recovery" ["重獲" "復元"])
("recreation" ["娛樂中心"])
("recruit" ["招募"])
("rectangle" ["長方形"])
("rector" ["牧師"])
("recur" ["重現"])
("red" ["紅色"])
("redbreast" ["知更鳥"])
("redden" ["變紅"])
("reddish" ["帶紅色的"])
("redeem" ["贖回"])
("reduction" ["減少"])
("reed" ["蘆葦"])
("reef" ["暗礁"])
("reel" ["捲軸"])
("refer" ["指示"])
("reference" ["參考書"])
("refine" ["提煉"])
("refined" ["精製的"])
("refinement" ["精美"])
("reflect" ["反射"])
("reflection" ["反射"])
("reform" ["改革"])
("reformer" ["改革者"])
("refrain" ["禁止"])
("refresh" ["恢復"])
("refreshment" ["身心爽快"])
("refrigerator" ["冰箱"])
("refuge" ["避難所"])
("refugee" ["難民"])
("refusal" ["拒絕"])
("refuse" ["拒絕"])
("regain" ["恢復" "重回"])
("regal" ["帝王的"])
("regard" ["認為"])
("regardful" ["小心的"])
("regarding" ["關於"])
("regardless" ["不顧"])
("regent" ["攝政"])
("regime" ["政權"])
("regiment" ["一團" "一群"])
("region" ["地區"])
("register" ["註冊"])
("registration" ["註冊"])
("regret" ["後悔"])
("regular" ["通常的"])
("regularity" ["規則"])
("regularly" ["正常地"])
("regulate" ["校正"])
("regulation" ["規則"])
("rein" ["韁繩"])
("reindeer" ["馴鹿"])
("reinforce" ["增援"])
("reiterate" ["反復"])
("reject" ["拒絕"])
("rejoice" ["使﹍高興"])
("rejoicing" ["高興"])
("relate" ["有關連"])
("relation" ["關係"])
("relationship" ["關係"])
("relative" ["親戚" "相關"])
("relatively" ["相對地"])
("relax" ["放鬆"])
("release" ["釋放"])
("relent" ["同情"])
("reliable" ["可靠"])
("relic" ["遺跡"])
("relief" ["解脫"])
("relieve" ["解除"])
("religion" ["宗教"])
("religious" ["宗教的"])
("relinquish" ["放棄"])
("relish" ["美味"])
("reluctance" ["勉強"])
("reluctant" ["勉強的"])
("reluctantly" ["勉強地"])
("rely" ["信任"])
("remain" ["保持" "留下"])
("remainder" ["餘數"])
("remark" ["注意" "評註"])
("remarkable" ["不平常的"])
("remarkably" ["不平常的"])
("remedy" ["治療" "補救"])
("remember" ["記得"])
("remembrance" ["紀念"])
("remind" ["提醒"])
("remit" ["匯寄" "赦免"])
("remnant" ["遺物"])
("remodel" ["改裝"])
("remorse" ["悔恨"])
("remote" ["遙遠的"])
("removal" ["撤除"])
("remove" ["移動"])
("removed" ["遠離的"])
("renaissance" ["復興"])
("rend" ["分裂"])
("render" ["呈送" "造成"])
("renew" ["更新" "續訂"])
("renounce" ["放棄" "否認"])
("renown" ["名望"])
("rent" ["租金" "出租"])
("repair" ["修理"])
("reparation" ["補償"])
("repast" ["餐飲"])
("repeal" ["撤銷"])
("repeat" ["重複"])
("repeated" ["重複的"])
("repeatedly" ["重複地"])
("repel" ["驅除" "拒絕"])
("repent" ["後悔"])
("repentance" ["悔恨"])
("repetition" ["重複"])
("replace" ["更換"])
("replenish" ["補充"])
("reply" ["答覆"])
("report" ["報告"])
("reporter" ["採訪記者"])
("represent" ["表示"])
("representation" ["代表"])
("reproach" ["叱責"])
("reproduce" ["複製"])
("reproduction" ["複製"])
("reproof" ["非難"])
("reprove" ["責備"])
("reptile" ["爬蟲動物"])
("republic" ["共和國"])
("republican" ["共和政體"])
("repulse" ["逐退"])
("reputation" ["聲價"])
("repute" ["名氣"])
("request" ["請求"])
("require" ["需要"])
("requirement" ["必要條件"])
("requisite" ["必要的"])
("rescue" ["救"])
("research" ["研究"])
("resemblance" ["類似點"])
("resemble" ["類似"])
("resent" ["憤慨"])
("resentment" ["憤慨"])
("reservation" ["預約" "保留"])
("reserve" ["預約"])
("reservoir" ["貯水處"])
("reside" ["住"])
("residence" ["住宅"])
("resident" ["居住的"])
("resign" ["辭職"])
("resignation" ["辭職"])
("resist" ["抵抗"])
("resistance" ["抵抗"])
("resolute" ["堅定的"])
("resolutely" ["堅決地"])
("resolution" ["決心"])
("resolve" ["下決心"])
("resolved" ["決議的"])
("resort" ["娛樂場"])
("resource" ["資源"])
("respect" ["尊敬"])
("respectable" ["可尊敬的"])
("respectful" ["表示敬意"])
("respectfully" ["尊敬地"])
("respecting" ["關於"])
("respective" ["個別的"])
("respectively" ["個別地"])
("respond" ["回答"])
("response" ["反應"])
("responsibility" ["責任"])
("responsible" ["應負責任的"])
("rest" ["休息"])
("restaurant" ["餐館"])
("restless" ["不安的"])
("restoration" ["修復"])
("restore" ["恢復原狀"])
("restrain" ["抑制"])
("restraint" ["抑制"])
("restrict" ["限於"])
("restriction" ["限制"])
("result" ["結果"])
("resume" ["重新開始"])
("resurrection" ["復活"])
("retail" ["零售"])
("retain" ["保持"])
("retard" ["減低速度"])
("retire" ["退休"])
("retirement" ["退休"])
("retort" ["反駁"])
("retreat" ["撤退"])
("return" ["歸還"])
("reveal" ["顯示"])
("revelation" ["揭發"])
("revenge" ["報仇"])
("revenue" ["歲入,收益"])
("revere" ["尊敬"])
("reverence" ["尊敬"])
("reverend" ["應尊敬的"])
("reverse" ["相反"])
("revert" ["恢復"])
("review" ["評論"])
("revise" ["修訂"])
("revision" ["校訂"])
("revival" ["復甦"])
("revive" ["復甦"])
("revolt" ["暴動"])
("revolution" ["革命"])
("revolutionary" ["革命的"])
("revolve" ["迴轉"])
("revolver" ["左輪手槍"])
("reward" ["報酬"])
("rhetoric" ["修辭"])
("rheumatism" ["風濕"])
("rhyme" ["押韻"])
("rhythm" ["旋律"])
("rib" ["肋骨"])
("ribbon" ["緞帶"])
("rice" ["米,飯"])
("rich" ["富有的"])
("rid" ["使免除"])
("riddle" ["謎"])
("ride" ["騎" "乘"])
("rider" ["騎士"])
("ridge" ["背"])
("ridicule" ["愚弄"])
("ridiculous" ["荒謬的"])
("rifle" ["來福槍"])
("rig" ["索具裝置"])
("right" ["正確的"])
("righteous" ["正義的"])
("righteousness" ["正義"])
("rightful" ["正直的"])
("righthand" ["右手的"])
("rigid" ["固定的"])
("rim" ["邊"])
("ring" ["戒子"])
("rinse" ["洗滌"])
("riot" ["暴動"])
("rip" ["扯裂"])
("ripe" ["成熟"])
("ripen" ["成熟"])
("ripple" ["漣漪"])
("rise" ["起床" "昇起"])
("rising" ["攀昇的"])
("risk" ["冒險"])
("rival" ["對敵者"])
("rivalry" ["競爭"])
("river" ["河"])
("rivet" ["使固定"])
("road" ["道路"])
("roadside" ["路邊"])
("roadway" ["道路"])
("roam" ["徘徊"])
("roar" ["咆哮"])
("roast" ["烘烤"])
("rob" ["搶劫"])
("robber" ["強盜"])
("robbery" ["掠奪"])
("robe" ["外袍"])
("robin" ["知更鳥"])
("rock" ["岩石"])
("rocket" ["火箭"])
("rocky" ["岩石的"])
("rod" ["棒" "魚竿"])
("role" ["角色"])
("roll" ["滾動"])
("rollcall" ["點名"])
("roller" ["滾筒"])
("romance" ["戀愛"])
("roof" ["屋頂"])
("room" ["房間"])
("rooster" ["雄雞"])
("root" ["根"])
("rope" ["繩索"])
("rose" ["薔薇"])
("rosebud" ["薔薇花蕾"])
("rosy" ["透紅的"])
("rot" ["腐壞"])
("rotate" ["迴轉"])
("rotation" ["迴轉"])
("rotten" ["腐敗的"])
("rouge" ["胭脂"])
("rough" ["粗的"])
("round" ["圓的"])
("rouse" ["喚醒"])
("route" ["路線"])
("routine" ["日常工作"])
("rove" ["轉來轉去"])
("rover" ["流浪者"])
("row" ["一排"])
("royal" ["國王的"])
("royalty" ["王權"])
("rub" ["揉"])
("rubber" ["橡膠"])
("rubbish" ["廢物"])
("ruby" ["紅寶石"])
("rude" ["無禮的"])
("rudely" ["無禮地"])
("rug" ["毯子"])
("rugged" ["崎嶇的"])
("ruin" ["毀滅"])
("rule" ["規則"])
("ruler" ["統治者"])
("ruling" ["裁定"])
("rum" ["甜酒"])
("rumble" ["噪音"])
("rumor" ["謠言"])
("run" ["跑"])
("runaway" ["逃亡者"])
("runner" ["跑步者"])
("running" ["跑的"])
("rural" ["鄉下的"])
("rush" ["速行"])
("rust" ["鐵秀"])
("rustic" ["鄉村的"])
("rusty" ["腐蝕的"])
("ruthless" ["無情的"])
("sable" ["黑貂"])
("sack" ["大袋子"])
("sacred" ["神聖的"])
("sacrifice" ["犧牲"])
("sad" ["悲哀"])
("saddle" ["鞍"])
("sadly" ["悲痛地"])
("sadness" ["悲哀"])
("safe" ["安全"])
("safeguard" ["保護"])
("safely" ["安全地"])
("safety" ["安全"])
("sag" ["鬆弛"])
("sage" ["賢能的"])
("sail" ["帆船"])
("sailor" ["水手"])
("saint" ["聖人"])
("sake" ["緣故"])
("salad" ["沙拉"])
("salary" ["薪水"])
("sale" ["銷售"])
("salesman" ["售貨員"])
("salmon" ["鮭魚"])
("salon" ["沙龍"])
("salt" ["鹽"])
("salute" ["敬禮"])
("salvation" ["救世"])
("same" ["相同的"])
("sample" ["樣品"])
("sanction" ["核准"])
("sand" ["沙"])
("sandal" ["涼鞋"])
("sandstone" ["沙岩"])
("sandwich" ["三明治"])
("sandy" ["沙的"])
("sane" ["頭腦清楚的"])
("sanitary" ["衛生的"])
("sanitation" ["衛生設備"])
("sardine" ["沙丁魚"])
("sash" ["飾帶"])
("satellite" ["衛星"])
("satin" ["緞布"])
("satire" ["諷刺"])
("satisfactory" ["滿意的"])
("satisfy" ["滿意"])
("saturday" ["星期六"])
("satyr" ["色狼"])
("sauce" ["調味汁"])
("saucepan" ["平底鍋"])
("saucer" ["小碟子"])
("saucy" ["俏皮的"])
("sausage" ["香腸"])
("savage" ["天然的"])
("save" ["拯救"])
("saving" ["節省"])
("savior" ["拯救的"])
("savor" ["風味"])
("saw" ["鋸開"])
("say" ["說"])
("saying" ["名言"])
("scald" ["燙傷"])
("scale" ["磅秤"])
("scalp" ["頭皮"])
("scamper" ["疾走"])
("scan" ["細看"])
("scandal" ["醜事"])
("scant" ["缺乏的"])
("scanty" ["缺乏的"])
("scar" ["疤痕"])
("scarce" ["缺乏的"])
("scarcely" ["幾乎沒有"])
("scarcity" ["缺乏"])
("scare" ["害怕"])
("scarecrow" ["稻草人"])
("scarf" ["圍巾"])
("scarlet" ["深紅色"])
("scatter" ["散步"])
("scene" ["實況"])
("scenery" ["景色"])
("scenic" ["景色"])
("scent" ["氣味"])
("scepter" ["權杖"])
("schedule" ["時間表"])
("scheme" ["計劃"])
("scholar" ["學者"])
("scholarship" ["獎學金"])
("school" ["學校"])
("schoolboy" ["學童"])
("schoolgirl" ["女學生"])
("schoolhouse" ["校舍"])
("schoolmaster" ["校長"])
("schoolroom" ["教室"])
("schooner" ["大篷車"])
("science" ["科學"])
("scientific" ["科學的"])
("scientist" ["科學家"])
("scissors" ["剪刀"])
("scoff" ["嘲笑"])
("scold" ["責罵"])
("scoop" ["杓子"])
("scope" ["眼界"])
("scorch" ["燒焦"])
("score" ["得分"])
("scorn" ["輕視"])
("scornful" ["輕視的"])
("scoundrel" ["無籟"])
("scour" ["擦洗"])
("scourge" ["災害"])
("scout" ["童子軍"])
("scowl" ["皺眉頭"])
("scramble" ["攪亂"])
("scrap" ["零頭" "剪報"])
("scrapbook" ["剪貼簿"])
("scrape" ["刮掉"])
("scratch" ["抓傷"])
("screech" ["尖叫"])
("screen" ["布幕" "銀幕"])
("screw" ["螺絲釘"])
("script" ["手稿"])
("scripture" ["經典"])
("scroll" ["卷軸"])
("scrub" ["擦洗" "灌木叢"])
("scruple" ["顧忌"])
("sculptor" ["彫刻家"])
("sculpture" ["彫刻品"])
("scurry" ["疾走"])
("scuttle" ["煤箱"])
("scythe" ["大鐮刀"])
("sea" ["海洋"])
("seacoast" ["海岸"])
("seal" ["印章" "記號" "海豹"])
("seam" ["接縫"])
("seaman" ["水手"])
("seaport" ["港口"])
("search" ["搜查"])
("searchlight" ["探照燈"])
("seashore" ["海岸"])
("seasick" ["暈船的"])
("seaside" ["海邊"])
("season" ["季節"])
("seat" ["座位"])
("seaweed" ["海澡"])
("seclude" ["隔離"])
("second" ["第二" "贊成"])
("secondary" ["次要的"])
("secondhand" ["二手貨"])
("secrecy" ["秘密"])
("secret" ["秘密的"])
("secretary" ["秘書"])
("sect" ["宗派"])
("section" ["部分"])
("secular" ["世俗的"])
("secure" ["保護"])
("security" ["安全"])
("see" ["看見"])
("seed" ["種子"])
("seedling" ["秧苗"])
("seeing" ["由於"])
("seek" ["尋求"])
("seem" ["似乎"])
("seeming" ["似乎的"])
("seesaw" ["蹺蹺板"])
("seethe" ["起泡沫"])
("segment" ["部分"])
("seize" ["捕捉"])
("seldom" ["很少"])
("select" ["挑選"])
("selection" ["選擇"])
("self" ["自己"])
("selfish" ["自私的"])
("selfishness" ["自私"])
("selfsame" ["同樣的"])
("sell" ["出售"])
("seller" ["賣主"])
("semblance" ["相似"])
("semicolon" ["分號"])
("senate" ["參議院"])
("senator" ["參議員"])
("send" ["送" "派"])
("senior" ["年長的"])
("sensation" ["感情"])
("sensational" ["驚人的"])
("sense" ["感官"])
("senseless" ["無知覺的"])
("sensibility" ["感性"])
("sensible" ["明顯的"])
("sensitive" ["敏感的"])
("sentence" ["判決" "句子"])
("sentiment" ["情緒"])
("sentimental" ["情緒化的"])
("sentinel" ["哨兵"])
("separate" ["分開"])
("separation" ["分離"])
("september" ["九月"])
("sepulcher" ["墳墓"])
("sequence" ["順序"])
("serenade" ["小夜曲"])
("serene" ["安詳的"])
("serge" ["毛嗶嘰"])
("sergeant" ["軍士" "警官"])
("series" ["系列"])
("serious" ["嚴重的"])
("sermon" ["講道"])
("serpent" ["蛇"])
("servant" ["僕人"])
("serve" ["侍候"])
("service" ["服務"])
("session" ["會期"])
("set" ["安置"])
("settle" ["安頓"])
("settled" ["固定的"])
("settlement" ["和解" "殖民地"])
("settler" ["定居者"])
("seven" ["七"])
("seventeen" ["十七"])
("seventeenth" ["第十七的"])
("seventh" ["第七" "的"])
("seventieth" ["第七十的"])
("seventy" ["七十"])
("sever" ["切斷"])
("several" ["幾個"])
("severe" ["嚴厲的"])
("severity" ["嚴厲"])
("sew" ["縫紉"])
("sewer" ["下水道"])
("sex" ["性別"])
("shabby" ["破舊的"])
("shade" ["陰涼處"])
("shadow" ["陰影"])
("shadowy" ["有陰影的"])
("shady" ["陰涼的"])
("shaft" ["箭桿" "矛柄"])
("shaggy" ["毛茸茸的"])
("shake" ["搖動"])
("shale" ["頁岩"])
("shall" ["將"])
("shallow" ["淺的"])
("shalt" ["將"])
("shame" ["羞恥"])
("shameful" ["不體面的"])
("shape" ["型狀"])
("shapeless" ["沒有形狀的"])
("share" ["份兒"])
("shark" ["鯊魚"])
("sharp" ["銳利的"])
("sharpen" ["削"])
("sharply" ["銳利地"])
("shatter" ["打碎"])
("shave" ["刮"])
("shawl" ["圍巾"])
("she" ["她"])
("sheaf" ["束"])
("shear" ["剪斷"])
("sheath" ["鞘"])
("shed" ["散出"])
("sheep" ["羊"])
("sheer" ["全然的"])
("sheet" ["床單" "一張"])
("shelf" ["擱板"])
("shell" ["殼"])
("shellfish" ["貝"])
("shelter" ["隱藏處"])
("shepherd" ["牧羊者"])
("sheriff" ["郡治安官"])
("shield" ["盾"])
("shift" ["替換"])
("shilling" ["先令"])
("shimmer" ["淡光"])
("shin" ["外小腿"])
("shine" ["發亮"])
("shingle" ["木瓦"])
("shiny" ["發亮的"])
("ship" ["船"])
("shipment" ["裝船"])
("shipping" ["裝貨"])
("shipwreck" ["遇難船"])
("shirt" ["襯衣"])
("shiver" ["發抖"])
("shock" ["震動"])
("shoe" ["鞋"])
("shoemaker" ["皮鞋匠"])
("shoot" ["射擊"])
("shop" ["店"])
("shopkeeper" ["店主"])
("shopping" ["購物"])
("shore" ["岸"])
("short" ["短"])
("shortage" ["缺乏"])
("shorten" ["弄短"])
("shortening" ["弄短"])
("shorthand" ["速記"])
("shortly" ["不久"])
("shortsighted" ["近視"])
("shot" ["發射"])
("should" ["將會"])
("shoulder" ["肩膀"])
("shout" ["叫喊"])
("shove" ["推"])
("shovel" ["鏟子"])
("show" ["表演" "顯示"])
("shower" ["驟雨"])
("shred" ["碎布條"])
("shrewd" ["敏捷的"])
("shriek" ["尖叫"])
("shrill" ["尖銳的"])
("shrine" ["神社"])
("shrink" ["縮小"])
("shrivel" ["起皺紋"])
("shrub" ["灌木"])
("shrug" ["聳肩"])
("shudder" ["發抖"])
("shuffle" ["洗紙牌"])
("shun" ["躲避"])
("shut" ["閉"])
("shutter" ["百葉窗"])
("shuttle" ["梭"])
("shy" ["害羞"])
("sick" ["病"])
("sicken" ["使作嘔"])
("sickness" ["病"])
("side" ["旁邊"])
("sidewalk" ["人行道"])
("siege" ["圍城"])
("sieve" ["篩子"])
("sift" ["篩"])
("sigh" ["嘆息"])
("sight" ["視覺"])
("sign" ["誌,簽名"])
("signal" ["信號"])
("signature" ["簽名"])
("significance" ["重要性"])
("significant" ["重要的"])
("signify" ["表示"])
("silence" ["沈默"])
("silent" ["無聲的"])
("silk" ["絲"])
("silkworm" ["蠶"])
("silly" ["愚蠢的"])
("silver" ["銀"])
("silvery" ["像銀的"])
("similar" ["類似的"])
("simple" ["簡單的"])
("simplicity" ["簡單"])
("simplify" ["簡化"])
("simply" ["簡單地"])
("simultaneous" ["同時的"])
("sin" ["罪惡"])
("since" ["自從"])
("sincere" ["真摯的"])
("sincerely" ["誠摯地"])
("sincerity" ["真摯"])
("sinew" ["腱子" "力量"])
("sing" ["歌唱"])
("singer" ["歌手"])
("single" ["單獨的"])
("singular" ["特殊的"])
("sinister" ["邪惡的"])
("sink" ["沈落" "水槽"])
("sinner" ["罪人"])
("sip" ["啜飲"])
("sir" ["先生"])
("sire" ["閣下"])
("siren" ["警報器"])
("sister" ["姊妹"])
("sit" ["坐"])
("site" ["位置"])
("situated" ["位於﹍"])
("situation" ["情況"])
("six" ["六"])
("sixteen" ["十六"])
("sixteenth" ["第十六的"])
("sixth" ["第六"])
("sixtieth" ["第六十的"])
("sixty" ["六十"])
("size" ["尺寸" "大小"])
("skate" ["溜冰鞋"])
("skeleton" ["骨架"])
("skeptical" ["多疑的"])
("sketch" ["草稿" "素描"])
("ski" ["滑雪"])
("skill" ["技能"])
("skilled" ["熟練的"])
("skillful" ["熟練的"])
("skim" ["撇去"])
("skin" ["皮膚"])
("skip" ["跳躍"])
("skirmish" ["小衝突"])
("skirt" ["裙子"])
("skull" ["頭蓋骨"])
("skunk" ["臭鼬"])
("sky" ["天空"])
("skylark" ["雲雀"])
("skyscraper" ["摩天摟"])
("slab" ["石片" "木板"])
("slack" ["煤渣" "緩慢的"])
("slacken" ["緩慢"])
("slam" ["猛撞"])
("slander" ["誹謗"])
("slang" ["俚語"])
("slant" ["傾斜"])
("slap" ["掌擊"])
("slash" ["割傷"])
("slate" ["石板"])
("slaughter" ["屠殺"])
("slave" ["奴隸"])
("slavery" ["奴隸制度"])
("slay" ["殺"])
("sled" ["雪撬"])
("sledge" ["雪撬" "大錘"])
("sleek" ["光滑的"])
("sleep" ["睡覺"])
("sleeper" ["睡眠者"])
("sleeping" ["睡眠"])
("sleepy" ["想睡的"])
("sleet" ["冰雹"])
("sleeve" ["袖子"])
("sleigh" ["雪撬"])
("slender" ["細長"])
("slice" ["片" "切片"])
("slide" ["滑落"])
("slight" ["輕微的"])
("slim" ["瘦長的"])
("sling" ["彈弓" "吊繩"])
("slip" ["滑倒" "溜走"])
("slipper" ["拖鞋"])
("slippery" ["滑溜的"])
("slogan" ["口號" "標語"])
("slope" ["傾斜"])
("slow" ["緩慢"])
("slug" ["小毛蟲"])
("slumber" ["睡眠"])
("slump" ["陷落"])
("sly" ["隱密的"])
("smack" ["滋味" "拍擊"])
("small" ["小的"])
("smallpox" ["天花"])
("smart" ["精明的"])
("smash" ["搗碎"])
("smear" ["弄髒"])
("smell" ["聞"])
("smile" ["微笑"])
("smite" ["打擊" "責備"])
("smith" ["工匠"])
("smock" ["罩衫"])
("smoke" ["煙霧" "抽煙"])
("smoking" ["冒煙的"])
("smooth" ["光滑的"])
("smother" ["悶" "蓋"])
("smuggle" ["走私"])
("snail" ["蝸牛"])
("snake" ["蛇"])
("snap" ["折斷" "搶奪"])
("snare" ["陷阱" "誘陷"])
("snarl" ["怒吼" "糾纏"])
("snatch" ["奪取"])
("sneak" ["潛行"])
("sneer" ["嘲笑"])
("sneeze" ["打噴嚏"])
("sniff" ["吸氣"])
("snore" ["打呼"])
("snort" ["作哼聲"])
("snow" ["雪"])
("snowy" ["似雪的"])
("snuff" ["吸入鼻中"])
("snug" ["舒適的"])
("so" ["如此"])
("so-called" ["所謂"])
("soak" ["浸透"])
("soap" ["肥皂"])
("soar" ["高飛"])
("sob" ["嗚咽"])
("sober" ["清醒的"])
("soccer" ["足球"])
("social" ["社會的"])
("socialism" ["社會主義"])
("socialist" ["社會主義者"])
("society" ["社會"])
("sock" ["短襪"])
("socket" ["插座" "凹槽"])
("sod" ["草地"])
("soda" ["汽水"])
("sofa" ["沙發"])
("soft" ["柔軟的"])
("soften" ["變軟"])
("soil" ["泥土"])
("sojourn" ["停留"])
("solace" ["安慰"])
("solar" ["太陽"])
("soldier" ["士兵"])
("sole" ["單一的"])
("solemn" ["嚴肅的"])
("solemnity" ["嚴肅"])
("solicit" ["律師"])
("solid" ["固體的"])
("solitary" ["單獨的"])
("solitude" ["單獨"])
("solo" ["獨唱" "獨奏"])
("solution" ["解答" "溶解"])
("solve" ["解決"])
("somber" ["陰暗的"])
("some" ["一些"])
("somebody" ["某人"])
("somehow" ["不知何故"])
("someone" ["某人"])
("something" ["某物"])
("sometime" ["某時" "日後"])
("sometimes" ["有時" "不時"])
("somewhat" ["有點"])
("somewhere" ["某處"])
("son" ["兒子"])
("song" ["歌曲"])
("sonnet" ["十四行詩"])
("soon" ["不久"])
("soot" ["煤灰"])
("soothe" ["安慰"])
("sordid" ["污穢的"])
("sore" ["疼痛的"])
("sorrow" ["悲傷"])
("sorrowful" ["悲傷的"])
("sorry" ["抱歉"])
("sort" ["種類"])
("soul" ["靈魂"])
("sound" ["健全的" "試探" "聲音"])
("soup" ["羹湯"])
("sour" ["酸的"])
("source" ["來源"])
("south" ["南方"])
("southeast" ["東南"])
("southern" ["南方的"])
("southward" ["向南"])
("southwest" ["西南"])
("southwestward" ["向西南"])
("sovereign" ["具有主權的"])
("sovereignty" ["主權"])
("sow" ["播種"])
("space" ["空間"])
("spacious" ["廣的"])
("spade" ["鏟子"])
("span" ["短時間"])
("spangle" ["金光閃爍"])
("spank" ["一巴掌"])
("spare" ["饒恕"])
("spark" ["火花"])
("sparkle" ["火花"])
("sparrow" ["麻雀"])
("speak" ["說"])
("speaker" ["演說者"])
("spear" ["矛"])
("special" ["特別的"])
("specialist" ["專家"])
("specialize" ["專門化"])
("species" ["種類"])
("specific" ["特殊的"])
("specify" ["指定"])
("specimen" ["樣品"])
("speck" ["斑點"])
("speckle" ["小斑點"])
("spectacle" ["奇觀" "眼鏡"])
("spectacular" ["壯觀的"])
("spectator" ["觀眾"])
("specter" ["幽靈"])
("spectrum" ["光譜"])
("speculate" ["推測"])
("speculation" ["推測"])
("speculative" ["推理的"])
("speech" ["演講"])
("speechless" ["說不出話來"])
("speed" ["速率"])
("speedy" ["迅速的"])
("spell" ["拼"])
("spelling" ["拼字"])
("spend" ["花費"])
("sphere" ["球狀"])
("sphinx" ["人頭獅身"])
("spice" ["香料"])
("spider" ["蜘蛛"])
("spike" ["長釘"])
("spill" ["潑掉"])
("spin" ["紡"])
("spinach" ["菠菜"])
("spindle" ["紡錘"])
("spine" ["背骨"])
("spinning" ["紡織"])
("spiral" ["螺旋形"])
("spire" ["尖塔"])
("spirit" ["精神"])
("spiritual" ["心靈上的"])
("spit" ["吐"])
("splash" ["濺開"])
("splendid" ["卓越的"])
("splendor" ["光彩"])
("splinter" ["碎片"])
("split" ["均分"])
("spoil" ["弄糟" "寵壞"])
("spoke" ["輻條"])
("spokesman" ["發言人"])
("sponge" ["海綿"])
("sponsor" ["贊助"])
("spontaneous" ["自然的"])
("spool" ["線軸"])
("spoon" ["匙"])
("spoonful" ["一匙"])
("sport" ["運動"])
("sportsman" ["運動家"])
("spot" ["點"])
("spouse" ["配偶"])
("spout" ["噴出"])
("spray" ["噴出"])
("spread" ["使蔓延"])
("spring" ["春天,跳" "彈簧"])
("sprinkle" ["灑"])
("sprout" ["芽"])
("spy" ["間諜"])
("square" ["正方形"])
("squash" ["壓扁"])
("squat" ["蹲"])
("squeak" ["吱吱聲"])
("squeal" ["尖聲啼哭"])
("squeeze" ["壓扁"])
("squire" ["鄉紳"])
("squirrel" ["松鼠"])
("stab" ["刺"])
("stability" ["安定"])
("stable" ["堅固的"])
("stack" ["堆"])
("stadium" ["體育館"])
("staff" ["職員"])
("stag" ["雄鹿"])
("stage" ["臺,階段"])
("stagger" ["蹣跚"])
("stain" ["污點"])
("stainless" ["不鏽鋼"])
("stair" ["樓梯"])
("staircase" ["樓梯"])
("stake" ["賭注"])
("stale" ["不新鮮的"])
("stalk" ["莖"])
("stall" ["陳列臺"])
("stammer" ["口吃"])
("stamp" ["郵票" "印章" "頓足" "鎮壓"])
("stanch" ["止血" "堅強的"])
("stand" ["站住"])
("standard" ["標準"])
("standing" ["身份" "地位"])
("standpoint" ["立場"])
("stanza" ["一節(詩)"])
("staple" ["名產" "主題" "釘書針"])
("star" ["星" "明星"])
("starch" ["澱粉"])
("stare" ["注視"])
("stark" ["僵硬的"])
("starry" ["多星的"])
("start" ["出發" "開始"])
("startle" ["吃驚"])
("startling" ["驚人的"])
("starvation" ["餓死"])
("starve" ["飢餓"])
("state" ["州" "狀況" "聲明"])
("stately" ["莊嚴的"])
("statement" ["聲明書"])
("statesman" ["政治家"])
("station" ["車站"])
("stationary" ["固定的"])
("stationer" ["文具商"])
("stationery" ["文具"])
("statistics" ["統計學"])
("statue" ["雕像"])
("stature" ["身材"])
("status" ["狀況" "地位"])
("statute" ["法規"])
("stay" ["停留" "延緩"])
("steadfast" ["固定的"])
("steady" ["穩定的"])
("steak" ["牛排" "魚排"])
("steal" ["偷竊"])
("steam" ["蒸汽"])
("steamboat" ["汽船"])
("steamer" ["蒸汽機"])
("steamship" ["汽船"])
("steed" ["駿馬"])
("steel" ["鋼"])
("steep" ["險峻的"])
("steeple" ["尖頂"])
("steer" ["駕駛"])
("stem" ["阻止" "柄" "幹"])
("stenographer" ["速記員"])
("step" ["腳步"])
("stepmother" ["後母"])
("sterling" ["純品的"])
("stern" ["嚴格的"])
("stew" ["燉"])
("steward" ["服務員"])
("stewardess" ["女服物員"])
("stick" ["棍子" "插入"])
("sticky" ["粘粘的"])
("stiff" ["僵硬的"])
("stiffen" ["變硬"])
("stifle" ["窒息"])
("stigma" ["瑕疵"])
("still" ["靜止"])
("stillness" ["靜止"])
("stimulate" ["刺激"])
("stimulus" ["刺激物"])
("sting" ["刺" "叮"])
("stir" ["攪拌"])
("stirrup" ["馬蹬"])
("stitch" ["針法"])
("stock" ["存貨" "股票"])
("stockholder" ["股東"])
("stocking" ["長襪"])
("stomach" ["胃"])
("stone" ["石頭"])
("stony" ["石狀的"])
("stool" ["凳子" "大便"])
("stoop" ["彎腰" "門廊"])
("stop" ["停止"])
("storage" ["儲藏室"])
("store" ["商店"])
("storehouse" ["倉庫"])
("storm" ["暴風雨"])
("stormy" ["暴風雨的"])
("story" ["故事"])
("stout" ["肥碩的"])
("stove" ["爐灶"])
("straight" ["直的"])
("straighten" ["弄直"])
("straightway" ["立刻"])
("strain" ["血統" "拉緊"])
("strait" ["海峽"])
("strand" ["一串"])
("strange" ["奇怪的"])
("stranger" ["陌生人"])
("strap" ["皮帶" "抽打"])
("stratagem" ["計策"])
("straw" ["稻草" "吸管"])
("strawberry" ["草莓"])
("stray" ["遊蕩"])
("streak" ["線條"])
("stream" ["溪流"])
("streamer" ["飾帶"])
("street" ["街道"])
("streetcar" ["電車"])
("strength" ["力氣"])
("strengthen" ["加強"])
("strenuous" ["費力的"])
("stress" ["壓力" "重音"])
("stretch" ["張開"])
("stretcher" ["擔架床"])
("strew" ["散播"])
("stricken" ["被侵害的"])
("strict" ["嚴格的"])
("stride" ["大步走"])
("strife" ["爭吵"])
("strike" ["打擊" "罷工"])
("striking" ["引人注目的" "打擊的"])
("string" ["細線" "繩子"])
("strip" ["長條" "脫掉"])
("stripe" ["條紋"])
("striped" ["有條紋的"])
("strive" ["奮鬥"])
("stroke" ["打擊" "中風"])
("stroll" ["脈搏" "筆畫"])
("strong" ["堅強的"])
("stronghold" ["要塞"])
("structure" ["構造"])
("struggle" ["奮鬥" "掙扎"])
("strut" ["昂首闊步"])
("stub" ["存根"])
("stubble" ["殘株"])
("stubborn" ["頑固"])
("stud" ["飾釘"])
("student" ["學生"])
("studio" ["工作室"])
("study" ["讀書"])
("stuff" ["東西" "填塞"])
("stumble" ["絆倒" "蹣跚"])
("stump" ["樹樁"])
("stun" ["目瞪口呆"])
("stunt" ["絕技"])
("stupendous" ["驚人的"])
("stupid" ["愚笨的"])
("sturdy" ["強健的"])
("style" ["式樣" "風格"])
("subdue" ["征服"])
("subject" ["科目" "主詞" "提出"])
("subjunctive" ["假設語氣"])
("sublime" ["崇高的"])
("submarine" ["潛水艇"])
("submerge" ["淹沒"])
("submission" ["歸順"])
("submit" ["建議"])
("subordinate" ["附屬的"])
("subscribe" ["訂購"])
("subscriber" ["訂購者"])
("subscription" ["署名" "訂閱"])
("subsequent" ["後來的"])
("subside" ["退落"])
("subsist" ["存在"])
("substance" ["物質" "實質"])
("substantial" ["大量"])
("substitute" ["代替者"])
("subtle" ["微妙的"])
("subtract" ["減掉"])
("suburb" ["郊區"])
("suburban" ["郊區的"])
("subway" ["地下鐵路"])
("succeed" ["繼承"])
("success" ["成功"])
("successful" ["成功的"])
("succession" ["連續"])
("successive" ["連續的"])
("successor" ["繼承者"])
("succor" ["援手"])
("such" ["這樣的"])
("suck" ["吸吮"])
("sucker" ["呆子"])
("sudden" ["突然的"])
("sue" ["控告"])
("suffer" ["受苦"])
("sufferer" ["受難者"])
("suffering" ["痛苦"])
("sufficient" ["足夠的"])
("suffix" ["字尾"])
("suffocate" ["窒息"])
("sugar" ["糖"])
("suggest" ["提議" "暗示"])
("suggestion" ["建議"])
("suicide" ["自殺"])
("suit" ["一套" "訴訟"])
("suitable" ["適合的"])
("suitcase" ["手提箱"])
("suite" ["套房"])
("suitor" ["起訴者"])
("sulfur" ["硫磺"])
("sullen" ["憂鬱的"])
("sum" ["總和"])
("summary" ["摘要"])
("summer" ["夏天"])
("summit" ["頂"])
("summon" ["召集"])
("sumptuous" ["奢侈的"])
("sun" ["太陽"])
("sunbeam" ["陽光"])
("sunday" ["星期日"])
("sundown" ["日落"])
("sunlight" ["陽光"])
("sunny" ["晴天"])
("sunrise" ["日出"])
("sunset" ["日落"])
("sunshine" ["陽光"])
("superb" ["極好的"])
("superficial" ["表面的"])
("superfluous" ["多餘的"])
("superintendent" ["監督人"])
("superior" ["優越的"])
("superiority" ["優越"])
("superlative" ["最高的"])
("superstition" ["迷信"])
("superstitious" ["迷信的"])
("supervise" ["監督"])
("supervision" ["監督"])
("supervisor" ["監督者"])
("supper" ["晚餐"])
("supplement" ["補充"])
("supply" ["供給"])
("support" ["支持"])
("supporter" ["三角腹帶"])
("suppose" ["假使"])
("supposedly" ["假定的"])
("suppress" ["壓制"])
("supremacy" ["至高"])
("supreme" ["至上的"])
("sure" ["的確"])
("surface" ["表面"])
("surge" ["大浪"])
("surgeon" ["外科醫生"])
("surgery" ["外科手術"])
("surmise" ["推測"])
("surmount" ["戰勝"])
("surname" ["姓"])
("surpass" ["優於"])
("surplus" ["剩餘"])
("surprise" ["使吃驚"])
("surprisingly" ["令人驚異的"])
("surrender" ["放棄" "投降"])
("surround" ["圍住"])
("surrounding" ["環境"])
("survey" ["觀察" "測量"])
("survive" ["生存"])
("survivor" ["生還者"])
("susceptible" ["容易受動搖"])
("suspect" ["懷疑"])
("suspend" ["暫時停止"])
("suspense" ["懸疑"])
("suspension" ["懸掛"])
("suspicion" ["疑心"])
("suspicious" ["可疑的"])
("sustain" ["維持"])
("swallow" ["吞"])
("swamp" ["沼澤"])
("swan" ["天鵝"])
("swarm" ["群"])
("sway" ["搖動"])
("swear" ["發誓"])
("sweat" ["發汗"])
("sweater" ["毛衣"])
("sweep" ["打掃"])
("sweeping" ["勢如破竹的"])
("sweet" ["甜"])
("sweeten" ["加甜"])
("sweetheart" ["愛人"])
("sweetness" ["甜美"])
("swell" ["漲滿"])
("swift" ["快的"])
("swim" ["游泳"])
("swine" ["豬"])
("swing" ["擺動"])
("swirl" ["漩渦"])
("switch" ["開關" "替換"])
("swollen" ["脹大的"])
("sword" ["劍"])
("syllable" ["音節"])
("symbol" ["象徵"])
("symmetrical" ["對稱性的"])
("sympathetic" ["有同情心的"])
("sympathize" ["同情"])
("sympathy" ["同情"])
("symphony" ["交響曲"])
("symptom" ["徵兆" "症狀"])
("syndicate" ["聯合組織"])
("synonym" ["同義字"])
("syntax" ["語法"])
("syrup" ["糖漿"])
("system" ["系統"])
("systematic" ["有系統的"])
("table" ["桌子"])
("tablet" ["平板"])
("tack" ["大頭釘"])
("tackle" ["釣魚用具"])
("tact" ["機智"])
("tactics" ["策略"])
("tag" ["標籤"])
("tail" ["尾巴"])
("tailor" ["裁縫師"])
("taint" ["污點"])
("take" ["拿"])
("tale" ["故事"])
("talent" ["才能"])
("talk" ["談論"])
("tall" ["高"])
("tame" ["馴服的"])
("tan" ["黃褐色"])
("tangle" ["糾纏"])
("tank" ["槽"])
("tap" ["輕打" "龍頭"])
("tape" ["膠帶" "捲帶"])
("taper" ["尖細"])
("tapestry" ["繡帷"])
("tar" ["焦油"])
("tardy" ["緩慢的"])
("target" ["目標"])
("tariff" ["關稅"])
("tarry" ["耽擱"])
("tart" ["果餡餅"])
("task" ["派給工作"])
("tassel" ["穗飾"])
("taste" ["滋味" "品味"])
("tatter" ["碎片"])
("tavern" ["客棧"])
("tawny" ["黃褐色"])
("tax" ["租稅"])
("taxation" ["賦稅"])
("taxi" ["計程車"])
("taxpayer" ["納稅人"])
("tea" ["茶"])
("teach" ["教導"])
("teacher" ["老師"])
("team" ["團隊"])
("tear" ["眼淚" "撕破"])
("tease" ["取笑"])
("teaspoon" ["茶匙"])
("technical" ["技術的"])
("technique" ["技術"])
("tedious" ["乏味的"])
("teem" ["充滿"])
("telegram" ["電報"])
("telegraph" ["電報機"])
("telephone" ["電話"])
("telescope" ["望眼鏡"])
("tell" ["告訴"])
("teller" ["出納員"])
("temper" ["脾氣"])
("temperament" ["氣質"])
("temperance" ["節制"])
("temperate" ["有節制的"])
("temperature" ["溫度"])
("tempest" ["暴風雨"])
("temple" ["寺廟"])
("temporary" ["暫時的"])
("tempt" ["勾引"])
("temptation" ["誘惑"])
("tempting" ["迷人的"])
("ten" ["十"])
("tenant" ["房客"])
("tend" ["走向" "照料"])
("tendency" ["趨勢"])
("tender" ["細嫩的"])
("tenderness" ["溫和性"])
("tenement" ["住宅"])
("tennis" ["網球"])
("tenor" ["男高音"])
("tense" ["拉緊" "時態"])
("tension" ["壓力"])
("tent" ["帳篷"])
("tenth" ["第十"])
("term" ["術語"])
("terminal" ["終點"])
("terminate" ["結束"])
("terrace" ["平台"])
("terrible" ["可怕的"])
("terribly" ["可怕地"])
("terrific" ["非常的"])
("terrify" ["驚嚇"])
("territory" ["領土"])
("terror" ["恐怖"])
("test" ["考試"])
("testament" ["遺囑"])
("testify" ["證實"])
("text" ["本文"])
("textbook" ["教科書"])
("textile" ["紡織品"])
("texture" ["質地"])
("than" ["比"])
("thank" ["感謝"])
("thankful" ["感謝的"])
("thanksgiving" ["感恩"])
("that" ["那個"])
("thatch" ["茅屋頂"])
("thaw" ["解凍"])
("the" ["這"])
("theater" ["戲院"])
("theatrical" ["戲劇化的"])
("thee" ["你"])
("theft" ["偷竊"])
("their" ["他們的"])
("theirs" ["他們的東西"])
("them" ["他們"])
("theme" ["主題"])
("themselves" ["他們自己"])
("then" ["當時"])
("thence" ["從此"])
("theological" ["神學的"])
("theology" ["神學"])
("theory" ["理論"])
("there" ["那裡"])
("thereabout" ["在那附近"])
("thereafter" ["在那之後"])
("thereby" ["因此"])
("therefore" ["所以"])
("therein" ["在其中"])
("thereof" ["關於"])
("thereon" ["在那上面"])
("thereupon" ["立刻"])
("therewith" ["隨後"])
("thermometer" ["溫度計"])
("these" ["這些"])
("they" ["他們"])
("thick" ["厚的"])
("thicken" ["變厚"])
("thicket" ["叢林"])
("thickness" ["厚度"])
("thief" ["竊賊"])
("thigh" ["大腿"])
("thimble" ["頂針"])
("thin" ["薄的"])
("thine" ["你的"])
("thing" ["東西"])
("think" ["思考"])
("third" ["第三"])
("thirst" ["口渴"])
("thirsty" ["渴的"])
("thirteen" ["十三"])
("thirteenth" ["第十三"])
("thirtieth" ["第三十"])
("thirty" ["三十"])
("this" ["這個"])
("thistle" ["薊"])
("thither" ["到那裡"])
("thorn" ["刺"])
("thorough" ["完全的"])
("those" ["那些"])
("thou" ["你"])
("though" ["雖然"])
("thought" ["觀念"])
("thoughtful" ["關心的"])
("thoughtless" ["不注意的"])
("thousand" ["千"])
("thrash" ["鞭打"])
("thread" ["細線"])
("threat" ["威脅"])
("threaten" ["威脅"])
("three" ["三"])
("threshold" ["入門"])
("thrice" ["三倍地"])
("thrift" ["節儉"])
("thrifty" ["節儉的"])
("thrill" ["顫抖"])
("thrive" ["興盛"])
("throat" ["喉嚨"])
("throb" ["跳動"])
("throne" ["王座"])
("throng" ["群眾"])
("through" ["經過"])
("throughout" ["遍及"])
("throw" ["丟掉"])
("thrush" ["畫眉鳥"])
("thrust" ["插入"])
("thumb" ["拇指"])
("thump" ["重擊"])
("thunder" ["雷聲"])
("thursday" ["星期四"])
("thus" ["如此"])
("thwart" ["阻橈"])
("thyself" ["你自己"])
("tick" ["滴答聲"])
("ticket" ["票"])
("tickle" ["搔癢"])
("tide" ["潮汐"])
("tidings" ["消息"])
("tidy" ["整潔的"])
("tie" ["打結"])
("tiger" ["老虎"])
("tight" ["緊的"])
("tighten" ["束緊"])
("tile" ["磚瓦"])
("till" ["直到"])
("tilt" ["傾斜"])
("timber" ["木料"])
("time" ["時間"])
("timely" ["及時的"])
("timid" ["膽小的"])
("tin" ["錫"])
("tinge" ["輕染"])
("tingle" ["刺痛"])
("tinker" ["修補匠"])
("tinkle" ["叮噹聲"])
("tint" ["色彩"])
("tiny" ["係小的"])
("tip" ["小費"])
("tiptoe" ["趾尖"])
("tire" ["疲倦"])
("tired" ["疲倦的"])
("tiresome" ["討厭"])
("tissue" ["組織" "薄紙"])
("title" ["標題"])
("to" ["向" "往"])
("toad" ["蟾蜍"])
("toast" ["烤麵包"])
("tobacco" ["煙草"])
("today" ["今天"])
("toe" ["腳趾"])
("together" ["一起"])
("toil" ["勞累"])
("toilet" ["廁所"])
("token" ["象徵"])
("tolerable" ["可容忍的"])
("tolerate" ["寬容"])
("toll" ["通行稅"])
("tomato" ["蕃茄"])
("tomb" ["墳墓"])
("tomorrow" ["明天"])
("ton" ["噸"])
("tone" ["音調"])
("tongs" ["夾鉗"])
("tongue" ["舌頭"])
("tonight" ["今晚"])
("tonnage" ["噸數"])
("too" ["太"])
("tool" ["工具"])
("tooth" ["牙齒"])
("top" ["頂"])
("topic" ["論題"])
("torch" ["火炬"])
("torment" ["折磨"])
("torrent" ["急流"])
("tortoise" ["龜"])
("torture" ["折磨"])
("toss" ["擲錢"])
("total" ["總計"])
("totally" ["統統"])
("totter" ["蹣跚"])
("touch" ["觸摸"])
("touching" ["動人的"])
("tough" ["強硬的"])
("tour" ["周遊"])
("tourist" ["觀光客"])
("tournament" ["競技"])
("tow" ["拖車" "拖船"])
("toward" ["朝向"])
("towel" ["毛巾"])
("tower" ["塔"])
("towering" ["高聳的"])
("town" ["鎮"])
("township" ["鎮區"])
("toy" ["玩具"])
("trace" ["跡象"])
("track" ["跑道"])
("tractor" ["拖曳機"])
("trade" ["生意"])
("trader" ["商人"])
("tradesman" ["零售商"])
("tradition" ["傳統"])
("traditional" ["傳統的"])
("traffic" ["交通"])
("tragic" ["悲劇"])
("trail" ["跡,線索"])
("trailer" ["活動房屋"])
("train" ["列車"])
("trainer" ["訓練者"])
("training" ["訓練"])
("trait" ["特徵"])
("traitor" ["叛逆者"])
("tram" ["電車"])
("tramp" ["踐踏"])
("trample" ["踐踏"])
("tranquil" ["寧靜的"])
("tranquility" ["寧靜"])
("transact" ["交易"])
("transaction" ["交易"])
("transfer" ["遷移"])
("transform" ["變換"])
("transformation" ["變換"])
("transient" ["暫時寄"])
("transit" ["運輸"])
("transition" ["過渡時期"])
("transitive" ["及物的"])
("translate" ["翻譯"])
("translation" ["翻譯"])
("transmission" ["傳送"])
("transmit" ["傳送"])
("transparent" ["透明的"])
("transport" ["輸送"])
("transportation" ["轉運"])
("transverse" ["橫斷物"])
("trap" ["圈套"])
("travel" ["遊歷"])
("traveler" ["旅客"])
("traverse" ["橫過"])
("tray" ["盤子"])
("treachery" ["背叛"])
("tread" ["踐踏"])
("treason" ["叛逆"])
("treasure" ["財寶"])
("treasurer" ["出納員"])
("treasury" ["寶庫"])
("treat" ["對待"])
("treatise" ["論述"])
("treatment" ["待遇"])
("treaty" ["條約"])
("treble" ["三重的"])
("tree" ["樹"])
("tremble" ["發抖"])
("tremendous" ["很大的"])
("tremulous" ["發抖的"])
("trench" ["渠溝"])
("trend" ["趨勢"])
("trespass" ["侵害"])
("trial" ["試驗,審判"])
("triangle" ["三角形"])
("tribe" ["部落"])
("tribute" ["貢物"])
("trick" ["秘訣"])
("trickle" ["滴流"])
("trifle" ["瑣事"])
("trifling" ["些許的"])
("trim" ["修剪"])
("trinity" ["三位一體"])
("trip" ["旅行" "旅程"])
("triple" ["三倍的"])
("triumph" ["凱旋"])
("triumphant" ["獲勝的"])
("trivial" ["瑣細的"])
("trolley" ["手推車"])
("troop" ["軍隊"])
("trophy" ["紀念獎"])
("tropic" ["熱帶"])
("tropical" ["熱帶的"])
("trot" ["快步跑"])
("trouble" ["困難"])
("troublesome" ["麻煩的"])
("trough" ["槽"])
("trouser" ["褲子"])
("trout" ["尊魚"])
("truck" ["卡車"])
("true" ["真的"])
("truly" ["真實地"])
("trumpet" ["喇叭"])
("trunk" ["軀幹"])
("trust" ["信任"])
("trustee" ["受託人"])
("trusting" ["相信的"])
("trusty" ["可信任的"])
("truth" ["真理"])
("truthful" ["誠實的"])
("try" ["試"])
("trying" ["難捱的"])
("tub" ["浴盆"])
("tube" ["筒"])
("tuck" ["擠進"])
("tuesday" ["星期二"])
("tug" ["強拉"])
("tulip" ["鬱金香"])
("tumble" ["滾落"])
("tune" ["調子"])
("tunnel" ["隧道"])
("turbulent" ["不穩定氣流"])
("turf" ["草地"])
("turn" ["轉動"])
("turnip" ["蕪菁"])
("turtle" ["海龜"])
("tutor" ["家庭教師"])
("tweed" ["斜紋軟呢"])
("twelfth" ["第十二"])
("twelve" ["十二"])
("twentieth" ["第二十"])
("twenty" ["二十"])
("twice" ["兩次"])
("twilight" ["微明"])
("twin" ["雙胞胎"])
("twine" ["合股線"])
("twinkle" ["閃亮"])
("twinkling" ["閃爍的"])
("twist" ["扭轉"])
("two" ["二"])
("type" ["樣式,打字"])
("typewriter" ["打字機"])
("typhoid" ["傷寒症"])
("typhoon" ["颱風"])
("typical" ["典型的"])
("typist" ["打字員"])
("tyranny" ["暴政"])
("tyrant" ["暴君"])
("ugly" ["醜的"])
("ultimate" ["最後的"])
("ultimately" ["最後"])
("umpire" ["裁判"])
("unable" ["不能"])
("unanimous" ["全場一致的"])
("unarmed" ["未武裝的"])
("unaware" ["不覺察的"])
("unbearable" ["不堪忍受的"])
("unbroken" ["完整的"])
("uncertainty" ["不確定"])
("unchanged" ["不變的"])
("uncle" ["伯父" "叔父"])
("uncomfortable" ["不舒適的"])
("uncommon" ["稀有的"])
("unconscious" ["失去意識的"])
("unconsciously" ["無意識地"])
("uncover" ["暴露"])
("under" ["在下"])
("underbrush" ["草叢"])
("undergo" ["經歷"])
("underground" ["在地下的"])
("underline" ["底線"])
("underneath" ["在下面"])
("understand" ["了解" "明白"])
("understanding" ["理解"])
("undertake" ["承擔"])
("underwear" ["內衣褲"])
("underworld" ["地獄"])
("undesirable" ["討人厭的"])
("undisturbed" ["安靜的"])
("undo" ["解開"])
("undone" ["未完成的"])
("undress" ["脫衣服"])
("uneasily" ["不自在地"])
("uneasiness" ["不自在"])
("uneasy" ["不安的"])
("unemployment" ["失業"])
("unequal" ["不平衡的"])
("uneven" ["不平的"])
("unexpected" ["意外的"])
("unfair" ["不公平的"])
("unfavorable" ["不利的"])
("unfinished" ["未完成的"])
("unfit" ["不適當的"])
("unfold" ["展開"])
("unfortunate" ["不幸的"])
("unfortunately" ["不幸地"])
("ungrateful" ["忘恩負義的"])
("uniform" ["制服"])
("uniformly" ["相同地"])
("unimportant" ["不重要的"])
("union" ["聯盟" "工會"])
("unique" ["唯一的"])
("unit" ["單位"])
("unite" ["聯合"])
("united" ["聯合的"])
("unity" ["單一" "整體"])
("universal" ["宇宙的"])
("universally" ["普遍地"])
("universe" ["宇宙"])
("university" ["大學"])
("unjust" ["不公平"])
("unkind" ["不仁的"])
("unknown" ["未知的"])
("unless" ["除非"])
("unlike" ["不同的"])
("unlimited" ["無限的"])
("unload" ["卸下"])
("unlock" ["開鎖"])
("unlucky" ["不幸的"])
("unmarried" ["未婚"])
("unmoved" ["不動搖的"])
("unnatural" ["不自然的"])
("unnecessary" ["不必要的"])
("unoccupied" ["沒人住的"])
("unpleasant" ["不愉快的"])
("unprecedent" ["空前的"])
("unreasonable" ["不合理的"])
("unrest" ["不安"])
("unseen" ["看不見的"])
("unspeakable" ["無法形容的"])
("unsuccessful" ["不成功的"])
("untie" ["解開"])
("until" ["直到"])
("unto" ["至" "到"])
("untouched" ["未提及的"])
("untrue" ["不確實的"])
("unusual" ["不平常的"])
("unwelcome" ["不受歡迎的"])
("unwilling" ["不情願的"])
("unwise" ["不智的"])
("unworthy" ["不值得的"])
("up" ["向上地"])
("uphold" ["支持" "舉起"])
("upland" ["高地"])
("uplift" ["抬起"])
("upon" ["在﹍之上"])
("upper" ["上面的"])
("upright" ["直立的"])
("uprising" ["叛亂"])
("uproar" ["騷動"])
("uproot" ["拔根"])
("upset" ["煩惱"])
("upside" ["上邊"])
("upward" ["向上地"])
("upwards" ["向上地"])
("urchin" ["頑童"])
("urge" ["催促"])
("urgent" ["緊急的"])
("urn" ["骨罈"])
("us" ["我們"])
("usage" ["用法"])
("use" ["利用"])
("useful" ["有用的"])
("useless" ["無用的"])
("usher" ["招待員"])
("usual" ["平常的"])
("usurp" ["霸佔"])
("utensil" ["用具"])
("utility" ["公益事業"])
("utilize" ["利用"])
("utmost" ["極端的"])
("utter" ["完全的" "說出"])
("utterance" ["發言"])
("vacancy" ["空缺"])
("vacant" ["空的"])
("vacation" ["假期"])
("vacuum" ["真空"])
("vagabond" ["流浪者"])
("vagrant" ["流浪者"])
("vague" ["含糊的"])
("vain" ["無效的"])
("vale" ["分離" "再會"])
("valiant" ["英勇的"])
("valley" ["山谷"])
("valor" ["勇氣"])
("valuable" ["有價值的"])
("valuation" ["評價"])
("value" ["價值"])
("valve" ["活塞"])
("van" ["貨車"])
("vanish" ["消失"])
("vanity" ["浮華"])
("vanquish" ["征服"])
("vapor" ["水蒸氣"])
("variable" ["會變的"])
("variation" ["變化"])
("varied" ["不同的"])
("variety" ["變化"])
("various" ["不同的"])
("varnish" ["油光漆"])
("vary" ["改變"])
("vase" ["花瓶"])
("vassal" ["附庸"])
("vast" ["大量的"])
("vat" ["大桶"])
("vault" ["撐竿跳"])
("vegetable" ["蔬菜"])
("vegetation" ["植物"])
("vehemence" ["猛烈"])
("vehement" ["猛烈的"])
("vehicle" ["車輛"])
("veil" ["面罩"])
("vein" ["血管"])
("velocity" ["迅速"])
("velvet" ["絲絨"])
("venerable" ["可敬的"])
("vengeance" ["復仇"])
("venom" ["毒物"])
("vent" ["出口"])
("ventilate" ["通風"])
("ventilation" ["通風"])
("venture" ["冒險"])
("veranda" ["走廊"])
("verb" ["動詞"])
("verdict" ["判決"])
("verge" ["邊緣"])
("verify" ["証實"])
("verily" ["真正地"])
("verse" ["韻文"])
("version" ["版本"])
("vertical" ["垂直的"])
("very" ["很"])
("vessel" ["容器" "船"])
("vest" ["背心"])
("vestige" ["痕跡"])
("veteran" ["退伍軍人"])
("veto" ["否決"])
("vex" ["激怒"])
("vexation" ["苦惱"])
("vibrate" ["震動"])
("vibration" ["震動"])
("vice" ["罪惡"])
("vicepresident" ["副總統"])
("vicinity" ["附近"])
("vicious" ["邪惡的"])
("victim" ["受害者"])
("victor" ["勝利者"])
("victory" ["勝利"])
("view" ["景色"])
("viewpoint" ["觀點"])
("vigilance" ["警戒"])
("vigor" ["活力"])
("vigorous" ["精力充沛的"])
("vile" ["惡劣的"])
("villa" ["別墅"])
("village" ["鄉村"])
("villager" ["村民"])
("villain" ["惡棍"])
("vine" ["藤蔓"])
("vinegar" ["醋"])
("vineyard" ["葡萄園"])
("violate" ["違犯"])
("violation" ["犯法"])
("violence" ["暴亂"])
("violent" ["強暴的"])
("violet" ["紫羅蘭色"])
("violin" ["小提琴"])
("viper" ["毒蛇"])
("virgin" ["處女"])
("virtually" ["實質上"])
("virtue" ["道德"])
("virtuous" ["有德行的"])
("visible" ["看得見的"])
("vision" ["視力"])
("visit" ["訪問"])
("visitor" ["訪問者"])
("visual" ["視覺的"])
("vital" ["有活力的"])
("vitality" ["生命力"])
("vitamin" ["維他命"])
("vivid" ["生動的"])
("vocabulary" ["語彙"])
("vocal" ["發聲的"])
("vogue" ["時髦"])
("voice" ["聲音"])
("void" ["空的"])
("volcanic" ["火山的"])
("volcano" ["火山"])
("volleyball" ["排球"])
("volume" ["冊"])
("voluntary" ["自願的"])
("volunteer" ["志願者"])
("vote" ["投票"])
("vow" ["誓言"])
("vowel" ["母音"])
("voyage" ["航行"])
("vulgar" ["粗俗的階級"])
("wade" ["在水步行"])
("wafer" ["感化餅乾"])
("wag" ["搖擺"])
("wage" ["工資" "薪水"])
("wager" ["賭注"])
("wagon" ["運貨馬車"])
("wail" ["哀泣"])
("waist" ["腰"])
("waistcoat" ["背心"])
("wait" ["等"])
("waiter" ["侍者"])
("waiting" ["等候"])
("wake" ["醒"])
("waken" ["醒來"])
("walk" ["走"])
("wall" ["牆壁"])
("wallet" ["錢袋"])
("walnut" ["胡桃"])
("wand" ["棒"])
("wander" ["徘徊"])
("wanderer" ["流浪者"])
("wane" ["虧缺"])
("war" ["戰爭"])
("ward" ["病房"])
("warden" ["典獄長"])
("wardrobe" ["衣廚"])
("ware" ["器具"])
("warehouse" ["倉庫"])
("warfare" ["戰爭"])
("warlike" ["好戰的"])
("warm" ["溫暖的"])
("warmth" ["溫暖"])
("warning" ["警告"])
("warp" ["彎曲"])
("warrant" ["保證"])
("warrior" ["戰士"])
("warship" ["軍艦"])
("wary" ["警覺的"])
("was" ["是"])
("wash" ["洗滌"])
("washing" ["洗滌"])
("wasp" ["黃蜂"])
("waste" ["浪費"])
("wasteful" ["浪費的"])
("watch" ["注意看"])
("watchful" ["注意的"])
("watchman" ["看手者"])
("water" ["水"])
("waterfall" ["瀑布"])
("waterproof" ["防水的"])
("waterway" ["水路"])
("watery" ["含水的"])
("wave" ["波浪"])
("waver" ["搖擺"])
("wax" ["蠟" "漸盈"])
("way" ["道賂"])
("wayside" ["路邊"])
("wayward" ["任性的"])
("we" ["我們"])
("weak" ["虛弱的"])
("weaken" ["削弱"])
("weakness" ["虛弱"])
("wealth" ["財富"])
("wealthy" ["富有的"])
("weapon" ["武器"])
("wear" ["穿帶"])
("wearily" ["疲勞地"])
("weariness" ["疲勞"])
("weary" ["疲勞的"])
("weasel" ["黃鼠狼"])
("weather" ["天氣"])
("weave" ["編織"])
("weaver" ["紡織者"])
("web" ["紡織品" "網"])
("wed" ["婚嫁"])
("wedding" ["婚禮"])
("wedge" ["楔形物"])
("wednesday" ["星期三"])
("wee" ["細小的"])
("week" ["星期"])
("weekday" ["平常日"])
("weekend" ["周末"])
("weep" ["哭泣"])
("weigh" ["稱重"])
("weight" ["重量"])
("weird" ["怪異的"])
("welcome" ["歡迎"])
("welfare" ["福利"])
("well" ["很好"])
("wellknown" ["著名的"])
("were" ["是"])
("west" ["西方"])
("western" ["西方的"])
("westward" ["向西的"])
("wet" ["溼的"])
("whale" ["鯨魚"])
("wharf" ["碼頭"])
("whatever" ["無論如何"])
("wheat" ["小麥"])
("wheel" ["輪子"])
("when" ["何時"])
("whence" ["何處" "何以"])
("whenever" ["無論何時"])
("where" ["何處"])
("whereas" ["然而"])
("whereby" ["如何"])
("wherefore" ["何故"])
("wherein" ["在其中"])
("whereupon" ["於是"])
("wherever" ["無論何處"])
("whether" ["是否"])
("which" ["哪一個"])
("whichever" ["無論何者"])
("while" ["當﹍時"])
("whim" ["突然的念頭"])
("whimper" ["嗚咽"])
("whine" ["發牢騷"])
("whip" ["鞭笞"])
("whir" ["呼呼聲"])
("whirl" ["旋轉"])
("whirlwind" ["旋風"])
("whisk" ["拂掃"])
("whisker" ["觸鬚"])
("whisky" ["威士忌酒"])
("whisper" ["耳語"])
("whistle" ["吹口哨"])
("whit" ["一點"])
("white" ["白色"])
("whiten" ["漂白"])
("whiteness" ["白色"])
("whither" ["向何處"])
("who" ["何人"])
("whoever" ["無論何人"])
("whole" ["全部的"])
("wholesale" ["批發"])
("wholesome" ["有益的"])
("wholly" ["完全地"])
("whom" ["誰"])
("whoop" ["呼叫聲"])
("whose" ["誰的"])
("why" ["為什麼"])
("wicked" ["邪惡的"])
("wide" ["寬闊"])
("widely" ["廣泛地"])
("widen" ["加寬"])
("widespread" ["普及的"])
("widow" ["寡婦"])
("width" ["寬度"])
("wife" ["妻子"])
("wig" ["假髮"])
("wigwam" ["帳篷"])
("wild" ["野生的"])
("wildcat" ["野貓"])
("wilderness" ["荒野"])
("will" ["意志" "遺囑" "會"])
("willful" ["情願的"])
("willing" ["情願的"])
("willingness" ["意願"])
("willow" ["柳樹"])
("wilt" ["枯萎"])
("win" ["獲勝"])
("wince" ["退避"])
("wind" ["風" "彎曲" "上絃"])
("winding" ["迴旋"])
("windmill" ["風車"])
("window" ["窗子"])
("windy" ["有風的"])
("wine" ["水果酒"])
("wink" ["眨眼睛"])
("winner" ["勝利者"])
("winning" ["勝利的"])
("winter" ["冬天"])
("wintry" ["寒冬的"])
("wipe" ["擦掉"])
("wire" ["電線"])
("wireless" ["無線電的"])
("wiry" ["金屬線的"])
("wise" ["聰明的"])
("wish" ["願望"])
("wishful" ["渴望的"])
("wit" ["智能"])
("witch" ["巫婆"])
("witchcraft" ["巫術"])
("with" ["和"])
("withal" ["又" "並且"])
("withdraw" ["撤回"])
("wither" ["枯萎"])
("withhold" ["扣留"])
("within" ["在﹍之內"])
("without" ["沒有"])
("withstand" ["對抗"])
("witness" ["證人"])
("witty" ["機智的"])
("wizard" ["男巫"])
("woe" ["悲痛"])
("woeful" ["悲痛的"])
("wolf" ["狼"])
("woman" ["女人"])
("wonder" ["奇蹟"])
("wonderful" ["奇妙的"])
("wondrous" ["驚人的"])
("wont" ["習慣的"])
("woo" ["求愛"])
("wood" ["木材"])
("wooded" ["多樹木的"])
("wooden" ["木製的"])
("woodland" ["林地"])
("woodman" ["樵夫"])
("woodpecker" ["啄木鳥"])
("wool" ["羊毛"])
("woolen" ["羊毛的"])
("word" ["文字"])
("work" ["工作"])
("worker" ["工人"])
("working" ["工作的"])
("workmanship" ["手藝"])
("workshop" ["工作室"])
("world" ["世界"])
("worldly" ["世俗的"])
("worm" ["蟲"])
("worry" ["使煩惱"])
("worse" ["更壞的"])
("worship" ["崇拜"])
("worshipper" ["崇拜者"])
("worst" ["最壞的"])
("worth" ["值得"])
("worthless" ["無用的"])
("worthy" ["值得的"])
("wound" ["傷"])
("wrap" ["包"])
("wrath" ["憤怒"])
("wreath" ["花圈"])
("wreathe" ["成圈"])
("wreck" ["遇難船"])
("wrench" ["螺旋鉗"])
("wrest" ["扭"])
("wrestle" ["摔角"])
("wrestling" ["摔角"])
("wriggle" ["蠕動前進"])
("wrinkle" ["皺紋"])
("wrist" ["手腕"])
("writ" ["令狀"])
("write" ["寫"])
("writer" ["作家"])
("writing" ["著述"])
("wrong" ["錯"])
("yacht" ["遊艇"])
("yard" ["庭院" "碼"])
("yarn" ["毛線"])
("yawn" ["哈欠"])
("yea" ["是的"])
("year" ["年"])
("yearly" ["每年的"])
("yeast" ["酵母"])
("yell" ["叫喊"])
("yellow" ["黃色"])
("yes" ["是"])
("yesterday" ["昨天"])
("yet" ["迄今"])
("yield" ["產生"])
("yoke" ["軛"])
("yonder" ["那邊"])
("you" ["你" "你們"])
("young" ["年輕的"])
("youngster" ["少年"])
("your" ["你的"])
("yourself" ["你自己"])
("youth" ["青年"])
("youthful" ["年青的"])
("zeal" ["熱心"])
("zealous" ["熱心的"])
("zero" ["零"])
("zest" ["熱心"])
("zinc" ["鋅"])
("zone" ["地帶"])
("zoo" ["動物園"])
("zoological" ["動物學的"])
("zoology" ["動物學"])
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:
