;; VR4300 pipeline description.
;;   Copyright (C) 2004, 2005, 2007 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.

(define_insn_reservation "r4300_load" 2
  (and (eq_attr "cpu" "r4300")
       (eq_attr "type" "load,fpload,fpidxload,xfer"))
  "alu")

(define_insn_reservation "r4300_imul_si" 5
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "SI")))
  "imuldiv*5")

(define_insn_reservation "r4300_imul_di" 8
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "imul,imul3,imadd")
	    (eq_attr "mode" "DI")))
  "imuldiv*8")

(define_insn_reservation "r4300_idiv_si" 37
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "imuldiv*37")

(define_insn_reservation "r4300_idiv_di" 69
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "imuldiv*69")

(define_insn_reservation "r4300_fmove" 1
  (and (eq_attr "cpu" "r4300")
       (eq_attr "type" "fcmp,fabs,fneg,fmove"))
  "imuldiv")

(define_insn_reservation "r4300_fadd" 3
  (and (eq_attr "cpu" "r4300")
       (eq_attr "type" "fadd"))
  "imuldiv*3")

(define_insn_reservation "r4300_fmul_single" 5
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "imuldiv*5")

(define_insn_reservation "r4300_fmul_double" 8
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "imuldiv*8")

(define_insn_reservation "r4300_fdiv_single" 29
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "imuldiv*29")

(define_insn_reservation "r4300_fdiv_double" 58
  (and (eq_attr "cpu" "r4300")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "imuldiv*58")
