/* Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 *
 * RSA 3072 with 3 exponent public key and verification.
 * Private key in rsa3072-3.pem.
 */

/* First generate a key:
 * # openssl genrsa -3 -out key.pem 3072
 * # openssl rsa -in key.pem -pubout > key.pub
 * Then dump the key: sudo emerge vboot_reference
 * # /usr/bin/dumpRSAPublicKey -pub key.pub | xxd -i
 */
const uint8_t rsa_data[] = {
	0x60, 0x00, 0x00, 0x00, 0xdd, 0x54, 0xe6, 0xe2, 0x8b, 0xdc, 0xea, 0xd2,
	0x58, 0x10, 0x72, 0xf1, 0x39, 0x2d, 0x10, 0x6e, 0x37, 0x4b, 0x19, 0x0d,
	0x0a, 0x02, 0x80, 0xdc, 0xb9, 0xee, 0xb4, 0x6b, 0xb6, 0x19, 0x73, 0x22,
	0x43, 0x09, 0x22, 0x7e, 0xf1, 0x48, 0xdd, 0xf2, 0x66, 0x12, 0x90, 0xb9,
	0x58, 0x54, 0x4b, 0xc4, 0xce, 0xf0, 0xb3, 0xbf, 0xad, 0x86, 0x1a, 0x6a,
	0x23, 0x66, 0x08, 0x10, 0x83, 0xda, 0xa3, 0xec, 0x8e, 0x36, 0x2d, 0xb2,
	0x91, 0x2c, 0xbd, 0x11, 0x2f, 0xa8, 0xdc, 0x8f, 0x52, 0x7a, 0x23, 0x58,
	0xad, 0x36, 0x9b, 0xde, 0xd6, 0x0d, 0x21, 0x1b, 0x5d, 0x7b, 0x1d, 0x51,
	0x6d, 0x7e, 0xa1, 0xca, 0x13, 0x0a, 0x11, 0x29, 0x63, 0xaa, 0x6e, 0x64,
	0x7a, 0x15, 0xa3, 0xf6, 0xed, 0xfd, 0xce, 0x5d, 0x17, 0xfb, 0x16, 0x38,
	0x55, 0x0b, 0xed, 0x6b, 0x12, 0xf9, 0xcf, 0x8b, 0xa7, 0xeb, 0x92, 0xd0,
	0x5e, 0x91, 0x91, 0x4e, 0x6e, 0x41, 0xa2, 0x88, 0x51, 0xf9, 0xf9, 0x0b,
	0x99, 0x72, 0x2e, 0xab, 0x50, 0xbb, 0xc6, 0xc0, 0x64, 0x88, 0x26, 0x7f,
	0xc1, 0x91, 0x8d, 0xe8, 0xea, 0x5a, 0x15, 0x1c, 0x0a, 0xac, 0xa3, 0x8a,
	0x8f, 0x42, 0x68, 0xc6, 0x7d, 0x3a, 0x53, 0xf6, 0x6a, 0x65, 0x7a, 0xb4,
	0x51, 0xf0, 0xce, 0xe3, 0x49, 0xd8, 0x38, 0x1a, 0x30, 0x1a, 0xd3, 0xa2,
	0x98, 0xf8, 0x53, 0x6d, 0xa2, 0x35, 0x22, 0x92, 0xd8, 0x46, 0x7b, 0x9d,
	0xc7, 0x25, 0xb6, 0xc6, 0x28, 0x12, 0x0d, 0x0d, 0x91, 0xbf, 0x9b, 0x58,
	0x73, 0xc1, 0x78, 0x39, 0xed, 0x16, 0x61, 0x90, 0x25, 0x14, 0xba, 0x9b,
	0x17, 0x4f, 0xaa, 0xf9, 0x5c, 0xfd, 0xc7, 0x18, 0xf3, 0x1d, 0xd7, 0xaa,
	0xea, 0x11, 0x18, 0xbb, 0x24, 0x3d, 0xf0, 0x57, 0x33, 0x9c, 0x23, 0x04,
	0x33, 0x81, 0xa0, 0x10, 0xc3, 0x6d, 0x12, 0xb6, 0xd0, 0xdc, 0xad, 0xd2,
	0x9c, 0x76, 0x01, 0x7a, 0x70, 0x04, 0x72, 0x29, 0xeb, 0x82, 0x60, 0x1b,
	0xea, 0x19, 0xe6, 0xdc, 0xeb, 0xec, 0xaf, 0xad, 0xce, 0xfa, 0x5b, 0xbc,
	0x81, 0x0c, 0x82, 0x19, 0xde, 0xbd, 0x65, 0xe6, 0x69, 0x1b, 0x8e, 0x38,
	0x93, 0xf3, 0x3f, 0x9f, 0x75, 0x69, 0xa9, 0x0f, 0xb7, 0x94, 0xca, 0xfd,
	0x30, 0xa9, 0x09, 0x59, 0x77, 0xd3, 0xef, 0x8d, 0x0a, 0x11, 0xfa, 0x07,
	0xd8, 0xe5, 0x35, 0x59, 0x23, 0xb5, 0x20, 0x28, 0xa7, 0x9f, 0x6d, 0xb6,
	0x18, 0x72, 0x51, 0x06, 0x02, 0xe7, 0x2b, 0xfb, 0xa5, 0x96, 0xf8, 0x8b,
	0x2d, 0xb4, 0x01, 0xd8, 0x66, 0xd0, 0x12, 0xa3, 0xd3, 0x67, 0x94, 0x37,
	0x21, 0xb4, 0xfc, 0xc5, 0x73, 0xd7, 0x77, 0x39, 0x75, 0xdd, 0xb2, 0x57,
	0x62, 0x83, 0xcd, 0x2d, 0xca, 0x8a, 0xf9, 0xd8, 0xc3, 0x00, 0xc2, 0x64,
	0x45, 0xaa, 0xaa, 0xe7, 0xf8, 0xdb, 0x9c, 0xd4, 0x33, 0x77, 0x5b, 0x55,
	0x57, 0x12, 0xcd, 0x33, 0xbe, 0x70, 0xa5, 0x78, 0x26, 0x3c, 0x56, 0xee,
	0xe3, 0xac, 0x23, 0xfe, 0x54, 0x98, 0xd6, 0x2e, 0xfe, 0xdd, 0xc4, 0x5a,
	0x23, 0xca, 0x5a, 0x22, 0xec, 0x8e, 0x36, 0x3b, 0xfb, 0x9f, 0x97, 0x7d,
	0x75, 0x37, 0xf7, 0x59, 0xef, 0x1d, 0x96, 0xad, 0x2b, 0x82, 0x19, 0x67,
	0x46, 0x7f, 0x92, 0x1f, 0xcb, 0xf0, 0xf7, 0x31, 0x72, 0x34, 0x4d, 0xdd,
	0x8b, 0x5b, 0x90, 0xe2, 0xeb, 0xdd, 0x04, 0x00, 0xde, 0x28, 0x15, 0x03,
	0x6b, 0x4e, 0x4e, 0x6b, 0x03, 0xd0, 0x54, 0x81, 0xea, 0xe4, 0x26, 0xbb,
	0x4c, 0x6f, 0x65, 0x70, 0x12, 0x6d, 0x84, 0x1d, 0x71, 0xfe, 0xc1, 0x63,
	0x1c, 0x33, 0x43, 0xcd, 0x8a, 0x92, 0xa6, 0x2d, 0xa3, 0xbd, 0xef, 0x93,
	0x39, 0x2f, 0x9b, 0xa9, 0x5c, 0x0d, 0xb9, 0x61, 0x23, 0xcf, 0x12, 0x1f,
	0x98, 0x85, 0x19, 0xa7, 0x08, 0xfc, 0xee, 0x8e, 0x79, 0x25, 0x0b, 0xed,
	0xb3, 0x72, 0xf4, 0x27, 0x9f, 0xee, 0x7b, 0x22, 0xd0, 0x6e, 0xdf, 0x4b,
	0x05, 0xef, 0xbd, 0x13, 0xb6, 0x22, 0xeb, 0x9e, 0xc5, 0x7d, 0xb6, 0x1c,
	0xfd, 0xf8, 0xc6, 0x82, 0x89, 0xd2, 0xc4, 0x01, 0xac, 0xec, 0xd5, 0xbd,
	0x2d, 0xbb, 0x09, 0x17, 0x0f, 0xd6, 0xc1, 0xb9, 0x07, 0xf0, 0xce, 0x23,
	0x81, 0x0c, 0xa9, 0x60, 0x58, 0x17, 0xbf, 0xf5, 0x14, 0xd0, 0x68, 0x33,
	0xf6, 0xc6, 0xae, 0xc3, 0xc3, 0x1f, 0x01, 0xd6, 0xae, 0xc8, 0x94, 0xba,
	0x35, 0x47, 0xa9, 0x77, 0x2b, 0x68, 0xd2, 0x75, 0x19, 0x75, 0x40, 0xce,
	0x11, 0x93, 0xaa, 0xb9, 0x09, 0x37, 0x91, 0xca, 0x83, 0x3d, 0x7a, 0xb1,
	0x03, 0x57, 0x34, 0x06, 0x37, 0x86, 0xf9, 0x64, 0xe4, 0xcf, 0x49, 0x0b,
	0x20, 0x21, 0xda, 0x0a, 0x25, 0xd4, 0x17, 0x21, 0x73, 0x39, 0xf9, 0x2f,
	0xeb, 0x81, 0x6f, 0x90, 0xea, 0x83, 0xfc, 0xc7, 0xe9, 0x44, 0xd1, 0xd2,
	0x8b, 0xc5, 0xf3, 0x1f, 0x35, 0x1c, 0xc5, 0xa3, 0x75, 0x36, 0xb7, 0x84,
	0xed, 0x67, 0xa0, 0xbd, 0xaf, 0x6b, 0x00, 0x15, 0x5a, 0x7c, 0x5c, 0xc7,
	0x95, 0x22, 0x76, 0xd9, 0x9c, 0x1f, 0xf0, 0xb2, 0x6e, 0x5b, 0xcb, 0x32,
	0x88, 0xa4, 0xc6, 0x7f, 0xfa, 0x2e, 0xc6, 0x40, 0x40, 0xa3, 0xe2, 0x57,
	0xb7, 0x08, 0xe0, 0xe9, 0x93, 0x10, 0x95, 0x70, 0x2d, 0x90, 0x0c, 0xeb,
	0x44, 0x50, 0xbc, 0xd9, 0xc7, 0xd5, 0x2b, 0x74, 0xac, 0x6e, 0x7f, 0xcf,
	0xfa, 0x8c, 0xf6, 0x76, 0x77, 0x79, 0xf8, 0xf4, 0x11, 0x8e, 0x5a, 0xe4,
	0x2c, 0xa2, 0x84, 0x56, 0xdb, 0x39, 0x54, 0x82, 0x8e, 0x85, 0x31, 0xc0,
	0x51, 0xf7, 0x6c, 0x2c, 0x5f, 0xbc, 0x63, 0x5c, 0xf3, 0x68, 0x4e, 0xa4,
	0x52, 0xc9, 0xe8, 0x06, 0xff, 0x94, 0xd3, 0xa1,
};

const struct rsa_public_key *rsa_key = (struct rsa_public_key *)rsa_data;
BUILD_ASSERT(sizeof(*rsa_key) == sizeof(rsa_data));

/* SHA-256 sum to verify:
 * # sha256sum README.md | sed -e 's/\(..\)/0x\1, /mg'
 */
const uint8_t hash[] = { 0xc7, 0xc3, 0xd0, 0xa3, 0x7e, 0xbd, 0x50, 0xe8,
			 0x3c, 0xb3, 0x5b, 0xed, 0x02, 0xf9, 0x8f, 0x97,
			 0xf8, 0xb5, 0x23, 0x43, 0x74, 0xda, 0x0a, 0x24,
			 0xdb, 0x04, 0xe4, 0x1e, 0xbd, 0x43, 0x02, 0xdc };

/* Incorrect hash to test the negative case */
const uint8_t hash_wrong[] = { 0x61, 0x1b, 0xd2, 0x44, 0xc7, 0x18, 0xa7, 0x2d,
			       0x0f, 0x2d, 0x3d, 0x0f, 0xe3, 0xb3, 0xc5, 0xe4,
			       0x12, 0xc2, 0x7b, 0x1e, 0x05, 0x2c, 0x6f, 0xad,
			       0xc4, 0xac, 0x71, 0x55, 0xe8, 0x80, 0x5c, 0x38 };

/* Generate signature using openssl:
 * openssl dgst -sha256 -sign test/rsa3072-3.pem README.md | xxd -i
 */
const uint8_t sig[] = {
	0xb3, 0xac, 0xcb, 0x5c, 0xbc, 0x82, 0x74, 0x14, 0xce, 0x7d, 0xbd, 0x3b,
	0xc6, 0x6e, 0x2d, 0x3e, 0xfd, 0xdb, 0x76, 0xb3, 0xfe, 0xed, 0x29, 0xd6,
	0xb8, 0x20, 0x8a, 0x79, 0xf8, 0xe4, 0x1b, 0xc1, 0x99, 0x21, 0x77, 0xb0,
	0xa7, 0x49, 0xfc, 0x31, 0x70, 0xe2, 0x5c, 0xc9, 0xc4, 0xc8, 0x5b, 0xbd,
	0xf9, 0xc9, 0x81, 0x43, 0x7e, 0x16, 0x23, 0xc7, 0xb3, 0x8f, 0x95, 0xca,
	0xb2, 0x56, 0x96, 0xfc, 0x53, 0xba, 0xf3, 0x77, 0x31, 0xde, 0x69, 0x9f,
	0x2e, 0xb1, 0xc0, 0xe1, 0xb9, 0x05, 0x7a, 0xf2, 0x92, 0x9c, 0xf2, 0x0b,
	0x54, 0xa1, 0x93, 0x58, 0x52, 0x2e, 0x9b, 0x02, 0x59, 0x05, 0x67, 0xc2,
	0x8c, 0x27, 0x1d, 0xc2, 0x70, 0x2f, 0x5c, 0x4f, 0xb2, 0xb4, 0x87, 0x71,
	0x75, 0x33, 0x2d, 0x96, 0x02, 0x81, 0x80, 0x13, 0xb1, 0xff, 0x8a, 0x73,
	0x1c, 0x66, 0x54, 0xec, 0x97, 0x08, 0x4f, 0x98, 0xec, 0x01, 0xa6, 0x93,
	0x59, 0xa9, 0x16, 0x28, 0x41, 0x60, 0x83, 0xb2, 0xe1, 0xe8, 0x42, 0xf7,
	0x92, 0x96, 0x5c, 0x91, 0x06, 0xf8, 0xde, 0x45, 0x67, 0x4e, 0xef, 0xde,
	0xb5, 0x87, 0x72, 0x02, 0x5e, 0x39, 0x7a, 0xa7, 0xf2, 0x22, 0xbc, 0x10,
	0x59, 0x13, 0xfb, 0x53, 0x98, 0x99, 0x2a, 0x51, 0xc5, 0x46, 0x7e, 0xdf,
	0x6f, 0xd8, 0xbd, 0xcd, 0x0e, 0xd7, 0x00, 0x2f, 0x76, 0x17, 0x8b, 0xce,
	0x05, 0x56, 0xc2, 0xe1, 0xcd, 0x37, 0xa1, 0x2f, 0xa6, 0xc4, 0xcd, 0xd5,
	0xaf, 0x10, 0x9b, 0x1f, 0x72, 0x28, 0x14, 0x3f, 0xa1, 0x9d, 0x08, 0x7f,
	0x3d, 0x0a, 0xac, 0x80, 0x7b, 0xe3, 0x31, 0x4f, 0x9c, 0x79, 0x7c, 0x4b,
	0xd7, 0x01, 0xcc, 0x9f, 0xbd, 0x9d, 0x52, 0x84, 0xd7, 0xea, 0xf8, 0xc8,
	0xf5, 0xf3, 0x0c, 0x83, 0x5c, 0x30, 0x0c, 0x50, 0x66, 0x5f, 0xee, 0x4d,
	0x23, 0x8a, 0x32, 0x07, 0x55, 0xb1, 0xfa, 0x5e, 0x89, 0x57, 0x18, 0x24,
	0xcc, 0x20, 0x30, 0x79, 0xf0, 0x4c, 0x09, 0xe2, 0x9a, 0x34, 0xc7, 0x07,
	0xf7, 0x29, 0x3a, 0xcf, 0x38, 0x18, 0x2c, 0x53, 0x2f, 0x33, 0xca, 0x95,
	0xfc, 0x3b, 0x23, 0x75, 0xbc, 0x15, 0xac, 0x1a, 0xbd, 0xf1, 0xa5, 0x6c,
	0x3e, 0x4b, 0xc3, 0x39, 0xb2, 0x1e, 0x18, 0xf1, 0xb9, 0x28, 0xcd, 0x13,
	0x05, 0x32, 0xd5, 0x46, 0x3e, 0x9b, 0x55, 0x9f, 0x13, 0xe3, 0x5d, 0x53,
	0x6a, 0xa8, 0x93, 0x33, 0xbb, 0x78, 0x1d, 0x3a, 0xeb, 0xbd, 0x3d, 0x2e,
	0xd1, 0xdc, 0x1c, 0xb6, 0x76, 0x6f, 0x29, 0x9f, 0x9f, 0x59, 0x23, 0x45,
	0xcc, 0x80, 0x23, 0xd7, 0x51, 0x06, 0xc8, 0x72, 0x94, 0x3a, 0xf8, 0x14,
	0x4d, 0x76, 0x2d, 0x59, 0x3c, 0xd7, 0x4e, 0x17, 0x52, 0xad, 0x1a, 0xe4,
	0xa9, 0xfb, 0x09, 0xc8, 0xb4, 0x28, 0x0b, 0x7d, 0xa8, 0x0a, 0x71, 0x81,
	/* Padding */
	0x00
};
