/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Early GPIOs in bootblock:
 * - LPC interface (for UART/BMC/POST)
 * - GPP_J2 (BMC ready input)
 */
static const struct pad_config early_gpio_table[] = {
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),	/* RCIN# */
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1),	/* LAD0 */
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1),	/* LAD1 */
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1),	/* LAD2 */
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1),	/* LAD3 */
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),	/* LFRAME# */
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),	/* SERIRQ */
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1),	/* CLKRUN# */
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1),	/* CLKOUT_LPC0 */
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),	/* CLKOUT_LPC1 */
	PAD_CFG_GPI_TRIG_OWN(GPP_J2, NONE, DEEP, OFF, ACPI),	/* GPIO */
};

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_A ------- */
	/* A0-A6, A8-A10 are configured in bootblock */
	PAD_CFG_NF(GPP_A7, NONE, DEEP, NF1),	/* PIRQA# */
	PAD_CFG_NF(GPP_A11, NONE, DEEP, NF1),	/* PME# */
	PAD_CFG_GPI_TRIG_OWN(GPP_A12, NONE, PLTRST, LEVEL, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1),	/* SUSWARN#/SUSPWRDNACK */
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),	/* SUS_STAT# */
	PAD_CFG_NF(GPP_A15, NONE, DEEP, NF1),	/* SUSACK# */
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),	/* CLKOUT_48 */
	PAD_CFG_GPI_TRIG_OWN(GPP_A17, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A18, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_A19 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_A20, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_NC(GPP_A21, NONE),	/* GPIO */
	PAD_NC(GPP_A22, NONE),	/* GPIO */
	PAD_NC(GPP_A23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_B0, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B1, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B5, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_NC(GPP_B6, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_B7, NONE, DEEP, NF1),	/* SRCCLKREQ2# */
	PAD_CFG_GPI_TRIG_OWN(GPP_B8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_B11 - RESERVED */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	/* SLP_S0# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* PLTRST# */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF1),	/* SPKR */
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B16, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B17, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B18, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B19, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_B20, 0, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B21, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B22, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_B23 - RESERVED */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_C ------- */
	/* GPP_C0 - RESERVED */
	/* GPP_C1 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_C2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_C3 - RESERVED */
	/* GPP_C4 - RESERVED */
	PAD_CFG_GPO(GPP_C5, 0, DEEP),	/* GPIO */
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_C8, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C9, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_C10, 1, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C12, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C13, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C14, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),	/* I2C0_SDA */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),	/* I2C0_SCL */
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),	/* I2C1_SDA */
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),	/* I2C1_SCL */
	/* GPP_C20 - RESERVED */
	PAD_CFG_GPO(GPP_C21, 1, DEEP),	/* GPIO */
	PAD_CFG_GPI_SMI(GPP_C22, NONE, DEEP, EDGE_SINGLE, INVERT),	/* GPIO */
	PAD_CFG_GPI_SCI(GPP_C23, NONE, DEEP, LEVEL, INVERT),	/* GPIO */

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_D0, NONE, PLTRST, LEVEL, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_D1, 0, PLTRST),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_D5, 0, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D12, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D13, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D14, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D16, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D17, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D19, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D20, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D21, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_G ------- */
	PAD_CFG_GPO(GPP_G0, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G1, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G2, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G3, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G4, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_G5, 1, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G7, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group AZA ------- */

	/* ------- GPIO Group VGPIO_0 ------- */

	/* ------- GPIO Group VGPIO_1 ------- */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, NONE, DEEP, NF1),	/* BATLOW# */
	PAD_CFG_NF(GPD1, NONE, DEEP, NF1),	/* ACPRESENT */
	PAD_CFG_NF(GPD2, NONE, DEEP, NF1),	/* LAN_WAKE# */
	PAD_CFG_NF(GPD3, NONE, DEEP, NF1),	/* PRWBTN# */
	PAD_CFG_NF(GPD4, NONE, DEEP, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, DEEP, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, DEEP, NF1),	/* SLP_A# */
	PAD_CFG_GPI_TRIG_OWN(GPD7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPD8, NONE, DEEP, NF1),	/* SUSCLK */
	PAD_CFG_GPI_TRIG_OWN(GPD9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPD10, NONE, DEEP, NF1),	/* SLP_S5# */
	PAD_CFG_GPI_TRIG_OWN(GPD11, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Community 3 ------- */

	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_K0, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K1, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K2, NONE, RSMRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K5, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K12, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K13, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K14, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K16, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K17, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_K18, NONE, DEEP, NF1),	/* NMI# */
	PAD_CFG_NF(GPP_K19, NONE, DEEP, NF1),	/* SMI# */
	PAD_CFG_GPI_TRIG_OWN(GPP_K20, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K21, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K22, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_NC(GPP_K23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE),	/* GPIO */
	PAD_NC(GPP_H1, NONE),	/* GPIO */
	PAD_NC(GPP_H2, NONE),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_H5 - RESERVED */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),	/* SRCCLKREQ12# */
	PAD_CFG_GPI_TRIG_OWN(GPP_H7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	/* GPP_H10 - RESERVED */
	/* GPP_H11 - RESERVED */
	PAD_CFG_GPO(GPP_H12, 1, PLTRST),	/* GPIO */
	/* GPP_H13 - RESERVED */
	/* GPP_H14 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_H15, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	/* GPP_H16 - RESERVED */
	/* GPP_H17 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_H18, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_H19, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_H20, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_H21, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_H22, 1, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H23, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, DEEP, NF1),	/* SATAXPCIE0 */
	PAD_CFG_NF(GPP_E1, NONE, DEEP, NF1),	/* SATAXPCIE1 */
	PAD_CFG_GPI_TRIG_OWN(GPP_E2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_NC(GPP_E5, NONE),	/* GPIO */
	PAD_CFG_GPI_NMI(GPP_E6, NONE, PLTRST, LEVEL, INVERT),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1),	/* SATALED# */
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1),	/* USB2_OC0# */
	PAD_CFG_GPI_TRIG_OWN(GPP_E10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E12, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_F0, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F1, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F5, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_F10, NONE, DEEP, NF1),	/* SATA_SCLOCK */
	PAD_CFG_NF(GPP_F11, NONE, DEEP, NF1),	/* SATA_SLOAD */
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF1),	/* SATA_SDATAOUT1 */
	PAD_CFG_NF(GPP_F13, NONE, DEEP, NF1),	/* SATA_SDATAOUT0 */
	PAD_CFG_GPI_TRIG_OWN(GPP_F14, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F15, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F16, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F17, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F18, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F19, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F20, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F21, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F22, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F23, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group SPI ------- */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group CPU ------- */

	/* ------- GPIO Group JTAG ------- */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_NF(GPP_I0, NONE, DEEP, NF1),	/* DDPB_HPD0 */
	PAD_CFG_NF(GPP_I1, NONE, DEEP, NF1),	/* DDPB_HPD1 */
	PAD_CFG_GPI_TRIG_OWN(GPP_I2, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPO(GPP_I5, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_I6, 1, DEEP),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I11, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I12, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I13, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I14, NONE, DEEP, OFF, ACPI),	/* GPIO */

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_J0, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_NF(GPP_J1, NONE, DEEP, NF2),	/* CPU_C10_GATE# */
	/* J2 configured in bootblock */
	PAD_CFG_GPI_TRIG_OWN(GPP_J3, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J4, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J5, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J6, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J7, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J8, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J9, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J10, NONE, DEEP, OFF, ACPI),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J11, NONE, DEEP, OFF, ACPI),	/* GPIO */
};

#endif /* CFG_GPIO_H */
