/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;

public class ReferenceExp
extends Expression {
    Object symbol;
    Declaration binding;
    static int counter;
    int id = ++counter;
    private static int DONT_DEREFERENCE;
    private static int PROCEDURE_NAME;
    public static int PREFER_BINDING2;

    public String string_name() {
        return this.symbol.toString();
    }

    public final String getName() {
        return this.symbol instanceof Symbol ? ((Symbol)this.symbol).getName() : this.symbol.toString();
    }

    public final Object getSymbol() {
        return this.symbol;
    }

    public final Declaration getBinding() {
        return this.binding;
    }

    public final void setBinding(Declaration declaration) {
        this.binding = declaration;
    }

    public final boolean getDontDereference() {
        return (this.flags & DONT_DEREFERENCE) != 0;
    }

    public final void setDontDereference(boolean bl) {
        this.setFlag(bl, DONT_DEREFERENCE);
    }

    public final boolean isProcedureName() {
        return (this.flags & PROCEDURE_NAME) != 0;
    }

    public final void setProcedureName(boolean bl) {
        this.setFlag(bl, PROCEDURE_NAME);
    }

    public ReferenceExp(Object object2) {
        this.symbol = object2;
    }

    public ReferenceExp(Object object2, Declaration declaration) {
        this.symbol = object2;
        this.binding = declaration;
    }

    public ReferenceExp(Declaration declaration) {
        this.binding = declaration;
        this.symbol = declaration.getName();
    }

    public Object eval(Environment environment) {
        Object object2;
        if (this.binding != null) {
            if (this.binding.field != null && this.binding.field.getStaticFlag()) {
                try {
                    object2 = this.binding.field.getReflectField().get(null);
                    if (!(object2 instanceof Symbol)) {
                        return object2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(this.binding.context instanceof ModuleExp) || this.binding.isPrivate()) {
                throw new Error("internal error: ReferenceExp.eval on lexical binding");
            }
        }
        if (this.getDontDereference()) {
            return this.symbol instanceof Symbol ? this.symbol : environment.getSymbol(this.symbol.toString());
        }
        if (this.getFlag(PREFER_BINDING2) || this.symbol instanceof Symbol) {
            object2 = this.symbol instanceof Symbol ? (Symbol)this.symbol : environment.getSymbol(this.symbol.toString());
            return this.isProcedureName() ? Interpreter.getSymbolProcedure((Symbol)object2) : Interpreter.getSymbolValue((Symbol)object2);
        }
        return environment.getChecked(this.symbol.toString());
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        Type type = this.getType();
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = Declaration.followAliases(this.binding);
        declaration.load(compilation);
        if (declaration.isIndirectBinding() && !this.getDontDereference()) {
            if (!this.isProcedureName()) {
                codeAttr.emitInvokeStatic(Compilation.getSymbolValueMethod);
            } else {
                codeAttr.emitInvokeStatic(Compilation.getSymbolProcedureMethod);
                type = Compilation.typeProcedure;
            }
        } else if (declaration.isFluid() && declaration.field == null) {
            codeAttr.emitGetField(FluidLetExp.valueField);
        }
        if (target instanceof SeriesTarget && declaration.getFlag(262144)) {
            ((SeriesTarget)target).compileFromStackSimple(compilation, type);
        } else {
            target.compileFromStack(compilation, type);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkReferenceExp(this);
    }

    public void print(OutPort outPort) {
        outPort.print("(Ref/");
        outPort.print(this.id);
        if (this.symbol != null && (this.binding == null || this.symbol.toString() != this.binding.getName())) {
            outPort.print('/');
            outPort.print(this.symbol);
        }
        if (this.binding != null) {
            outPort.print('/');
            outPort.print(this.binding);
        }
        outPort.print(")");
    }

    public Type getType() {
        return this.binding == null || this.binding.isFluid() ? Type.pointer_type : (this.getDontDereference() ? Compilation.typeLocation : this.binding.getType());
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }

    static {
        DONT_DEREFERENCE = 1;
        PROCEDURE_NAME = 2;
        PREFER_BINDING2 = 4;
    }
}

