/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

public class Access {
    public static final short PUBLIC = 1;
    public static final short PRIVATE = 2;
    public static final short PROTECTED = 4;
    public static final short STATIC = 8;
    public static final short FINAL = 16;
    public static final short SUPER = 32;
    public static final short SYNCHRONIZED = 32;
    public static final short VOLATILE = 64;
    public static final short BRIDGE = 64;
    public static final short TRANSIENT = 128;
    public static final short VARARGS = 128;
    public static final short NATIVE = 256;
    public static final short INTERFACE = 512;
    public static final short ABSTRACT = 1024;
    public static final short STRICT = 2048;
    public static final short SYNTHETIC = 4096;
    public static final short ANNOTATION = 8192;
    public static final short ENUM = 16384;
    public static final short CLASS_MODIFIERS = 30257;
    public static final short FIELD_MODIFIERS = 20703;
    public static final short METHOD_MODIFIERS = 7679;

    public static String toString(int n) {
        return Access.toString(n, '\u0000');
    }

    public static String toString(int n, char c) {
        int n2 = c == 'C' ? 30257 : (c == 'F' ? 20703 : (c == 'M' ? 7679 : Short.MAX_VALUE));
        short s = (short)(n & ~n2);
        StringBuffer stringBuffer = new StringBuffer();
        if (((n &= n2) & 1) != 0) {
            stringBuffer.append(" public");
        }
        if ((n & 2) != 0) {
            stringBuffer.append(" private");
        }
        if ((n & 4) != 0) {
            stringBuffer.append(" protected");
        }
        if ((n & 8) != 0) {
            stringBuffer.append(" static");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append(" final");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(c == 'C' ? " super" : " synchronized");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append(c == 'M' ? " bridge" : " volatile");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append(c == 'M' ? " varargs" : " transient");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append(" native");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append(" interface");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append(" abstract");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append(" strict");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append(" enum");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append(" synthetic");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append(" annotation");
        }
        if (s != 0) {
            stringBuffer.append(" unknown-flags:0x");
            stringBuffer.append(Integer.toHexString(s));
        }
        return stringBuffer.toString();
    }
}

