/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Location;
import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.FieldLocation;
import gnu.mapping.Environment;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;

public class ModuleInfo {
    static final String INFO_KEY = new String("(module-info)");
    String className;
    Object instance;
    ModuleExp exp;

    public synchronized ModuleExp getModuleExp() {
        ModuleExp moduleExp = this.exp;
        if (moduleExp == null) {
            ClassType classType = this.instance == null ? ClassType.make(this.className) : (ClassType)ClassType.make(this.instance.getClass());
            moduleExp = new ModuleExp();
            moduleExp.type = classType;
            moduleExp.setName(classType.getName());
            moduleExp.flags |= 0x10000;
            moduleExp.info = this;
            this.exp = moduleExp;
        }
        return moduleExp;
    }

    public synchronized ModuleExp setupModuleExp() {
        Object object2;
        ModuleExp moduleExp = this.getModuleExp();
        if ((moduleExp.flags & 0x10000) == 0) {
            return moduleExp;
        }
        moduleExp.setFlag(false, 65536);
        ClassType classType = ClassType.make(this.className);
        Object object3 = null;
        Language language = Language.getDefaultLanguage();
        Class clazz = classType.getReflectClass();
        for (object2 = classType.getFields(); object2 != null; object2 = ((Field)object2).getNext()) {
            int n = ((Field)object2).getFlags();
            if ((n & 1) == 0) continue;
            try {
                if ((n & 8) == 0 && object3 == null) {
                    object3 = this.getInstance();
                }
                Object object4 = clazz.getField(((Location)object2).getName()).get(object3);
                Declaration declaration = language.declFromField(moduleExp, object4, (Field)object2);
                if ((n & 0x10) != 0 && (!(object4 instanceof gnu.mapping.Location) || object4 instanceof FieldLocation)) {
                    declaration.noteValue(new QuoteExp(object4));
                    continue;
                }
                declaration.noteValue(null);
                continue;
            }
            catch (Exception exception) {
                throw new WrappedException(exception);
            }
        }
        for (object2 = moduleExp.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            ModuleInfo.makeDeclInModule2(moduleExp, (Declaration)object2);
        }
        return moduleExp;
    }

    public static ModuleInfo findFromInstance(Object object2) {
        ModuleInfo moduleInfo = ModuleInfo.find(object2.getClass().getName());
        moduleInfo.instance = object2;
        return moduleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleInfo find(String string) {
        Environment environment = Environment.getCurrent();
        Symbol symbol = Namespace.EmptyNamespace.getSymbol(string);
        Environment environment2 = environment;
        synchronized (environment2) {
            NamedLocation namedLocation = environment.getLocation(symbol, INFO_KEY, true);
            ModuleInfo moduleInfo = (ModuleInfo)namedLocation.get(null);
            if (moduleInfo == null) {
                moduleInfo = new ModuleInfo();
                moduleInfo.className = string;
                namedLocation.set(moduleInfo);
            }
            return moduleInfo;
        }
    }

    public static void register(Object object2) {
        String string = object2.getClass().getName();
        ModuleInfo moduleInfo = ModuleInfo.find(string);
        moduleInfo.instance = object2;
    }

    public synchronized Object getInstance() {
        Object object2 = this.instance;
        if (object2 == null) {
            Class<?> clazz;
            String string = this.className;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WrappedException("cannot find module " + string, classNotFoundException);
            }
            try {
                try {
                    object2 = clazz.getDeclaredField("$instance").get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    object2 = clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                throw new WrappedException("exception while initializing module " + string, throwable);
            }
            this.instance = object2;
        }
        return object2;
    }

    public Object getRunInstance() {
        Object object2 = this.getInstance();
        if (object2 instanceof Runnable) {
            ((Runnable)object2).run();
        }
        return object2;
    }

    static void makeDeclInModule2(ModuleExp moduleExp, Declaration declaration) {
        Object object2 = declaration.getConstantValue();
        if (object2 instanceof FieldLocation) {
            FieldLocation fieldLocation = (FieldLocation)object2;
            Declaration declaration2 = fieldLocation.getDeclaration();
            ReferenceExp referenceExp = new ReferenceExp(declaration2);
            declaration.setAlias(true);
            if (fieldLocation.isIndirectLocation()) {
                referenceExp.setDontDereference(true);
            }
            declaration.setValue(referenceExp);
            if (declaration2.isProcedureDecl()) {
                declaration.setProcedureDecl(true);
            }
            if (declaration2.getFlag(32768)) {
                declaration.setSyntax();
            }
            if (!declaration.getFlag(2048)) {
                ClassType classType = fieldLocation.getDeclaringClass();
                String string = classType.getName();
                for (Declaration declaration3 = moduleExp.firstDecl(); declaration3 != null; declaration3 = declaration3.nextDecl()) {
                    if (!string.equals(declaration3.getType().getName()) || !declaration3.getFlag(0x40000000)) continue;
                    referenceExp.setContextDecl(declaration3);
                    break;
                }
            }
        }
    }
}

