/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.Target;
import gnu.mapping.Procedure2;

public class IsEq
extends Procedure2
implements Inlineable {
    Language language;

    public IsEq(Language language, String string) {
        this.language = language;
        this.setName(string);
    }

    public boolean apply(Object object2, Object object3) {
        return object2 == object3;
    }

    public Object apply2(Object object2, Object object3) {
        return this.language.booleanObject(object2 == object3);
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        IsEq.compile(applyExp.getArgs(), compilation, target, this.language);
    }

    public static void compile(Expression[] expressionArray, Compilation compilation, Target target, Language language) {
        CodeAttr codeAttr = compilation.getCode();
        expressionArray[0].compile(compilation, Target.pushObject);
        expressionArray[1].compile(compilation, Target.pushObject);
        if (target instanceof ConditionalTarget) {
            ConditionalTarget conditionalTarget = (ConditionalTarget)target;
            if (conditionalTarget.trueBranchComesFirst) {
                codeAttr.emitGotoIfNE(conditionalTarget.ifFalse);
            } else {
                codeAttr.emitGotoIfEq(conditionalTarget.ifTrue);
            }
            conditionalTarget.emitGotoFirstBranch(codeAttr);
        } else {
            Type type;
            codeAttr.emitIfEq();
            if (target.getType() instanceof ClassType) {
                Object object2 = language.booleanObject(true);
                Object object3 = language.booleanObject(false);
                compilation.compileConstant(object2, Target.pushObject);
                codeAttr.emitElse();
                compilation.compileConstant(object3, Target.pushObject);
                type = object2 instanceof Boolean && object3 instanceof Boolean ? Compilation.scmBooleanType : Type.pointer_type;
            } else {
                codeAttr.emitPushInt(1);
                codeAttr.emitElse();
                codeAttr.emitPushInt(0);
                type = language.getTypeFor(Boolean.TYPE);
            }
            codeAttr.emitFi();
            target.compileFromStack(compilation, type);
        }
    }

    public Type getReturnType(Expression[] expressionArray) {
        return this.language.getTypeFor(Boolean.TYPE);
    }
}

