/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.HashNode;

public class GeneralHashTable {
    protected HashNode[] table;
    int log2Size = 4;
    private int mask;
    protected int num_bindings;

    public GeneralHashTable() {
        this(64);
    }

    public GeneralHashTable(int n) {
        while (n > 1 << this.log2Size) {
            ++this.log2Size;
        }
        n = 1 << this.log2Size;
        this.table = new HashNode[n];
        this.mask = n - 1;
    }

    protected HashNode makeEntry(Object object2, int n, Object object3) {
        HashNode hashNode = new HashNode();
        hashNode.key = object2;
        hashNode.hash = n;
        hashNode.value = object3;
        return hashNode;
    }

    public int hash(Object object2) {
        return object2 == null ? 0 : object2.hashCode();
    }

    public int hash(HashNode hashNode) {
        return hashNode.hash;
    }

    public boolean matches(Object object2, int n, HashNode hashNode) {
        return hashNode.hash == n && this.matches(hashNode.getKey(), object2);
    }

    public boolean matches(Object object2, Object object3) {
        return object2 == object3 || object2 != null && object2.equals(object3);
    }

    public Object get(Object object2, Object object3) {
        int n = this.hash(object2);
        int n2 = n & this.mask;
        HashNode hashNode = this.table[n2];
        while (hashNode != null) {
            if (this.matches(object2, n, hashNode)) {
                return hashNode.getValue();
            }
            hashNode = hashNode.next;
        }
        return object3;
    }

    public HashNode getNode(Object object2) {
        int n = this.hash(object2);
        int n2 = n & this.mask;
        HashNode hashNode = this.table[n2];
        while (hashNode != null) {
            if (this.matches(object2, n, hashNode)) {
                return hashNode;
            }
            hashNode = hashNode.next;
        }
        return null;
    }

    public Object put(Object object2, Object object3) {
        return this.put(object2, this.hash(object2), object3);
    }

    public Object put(Object object2, int n, Object object3) {
        HashNode hashNode;
        int n2 = n & this.mask;
        HashNode hashNode2 = hashNode = this.table[n2];
        while (true) {
            if (hashNode2 == null) {
                if (++this.num_bindings >= this.table.length) {
                    this.rehash();
                }
                hashNode2 = this.makeEntry(object2, n, object3);
                hashNode2.next = hashNode;
                this.table[n2] = hashNode2;
                return null;
            }
            if (this.matches(object2, n, hashNode2)) {
                return hashNode2.setValue(object3);
            }
            hashNode2 = hashNode2.next;
        }
    }

    public Object remove(Object object2) {
        int n = this.hash(object2);
        int n2 = n & this.mask;
        HashNode hashNode = null;
        HashNode hashNode2 = this.table[n2];
        while (hashNode2 != null) {
            HashNode hashNode3 = hashNode2.next;
            if (this.matches(object2, n, hashNode2)) {
                if (hashNode == null) {
                    this.table[n2] = hashNode3;
                } else {
                    hashNode.next = hashNode2;
                }
                --this.num_bindings;
                return hashNode2.getValue();
            }
            hashNode = hashNode2;
            hashNode2 = hashNode3;
        }
        return null;
    }

    void rehash() {
        HashNode[] hashNodeArray = this.table;
        int n = hashNodeArray.length;
        int n2 = 2 * n;
        HashNode[] hashNodeArray2 = new HashNode[n2];
        int n3 = n2 - 1;
        int n4 = n;
        while (--n4 >= 0) {
            HashNode hashNode = hashNodeArray[n4];
            while (hashNode != null) {
                HashNode hashNode2;
                HashNode hashNode3 = hashNode.next;
                int n5 = this.hash(hashNode);
                int n6 = n5 & n3;
                hashNode.next = hashNode2 = hashNodeArray2[n6];
                hashNodeArray2[n6] = hashNode;
                hashNode = hashNode3;
            }
        }
        this.table = hashNodeArray2;
        ++this.log2Size;
        this.mask = n3;
    }

    public void clear() {
        HashNode[] hashNodeArray = this.table;
        int n = hashNodeArray.length;
        while (--n >= 0) {
            hashNodeArray[n] = null;
        }
        this.num_bindings = 0;
    }

    public int size() {
        return this.num_bindings;
    }

    protected static HashNode next(HashNode hashNode) {
        return hashNode.next;
    }
}

