/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DComplex
extends Complex
implements Externalizable {
    double real;
    double imag;

    public DComplex() {
    }

    public DComplex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public RealNum re() {
        return new DFloNum(this.real);
    }

    public double doubleValue() {
        return this.real;
    }

    public RealNum im() {
        return new DFloNum(this.imag);
    }

    public double doubleImagValue() {
        return this.imag;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object2;
        return complex.unit() == Unit.Empty && Double.doubleToLongBits(this.real) == Double.doubleToLongBits(complex.reValue()) && Double.doubleToLongBits(this.imag) == Double.doubleToLongBits(complex.imValue());
    }

    public String toString() {
        String string;
        String string2;
        String string3 = "";
        if (this.real == Double.POSITIVE_INFINITY) {
            string3 = "#i";
            string2 = "1/0";
        } else if (this.real == Double.NEGATIVE_INFINITY) {
            string3 = "#i";
            string2 = "-1/0";
        } else if (Double.isNaN(this.real)) {
            string3 = "#i";
            string2 = "0/0";
        } else {
            string2 = Double.toString(this.real);
        }
        if (Double.doubleToLongBits(this.imag) == 0L) {
            return string3 + string2;
        }
        if (this.imag == Double.POSITIVE_INFINITY) {
            string3 = "#i";
            string = "+1/0i";
        } else if (this.imag == Double.NEGATIVE_INFINITY) {
            string3 = "#i";
            string = "-1/0i";
        } else if (Double.isNaN(this.imag)) {
            string3 = "#i";
            string = "+0/0i";
        } else {
            string = Double.toString(this.imag) + "i";
            if (string.charAt(0) != '-') {
                string = "+" + string;
            }
        }
        return (Double.doubleToLongBits(this.real) == 0L ? string3 : string3 + string2) + string;
    }

    public String toString(int n) {
        if (n == 10) {
            return this.toString();
        }
        return "#d" + this.toString();
    }

    public final Numeric neg() {
        return new DComplex(-this.real, -this.imag);
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            if (complex.dimensions() != Dimensions.Empty) {
                throw new ArithmeticException("units mis-match");
            }
            return new DComplex(this.real + (double)n * complex.reValue(), this.imag + (double)n * complex.imValue());
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            if (complex.unit() == Unit.Empty) {
                double d = complex.reValue();
                double d2 = complex.imValue();
                return new DComplex(this.real * d - this.imag * d2, this.real * d2 + this.imag * d);
            }
            return Complex.times(this, complex);
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric div(Object object2) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            return DComplex.div(this.real, this.imag, complex.doubleValue(), complex.doubleImagValue());
        }
        return ((Numeric)object2).divReversed(this);
    }

    public static DComplex power(double d, double d2, double d3, double d4) {
        double d5 = Math.log(DComplex.hypot(d, d2));
        double d6 = Math.atan2(d2, d);
        double d7 = Math.exp(d5 * d3 - d4 * d6);
        d6 = d4 * d5 + d3 * d6;
        return Complex.polar(d7, d6);
    }

    public static Complex log(double d, double d2) {
        return DComplex.make(Math.log(DComplex.hypot(d, d2)), Math.atan2(d2, d));
    }

    public static DComplex div(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = Math.abs(d3);
        if (d9 <= (d8 = Math.abs(d4))) {
            double d10 = d3 / d4;
            d7 = d4 * (1.0 + d10 * d10);
            d6 = d * d10 + d2;
            d5 = d2 * d10 - d;
        } else {
            double d11 = d4 / d3;
            d7 = d3 * (1.0 + d11 * d11);
            d6 = d + d2 * d11;
            d5 = d2 - d * d11;
        }
        return new DComplex(d6 / d7, d5 / d7);
    }

    public static Complex sqrt(double d, double d2) {
        double d3;
        double d4;
        double d5 = DComplex.hypot(d, d2);
        if (d5 == 0.0) {
            d3 = d4 = d5;
        } else if (d > 0.0) {
            d3 = Math.sqrt(0.5 * (d5 + d));
            d4 = d2 / d3 / 2.0;
        } else {
            d4 = Math.sqrt(0.5 * (d5 - d));
            if (d2 < 0.0) {
                d4 = -d4;
            }
            d3 = d2 / d4 / 2.0;
        }
        return new DComplex(d3, d4);
    }

    public static double hypot(double d, double d2) {
        double d3;
        double d4;
        int n;
        int n2;
        double d5 = d;
        double d6 = d2;
        long l = Double.doubleToLongBits(d) << 1 >>> 1;
        long l2 = Double.doubleToLongBits(d2) << 1 >>> 1;
        int n3 = (int)(l2 >>> 32);
        if (n3 > (n2 = (int)(l >>> 32))) {
            n = n2;
            n2 = n3;
            n3 = n;
            long l3 = l;
            l = l2;
            l2 = l3;
        }
        d5 = Double.longBitsToDouble(l);
        d6 = Double.longBitsToDouble(l2);
        if (n2 - n3 > 0x3C00000) {
            return d5 + d6;
        }
        int n4 = 0;
        n = 0;
        if (n2 > 1596981248) {
            if (n2 >= 0x7FF00000) {
                double d7 = d5 + d6;
                if ((l & 0xFFFFFFFFFFFFFL) == 0L) {
                    d7 = d5;
                }
                if ((l2 ^ 0x7FF0000000000000L) == 0L) {
                    d7 = d6;
                }
                return d7;
            }
            n = -629145600;
            n4 += 600;
        }
        if (n3 < 0x20B00000) {
            if (n3 <= 1048575) {
                if (l2 == 0L) {
                    return d5;
                }
                d4 = Double.longBitsToDouble(9209861237972664320L);
                d6 *= d4;
                d5 *= d4;
                n4 -= 1022;
            } else {
                n4 -= 600;
                n = 629145600;
            }
        }
        if (n != 0) {
            n2 += n;
            n3 += n;
            d5 = Double.longBitsToDouble(l += (long)(n << 32));
            d6 = Double.longBitsToDouble(l2 += (long)(n << 32));
        }
        if ((d3 = d5 - d6) > d6) {
            d4 = Double.longBitsToDouble((long)n2 << 32);
            double d8 = d5 - d4;
            d3 = d4 * d4 - (d6 * -d6 - d8 * (d5 + d4));
        } else {
            d5 += d5;
            double d9 = Double.longBitsToDouble((long)n3 << 32);
            double d10 = d6 - d9;
            d4 = Double.longBitsToDouble((long)(n2 + 0x100000) << 32);
            double d11 = d5 - d4;
            d3 = d4 * d9 - (d3 * -d3 - (d4 * d10 + d11 * d6));
        }
        d3 = Math.sqrt(d3);
        if (n4 != 0) {
            d4 = Double.longBitsToDouble(0x3FF0000000000000L + ((long)n4 << 52));
            d3 *= d4;
        }
        return d3;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.real);
        objectOutput.writeDouble(this.imag);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.real = objectInput.readDouble();
        this.imag = objectInput.readDouble();
    }
}

