/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class Char
implements Comparable,
Externalizable {
    int value;
    static Char[] ascii;
    static Char temp;
    static Hashtable hashTable;
    static char[] charNameValues;
    static String[] charNames;

    public Char() {
    }

    private Char(char c) {
        this.value = c;
    }

    private Char(int n) {
        this.value = n;
    }

    public final char charValue() {
        return (char)this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static Char make(int n) {
        Object v;
        if (n < 128) {
            return ascii[n];
        }
        Char.temp.value = n;
        if (hashTable == null) {
            hashTable = new Hashtable();
        }
        if ((v = hashTable.get(temp)) != null) {
            return (Char)v;
        }
        Char char_ = new Char(n);
        hashTable.put(char_, char_);
        return char_;
    }

    public boolean equals(Object object2) {
        return object2 != null && object2 instanceof Char && ((Char)object2).intValue() == this.value;
    }

    public static int nameToChar(String string) {
        int n;
        int n2 = charNames.length;
        while (--n2 >= 0) {
            if (!charNames[n2].equals(string)) continue;
            return charNameValues[n2];
        }
        n2 = charNames.length;
        while (--n2 >= 0) {
            if (!charNames[n2].equalsIgnoreCase(string)) continue;
            return charNameValues[n2];
        }
        n2 = string.length();
        if (n2 > 1 && string.charAt(0) == 'u') {
            n = 0;
            int n3 = 1;
            while (true) {
                if (n3 == n2) {
                    return n;
                }
                int n4 = Character.digit(string.charAt(n3), 16);
                if (n4 < 0) break;
                n = (n << 4) + n4;
                ++n3;
            }
        }
        if (n2 == 3 && string.charAt(1) == '-' && ((n = string.charAt(0)) == 99 || n == 67)) {
            n = string.charAt(2);
            return n & 0x1F;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        if (this.value >= 32 && this.value < 127 && this.value != 39) {
            stringBuffer.append((char)this.value);
        } else {
            stringBuffer.append('\\');
            if (this.value == 39) {
                stringBuffer.append('\'');
            } else if (this.value == 10) {
                stringBuffer.append('n');
            } else if (this.value == 13) {
                stringBuffer.append('r');
            } else if (this.value == 9) {
                stringBuffer.append('t');
            } else if (this.value < 256) {
                String string = Integer.toOctalString(this.value);
                int n = 3 - string.length();
                while (--n >= 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append('u');
                String string = Integer.toHexString(this.value);
                int n = 4 - string.length();
                while (--n >= 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            }
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static String toScmReadableString(int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("#\\");
        for (int i = 0; i < charNameValues.length; ++i) {
            if ((char)n != charNameValues[i]) continue;
            stringBuffer.append(charNames[i]);
            return stringBuffer.toString();
        }
        if (n < 8) {
            stringBuffer.append('0');
            stringBuffer.append(n);
        } else if (n < 32 || n > 127) {
            stringBuffer.append(Integer.toString(n, 8));
        } else {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.value > 55296) {
            if (this.value > 65535) {
                objectOutput.writeChar((this.value - 65536 >> 10) + 55296);
                this.value = (this.value & 0x3FF) + 56320;
            } else if (this.value <= 56319) {
                objectOutput.writeChar(this.value);
                this.value = 0;
            }
        }
        objectOutput.writeChar(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        char c;
        this.value = objectInput.readChar();
        if (this.value >= 55296 && this.value < 56319 && (c = objectInput.readChar()) >= '\udc00' && c <= '\udfff') {
            this.value = (this.value - 55296 << 10) + (c - 56320) + 65536;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return Char.make(this.value);
    }

    public int compareTo(Object object2) {
        return this.value - ((Char)object2).value;
    }

    static {
        temp = new Char(0);
        ascii = new Char[128];
        int n = 128;
        while (--n >= 0) {
            Char.ascii[n] = new Char(n);
        }
        charNameValues = new char[]{' ', '\t', '\n', '\n', '\r', '\f', '\b', '\u001b', '\u007f', '\u007f', '\u0007', '\u0000'};
        charNames = new String[]{"space", "tab", "newline", "linefeed", "return", "page", "backspace", "esc", "del", "rubout", "bel", "nul"};
    }
}

