/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.lists.FString;
import gnu.lists.FVector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0or1;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.WriterManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import kawa.Shell;
import kawa.Telnet;
import kawa.TelnetOutputStream;
import kawa.TelnetRepl;
import kawa.Version;
import kawa.lang.CompileFile;
import kawa.standard.load;

public class repl
extends Procedure0or1 {
    public static String compilationDirectory = null;
    public static String compilationTopname = null;
    public static String compilationPrefix = null;
    Language language;
    static Language previousLanguage;
    private static int exitCounter;
    public static String[] commandLineArgArray;
    public static FVector commandLineArguments;
    public static String homeDirectory;
    static boolean shutdownRegistered;
    static String[][] propertyFields;

    public repl(Language language) {
        this.language = language;
    }

    public Object apply0() {
        Shell.run(this.language, Environment.getCurrent());
        return Values.empty;
    }

    public Object apply1(Object object2) {
        Shell.run(this.language, (Environment)object2);
        return Values.empty;
    }

    static void bad_option(String string) {
        System.err.println("kawa: bad option '" + string + "'");
        repl.printOptions(System.err);
        System.exit(-1);
    }

    public static void printOption(PrintStream printStream, String string, String string2) {
        printStream.print(" ");
        printStream.print(string);
        int n = string.length() + 1;
        for (int i = 0; i < 30 - n; ++i) {
            printStream.print(" ");
        }
        printStream.print(" ");
        printStream.println(string2);
    }

    public static void printOptions(PrintStream printStream) {
        printStream.println("Usage: [java kawa.repl | kawa] [options ...]");
        printStream.println();
        printStream.println(" Generic options:");
        repl.printOption(printStream, "--help", "Show help about options");
        repl.printOption(printStream, "--author", "Show author information");
        repl.printOption(printStream, "--version", "Show version information");
        printStream.println();
        printStream.println(" Options");
        repl.printOption(printStream, "-e <expr>", "Evaluate expression <expr>");
        repl.printOption(printStream, "-c <expr>", "Same as -e, but make sure ~/.kawarc.scm is run first");
        repl.printOption(printStream, "-f <filename>", "File to interpret");
        repl.printOption(printStream, "-s| --", "Start reading commands interactively from console");
        repl.printOption(printStream, "-w", "Launch the interpreter in a GUI window");
        repl.printOption(printStream, "--server <port>", "Start a server accepting telnet connections on <port>");
        repl.printOption(printStream, "--debug-dump-zip", "Compiled interactive expressions to a zip archive");
        repl.printOption(printStream, "--debug-print-expr", "Print generated internal expressions");
        repl.printOption(printStream, "--debug-print-final-expr", "Print expression after any optimizations");
        repl.printOption(printStream, "--[no-]full-tailcalls", "(Don't) use full tail-calls");
        repl.printOption(printStream, "-C <filename> ...", "Compile named files to Java class files");
        repl.printOption(printStream, "--output-format <format>", "Use <format> when printing top-level output");
        repl.printOption(printStream, "--<language>", "Select source language, one of:");
        String[][] stringArray = Language.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.print("   ");
            String[] stringArray2 = stringArray[i];
            int n = stringArray2.length - 1;
            for (int j = 0; j < n; ++j) {
                printStream.print(stringArray2[j] + " ");
            }
            if (i == 0) {
                printStream.print("[default]");
            }
            printStream.println();
        }
        printStream.println(" Compilation options, must be specified before -C");
        repl.printOption(printStream, "-d <dirname>", "Directory to place .class files in");
        repl.printOption(printStream, "-P <prefix>", "Prefix to prepand to class names");
        repl.printOption(printStream, "-T <topname>", "name to give to top-level class");
        repl.printOption(printStream, "--main", "Generate an application, with a main method");
        repl.printOption(printStream, "--applet", "Generate an applet");
        repl.printOption(printStream, "--servlet", "Generate a servlet");
        repl.printOption(printStream, "--module-static", "Top-leval definitions are by default static");
        Vector vector = Compilation.options.keys();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            repl.printOption(printStream, "--" + string, Compilation.options.getDoc(string));
        }
        printStream.println();
        printStream.println("For more information go to:  http://www.gnu.org/software/kawa/");
    }

    public static synchronized void exitIncrement() {
        if (exitCounter == 0) {
            ++exitCounter;
        }
        ++exitCounter;
    }

    public static synchronized void exitDecrement() {
        int n = exitCounter;
        if (n > 0) {
            if (--n == 0) {
                System.exit(0);
            } else {
                exitCounter = n;
            }
        }
    }

    static void checkInitFile() {
        if (homeDirectory == null) {
            Comparable<Boolean> comparable;
            File file = null;
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                comparable = new FString(homeDirectory);
                String string = System.getProperty("file.separator");
                String string2 = "/".equals(string) ? ".kawarc.scm" : "kawarc.scm";
                file = new File(homeDirectory, string2);
            } else {
                comparable = Boolean.FALSE;
            }
            Environment.getCurrent().put("home-directory", (Object)comparable);
            if (file != null && file.exists()) {
                Shell.runFile(file.getPath());
            }
        }
    }

    public static void setArgs(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        Object[] objectArray = new Object[n2];
        if (n == 0) {
            commandLineArgArray = stringArray;
        } else {
            String[] stringArray2 = new String[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                stringArray2[n3] = stringArray[n3 + n];
            }
            commandLineArgArray = stringArray2;
        }
        int n4 = n2;
        while (--n4 >= 0) {
            objectArray[n4] = new FString(stringArray[n4 + n]);
        }
        commandLineArguments = new FVector(objectArray);
        Environment.getCurrent().put("command-line-arguments", (Object)commandLineArguments);
    }

    public static void getLanguageFromFilenameExtension(String string) {
        if (previousLanguage == null && (previousLanguage = Language.getInstanceFromFilenameExtension(string)) != null) {
            Language.setDefaults(previousLanguage);
            return;
        }
        repl.getLanguage();
    }

    public static void getLanguage() {
        if (previousLanguage == null) {
            previousLanguage = Language.getInstance(null);
            Language.setDefaults(previousLanguage);
        }
    }

    public static int processArgs(String[] stringArray, int n, int n2) {
        boolean bl = false;
        while (n < n2) {
            String string = stringArray[n];
            if (string.equals("-c") || string.equals("-e")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                repl.getLanguage();
                repl.setArgs(stringArray, n + 1);
                if (string.equals("-c")) {
                    repl.checkInitFile();
                }
                Language language = Language.getDefaultLanguage();
                Shell.runString(stringArray[n], language, Environment.getCurrent());
                bl = true;
            } else if (string.equals("-f")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                String string2 = stringArray[n];
                repl.getLanguageFromFilenameExtension(string2);
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                Shell.runFile(string2);
                bl = true;
            } else {
                Object object2;
                Object object3;
                Object object4;
                if (string.equals("\\")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    String string3 = stringArray[n];
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
                        int n3 = ((InputStream)bufferedInputStream).read();
                        if (n3 == 35) {
                            int n4;
                            StringBuffer stringBuffer = new StringBuffer(100);
                            object4 = new Vector<String>(10);
                            int n5 = 0;
                            while (n3 != 10 && n3 != 13 && n3 >= 0) {
                                n3 = ((InputStream)bufferedInputStream).read();
                            }
                            while (true) {
                                if ((n3 = ((InputStream)bufferedInputStream).read()) < 0) {
                                    System.err.println("unexpected end-of-file processing argument line for: '" + string3 + '\'');
                                    System.exit(-1);
                                }
                                if (n5 == 0) {
                                    if (n3 == 92 || n3 == 39 || n3 == 34) {
                                        n5 = n3;
                                        continue;
                                    }
                                    if (n3 == 10 || n3 == 13) break;
                                    if (n3 == 32 || n3 == 9) {
                                        if (stringBuffer.length() <= 0) continue;
                                        ((Vector)object4).addElement(stringBuffer.toString());
                                        stringBuffer.setLength(0);
                                        continue;
                                    }
                                } else if (n5 == 92) {
                                    n5 = 0;
                                } else if (n3 == n5) {
                                    n5 = 0;
                                    continue;
                                }
                                stringBuffer.append((char)n3);
                            }
                            if (stringBuffer.length() > 0) {
                                ((Vector)object4).addElement(stringBuffer.toString());
                            }
                            if ((n4 = ((Vector)object4).size()) > 0) {
                                object3 = new String[n4];
                                ((Vector)object4).copyInto((Object[])object3);
                                int n6 = repl.processArgs((String[])object3, 0, n4);
                                if (n6 >= 0 && n6 < n4) {
                                    System.err.println("" + (n4 - n6) + " unused meta args");
                                }
                            }
                        }
                        repl.getLanguageFromFilenameExtension(string3);
                        object2 = InPort.openFile(bufferedInputStream, string3);
                        repl.setArgs(stringArray, n + 1);
                        repl.checkInitFile();
                        load.loadSource((InPort)object2, Environment.user());
                        return -1;
                    }
                    catch (SyntaxException syntaxException) {
                        syntaxException.printAll(OutPort.errDefault(), 20);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Cannot open file " + string3);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                        System.exit(1);
                    }
                    return -1;
                }
                if (string.equals("-s") || string.equals("--")) {
                    repl.getLanguage();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
                    return -1;
                }
                if (string.equals("-w")) {
                    repl.getLanguage();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    try {
                        Class.forName("kawa.GuiConsole").newInstance();
                    }
                    catch (Exception exception) {
                        System.err.println("failed to create Kawa window: " + exception);
                        System.exit(-1);
                    }
                    bl = true;
                } else if (string.equals("-d")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationDirectory = stringArray[n];
                } else if (string.equals("-P")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationPrefix = stringArray[n];
                } else if (string.equals("-T")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationTopname = stringArray[n];
                } else {
                    if (string.equals("-C")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        while (n < n2) {
                            string = stringArray[n];
                            repl.getLanguageFromFilenameExtension(string);
                            try {
                                System.err.println("(compiling " + string + ")");
                                SourceMessages sourceMessages = new SourceMessages();
                                CompileFile.compile_to_files(string, compilationDirectory, compilationPrefix, compilationTopname, sourceMessages);
                                boolean bl2 = sourceMessages.seenErrors();
                                sourceMessages.checkErrors(System.err, 50);
                                if (bl2) {
                                    System.exit(-1);
                                }
                            }
                            catch (Throwable throwable) {
                                System.err.println("Internal error while compiling " + string);
                                throwable.printStackTrace(System.err);
                                System.exit(-1);
                            }
                            ++n;
                        }
                        return -1;
                    }
                    if (string.equals("--output-format") || string.equals("--format")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        Shell.setDefaultFormat(stringArray[n]);
                    } else {
                        Object object5;
                        if (string.equals("--connect")) {
                            int n7;
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n7 = 0;
                            } else {
                                try {
                                    n7 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--connect port#");
                                    n7 = -1;
                                }
                            }
                            try {
                                object2 = new Socket("localhost", n7);
                                Telnet telnet = new Telnet((Socket)object2, true);
                                object5 = telnet.getInputStream();
                                TelnetOutputStream telnetOutputStream = telnet.getOutputStream();
                                object4 = new PrintStream(telnetOutputStream, true);
                                System.setIn((InputStream)object5);
                                System.setOut((PrintStream)object4);
                                System.setErr((PrintStream)object4);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace(System.err);
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--server")) {
                            int n8;
                            repl.getLanguage();
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n8 = 0;
                            } else {
                                try {
                                    n8 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--server port#");
                                    n8 = -1;
                                }
                            }
                            try {
                                object2 = new ServerSocket(n8);
                                n8 = ((ServerSocket)object2).getLocalPort();
                                System.err.println("Listening on port " + n8);
                                while (true) {
                                    System.err.print("waiting ... ");
                                    System.err.flush();
                                    Socket socket = ((ServerSocket)object2).accept();
                                    System.err.println("got connection from " + socket.getInetAddress() + " port:" + socket.getPort());
                                    TelnetRepl.serve(Language.getDefaultLanguage(), socket);
                                }
                            }
                            catch (IOException iOException) {
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--main")) {
                            Compilation.generateMainDefault = true;
                        } else if (string.equals("--applet")) {
                            Compilation.generateAppletDefault = true;
                        } else if (string.equals("--servlet")) {
                            Compilation.generateServletDefault = true;
                        } else if (string.equals("--debug-dump-zip")) {
                            ModuleExp.dumpZipPrefix = "kawa-zip-dump-";
                        } else if (string.equals("--debug-print-expr")) {
                            ModuleExp.debugPrintExpr = true;
                        } else if (string.equals("--debug-print-final-expr")) {
                            Compilation.debugPrintFinalExpr = true;
                        } else if (string.equals("--module-static")) {
                            Compilation.moduleStatic = 1;
                        } else if (string.equals("--module-static-run")) {
                            Compilation.moduleStatic = 2;
                        } else if (string.equals("--fewer-classes")) {
                            Compilation.fewerClasses = true;
                        } else if (string.equals("--no-inline") || string.equals("--inline=none")) {
                            Compilation.inlineOk = false;
                        } else if (string.equals("--inline")) {
                            Compilation.inlineOk = true;
                        } else if (string.equals("--cps")) {
                            Compilation.fewerClasses = true;
                            Compilation.defaultCallConvention = 4;
                        } else if (string.equals("--full-tailcalls")) {
                            Compilation.defaultCallConvention = 3;
                        } else if (string.equals("--no-full-tailcalls")) {
                            Compilation.defaultCallConvention = 1;
                        } else if (string.equals("--help")) {
                            repl.printOptions(System.out);
                            System.exit(0);
                        } else if (string.equals("--author")) {
                            System.out.println("Per Bothner <per@bothner.com>");
                            System.exit(0);
                        } else if (string.equals("--version")) {
                            System.out.print("Kawa ");
                            System.out.print(Version.getVersion());
                            System.out.println();
                            System.out.println("Copyright (C) 2005 Per Bothner");
                            bl = true;
                        } else if (string.length() > 0 && string.charAt(0) == '-') {
                            String string4 = string;
                            if (string4.length() > 2 && string4.charAt(0) == '-') {
                                string4 = string4.substring(string4.charAt(1) == '-' ? 2 : 1);
                            }
                            if ((object2 = Language.getInstance(string4)) != null) {
                                if (previousLanguage == null) {
                                    Language.setDefaults((Language)object2);
                                } else {
                                    Language.setDefaultLanguage((Language)object2);
                                }
                                previousLanguage = object2;
                            } else {
                                boolean bl3;
                                int n9 = string4.indexOf("=");
                                if (n9 < 0) {
                                    object5 = null;
                                } else {
                                    object5 = string4.substring(n9 + 1);
                                    string4 = string4.substring(0, n9);
                                }
                                boolean bl4 = bl3 = string4.startsWith("no-") && string4.length() > 3;
                                if (object5 == null && bl3) {
                                    object5 = "no";
                                    string4 = string4.substring(3);
                                }
                                if ((object4 = Compilation.options.set(string4, (String)object5)) != null) {
                                    if (bl3 && object4 == "unknown option name") {
                                        object4 = "both '--no-' prefix and '=" + (String)object5 + "' specified";
                                    }
                                    if (object4 == "unknown option name") {
                                        repl.bad_option(string);
                                    } else {
                                        System.err.println("kawa: bad option '" + string + "': " + (String)object4);
                                        System.exit(-1);
                                    }
                                }
                            }
                        } else {
                            Object object6;
                            Object object7;
                            int n10 = string.indexOf(61);
                            if (n10 <= 0) {
                                return n;
                            }
                            object2 = string.substring(0, n10);
                            String string5 = string.substring(n10 + 1);
                            int n11 = 0;
                            while ((object7 = propertyFields[n11]) != null) {
                                if (((String)object2).equals(object7[0])) {
                                    String string6 = object7[1];
                                    object3 = object7[2];
                                    try {
                                        Class<?> clazz = Class.forName(string6);
                                        ThreadLocation threadLocation = (ThreadLocation)clazz.getDeclaredField((String)object3).get(null);
                                        threadLocation.setGlobal(string5);
                                    }
                                    catch (Throwable throwable) {
                                        System.err.println("error setting property " + (String)object2 + " field " + string6 + '.' + (String)object3 + ": " + throwable);
                                        System.exit(-1);
                                    }
                                }
                                ++n11;
                            }
                            if (((String)object2).charAt(0) == '{') {
                                n11 = ((String)object2).lastIndexOf(125);
                                if (n11 <= 0) {
                                    System.err.println("missing '}' in property name '" + (String)object2 + "'");
                                    System.exit(-1);
                                }
                                object5 = ((String)object2).substring(1, n11);
                                object6 = ((String)object2).substring(n11 + 1);
                            } else {
                                object5 = "";
                                object6 = object2;
                            }
                            object4 = Symbol.make(object5, (String)object6);
                            Language.getDefaultLanguage();
                            object7 = Environment.getCurrent();
                            ((Environment)object7).put((Symbol)object4, null, string5);
                        }
                    }
                }
            }
            ++n;
        }
        return bl ? -1 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            int n = repl.processArgs(stringArray, 0, stringArray.length);
            if (n < 0) {
                return;
            }
            if (n < stringArray.length) {
                String string = stringArray[n];
                repl.getLanguageFromFilenameExtension(string);
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                Shell.runFile(string);
            } else {
                repl.getLanguage();
                repl.setArgs(stringArray, n);
                repl.checkInitFile();
                Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
            }
        }
        finally {
            if (!shutdownRegistered) {
                OutPort.runCleanups();
            }
            repl.exitDecrement();
        }
    }

    static {
        shutdownRegistered = WriterManager.instance.registerShutdownHook();
        propertyFields = new String[][]{{"out:doctype-system", "gnu.xml.XMLPrinter", "doctypeSystem"}, {"out:doctype-public", "gnu.xml.XMLPrinter", "doctypePublic"}, {"out:base", "gnu.kawa.functions.DisplayFormat", "outBase"}, {"out:radix", "gnu.kawa.functions.DisplayFormat", "outRadix"}, {"out:line-length", "gnu.text.PrettyWriter", "lineLengthLoc"}, {"out:right-margin", "gnu.text.PrettyWriter", "lineLengthLoc"}, {"out:miser-width", "gnu.text.PrettyWriter", "miserWidthLoc"}, {"out:xml-indent", "gnu.xml.XMLPrinter", "indentLoc"}, null};
    }
}

