/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ScopeExp;
import gnu.kawa.util.GeneralHashTable;
import gnu.kawa.util.HashNode;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameLookup
extends GeneralHashTable<Object, Declaration> {
    Language language;
    static final Symbol KEY = Symbol.makeUninterned("<current-NameLookup>");

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public NameLookup(Language language) {
        this.language = language;
    }

    public static NameLookup getInstance(Environment environment, Language language) {
        Location location2 = environment.getLocation(KEY);
        NameLookup nameLookup = (NameLookup)location2.get(null);
        if (nameLookup == null) {
            nameLookup = new NameLookup(language);
            location2.set(nameLookup);
        } else {
            nameLookup.setLanguage(language);
        }
        return nameLookup;
    }

    public static void setInstance(Environment environment, NameLookup nameLookup) {
        if (nameLookup == null) {
            environment.remove(KEY);
        } else {
            environment.put(KEY, null, nameLookup);
        }
    }

    public void push(Declaration declaration) {
        Object object2 = declaration.getSymbol();
        if (object2 == null) {
            return;
        }
        if (++this.num_bindings >= ((HashNode[])this.table).length) {
            this.rehash();
        }
        int n = this.hash(object2);
        Object object3 = this.makeEntry(object2, n, declaration);
        int n2 = this.hashToIndex(n);
        ((HashNode)object3).next = ((HashNode[])this.table)[n2];
        ((HashNode[])this.table)[n2] = object3;
    }

    public boolean pop(Declaration declaration) {
        Object object2 = declaration.getSymbol();
        if (object2 == null) {
            return false;
        }
        int n = this.hash(object2);
        HashNode hashNode = null;
        int n2 = this.hashToIndex(n);
        HashNode hashNode2 = ((HashNode[])this.table)[n2];
        while (hashNode2 != null) {
            HashNode hashNode3 = hashNode2.next;
            if (hashNode2.getValue() == declaration) {
                if (hashNode == null) {
                    ((HashNode[])this.table)[n2] = hashNode3;
                } else {
                    hashNode.next = hashNode3;
                }
                --this.num_bindings;
                return true;
            }
            hashNode = hashNode2;
            hashNode2 = hashNode3;
        }
        return false;
    }

    public void push(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.push(declaration);
        }
    }

    public void pop(ScopeExp scopeExp) {
        for (Declaration declaration = scopeExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            this.pop(declaration);
        }
    }

    public void removeSubsumed(Declaration declaration) {
        Object object2 = declaration.getSymbol();
        int n = this.hash(object2);
        int n2 = this.hashToIndex(n);
        HashNode hashNode = null;
        HashNode hashNode2 = ((HashNode[])this.table)[n2];
        while (hashNode2 != null) {
            HashNode hashNode3 = hashNode2.next;
            Declaration declaration2 = (Declaration)hashNode2.getValue();
            if (declaration2 != declaration && this.subsumedBy(declaration, declaration2)) {
                if (hashNode == null) {
                    ((HashNode[])this.table)[n2] = hashNode3;
                } else {
                    hashNode.next = hashNode3;
                }
            } else {
                hashNode = hashNode2;
            }
            hashNode2 = hashNode3;
        }
    }

    protected boolean subsumedBy(Declaration declaration, Declaration declaration2) {
        return declaration.getSymbol() == declaration2.getSymbol() && (this.language.getNamespaceOf(declaration) & this.language.getNamespaceOf(declaration2)) != 0;
    }

    public Declaration lookup(Object object2, int n) {
        int n2 = this.hash(object2);
        int n3 = this.hashToIndex(n2);
        HashNode hashNode = ((HashNode[])this.table)[n3];
        while (hashNode != null) {
            Declaration declaration = (Declaration)hashNode.getValue();
            if (object2.equals(declaration.getSymbol()) && this.language.hasNamespace(declaration, n)) {
                return declaration;
            }
            hashNode = hashNode.next;
        }
        return null;
    }

    public Declaration lookup(Object object2, boolean bl) {
        return this.lookup(object2, bl ? 2 : 1);
    }
}

