/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class DefineNamespace
extends Syntax {
    private boolean makePrivate;
    private boolean makeXML;
    public static final DefineNamespace define_namespace = new DefineNamespace();
    public static final DefineNamespace define_private_namespace = new DefineNamespace();
    public static final DefineNamespace define_xml_namespace = new DefineNamespace();
    public static final String XML_NAMESPACE_MAGIC = "&xml&";

    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        Expression expression;
        Pair pair2;
        Pair pair3;
        if (!(pair.getCdr() instanceof Pair && (pair3 = (Pair)pair.getCdr()).getCar() instanceof Symbol && pair3.getCdr() instanceof Pair && (pair2 = (Pair)pair3.getCdr()).getCdr() == LList.Empty)) {
            translator.error('e', "invalid syntax for define-namespace");
            return false;
        }
        Symbol symbol = (Symbol)pair3.getCar();
        Declaration declaration = scopeExp.getDefine(symbol, 'w', translator);
        translator.push(declaration);
        declaration.setFlag(0x204000);
        if (this.makePrivate) {
            declaration.setFlag(0x1000000);
            declaration.setPrivate(true);
        } else if (scopeExp instanceof ModuleExp) {
            declaration.setCanRead(true);
        }
        Translator.setLine(declaration, (Object)pair3);
        String string = null;
        if (pair2.getCar() instanceof CharSequence) {
            Namespace namespace;
            string = pair2.getCar().toString();
            if (string.startsWith("class:")) {
                String string2 = string.substring(6);
                namespace = ClassNamespace.getInstance(string, ClassType.make(string2));
                declaration.setType(ClassType.make("gnu.kawa.lispexpr.ClassNamespace"));
            } else if (this.makeXML) {
                namespace = XmlNamespace.getInstance(symbol.getName(), string);
                declaration.setType(ClassType.make("gnu.kawa.xml.XmlNamespace"));
            } else {
                namespace = Namespace.getInstance(string);
                declaration.setType(ClassType.make("gnu.mapping.Namespace"));
            }
            expression = new QuoteExp(namespace);
            declaration.setFlag(8192);
        } else {
            expression = translator.rewrite_car(pair2, false);
        }
        declaration.noteValue(expression);
        vector.addElement(SetExp.makeDefinition(declaration, expression));
        return true;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return translator.syntaxError("define-namespace is only allowed in a <body>");
    }

    static {
        define_namespace.setName("define-namespace");
        define_private_namespace.setName("define-private-namespace");
        DefineNamespace.define_private_namespace.makePrivate = true;
        define_xml_namespace.setName("define-xml-namespace");
        DefineNamespace.define_xml_namespace.makeXML = true;
    }
}

