/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.Declaration;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.xml.KNode;
import gnu.lists.AbstractSequence;
import gnu.lists.NodePredicate;
import gnu.mapping.Procedure;
import gnu.xml.NodeTree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NodeType
extends ObjectType
implements TypeValue,
NodePredicate,
Externalizable {
    public static final int TEXT_OK = 1;
    public static final int ELEMENT_OK = 2;
    public static final int ATTRIBUTE_OK = 4;
    public static final int DOCUMENT_OK = 8;
    public static final int COMMENT_OK = 16;
    public static final int PI_OK = 32;
    int kinds = -1;
    public static final ClassType typeKNode = ClassType.make("gnu.kawa.xml.KNode");
    public static final ClassType typeNodeType = ClassType.make("gnu.kawa.xml.NodeType");
    public static final NodeType nodeType = new NodeType("gnu.kawa.xml.KNode");
    static final Method coerceMethod = typeNodeType.getDeclaredMethod("coerceForce", 2);
    static final Method coerceOrNullMethod = typeNodeType.getDeclaredMethod("coerceOrNull", 2);
    public static final NodeType documentNodeTest = new NodeType("document-node", 8);
    public static final NodeType textNodeTest = new NodeType("text", 1);
    public static final NodeType commentNodeTest = new NodeType("comment", 16);
    public static final NodeType anyNodeTest = new NodeType("node");

    public NodeType(String string, int n) {
        super(string);
        this.kinds = n;
    }

    public NodeType(String string) {
        this(string, -1);
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        codeAttr.emitPushInt(this.kinds);
        codeAttr.emitInvokeStatic(coerceMethod);
    }

    public Object coerceFromObject(Object object2) {
        return NodeType.coerceForce(object2, this.kinds);
    }

    public Type getImplementationType() {
        return typeKNode;
    }

    public int compare(Type type) {
        return this.getImplementationType().compare(type);
    }

    public boolean isInstance(Object object2) {
        if (object2 instanceof KNode) {
            KNode kNode = (KNode)object2;
            return this.isInstancePos(kNode.sequence, kNode.getPos());
        }
        return false;
    }

    public boolean isInstancePos(AbstractSequence abstractSequence, int n) {
        return NodeType.isInstance(abstractSequence, n, this.kinds);
    }

    public static boolean isInstance(AbstractSequence abstractSequence, int n, int n2) {
        int n3 = abstractSequence.getNextKind(n);
        if (n2 < 0) {
            return n3 != 0;
        }
        switch (n3) {
            case 0: {
                return false;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: {
                return (n2 & 1) != 0;
            }
            case 33: {
                return (n2 & 2) != 0;
            }
            case 35: {
                return (n2 & 4) != 0;
            }
            case 34: {
                return (n2 & 8) != 0;
            }
            case 36: {
                return (n2 & 0x10) != 0;
            }
            case 37: {
                return (n2 & 0x20) != 0;
            }
        }
        return true;
    }

    public static KNode coerceForce(Object object2, int n) {
        KNode kNode = NodeType.coerceOrNull(object2, n);
        if (kNode == null) {
            throw new ClassCastException("coerce from " + object2.getClass());
        }
        return kNode;
    }

    public static KNode coerceOrNull(Object object2, int n) {
        KNode kNode;
        if (object2 instanceof NodeTree) {
            kNode = KNode.make((NodeTree)object2);
        } else if (object2 instanceof KNode) {
            kNode = (KNode)object2;
        } else {
            return null;
        }
        return NodeType.isInstance(kNode.sequence, kNode.ipos, n) ? kNode : null;
    }

    protected void emitCoerceOrNullMethod(Variable variable, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (variable != null) {
            codeAttr.emitLoad(variable);
        }
        codeAttr.emitPushInt(this.kinds);
        codeAttr.emitInvokeStatic(coerceOrNullMethod);
    }

    public void emitTestIf(Variable variable, Declaration declaration, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        this.emitCoerceOrNullMethod(variable, compilation);
        if (declaration != null) {
            codeAttr.emitDup();
            declaration.compileStore(compilation);
        }
        codeAttr.emitIfNotNull();
    }

    public void emitIsInstance(Variable variable, Compilation compilation, Target target) {
        if (target instanceof ConditionalTarget) {
            ConditionalTarget conditionalTarget = (ConditionalTarget)target;
            this.emitCoerceOrNullMethod(variable, compilation);
            CodeAttr codeAttr = compilation.getCode();
            if (conditionalTarget.trueBranchComesFirst) {
                codeAttr.emitGotoIfCompare1(conditionalTarget.ifFalse, 198);
            } else {
                codeAttr.emitGotoIfCompare1(conditionalTarget.ifTrue, 199);
            }
            conditionalTarget.emitGotoFirstBranch(codeAttr);
        } else {
            InstanceOf.emitIsInstance(this, variable, compilation, target);
        }
    }

    public Procedure getConstructor() {
        return null;
    }

    public String toString() {
        return "NodeType " + this.getName();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.getName();
        objectOutput.writeUTF(string == null ? "" : string);
        objectOutput.writeInt(this.kinds);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        if (string.length() > 0) {
            this.setName(string);
        }
        this.kinds = objectInput.readInt();
    }
}

