/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.kawa.xml.XDataType;
import gnu.kawa.xml.XString;
import gnu.xml.TextUtils;
import gnu.xml.XName;
import java.util.regex.Pattern;

public class XStringType
extends XDataType {
    Pattern pattern;
    static ClassType XStringType = ClassType.make("gnu.kawa.xml.XString");
    public static final XStringType normalizedStringType = new XStringType("normalizedString", stringType, 39, null);
    public static final XStringType tokenType = new XStringType("token", normalizedStringType, 40, null);
    public static final XStringType languageType = new XStringType("language", tokenType, 41, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
    public static final XStringType NMTOKENType = new XStringType("NMTOKEN", tokenType, 42, "\\c+");
    public static final XStringType NameType = new XStringType("Name", tokenType, 43, null);
    public static final XStringType NCNameType = new XStringType("NCName", NameType, 44, null);
    public static final XStringType IDType = new XStringType("ID", NCNameType, 45, null);
    public static final XStringType IDREFType = new XStringType("IDREF", NCNameType, 46, null);
    public static final XStringType ENTITYType = new XStringType("ENTITY", NCNameType, 47, null);

    public XStringType(String string, XDataType xDataType, int n, String string2) {
        super(string, XStringType, n);
        this.baseType = xDataType;
        if (string2 != null) {
            this.pattern = Pattern.compile(string2);
        }
    }

    public boolean isInstance(Object object2) {
        if (!(object2 instanceof XString)) {
            return false;
        }
        XDataType xDataType = ((XString)object2).getStringType();
        while (xDataType != null) {
            if (xDataType == this) {
                return true;
            }
            xDataType = xDataType.baseType;
        }
        return false;
    }

    public String matches(String string) {
        boolean bl;
        switch (this.typeCode) {
            case 39: 
            case 40: {
                boolean bl2 = this.typeCode != 39;
                bl = string == TextUtils.replaceWhitespace(string, bl2);
                break;
            }
            case 43: {
                bl = XName.isName(string);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                bl = XName.isNCName(string);
                break;
            }
            case 42: {
                bl = XName.isNmToken(string);
                break;
            }
            default: {
                bl = this.pattern == null || this.pattern.matcher(string).matches();
            }
        }
        return bl ? null : "not a valid XML " + this.getName();
    }

    public Object valueOf(String string) {
        String string2 = this.matches(string = TextUtils.replaceWhitespace(string, this != normalizedStringType));
        if (string2 != null) {
            throw new ClassCastException("cannot cast " + string + " to " + this.name);
        }
        return new XString(string, this);
    }

    public Object cast(Object object2) {
        XString xString;
        if (object2 instanceof XString && (xString = (XString)object2).getStringType() == this) {
            return xString;
        }
        return this.valueOf((String)stringType.cast(object2));
    }

    public static XString makeNCName(String string) {
        return (XString)NCNameType.valueOf(string);
    }
}

