/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.RunnableClosure;

public class Future
extends Thread {
    public RunnableClosure closure;

    public Future(Procedure procedure, CallContext callContext) {
        this.closure = new RunnableClosure(procedure, callContext);
    }

    public Future(Procedure procedure, CallContext callContext, Environment environment) {
        this.closure = new RunnableClosure(procedure, callContext, environment);
        this.closure.environment.setName(this.getName());
    }

    public Future(Procedure procedure, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        this.closure = new RunnableClosure(procedure, environment, inPort, outPort, outPort2);
    }

    public Future(Procedure procedure) {
        this.closure = new RunnableClosure(procedure);
    }

    public final CallContext getCallContext() {
        return this.closure.getCallContext();
    }

    public Environment getEnvironment() {
        return this.closure.environment;
    }

    public void run() {
        this.closure.run();
    }

    public Object waitForResult() throws Throwable {
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("thread join [force] was interrupted");
        }
        Throwable throwable = this.closure.exception;
        if (throwable != null) {
            throw throwable;
        }
        return this.closure.result;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<future ");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

