/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import gnu.text.Path;
import gnu.text.URIPath;
import gnu.text.URLPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePath
extends Path
implements Comparable<FilePath> {
    final File file;
    final String path;

    private FilePath(File file) {
        this.file = file;
        this.path = file.toString();
    }

    private FilePath(File file, String string) {
        this.file = file;
        this.path = string;
    }

    public static FilePath valueOf(String string) {
        String string2 = string;
        return new FilePath(new File(string), string2);
    }

    public static FilePath valueOf(File file) {
        return new FilePath(file);
    }

    public static FilePath coerceToFilePathOrNull(Object object2) {
        String string;
        if (object2 instanceof FilePath) {
            return (FilePath)object2;
        }
        if (object2 instanceof URIPath) {
            return FilePath.valueOf(new File(((URIPath)object2).uri));
        }
        if (object2 instanceof URI) {
            return FilePath.valueOf(new File((URI)object2));
        }
        if (object2 instanceof File) {
            return FilePath.valueOf((File)object2);
        }
        if (object2 instanceof FString) {
            string = object2.toString();
        } else if (object2 instanceof String) {
            string = (String)object2;
        } else {
            return null;
        }
        return FilePath.valueOf(string);
    }

    public static FilePath makeFilePath(Object object2) {
        FilePath filePath = FilePath.coerceToFilePathOrNull(object2);
        if (filePath == null) {
            throw new WrongType((String)null, -4, object2, "filepath");
        }
        return filePath;
    }

    @Override
    public boolean isAbsolute() {
        return this == Path.userDirPath || this.file.isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        char c;
        int n;
        if (this.file.isDirectory()) {
            return true;
        }
        return !this.file.exists() && (n = this.path.length()) > 0 && ((c = this.path.charAt(n - 1)) == '/' || c == File.separatorChar);
    }

    @Override
    public boolean delete() {
        return this.toFile().delete();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long getContentLength() {
        long l = this.file.length();
        return l == 0L && !this.file.exists() ? -1L : l;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getLast() {
        return this.file.getName();
    }

    @Override
    public FilePath getParent() {
        File file = this.file.getParentFile();
        if (file == null) {
            return null;
        }
        return FilePath.valueOf(file);
    }

    @Override
    public int compareTo(FilePath filePath) {
        return this.file.compareTo(filePath.file);
    }

    public boolean equals(Object object2) {
        return object2 instanceof FilePath && this.file.equals(((FilePath)object2).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.path;
    }

    public File toFile() {
        return this.file;
    }

    @Override
    public URL toURL() {
        if (this == Path.userDirPath) {
            return this.resolve("").toURL();
        }
        if (!this.isAbsolute()) {
            return this.getAbsolute().toURL();
        }
        try {
            return this.file.toURI().toURL();
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    private static URI toUri(File file) {
        try {
            if (file.isAbsolute()) {
                return file.toURI();
            }
            String string = file.toString();
            char c = File.separatorChar;
            if (c != '/') {
                string = string.replace(c, '/');
            }
            return new URI(null, null, string, null);
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    @Override
    public URI toUri() {
        if (this == Path.userDirPath) {
            return this.resolve("").toURI();
        }
        return FilePath.toUri(this.file);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String getScheme() {
        return this.isAbsolute() ? "file" : null;
    }

    @Override
    public Path resolve(String string) {
        if (Path.uriSchemeSpecified(string)) {
            return URLPath.valueOf(string);
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return FilePath.valueOf(file);
        }
        char c = File.separatorChar;
        if (c != '/') {
            string = string.replace('/', c);
        }
        File file2 = this == Path.userDirPath ? new File(System.getProperty("user.dir"), string) : new File(this.isDirectory() ? this.file : this.file.getParentFile(), string);
        return FilePath.valueOf(file2);
    }

    @Override
    public Path getCanonical() {
        try {
            File file = this.file.getCanonicalFile();
            if (!file.equals(this.file)) {
                return FilePath.valueOf(file);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }
}

