/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.kawa.swingviews.SwingContent;
import gnu.lists.CharBuffer;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.Values;
import gnu.text.Path;
import gnu.text.QueueReader;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kawa.GuiInPort;
import kawa.ReplPane;
import kawa.ReplPaneOutPort;
import kawa.Shell;
import kawa.repl;

public class ReplDocument
extends DefaultStyledDocument
implements DocumentListener,
FocusListener {
    public static StyleContext styles = new StyleContext();
    public static Style defaultStyle = styles.addStyle("default", null);
    public static Style inputStyle = styles.addStyle("input", null);
    public static Style redStyle = styles.addStyle("red", null);
    static Style blueStyle = styles.addStyle("blue", null);
    static Style promptStyle = styles.addStyle("prompt", null);
    JTextPane pane;
    int paneCount;
    SwingContent content;
    final QueueReader in_r;
    final GuiInPort in_p;
    final ReplPaneOutPort out_stream;
    final ReplPaneOutPort err_stream;
    Language language;
    Environment environment;
    Future thread;
    public int outputMark = 0;
    public int endMark = -1;
    int length = 0;
    Object closeListeners;

    public ReplDocument(Language language, Environment environment, boolean bl) {
        this(new SwingContent(), language, environment, bl);
    }

    private ReplDocument(SwingContent swingContent, Language language, Environment environment, boolean bl) {
        super((AbstractDocument.Content)swingContent, styles);
        this.content = swingContent;
        repl.exitIncrement();
        this.addDocumentListener(this);
        this.language = language;
        this.in_r = new QueueReader(){

            public void checkAvailable() {
                ReplDocument.this.checkingPendingInput();
            }
        };
        this.out_stream = new ReplPaneOutPort(this, "/dev/stdout", defaultStyle);
        this.err_stream = new ReplPaneOutPort(this, "/dev/stderr", redStyle);
        this.in_p = new GuiInPort(this.in_r, Path.valueOf("/dev/stdin"), this.out_stream, this);
        this.thread = new Future(new repl(language){

            public Object apply0() {
                Shell.run(this.language, Environment.getCurrent());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ReplDocument.this.fireDocumentClosed();
                    }
                });
                return Values.empty;
            }
        }, environment, this.in_p, this.out_stream, this.err_stream);
        Environment environment2 = this.thread.getEnvironment();
        if (bl) {
            environment2.setIndirectDefines();
        }
        this.environment = environment2;
        this.thread.start();
    }

    public synchronized void deleteOldText() {
        try {
            String string = this.getText(0, this.outputMark);
            int n = this.outputMark <= 0 ? 0 : string.lastIndexOf(10, this.outputMark - 1) + 1;
            this.remove(0, n);
        }
        catch (BadLocationException badLocationException) {
            throw new Error(badLocationException);
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) {
        try {
            super.insertString(n, string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            throw new Error(badLocationException);
        }
    }

    public void write(final String string, final AttributeSet attributeSet) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = ReplDocument.this.pane != null && ReplDocument.this.pane.getCaretPosition() == ReplDocument.this.outputMark;
                ReplDocument.this.insertString(ReplDocument.this.outputMark, string, attributeSet);
                int n = string.length();
                ReplDocument.this.outputMark += n;
                if (bl) {
                    ReplDocument.this.pane.setCaretPosition(ReplDocument.this.outputMark);
                }
            }
        });
    }

    public void checkingPendingInput() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n = ReplDocument.this.outputMark;
                if (n <= ReplDocument.this.endMark) {
                    CharBuffer charBuffer = ReplDocument.this.content.buffer;
                    int n2 = charBuffer.indexOf(10, n);
                    if (n2 == ReplDocument.this.endMark) {
                        ReplDocument.this.endMark = -1;
                    }
                    if (n == ReplDocument.this.outputMark) {
                        ReplDocument.this.outputMark = n2 + 1;
                    }
                    if (ReplDocument.this.in_r != null) {
                        QueueReader queueReader = ReplDocument.this.in_r;
                        synchronized (queueReader) {
                            ReplDocument.this.in_r.append(charBuffer.substring(n, n2 + 1));
                            ReplDocument.this.in_r.notifyAll();
                        }
                    }
                }
            }
        });
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object2 = focusEvent.getSource();
        this.pane = object2 instanceof ReplPane ? (ReplPane)object2 : null;
        this.pane = object2 instanceof ReplPane ? (ReplPane)object2 : null;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.pane = null;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public synchronized void textValueChanged(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = this.getLength() - this.length;
        this.length += n2;
        if (n < this.outputMark) {
            this.outputMark += n2;
        } else if (n - n2 < this.outputMark) {
            this.outputMark = n;
        }
        if (this.endMark >= 0) {
            if (n < this.endMark) {
                this.endMark += n2;
            } else if (n - n2 < this.endMark) {
                this.endMark = n;
            }
        }
    }

    void close() {
        this.in_r.appendEOF();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread.stop();
        this.fireDocumentClosed();
        repl.exitDecrement();
    }

    public void addDocumentCloseListener(DocumentCloseListener documentCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = documentCloseListener;
        } else {
            ArrayList<Object> arrayList;
            if (this.closeListeners instanceof ArrayList) {
                arrayList = (ArrayList<Object>)this.closeListeners;
            } else {
                arrayList = new ArrayList<Object>(10);
                arrayList.add(this.closeListeners);
                this.closeListeners = arrayList;
            }
            arrayList.add(documentCloseListener);
        }
    }

    public void removeDocumentCloseListener(DocumentCloseListener documentCloseListener) {
        if (this.closeListeners instanceof DocumentCloseListener) {
            if (this.closeListeners == documentCloseListener) {
                this.closeListeners = null;
            }
        } else if (this.closeListeners != null) {
            ArrayList arrayList = (ArrayList)this.closeListeners;
            int n = arrayList.size();
            while (--n >= 0) {
                if (arrayList.get(n) != documentCloseListener) continue;
                arrayList.remove(n);
            }
            if (arrayList.size() == 0) {
                this.closeListeners = null;
            }
        }
    }

    void fireDocumentClosed() {
        if (this.closeListeners instanceof DocumentCloseListener) {
            ((DocumentCloseListener)this.closeListeners).closed(this);
        } else if (this.closeListeners != null) {
            ArrayList arrayList = (ArrayList)this.closeListeners;
            int n = arrayList.size();
            while (--n >= 0) {
                ((DocumentCloseListener)arrayList.get(n)).closed(this);
            }
        }
    }

    static {
        StyleConstants.setForeground(redStyle, Color.red);
        StyleConstants.setForeground(blueStyle, Color.blue);
        StyleConstants.setForeground(promptStyle, Color.green);
        StyleConstants.setBold(inputStyle, true);
    }

    public static interface DocumentCloseListener {
        public void closed(ReplDocument var1);
    }
}

