/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.ErrorExp;
import gnu.expr.ScopeExp;
import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Procedure1;
import gnu.text.Printable;
import gnu.text.ReportFormat;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.lang.Macro;
import kawa.lang.Pattern;
import kawa.lang.PatternScope;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxPattern;
import kawa.lang.SyntaxRule;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class SyntaxRules
extends Procedure1
implements Printable,
Externalizable {
    Object[] literal_identifiers;
    SyntaxRule[] rules;
    int maxVars = 0;

    public SyntaxRules() {
    }

    public SyntaxRules(Object[] objectArray, SyntaxRule[] syntaxRuleArray, int n) {
        this.literal_identifiers = objectArray;
        this.rules = syntaxRuleArray;
        this.maxVars = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxRules(Object[] objectArray, Object object2, Translator translator) {
        int n;
        this.literal_identifiers = objectArray;
        int n2 = Translator.listLength(object2);
        if (n2 < 0) {
            n2 = 0;
            translator.syntaxError("missing or invalid syntax-rules");
        }
        this.rules = new SyntaxRule[n2];
        SyntaxForm syntaxForm = null;
        for (n = 0; n < n2; ++n) {
            while (object2 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object2;
                object2 = syntaxForm.form;
            }
            Pair pair = (Pair)object2;
            SyntaxForm syntaxForm2 = syntaxForm;
            Object object3 = pair.getCar();
            while (object3 instanceof SyntaxForm) {
                syntaxForm2 = (SyntaxForm)object3;
                object3 = syntaxForm2.form;
            }
            if (!(object3 instanceof Pair)) {
                translator.syntaxError("missing pattern in " + n + "'th syntax rule");
                return;
            }
            SyntaxForm syntaxForm3 = syntaxForm2;
            Pair pair2 = (Pair)object3;
            Object object4 = pair2.getCar();
            String string = translator.getFileName();
            int n3 = translator.getLineNumber();
            int n4 = translator.getColumnNumber();
            try {
                SyntaxForm syntaxForm4 = syntaxForm2;
                translator.setLine(pair2);
                object3 = pair2.getCdr();
                while (object3 instanceof SyntaxForm) {
                    syntaxForm4 = (SyntaxForm)object3;
                    object3 = syntaxForm4.form;
                }
                if (!(object3 instanceof Pair)) {
                    translator.syntaxError("missing template in " + n + "'th syntax rule");
                    return;
                }
                pair2 = (Pair)object3;
                if (pair2.getCdr() != LList.Empty) {
                    translator.syntaxError("junk after " + n + "'th syntax rule");
                    return;
                }
                Object object5 = pair2.getCar();
                PatternScope patternScope = PatternScope.push(translator);
                translator.push(patternScope);
                while (object4 instanceof SyntaxForm) {
                    syntaxForm3 = (SyntaxForm)object4;
                    object4 = syntaxForm3.form;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (!(object4 instanceof Pair)) {
                    translator.syntaxError("pattern does not start with name");
                    return;
                }
                objectArray[0] = ((Pair)object4).getCar();
                Externalizable externalizable = (Pair)object4;
                stringBuffer.append('\f');
                stringBuffer.append('\u0018');
                object4 = externalizable.getCdr();
                externalizable = new SyntaxPattern(stringBuffer, object4, syntaxForm3, objectArray, translator);
                this.rules[n] = new SyntaxRule((SyntaxPattern)externalizable, object5, syntaxForm4, translator);
                PatternScope.pop(translator);
                translator.pop();
            }
            finally {
                translator.setLine(string, n3, n4);
            }
            object2 = pair.getCdr();
        }
        n = this.rules.length;
        while (--n >= 0) {
            int n5 = this.rules[n].patternNesting.length();
            if (n5 <= this.maxVars) continue;
            this.maxVars = n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apply1(Object object2) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            Translator translator = (Translator)Compilation.getCurrent();
            ScopeExp scopeExp = translator.currentScope();
            translator.setCurrentScope(syntaxForm.scope);
            try {
                Object object3 = this.expand(syntaxForm, translator);
                return object3;
            }
            finally {
                translator.setCurrentScope(scopeExp);
            }
        }
        return this.expand(object2, (Translator)Compilation.getCurrent());
    }

    public Object expand(Object object2, Translator translator) {
        Object[] objectArray = new Object[this.maxVars];
        Macro macro = (Macro)translator.getCurrentSyntax();
        for (int i = 0; i < this.rules.length; ++i) {
            SyntaxRule syntaxRule = this.rules[i];
            if (syntaxRule == null) {
                return new ErrorExp("error defining " + macro);
            }
            SyntaxPattern syntaxPattern = syntaxRule.pattern;
            boolean bl = ((Pattern)syntaxPattern).match(object2, objectArray, 0);
            if (!bl) continue;
            Object object3 = syntaxRule.execute(objectArray, translator, TemplateScope.make(translator));
            return object3;
        }
        return translator.syntaxError("no matching syntax-rule for " + this.literal_identifiers[0]);
    }

    public void print(Consumer consumer) {
        consumer.write("#<macro ");
        ReportFormat.print(this.literal_identifiers[0], consumer);
        consumer.write(62);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.literal_identifiers);
        objectOutput.writeObject(this.rules);
        objectOutput.writeInt(this.maxVars);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.literal_identifiers = (Object[])objectInput.readObject();
        this.rules = (SyntaxRule[])objectInput.readObject();
        this.maxVars = objectInput.readInt();
    }
}

