/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.expr.Language;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberCompare
extends ProcedureN {
    Language language;
    static final int RESULT_GRT = 1;
    static final int RESULT_EQU = 0;
    static final int RESULT_LSS = -1;
    static final int RESULT_NAN = -2;
    static final int RESULT_NEQ = -3;
    public static final int TRUE_IF_GRT = 16;
    public static final int TRUE_IF_EQU = 8;
    public static final int TRUE_IF_LSS = 4;
    public static final int TRUE_IF_NAN = 2;
    public static final int TRUE_IF_NEQ = 1;
    int flags;

    @Override
    public int numArgs() {
        return -4094;
    }

    public static boolean $Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(8, arg1, arg2);
    }

    public static boolean $Gr(Object arg1, Object arg2) {
        return NumberCompare.apply2(16, arg1, arg2);
    }

    public static boolean $Gr$Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(24, arg1, arg2);
    }

    public static boolean $Ls(Object arg1, Object arg2) {
        return NumberCompare.apply2(4, arg1, arg2);
    }

    public static boolean $Ls$Eq(Object arg1, Object arg2) {
        return NumberCompare.apply2(12, arg1, arg2);
    }

    public static boolean $Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Eq(arg1, arg2) && NumberCompare.$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Eq(arg3, rest[0]) && NumberCompare.applyN(8, rest));
    }

    public static boolean $Gr$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Gr(arg1, arg2) && NumberCompare.$Gr(arg2, arg3) && (rest.length == 0 || NumberCompare.$Gr(arg3, rest[0]) && NumberCompare.applyN(16, rest));
    }

    public static boolean $Gr$Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Gr$Eq(arg1, arg2) && NumberCompare.$Gr$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Gr$Eq(arg3, rest[0]) && NumberCompare.applyN(24, rest));
    }

    public static boolean $Ls$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Ls(arg1, arg2) && NumberCompare.$Ls(arg2, arg3) && (rest.length == 0 || NumberCompare.$Ls(arg3, rest[0]) && NumberCompare.applyN(4, rest));
    }

    public static boolean $Ls$Eq$V(Object arg1, Object arg2, Object arg3, Object[] rest) {
        return NumberCompare.$Ls$Eq(arg1, arg2) && NumberCompare.$Ls$Eq(arg2, arg3) && (rest.length == 0 || NumberCompare.$Ls$Eq(arg3, rest[0]) && NumberCompare.applyN(12, rest));
    }

    public static NumberCompare make(Language language, String name, int flags) {
        NumberCompare proc = new NumberCompare();
        proc.language = language;
        proc.setName(name);
        proc.flags = flags;
        proc.setProperty(Procedure.validateApplyKey, "gnu.kawa.functions.CompileMisc:validateApplySimpleBoolean");
        proc.setProperty(Procedure.compilerXKey, "gnu.kawa.functions.CompileMisc:compileNumberCompare");
        return proc;
    }

    protected final Language getLanguage() {
        return this.language;
    }

    @Override
    public Object apply2(Object arg1, Object arg2) {
        return this.getLanguage().booleanObject(NumberCompare.apply2(this.flags, arg1, arg2));
    }

    public static boolean apply2(int flags, Object arg1, Object arg2) {
        return (1 << 3 + NumberCompare.compare(arg1, arg2, true) & flags) != 0;
    }

    public static boolean checkCompareCode(int code, int flags) {
        return (1 << 3 + code & flags) != 0;
    }

    public static boolean applyWithPromotion(int flags, Object arg1, Object arg2) {
        return NumberCompare.checkCompareCode(NumberCompare.compare(arg1, arg2, false), flags);
    }

    public static int compare(Object arg1, Object arg2, boolean exact) {
        int code1 = Arithmetic.classifyValue(arg1);
        int code2 = Arithmetic.classifyValue(arg2);
        return NumberCompare.compare(arg1, code1, arg2, code2, exact);
    }

    public static int compare(Object arg1, int code1, Object arg2, int code2, boolean exact) {
        int comp;
        if (code1 < 0 || code2 < 0) {
            return -3;
        }
        int code = code1 < code2 ? code2 : code1;
        switch (code) {
            case 1: {
                int i1 = Arithmetic.asInt(arg1);
                int i2 = Arithmetic.asInt(arg2);
                comp = i1 < i2 ? -1 : (i1 > i2 ? 1 : 0);
                break;
            }
            case 2: {
                long l1 = Arithmetic.asLong(arg1);
                long l2 = Arithmetic.asLong(arg2);
                comp = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
                break;
            }
            case 3: {
                BigInteger bi1 = Arithmetic.asBigInteger(arg1);
                BigInteger bi2 = Arithmetic.asBigInteger(arg2);
                comp = bi1.compareTo(bi2);
                break;
            }
            case 4: {
                comp = IntNum.compare(Arithmetic.asIntNum(arg1), Arithmetic.asIntNum(arg2));
                break;
            }
            case 5: {
                BigDecimal bd1 = Arithmetic.asBigDecimal(arg1);
                BigDecimal bd2 = Arithmetic.asBigDecimal(arg2);
                comp = bd1.compareTo(bd2);
                break;
            }
            case 6: {
                comp = RatNum.compare(Arithmetic.asRatNum(arg1), Arithmetic.asRatNum(arg2));
                break;
            }
            case 7: {
                if (!exact || code1 > 6 && code2 > 6) {
                    float f2;
                    float f1 = Arithmetic.asFloat(arg1);
                    comp = f1 > (f2 = Arithmetic.asFloat(arg2)) ? 1 : (f1 < f2 ? -1 : (f1 == f2 ? 0 : -2));
                    break;
                }
            }
            case 8: 
            case 9: {
                if (!exact || code1 > 6 && code2 > 6) {
                    double d2;
                    double d1 = Arithmetic.asDouble(arg1);
                    comp = d1 > (d2 = Arithmetic.asDouble(arg2)) ? 1 : (d1 < d2 ? -1 : (d1 == d2 ? 0 : -2));
                    break;
                }
            }
            default: {
                Numeric num1 = Arithmetic.asNumeric(arg1);
                Numeric num2 = Arithmetic.asNumeric(arg2);
                comp = num1.compare(num2);
            }
        }
        return comp;
    }

    static boolean applyN(int flags, Object[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            Object arg1 = args[i];
            Object arg2 = args[i + 1];
            if (NumberCompare.apply2(flags, arg1, arg2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object applyN(Object[] args) {
        return this.getLanguage().booleanObject(NumberCompare.applyN(this.flags, args));
    }
}

