/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.LazyType;
import gnu.mapping.Lazy;
import gnu.mapping.Promise;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Arithmetic {
    public static final int INT_CODE = 1;
    public static final int LONG_CODE = 2;
    public static final int BIGINTEGER_CODE = 3;
    public static final int INTNUM_CODE = 4;
    public static final int BIGDECIMAL_CODE = 5;
    public static final int RATNUM_CODE = 6;
    public static final int FLOAT_CODE = 7;
    public static final int DOUBLE_CODE = 8;
    public static final int FLONUM_CODE = 9;
    public static final int REALNUM_CODE = 10;
    public static final int NUMERIC_CODE = 11;
    static LangObjType typeDFloNum = LangObjType.dflonumType;
    static LangObjType typeRatNum = LangObjType.rationalType;
    static LangObjType typeRealNum = LangObjType.realType;
    static ClassType typeNumber = ClassType.make("java.lang.Number");
    static LangObjType typeIntNum = LangObjType.integerType;

    public static int classifyValue(Object value) {
        while (true) {
            Object v;
            if (value instanceof Numeric) {
                if (value instanceof IntNum) {
                    return 4;
                }
                if (value instanceof RatNum) {
                    return 6;
                }
                if (value instanceof DFloNum) {
                    return 9;
                }
                if (value instanceof RealNum) {
                    return 10;
                }
                return 11;
            }
            if (value instanceof Number) {
                if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    return 1;
                }
                if (value instanceof Long) {
                    return 2;
                }
                if (value instanceof Float) {
                    return 7;
                }
                if (value instanceof Double) {
                    return 8;
                }
                if (value instanceof BigInteger) {
                    return 3;
                }
                if (!(value instanceof BigDecimal)) break;
                return 5;
            }
            if (!(value instanceof Lazy) || (v = ((Lazy)value).getValue()) == value) break;
            value = v;
        }
        return -1;
    }

    public static Type kindType(int kind) {
        switch (kind) {
            case 1: {
                return LangPrimType.intType;
            }
            case 2: {
                return LangPrimType.longType;
            }
            case 3: {
                return ClassType.make("java.math.BigInteger");
            }
            case 4: {
                return typeIntNum;
            }
            case 5: {
                return ClassType.make("java.math.BigDecimal");
            }
            case 6: {
                return typeRatNum;
            }
            case 7: {
                return LangPrimType.floatType;
            }
            case 8: {
                return LangPrimType.doubleType;
            }
            case 9: {
                return typeDFloNum;
            }
            case 10: {
                return typeRealNum;
            }
            case 11: {
                return LangObjType.numericType;
            }
        }
        return Type.pointer_type;
    }

    public static int classifyType(Type type) {
        boolean kind = false;
        if (type instanceof PrimType) {
            char sig = type.getSignature().charAt(0);
            if (sig == 'V' || sig == 'Z' || sig == 'C') {
                return 0;
            }
            if (sig == 'D') {
                return 8;
            }
            if (sig == 'F') {
                return 7;
            }
            if (sig == 'J') {
                return 2;
            }
            return 1;
        }
        String tname = type.getName();
        if (type.isSubtype(typeIntNum)) {
            return 4;
        }
        if (type.isSubtype(typeRatNum)) {
            return 6;
        }
        if (type.isSubtype(typeDFloNum)) {
            return 9;
        }
        if ("java.lang.Double".equals(tname)) {
            return 8;
        }
        if ("java.lang.Float".equals(tname)) {
            return 7;
        }
        if ("java.lang.Long".equals(tname)) {
            return 2;
        }
        if ("java.lang.Integer".equals(tname) || "java.lang.Short".equals(tname) || "java.lang.Byte".equals(tname)) {
            return 1;
        }
        if ("java.math.BigInteger".equals(tname)) {
            return 3;
        }
        if ("java.math.BigDecimal".equals(tname)) {
            return 5;
        }
        if (type.isSubtype(typeRealNum)) {
            return 10;
        }
        if (type.isSubtype(LangObjType.numericType)) {
            return 11;
        }
        if (type instanceof LazyType) {
            return Arithmetic.classifyType(((LazyType)type).getValueType());
        }
        return 0;
    }

    public static int asInt(Object value) {
        return ((Number)Promise.force(value)).intValue();
    }

    public static long asLong(Object value) {
        return ((Number)Promise.force(value)).longValue();
    }

    public static float asFloat(Object value) {
        return ((Number)Promise.force(value)).floatValue();
    }

    public static double asDouble(Object value) {
        return ((Number)Promise.force(value)).doubleValue();
    }

    public static BigInteger asBigInteger(Object value) {
        if ((value = Promise.force(value)) instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof IntNum) {
            return new BigInteger(value.toString());
        }
        return BigInteger.valueOf(((Number)value).longValue());
    }

    public static IntNum asIntNum(BigDecimal value) {
        return IntNum.valueOf(value.toBigInteger().toString(), 10);
    }

    public static IntNum asIntNum(BigInteger value) {
        return IntNum.valueOf(value.toString(), 10);
    }

    public static IntNum asIntNum(Object value) {
        if ((value = Promise.force(value)) instanceof IntNum) {
            return (IntNum)value;
        }
        if (value instanceof BigInteger) {
            return IntNum.valueOf(value.toString(), 10);
        }
        if (value instanceof BigDecimal) {
            return Arithmetic.asIntNum((BigDecimal)value);
        }
        return IntNum.make(((Number)value).longValue());
    }

    public static BigDecimal asBigDecimal(Object value) {
        if ((value = Promise.force(value)) instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        return new BigDecimal(value.toString());
    }

    public static RatNum asRatNum(Object value) {
        if ((value = Promise.force(value)) instanceof RatNum) {
            return (RatNum)value;
        }
        if (value instanceof BigInteger) {
            return IntNum.valueOf(value.toString(), 10);
        }
        if (value instanceof BigDecimal) {
            return RatNum.valueOf((BigDecimal)value);
        }
        return IntNum.make(((Number)value).longValue());
    }

    public static Numeric asNumeric(Object value) {
        Numeric n = Numeric.asNumericOrNull(value = Promise.force(value));
        return n != null ? n : (Numeric)value;
    }

    public static String toString(Object number, int radix) {
        int code = Arithmetic.classifyValue(number);
        switch (code) {
            case 1: {
                return Integer.toString(Arithmetic.asInt(number), radix);
            }
            case 2: {
                return Long.toString(Arithmetic.asLong(number), radix);
            }
            case 3: {
                return Arithmetic.asBigInteger(number).toString(radix);
            }
            case 4: {
                return Arithmetic.asIntNum(number).toString(radix);
            }
            case 5: {
                if (radix == 10) {
                    return Arithmetic.asBigDecimal(number).toString();
                }
            }
            case 7: {
                if (radix == 10) {
                    return Float.toString(Arithmetic.asFloat(number));
                }
            }
            case 8: 
            case 9: {
                if (radix != 10) break;
                return Double.toString(Arithmetic.asDouble(number));
            }
        }
        return Arithmetic.asNumeric(number).toString(radix);
    }

    public static Object convert(Object value, int code) {
        value = Promise.force(value);
        switch (code) {
            case 1: {
                if (value instanceof Integer) {
                    return value;
                }
                int i = ((Number)value).intValue();
                return i;
            }
            case 2: {
                if (value instanceof Long) {
                    return value;
                }
                long l = ((Number)value).longValue();
                return l;
            }
            case 3: {
                return Arithmetic.asBigInteger(value);
            }
            case 4: {
                return Arithmetic.asIntNum(value);
            }
            case 5: {
                return Arithmetic.asBigDecimal(value);
            }
            case 6: {
                return Arithmetic.asRatNum(value);
            }
            case 7: {
                if (value instanceof Float) {
                    return value;
                }
                float f = Arithmetic.asFloat(value);
                return Float.valueOf(f);
            }
            case 8: {
                if (value instanceof Double) {
                    return value;
                }
                double d = Arithmetic.asDouble(value);
                return d;
            }
            case 9: {
                if (value instanceof DFloNum) {
                    return value;
                }
                return DFloNum.make(Arithmetic.asDouble(value));
            }
            case 11: {
                return Arithmetic.asNumeric(value);
            }
            case 10: {
                return (RealNum)Arithmetic.asNumeric(value);
            }
        }
        return (Number)value;
    }

    public static boolean isExact(Number num) {
        if (num instanceof Numeric) {
            return ((Numeric)num).isExact();
        }
        return !(num instanceof Double) && !(num instanceof Float) && !(num instanceof BigDecimal);
    }

    public static Number toExact(Number num) {
        if (num instanceof Numeric) {
            return ((Numeric)num).toExact();
        }
        if (num instanceof Double || num instanceof Float || num instanceof BigDecimal) {
            return DFloNum.toExact(num.doubleValue());
        }
        return num;
    }

    public static Number toInexact(Number num) {
        if (num instanceof Numeric) {
            return ((Numeric)num).toInexact();
        }
        if (num instanceof Double || num instanceof Float || num instanceof BigDecimal) {
            return num;
        }
        return num.doubleValue();
    }
}

