/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

public class GraphicsState
implements Cloneable {
    public static final Color DEFAULT_BACKGROUND = Color.BLACK;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Shape DEFAULT_CLIP = null;
    public static final Composite DEFAULT_COMPOSITE = AlphaComposite.SrcOver;
    public static final Font DEFAULT_FONT = Font.decode(null);
    public static final Color DEFAULT_PAINT = DEFAULT_COLOR;
    public static final Stroke DEFAULT_STROKE = new BasicStroke();
    public static final AffineTransform DEFAULT_TRANSFORM = new AffineTransform();
    public static final Color DEFAULT_XOR_MODE = Color.BLACK;
    private RenderingHints hints = new RenderingHints(null);
    private Color background = DEFAULT_BACKGROUND;
    private Color color = DEFAULT_COLOR;
    private Shape clip = DEFAULT_CLIP;
    private Composite composite = DEFAULT_COMPOSITE;
    private Font font = DEFAULT_FONT;
    private Paint paint = DEFAULT_PAINT;
    private Stroke stroke = DEFAULT_STROKE;
    private AffineTransform transform = new AffineTransform(DEFAULT_TRANSFORM);
    private Color xorMode = DEFAULT_XOR_MODE;

    public Object clone() throws CloneNotSupportedException {
        GraphicsState clone = (GraphicsState)super.clone();
        clone.hints = (RenderingHints)this.hints.clone();
        clone.clip = GraphicsUtils.clone(this.clip);
        clone.transform = new AffineTransform(this.transform);
        return clone;
    }

    private static Shape transformShape(Shape s, AffineTransform tx) {
        boolean isRectlinearTx;
        if (s == null) {
            return null;
        }
        if (tx == null || tx.isIdentity()) {
            return GraphicsUtils.clone(s);
        }
        boolean isRectangle = s instanceof Rectangle2D;
        int nonRectlinearTxMask = 48;
        boolean bl = isRectlinearTx = (tx.getType() & nonRectlinearTxMask) == 0;
        if (isRectangle && isRectlinearTx) {
            Rectangle2D rect = (Rectangle2D)s;
            double[] corners = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
            tx.transform(corners, 0, corners, 0, 2);
            rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal(corners[0], corners[1], corners[2], corners[3]);
            return rect;
        }
        return tx.createTransformedShape(s);
    }

    private static Shape untransformShape(Shape s, AffineTransform tx) {
        if (s == null) {
            return null;
        }
        try {
            AffineTransform inverse = tx.createInverse();
            return GraphicsState.transformShape(s, inverse);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public Shape transformShape(Shape shape) {
        return GraphicsState.transformShape(shape, this.transform);
    }

    public Shape untransformShape(Shape shape) {
        return GraphicsState.untransformShape(shape, this.transform);
    }

    public RenderingHints getHints() {
        return this.hints;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Shape getClip() {
        return this.untransformShape(this.clip);
    }

    public void setClip(Shape clip) {
        this.clip = this.transformShape(clip);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public void setTransform(AffineTransform tx) {
        this.transform.setTransform(tx);
    }

    public Color getXorMode() {
        return this.xorMode;
    }

    public void setXorMode(Color xorMode) {
        this.xorMode = xorMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphicsState)) {
            return false;
        }
        GraphicsState o = (GraphicsState)obj;
        return this.hints.equals(o.hints) && this.background.equals(o.background) && this.color.equals(o.color) && this.composite.equals(o.composite) && this.font.equals(o.font) && this.paint.equals(o.paint) && this.stroke.equals(o.stroke) && this.transform.equals(o.transform) && this.xorMode.equals(o.xorMode) && (this.clip != null && o.clip != null || this.clip == o.clip) && (this.clip == null || this.clip.equals(o.clip));
    }

    public boolean isDefault() {
        return this.hints.isEmpty() && this.background.equals(DEFAULT_BACKGROUND) && this.color.equals(DEFAULT_COLOR) && this.composite.equals(DEFAULT_COMPOSITE) && this.font.equals(DEFAULT_FONT) && this.paint.equals(DEFAULT_PAINT) && this.stroke.equals(DEFAULT_STROKE) && this.transform.equals(DEFAULT_TRANSFORM) && this.xorMode.equals(DEFAULT_XOR_MODE) && this.clip == DEFAULT_CLIP;
    }
}

