/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.StableManager;
import java.io.IOException;
import java.io.Writer;

public class CharBuffer
extends FString {
    public CharBuffer(FString str) {
        super(str);
        this.indexes = new StableManager(this);
    }

    public CharBuffer(int initialSize) {
        super(initialSize);
        this.indexes = new StableManager(this);
    }

    protected CharBuffer() {
        this.indexes = new StableManager(this);
    }

    @Override
    public int length() {
        return this.size();
    }

    public char[] getArray() {
        return this.getBuffer();
    }

    @Override
    public void delete(int start, int end) {
        int ipos = this.createPos(start, false);
        this.removePos(ipos, end - start);
        this.releasePos(ipos);
    }

    @Override
    public void consume(int start, int count, Consumer dest) {
        throw new Error();
    }

    @Override
    public String toString() {
        int len = this.size();
        int start = this.getSegment(0, len);
        return new String(this.getArray(), start, len);
    }

    @Override
    public void writeTo(int start, int count, Appendable dest) throws IOException {
        if (dest instanceof Writer) {
            this.writeTo(start, count, (Writer)dest);
        } else {
            dest.append(this, start, start + count);
        }
    }

    @Override
    public void writeTo(Appendable dest) throws IOException {
        this.writeTo(0, this.size(), dest);
    }

    public void dump() {
        int i;
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        StableManager manager = (StableManager)this.indexes;
        int gapStart = manager.getGapStart();
        int gapEnd = manager.getGapEnd();
        int[] positions = manager.positions;
        int free = manager.free;
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, gapStart));
        System.err.println("\" (gapStart:" + gapStart + " gapEnd:" + gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), gapEnd, this.getArray().length - gapEnd));
        System.err.println("\"");
        int poslen = positions == null ? 0 : positions.length;
        System.err.println("Positions (size: " + poslen + " free:" + free + "):");
        boolean[] isFree = null;
        if (free != -2) {
            isFree = new boolean[positions.length];
            i = free;
            while (i >= 0) {
                isFree[i] = true;
                i = positions[i];
            }
        }
        for (i = 0; i < poslen; ++i) {
            int pos = positions[i];
            if (!(free == -2 ? pos != -2 : !isFree[i])) continue;
            int p = pos >> 1;
            if (p > gapStart) {
                p -= gapEnd - gapStart;
            }
            System.err.println("position#" + i + ": " + p + " isAfter:" + (pos & 1));
        }
    }

    @Override
    public int nextIndex(int ipos) {
        return super.nextIndex(ipos);
    }

    @Override
    public void releasePos(int ipos) {
        super.releasePos(ipos);
    }
}

