/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceMapper;
import org.xml.sax.Locator;

public interface SourceLocator
extends javax.xml.transform.SourceLocator,
Locator {
    @Override
    public int getLineNumber();

    @Override
    public int getColumnNumber();

    public int getStartLine();

    public int getStartColumn();

    public int getEndLine();

    public int getEndColumn();

    @Override
    public String getPublicId();

    @Override
    public String getSystemId();

    public String getFileName();

    public boolean isStableSourceLocation();

    public static class Simple
    implements SourceLocator {
        protected String filename;
        protected long position;

        @Override
        public String getFileName() {
            return this.filename;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.filename;
        }

        @Override
        public int getLineNumber() {
            return SourceMapper.simpleStartLine(this.position);
        }

        @Override
        public int getColumnNumber() {
            return SourceMapper.simpleStartColumn(this.position);
        }

        @Override
        public int getStartLine() {
            return SourceMapper.simpleStartLine(this.position);
        }

        @Override
        public int getStartColumn() {
            return SourceMapper.simpleStartColumn(this.position);
        }

        @Override
        public int getEndLine() {
            return SourceMapper.simpleEndLine(this.position);
        }

        @Override
        public int getEndColumn() {
            return SourceMapper.simpleEndColumn(this.position);
        }

        @Override
        public boolean isStableSourceLocation() {
            return true;
        }

        public void setFile(String filename) {
            this.filename = filename;
        }

        public void setLine(String filename, int line, int column) {
            this.setFile(filename);
            this.setLine(line, column);
        }

        public void setLine(int lineno, int colno) {
            this.position = SourceMapper.simpleEncode(lineno, colno);
        }

        public void setLine(int lineno) {
            this.setLine(lineno, 0);
        }

        public void setLocation(SourceLocator location2) {
            this.filename = location2.getFileName();
            this.position = SourceMapper.simpleEncode(location2);
        }
    }
}

