/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.javafx;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.domterm.Backend;
import org.domterm.DomHttpServer;
import org.domterm.javafx.WebTerminalApp;
import org.domterm.javafx.WebWriter;
import org.domterm.util.WTDebug;
import org.w3c.dom.Document;
import org.w3c.dom.events.EventListener;

public class WebTerminal
extends VBox
implements EventHandler,
EventListener {
    public Backend backend;
    static DomHttpServer httpServer;
    WebView webView;
    public WebEngine webEngine;
    JSObject jsWebTerminal;
    String defaultBackgroundColor = "white";
    String defaultForegroundColor = "black";
    Document documentNode;
    public static final boolean USE_XHTML = false;
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String htmlNamespace = "";
    private String initialOutput;

    public void log(String string) {
        WTDebug.println(string);
    }

    protected WebView getWebView() {
        return this.webView;
    }

    public boolean isLineEditing() {
        Object object = this.jsWebTerminal.getMember("lineEditing");
        return object != null && object instanceof Boolean && (Boolean)object != false;
    }

    public void setLineEditing(boolean bl) {
        this.jsWebTerminal.setMember("lineEditing", bl);
    }

    public void setLineEditing(char c) {
        this.jsWebTerminal.setMember("autoEditing", c == 'a');
        this.jsWebTerminal.setMember("lineEditing", c == 'l');
    }

    public String getSelectedText() {
        return this.jsWebTerminal.call("getSelectedText", new Object[0]).toString();
    }

    public void pasteText(String string) {
        this.jsWebTerminal.call("pasteText", string);
    }

    public void doCopy() {
        String string = this.getSelectedText();
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public void doPaste() {
        String string = (String)Clipboard.getSystemClipboard().getContent(DataFormat.PLAIN_TEXT);
        if (string != null) {
            this.pasteText(string);
        }
    }

    public void setWindowSize(int n, int n2, int n3, int n4) {
        if (this.backend != null) {
            this.backend.setWindowSize(n, n2, n3, n4);
        }
    }

    public void close() {
        WebTerminalApp webTerminalApp = WebTerminalApp.instance;
        if (webTerminalApp != null) {
            if (WebTerminalApp.mainClient == this.backend && WebTerminalApp.exitOnStop) {
                WebTerminalApp.instance = null;
                Platform.exit();
            }
        }
    }

    protected void enter(KeyEvent keyEvent) {
    }

    public void handle(Event event) {
    }

    @Override
    public void handleEvent(org.w3c.dom.events.Event event) {
        System.err.println("WT.handleEvent " + event);
    }

    public Document getDocumentNode() {
        return this.documentNode;
    }

    protected void loadSucceeded() {
    }

    public void setBackend(Backend backend) {
        this.backend = backend;
    }

    public WebTerminal(final Backend backend) {
        if (httpServer == null) {
            try {
                WebTerminal.startServer(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setBackend(backend);
        this.webView = new WebView();
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    WebTerminal.this.initialize();
                    if (WebTerminal.this.initialOutput != null) {
                        if (backend != null && backend.verbosity > 0) {
                            WTDebug.println("WT.changed newV:" + state2 + " initial:" + WebTerminal.this.initialOutput + " jsW:" + WebTerminal.this.jsWebTerminal + " outB:" + WebTerminal.this.jsWebTerminal.getMember("outputBefore"));
                        }
                        WebTerminal.this.jsWebTerminal.call("insertString", WebTerminal.this.initialOutput);
                        WebTerminal.this.initialOutput = null;
                    }
                    WebTerminal.this.loadSucceeded();
                }
            }
        });
        this.loadPage(this.webEngine);
        this.getChildren().add((Object)this.webView);
        VBox.setVgrow((Node)this.webView, (Priority)Priority.ALWAYS);
    }

    protected String pageUrl() {
        String string = "jfx-term.html";
        return "http://localhost:" + httpServer.getPort() + "/domterm/" + string;
    }

    protected void loadPage(WebEngine webEngine) {
        webEngine.load(this.pageUrl());
    }

    protected void initialize() {
        try {
            this.documentNode = this.webEngine.getDocument();
            Object object = this.webEngine.executeScript("makeDomTerm()");
            this.jsWebTerminal = (JSObject)object;
            this.jsWebTerminal.setMember("java", this);
            this.jsWebTerminal.setMember("jclient", this.backend);
            this.webEngine.executeScript("initDomTerm()");
            this.backend.run(new WebWriter(this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public final void processInputCharacters(String string) {
        if (this.backend != null) {
            this.backend.processInputCharacters(string);
        }
    }

    public void insertOutput(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebTerminal.this.backend != null && WebTerminal.this.backend.verbosity > 0) {
                    WTDebug.println("insertOutput/later jsW:" + WebTerminal.this.jsWebTerminal + " str:" + WTDebug.toQuoted(string));
                }
                if (WebTerminal.this.jsWebTerminal == null) {
                    WebTerminal.this.initialOutput = WebTerminal.this.initialOutput == null ? string : WebTerminal.this.initialOutput + string;
                } else {
                    WebTerminal.this.jsWebTerminal.call("insertString", string);
                }
            }
        });
    }

    public static void startServer(int n) throws IOException, UnknownHostException {
        DomHttpServer domHttpServer = new DomHttpServer(n, new String[0]);
        domHttpServer.start();
        httpServer = domHttpServer;
    }
}

