/* This is the internal header file for the RTE */

#ifndef _INTERNALNET_H
#define _INTERNALNET_H

#include "Types.h"
#include "memory.h"

#include "../../Interfaces/Threads.h"
#include "../../Interfaces/Network.h"

/* System Required Internet Interfaces */
#ifdef LINUX
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <stdarg.h>
#include <fcntl.h>
#endif /* LINUX */

#define MAX_REMOTE_RTES 255
#define MAX_LOCAL_CLIENTS 255

#define LISTEN_PORT 8000
#define SEND_PORT 8001

struct IP_Address {
  int length;
  char * address;  
};

/* These nodes refer to remote systems in the parallel system
   They map to the index of the array which is the local handle provided.
 */
struct Lookup_Table {

  struct IP_Address ip_addr;
  pid_t pid;
  Handle tid;
 
#ifdef LINUX 
  struct sockaddr_in hardware_addr;
#endif
  
};

/* The local reference is the index... */
struct Lookup_Table lookup[MAX_REMOTE_RTES];

/* Network start and stop functions */
void initialize_networking(bool);
void finialize_networking();

#endif
