/*
	Runtime Engine
		By Craig Kadziolka ( Nov 1999 - Dec 2000 )

	Modifications and copying is permitted providing this header
	is retained
*/

#include "gc.h"
#include <stdlib.h>

#define ROOTSETSIZE 2024
#define MAXOBJSIZE 8096	/* 8k objects max */
#define ALLOCATION_SPURT_SIZE 1024

int * rootset [ ROOTSETSIZE ];

/* Garbage collector calls:
	void * alloc ( size )
	garbage_collect()
	heap_return()
	int GC_GetTreadmillTotalObjects ( treadmill )
	int GC_GetTreadmillFreeObjects ( treadmill )
	int GC_GetTreadmillUsedObjects ( treadmill )
   Other calls:
	address sbrk ( modification )
	
*/	


int * obj;

int aux_get_large_objects( struct sLargeBlock * start )
{
	if (start == NULL) 
		return 0;
	else
		return (1 + get_large_objects( start -> next ));
}

int get_large_objects()
{
	return (aux_get_large_objects ( GC.large_treadmill ));
}

void test_small_allocation()
{
	int prior_objs, new_objs;
	int isobj, size;
	
	garbage_collect();
	prior_objs = GC_GetTreadmillUsedObjects ( 2 );

	printf("Testing small allocation of 100 bytes:");

	obj = (int *) alloc ( 100 );
	new_objs = GC_GetTreadmillUsedObjects ( 2 );

//	isobj = is_object( obj, size );

	if (isobj == 0) {
		printf("is object does not detect the new object\n");
	}
	
	if ( prior_objs == new_objs - 1 ) {
		printf(" Passed\n");
	} else {
		printf(" Failed\n");
	}

	printf("Testing collection with object valid:");
	
	garbage_collect();

	prior_objs = GC_GetTreadmillUsedObjects ( 2 );

	if (prior_objs == new_objs) {
		printf(" Passed\n");
	} else {
		printf(" Failed { objs before(%u), objs after(%u)\n",
				new_objs, prior_objs);
	}

}

int Main()
{
	
	printf("Testing the functionality of the garbage collector\n");
	printf("obj@(%u)\n", &obj);

	test_small_allocation();



	exit(0); /* Explicit termination */
	
}
