/*------------------------->  ANSI C - headerfile  <-------------------------*/
/* Copyright (C) 2000 by K Hopper, University of Waikato, New Zealand        */
/* This file is part of the GNU Sather library. It is free software; you may */
/* redistribute  and/or modify it under the terms of the GNU Library General */
/* Public  License (LGPL)  as published  by the  Free  Software  Foundation; */
/* either version 2 of the license, or (at your option) any later version.   */
/* This  library  is distributed  in the  hope that it will  be  useful, but */
/* WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE. See Doc/LGPL for more details.       */
/* The license text is also available from:  Free Software Foundation, Inc., */
/* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     */
/*------------>  Please email comments to <bug-sather@gnu.org>  <------------*/

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          This file contains references to those run-time facilities which
     are Operating System dependent.
     
          Version 1.0 Oct 98.  Copyright K Hopper, U of Waikato
          
                          Development History
                          -------------------

        Date           Who By         Detail
        ----           ------         ------

        16 Oct 98        kh       Original from Sather 1.2 distribution.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#include "sather.h"

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The first group of routines are provided for providing the interface
     to the operating system runtime in the Sather engine way!  They are
     implemented in the file interface.c!

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

extern void rt_start() ;
extern void rt_stop() ;

extern void rt_segfault_handler() ;

extern int rt_fatal(char *file, int line, char *msg) ;
extern int rt_fatal_2(char *file, int line, char *msg, char *str) ;
extern int rt_fatal2(char *msg) ;
extern int rt_fatal2_2(char *msg, char *str) ;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The second group of routines following have been provided (in
     filesys.c) to simplify the interface calling code.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

extern char* read_dir(EXT_OB dirp)
extern EXT_OB get_cwd()
extern EXT_OB get_std_channel(int code)
extern struct stat *file_stat(
                      char *name,
                      struct stat *tuple)

extern int feof(FILE *p)
extern int ferror(FILE *p)
extern EXT_OB error_message(void)

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          This final routine is a renaming facility for the 'times' Posix
     library routine, since that name conflicts with the sather name 'times'
     defined in the numeric classes of the required Sather library.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

extern unsigned int p_times(EXT_OB arg)
