unit ChildFrm;

{
  Inno Setup
  Copyright (C) 1998-99 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  TSetupChildForm class
}

interface

uses
  WinTypes, WinProcs, SysUtils, Messages, Classes, Graphics, Controls,
  Forms;

type
  TSetupChildForm = class(TForm)
  protected
    procedure CreateParams (var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
  public
    CantShow: Boolean;
  end;

implementation

uses
  Main;

procedure TSetupChildForm.CreateParams (var Params: TCreateParams);
begin
  inherited CreateParams (Params);
  { Ensure the form is *always* on top of MainForm by making MainForm
    the "parent" of the form. }
  Params.WndParent := MainForm.Handle;
end;

function TSetupChildForm.GetPalette: HPALETTE;
begin
  Result := MainForm.NewPalette;
end;

end.
