unit InstFnc2;

{
  Inno Setup
  Copyright (C) 1998-99 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Misc. installation functions #2
}

interface

{$I VERSION.INC}

function CreateShellLink (const Filename, Description, ShortcutTo, Parameters,
  WorkingDir, IconFilename: String; const IconIndex, ShowCmd: Integer): Boolean;
procedure RegisterTypeLibrary (const Filename: String);

implementation

uses
  WinProcs, WinTypes, SysUtils, Main, CmnFunc2,
  Msgs, MsgIDs,
  {$IFNDEF Delphi3orHigher} OLE2, {$ELSE} ActiveX, ComObj, {$ENDIF}
  ShellAPI, ShlObj;

procedure RaiseOleError (const FunctionName: String; const ResultCode: HRESULT);
begin
  raise Exception.Create(FmtSetupMessage(msgErrorFunctionFailed,
    [FunctionName, IntToHexStr8(ResultCode)]));
end;

function CreateShellLink (const Filename, Description, ShortcutTo, Parameters,
  WorkingDir, IconFilename: String; const IconIndex, ShowCmd: Integer): Boolean;
{ Creates a lnk file named Filename, with a description of Description, which
  points to ShortcutTo.
  NOTE! If you want to copy this procedure for use in your own application
  be sure to call CoInitialize at application startup and CoUninitialize at
  application shutdown. See the bottom of this unit for an example. But this
  is not necessary if you are using Delphi 3 and your project already 'uses'
  the ComObj RTL unit. }
{$IFNDEF Delphi3OrHigher}
var
  OleResult: HRESULT;
  SL: IShellLink;
  PF: IPersistFile;
  WideFilename: PWideChar;
begin
  OleResult := CoCreateInstance(CLSID_ShellLink, nil, CLSCTX_INPROC_SERVER,
     IID_IShellLink, SL);
  if OleResult <> S_OK then
    RaiseOleError ('CoCreateInstance', OleResult);
  PF := nil;
  WideFilename := nil;
  try
    SL.SetPath (PChar(ShortcutTo));
    SL.SetArguments (PChar(Parameters));
    if WorkingDir <> '' then
      SL.SetWorkingDirectory (PChar(WorkingDir));
    if IconFilename <> '' then
      SL.SetIconLocation (PChar(IconFilename), IconIndex);
    SL.SetShowCmd (ShowCmd);
    if Description <> '' then
      SL.SetDescription (PChar(Description));
    OleResult := SL.QueryInterface(IID_IPersistFile, PF);
    if OleResult <> S_OK then
      RaiseOleError ('IShellLink::QueryInterface', OleResult);
    WideFilename := StringToOleStr(Filename);
    Result := SUCCEEDED(PF.Save(WideFilename, True));
  finally
    if Assigned(WideFilename) then
      SysFreeString (WideFilename);
    if Assigned(PF) then
      PF.Release;
    SL.Release;
  end;
{$ELSE}
var
  Obj: IUnknown;
  SL: IShellLink;
  PF: IPersistFile;
  WideFilename: WideString;
begin
  Obj := CreateComObject(CLSID_ShellLink);
  SL := Obj as IShellLink;
  SL.SetPath (PChar(ShortcutTo));
  SL.SetArguments (PChar(Parameters));
  if WorkingDir <> '' then
    SL.SetWorkingDirectory (PChar(WorkingDir));
  if IconFilename <> '' then
    SL.SetIconLocation (PChar(IconFilename), IconIndex);
  SL.SetShowCmd (ShowCmd);
  if Description <> '' then
    SL.SetDescription (PChar(Description));
  PF := Obj as IPersistFile;
  WideFilename := Filename;
  Result := SUCCEEDED(PF.Save(PWideChar(WideFilename), True));
  { Delphi 3 automatically releases COM objects when they go out of scope }
{$ENDIF}
end;

procedure RegisterTypeLibrary (const Filename: String);
{$IFNDEF Delphi3OrHigher}
var
  WideFilename: PWideChar;
  OleResult: HRESULT;
  TypeLib: ITypeLib;
  DocName: PWideChar;
  DocNameStr: String;
begin
  WideFilename := StringToOleStr(ExpandFilename(Filename));
  TypeLib := nil;
  DocName := nil;
  try
    OleResult := LoadTypeLib(WideFilename, TypeLib);
    if FAILED(OleResult) then
      RaiseOleError ('LoadTypeLib', OleResult);
    OleResult := TypeLib.GetDocumentation(-1, nil, nil, nil, @DocName);
    if FAILED(OleResult) then
      RaiseOleError ('ITypeLib::GetDocumentation', OleResult);
    if Assigned(DocName) then begin
      DocNameStr := ExtractFilePath(OleStrToString(DocName));
      SysFreeString (DocName);
      DocName := nil;
      DocName := StringToOleStr(DocNameStr);
    end;
    OleResult := RegisterTypeLib(TypeLib, WideFilename, DocName);
    if FAILED(OleResult) then
      RaiseOleError ('RegisterTypeLib', OleResult);
  finally
    if Assigned(DocName) then
      SysFreeString (DocName);
    if Assigned(TypeLib) then
      TypeLib.Release;
    SysFreeString (WideFilename);
  end;
end;
{$ELSE}
var
  WideFilename: WideString;
  OleResult: HRESULT;
  TypeLib: ITypeLib;
  DocName: WideString;
begin
  WideFilename := ExpandFilename(Filename);
  OleResult := LoadTypeLib(PWideChar(WideFilename), TypeLib);
  if FAILED(OleResult) then
    RaiseOleError ('LoadTypeLib', OleResult);
  OleResult := TypeLib.GetDocumentation(-1, nil, nil, nil, @DocName);
  if FAILED(OleResult) then
    RaiseOleError ('ITypeLib::GetDocumentation', OleResult);
  if DocName <> '' then
    DocName := ExtractFilePath(DocName);
  OleResult := RegisterTypeLib(TypeLib, PWideChar(WideFilename), Pointer(DocName));
  { ^ use Pointer cast instead of PWideChar so that it passes 'nil' if DocName is empty }
  if FAILED(OleResult) then
    RaiseOleError ('RegisterTypeLib', OleResult);
end;
{$ENDIF}

procedure InitOle;
var
  OleResult: HRESULT;
begin
  OleResult := CoInitialize(nil);
  if FAILED(OleResult) then
    raise Exception.CreateFmt('CoInitialize failed (0x%.8x)', [OleResult]);
    { ^ doesn't use a SetupMessage since messages probably aren't loaded
      during 'initialization' section below, which calls this procedure }
end;

initialization
  InitOle;
finalization
  CoUninitialize;
end.
