program RegSvr;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Internally used program for registering OLE servers & type libraries
}

{$I VERSION.INC}

uses
  Windows, SysUtils,
  {$IFNDEF Delphi3orHigher} OLE2, {$ELSE} ActiveX, ComObj, {$ENDIF}
  InstFunc;

{x$R *.RES}

procedure RegisterServer (const Filename: String);
var
  LibHandle: THandle;
  RegisterServerProc: function: HRESULT; stdcall;
begin
  LibHandle := LoadLibrary(PChar(Filename));
  if LibHandle <> 0 then
    try
      @RegisterServerProc := GetProcAddress(LibHandle, 'DllRegisterServer');
      if Assigned(@RegisterServerProc) then
        RegisterServerProc;
    finally
      FreeLibrary (LibHandle);
    end;
end;

procedure RegisterTypeLibrary (const Filename: String);
{$IFNDEF Delphi3OrHigher}
var
  WideFilename: PWideChar;
  OleResult: HRESULT;
  TypeLib: ITypeLib;
  DocName: PWideChar;
  DocNameStr: String;
begin
  WideFilename := StringToOleStr(ExpandFilename(Filename));
  TypeLib := nil;
  DocName := nil;
  try
    OleResult := LoadTypeLib(WideFilename, TypeLib);
    if FAILED(OleResult) then
      Exit; //RaiseOleError ('LoadTypeLib', OleResult);
    OleResult := TypeLib.GetDocumentation(-1, nil, nil, nil, @DocName);
    if FAILED(OleResult) then
      Exit; //RaiseOleError ('ITypeLib::GetDocumentation', OleResult);
    if Assigned(DocName) then begin
      DocNameStr := ExtractFilePath(OleStrToString(DocName));
      SysFreeString (DocName);
      DocName := nil;
      DocName := StringToOleStr(DocNameStr);
    end;
    OleResult := RegisterTypeLib(TypeLib, WideFilename, DocName);
    if FAILED(OleResult) then
      Exit; //RaiseOleError ('RegisterTypeLib', OleResult);
  finally
    if Assigned(DocName) then
      SysFreeString (DocName);
    if Assigned(TypeLib) then
      TypeLib.Release;
    SysFreeString (WideFilename);
  end;
end;
{$ELSE}
var
  WideFilename: WideString;
  OleResult: HRESULT;
  TypeLib: ITypeLib;
  DocName: WideString;
begin
  WideFilename := ExpandFilename(Filename);
  OleResult := LoadTypeLib(PWideChar(WideFilename), TypeLib);
  if FAILED(OleResult) then
    Exit; //RaiseOleError ('LoadTypeLib', OleResult);
  OleResult := TypeLib.GetDocumentation(-1, nil, nil, nil, @DocName);
  if FAILED(OleResult) then
    Exit; //RaiseOleError ('ITypeLib::GetDocumentation', OleResult);
  if DocName <> '' then
    DocName := ExtractFilePath(DocName);
  OleResult := RegisterTypeLib(TypeLib, PWideChar(WideFilename), PWideChar(DocName));
  if FAILED(OleResult) then
    Exit; //RaiseOleError ('RegisterTypeLib', OleResult);
end;
{$ENDIF}

var
  F: TextFile;
  L, ListFilename, RegFilename: String;
begin
  if ParamStr(1) <> '/REG' then
    Exit;
  SetErrorMode (SEM_FAILCRITICALERRORS or SEM_NOOPENFILEERRORBOX);
  CoInitialize (nil);
  try
    ListFilename := ChangeFileExt(ParamStr(0), '.lst');
    AssignFile (F, ListFilename);
    FileMode := fmOpenRead or fmShareDenyWrite;
    Reset (F);
    try
      while not Eof(F) do begin
        Readln (F, L);
        if (Length(L) > 3) and (L[1] = '[') and (L[3] = ']') then begin
          RegFilename := Copy(L, 4, Maxint);
          case L[2] of
            's': RegisterServer (RegFilename);
            't': RegisterTypeLibrary (RegFilename);
          end;
        end;
      end;
    finally
      CloseFile (F);
    end;
    DeleteFile (ListFilename);
    try
      RestartReplace (ParamStr(0), '');
    except
      { ignore exceptions }
    end;
  finally
    CoUninitialize;
  end;
end.
