program Setup;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Setup program
}

uses
  Forms,
  WinProcs,
  WinTypes,
  SysUtils,
  CmnFunc in 'CMNFUNC.PAS',
  CmnFunc2 in 'CMNFUNC2.PAS',
  Main in 'MAIN.PAS' {MainForm},
  Wizard in 'WIZARD.PAS' {WizardForm},
  Install in 'INSTALL.PAS' {InstallForm},
  DDEInt in 'DDEINT.PAS',
  Msgs in 'MSGS.PAS',
  MsgIDs in 'MSGIDS.PAS',
  Undo in 'UNDO.PAS',
  Struct in 'STRUCT.PAS',
  SelDir in 'SELDIR.PAS' {SelDirForm},
  NewDisk in 'NEWDISK.PAS' {NewDiskForm},
  InstFunc in 'INSTFUNC.PAS',
  InstFnc2 in 'INSTFNC2.PAS';

{$R *.RES}
{$R IMAGES.RES}

{$I VERSION.INC}

procedure ShowExceptionMsg (const Msg: String);
var
  M: String;
begin
  M := Msg;
  if (M <> '') and (M[Length(M)] > '.') then M := M + '.';
  MessageBox (0, PChar(M), Pointer(SetupMessages[msgErrorTitle]),
    MB_OK or MB_ICONSTOP);
    { ^ use a Pointer cast instead of a PChar cast so that it will use "nil"
      if SetupMessages[msgErrorTitle] is empty due to the messages not being
      loaded yet. MessageBox displays 'Error' as the caption if the lpCaption
      parameter is nil. }
end;

begin
  { Leave these extra semicolons here or else Delphi gets confused and starts
    moving or deleting some of this stuff.
    NOTE: Delphi doesn't allow Application.Title to first be set as a constant.

    Don't localize the following line since it's really set in InitializeSetup }
  ;
  Application.Title := 'Setup';
  ;
  try
    InitializeSetup;
  except
    on E: Exception do begin
      if not(E is EAbort) then
        ShowExceptionMsg (E.Message);
      DeinitSetup;
      Exit;
    end;
  end;
  ;
  Application.CreateForm(TMainForm, MainForm);
  Application.Run;

  try
    DeinitSetup;
  except
    on E: Exception do begin
      if not(E is EAbort) then
        ShowExceptionMsg (E.Message);
      Exit;
    end;
  end;
end.